#!/usr/bin/perl

package eBay::API::XML::Call::FetchToken::FetchTokenRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FetchTokenRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::FetchToken::FetchTokenRequestType

=head1 DESCRIPTION

Retrieves user token.
The call can be used to get a token only after a user, at an eBay sign-in page,
gives consent for the token to be generated.
After token retrieval, the token can be used to authenticate other calls made on behalf of the user.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::FetchToken::FetchTokenRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'IncludeRESTToken', 'xs:boolean', '', '', '' ]
	, [ 'SecretID', 'xs:string', '', '', '' ]
	, [ 'SessionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setIncludeRESTToken()

Specified if you want to retrieve a REST token for a user.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeRESTToken {
  my $self = shift;
  $self->{'IncludeRESTToken'} = shift
}

=head2 isIncludeRESTToken()

#    Returns: 'xs:boolean'

=cut

sub isIncludeRESTToken {
  my $self = shift;
  return $self->{'IncludeRESTToken'};
}


=head2 setSecretID()

A value that is associated with the token retrieval request. SecretID
is defined by the application, and is passed in redirect
URL to the eBay signin page. eBay recommends using a UUID for the secret
ID value. You must also set Username (part of the RequesterCredentials)
for the particular user of interest. SecretID and Username are not
required if SessionID is present.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setSecretID {
  my $self = shift;
  $self->{'SecretID'} = shift
}

=head2 getSecretID()

#    Returns: 'xs:string'

=cut

sub getSecretID {
  my $self = shift;
  return $self->{'SecretID'};
}


=head2 setSessionID()

A value that is associated with the token retrieval request. The session ID
is generated by eBay by the application making GetSessionID call, and is passed in redirect
URL to the eBay signin page. The advantage of using SessionID is that it
does not require UserID as part of the FetchToken request. SessionID is not required
if SecretID is present.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setSessionID {
  my $self = shift;
  $self->{'SessionID'} = shift
}

=head2 getSessionID()

#    Returns: 'xs:string'

=cut

sub getSessionID {
  my $self = shift;
  return $self->{'SessionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
