#!/usr/bin/perl

package eBay::API::XML::DataType::ValType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ValType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ValType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ValType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'SuggestedValueLiteral', 'xs:string', '1', '', '' ]
	, [ 'ValueID', 'xs:int', '', '', '' ]
	, [ 'ValueLiteral', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSuggestedValueLiteral()

(out) Reserved for future use. Suggested alternative text for
ValueLiteral. Multiple SuggestedValueLiteral elements can be
returned in a Value node. Not applicable to Half.com.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setSuggestedValueLiteral {
  my $self = shift;
  $self->{'SuggestedValueLiteral'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSuggestedValueLiteral()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getSuggestedValueLiteral {
  my $self = shift;
  return $self->_getDataTypeArray('SuggestedValueLiteral');
}


=head2 setValueID()

Constant value that identifies the attribute or characteristic
in a language-independent way. Unique within the
characteristic set.<br>
<br>
In item-listing requests, if the ID is defined as -3
or -6 (Other) in GetAttributesCS or GetProductSellingPages,
use ValueLiteral to specify the string value that the
user entered. Otherwise, use ValueID to specify the ID
that is pre-defined in GetAttributesCS or GetProductSellingPages.
In item-listing requests and product searches,
the possible ID values are:<br>
-3 = User entered an arbitrary value (not an "Other" field)<br>
-6 = User entered a value in an "Other" field<br>
-100 = Value not specified (null)<br>
#### (integer) = Identifier for a pre-defined value
that the user selected (e.g., -14 or 1001)<br>
For eBay.com, required if ValueList is specified.
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrModelAttribute
Title: Attribute Elements

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         GetProductSearchResults
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: Conditionally
  Context: AttributeSetArray

  Calls: GetSearchResults
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setValueID {
  my $self = shift;
  $self->{'ValueID'} = shift
}

=head2 getValueID()

  Calls: GetCategoryListings
         GetItemRecommendations
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnCategories, ReturnAll
           GranularityLevel: Coarse


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

  Calls: GetProductFamilyMembers
         GetProductSearchResults
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getValueID {
  my $self = shift;
  return $self->{'ValueID'};
}


=head2 setValueLiteral()

The descriptive name of an attribute or characteristic value
(e.g., "New" might be a literal value for a Condition
attribute). In item-listing requests, if you send ValueID with
an id of -3 or -6, you must use ValueLiteral to enter the value the user
specified. Otherwise, eBay treats the request as if no value
was sent at all. For eBay.com listings,
use AttributeSetArray.AttributeSet.Attribute.Value.ValueLiteral.
The max length allowed varies per attribute.<br>
<br>
For GetSearchResults requests (in SearchRequest), only use ValueLiteral
for attributes that support free-text values.
That is, if eBay defines a value name and
a unique value ID for an attribute in GetProductFinder,
do not pass the name in ValueLiteral (because it won't work).
Instead, specify the unique value ID in ValueID.<br>
<br>
For Half.com, use AttributeArray.Attribute.Value.ValueLiteral
in listing requests.
That is, the parent elements and usage for Half.com differs
from eBay's standard Item Specifics format (and there is no
relationship to GetAttributesCS). For Half.com,
AttributeArray.Attribute.Value.ValueLiteral is required when
you use AddItem. See the eBay Web Services Guide for valid
values. For the Half.com Notes attribute, the max
length is 500 characters. You can revise
AttributeArray.Attribute.Value.ValueLiteral for Half.com
listings.

MaxLength: see description

  Calls: AddItem
         AddLiveAuctionItem
         GetItemRecommendations
         GetProductSearchResults
         GetSearchResults
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setValueLiteral {
  my $self = shift;
  $self->{'ValueLiteral'} = shift
}

=head2 getValueLiteral()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnCategories, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
         GetItemRecommendations
         GetProducts
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetProductFamilyMembers
         GetProductSearchResults
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getValueLiteral {
  my $self = shift;
  return $self->{'ValueLiteral'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
