// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/privacy/dlp/v2/dlp.proto

package dlp

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Operators available for comparing the value of fields.
type RelationalOperator int32

const (
	// Unused
	RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED RelationalOperator = 0
	// Equal. Attempts to match even with incompatible types.
	RelationalOperator_EQUAL_TO RelationalOperator = 1
	// Not equal to. Attempts to match even with incompatible types.
	RelationalOperator_NOT_EQUAL_TO RelationalOperator = 2
	// Greater than.
	RelationalOperator_GREATER_THAN RelationalOperator = 3
	// Less than.
	RelationalOperator_LESS_THAN RelationalOperator = 4
	// Greater than or equals.
	RelationalOperator_GREATER_THAN_OR_EQUALS RelationalOperator = 5
	// Less than or equals.
	RelationalOperator_LESS_THAN_OR_EQUALS RelationalOperator = 6
	// Exists
	RelationalOperator_EXISTS RelationalOperator = 7
)

// Enum value maps for RelationalOperator.
var (
	RelationalOperator_name = map[int32]string{
		0: "RELATIONAL_OPERATOR_UNSPECIFIED",
		1: "EQUAL_TO",
		2: "NOT_EQUAL_TO",
		3: "GREATER_THAN",
		4: "LESS_THAN",
		5: "GREATER_THAN_OR_EQUALS",
		6: "LESS_THAN_OR_EQUALS",
		7: "EXISTS",
	}
	RelationalOperator_value = map[string]int32{
		"RELATIONAL_OPERATOR_UNSPECIFIED": 0,
		"EQUAL_TO":                        1,
		"NOT_EQUAL_TO":                    2,
		"GREATER_THAN":                    3,
		"LESS_THAN":                       4,
		"GREATER_THAN_OR_EQUALS":          5,
		"LESS_THAN_OR_EQUALS":             6,
		"EXISTS":                          7,
	}
)

func (x RelationalOperator) Enum() *RelationalOperator {
	p := new(RelationalOperator)
	*p = x
	return p
}

func (x RelationalOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RelationalOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[0].Descriptor()
}

func (RelationalOperator) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[0]
}

func (x RelationalOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RelationalOperator.Descriptor instead.
func (RelationalOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{0}
}

// Type of the match which can be applied to different ways of matching, like
// Dictionary, regular expression and intersecting with findings of another
// info type.
type MatchingType int32

const (
	// Invalid.
	MatchingType_MATCHING_TYPE_UNSPECIFIED MatchingType = 0
	// Full match.
	//
	// - Dictionary: join of Dictionary results matched complete finding quote
	// - Regex: all regex matches fill a finding quote start to end
	// - Exclude info type: completely inside affecting info types findings
	MatchingType_MATCHING_TYPE_FULL_MATCH MatchingType = 1
	// Partial match.
	//
	// - Dictionary: at least one of the tokens in the finding matches
	// - Regex: substring of the finding matches
	// - Exclude info type: intersects with affecting info types findings
	MatchingType_MATCHING_TYPE_PARTIAL_MATCH MatchingType = 2
	// Inverse match.
	//
	// - Dictionary: no tokens in the finding match the dictionary
	// - Regex: finding doesn't match the regex
	// - Exclude info type: no intersection with affecting info types findings
	MatchingType_MATCHING_TYPE_INVERSE_MATCH MatchingType = 3
)

// Enum value maps for MatchingType.
var (
	MatchingType_name = map[int32]string{
		0: "MATCHING_TYPE_UNSPECIFIED",
		1: "MATCHING_TYPE_FULL_MATCH",
		2: "MATCHING_TYPE_PARTIAL_MATCH",
		3: "MATCHING_TYPE_INVERSE_MATCH",
	}
	MatchingType_value = map[string]int32{
		"MATCHING_TYPE_UNSPECIFIED":   0,
		"MATCHING_TYPE_FULL_MATCH":    1,
		"MATCHING_TYPE_PARTIAL_MATCH": 2,
		"MATCHING_TYPE_INVERSE_MATCH": 3,
	}
)

func (x MatchingType) Enum() *MatchingType {
	p := new(MatchingType)
	*p = x
	return p
}

func (x MatchingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MatchingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[1].Descriptor()
}

func (MatchingType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[1]
}

func (x MatchingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MatchingType.Descriptor instead.
func (MatchingType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{1}
}

// Options describing which parts of the provided content should be scanned.
type ContentOption int32

const (
	// Includes entire content of a file or a data stream.
	ContentOption_CONTENT_UNSPECIFIED ContentOption = 0
	// Text content within the data, excluding any metadata.
	ContentOption_CONTENT_TEXT ContentOption = 1
	// Images found in the data.
	ContentOption_CONTENT_IMAGE ContentOption = 2
)

// Enum value maps for ContentOption.
var (
	ContentOption_name = map[int32]string{
		0: "CONTENT_UNSPECIFIED",
		1: "CONTENT_TEXT",
		2: "CONTENT_IMAGE",
	}
	ContentOption_value = map[string]int32{
		"CONTENT_UNSPECIFIED": 0,
		"CONTENT_TEXT":        1,
		"CONTENT_IMAGE":       2,
	}
)

func (x ContentOption) Enum() *ContentOption {
	p := new(ContentOption)
	*p = x
	return p
}

func (x ContentOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[2].Descriptor()
}

func (ContentOption) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[2]
}

func (x ContentOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentOption.Descriptor instead.
func (ContentOption) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{2}
}

// Type of metadata containing the finding.
type MetadataType int32

const (
	// Unused
	MetadataType_METADATATYPE_UNSPECIFIED MetadataType = 0
	// General file metadata provided by Cloud Storage.
	MetadataType_STORAGE_METADATA MetadataType = 2
)

// Enum value maps for MetadataType.
var (
	MetadataType_name = map[int32]string{
		0: "METADATATYPE_UNSPECIFIED",
		2: "STORAGE_METADATA",
	}
	MetadataType_value = map[string]int32{
		"METADATATYPE_UNSPECIFIED": 0,
		"STORAGE_METADATA":         2,
	}
)

func (x MetadataType) Enum() *MetadataType {
	p := new(MetadataType)
	*p = x
	return p
}

func (x MetadataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[3].Descriptor()
}

func (MetadataType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[3]
}

func (x MetadataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataType.Descriptor instead.
func (MetadataType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{3}
}

// Parts of the APIs which use certain infoTypes.
type InfoTypeSupportedBy int32

const (
	// Unused.
	InfoTypeSupportedBy_ENUM_TYPE_UNSPECIFIED InfoTypeSupportedBy = 0
	// Supported by the inspect operations.
	InfoTypeSupportedBy_INSPECT InfoTypeSupportedBy = 1
	// Supported by the risk analysis operations.
	InfoTypeSupportedBy_RISK_ANALYSIS InfoTypeSupportedBy = 2
)

// Enum value maps for InfoTypeSupportedBy.
var (
	InfoTypeSupportedBy_name = map[int32]string{
		0: "ENUM_TYPE_UNSPECIFIED",
		1: "INSPECT",
		2: "RISK_ANALYSIS",
	}
	InfoTypeSupportedBy_value = map[string]int32{
		"ENUM_TYPE_UNSPECIFIED": 0,
		"INSPECT":               1,
		"RISK_ANALYSIS":         2,
	}
)

func (x InfoTypeSupportedBy) Enum() *InfoTypeSupportedBy {
	p := new(InfoTypeSupportedBy)
	*p = x
	return p
}

func (x InfoTypeSupportedBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoTypeSupportedBy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[4].Descriptor()
}

func (InfoTypeSupportedBy) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[4]
}

func (x InfoTypeSupportedBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoTypeSupportedBy.Descriptor instead.
func (InfoTypeSupportedBy) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4}
}

// An enum to represent the various types of DLP jobs.
type DlpJobType int32

const (
	// Unused
	DlpJobType_DLP_JOB_TYPE_UNSPECIFIED DlpJobType = 0
	// The job inspected Google Cloud for sensitive data.
	DlpJobType_INSPECT_JOB DlpJobType = 1
	// The job executed a Risk Analysis computation.
	DlpJobType_RISK_ANALYSIS_JOB DlpJobType = 2
)

// Enum value maps for DlpJobType.
var (
	DlpJobType_name = map[int32]string{
		0: "DLP_JOB_TYPE_UNSPECIFIED",
		1: "INSPECT_JOB",
		2: "RISK_ANALYSIS_JOB",
	}
	DlpJobType_value = map[string]int32{
		"DLP_JOB_TYPE_UNSPECIFIED": 0,
		"INSPECT_JOB":              1,
		"RISK_ANALYSIS_JOB":        2,
	}
)

func (x DlpJobType) Enum() *DlpJobType {
	p := new(DlpJobType)
	*p = x
	return p
}

func (x DlpJobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DlpJobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[5].Descriptor()
}

func (DlpJobType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[5]
}

func (x DlpJobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DlpJobType.Descriptor instead.
func (DlpJobType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5}
}

// State of a StoredInfoType version.
type StoredInfoTypeState int32

const (
	// Unused
	StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED StoredInfoTypeState = 0
	// StoredInfoType version is being created.
	StoredInfoTypeState_PENDING StoredInfoTypeState = 1
	// StoredInfoType version is ready for use.
	StoredInfoTypeState_READY StoredInfoTypeState = 2
	// StoredInfoType creation failed. All relevant error messages are returned in
	// the `StoredInfoTypeVersion` message.
	StoredInfoTypeState_FAILED StoredInfoTypeState = 3
	// StoredInfoType is no longer valid because artifacts stored in
	// user-controlled storage were modified. To fix an invalid StoredInfoType,
	// use the `UpdateStoredInfoType` method to create a new version.
	StoredInfoTypeState_INVALID StoredInfoTypeState = 4
)

// Enum value maps for StoredInfoTypeState.
var (
	StoredInfoTypeState_name = map[int32]string{
		0: "STORED_INFO_TYPE_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "READY",
		3: "FAILED",
		4: "INVALID",
	}
	StoredInfoTypeState_value = map[string]int32{
		"STORED_INFO_TYPE_STATE_UNSPECIFIED": 0,
		"PENDING":                            1,
		"READY":                              2,
		"FAILED":                             3,
		"INVALID":                            4,
	}
)

func (x StoredInfoTypeState) Enum() *StoredInfoTypeState {
	p := new(StoredInfoTypeState)
	*p = x
	return p
}

func (x StoredInfoTypeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoredInfoTypeState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[6].Descriptor()
}

func (StoredInfoTypeState) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[6]
}

func (x StoredInfoTypeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoredInfoTypeState.Descriptor instead.
func (StoredInfoTypeState) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{6}
}

// The type of data being sent for inspection.
type ByteContentItem_BytesType int32

const (
	// Unused
	ByteContentItem_BYTES_TYPE_UNSPECIFIED ByteContentItem_BytesType = 0
	// Any image type.
	ByteContentItem_IMAGE ByteContentItem_BytesType = 6
	// jpeg
	ByteContentItem_IMAGE_JPEG ByteContentItem_BytesType = 1
	// bmp
	ByteContentItem_IMAGE_BMP ByteContentItem_BytesType = 2
	// png
	ByteContentItem_IMAGE_PNG ByteContentItem_BytesType = 3
	// svg
	ByteContentItem_IMAGE_SVG ByteContentItem_BytesType = 4
	// plain text
	ByteContentItem_TEXT_UTF8 ByteContentItem_BytesType = 5
	// docx, docm, dotx, dotm
	ByteContentItem_WORD_DOCUMENT ByteContentItem_BytesType = 7
	// pdf
	ByteContentItem_PDF ByteContentItem_BytesType = 8
	// avro
	ByteContentItem_AVRO ByteContentItem_BytesType = 11
	// csv
	ByteContentItem_CSV ByteContentItem_BytesType = 12
	// tsv
	ByteContentItem_TSV ByteContentItem_BytesType = 13
)

// Enum value maps for ByteContentItem_BytesType.
var (
	ByteContentItem_BytesType_name = map[int32]string{
		0:  "BYTES_TYPE_UNSPECIFIED",
		6:  "IMAGE",
		1:  "IMAGE_JPEG",
		2:  "IMAGE_BMP",
		3:  "IMAGE_PNG",
		4:  "IMAGE_SVG",
		5:  "TEXT_UTF8",
		7:  "WORD_DOCUMENT",
		8:  "PDF",
		11: "AVRO",
		12: "CSV",
		13: "TSV",
	}
	ByteContentItem_BytesType_value = map[string]int32{
		"BYTES_TYPE_UNSPECIFIED": 0,
		"IMAGE":                  6,
		"IMAGE_JPEG":             1,
		"IMAGE_BMP":              2,
		"IMAGE_PNG":              3,
		"IMAGE_SVG":              4,
		"TEXT_UTF8":              5,
		"WORD_DOCUMENT":          7,
		"PDF":                    8,
		"AVRO":                   11,
		"CSV":                    12,
		"TSV":                    13,
	}
)

func (x ByteContentItem_BytesType) Enum() *ByteContentItem_BytesType {
	p := new(ByteContentItem_BytesType)
	*p = x
	return p
}

func (x ByteContentItem_BytesType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ByteContentItem_BytesType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[7].Descriptor()
}

func (ByteContentItem_BytesType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[7]
}

func (x ByteContentItem_BytesType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ByteContentItem_BytesType.Descriptor instead.
func (ByteContentItem_BytesType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5, 0}
}

// Predefined schemas for storing findings.
// Only for use with external storage.
type OutputStorageConfig_OutputSchema int32

const (
	// Unused.
	OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED OutputStorageConfig_OutputSchema = 0
	// Basic schema including only `info_type`, `quote`, `certainty`, and
	// `timestamp`.
	OutputStorageConfig_BASIC_COLUMNS OutputStorageConfig_OutputSchema = 1
	// Schema tailored to findings from scanning Google Cloud Storage.
	OutputStorageConfig_GCS_COLUMNS OutputStorageConfig_OutputSchema = 2
	// Schema tailored to findings from scanning Google Datastore.
	OutputStorageConfig_DATASTORE_COLUMNS OutputStorageConfig_OutputSchema = 3
	// Schema tailored to findings from scanning Google BigQuery.
	OutputStorageConfig_BIG_QUERY_COLUMNS OutputStorageConfig_OutputSchema = 4
	// Schema containing all columns.
	OutputStorageConfig_ALL_COLUMNS OutputStorageConfig_OutputSchema = 5
)

// Enum value maps for OutputStorageConfig_OutputSchema.
var (
	OutputStorageConfig_OutputSchema_name = map[int32]string{
		0: "OUTPUT_SCHEMA_UNSPECIFIED",
		1: "BASIC_COLUMNS",
		2: "GCS_COLUMNS",
		3: "DATASTORE_COLUMNS",
		4: "BIG_QUERY_COLUMNS",
		5: "ALL_COLUMNS",
	}
	OutputStorageConfig_OutputSchema_value = map[string]int32{
		"OUTPUT_SCHEMA_UNSPECIFIED": 0,
		"BASIC_COLUMNS":             1,
		"GCS_COLUMNS":               2,
		"DATASTORE_COLUMNS":         3,
		"BIG_QUERY_COLUMNS":         4,
		"ALL_COLUMNS":               5,
	}
)

func (x OutputStorageConfig_OutputSchema) Enum() *OutputStorageConfig_OutputSchema {
	p := new(OutputStorageConfig_OutputSchema)
	*p = x
	return p
}

func (x OutputStorageConfig_OutputSchema) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputStorageConfig_OutputSchema) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[8].Descriptor()
}

func (OutputStorageConfig_OutputSchema) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[8]
}

func (x OutputStorageConfig_OutputSchema) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputStorageConfig_OutputSchema.Descriptor instead.
func (OutputStorageConfig_OutputSchema) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{30, 0}
}

// Components that make up time.
type TimePartConfig_TimePart int32

const (
	// Unused
	TimePartConfig_TIME_PART_UNSPECIFIED TimePartConfig_TimePart = 0
	// [0-9999]
	TimePartConfig_YEAR TimePartConfig_TimePart = 1
	// [1-12]
	TimePartConfig_MONTH TimePartConfig_TimePart = 2
	// [1-31]
	TimePartConfig_DAY_OF_MONTH TimePartConfig_TimePart = 3
	// [1-7]
	TimePartConfig_DAY_OF_WEEK TimePartConfig_TimePart = 4
	// [1-53]
	TimePartConfig_WEEK_OF_YEAR TimePartConfig_TimePart = 5
	// [0-23]
	TimePartConfig_HOUR_OF_DAY TimePartConfig_TimePart = 6
)

// Enum value maps for TimePartConfig_TimePart.
var (
	TimePartConfig_TimePart_name = map[int32]string{
		0: "TIME_PART_UNSPECIFIED",
		1: "YEAR",
		2: "MONTH",
		3: "DAY_OF_MONTH",
		4: "DAY_OF_WEEK",
		5: "WEEK_OF_YEAR",
		6: "HOUR_OF_DAY",
	}
	TimePartConfig_TimePart_value = map[string]int32{
		"TIME_PART_UNSPECIFIED": 0,
		"YEAR":                  1,
		"MONTH":                 2,
		"DAY_OF_MONTH":          3,
		"DAY_OF_WEEK":           4,
		"WEEK_OF_YEAR":          5,
		"HOUR_OF_DAY":           6,
	}
)

func (x TimePartConfig_TimePart) Enum() *TimePartConfig_TimePart {
	p := new(TimePartConfig_TimePart)
	*p = x
	return p
}

func (x TimePartConfig_TimePart) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimePartConfig_TimePart) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[9].Descriptor()
}

func (TimePartConfig_TimePart) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[9]
}

func (x TimePartConfig_TimePart) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimePartConfig_TimePart.Descriptor instead.
func (TimePartConfig_TimePart) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{49, 0}
}

// Convenience enum for indication common characters to not transform.
type CharsToIgnore_CommonCharsToIgnore int32

const (
	// Unused.
	CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED CharsToIgnore_CommonCharsToIgnore = 0
	// 0-9
	CharsToIgnore_NUMERIC CharsToIgnore_CommonCharsToIgnore = 1
	// A-Z
	CharsToIgnore_ALPHA_UPPER_CASE CharsToIgnore_CommonCharsToIgnore = 2
	// a-z
	CharsToIgnore_ALPHA_LOWER_CASE CharsToIgnore_CommonCharsToIgnore = 3
	// US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
	CharsToIgnore_PUNCTUATION CharsToIgnore_CommonCharsToIgnore = 4
	// Whitespace character, one of [ \t\n\x0B\f\r]
	CharsToIgnore_WHITESPACE CharsToIgnore_CommonCharsToIgnore = 5
)

// Enum value maps for CharsToIgnore_CommonCharsToIgnore.
var (
	CharsToIgnore_CommonCharsToIgnore_name = map[int32]string{
		0: "COMMON_CHARS_TO_IGNORE_UNSPECIFIED",
		1: "NUMERIC",
		2: "ALPHA_UPPER_CASE",
		3: "ALPHA_LOWER_CASE",
		4: "PUNCTUATION",
		5: "WHITESPACE",
	}
	CharsToIgnore_CommonCharsToIgnore_value = map[string]int32{
		"COMMON_CHARS_TO_IGNORE_UNSPECIFIED": 0,
		"NUMERIC":                            1,
		"ALPHA_UPPER_CASE":                   2,
		"ALPHA_LOWER_CASE":                   3,
		"PUNCTUATION":                        4,
		"WHITESPACE":                         5,
	}
)

func (x CharsToIgnore_CommonCharsToIgnore) Enum() *CharsToIgnore_CommonCharsToIgnore {
	p := new(CharsToIgnore_CommonCharsToIgnore)
	*p = x
	return p
}

func (x CharsToIgnore_CommonCharsToIgnore) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CharsToIgnore_CommonCharsToIgnore) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[10].Descriptor()
}

func (CharsToIgnore_CommonCharsToIgnore) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[10]
}

func (x CharsToIgnore_CommonCharsToIgnore) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CharsToIgnore_CommonCharsToIgnore.Descriptor instead.
func (CharsToIgnore_CommonCharsToIgnore) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{55, 0}
}

// These are commonly used subsets of the alphabet that the FFX mode
// natively supports. In the algorithm, the alphabet is selected using
// the "radix". Therefore each corresponds to particular radix.
type CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet int32

const (
	// Unused.
	CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 0
	// `[0-9]` (radix of 10)
	CryptoReplaceFfxFpeConfig_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 1
	// `[0-9A-F]` (radix of 16)
	CryptoReplaceFfxFpeConfig_HEXADECIMAL CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 2
	// `[0-9A-Z]` (radix of 36)
	CryptoReplaceFfxFpeConfig_UPPER_CASE_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 3
	// `[0-9A-Za-z]` (radix of 62)
	CryptoReplaceFfxFpeConfig_ALPHA_NUMERIC CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = 4
)

// Enum value maps for CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet.
var (
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name = map[int32]string{
		0: "FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED",
		1: "NUMERIC",
		2: "HEXADECIMAL",
		3: "UPPER_CASE_ALPHA_NUMERIC",
		4: "ALPHA_NUMERIC",
	}
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value = map[string]int32{
		"FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED": 0,
		"NUMERIC":                                1,
		"HEXADECIMAL":                            2,
		"UPPER_CASE_ALPHA_NUMERIC":               3,
		"ALPHA_NUMERIC":                          4,
	}
)

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Enum() *CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet {
	p := new(CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet)
	*p = x
	return p
}

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[11].Descriptor()
}

func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[11]
}

func (x CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet.Descriptor instead.
func (CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{59, 0}
}

// Logical operators for conditional checks.
type RecordCondition_Expressions_LogicalOperator int32

const (
	// Unused
	RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED RecordCondition_Expressions_LogicalOperator = 0
	// Conditional AND
	RecordCondition_Expressions_AND RecordCondition_Expressions_LogicalOperator = 1
)

// Enum value maps for RecordCondition_Expressions_LogicalOperator.
var (
	RecordCondition_Expressions_LogicalOperator_name = map[int32]string{
		0: "LOGICAL_OPERATOR_UNSPECIFIED",
		1: "AND",
	}
	RecordCondition_Expressions_LogicalOperator_value = map[string]int32{
		"LOGICAL_OPERATOR_UNSPECIFIED": 0,
		"AND":                          1,
	}
)

func (x RecordCondition_Expressions_LogicalOperator) Enum() *RecordCondition_Expressions_LogicalOperator {
	p := new(RecordCondition_Expressions_LogicalOperator)
	*p = x
	return p
}

func (x RecordCondition_Expressions_LogicalOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecordCondition_Expressions_LogicalOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[12].Descriptor()
}

func (RecordCondition_Expressions_LogicalOperator) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[12]
}

func (x RecordCondition_Expressions_LogicalOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecordCondition_Expressions_LogicalOperator.Descriptor instead.
func (RecordCondition_Expressions_LogicalOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69, 2, 0}
}

// Possible outcomes of transformations.
type TransformationSummary_TransformationResultCode int32

const (
	// Unused
	TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED TransformationSummary_TransformationResultCode = 0
	// Transformation completed without an error.
	TransformationSummary_SUCCESS TransformationSummary_TransformationResultCode = 1
	// Transformation had an error.
	TransformationSummary_ERROR TransformationSummary_TransformationResultCode = 2
)

// Enum value maps for TransformationSummary_TransformationResultCode.
var (
	TransformationSummary_TransformationResultCode_name = map[int32]string{
		0: "TRANSFORMATION_RESULT_CODE_UNSPECIFIED",
		1: "SUCCESS",
		2: "ERROR",
	}
	TransformationSummary_TransformationResultCode_value = map[string]int32{
		"TRANSFORMATION_RESULT_CODE_UNSPECIFIED": 0,
		"SUCCESS":                                1,
		"ERROR":                                  2,
	}
)

func (x TransformationSummary_TransformationResultCode) Enum() *TransformationSummary_TransformationResultCode {
	p := new(TransformationSummary_TransformationResultCode)
	*p = x
	return p
}

func (x TransformationSummary_TransformationResultCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransformationSummary_TransformationResultCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[13].Descriptor()
}

func (TransformationSummary_TransformationResultCode) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[13]
}

func (x TransformationSummary_TransformationResultCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransformationSummary_TransformationResultCode.Descriptor instead.
func (TransformationSummary_TransformationResultCode) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{71, 0}
}

// Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
// will be created with this configuration. The service may automatically
// pause triggers experiencing frequent errors. To restart a job, set the
// status to HEALTHY after correcting user errors.
type JobTrigger_Status int32

const (
	// Unused.
	JobTrigger_STATUS_UNSPECIFIED JobTrigger_Status = 0
	// Trigger is healthy.
	JobTrigger_HEALTHY JobTrigger_Status = 1
	// Trigger is temporarily paused.
	JobTrigger_PAUSED JobTrigger_Status = 2
	// Trigger is cancelled and can not be resumed.
	JobTrigger_CANCELLED JobTrigger_Status = 3
)

// Enum value maps for JobTrigger_Status.
var (
	JobTrigger_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "HEALTHY",
		2: "PAUSED",
		3: "CANCELLED",
	}
	JobTrigger_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"HEALTHY":            1,
		"PAUSED":             2,
		"CANCELLED":          3,
	}
)

func (x JobTrigger_Status) Enum() *JobTrigger_Status {
	p := new(JobTrigger_Status)
	*p = x
	return p
}

func (x JobTrigger_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobTrigger_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[14].Descriptor()
}

func (JobTrigger_Status) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[14]
}

func (x JobTrigger_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobTrigger_Status.Descriptor instead.
func (JobTrigger_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{77, 0}
}

// Possible states of a job. New items may be added.
type DlpJob_JobState int32

const (
	// Unused.
	DlpJob_JOB_STATE_UNSPECIFIED DlpJob_JobState = 0
	// The job has not yet started.
	DlpJob_PENDING DlpJob_JobState = 1
	// The job is currently running. Once a job has finished it will transition
	// to FAILED or DONE.
	DlpJob_RUNNING DlpJob_JobState = 2
	// The job is no longer running.
	DlpJob_DONE DlpJob_JobState = 3
	// The job was canceled before it could complete.
	DlpJob_CANCELED DlpJob_JobState = 4
	// The job had an error and did not complete.
	DlpJob_FAILED DlpJob_JobState = 5
	// The job is currently accepting findings via hybridInspect.
	// A hybrid job in ACTIVE state may continue to have findings added to it
	// through calling of hybridInspect. After the job has finished no more
	// calls to hybridInspect may be made. ACTIVE jobs can transition to DONE.
	DlpJob_ACTIVE DlpJob_JobState = 6
)

// Enum value maps for DlpJob_JobState.
var (
	DlpJob_JobState_name = map[int32]string{
		0: "JOB_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
		4: "CANCELED",
		5: "FAILED",
		6: "ACTIVE",
	}
	DlpJob_JobState_value = map[string]int32{
		"JOB_STATE_UNSPECIFIED": 0,
		"PENDING":               1,
		"RUNNING":               2,
		"DONE":                  3,
		"CANCELED":              4,
		"FAILED":                5,
		"ACTIVE":                6,
	}
)

func (x DlpJob_JobState) Enum() *DlpJob_JobState {
	p := new(DlpJob_JobState)
	*p = x
	return p
}

func (x DlpJob_JobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DlpJob_JobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_dlp_proto_enumTypes[15].Descriptor()
}

func (DlpJob_JobState) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_dlp_proto_enumTypes[15]
}

func (x DlpJob_JobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DlpJob_JobState.Descriptor instead.
func (DlpJob_JobState) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{94, 0}
}

// List of exclude infoTypes.
type ExcludeInfoTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// InfoType list in ExclusionRule rule drops a finding when it overlaps or
	// contained within with a finding of an infoType from this list. For
	// example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"` and
	// `exclusion_rule` containing `exclude_info_types.info_types` with
	// "EMAIL_ADDRESS" the phone number findings are dropped if they overlap
	// with EMAIL_ADDRESS finding.
	// That leads to "555-222-2222@example.org" to generate only a single
	// finding, namely email address.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *ExcludeInfoTypes) Reset() {
	*x = ExcludeInfoTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExcludeInfoTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExcludeInfoTypes) ProtoMessage() {}

func (x *ExcludeInfoTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExcludeInfoTypes.ProtoReflect.Descriptor instead.
func (*ExcludeInfoTypes) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{0}
}

func (x *ExcludeInfoTypes) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// The rule that specifies conditions when findings of infoTypes specified in
// `InspectionRuleSet` are removed from results.
type ExclusionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exclusion rule types.
	//
	// Types that are assignable to Type:
	//	*ExclusionRule_Dictionary
	//	*ExclusionRule_Regex
	//	*ExclusionRule_ExcludeInfoTypes
	Type isExclusionRule_Type `protobuf_oneof:"type"`
	// How the rule is applied, see MatchingType documentation for details.
	MatchingType MatchingType `protobuf:"varint,4,opt,name=matching_type,json=matchingType,proto3,enum=google.privacy.dlp.v2.MatchingType" json:"matching_type,omitempty"`
}

func (x *ExclusionRule) Reset() {
	*x = ExclusionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExclusionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExclusionRule) ProtoMessage() {}

func (x *ExclusionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExclusionRule.ProtoReflect.Descriptor instead.
func (*ExclusionRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{1}
}

func (m *ExclusionRule) GetType() isExclusionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ExclusionRule) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := x.GetType().(*ExclusionRule_Dictionary); ok {
		return x.Dictionary
	}
	return nil
}

func (x *ExclusionRule) GetRegex() *CustomInfoType_Regex {
	if x, ok := x.GetType().(*ExclusionRule_Regex); ok {
		return x.Regex
	}
	return nil
}

func (x *ExclusionRule) GetExcludeInfoTypes() *ExcludeInfoTypes {
	if x, ok := x.GetType().(*ExclusionRule_ExcludeInfoTypes); ok {
		return x.ExcludeInfoTypes
	}
	return nil
}

func (x *ExclusionRule) GetMatchingType() MatchingType {
	if x != nil {
		return x.MatchingType
	}
	return MatchingType_MATCHING_TYPE_UNSPECIFIED
}

type isExclusionRule_Type interface {
	isExclusionRule_Type()
}

type ExclusionRule_Dictionary struct {
	// Dictionary which defines the rule.
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,1,opt,name=dictionary,proto3,oneof"`
}

type ExclusionRule_Regex struct {
	// Regular expression which defines the rule.
	Regex *CustomInfoType_Regex `protobuf:"bytes,2,opt,name=regex,proto3,oneof"`
}

type ExclusionRule_ExcludeInfoTypes struct {
	// Set of infoTypes for which findings would affect this rule.
	ExcludeInfoTypes *ExcludeInfoTypes `protobuf:"bytes,3,opt,name=exclude_info_types,json=excludeInfoTypes,proto3,oneof"`
}

func (*ExclusionRule_Dictionary) isExclusionRule_Type() {}

func (*ExclusionRule_Regex) isExclusionRule_Type() {}

func (*ExclusionRule_ExcludeInfoTypes) isExclusionRule_Type() {}

// A single inspection rule to be applied to infoTypes, specified in
// `InspectionRuleSet`.
type InspectionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Inspection rule types.
	//
	// Types that are assignable to Type:
	//	*InspectionRule_HotwordRule
	//	*InspectionRule_ExclusionRule
	Type isInspectionRule_Type `protobuf_oneof:"type"`
}

func (x *InspectionRule) Reset() {
	*x = InspectionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectionRule) ProtoMessage() {}

func (x *InspectionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectionRule.ProtoReflect.Descriptor instead.
func (*InspectionRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{2}
}

func (m *InspectionRule) GetType() isInspectionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *InspectionRule) GetHotwordRule() *CustomInfoType_DetectionRule_HotwordRule {
	if x, ok := x.GetType().(*InspectionRule_HotwordRule); ok {
		return x.HotwordRule
	}
	return nil
}

func (x *InspectionRule) GetExclusionRule() *ExclusionRule {
	if x, ok := x.GetType().(*InspectionRule_ExclusionRule); ok {
		return x.ExclusionRule
	}
	return nil
}

type isInspectionRule_Type interface {
	isInspectionRule_Type()
}

type InspectionRule_HotwordRule struct {
	// Hotword-based detection rule.
	HotwordRule *CustomInfoType_DetectionRule_HotwordRule `protobuf:"bytes,1,opt,name=hotword_rule,json=hotwordRule,proto3,oneof"`
}

type InspectionRule_ExclusionRule struct {
	// Exclusion rule.
	ExclusionRule *ExclusionRule `protobuf:"bytes,2,opt,name=exclusion_rule,json=exclusionRule,proto3,oneof"`
}

func (*InspectionRule_HotwordRule) isInspectionRule_Type() {}

func (*InspectionRule_ExclusionRule) isInspectionRule_Type() {}

// Rule set for modifying a set of infoTypes to alter behavior under certain
// circumstances, depending on the specific details of the rules within the set.
type InspectionRuleSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of infoTypes this rule set is applied to.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Set of rules to be applied to infoTypes. The rules are applied in order.
	Rules []*InspectionRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *InspectionRuleSet) Reset() {
	*x = InspectionRuleSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectionRuleSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectionRuleSet) ProtoMessage() {}

func (x *InspectionRuleSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectionRuleSet.ProtoReflect.Descriptor instead.
func (*InspectionRuleSet) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{3}
}

func (x *InspectionRuleSet) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InspectionRuleSet) GetRules() []*InspectionRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Configuration description of the scanning process.
// When used with redactContent only info_types and min_likelihood are currently
// used.
type InspectConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Restricts what info_types to look for. The values must correspond to
	// InfoType values returned by ListInfoTypes or listed at
	// https://cloud.google.com/dlp/docs/infotypes-reference.
	//
	// When no InfoTypes or CustomInfoTypes are specified in a request, the
	// system may automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// If you need precise control and predictability as to what detectors are
	// run you should specify specific InfoTypes listed in the reference,
	// otherwise a default list will be used, which may change over time.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Only returns findings equal or above this threshold. The default is
	// POSSIBLE.
	// See https://cloud.google.com/dlp/docs/likelihood to learn more.
	MinLikelihood Likelihood `protobuf:"varint,2,opt,name=min_likelihood,json=minLikelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"min_likelihood,omitempty"`
	// Configuration to control the number of findings returned.
	Limits *InspectConfig_FindingLimits `protobuf:"bytes,3,opt,name=limits,proto3" json:"limits,omitempty"`
	// When true, a contextual quote from the data that triggered a finding is
	// included in the response; see Finding.quote.
	IncludeQuote bool `protobuf:"varint,4,opt,name=include_quote,json=includeQuote,proto3" json:"include_quote,omitempty"`
	// When true, excludes type information of the findings.
	ExcludeInfoTypes bool `protobuf:"varint,5,opt,name=exclude_info_types,json=excludeInfoTypes,proto3" json:"exclude_info_types,omitempty"`
	// CustomInfoTypes provided by the user. See
	// https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
	CustomInfoTypes []*CustomInfoType `protobuf:"bytes,6,rep,name=custom_info_types,json=customInfoTypes,proto3" json:"custom_info_types,omitempty"`
	// List of options defining data content to scan.
	// If empty, text, images, and other content will be included.
	ContentOptions []ContentOption `protobuf:"varint,8,rep,packed,name=content_options,json=contentOptions,proto3,enum=google.privacy.dlp.v2.ContentOption" json:"content_options,omitempty"`
	// Set of rules to apply to the findings for this InspectConfig.
	// Exclusion rules, contained in the set are executed in the end, other
	// rules are executed in the order they are specified for each info type.
	RuleSet []*InspectionRuleSet `protobuf:"bytes,10,rep,name=rule_set,json=ruleSet,proto3" json:"rule_set,omitempty"`
}

func (x *InspectConfig) Reset() {
	*x = InspectConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig) ProtoMessage() {}

func (x *InspectConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig.ProtoReflect.Descriptor instead.
func (*InspectConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4}
}

func (x *InspectConfig) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InspectConfig) GetMinLikelihood() Likelihood {
	if x != nil {
		return x.MinLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (x *InspectConfig) GetLimits() *InspectConfig_FindingLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *InspectConfig) GetIncludeQuote() bool {
	if x != nil {
		return x.IncludeQuote
	}
	return false
}

func (x *InspectConfig) GetExcludeInfoTypes() bool {
	if x != nil {
		return x.ExcludeInfoTypes
	}
	return false
}

func (x *InspectConfig) GetCustomInfoTypes() []*CustomInfoType {
	if x != nil {
		return x.CustomInfoTypes
	}
	return nil
}

func (x *InspectConfig) GetContentOptions() []ContentOption {
	if x != nil {
		return x.ContentOptions
	}
	return nil
}

func (x *InspectConfig) GetRuleSet() []*InspectionRuleSet {
	if x != nil {
		return x.RuleSet
	}
	return nil
}

// Container for bytes to inspect or redact.
type ByteContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of data stored in the bytes string. Default will be TEXT_UTF8.
	Type ByteContentItem_BytesType `protobuf:"varint,1,opt,name=type,proto3,enum=google.privacy.dlp.v2.ByteContentItem_BytesType" json:"type,omitempty"`
	// Content data to inspect or redact.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ByteContentItem) Reset() {
	*x = ByteContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ByteContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ByteContentItem) ProtoMessage() {}

func (x *ByteContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ByteContentItem.ProtoReflect.Descriptor instead.
func (*ByteContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{5}
}

func (x *ByteContentItem) GetType() ByteContentItem_BytesType {
	if x != nil {
		return x.Type
	}
	return ByteContentItem_BYTES_TYPE_UNSPECIFIED
}

func (x *ByteContentItem) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Container structure for the content to inspect.
type ContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data of the item either in the byte array or UTF-8 string form, or table.
	//
	// Types that are assignable to DataItem:
	//	*ContentItem_Value
	//	*ContentItem_Table
	//	*ContentItem_ByteItem
	DataItem isContentItem_DataItem `protobuf_oneof:"data_item"`
}

func (x *ContentItem) Reset() {
	*x = ContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentItem) ProtoMessage() {}

func (x *ContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentItem.ProtoReflect.Descriptor instead.
func (*ContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{6}
}

func (m *ContentItem) GetDataItem() isContentItem_DataItem {
	if m != nil {
		return m.DataItem
	}
	return nil
}

func (x *ContentItem) GetValue() string {
	if x, ok := x.GetDataItem().(*ContentItem_Value); ok {
		return x.Value
	}
	return ""
}

func (x *ContentItem) GetTable() *Table {
	if x, ok := x.GetDataItem().(*ContentItem_Table); ok {
		return x.Table
	}
	return nil
}

func (x *ContentItem) GetByteItem() *ByteContentItem {
	if x, ok := x.GetDataItem().(*ContentItem_ByteItem); ok {
		return x.ByteItem
	}
	return nil
}

type isContentItem_DataItem interface {
	isContentItem_DataItem()
}

type ContentItem_Value struct {
	// String data to inspect or redact.
	Value string `protobuf:"bytes,3,opt,name=value,proto3,oneof"`
}

type ContentItem_Table struct {
	// Structured content for inspection. See
	// https://cloud.google.com/dlp/docs/inspecting-text#inspecting_a_table to
	// learn more.
	Table *Table `protobuf:"bytes,4,opt,name=table,proto3,oneof"`
}

type ContentItem_ByteItem struct {
	// Content data to inspect or redact. Replaces `type` and `data`.
	ByteItem *ByteContentItem `protobuf:"bytes,5,opt,name=byte_item,json=byteItem,proto3,oneof"`
}

func (*ContentItem_Value) isContentItem_DataItem() {}

func (*ContentItem_Table) isContentItem_DataItem() {}

func (*ContentItem_ByteItem) isContentItem_DataItem() {}

// Structured content to inspect. Up to 50,000 `Value`s per request allowed.
// See https://cloud.google.com/dlp/docs/inspecting-text#inspecting_a_table to
// learn more.
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Headers of the table.
	Headers []*FieldId `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
	// Rows of the table.
	Rows []*Table_Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{7}
}

func (x *Table) GetHeaders() []*FieldId {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *Table) GetRows() []*Table_Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// All the findings for a single scanned item.
type InspectResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of findings for an item.
	Findings []*Finding `protobuf:"bytes,1,rep,name=findings,proto3" json:"findings,omitempty"`
	// If true, then this item might have more findings than were returned,
	// and the findings returned are an arbitrary subset of all findings.
	// The findings list might be truncated because the input items were too
	// large, or because the server reached the maximum amount of resources
	// allowed for a single API call. For best results, divide the input into
	// smaller batches.
	FindingsTruncated bool `protobuf:"varint,2,opt,name=findings_truncated,json=findingsTruncated,proto3" json:"findings_truncated,omitempty"`
}

func (x *InspectResult) Reset() {
	*x = InspectResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectResult) ProtoMessage() {}

func (x *InspectResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectResult.ProtoReflect.Descriptor instead.
func (*InspectResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{8}
}

func (x *InspectResult) GetFindings() []*Finding {
	if x != nil {
		return x.Findings
	}
	return nil
}

func (x *InspectResult) GetFindingsTruncated() bool {
	if x != nil {
		return x.FindingsTruncated
	}
	return false
}

// Represents a piece of potentially sensitive content.
type Finding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name in format
	// projects/{project}/locations/{location}/findings/{finding} Populated only
	// when viewing persisted findings.
	Name string `protobuf:"bytes,14,opt,name=name,proto3" json:"name,omitempty"`
	// The content that was found. Even if the content is not textual, it
	// may be converted to a textual representation here.
	// Provided if `include_quote` is true and the finding is
	// less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
	// in length, the quote may be omitted.
	Quote string `protobuf:"bytes,1,opt,name=quote,proto3" json:"quote,omitempty"`
	// The type of content that might have been found.
	// Provided if `excluded_types` is false.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Confidence of how likely it is that the `info_type` is correct.
	Likelihood Likelihood `protobuf:"varint,3,opt,name=likelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"likelihood,omitempty"`
	// Where the content was found.
	Location *Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// Timestamp when finding was detected.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Contains data parsed from quotes. Only populated if include_quote was set
	// to true and a supported infoType was requested. Currently supported
	// infoTypes: DATE, DATE_OF_BIRTH and TIME.
	QuoteInfo *QuoteInfo `protobuf:"bytes,7,opt,name=quote_info,json=quoteInfo,proto3" json:"quote_info,omitempty"`
	// The job that stored the finding.
	ResourceName string `protobuf:"bytes,8,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Job trigger name, if applicable, for this finding.
	TriggerName string `protobuf:"bytes,9,opt,name=trigger_name,json=triggerName,proto3" json:"trigger_name,omitempty"`
	// The labels associated with this `Finding`.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// Label values must be between 0 and 63 characters long and must conform
	// to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//
	// No more than 10 labels can be associated with a given finding.
	//
	// Examples:
	// * `"environment" : "production"`
	// * `"pipeline" : "etl"`
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Time the job started that produced this finding.
	JobCreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=job_create_time,json=jobCreateTime,proto3" json:"job_create_time,omitempty"`
	// The job that stored the finding.
	JobName string `protobuf:"bytes,13,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *Finding) Reset() {
	*x = Finding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Finding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Finding) ProtoMessage() {}

func (x *Finding) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Finding.ProtoReflect.Descriptor instead.
func (*Finding) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{9}
}

func (x *Finding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Finding) GetQuote() string {
	if x != nil {
		return x.Quote
	}
	return ""
}

func (x *Finding) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *Finding) GetLikelihood() Likelihood {
	if x != nil {
		return x.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (x *Finding) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Finding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Finding) GetQuoteInfo() *QuoteInfo {
	if x != nil {
		return x.QuoteInfo
	}
	return nil
}

func (x *Finding) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Finding) GetTriggerName() string {
	if x != nil {
		return x.TriggerName
	}
	return ""
}

func (x *Finding) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Finding) GetJobCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.JobCreateTime
	}
	return nil
}

func (x *Finding) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Specifies the location of the finding.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based byte offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Note that when the content is not textual, this references
	// the UTF-8 encoded textual representation of the content.
	// Omitted if content is an image.
	ByteRange *Range `protobuf:"bytes,1,opt,name=byte_range,json=byteRange,proto3" json:"byte_range,omitempty"`
	// Unicode character offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Provided when the content is text.
	CodepointRange *Range `protobuf:"bytes,2,opt,name=codepoint_range,json=codepointRange,proto3" json:"codepoint_range,omitempty"`
	// List of nested objects pointing to the precise location of the finding
	// within the file or record.
	ContentLocations []*ContentLocation `protobuf:"bytes,7,rep,name=content_locations,json=contentLocations,proto3" json:"content_locations,omitempty"`
	// Information about the container where this finding occurred, if available.
	Container *Container `protobuf:"bytes,8,opt,name=container,proto3" json:"container,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{10}
}

func (x *Location) GetByteRange() *Range {
	if x != nil {
		return x.ByteRange
	}
	return nil
}

func (x *Location) GetCodepointRange() *Range {
	if x != nil {
		return x.CodepointRange
	}
	return nil
}

func (x *Location) GetContentLocations() []*ContentLocation {
	if x != nil {
		return x.ContentLocations
	}
	return nil
}

func (x *Location) GetContainer() *Container {
	if x != nil {
		return x.Container
	}
	return nil
}

// Precise location of the finding within a document, record, image, or metadata
// container.
type ContentLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the container where the finding is located.
	// The top level name is the source file name or table name. Names of some
	// common storage containers are formatted as follows:
	//
	// * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
	// * Cloud Storage files: `gs://{bucket}/{path}`
	// * Datastore namespace: {namespace}
	//
	// Nested names could be absent if the embedded object has no string
	// identifier (for an example an image contained within a document).
	ContainerName string `protobuf:"bytes,1,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	// Type of the container within the file with location of the finding.
	//
	// Types that are assignable to Location:
	//	*ContentLocation_RecordLocation
	//	*ContentLocation_ImageLocation
	//	*ContentLocation_DocumentLocation
	//	*ContentLocation_MetadataLocation
	Location isContentLocation_Location `protobuf_oneof:"location"`
	// Findings container modification timestamp, if applicable.
	// For Google Cloud Storage contains last file modification timestamp.
	// For BigQuery table contains last_modified_time property.
	// For Datastore - not populated.
	ContainerTimestamp *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=container_timestamp,json=containerTimestamp,proto3" json:"container_timestamp,omitempty"`
	// Findings container version, if available
	// ("generation" for Google Cloud Storage).
	ContainerVersion string `protobuf:"bytes,7,opt,name=container_version,json=containerVersion,proto3" json:"container_version,omitempty"`
}

func (x *ContentLocation) Reset() {
	*x = ContentLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentLocation) ProtoMessage() {}

func (x *ContentLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentLocation.ProtoReflect.Descriptor instead.
func (*ContentLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{11}
}

func (x *ContentLocation) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (m *ContentLocation) GetLocation() isContentLocation_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *ContentLocation) GetRecordLocation() *RecordLocation {
	if x, ok := x.GetLocation().(*ContentLocation_RecordLocation); ok {
		return x.RecordLocation
	}
	return nil
}

func (x *ContentLocation) GetImageLocation() *ImageLocation {
	if x, ok := x.GetLocation().(*ContentLocation_ImageLocation); ok {
		return x.ImageLocation
	}
	return nil
}

func (x *ContentLocation) GetDocumentLocation() *DocumentLocation {
	if x, ok := x.GetLocation().(*ContentLocation_DocumentLocation); ok {
		return x.DocumentLocation
	}
	return nil
}

func (x *ContentLocation) GetMetadataLocation() *MetadataLocation {
	if x, ok := x.GetLocation().(*ContentLocation_MetadataLocation); ok {
		return x.MetadataLocation
	}
	return nil
}

func (x *ContentLocation) GetContainerTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.ContainerTimestamp
	}
	return nil
}

func (x *ContentLocation) GetContainerVersion() string {
	if x != nil {
		return x.ContainerVersion
	}
	return ""
}

type isContentLocation_Location interface {
	isContentLocation_Location()
}

type ContentLocation_RecordLocation struct {
	// Location within a row or record of a database table.
	RecordLocation *RecordLocation `protobuf:"bytes,2,opt,name=record_location,json=recordLocation,proto3,oneof"`
}

type ContentLocation_ImageLocation struct {
	// Location within an image's pixels.
	ImageLocation *ImageLocation `protobuf:"bytes,3,opt,name=image_location,json=imageLocation,proto3,oneof"`
}

type ContentLocation_DocumentLocation struct {
	// Location data for document files.
	DocumentLocation *DocumentLocation `protobuf:"bytes,5,opt,name=document_location,json=documentLocation,proto3,oneof"`
}

type ContentLocation_MetadataLocation struct {
	// Location within the metadata for inspected content.
	MetadataLocation *MetadataLocation `protobuf:"bytes,8,opt,name=metadata_location,json=metadataLocation,proto3,oneof"`
}

func (*ContentLocation_RecordLocation) isContentLocation_Location() {}

func (*ContentLocation_ImageLocation) isContentLocation_Location() {}

func (*ContentLocation_DocumentLocation) isContentLocation_Location() {}

func (*ContentLocation_MetadataLocation) isContentLocation_Location() {}

// Metadata Location
type MetadataLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of metadata containing the finding.
	Type MetadataType `protobuf:"varint,1,opt,name=type,proto3,enum=google.privacy.dlp.v2.MetadataType" json:"type,omitempty"`
	// Label of the piece of metadata containing the finding, for example -
	// latitude, author, caption.
	//
	// Types that are assignable to Label:
	//	*MetadataLocation_StorageLabel
	Label isMetadataLocation_Label `protobuf_oneof:"label"`
}

func (x *MetadataLocation) Reset() {
	*x = MetadataLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataLocation) ProtoMessage() {}

func (x *MetadataLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataLocation.ProtoReflect.Descriptor instead.
func (*MetadataLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{12}
}

func (x *MetadataLocation) GetType() MetadataType {
	if x != nil {
		return x.Type
	}
	return MetadataType_METADATATYPE_UNSPECIFIED
}

func (m *MetadataLocation) GetLabel() isMetadataLocation_Label {
	if m != nil {
		return m.Label
	}
	return nil
}

func (x *MetadataLocation) GetStorageLabel() *StorageMetadataLabel {
	if x, ok := x.GetLabel().(*MetadataLocation_StorageLabel); ok {
		return x.StorageLabel
	}
	return nil
}

type isMetadataLocation_Label interface {
	isMetadataLocation_Label()
}

type MetadataLocation_StorageLabel struct {
	// Storage metadata.
	StorageLabel *StorageMetadataLabel `protobuf:"bytes,3,opt,name=storage_label,json=storageLabel,proto3,oneof"`
}

func (*MetadataLocation_StorageLabel) isMetadataLocation_Label() {}

// Storage metadata label to indicate which metadata entry contains findings.
type StorageMetadataLabel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *StorageMetadataLabel) Reset() {
	*x = StorageMetadataLabel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageMetadataLabel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageMetadataLabel) ProtoMessage() {}

func (x *StorageMetadataLabel) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageMetadataLabel.ProtoReflect.Descriptor instead.
func (*StorageMetadataLabel) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{13}
}

func (x *StorageMetadataLabel) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Location of a finding within a document.
type DocumentLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Offset of the line, from the beginning of the file, where the finding
	// is located.
	FileOffset int64 `protobuf:"varint,1,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
}

func (x *DocumentLocation) Reset() {
	*x = DocumentLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentLocation) ProtoMessage() {}

func (x *DocumentLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentLocation.ProtoReflect.Descriptor instead.
func (*DocumentLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{14}
}

func (x *DocumentLocation) GetFileOffset() int64 {
	if x != nil {
		return x.FileOffset
	}
	return 0
}

// Location of a finding within a row or record.
type RecordLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the finding.
	RecordKey *RecordKey `protobuf:"bytes,1,opt,name=record_key,json=recordKey,proto3" json:"record_key,omitempty"`
	// Field id of the field containing the finding.
	FieldId *FieldId `protobuf:"bytes,2,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Location within a `ContentItem.Table`.
	TableLocation *TableLocation `protobuf:"bytes,3,opt,name=table_location,json=tableLocation,proto3" json:"table_location,omitempty"`
}

func (x *RecordLocation) Reset() {
	*x = RecordLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordLocation) ProtoMessage() {}

func (x *RecordLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordLocation.ProtoReflect.Descriptor instead.
func (*RecordLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{15}
}

func (x *RecordLocation) GetRecordKey() *RecordKey {
	if x != nil {
		return x.RecordKey
	}
	return nil
}

func (x *RecordLocation) GetFieldId() *FieldId {
	if x != nil {
		return x.FieldId
	}
	return nil
}

func (x *RecordLocation) GetTableLocation() *TableLocation {
	if x != nil {
		return x.TableLocation
	}
	return nil
}

// Location of a finding within a table.
type TableLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The zero-based index of the row where the finding is located. Only
	// populated for resources that have a natural ordering, not BigQuery. In
	// BigQuery, to identify the row a finding came from, populate
	// BigQueryOptions.identifying_fields with your primary key column names and
	// when you store the findings the value of those columns will be stored
	// inside of Finding.
	RowIndex int64 `protobuf:"varint,1,opt,name=row_index,json=rowIndex,proto3" json:"row_index,omitempty"`
}

func (x *TableLocation) Reset() {
	*x = TableLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableLocation) ProtoMessage() {}

func (x *TableLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableLocation.ProtoReflect.Descriptor instead.
func (*TableLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{16}
}

func (x *TableLocation) GetRowIndex() int64 {
	if x != nil {
		return x.RowIndex
	}
	return 0
}

// Represents a container that may contain DLP findings.
// Examples of a container include a file, table, or database record.
type Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container type, for example BigQuery or Google Cloud Storage.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Project where the finding was found.
	// Can be different from the project that owns the finding.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A string representation of the full container name.
	// Examples:
	// - BigQuery: 'Project:DataSetId.TableId'
	// - Google Cloud Storage: 'gs://Bucket/folders/filename.txt'
	FullPath string `protobuf:"bytes,3,opt,name=full_path,json=fullPath,proto3" json:"full_path,omitempty"`
	// The root of the container.
	// Examples:
	// - For BigQuery table `project_id:dataset_id.table_id`, the root is
	//  `dataset_id`
	// - For Google Cloud Storage file `gs://bucket/folder/filename.txt`, the root
	//  is `gs://bucket`
	RootPath string `protobuf:"bytes,4,opt,name=root_path,json=rootPath,proto3" json:"root_path,omitempty"`
	// The rest of the path after the root.
	// Examples:
	// - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
	//  `table_id`
	// - Google Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
	//  path is `folder/filename.txt`
	RelativePath string `protobuf:"bytes,5,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// Findings container modification timestamp, if applicable.
	// For Google Cloud Storage contains last file modification timestamp.
	// For BigQuery table contains last_modified_time property.
	// For Datastore - not populated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Findings container version, if available
	// ("generation" for Google Cloud Storage).
	Version string `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Container) Reset() {
	*x = Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Container) ProtoMessage() {}

func (x *Container) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Container.ProtoReflect.Descriptor instead.
func (*Container) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{17}
}

func (x *Container) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Container) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Container) GetFullPath() string {
	if x != nil {
		return x.FullPath
	}
	return ""
}

func (x *Container) GetRootPath() string {
	if x != nil {
		return x.RootPath
	}
	return ""
}

func (x *Container) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *Container) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Container) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Generic half-open interval [start, end)
type Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the first character of the range (inclusive).
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// Index of the last character of the range (exclusive).
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Range) Reset() {
	*x = Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{18}
}

func (x *Range) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Range) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

// Location of the finding within an image.
type ImageLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bounding boxes locating the pixels within the image containing the finding.
	BoundingBoxes []*BoundingBox `protobuf:"bytes,1,rep,name=bounding_boxes,json=boundingBoxes,proto3" json:"bounding_boxes,omitempty"`
}

func (x *ImageLocation) Reset() {
	*x = ImageLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageLocation) ProtoMessage() {}

func (x *ImageLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageLocation.ProtoReflect.Descriptor instead.
func (*ImageLocation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{19}
}

func (x *ImageLocation) GetBoundingBoxes() []*BoundingBox {
	if x != nil {
		return x.BoundingBoxes
	}
	return nil
}

// Bounding box encompassing detected text within an image.
type BoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Top coordinate of the bounding box. (0,0) is upper left.
	Top int32 `protobuf:"varint,1,opt,name=top,proto3" json:"top,omitempty"`
	// Left coordinate of the bounding box. (0,0) is upper left.
	Left int32 `protobuf:"varint,2,opt,name=left,proto3" json:"left,omitempty"`
	// Width of the bounding box in pixels.
	Width int32 `protobuf:"varint,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the bounding box in pixels.
	Height int32 `protobuf:"varint,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *BoundingBox) Reset() {
	*x = BoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingBox) ProtoMessage() {}

func (x *BoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingBox.ProtoReflect.Descriptor instead.
func (*BoundingBox) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{20}
}

func (x *BoundingBox) GetTop() int32 {
	if x != nil {
		return x.Top
	}
	return 0
}

func (x *BoundingBox) GetLeft() int32 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *BoundingBox) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *BoundingBox) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// Request to search for potentially sensitive info in an image and redact it
// by covering it with a colored rectangle.
type RedactImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,8,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The configuration for specifying what content to redact from images.
	ImageRedactionConfigs []*RedactImageRequest_ImageRedactionConfig `protobuf:"bytes,5,rep,name=image_redaction_configs,json=imageRedactionConfigs,proto3" json:"image_redaction_configs,omitempty"`
	// Whether the response should include findings along with the redacted
	// image.
	IncludeFindings bool `protobuf:"varint,6,opt,name=include_findings,json=includeFindings,proto3" json:"include_findings,omitempty"`
	// The content must be PNG, JPEG, SVG or BMP.
	ByteItem *ByteContentItem `protobuf:"bytes,7,opt,name=byte_item,json=byteItem,proto3" json:"byte_item,omitempty"`
}

func (x *RedactImageRequest) Reset() {
	*x = RedactImageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageRequest) ProtoMessage() {}

func (x *RedactImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageRequest.ProtoReflect.Descriptor instead.
func (*RedactImageRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{21}
}

func (x *RedactImageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RedactImageRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

func (x *RedactImageRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *RedactImageRequest) GetImageRedactionConfigs() []*RedactImageRequest_ImageRedactionConfig {
	if x != nil {
		return x.ImageRedactionConfigs
	}
	return nil
}

func (x *RedactImageRequest) GetIncludeFindings() bool {
	if x != nil {
		return x.IncludeFindings
	}
	return false
}

func (x *RedactImageRequest) GetByteItem() *ByteContentItem {
	if x != nil {
		return x.ByteItem
	}
	return nil
}

// Represents a color in the RGB color space.
type Color struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of red in the color as a value in the interval [0, 1].
	Red float32 `protobuf:"fixed32,1,opt,name=red,proto3" json:"red,omitempty"`
	// The amount of green in the color as a value in the interval [0, 1].
	Green float32 `protobuf:"fixed32,2,opt,name=green,proto3" json:"green,omitempty"`
	// The amount of blue in the color as a value in the interval [0, 1].
	Blue float32 `protobuf:"fixed32,3,opt,name=blue,proto3" json:"blue,omitempty"`
}

func (x *Color) Reset() {
	*x = Color{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Color) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Color) ProtoMessage() {}

func (x *Color) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Color.ProtoReflect.Descriptor instead.
func (*Color) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{22}
}

func (x *Color) GetRed() float32 {
	if x != nil {
		return x.Red
	}
	return 0
}

func (x *Color) GetGreen() float32 {
	if x != nil {
		return x.Green
	}
	return 0
}

func (x *Color) GetBlue() float32 {
	if x != nil {
		return x.Blue
	}
	return 0
}

// Results of redacting an image.
type RedactImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The redacted image. The type will be the same as the original image.
	RedactedImage []byte `protobuf:"bytes,1,opt,name=redacted_image,json=redactedImage,proto3" json:"redacted_image,omitempty"`
	// If an image was being inspected and the InspectConfig's include_quote was
	// set to true, then this field will include all text, if any, that was found
	// in the image.
	ExtractedText string `protobuf:"bytes,2,opt,name=extracted_text,json=extractedText,proto3" json:"extracted_text,omitempty"`
	// The findings. Populated when include_findings in the request is true.
	InspectResult *InspectResult `protobuf:"bytes,3,opt,name=inspect_result,json=inspectResult,proto3" json:"inspect_result,omitempty"`
}

func (x *RedactImageResponse) Reset() {
	*x = RedactImageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageResponse) ProtoMessage() {}

func (x *RedactImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageResponse.ProtoReflect.Descriptor instead.
func (*RedactImageResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{23}
}

func (x *RedactImageResponse) GetRedactedImage() []byte {
	if x != nil {
		return x.RedactedImage
	}
	return nil
}

func (x *RedactImageResponse) GetExtractedText() string {
	if x != nil {
		return x.ExtractedText
	}
	return ""
}

func (x *RedactImageResponse) GetInspectResult() *InspectResult {
	if x != nil {
		return x.InspectResult
	}
	return nil
}

// Request to de-identify a list of items.
type DeidentifyContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the de-identification of the content item.
	// Items specified here will override the template referenced by the
	// deidentify_template_name argument.
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=deidentify_config,json=deidentifyConfig,proto3" json:"deidentify_config,omitempty"`
	// Configuration for the inspector.
	// Items specified here will override the template referenced by the
	// inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to de-identify. Will be treated as text.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Template to use. Any configuration directly specified in
	// deidentify_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	DeidentifyTemplateName string `protobuf:"bytes,6,opt,name=deidentify_template_name,json=deidentifyTemplateName,proto3" json:"deidentify_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *DeidentifyContentRequest) Reset() {
	*x = DeidentifyContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyContentRequest) ProtoMessage() {}

func (x *DeidentifyContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyContentRequest.ProtoReflect.Descriptor instead.
func (*DeidentifyContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{24}
}

func (x *DeidentifyContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *DeidentifyContentRequest) GetDeidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.DeidentifyConfig
	}
	return nil
}

func (x *DeidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *DeidentifyContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *DeidentifyContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *DeidentifyContentRequest) GetDeidentifyTemplateName() string {
	if x != nil {
		return x.DeidentifyTemplateName
	}
	return ""
}

func (x *DeidentifyContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of de-identifying a ContentItem.
type DeidentifyContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The de-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// An overview of the changes that were made on the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *DeidentifyContentResponse) Reset() {
	*x = DeidentifyContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyContentResponse) ProtoMessage() {}

func (x *DeidentifyContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyContentResponse.ProtoReflect.Descriptor instead.
func (*DeidentifyContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{25}
}

func (x *DeidentifyContentResponse) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *DeidentifyContentResponse) GetOverview() *TransformationOverview {
	if x != nil {
		return x.Overview
	}
	return nil
}

// Request to re-identify an item.
type ReidentifyContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the re-identification of the content item.
	// This field shares the same proto message type that is used for
	// de-identification, however its usage here is for the reversal of the
	// previous de-identification. Re-identification is performed by examining
	// the transformations used to de-identify the items and executing the
	// reverse. This requires that only reversible transformations
	// be provided here. The reversible transformations are:
	//
	//  - `CryptoDeterministicConfig`
	//  - `CryptoReplaceFfxFpeConfig`
	ReidentifyConfig *DeidentifyConfig `protobuf:"bytes,2,opt,name=reidentify_config,json=reidentifyConfig,proto3" json:"reidentify_config,omitempty"`
	// Configuration for the inspector.
	InspectConfig *InspectConfig `protobuf:"bytes,3,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to re-identify. Will be treated as text.
	Item *ContentItem `protobuf:"bytes,4,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,5,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Template to use. References an instance of `DeidentifyTemplate`.
	// Any configuration directly specified in `reidentify_config` or
	// `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	ReidentifyTemplateName string `protobuf:"bytes,6,opt,name=reidentify_template_name,json=reidentifyTemplateName,proto3" json:"reidentify_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ReidentifyContentRequest) Reset() {
	*x = ReidentifyContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReidentifyContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReidentifyContentRequest) ProtoMessage() {}

func (x *ReidentifyContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReidentifyContentRequest.ProtoReflect.Descriptor instead.
func (*ReidentifyContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{26}
}

func (x *ReidentifyContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReidentifyContentRequest) GetReidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.ReidentifyConfig
	}
	return nil
}

func (x *ReidentifyContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *ReidentifyContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *ReidentifyContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *ReidentifyContentRequest) GetReidentifyTemplateName() string {
	if x != nil {
		return x.ReidentifyTemplateName
	}
	return ""
}

func (x *ReidentifyContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of re-identifying a item.
type ReidentifyContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The re-identified item.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// An overview of the changes that were made to the `item`.
	Overview *TransformationOverview `protobuf:"bytes,2,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *ReidentifyContentResponse) Reset() {
	*x = ReidentifyContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReidentifyContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReidentifyContentResponse) ProtoMessage() {}

func (x *ReidentifyContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReidentifyContentResponse.ProtoReflect.Descriptor instead.
func (*ReidentifyContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{27}
}

func (x *ReidentifyContentResponse) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *ReidentifyContentResponse) GetOverview() *TransformationOverview {
	if x != nil {
		return x.Overview
	}
	return nil
}

// Request to search for potentially sensitive info in a ContentItem.
type InspectContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Configuration for the inspector. What specified here will override
	// the template referenced by the inspect_template_name argument.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// The item to inspect.
	Item *ContentItem `protobuf:"bytes,3,opt,name=item,proto3" json:"item,omitempty"`
	// Template to use. Any configuration directly specified in
	// inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups
	// are recursively merged.
	InspectTemplateName string `protobuf:"bytes,4,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *InspectContentRequest) Reset() {
	*x = InspectContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectContentRequest) ProtoMessage() {}

func (x *InspectContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectContentRequest.ProtoReflect.Descriptor instead.
func (*InspectContentRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{28}
}

func (x *InspectContentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InspectContentRequest) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *InspectContentRequest) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *InspectContentRequest) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *InspectContentRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Results of inspecting an item.
type InspectContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The findings.
	Result *InspectResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *InspectContentResponse) Reset() {
	*x = InspectContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectContentResponse) ProtoMessage() {}

func (x *InspectContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectContentResponse.ProtoReflect.Descriptor instead.
func (*InspectContentResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{29}
}

func (x *InspectContentResponse) GetResult() *InspectResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// Cloud repository for storing output.
type OutputStorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output storage types.
	//
	// Types that are assignable to Type:
	//	*OutputStorageConfig_Table
	Type isOutputStorageConfig_Type `protobuf_oneof:"type"`
	// Schema used for writing the findings for Inspect jobs. This field is only
	// used for Inspect and must be unspecified for Risk jobs. Columns are derived
	// from the `Finding` object. If appending to an existing table, any columns
	// from the predefined schema that are missing will be added. No columns in
	// the existing table will be deleted.
	//
	// If unspecified, then all available columns will be used for a new table or
	// an (existing) table with no schema, and no changes will be made to an
	// existing table that has a schema.
	// Only for use with external storage.
	OutputSchema OutputStorageConfig_OutputSchema `protobuf:"varint,3,opt,name=output_schema,json=outputSchema,proto3,enum=google.privacy.dlp.v2.OutputStorageConfig_OutputSchema" json:"output_schema,omitempty"`
}

func (x *OutputStorageConfig) Reset() {
	*x = OutputStorageConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputStorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputStorageConfig) ProtoMessage() {}

func (x *OutputStorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputStorageConfig.ProtoReflect.Descriptor instead.
func (*OutputStorageConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{30}
}

func (m *OutputStorageConfig) GetType() isOutputStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *OutputStorageConfig) GetTable() *BigQueryTable {
	if x, ok := x.GetType().(*OutputStorageConfig_Table); ok {
		return x.Table
	}
	return nil
}

func (x *OutputStorageConfig) GetOutputSchema() OutputStorageConfig_OutputSchema {
	if x != nil {
		return x.OutputSchema
	}
	return OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED
}

type isOutputStorageConfig_Type interface {
	isOutputStorageConfig_Type()
}

type OutputStorageConfig_Table struct {
	// Store findings in an existing table or a new table in an existing
	// dataset. If table_id is not set a new one will be generated
	// for you with the following format:
	// dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific timezone will be used for
	// generating the date details.
	//
	// For Inspect, each column in an existing output table must have the same
	// name, type, and mode of a field in the `Finding` object.
	//
	// For Risk, an existing output table should be the output of a previous
	// Risk analysis job run on the same source table, with the same privacy
	// metric and quasi-identifiers. Risk jobs that analyze the same table but
	// compute a different privacy metric, or use different sets of
	// quasi-identifiers, cannot store their results in the same table.
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,proto3,oneof"`
}

func (*OutputStorageConfig_Table) isOutputStorageConfig_Type() {}

// Statistics regarding a specific InfoType.
type InfoTypeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of finding this stat is for.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Number of findings for this infoType.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *InfoTypeStats) Reset() {
	*x = InfoTypeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeStats) ProtoMessage() {}

func (x *InfoTypeStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeStats.ProtoReflect.Descriptor instead.
func (*InfoTypeStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{31}
}

func (x *InfoTypeStats) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *InfoTypeStats) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// The results of an inspect DataSource job.
type InspectDataSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration used for this job.
	RequestedOptions *InspectDataSourceDetails_RequestedOptions `protobuf:"bytes,2,opt,name=requested_options,json=requestedOptions,proto3" json:"requested_options,omitempty"`
	// A summary of the outcome of this inspect job.
	Result *InspectDataSourceDetails_Result `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *InspectDataSourceDetails) Reset() {
	*x = InspectDataSourceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails) ProtoMessage() {}

func (x *InspectDataSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{32}
}

func (x *InspectDataSourceDetails) GetRequestedOptions() *InspectDataSourceDetails_RequestedOptions {
	if x != nil {
		return x.RequestedOptions
	}
	return nil
}

func (x *InspectDataSourceDetails) GetResult() *InspectDataSourceDetails_Result {
	if x != nil {
		return x.Result
	}
	return nil
}

// Statistics related to processing hybrid inspect requests.
type HybridInspectStatistics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of hybrid inspection requests processed within this job.
	ProcessedCount int64 `protobuf:"varint,1,opt,name=processed_count,json=processedCount,proto3" json:"processed_count,omitempty"`
	// The number of hybrid inspection requests aborted because the job ran
	// out of quota or was ended before they could be processed.
	AbortedCount int64 `protobuf:"varint,2,opt,name=aborted_count,json=abortedCount,proto3" json:"aborted_count,omitempty"`
	// The number of hybrid requests currently being processed. Only populated
	// when called via method `getDlpJob`.
	// A burst of traffic may cause hybrid inspect requests to be enqueued.
	// Processing will take place as quickly as possible, but resource limitations
	// may impact how long a request is enqueued for.
	PendingCount int64 `protobuf:"varint,3,opt,name=pending_count,json=pendingCount,proto3" json:"pending_count,omitempty"`
}

func (x *HybridInspectStatistics) Reset() {
	*x = HybridInspectStatistics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectStatistics) ProtoMessage() {}

func (x *HybridInspectStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectStatistics.ProtoReflect.Descriptor instead.
func (*HybridInspectStatistics) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{33}
}

func (x *HybridInspectStatistics) GetProcessedCount() int64 {
	if x != nil {
		return x.ProcessedCount
	}
	return 0
}

func (x *HybridInspectStatistics) GetAbortedCount() int64 {
	if x != nil {
		return x.AbortedCount
	}
	return 0
}

func (x *HybridInspectStatistics) GetPendingCount() int64 {
	if x != nil {
		return x.PendingCount
	}
	return 0
}

// InfoType description.
type InfoTypeDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal name of the infoType.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable form of the infoType name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Which parts of the API supports this InfoType.
	SupportedBy []InfoTypeSupportedBy `protobuf:"varint,3,rep,packed,name=supported_by,json=supportedBy,proto3,enum=google.privacy.dlp.v2.InfoTypeSupportedBy" json:"supported_by,omitempty"`
	// Description of the infotype. Translated when language is provided in the
	// request.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *InfoTypeDescription) Reset() {
	*x = InfoTypeDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeDescription) ProtoMessage() {}

func (x *InfoTypeDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeDescription.ProtoReflect.Descriptor instead.
func (*InfoTypeDescription) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{34}
}

func (x *InfoTypeDescription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InfoTypeDescription) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InfoTypeDescription) GetSupportedBy() []InfoTypeSupportedBy {
	if x != nil {
		return x.SupportedBy
	}
	return nil
}

func (x *InfoTypeDescription) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Request for the list of infoTypes.
type ListInfoTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource name.
	// - Format:locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// BCP-47 language code for localized infoType friendly
	// names. If omitted, or if localized strings are not available,
	// en-US strings will be returned.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// filter to only return infoTypes supported by certain parts of the
	// API. Defaults to supported_by=INSPECT.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,3,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListInfoTypesRequest) Reset() {
	*x = ListInfoTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInfoTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInfoTypesRequest) ProtoMessage() {}

func (x *ListInfoTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInfoTypesRequest.ProtoReflect.Descriptor instead.
func (*ListInfoTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{35}
}

func (x *ListInfoTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInfoTypesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListInfoTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInfoTypesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response to the ListInfoTypes request.
type ListInfoTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of sensitive infoTypes.
	InfoTypes []*InfoTypeDescription `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *ListInfoTypesResponse) Reset() {
	*x = ListInfoTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInfoTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInfoTypesResponse) ProtoMessage() {}

func (x *ListInfoTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInfoTypesResponse.ProtoReflect.Descriptor instead.
func (*ListInfoTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{36}
}

func (x *ListInfoTypesResponse) GetInfoTypes() []*InfoTypeDescription {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// Configuration for a risk analysis job. See
// https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
type RiskAnalysisJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Privacy metric to compute.
	PrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=privacy_metric,json=privacyMetric,proto3" json:"privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	SourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
	// Actions to execute at the completion of the job. Are executed in the order
	// provided.
	Actions []*Action `protobuf:"bytes,3,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *RiskAnalysisJobConfig) Reset() {
	*x = RiskAnalysisJobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RiskAnalysisJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RiskAnalysisJobConfig) ProtoMessage() {}

func (x *RiskAnalysisJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RiskAnalysisJobConfig.ProtoReflect.Descriptor instead.
func (*RiskAnalysisJobConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{37}
}

func (x *RiskAnalysisJobConfig) GetPrivacyMetric() *PrivacyMetric {
	if x != nil {
		return x.PrivacyMetric
	}
	return nil
}

func (x *RiskAnalysisJobConfig) GetSourceTable() *BigQueryTable {
	if x != nil {
		return x.SourceTable
	}
	return nil
}

func (x *RiskAnalysisJobConfig) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// A column with a semantic tag attached.
type QuasiId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Semantic tag that identifies what a column contains, to determine which
	// statistical model to use to estimate the reidentifiability of each
	// value. [required]
	//
	// Types that are assignable to Tag:
	//	*QuasiId_InfoType
	//	*QuasiId_CustomTag
	//	*QuasiId_Inferred
	Tag isQuasiId_Tag `protobuf_oneof:"tag"`
}

func (x *QuasiId) Reset() {
	*x = QuasiId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuasiId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuasiId) ProtoMessage() {}

func (x *QuasiId) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuasiId.ProtoReflect.Descriptor instead.
func (*QuasiId) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{38}
}

func (x *QuasiId) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (m *QuasiId) GetTag() isQuasiId_Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (x *QuasiId) GetInfoType() *InfoType {
	if x, ok := x.GetTag().(*QuasiId_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *QuasiId) GetCustomTag() string {
	if x, ok := x.GetTag().(*QuasiId_CustomTag); ok {
		return x.CustomTag
	}
	return ""
}

func (x *QuasiId) GetInferred() *emptypb.Empty {
	if x, ok := x.GetTag().(*QuasiId_Inferred); ok {
		return x.Inferred
	}
	return nil
}

type isQuasiId_Tag interface {
	isQuasiId_Tag()
}

type QuasiId_InfoType struct {
	// A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We
	// currently support US ZIP codes, region codes, ages and genders.
	// To programmatically obtain the list of supported InfoTypes, use
	// ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3,oneof"`
}

type QuasiId_CustomTag struct {
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,3,opt,name=custom_tag,json=customTag,proto3,oneof"`
}

type QuasiId_Inferred struct {
	// If no semantic tag is indicated, we infer the statistical model from
	// the distribution of values in the input data
	Inferred *emptypb.Empty `protobuf:"bytes,4,opt,name=inferred,proto3,oneof"`
}

func (*QuasiId_InfoType) isQuasiId_Tag() {}

func (*QuasiId_CustomTag) isQuasiId_Tag() {}

func (*QuasiId_Inferred) isQuasiId_Tag() {}

// An auxiliary table containing statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple.
// If a tuple is present in the data but not in the auxiliary table, the
// corresponding relative frequency is assumed to be zero (and thus, the
// tuple is highly reidentifiable).
type StatisticalTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Auxiliary table location.
	Table *BigQueryTable `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// Required. Quasi-identifier columns.
	QuasiIds []*StatisticalTable_QuasiIdentifierField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Required. The relative frequency column must contain a floating-point number
	// between 0 and 1 (inclusive). Null values are assumed to be zero.
	RelativeFrequency *FieldId `protobuf:"bytes,2,opt,name=relative_frequency,json=relativeFrequency,proto3" json:"relative_frequency,omitempty"`
}

func (x *StatisticalTable) Reset() {
	*x = StatisticalTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatisticalTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticalTable) ProtoMessage() {}

func (x *StatisticalTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticalTable.ProtoReflect.Descriptor instead.
func (*StatisticalTable) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{39}
}

func (x *StatisticalTable) GetTable() *BigQueryTable {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *StatisticalTable) GetQuasiIds() []*StatisticalTable_QuasiIdentifierField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *StatisticalTable) GetRelativeFrequency() *FieldId {
	if x != nil {
		return x.RelativeFrequency
	}
	return nil
}

// Privacy metric to compute for reidentification risk analysis.
type PrivacyMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types of analysis.
	//
	// Types that are assignable to Type:
	//	*PrivacyMetric_NumericalStatsConfig_
	//	*PrivacyMetric_CategoricalStatsConfig_
	//	*PrivacyMetric_KAnonymityConfig_
	//	*PrivacyMetric_LDiversityConfig_
	//	*PrivacyMetric_KMapEstimationConfig_
	//	*PrivacyMetric_DeltaPresenceEstimationConfig_
	Type isPrivacyMetric_Type `protobuf_oneof:"type"`
}

func (x *PrivacyMetric) Reset() {
	*x = PrivacyMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric) ProtoMessage() {}

func (x *PrivacyMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric.ProtoReflect.Descriptor instead.
func (*PrivacyMetric) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40}
}

func (m *PrivacyMetric) GetType() isPrivacyMetric_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *PrivacyMetric) GetNumericalStatsConfig() *PrivacyMetric_NumericalStatsConfig {
	if x, ok := x.GetType().(*PrivacyMetric_NumericalStatsConfig_); ok {
		return x.NumericalStatsConfig
	}
	return nil
}

func (x *PrivacyMetric) GetCategoricalStatsConfig() *PrivacyMetric_CategoricalStatsConfig {
	if x, ok := x.GetType().(*PrivacyMetric_CategoricalStatsConfig_); ok {
		return x.CategoricalStatsConfig
	}
	return nil
}

func (x *PrivacyMetric) GetKAnonymityConfig() *PrivacyMetric_KAnonymityConfig {
	if x, ok := x.GetType().(*PrivacyMetric_KAnonymityConfig_); ok {
		return x.KAnonymityConfig
	}
	return nil
}

func (x *PrivacyMetric) GetLDiversityConfig() *PrivacyMetric_LDiversityConfig {
	if x, ok := x.GetType().(*PrivacyMetric_LDiversityConfig_); ok {
		return x.LDiversityConfig
	}
	return nil
}

func (x *PrivacyMetric) GetKMapEstimationConfig() *PrivacyMetric_KMapEstimationConfig {
	if x, ok := x.GetType().(*PrivacyMetric_KMapEstimationConfig_); ok {
		return x.KMapEstimationConfig
	}
	return nil
}

func (x *PrivacyMetric) GetDeltaPresenceEstimationConfig() *PrivacyMetric_DeltaPresenceEstimationConfig {
	if x, ok := x.GetType().(*PrivacyMetric_DeltaPresenceEstimationConfig_); ok {
		return x.DeltaPresenceEstimationConfig
	}
	return nil
}

type isPrivacyMetric_Type interface {
	isPrivacyMetric_Type()
}

type PrivacyMetric_NumericalStatsConfig_ struct {
	// Numerical stats
	NumericalStatsConfig *PrivacyMetric_NumericalStatsConfig `protobuf:"bytes,1,opt,name=numerical_stats_config,json=numericalStatsConfig,proto3,oneof"`
}

type PrivacyMetric_CategoricalStatsConfig_ struct {
	// Categorical stats
	CategoricalStatsConfig *PrivacyMetric_CategoricalStatsConfig `protobuf:"bytes,2,opt,name=categorical_stats_config,json=categoricalStatsConfig,proto3,oneof"`
}

type PrivacyMetric_KAnonymityConfig_ struct {
	// K-anonymity
	KAnonymityConfig *PrivacyMetric_KAnonymityConfig `protobuf:"bytes,3,opt,name=k_anonymity_config,json=kAnonymityConfig,proto3,oneof"`
}

type PrivacyMetric_LDiversityConfig_ struct {
	// l-diversity
	LDiversityConfig *PrivacyMetric_LDiversityConfig `protobuf:"bytes,4,opt,name=l_diversity_config,json=lDiversityConfig,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_ struct {
	// k-map
	KMapEstimationConfig *PrivacyMetric_KMapEstimationConfig `protobuf:"bytes,5,opt,name=k_map_estimation_config,json=kMapEstimationConfig,proto3,oneof"`
}

type PrivacyMetric_DeltaPresenceEstimationConfig_ struct {
	// delta-presence
	DeltaPresenceEstimationConfig *PrivacyMetric_DeltaPresenceEstimationConfig `protobuf:"bytes,6,opt,name=delta_presence_estimation_config,json=deltaPresenceEstimationConfig,proto3,oneof"`
}

func (*PrivacyMetric_NumericalStatsConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_CategoricalStatsConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_KAnonymityConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_LDiversityConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_KMapEstimationConfig_) isPrivacyMetric_Type() {}

func (*PrivacyMetric_DeltaPresenceEstimationConfig_) isPrivacyMetric_Type() {}

// Result of a risk analysis operation request.
type AnalyzeDataSourceRiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Privacy metric to compute.
	RequestedPrivacyMetric *PrivacyMetric `protobuf:"bytes,1,opt,name=requested_privacy_metric,json=requestedPrivacyMetric,proto3" json:"requested_privacy_metric,omitempty"`
	// Input dataset to compute metrics over.
	RequestedSourceTable *BigQueryTable `protobuf:"bytes,2,opt,name=requested_source_table,json=requestedSourceTable,proto3" json:"requested_source_table,omitempty"`
	// Values associated with this metric.
	//
	// Types that are assignable to Result:
	//	*AnalyzeDataSourceRiskDetails_NumericalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_
	//	*AnalyzeDataSourceRiskDetails_KAnonymityResult_
	//	*AnalyzeDataSourceRiskDetails_LDiversityResult_
	//	*AnalyzeDataSourceRiskDetails_KMapEstimationResult_
	//	*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_
	Result isAnalyzeDataSourceRiskDetails_Result `protobuf_oneof:"result"`
}

func (x *AnalyzeDataSourceRiskDetails) Reset() {
	*x = AnalyzeDataSourceRiskDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41}
}

func (x *AnalyzeDataSourceRiskDetails) GetRequestedPrivacyMetric() *PrivacyMetric {
	if x != nil {
		return x.RequestedPrivacyMetric
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetRequestedSourceTable() *BigQueryTable {
	if x != nil {
		return x.RequestedSourceTable
	}
	return nil
}

func (m *AnalyzeDataSourceRiskDetails) GetResult() isAnalyzeDataSourceRiskDetails_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetNumericalStatsResult() *AnalyzeDataSourceRiskDetails_NumericalStatsResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_NumericalStatsResult_); ok {
		return x.NumericalStatsResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetCategoricalStatsResult() *AnalyzeDataSourceRiskDetails_CategoricalStatsResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_); ok {
		return x.CategoricalStatsResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetKAnonymityResult() *AnalyzeDataSourceRiskDetails_KAnonymityResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_KAnonymityResult_); ok {
		return x.KAnonymityResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetLDiversityResult() *AnalyzeDataSourceRiskDetails_LDiversityResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_LDiversityResult_); ok {
		return x.LDiversityResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetKMapEstimationResult() *AnalyzeDataSourceRiskDetails_KMapEstimationResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_); ok {
		return x.KMapEstimationResult
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails) GetDeltaPresenceEstimationResult() *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult {
	if x, ok := x.GetResult().(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_); ok {
		return x.DeltaPresenceEstimationResult
	}
	return nil
}

type isAnalyzeDataSourceRiskDetails_Result interface {
	isAnalyzeDataSourceRiskDetails_Result()
}

type AnalyzeDataSourceRiskDetails_NumericalStatsResult_ struct {
	// Numerical stats result
	NumericalStatsResult *AnalyzeDataSourceRiskDetails_NumericalStatsResult `protobuf:"bytes,3,opt,name=numerical_stats_result,json=numericalStatsResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_ struct {
	// Categorical stats result
	CategoricalStatsResult *AnalyzeDataSourceRiskDetails_CategoricalStatsResult `protobuf:"bytes,4,opt,name=categorical_stats_result,json=categoricalStatsResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_KAnonymityResult_ struct {
	// K-anonymity result
	KAnonymityResult *AnalyzeDataSourceRiskDetails_KAnonymityResult `protobuf:"bytes,5,opt,name=k_anonymity_result,json=kAnonymityResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_LDiversityResult_ struct {
	// L-divesity result
	LDiversityResult *AnalyzeDataSourceRiskDetails_LDiversityResult `protobuf:"bytes,6,opt,name=l_diversity_result,json=lDiversityResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_KMapEstimationResult_ struct {
	// K-map result
	KMapEstimationResult *AnalyzeDataSourceRiskDetails_KMapEstimationResult `protobuf:"bytes,7,opt,name=k_map_estimation_result,json=kMapEstimationResult,proto3,oneof"`
}

type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_ struct {
	// Delta-presence result
	DeltaPresenceEstimationResult *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult `protobuf:"bytes,9,opt,name=delta_presence_estimation_result,json=deltaPresenceEstimationResult,proto3,oneof"`
}

func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_) isAnalyzeDataSourceRiskDetails_Result() {}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_) isAnalyzeDataSourceRiskDetails_Result() {
}

// A value of a field, including its frequency.
type ValueFrequency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A value contained in the field in question.
	Value *Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// How many times the value is contained in the field.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *ValueFrequency) Reset() {
	*x = ValueFrequency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueFrequency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueFrequency) ProtoMessage() {}

func (x *ValueFrequency) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueFrequency.ProtoReflect.Descriptor instead.
func (*ValueFrequency) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{42}
}

func (x *ValueFrequency) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ValueFrequency) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Set of primitive values supported by the system.
// Note that for the purposes of inspection or transformation, the number
// of bytes considered to comprise a 'Value' is based on its representation
// as a UTF-8 encoded string. For example, if 'integer_value' is set to
// 123456789, the number of bytes would be counted as 9, even though an
// int64 only holds up to 8 bytes of data.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value types
	//
	// Types that are assignable to Type:
	//	*Value_IntegerValue
	//	*Value_FloatValue
	//	*Value_StringValue
	//	*Value_BooleanValue
	//	*Value_TimestampValue
	//	*Value_TimeValue
	//	*Value_DateValue
	//	*Value_DayOfWeekValue
	Type isValue_Type `protobuf_oneof:"type"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{43}
}

func (m *Value) GetType() isValue_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Value) GetIntegerValue() int64 {
	if x, ok := x.GetType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *Value) GetFloatValue() float64 {
	if x, ok := x.GetType().(*Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetBooleanValue() bool {
	if x, ok := x.GetType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (x *Value) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *Value) GetTimeValue() *timeofday.TimeOfDay {
	if x, ok := x.GetType().(*Value_TimeValue); ok {
		return x.TimeValue
	}
	return nil
}

func (x *Value) GetDateValue() *date.Date {
	if x, ok := x.GetType().(*Value_DateValue); ok {
		return x.DateValue
	}
	return nil
}

func (x *Value) GetDayOfWeekValue() dayofweek.DayOfWeek {
	if x, ok := x.GetType().(*Value_DayOfWeekValue); ok {
		return x.DayOfWeekValue
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

type isValue_Type interface {
	isValue_Type()
}

type Value_IntegerValue struct {
	// integer
	IntegerValue int64 `protobuf:"varint,1,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type Value_FloatValue struct {
	// float
	FloatValue float64 `protobuf:"fixed64,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type Value_StringValue struct {
	// string
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_BooleanValue struct {
	// boolean
	BooleanValue bool `protobuf:"varint,4,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

type Value_TimestampValue struct {
	// timestamp
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type Value_TimeValue struct {
	// time of day
	TimeValue *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=time_value,json=timeValue,proto3,oneof"`
}

type Value_DateValue struct {
	// date
	DateValue *date.Date `protobuf:"bytes,7,opt,name=date_value,json=dateValue,proto3,oneof"`
}

type Value_DayOfWeekValue struct {
	// day of week
	DayOfWeekValue dayofweek.DayOfWeek `protobuf:"varint,8,opt,name=day_of_week_value,json=dayOfWeekValue,proto3,enum=google.type.DayOfWeek,oneof"`
}

func (*Value_IntegerValue) isValue_Type() {}

func (*Value_FloatValue) isValue_Type() {}

func (*Value_StringValue) isValue_Type() {}

func (*Value_BooleanValue) isValue_Type() {}

func (*Value_TimestampValue) isValue_Type() {}

func (*Value_TimeValue) isValue_Type() {}

func (*Value_DateValue) isValue_Type() {}

func (*Value_DayOfWeekValue) isValue_Type() {}

// Message for infoType-dependent details parsed from quote.
type QuoteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Object representation of the quote.
	//
	// Types that are assignable to ParsedQuote:
	//	*QuoteInfo_DateTime
	ParsedQuote isQuoteInfo_ParsedQuote `protobuf_oneof:"parsed_quote"`
}

func (x *QuoteInfo) Reset() {
	*x = QuoteInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuoteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuoteInfo) ProtoMessage() {}

func (x *QuoteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuoteInfo.ProtoReflect.Descriptor instead.
func (*QuoteInfo) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{44}
}

func (m *QuoteInfo) GetParsedQuote() isQuoteInfo_ParsedQuote {
	if m != nil {
		return m.ParsedQuote
	}
	return nil
}

func (x *QuoteInfo) GetDateTime() *DateTime {
	if x, ok := x.GetParsedQuote().(*QuoteInfo_DateTime); ok {
		return x.DateTime
	}
	return nil
}

type isQuoteInfo_ParsedQuote interface {
	isQuoteInfo_ParsedQuote()
}

type QuoteInfo_DateTime struct {
	// The date time indicated by the quote.
	DateTime *DateTime `protobuf:"bytes,2,opt,name=date_time,json=dateTime,proto3,oneof"`
}

func (*QuoteInfo_DateTime) isQuoteInfo_ParsedQuote() {}

// Message for a date time object.
// e.g. 2018-01-01, 5th August.
type DateTime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more of the following must be set.
	// Must be a valid date or time value.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Day of week
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	// Time of day
	Time *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Time zone
	TimeZone *DateTime_TimeZone `protobuf:"bytes,4,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *DateTime) Reset() {
	*x = DateTime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTime) ProtoMessage() {}

func (x *DateTime) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTime.ProtoReflect.Descriptor instead.
func (*DateTime) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{45}
}

func (x *DateTime) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *DateTime) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek_DAY_OF_WEEK_UNSPECIFIED
}

func (x *DateTime) GetTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *DateTime) GetTimeZone() *DateTime_TimeZone {
	if x != nil {
		return x.TimeZone
	}
	return nil
}

// The configuration that controls how the data will change.
type DeidentifyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Transformation:
	//	*DeidentifyConfig_InfoTypeTransformations
	//	*DeidentifyConfig_RecordTransformations
	Transformation isDeidentifyConfig_Transformation `protobuf_oneof:"transformation"`
	// Mode for handling transformation errors. If left unspecified, the default
	// mode is `TransformationErrorHandling.ThrowError`.
	TransformationErrorHandling *TransformationErrorHandling `protobuf:"bytes,3,opt,name=transformation_error_handling,json=transformationErrorHandling,proto3" json:"transformation_error_handling,omitempty"`
}

func (x *DeidentifyConfig) Reset() {
	*x = DeidentifyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyConfig) ProtoMessage() {}

func (x *DeidentifyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyConfig.ProtoReflect.Descriptor instead.
func (*DeidentifyConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{46}
}

func (m *DeidentifyConfig) GetTransformation() isDeidentifyConfig_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *DeidentifyConfig) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := x.GetTransformation().(*DeidentifyConfig_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

func (x *DeidentifyConfig) GetRecordTransformations() *RecordTransformations {
	if x, ok := x.GetTransformation().(*DeidentifyConfig_RecordTransformations); ok {
		return x.RecordTransformations
	}
	return nil
}

func (x *DeidentifyConfig) GetTransformationErrorHandling() *TransformationErrorHandling {
	if x != nil {
		return x.TransformationErrorHandling
	}
	return nil
}

type isDeidentifyConfig_Transformation interface {
	isDeidentifyConfig_Transformation()
}

type DeidentifyConfig_InfoTypeTransformations struct {
	// Treat the dataset as free-form text and apply the same free text
	// transformation everywhere.
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,1,opt,name=info_type_transformations,json=infoTypeTransformations,proto3,oneof"`
}

type DeidentifyConfig_RecordTransformations struct {
	// Treat the dataset as structured. Transformations can be applied to
	// specific locations within structured datasets, such as transforming
	// a column within a table.
	RecordTransformations *RecordTransformations `protobuf:"bytes,2,opt,name=record_transformations,json=recordTransformations,proto3,oneof"`
}

func (*DeidentifyConfig_InfoTypeTransformations) isDeidentifyConfig_Transformation() {}

func (*DeidentifyConfig_RecordTransformations) isDeidentifyConfig_Transformation() {}

// How to handle transformation errors during de-identification. A
// transformation error occurs when the requested transformation is incompatible
// with the data. For example, trying to de-identify an IP address using a
// `DateShift` transformation would result in a transformation error, since date
// info cannot be extracted from an IP address.
// Information about any incompatible transformations, and how they were
// handled, is returned in the response as part of the
// `TransformationOverviews`.
type TransformationErrorHandling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How transformation errors should be handled.
	//
	// Types that are assignable to Mode:
	//	*TransformationErrorHandling_ThrowError_
	//	*TransformationErrorHandling_LeaveUntransformed_
	Mode isTransformationErrorHandling_Mode `protobuf_oneof:"mode"`
}

func (x *TransformationErrorHandling) Reset() {
	*x = TransformationErrorHandling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling) ProtoMessage() {}

func (x *TransformationErrorHandling) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47}
}

func (m *TransformationErrorHandling) GetMode() isTransformationErrorHandling_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *TransformationErrorHandling) GetThrowError() *TransformationErrorHandling_ThrowError {
	if x, ok := x.GetMode().(*TransformationErrorHandling_ThrowError_); ok {
		return x.ThrowError
	}
	return nil
}

func (x *TransformationErrorHandling) GetLeaveUntransformed() *TransformationErrorHandling_LeaveUntransformed {
	if x, ok := x.GetMode().(*TransformationErrorHandling_LeaveUntransformed_); ok {
		return x.LeaveUntransformed
	}
	return nil
}

type isTransformationErrorHandling_Mode interface {
	isTransformationErrorHandling_Mode()
}

type TransformationErrorHandling_ThrowError_ struct {
	// Throw an error
	ThrowError *TransformationErrorHandling_ThrowError `protobuf:"bytes,1,opt,name=throw_error,json=throwError,proto3,oneof"`
}

type TransformationErrorHandling_LeaveUntransformed_ struct {
	// Ignore errors
	LeaveUntransformed *TransformationErrorHandling_LeaveUntransformed `protobuf:"bytes,2,opt,name=leave_untransformed,json=leaveUntransformed,proto3,oneof"`
}

func (*TransformationErrorHandling_ThrowError_) isTransformationErrorHandling_Mode() {}

func (*TransformationErrorHandling_LeaveUntransformed_) isTransformationErrorHandling_Mode() {}

// A rule for transforming a value.
type PrimitiveTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Transformation:
	//	*PrimitiveTransformation_ReplaceConfig
	//	*PrimitiveTransformation_RedactConfig
	//	*PrimitiveTransformation_CharacterMaskConfig
	//	*PrimitiveTransformation_CryptoReplaceFfxFpeConfig
	//	*PrimitiveTransformation_FixedSizeBucketingConfig
	//	*PrimitiveTransformation_BucketingConfig
	//	*PrimitiveTransformation_ReplaceWithInfoTypeConfig
	//	*PrimitiveTransformation_TimePartConfig
	//	*PrimitiveTransformation_CryptoHashConfig
	//	*PrimitiveTransformation_DateShiftConfig
	//	*PrimitiveTransformation_CryptoDeterministicConfig
	Transformation isPrimitiveTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (x *PrimitiveTransformation) Reset() {
	*x = PrimitiveTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrimitiveTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimitiveTransformation) ProtoMessage() {}

func (x *PrimitiveTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimitiveTransformation.ProtoReflect.Descriptor instead.
func (*PrimitiveTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{48}
}

func (m *PrimitiveTransformation) GetTransformation() isPrimitiveTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *PrimitiveTransformation) GetReplaceConfig() *ReplaceValueConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_ReplaceConfig); ok {
		return x.ReplaceConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetRedactConfig() *RedactConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_RedactConfig); ok {
		return x.RedactConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCharacterMaskConfig() *CharacterMaskConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CharacterMaskConfig); ok {
		return x.CharacterMaskConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoReplaceFfxFpeConfig() *CryptoReplaceFfxFpeConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoReplaceFfxFpeConfig); ok {
		return x.CryptoReplaceFfxFpeConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetFixedSizeBucketingConfig() *FixedSizeBucketingConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_FixedSizeBucketingConfig); ok {
		return x.FixedSizeBucketingConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetBucketingConfig() *BucketingConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_BucketingConfig); ok {
		return x.BucketingConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetReplaceWithInfoTypeConfig() *ReplaceWithInfoTypeConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_ReplaceWithInfoTypeConfig); ok {
		return x.ReplaceWithInfoTypeConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetTimePartConfig() *TimePartConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_TimePartConfig); ok {
		return x.TimePartConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoHashConfig() *CryptoHashConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoHashConfig); ok {
		return x.CryptoHashConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetDateShiftConfig() *DateShiftConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_DateShiftConfig); ok {
		return x.DateShiftConfig
	}
	return nil
}

func (x *PrimitiveTransformation) GetCryptoDeterministicConfig() *CryptoDeterministicConfig {
	if x, ok := x.GetTransformation().(*PrimitiveTransformation_CryptoDeterministicConfig); ok {
		return x.CryptoDeterministicConfig
	}
	return nil
}

type isPrimitiveTransformation_Transformation interface {
	isPrimitiveTransformation_Transformation()
}

type PrimitiveTransformation_ReplaceConfig struct {
	// Replace
	ReplaceConfig *ReplaceValueConfig `protobuf:"bytes,1,opt,name=replace_config,json=replaceConfig,proto3,oneof"`
}

type PrimitiveTransformation_RedactConfig struct {
	// Redact
	RedactConfig *RedactConfig `protobuf:"bytes,2,opt,name=redact_config,json=redactConfig,proto3,oneof"`
}

type PrimitiveTransformation_CharacterMaskConfig struct {
	// Mask
	CharacterMaskConfig *CharacterMaskConfig `protobuf:"bytes,3,opt,name=character_mask_config,json=characterMaskConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoReplaceFfxFpeConfig struct {
	// Ffx-Fpe
	CryptoReplaceFfxFpeConfig *CryptoReplaceFfxFpeConfig `protobuf:"bytes,4,opt,name=crypto_replace_ffx_fpe_config,json=cryptoReplaceFfxFpeConfig,proto3,oneof"`
}

type PrimitiveTransformation_FixedSizeBucketingConfig struct {
	// Fixed size bucketing
	FixedSizeBucketingConfig *FixedSizeBucketingConfig `protobuf:"bytes,5,opt,name=fixed_size_bucketing_config,json=fixedSizeBucketingConfig,proto3,oneof"`
}

type PrimitiveTransformation_BucketingConfig struct {
	// Bucketing
	BucketingConfig *BucketingConfig `protobuf:"bytes,6,opt,name=bucketing_config,json=bucketingConfig,proto3,oneof"`
}

type PrimitiveTransformation_ReplaceWithInfoTypeConfig struct {
	// Replace with infotype
	ReplaceWithInfoTypeConfig *ReplaceWithInfoTypeConfig `protobuf:"bytes,7,opt,name=replace_with_info_type_config,json=replaceWithInfoTypeConfig,proto3,oneof"`
}

type PrimitiveTransformation_TimePartConfig struct {
	// Time extraction
	TimePartConfig *TimePartConfig `protobuf:"bytes,8,opt,name=time_part_config,json=timePartConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoHashConfig struct {
	// Crypto
	CryptoHashConfig *CryptoHashConfig `protobuf:"bytes,9,opt,name=crypto_hash_config,json=cryptoHashConfig,proto3,oneof"`
}

type PrimitiveTransformation_DateShiftConfig struct {
	// Date Shift
	DateShiftConfig *DateShiftConfig `protobuf:"bytes,11,opt,name=date_shift_config,json=dateShiftConfig,proto3,oneof"`
}

type PrimitiveTransformation_CryptoDeterministicConfig struct {
	// Deterministic Crypto
	CryptoDeterministicConfig *CryptoDeterministicConfig `protobuf:"bytes,12,opt,name=crypto_deterministic_config,json=cryptoDeterministicConfig,proto3,oneof"`
}

func (*PrimitiveTransformation_ReplaceConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_RedactConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CharacterMaskConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoReplaceFfxFpeConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_FixedSizeBucketingConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_BucketingConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_ReplaceWithInfoTypeConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_TimePartConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoHashConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_DateShiftConfig) isPrimitiveTransformation_Transformation() {}

func (*PrimitiveTransformation_CryptoDeterministicConfig) isPrimitiveTransformation_Transformation() {}

// For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
// portion of the value.
type TimePartConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The part of the time to keep.
	PartToExtract TimePartConfig_TimePart `protobuf:"varint,1,opt,name=part_to_extract,json=partToExtract,proto3,enum=google.privacy.dlp.v2.TimePartConfig_TimePart" json:"part_to_extract,omitempty"`
}

func (x *TimePartConfig) Reset() {
	*x = TimePartConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimePartConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimePartConfig) ProtoMessage() {}

func (x *TimePartConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimePartConfig.ProtoReflect.Descriptor instead.
func (*TimePartConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{49}
}

func (x *TimePartConfig) GetPartToExtract() TimePartConfig_TimePart {
	if x != nil {
		return x.PartToExtract
	}
	return TimePartConfig_TIME_PART_UNSPECIFIED
}

// Pseudonymization method that generates surrogates via cryptographic hashing.
// Uses SHA-256.
// The key size must be either 32 or 64 bytes.
// Outputs a base64 encoded representation of the hashed output
// (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=).
// Currently, only string and integer values can be hashed.
// See https://cloud.google.com/dlp/docs/pseudonymization to learn more.
type CryptoHashConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used by the hash function.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
}

func (x *CryptoHashConfig) Reset() {
	*x = CryptoHashConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoHashConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoHashConfig) ProtoMessage() {}

func (x *CryptoHashConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoHashConfig.ProtoReflect.Descriptor instead.
func (*CryptoHashConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{50}
}

func (x *CryptoHashConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

// Pseudonymization method that generates deterministic encryption for the given
// input. Outputs a base64 encoded representation of the encrypted output.
// Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
type CryptoDeterministicConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used by the encryption function.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// The custom info type to annotate the surrogate with.
	// This annotation will be applied to the surrogate by prefixing it with
	// the name of the custom info type followed by the number of
	// characters comprising the surrogate. The following scheme defines the
	// format: {info type name}({surrogate character count}):{surrogate}
	//
	// For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
	// the surrogate is 'abc', the full replacement value
	// will be: 'MY_TOKEN_INFO_TYPE(3):abc'
	//
	// This annotation identifies the surrogate when inspecting content using the
	// custom info type 'Surrogate'. This facilitates reversal of the
	// surrogate when it occurs in free text.
	//
	// Note: For record transformations where the entire cell in a table is being
	// transformed, surrogates are not mandatory. Surrogates are used to denote
	// the location of the token and are necessary for re-identification in free
	// form text.
	//
	// In order for inspection to work properly, the name of this info type must
	// not occur naturally anywhere in your data; otherwise, inspection may either
	//
	// - reverse a surrogate that does not correspond to an actual identifier
	// - be unable to parse the surrogate and result in an error
	//
	// Therefore, choose your custom info type name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data.
	// For example, assuming your data is entered from a regular ASCII keyboard,
	// the symbol with the hex code point 29DD might be used like so:
	// ⧝MY_TOKEN_TYPE.
	SurrogateInfoType *InfoType `protobuf:"bytes,2,opt,name=surrogate_info_type,json=surrogateInfoType,proto3" json:"surrogate_info_type,omitempty"`
	// A context may be used for higher security and maintaining
	// referential integrity such that the same identifier in two different
	// contexts will be given a distinct surrogate. The context is appended to
	// plaintext value being encrypted. On decryption the provided context is
	// validated against the value used during encryption. If a context was
	// provided during encryption, same context must be provided during decryption
	// as well.
	//
	// If the context is not set, plaintext would be used as is for encryption.
	// If the context is set but:
	//
	// 1. there is no record present when transforming a given value or
	// 2. the field is not present when transforming a given value,
	//
	// plaintext would be used as is for encryption.
	//
	// Note that case (1) is expected when an `InfoTypeTransformation` is
	// applied to both structured and non-structured `ContentItem`s.
	Context *FieldId `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *CryptoDeterministicConfig) Reset() {
	*x = CryptoDeterministicConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoDeterministicConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoDeterministicConfig) ProtoMessage() {}

func (x *CryptoDeterministicConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoDeterministicConfig.ProtoReflect.Descriptor instead.
func (*CryptoDeterministicConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{51}
}

func (x *CryptoDeterministicConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

func (x *CryptoDeterministicConfig) GetSurrogateInfoType() *InfoType {
	if x != nil {
		return x.SurrogateInfoType
	}
	return nil
}

func (x *CryptoDeterministicConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

// Replace each input value with a given `Value`.
type ReplaceValueConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value to replace it with.
	NewValue *Value `protobuf:"bytes,1,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
}

func (x *ReplaceValueConfig) Reset() {
	*x = ReplaceValueConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceValueConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceValueConfig) ProtoMessage() {}

func (x *ReplaceValueConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceValueConfig.ProtoReflect.Descriptor instead.
func (*ReplaceValueConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{52}
}

func (x *ReplaceValueConfig) GetNewValue() *Value {
	if x != nil {
		return x.NewValue
	}
	return nil
}

// Replace each matching finding with the name of the info_type.
type ReplaceWithInfoTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReplaceWithInfoTypeConfig) Reset() {
	*x = ReplaceWithInfoTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplaceWithInfoTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplaceWithInfoTypeConfig) ProtoMessage() {}

func (x *ReplaceWithInfoTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplaceWithInfoTypeConfig.ProtoReflect.Descriptor instead.
func (*ReplaceWithInfoTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{53}
}

// Redact a given value. For example, if used with an `InfoTypeTransformation`
// transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the
// output would be 'My phone number is '.
type RedactConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RedactConfig) Reset() {
	*x = RedactConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactConfig) ProtoMessage() {}

func (x *RedactConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactConfig.ProtoReflect.Descriptor instead.
func (*RedactConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{54}
}

// Characters to skip when doing deidentification of a value. These will be left
// alone and skipped.
type CharsToIgnore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Characters:
	//	*CharsToIgnore_CharactersToSkip
	//	*CharsToIgnore_CommonCharactersToIgnore
	Characters isCharsToIgnore_Characters `protobuf_oneof:"characters"`
}

func (x *CharsToIgnore) Reset() {
	*x = CharsToIgnore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CharsToIgnore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CharsToIgnore) ProtoMessage() {}

func (x *CharsToIgnore) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CharsToIgnore.ProtoReflect.Descriptor instead.
func (*CharsToIgnore) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{55}
}

func (m *CharsToIgnore) GetCharacters() isCharsToIgnore_Characters {
	if m != nil {
		return m.Characters
	}
	return nil
}

func (x *CharsToIgnore) GetCharactersToSkip() string {
	if x, ok := x.GetCharacters().(*CharsToIgnore_CharactersToSkip); ok {
		return x.CharactersToSkip
	}
	return ""
}

func (x *CharsToIgnore) GetCommonCharactersToIgnore() CharsToIgnore_CommonCharsToIgnore {
	if x, ok := x.GetCharacters().(*CharsToIgnore_CommonCharactersToIgnore); ok {
		return x.CommonCharactersToIgnore
	}
	return CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED
}

type isCharsToIgnore_Characters interface {
	isCharsToIgnore_Characters()
}

type CharsToIgnore_CharactersToSkip struct {
	// Characters to not transform when masking.
	CharactersToSkip string `protobuf:"bytes,1,opt,name=characters_to_skip,json=charactersToSkip,proto3,oneof"`
}

type CharsToIgnore_CommonCharactersToIgnore struct {
	// Common characters to not transform when masking. Useful to avoid removing
	// punctuation.
	CommonCharactersToIgnore CharsToIgnore_CommonCharsToIgnore `protobuf:"varint,2,opt,name=common_characters_to_ignore,json=commonCharactersToIgnore,proto3,enum=google.privacy.dlp.v2.CharsToIgnore_CommonCharsToIgnore,oneof"`
}

func (*CharsToIgnore_CharactersToSkip) isCharsToIgnore_Characters() {}

func (*CharsToIgnore_CommonCharactersToIgnore) isCharsToIgnore_Characters() {}

// Partially mask a string by replacing a given number of characters with a
// fixed character. Masking can start from the beginning or end of the string.
// This can be used on data of any type (numbers, longs, and so on) and when
// de-identifying structured data we'll attempt to preserve the original data's
// type. (This allows you to take a long like 123 and modify it to a string like
// **3.
type CharacterMaskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Character to use to mask the sensitive values&mdash;for example, `*` for an
	// alphabetic string such as a name, or `0` for a numeric string such as ZIP
	// code or credit card number. This string must have a length of 1. If not
	// supplied, this value defaults to `*` for strings, and `0` for digits.
	MaskingCharacter string `protobuf:"bytes,1,opt,name=masking_character,json=maskingCharacter,proto3" json:"masking_character,omitempty"`
	// Number of characters to mask. If not set, all matching chars will be
	// masked. Skipped characters do not count towards this tally.
	NumberToMask int32 `protobuf:"varint,2,opt,name=number_to_mask,json=numberToMask,proto3" json:"number_to_mask,omitempty"`
	// Mask characters in reverse order. For example, if `masking_character` is
	// `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
	// input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
	// If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
	// is `true`, then the string `12345` is masked as `12***`.
	ReverseOrder bool `protobuf:"varint,3,opt,name=reverse_order,json=reverseOrder,proto3" json:"reverse_order,omitempty"`
	// When masking a string, items in this list will be skipped when replacing
	// characters. For example, if the input string is `555-555-5555` and you
	// instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
	// returns `***-**5-5555`.
	CharactersToIgnore []*CharsToIgnore `protobuf:"bytes,4,rep,name=characters_to_ignore,json=charactersToIgnore,proto3" json:"characters_to_ignore,omitempty"`
}

func (x *CharacterMaskConfig) Reset() {
	*x = CharacterMaskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CharacterMaskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CharacterMaskConfig) ProtoMessage() {}

func (x *CharacterMaskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CharacterMaskConfig.ProtoReflect.Descriptor instead.
func (*CharacterMaskConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{56}
}

func (x *CharacterMaskConfig) GetMaskingCharacter() string {
	if x != nil {
		return x.MaskingCharacter
	}
	return ""
}

func (x *CharacterMaskConfig) GetNumberToMask() int32 {
	if x != nil {
		return x.NumberToMask
	}
	return 0
}

func (x *CharacterMaskConfig) GetReverseOrder() bool {
	if x != nil {
		return x.ReverseOrder
	}
	return false
}

func (x *CharacterMaskConfig) GetCharactersToIgnore() []*CharsToIgnore {
	if x != nil {
		return x.CharactersToIgnore
	}
	return nil
}

// Buckets values based on fixed size ranges. The
// Bucketing transformation can provide all of this functionality,
// but requires more configuration. This message is provided as a convenience to
// the user for simple bucketing strategies.
//
// The transformed value will be a hyphenated string of
// {lower_bound}-{upper_bound}, i.e if lower_bound = 10 and upper_bound = 20
// all values that are within this bucket will be replaced with "10-20".
//
// This can be used on data of type: double, long.
//
// If the bound Value type differs from the type of data
// being transformed, we will first attempt converting the type of the data to
// be transformed to match the type of the bound before comparing.
//
// See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
type FixedSizeBucketingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lower bound value of buckets. All values less than `lower_bound` are
	// grouped together into a single bucket; for example if `lower_bound` = 10,
	// then all values less than 10 are replaced with the value "-10".
	LowerBound *Value `protobuf:"bytes,1,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Required. Upper bound value of buckets. All values greater than upper_bound are
	// grouped together into a single bucket; for example if `upper_bound` = 89,
	// then all values greater than 89 are replaced with the value "89+".
	UpperBound *Value `protobuf:"bytes,2,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
	// Required. Size of each bucket (except for minimum and maximum buckets). So if
	// `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
	// following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
	// 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
	BucketSize float64 `protobuf:"fixed64,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
}

func (x *FixedSizeBucketingConfig) Reset() {
	*x = FixedSizeBucketingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FixedSizeBucketingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FixedSizeBucketingConfig) ProtoMessage() {}

func (x *FixedSizeBucketingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FixedSizeBucketingConfig.ProtoReflect.Descriptor instead.
func (*FixedSizeBucketingConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{57}
}

func (x *FixedSizeBucketingConfig) GetLowerBound() *Value {
	if x != nil {
		return x.LowerBound
	}
	return nil
}

func (x *FixedSizeBucketingConfig) GetUpperBound() *Value {
	if x != nil {
		return x.UpperBound
	}
	return nil
}

func (x *FixedSizeBucketingConfig) GetBucketSize() float64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

// Generalization function that buckets values based on ranges. The ranges and
// replacement values are dynamically provided by the user for custom behavior,
// such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH
// This can be used on
// data of type: number, long, string, timestamp.
// If the bound `Value` type differs from the type of data being transformed, we
// will first attempt converting the type of the data to be transformed to match
// the type of the bound before comparing.
// See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
type BucketingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of buckets. Ranges must be non-overlapping.
	Buckets []*BucketingConfig_Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *BucketingConfig) Reset() {
	*x = BucketingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketingConfig) ProtoMessage() {}

func (x *BucketingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketingConfig.ProtoReflect.Descriptor instead.
func (*BucketingConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{58}
}

func (x *BucketingConfig) GetBuckets() []*BucketingConfig_Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Replaces an identifier with a surrogate using Format Preserving Encryption
// (FPE) with the FFX mode of operation; however when used in the
// `ReidentifyContent` API method, it serves the opposite function by reversing
// the surrogate back into the original identifier. The identifier must be
// encoded as ASCII. For a given crypto key and context, the same identifier
// will be replaced with the same surrogate. Identifiers must be at least two
// characters long. In the case that the identifier is the empty string, it will
// be skipped. See https://cloud.google.com/dlp/docs/pseudonymization to learn
// more.
//
// Note: We recommend using  CryptoDeterministicConfig for all use cases which
// do not require preserving the input alphabet space and size, plus warrant
// referential integrity.
type CryptoReplaceFfxFpeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key used by the encryption algorithm.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// The 'tweak', a context may be used for higher security since the same
	// identifier in two different contexts won't be given the same surrogate. If
	// the context is not set, a default tweak will be used.
	//
	// If the context is set but:
	//
	// 1. there is no record present when transforming a given value or
	// 1. the field is not present when transforming a given value,
	//
	// a default tweak will be used.
	//
	// Note that case (1) is expected when an `InfoTypeTransformation` is
	// applied to both structured and non-structured `ContentItem`s.
	// Currently, the referenced field may be of value type integer or string.
	//
	// The tweak is constructed as a sequence of bytes in big endian byte order
	// such that:
	//
	// - a 64 bit integer is encoded followed by a single byte of value 1
	// - a string is encoded in UTF-8 format followed by a single byte of value 2
	Context *FieldId `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
	// Choose an alphabet which the data being transformed will be made up of.
	//
	// Types that are assignable to Alphabet:
	//	*CryptoReplaceFfxFpeConfig_CommonAlphabet
	//	*CryptoReplaceFfxFpeConfig_CustomAlphabet
	//	*CryptoReplaceFfxFpeConfig_Radix
	Alphabet isCryptoReplaceFfxFpeConfig_Alphabet `protobuf_oneof:"alphabet"`
	// The custom infoType to annotate the surrogate with.
	// This annotation will be applied to the surrogate by prefixing it with
	// the name of the custom infoType followed by the number of
	// characters comprising the surrogate. The following scheme defines the
	// format: info_type_name(surrogate_character_count):surrogate
	//
	// For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
	// the surrogate is 'abc', the full replacement value
	// will be: 'MY_TOKEN_INFO_TYPE(3):abc'
	//
	// This annotation identifies the surrogate when inspecting content using the
	// custom infoType
	// [`SurrogateType`](https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#surrogatetype).
	// This facilitates reversal of the surrogate when it occurs in free text.
	//
	// In order for inspection to work properly, the name of this infoType must
	// not occur naturally anywhere in your data; otherwise, inspection may
	// find a surrogate that does not correspond to an actual identifier.
	// Therefore, choose your custom infoType name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data.
	// For example, assuming your data is entered from a regular ASCII keyboard,
	// the symbol with the hex code point 29DD might be used like so:
	// ⧝MY_TOKEN_TYPE
	SurrogateInfoType *InfoType `protobuf:"bytes,8,opt,name=surrogate_info_type,json=surrogateInfoType,proto3" json:"surrogate_info_type,omitempty"`
}

func (x *CryptoReplaceFfxFpeConfig) Reset() {
	*x = CryptoReplaceFfxFpeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoReplaceFfxFpeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoReplaceFfxFpeConfig) ProtoMessage() {}

func (x *CryptoReplaceFfxFpeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoReplaceFfxFpeConfig.ProtoReflect.Descriptor instead.
func (*CryptoReplaceFfxFpeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{59}
}

func (x *CryptoReplaceFfxFpeConfig) GetCryptoKey() *CryptoKey {
	if x != nil {
		return x.CryptoKey
	}
	return nil
}

func (x *CryptoReplaceFfxFpeConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

func (m *CryptoReplaceFfxFpeConfig) GetAlphabet() isCryptoReplaceFfxFpeConfig_Alphabet {
	if m != nil {
		return m.Alphabet
	}
	return nil
}

func (x *CryptoReplaceFfxFpeConfig) GetCommonAlphabet() CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CommonAlphabet); ok {
		return x.CommonAlphabet
	}
	return CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED
}

func (x *CryptoReplaceFfxFpeConfig) GetCustomAlphabet() string {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_CustomAlphabet); ok {
		return x.CustomAlphabet
	}
	return ""
}

func (x *CryptoReplaceFfxFpeConfig) GetRadix() int32 {
	if x, ok := x.GetAlphabet().(*CryptoReplaceFfxFpeConfig_Radix); ok {
		return x.Radix
	}
	return 0
}

func (x *CryptoReplaceFfxFpeConfig) GetSurrogateInfoType() *InfoType {
	if x != nil {
		return x.SurrogateInfoType
	}
	return nil
}

type isCryptoReplaceFfxFpeConfig_Alphabet interface {
	isCryptoReplaceFfxFpeConfig_Alphabet()
}

type CryptoReplaceFfxFpeConfig_CommonAlphabet struct {
	// Common alphabets.
	CommonAlphabet CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet `protobuf:"varint,4,opt,name=common_alphabet,json=commonAlphabet,proto3,enum=google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet,oneof"`
}

type CryptoReplaceFfxFpeConfig_CustomAlphabet struct {
	// This is supported by mapping these to the alphanumeric characters
	// that the FFX mode natively supports. This happens before/after
	// encryption/decryption.
	// Each character listed must appear only once.
	// Number of characters must be in the range [2, 95].
	// This must be encoded as ASCII.
	// The order of characters does not matter.
	CustomAlphabet string `protobuf:"bytes,5,opt,name=custom_alphabet,json=customAlphabet,proto3,oneof"`
}

type CryptoReplaceFfxFpeConfig_Radix struct {
	// The native way to select the alphabet. Must be in the range [2, 95].
	Radix int32 `protobuf:"varint,6,opt,name=radix,proto3,oneof"`
}

func (*CryptoReplaceFfxFpeConfig_CommonAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}

func (*CryptoReplaceFfxFpeConfig_CustomAlphabet) isCryptoReplaceFfxFpeConfig_Alphabet() {}

func (*CryptoReplaceFfxFpeConfig_Radix) isCryptoReplaceFfxFpeConfig_Alphabet() {}

// This is a data encryption key (DEK) (as opposed to
// a key encryption key (KEK) stored by KMS).
// When using KMS to wrap/unwrap DEKs, be sure to set an appropriate
// IAM policy on the KMS CryptoKey (KEK) to ensure an attacker cannot
// unwrap the data crypto key.
type CryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources of crypto keys.
	//
	// Types that are assignable to Source:
	//	*CryptoKey_Transient
	//	*CryptoKey_Unwrapped
	//	*CryptoKey_KmsWrapped
	Source isCryptoKey_Source `protobuf_oneof:"source"`
}

func (x *CryptoKey) Reset() {
	*x = CryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKey) ProtoMessage() {}

func (x *CryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKey.ProtoReflect.Descriptor instead.
func (*CryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{60}
}

func (m *CryptoKey) GetSource() isCryptoKey_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CryptoKey) GetTransient() *TransientCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_Transient); ok {
		return x.Transient
	}
	return nil
}

func (x *CryptoKey) GetUnwrapped() *UnwrappedCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_Unwrapped); ok {
		return x.Unwrapped
	}
	return nil
}

func (x *CryptoKey) GetKmsWrapped() *KmsWrappedCryptoKey {
	if x, ok := x.GetSource().(*CryptoKey_KmsWrapped); ok {
		return x.KmsWrapped
	}
	return nil
}

type isCryptoKey_Source interface {
	isCryptoKey_Source()
}

type CryptoKey_Transient struct {
	// Transient crypto key
	Transient *TransientCryptoKey `protobuf:"bytes,1,opt,name=transient,proto3,oneof"`
}

type CryptoKey_Unwrapped struct {
	// Unwrapped crypto key
	Unwrapped *UnwrappedCryptoKey `protobuf:"bytes,2,opt,name=unwrapped,proto3,oneof"`
}

type CryptoKey_KmsWrapped struct {
	// Kms wrapped key
	KmsWrapped *KmsWrappedCryptoKey `protobuf:"bytes,3,opt,name=kms_wrapped,json=kmsWrapped,proto3,oneof"`
}

func (*CryptoKey_Transient) isCryptoKey_Source() {}

func (*CryptoKey_Unwrapped) isCryptoKey_Source() {}

func (*CryptoKey_KmsWrapped) isCryptoKey_Source() {}

// Use this to have a random data crypto key generated.
// It will be discarded after the request finishes.
type TransientCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the key.
	// This is an arbitrary string used to differentiate different keys.
	// A unique key is generated per name: two separate `TransientCryptoKey`
	// protos share the same generated key if their names are the same.
	// When the data crypto key is generated, this name is not used in any way
	// (repeating the api call will result in a different key being generated).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *TransientCryptoKey) Reset() {
	*x = TransientCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransientCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransientCryptoKey) ProtoMessage() {}

func (x *TransientCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransientCryptoKey.ProtoReflect.Descriptor instead.
func (*TransientCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{61}
}

func (x *TransientCryptoKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Using raw keys is prone to security risks due to accidentally
// leaking the key. Choose another type of key if possible.
type UnwrappedCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A 128/192/256 bit key.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *UnwrappedCryptoKey) Reset() {
	*x = UnwrappedCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnwrappedCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnwrappedCryptoKey) ProtoMessage() {}

func (x *UnwrappedCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnwrappedCryptoKey.ProtoReflect.Descriptor instead.
func (*UnwrappedCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{62}
}

func (x *UnwrappedCryptoKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

// Include to use an existing data crypto key wrapped by KMS.
// The wrapped key must be a 128/192/256 bit key.
// Authorization requires the following IAM permissions when sending a request
// to perform a crypto transformation using a kms-wrapped crypto key:
// dlp.kms.encrypt
type KmsWrappedCryptoKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The wrapped data crypto key.
	WrappedKey []byte `protobuf:"bytes,1,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
	// Required. The resource name of the KMS CryptoKey to use for unwrapping.
	CryptoKeyName string `protobuf:"bytes,2,opt,name=crypto_key_name,json=cryptoKeyName,proto3" json:"crypto_key_name,omitempty"`
}

func (x *KmsWrappedCryptoKey) Reset() {
	*x = KmsWrappedCryptoKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KmsWrappedCryptoKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsWrappedCryptoKey) ProtoMessage() {}

func (x *KmsWrappedCryptoKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsWrappedCryptoKey.ProtoReflect.Descriptor instead.
func (*KmsWrappedCryptoKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{63}
}

func (x *KmsWrappedCryptoKey) GetWrappedKey() []byte {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

func (x *KmsWrappedCryptoKey) GetCryptoKeyName() string {
	if x != nil {
		return x.CryptoKeyName
	}
	return ""
}

// Shifts dates by random number of days, with option to be consistent for the
// same context. See https://cloud.google.com/dlp/docs/concepts-date-shifting
// to learn more.
type DateShiftConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Range of shift in days. Actual shift will be selected at random within this
	// range (inclusive ends). Negative means shift to earlier in time. Must not
	// be more than 365250 days (1000 years) each direction.
	//
	// For example, 3 means shift date to at most 3 days into the future.
	UpperBoundDays int32 `protobuf:"varint,1,opt,name=upper_bound_days,json=upperBoundDays,proto3" json:"upper_bound_days,omitempty"`
	// Required. For example, -5 means shift date to at most 5 days back in the past.
	LowerBoundDays int32 `protobuf:"varint,2,opt,name=lower_bound_days,json=lowerBoundDays,proto3" json:"lower_bound_days,omitempty"`
	// Points to the field that contains the context, for example, an entity id.
	// If set, must also set cryptoKey. If set, shift will be consistent for the
	// given context.
	Context *FieldId `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
	// Method for calculating shift that takes context into consideration. If
	// set, must also set context. Can only be applied to table items.
	//
	// Types that are assignable to Method:
	//	*DateShiftConfig_CryptoKey
	Method isDateShiftConfig_Method `protobuf_oneof:"method"`
}

func (x *DateShiftConfig) Reset() {
	*x = DateShiftConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateShiftConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateShiftConfig) ProtoMessage() {}

func (x *DateShiftConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateShiftConfig.ProtoReflect.Descriptor instead.
func (*DateShiftConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{64}
}

func (x *DateShiftConfig) GetUpperBoundDays() int32 {
	if x != nil {
		return x.UpperBoundDays
	}
	return 0
}

func (x *DateShiftConfig) GetLowerBoundDays() int32 {
	if x != nil {
		return x.LowerBoundDays
	}
	return 0
}

func (x *DateShiftConfig) GetContext() *FieldId {
	if x != nil {
		return x.Context
	}
	return nil
}

func (m *DateShiftConfig) GetMethod() isDateShiftConfig_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (x *DateShiftConfig) GetCryptoKey() *CryptoKey {
	if x, ok := x.GetMethod().(*DateShiftConfig_CryptoKey); ok {
		return x.CryptoKey
	}
	return nil
}

type isDateShiftConfig_Method interface {
	isDateShiftConfig_Method()
}

type DateShiftConfig_CryptoKey struct {
	// Causes the shift to be computed based on this key and the context. This
	// results in the same shift for the same context and crypto_key. If
	// set, must also set context. Can only be applied to table items.
	CryptoKey *CryptoKey `protobuf:"bytes,4,opt,name=crypto_key,json=cryptoKey,proto3,oneof"`
}

func (*DateShiftConfig_CryptoKey) isDateShiftConfig_Method() {}

// A type of transformation that will scan unstructured text and
// apply various `PrimitiveTransformation`s to each finding, where the
// transformation is applied to only values that were identified as a specific
// info_type.
type InfoTypeTransformations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Transformation for each infoType. Cannot specify more than one
	// for a given infoType.
	Transformations []*InfoTypeTransformations_InfoTypeTransformation `protobuf:"bytes,1,rep,name=transformations,proto3" json:"transformations,omitempty"`
}

func (x *InfoTypeTransformations) Reset() {
	*x = InfoTypeTransformations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeTransformations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeTransformations) ProtoMessage() {}

func (x *InfoTypeTransformations) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeTransformations.ProtoReflect.Descriptor instead.
func (*InfoTypeTransformations) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{65}
}

func (x *InfoTypeTransformations) GetTransformations() []*InfoTypeTransformations_InfoTypeTransformation {
	if x != nil {
		return x.Transformations
	}
	return nil
}

// The transformation to apply to the field.
type FieldTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input field(s) to apply the transformation to.
	Fields []*FieldId `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	// Only apply the transformation if the condition evaluates to true for the
	// given `RecordCondition`. The conditions are allowed to reference fields
	// that are not used in the actual transformation.
	//
	// Example Use Cases:
	//
	// - Apply a different bucket transformation to an age column if the zip code
	// column for the same record is within a specific range.
	// - Redact a field if the date of birth field is greater than 85.
	Condition *RecordCondition `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// Transformation to apply. [required]
	//
	// Types that are assignable to Transformation:
	//	*FieldTransformation_PrimitiveTransformation
	//	*FieldTransformation_InfoTypeTransformations
	Transformation isFieldTransformation_Transformation `protobuf_oneof:"transformation"`
}

func (x *FieldTransformation) Reset() {
	*x = FieldTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldTransformation) ProtoMessage() {}

func (x *FieldTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldTransformation.ProtoReflect.Descriptor instead.
func (*FieldTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{66}
}

func (x *FieldTransformation) GetFields() []*FieldId {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *FieldTransformation) GetCondition() *RecordCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (m *FieldTransformation) GetTransformation() isFieldTransformation_Transformation {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (x *FieldTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if x, ok := x.GetTransformation().(*FieldTransformation_PrimitiveTransformation); ok {
		return x.PrimitiveTransformation
	}
	return nil
}

func (x *FieldTransformation) GetInfoTypeTransformations() *InfoTypeTransformations {
	if x, ok := x.GetTransformation().(*FieldTransformation_InfoTypeTransformations); ok {
		return x.InfoTypeTransformations
	}
	return nil
}

type isFieldTransformation_Transformation interface {
	isFieldTransformation_Transformation()
}

type FieldTransformation_PrimitiveTransformation struct {
	// Apply the transformation to the entire field.
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,4,opt,name=primitive_transformation,json=primitiveTransformation,proto3,oneof"`
}

type FieldTransformation_InfoTypeTransformations struct {
	// Treat the contents of the field as free text, and selectively
	// transform content that matches an `InfoType`.
	InfoTypeTransformations *InfoTypeTransformations `protobuf:"bytes,5,opt,name=info_type_transformations,json=infoTypeTransformations,proto3,oneof"`
}

func (*FieldTransformation_PrimitiveTransformation) isFieldTransformation_Transformation() {}

func (*FieldTransformation_InfoTypeTransformations) isFieldTransformation_Transformation() {}

// A type of transformation that is applied over structured data such as a
// table.
type RecordTransformations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transform the record by applying various field transformations.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,1,rep,name=field_transformations,json=fieldTransformations,proto3" json:"field_transformations,omitempty"`
	// Configuration defining which records get suppressed entirely. Records that
	// match any suppression rule are omitted from the output.
	RecordSuppressions []*RecordSuppression `protobuf:"bytes,2,rep,name=record_suppressions,json=recordSuppressions,proto3" json:"record_suppressions,omitempty"`
}

func (x *RecordTransformations) Reset() {
	*x = RecordTransformations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordTransformations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordTransformations) ProtoMessage() {}

func (x *RecordTransformations) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordTransformations.ProtoReflect.Descriptor instead.
func (*RecordTransformations) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{67}
}

func (x *RecordTransformations) GetFieldTransformations() []*FieldTransformation {
	if x != nil {
		return x.FieldTransformations
	}
	return nil
}

func (x *RecordTransformations) GetRecordSuppressions() []*RecordSuppression {
	if x != nil {
		return x.RecordSuppressions
	}
	return nil
}

// Configuration to suppress records whose suppression conditions evaluate to
// true.
type RecordSuppression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A condition that when it evaluates to true will result in the record being
	// evaluated to be suppressed from the transformed content.
	Condition *RecordCondition `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *RecordSuppression) Reset() {
	*x = RecordSuppression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordSuppression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordSuppression) ProtoMessage() {}

func (x *RecordSuppression) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordSuppression.ProtoReflect.Descriptor instead.
func (*RecordSuppression) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{68}
}

func (x *RecordSuppression) GetCondition() *RecordCondition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// A condition for determining whether a transformation should be applied to
// a field.
type RecordCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression.
	Expressions *RecordCondition_Expressions `protobuf:"bytes,3,opt,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *RecordCondition) Reset() {
	*x = RecordCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition) ProtoMessage() {}

func (x *RecordCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition.ProtoReflect.Descriptor instead.
func (*RecordCondition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69}
}

func (x *RecordCondition) GetExpressions() *RecordCondition_Expressions {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// Overview of the modifications that occurred.
type TransformationOverview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,2,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
	// Transformations applied to the dataset.
	TransformationSummaries []*TransformationSummary `protobuf:"bytes,3,rep,name=transformation_summaries,json=transformationSummaries,proto3" json:"transformation_summaries,omitempty"`
}

func (x *TransformationOverview) Reset() {
	*x = TransformationOverview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationOverview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationOverview) ProtoMessage() {}

func (x *TransformationOverview) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationOverview.ProtoReflect.Descriptor instead.
func (*TransformationOverview) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{70}
}

func (x *TransformationOverview) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

func (x *TransformationOverview) GetTransformationSummaries() []*TransformationSummary {
	if x != nil {
		return x.TransformationSummaries
	}
	return nil
}

// Summary of a single transformation.
// Only one of 'transformation', 'field_transformation', or 'record_suppress'
// will be set.
type TransformationSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set if the transformation was limited to a specific InfoType.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Set if the transformation was limited to a specific FieldId.
	Field *FieldId `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// The specific transformation these stats apply to.
	Transformation *PrimitiveTransformation `protobuf:"bytes,3,opt,name=transformation,proto3" json:"transformation,omitempty"`
	// The field transformation that was applied.
	// If multiple field transformations are requested for a single field,
	// this list will contain all of them; otherwise, only one is supplied.
	FieldTransformations []*FieldTransformation `protobuf:"bytes,5,rep,name=field_transformations,json=fieldTransformations,proto3" json:"field_transformations,omitempty"`
	// The specific suppression option these stats apply to.
	RecordSuppress *RecordSuppression `protobuf:"bytes,6,opt,name=record_suppress,json=recordSuppress,proto3" json:"record_suppress,omitempty"`
	// Collection of all transformations that took place or had an error.
	Results []*TransformationSummary_SummaryResult `protobuf:"bytes,4,rep,name=results,proto3" json:"results,omitempty"`
	// Total size in bytes that were transformed in some way.
	TransformedBytes int64 `protobuf:"varint,7,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
}

func (x *TransformationSummary) Reset() {
	*x = TransformationSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationSummary) ProtoMessage() {}

func (x *TransformationSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationSummary.ProtoReflect.Descriptor instead.
func (*TransformationSummary) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{71}
}

func (x *TransformationSummary) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *TransformationSummary) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *TransformationSummary) GetTransformation() *PrimitiveTransformation {
	if x != nil {
		return x.Transformation
	}
	return nil
}

func (x *TransformationSummary) GetFieldTransformations() []*FieldTransformation {
	if x != nil {
		return x.FieldTransformations
	}
	return nil
}

func (x *TransformationSummary) GetRecordSuppress() *RecordSuppression {
	if x != nil {
		return x.RecordSuppress
	}
	return nil
}

func (x *TransformationSummary) GetResults() []*TransformationSummary_SummaryResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *TransformationSummary) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

// Schedule for triggeredJobs.
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Option:
	//	*Schedule_RecurrencePeriodDuration
	Option isSchedule_Option `protobuf_oneof:"option"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{72}
}

func (m *Schedule) GetOption() isSchedule_Option {
	if m != nil {
		return m.Option
	}
	return nil
}

func (x *Schedule) GetRecurrencePeriodDuration() *durationpb.Duration {
	if x, ok := x.GetOption().(*Schedule_RecurrencePeriodDuration); ok {
		return x.RecurrencePeriodDuration
	}
	return nil
}

type isSchedule_Option interface {
	isSchedule_Option()
}

type Schedule_RecurrencePeriodDuration struct {
	// With this option a job is started a regular periodic basis. For
	// example: every day (86400 seconds).
	//
	// A scheduled start time will be skipped if the previous
	// execution has not ended when its scheduled time occurs.
	//
	// This value must be set to a time duration greater than or equal
	// to 1 day and can be no longer than 60 days.
	RecurrencePeriodDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=recurrence_period_duration,json=recurrencePeriodDuration,proto3,oneof"`
}

func (*Schedule_RecurrencePeriodDuration) isSchedule_Option() {}

// Job trigger option for hybrid jobs. Jobs must be manually created
// and finished.
type Manual struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Manual) Reset() {
	*x = Manual{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manual) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manual) ProtoMessage() {}

func (x *Manual) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manual.ProtoReflect.Descriptor instead.
func (*Manual) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{73}
}

// The inspectTemplate contains a configuration (set of types of sensitive data
// to be detected) to be used anywhere you otherwise would normally specify
// InspectConfig. See https://cloud.google.com/dlp/docs/concepts-templates
// to learn more.
type InspectTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The template name.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of an inspectTemplate.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of an inspectTemplate.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The core content of the template. Configuration of the scanning process.
	InspectConfig *InspectConfig `protobuf:"bytes,6,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
}

func (x *InspectTemplate) Reset() {
	*x = InspectTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectTemplate) ProtoMessage() {}

func (x *InspectTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectTemplate.ProtoReflect.Descriptor instead.
func (*InspectTemplate) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{74}
}

func (x *InspectTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InspectTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InspectTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InspectTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InspectTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InspectTemplate) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

// DeidentifyTemplates contains instructions on how to de-identify content.
// See https://cloud.google.com/dlp/docs/concepts-templates to learn more.
type DeidentifyTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The template name.
	//
	// The template will have one of the following formats:
	// `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 256 chars).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Short description (max 256 chars).
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of an inspectTemplate.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of an inspectTemplate.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// ///////////// // The core content of the template  // ///////////////
	DeidentifyConfig *DeidentifyConfig `protobuf:"bytes,6,opt,name=deidentify_config,json=deidentifyConfig,proto3" json:"deidentify_config,omitempty"`
}

func (x *DeidentifyTemplate) Reset() {
	*x = DeidentifyTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeidentifyTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeidentifyTemplate) ProtoMessage() {}

func (x *DeidentifyTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeidentifyTemplate.ProtoReflect.Descriptor instead.
func (*DeidentifyTemplate) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{75}
}

func (x *DeidentifyTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeidentifyTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DeidentifyTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DeidentifyTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeidentifyTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DeidentifyTemplate) GetDeidentifyConfig() *DeidentifyConfig {
	if x != nil {
		return x.DeidentifyConfig
	}
	return nil
}

// Details information about an error encountered during job execution or
// the results of an unsuccessful activation of the JobTrigger.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detailed error codes and messages.
	Details *status.Status `protobuf:"bytes,1,opt,name=details,proto3" json:"details,omitempty"`
	// The times the error occurred.
	Timestamps []*timestamppb.Timestamp `protobuf:"bytes,2,rep,name=timestamps,proto3" json:"timestamps,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{76}
}

func (x *Error) GetDetails() *status.Status {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Error) GetTimestamps() []*timestamppb.Timestamp {
	if x != nil {
		return x.Timestamps
	}
	return nil
}

// Contains a configuration to make dlp api calls on a repeating basis.
// See https://cloud.google.com/dlp/docs/concepts-job-triggers to learn more.
type JobTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique resource name for the triggeredJob, assigned by the service when the
	// triggeredJob is created, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name (max 100 chars)
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User provided description (max 256 chars)
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration details for the specific type of job to run.
	//
	// Types that are assignable to Job:
	//	*JobTrigger_InspectJob
	Job isJobTrigger_Job `protobuf_oneof:"job"`
	// A list of triggers which will be OR'ed together. Only one in the list
	// needs to trigger for a job to be started. The list may contain only
	// a single Schedule trigger and must have at least one object.
	Triggers []*JobTrigger_Trigger `protobuf:"bytes,5,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Output only. A stream of errors encountered when the trigger was activated. Repeated
	// errors may result in the JobTrigger automatically being paused.
	// Will return the last 100 errors. Whenever the JobTrigger is modified
	// this list will be cleared.
	Errors []*Error `protobuf:"bytes,6,rep,name=errors,proto3" json:"errors,omitempty"`
	// Output only. The creation timestamp of a triggeredJob.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a triggeredJob.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The timestamp of the last time this trigger executed.
	LastRunTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=last_run_time,json=lastRunTime,proto3" json:"last_run_time,omitempty"`
	// Required. A status for this trigger.
	Status JobTrigger_Status `protobuf:"varint,10,opt,name=status,proto3,enum=google.privacy.dlp.v2.JobTrigger_Status" json:"status,omitempty"`
}

func (x *JobTrigger) Reset() {
	*x = JobTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTrigger) ProtoMessage() {}

func (x *JobTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTrigger.ProtoReflect.Descriptor instead.
func (*JobTrigger) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{77}
}

func (x *JobTrigger) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobTrigger) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *JobTrigger) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *JobTrigger) GetJob() isJobTrigger_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (x *JobTrigger) GetInspectJob() *InspectJobConfig {
	if x, ok := x.GetJob().(*JobTrigger_InspectJob); ok {
		return x.InspectJob
	}
	return nil
}

func (x *JobTrigger) GetTriggers() []*JobTrigger_Trigger {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *JobTrigger) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *JobTrigger) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *JobTrigger) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *JobTrigger) GetLastRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRunTime
	}
	return nil
}

func (x *JobTrigger) GetStatus() JobTrigger_Status {
	if x != nil {
		return x.Status
	}
	return JobTrigger_STATUS_UNSPECIFIED
}

type isJobTrigger_Job interface {
	isJobTrigger_Job()
}

type JobTrigger_InspectJob struct {
	// For inspect jobs, a snapshot of the configuration.
	InspectJob *InspectJobConfig `protobuf:"bytes,4,opt,name=inspect_job,json=inspectJob,proto3,oneof"`
}

func (*JobTrigger_InspectJob) isJobTrigger_Job() {}

// A task to execute on the completion of a job.
// See https://cloud.google.com/dlp/docs/concepts-actions to learn more.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Action:
	//	*Action_SaveFindings_
	//	*Action_PubSub
	//	*Action_PublishSummaryToCscc_
	//	*Action_PublishFindingsToCloudDataCatalog_
	//	*Action_JobNotificationEmails_
	//	*Action_PublishToStackdriver_
	Action isAction_Action `protobuf_oneof:"action"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78}
}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Action) GetSaveFindings() *Action_SaveFindings {
	if x, ok := x.GetAction().(*Action_SaveFindings_); ok {
		return x.SaveFindings
	}
	return nil
}

func (x *Action) GetPubSub() *Action_PublishToPubSub {
	if x, ok := x.GetAction().(*Action_PubSub); ok {
		return x.PubSub
	}
	return nil
}

func (x *Action) GetPublishSummaryToCscc() *Action_PublishSummaryToCscc {
	if x, ok := x.GetAction().(*Action_PublishSummaryToCscc_); ok {
		return x.PublishSummaryToCscc
	}
	return nil
}

func (x *Action) GetPublishFindingsToCloudDataCatalog() *Action_PublishFindingsToCloudDataCatalog {
	if x, ok := x.GetAction().(*Action_PublishFindingsToCloudDataCatalog_); ok {
		return x.PublishFindingsToCloudDataCatalog
	}
	return nil
}

func (x *Action) GetJobNotificationEmails() *Action_JobNotificationEmails {
	if x, ok := x.GetAction().(*Action_JobNotificationEmails_); ok {
		return x.JobNotificationEmails
	}
	return nil
}

func (x *Action) GetPublishToStackdriver() *Action_PublishToStackdriver {
	if x, ok := x.GetAction().(*Action_PublishToStackdriver_); ok {
		return x.PublishToStackdriver
	}
	return nil
}

type isAction_Action interface {
	isAction_Action()
}

type Action_SaveFindings_ struct {
	// Save resulting findings in a provided location.
	SaveFindings *Action_SaveFindings `protobuf:"bytes,1,opt,name=save_findings,json=saveFindings,proto3,oneof"`
}

type Action_PubSub struct {
	// Publish a notification to a pubsub topic.
	PubSub *Action_PublishToPubSub `protobuf:"bytes,2,opt,name=pub_sub,json=pubSub,proto3,oneof"`
}

type Action_PublishSummaryToCscc_ struct {
	// Publish summary to Cloud Security Command Center (Alpha).
	PublishSummaryToCscc *Action_PublishSummaryToCscc `protobuf:"bytes,3,opt,name=publish_summary_to_cscc,json=publishSummaryToCscc,proto3,oneof"`
}

type Action_PublishFindingsToCloudDataCatalog_ struct {
	// Publish findings to Cloud Datahub.
	PublishFindingsToCloudDataCatalog *Action_PublishFindingsToCloudDataCatalog `protobuf:"bytes,5,opt,name=publish_findings_to_cloud_data_catalog,json=publishFindingsToCloudDataCatalog,proto3,oneof"`
}

type Action_JobNotificationEmails_ struct {
	// Enable email notification for project owners and editors on job's
	// completion/failure.
	JobNotificationEmails *Action_JobNotificationEmails `protobuf:"bytes,8,opt,name=job_notification_emails,json=jobNotificationEmails,proto3,oneof"`
}

type Action_PublishToStackdriver_ struct {
	// Enable Stackdriver metric dlp.googleapis.com/finding_count.
	PublishToStackdriver *Action_PublishToStackdriver `protobuf:"bytes,9,opt,name=publish_to_stackdriver,json=publishToStackdriver,proto3,oneof"`
}

func (*Action_SaveFindings_) isAction_Action() {}

func (*Action_PubSub) isAction_Action() {}

func (*Action_PublishSummaryToCscc_) isAction_Action() {}

func (*Action_PublishFindingsToCloudDataCatalog_) isAction_Action() {}

func (*Action_JobNotificationEmails_) isAction_Action() {}

func (*Action_PublishToStackdriver_) isAction_Action() {}

// Request message for CreateInspectTemplate.
type CreateInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The InspectTemplate to create.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateInspectTemplateRequest) Reset() {
	*x = CreateInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInspectTemplateRequest) ProtoMessage() {}

func (x *CreateInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{79}
}

func (x *CreateInspectTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.InspectTemplate
	}
	return nil
}

func (x *CreateInspectTemplateRequest) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

func (x *CreateInspectTemplateRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateInspectTemplate.
type UpdateInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and inspectTemplate to be updated, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New InspectTemplate value.
	InspectTemplate *InspectTemplate `protobuf:"bytes,2,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateInspectTemplateRequest) Reset() {
	*x = UpdateInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInspectTemplateRequest) ProtoMessage() {}

func (x *UpdateInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{80}
}

func (x *UpdateInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateInspectTemplateRequest) GetInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.InspectTemplate
	}
	return nil
}

func (x *UpdateInspectTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetInspectTemplate.
type GetInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and inspectTemplate to be read, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInspectTemplateRequest) Reset() {
	*x = GetInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInspectTemplateRequest) ProtoMessage() {}

func (x *GetInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{81}
}

func (x *GetInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListInspectTemplates.
type ListInspectTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from previous call
	// to `ListInspectTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page, can be limited by server. If zero server returns
	// a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case-insensitive,
	// default sorting order is ascending, redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to time the template was created.
	// - `update_time`: corresponds to time the template was last updated.
	// - `name`: corresponds to template's name.
	// - `display_name`: corresponds to template's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListInspectTemplatesRequest) Reset() {
	*x = ListInspectTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInspectTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInspectTemplatesRequest) ProtoMessage() {}

func (x *ListInspectTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInspectTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListInspectTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{82}
}

func (x *ListInspectTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInspectTemplatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListInspectTemplatesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListInspectTemplates.
type ListInspectTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of inspectTemplates, up to page_size in ListInspectTemplatesRequest.
	InspectTemplates []*InspectTemplate `protobuf:"bytes,1,rep,name=inspect_templates,json=inspectTemplates,proto3" json:"inspect_templates,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListInspectTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInspectTemplatesResponse) Reset() {
	*x = ListInspectTemplatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInspectTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInspectTemplatesResponse) ProtoMessage() {}

func (x *ListInspectTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInspectTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListInspectTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{83}
}

func (x *ListInspectTemplatesResponse) GetInspectTemplates() []*InspectTemplate {
	if x != nil {
		return x.InspectTemplates
	}
	return nil
}

func (x *ListInspectTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteInspectTemplate.
type DeleteInspectTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and inspectTemplate to be deleted, for
	// example `organizations/433245324/inspectTemplates/432452342` or
	// projects/project-id/inspectTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteInspectTemplateRequest) Reset() {
	*x = DeleteInspectTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInspectTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInspectTemplateRequest) ProtoMessage() {}

func (x *DeleteInspectTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInspectTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteInspectTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{84}
}

func (x *DeleteInspectTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateJobTrigger.
type CreateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The JobTrigger to create.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger,proto3" json:"job_trigger,omitempty"`
	// The trigger id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TriggerId string `protobuf:"bytes,3,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateJobTriggerRequest) Reset() {
	*x = CreateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobTriggerRequest) ProtoMessage() {}

func (x *CreateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*CreateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{85}
}

func (x *CreateJobTriggerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if x != nil {
		return x.JobTrigger
	}
	return nil
}

func (x *CreateJobTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *CreateJobTriggerRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for ActivateJobTrigger.
type ActivateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the trigger to activate, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ActivateJobTriggerRequest) Reset() {
	*x = ActivateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActivateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateJobTriggerRequest) ProtoMessage() {}

func (x *ActivateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*ActivateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{86}
}

func (x *ActivateJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateJobTrigger.
type UpdateJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New JobTrigger value.
	JobTrigger *JobTrigger `protobuf:"bytes,2,opt,name=job_trigger,json=jobTrigger,proto3" json:"job_trigger,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateJobTriggerRequest) Reset() {
	*x = UpdateJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateJobTriggerRequest) ProtoMessage() {}

func (x *UpdateJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*UpdateJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{87}
}

func (x *UpdateJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateJobTriggerRequest) GetJobTrigger() *JobTrigger {
	if x != nil {
		return x.JobTrigger
	}
	return nil
}

func (x *UpdateJobTriggerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetJobTrigger.
type GetJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobTriggerRequest) Reset() {
	*x = GetJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobTriggerRequest) ProtoMessage() {}

func (x *GetJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*GetJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{88}
}

func (x *GetJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDlpJobRequest. Used to initiate long running
// jobs such as calculating risk metrics or inspecting Google Cloud
// Storage.
type CreateDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration details for the specific type of job to run.
	//
	// Types that are assignable to Job:
	//	*CreateDlpJobRequest_InspectJob
	//	*CreateDlpJobRequest_RiskJob
	Job isCreateDlpJobRequest_Job `protobuf_oneof:"job"`
	// The job id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	JobId string `protobuf:"bytes,4,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateDlpJobRequest) Reset() {
	*x = CreateDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDlpJobRequest) ProtoMessage() {}

func (x *CreateDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDlpJobRequest.ProtoReflect.Descriptor instead.
func (*CreateDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{89}
}

func (x *CreateDlpJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *CreateDlpJobRequest) GetJob() isCreateDlpJobRequest_Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (x *CreateDlpJobRequest) GetInspectJob() *InspectJobConfig {
	if x, ok := x.GetJob().(*CreateDlpJobRequest_InspectJob); ok {
		return x.InspectJob
	}
	return nil
}

func (x *CreateDlpJobRequest) GetRiskJob() *RiskAnalysisJobConfig {
	if x, ok := x.GetJob().(*CreateDlpJobRequest_RiskJob); ok {
		return x.RiskJob
	}
	return nil
}

func (x *CreateDlpJobRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *CreateDlpJobRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

type isCreateDlpJobRequest_Job interface {
	isCreateDlpJobRequest_Job()
}

type CreateDlpJobRequest_InspectJob struct {
	// Set to control what and how to inspect.
	InspectJob *InspectJobConfig `protobuf:"bytes,2,opt,name=inspect_job,json=inspectJob,proto3,oneof"`
}

type CreateDlpJobRequest_RiskJob struct {
	// Set to choose what metric to calculate.
	RiskJob *RiskAnalysisJobConfig `protobuf:"bytes,3,opt,name=risk_job,json=riskJob,proto3,oneof"`
}

func (*CreateDlpJobRequest_InspectJob) isCreateDlpJobRequest_Job() {}

func (*CreateDlpJobRequest_RiskJob) isCreateDlpJobRequest_Job() {}

// Request message for ListJobTriggers.
type ListJobTriggersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from previous call
	// to ListJobTriggers. `order_by` field must not
	// change for subsequent calls.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page, can be limited by a server.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of triggeredJob fields to order by,
	// followed by `asc` or `desc` postfix. This list is case-insensitive,
	// default sorting order is ascending, redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to time the JobTrigger was created.
	// - `update_time`: corresponds to time the JobTrigger was last updated.
	// - `last_run_time`: corresponds to the last time the JobTrigger ran.
	// - `name`: corresponds to JobTrigger's name.
	// - `display_name`: corresponds to JobTrigger's display name.
	// - `status`: corresponds to JobTrigger's status.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values for inspect jobs:
	//     - `status` - HEALTHY|PAUSED|CANCELLED
	//     - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
	//     - 'last_run_time` - RFC 3339 formatted timestamp, surrounded by
	//     quotation marks. Nanoseconds are ignored.
	//     - 'error_count' - Number of errors that have occurred while running.
	// * The operator must be `=` or `!=` for status and inspected_storage.
	//
	// Examples:
	//
	// * inspected_storage = cloud_storage AND status = HEALTHY
	// * inspected_storage = cloud_storage OR inspected_storage = bigquery
	// * inspected_storage = cloud_storage AND (state = PAUSED OR state = HEALTHY)
	// * last_run_time > \"2017-12-12T00:00:00+00:00\"
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListJobTriggersRequest) Reset() {
	*x = ListJobTriggersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobTriggersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobTriggersRequest) ProtoMessage() {}

func (x *ListJobTriggersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobTriggersRequest.ProtoReflect.Descriptor instead.
func (*ListJobTriggersRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{90}
}

func (x *ListJobTriggersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobTriggersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobTriggersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobTriggersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListJobTriggersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobTriggersRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListJobTriggers.
type ListJobTriggersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of triggeredJobs, up to page_size in ListJobTriggersRequest.
	JobTriggers []*JobTrigger `protobuf:"bytes,1,rep,name=job_triggers,json=jobTriggers,proto3" json:"job_triggers,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListJobTriggers request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListJobTriggersResponse) Reset() {
	*x = ListJobTriggersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobTriggersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobTriggersResponse) ProtoMessage() {}

func (x *ListJobTriggersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobTriggersResponse.ProtoReflect.Descriptor instead.
func (*ListJobTriggersResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{91}
}

func (x *ListJobTriggersResponse) GetJobTriggers() []*JobTrigger {
	if x != nil {
		return x.JobTriggers
	}
	return nil
}

func (x *ListJobTriggersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteJobTrigger.
type DeleteJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project and the triggeredJob, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteJobTriggerRequest) Reset() {
	*x = DeleteJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteJobTriggerRequest) ProtoMessage() {}

func (x *DeleteJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*DeleteJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{92}
}

func (x *DeleteJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Controls what and how to inspect for findings.
type InspectJobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data to scan.
	StorageConfig *StorageConfig `protobuf:"bytes,1,opt,name=storage_config,json=storageConfig,proto3" json:"storage_config,omitempty"`
	// How and what to scan for.
	InspectConfig *InspectConfig `protobuf:"bytes,2,opt,name=inspect_config,json=inspectConfig,proto3" json:"inspect_config,omitempty"`
	// If provided, will be used as the default for all values in InspectConfig.
	// `inspect_config` will be merged into the values persisted as part of the
	// template.
	InspectTemplateName string `protobuf:"bytes,3,opt,name=inspect_template_name,json=inspectTemplateName,proto3" json:"inspect_template_name,omitempty"`
	// Actions to execute at the completion of the job.
	Actions []*Action `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *InspectJobConfig) Reset() {
	*x = InspectJobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectJobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectJobConfig) ProtoMessage() {}

func (x *InspectJobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectJobConfig.ProtoReflect.Descriptor instead.
func (*InspectJobConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{93}
}

func (x *InspectJobConfig) GetStorageConfig() *StorageConfig {
	if x != nil {
		return x.StorageConfig
	}
	return nil
}

func (x *InspectJobConfig) GetInspectConfig() *InspectConfig {
	if x != nil {
		return x.InspectConfig
	}
	return nil
}

func (x *InspectJobConfig) GetInspectTemplateName() string {
	if x != nil {
		return x.InspectTemplateName
	}
	return ""
}

func (x *InspectJobConfig) GetActions() []*Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Combines all of the information about a DLP job.
type DlpJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-assigned name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of job.
	Type DlpJobType `protobuf:"varint,2,opt,name=type,proto3,enum=google.privacy.dlp.v2.DlpJobType" json:"type,omitempty"`
	// State of a job.
	State DlpJob_JobState `protobuf:"varint,3,opt,name=state,proto3,enum=google.privacy.dlp.v2.DlpJob_JobState" json:"state,omitempty"`
	// Types that are assignable to Details:
	//	*DlpJob_RiskDetails
	//	*DlpJob_InspectDetails
	Details isDlpJob_Details `protobuf_oneof:"details"`
	// Time when the job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the job started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time when the job finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// If created by a job trigger, the resource name of the trigger that
	// instantiated the job.
	JobTriggerName string `protobuf:"bytes,10,opt,name=job_trigger_name,json=jobTriggerName,proto3" json:"job_trigger_name,omitempty"`
	// A stream of errors encountered running the job.
	Errors []*Error `protobuf:"bytes,11,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *DlpJob) Reset() {
	*x = DlpJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DlpJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DlpJob) ProtoMessage() {}

func (x *DlpJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DlpJob.ProtoReflect.Descriptor instead.
func (*DlpJob) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{94}
}

func (x *DlpJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DlpJob) GetType() DlpJobType {
	if x != nil {
		return x.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (x *DlpJob) GetState() DlpJob_JobState {
	if x != nil {
		return x.State
	}
	return DlpJob_JOB_STATE_UNSPECIFIED
}

func (m *DlpJob) GetDetails() isDlpJob_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *DlpJob) GetRiskDetails() *AnalyzeDataSourceRiskDetails {
	if x, ok := x.GetDetails().(*DlpJob_RiskDetails); ok {
		return x.RiskDetails
	}
	return nil
}

func (x *DlpJob) GetInspectDetails() *InspectDataSourceDetails {
	if x, ok := x.GetDetails().(*DlpJob_InspectDetails); ok {
		return x.InspectDetails
	}
	return nil
}

func (x *DlpJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DlpJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DlpJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *DlpJob) GetJobTriggerName() string {
	if x != nil {
		return x.JobTriggerName
	}
	return ""
}

func (x *DlpJob) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

type isDlpJob_Details interface {
	isDlpJob_Details()
}

type DlpJob_RiskDetails struct {
	// Results from analyzing risk of a data source.
	RiskDetails *AnalyzeDataSourceRiskDetails `protobuf:"bytes,4,opt,name=risk_details,json=riskDetails,proto3,oneof"`
}

type DlpJob_InspectDetails struct {
	// Results from inspecting a data source.
	InspectDetails *InspectDataSourceDetails `protobuf:"bytes,5,opt,name=inspect_details,json=inspectDetails,proto3,oneof"`
}

func (*DlpJob_RiskDetails) isDlpJob_Details() {}

func (*DlpJob_InspectDetails) isDlpJob_Details() {}

// The request message for [DlpJobs.GetDlpJob][].
type GetDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDlpJobRequest) Reset() {
	*x = GetDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDlpJobRequest) ProtoMessage() {}

func (x *GetDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDlpJobRequest.ProtoReflect.Descriptor instead.
func (*GetDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{95}
}

func (x *GetDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for listing DLP jobs.
type ListDlpJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Allows filtering.
	//
	// Supported syntax:
	//
	// * Filter expressions are made up of one or more restrictions.
	// * Restrictions can be combined by `AND` or `OR` logical operators. A
	// sequence of restrictions implicitly uses `AND`.
	// * A restriction has the form of `{field} {operator} {value}`.
	// * Supported fields/values for inspect jobs:
	//     - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
	//     - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
	//     - `trigger_name` - The resource name of the trigger that created job.
	//     - 'end_time` - Corresponds to time the job finished.
	//     - 'start_time` - Corresponds to time the job finished.
	// * Supported fields for risk analysis jobs:
	//     - `state` - RUNNING|CANCELED|FINISHED|FAILED
	//     - 'end_time` - Corresponds to time the job finished.
	//     - 'start_time` - Corresponds to time the job finished.
	// * The operator must be `=` or `!=`.
	//
	// Examples:
	//
	// * inspected_storage = cloud_storage AND state = done
	// * inspected_storage = cloud_storage OR inspected_storage = bigquery
	// * inspected_storage = cloud_storage AND (state = done OR state = canceled)
	// * end_time > \"2017-12-12T00:00:00+00:00\"
	//
	// The length of this field should be no more than 500 characters.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The type of job. Defaults to `DlpJobType.INSPECT`
	Type DlpJobType `protobuf:"varint,5,opt,name=type,proto3,enum=google.privacy.dlp.v2.DlpJobType" json:"type,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case-insensitive,
	// default sorting order is ascending, redundant space characters are
	// insignificant.
	//
	// Example: `name asc, end_time asc, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to time the job was created.
	// - `end_time`: corresponds to time the job ended.
	// - `name`: corresponds to job's name.
	// - `state`: corresponds to `state`
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListDlpJobsRequest) Reset() {
	*x = ListDlpJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDlpJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDlpJobsRequest) ProtoMessage() {}

func (x *ListDlpJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDlpJobsRequest.ProtoReflect.Descriptor instead.
func (*ListDlpJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{96}
}

func (x *ListDlpJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDlpJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDlpJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDlpJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDlpJobsRequest) GetType() DlpJobType {
	if x != nil {
		return x.Type
	}
	return DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
}

func (x *ListDlpJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListDlpJobsRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// The response message for listing DLP jobs.
type ListDlpJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of DlpJobs that matches the specified filter in the request.
	Jobs []*DlpJob `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDlpJobsResponse) Reset() {
	*x = ListDlpJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDlpJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDlpJobsResponse) ProtoMessage() {}

func (x *ListDlpJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDlpJobsResponse.ProtoReflect.Descriptor instead.
func (*ListDlpJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{97}
}

func (x *ListDlpJobsResponse) GetJobs() []*DlpJob {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *ListDlpJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for canceling a DLP job.
type CancelDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be cancelled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDlpJobRequest) Reset() {
	*x = CancelDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDlpJobRequest) ProtoMessage() {}

func (x *CancelDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDlpJobRequest.ProtoReflect.Descriptor instead.
func (*CancelDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{98}
}

func (x *CancelDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for finishing a DLP hybrid job.
type FinishDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be cancelled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FinishDlpJobRequest) Reset() {
	*x = FinishDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinishDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinishDlpJobRequest) ProtoMessage() {}

func (x *FinishDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinishDlpJobRequest.ProtoReflect.Descriptor instead.
func (*FinishDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{99}
}

func (x *FinishDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for deleting a DLP job.
type DeleteDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DlpJob resource to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDlpJobRequest) Reset() {
	*x = DeleteDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDlpJobRequest) ProtoMessage() {}

func (x *DeleteDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDlpJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{100}
}

func (x *DeleteDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDeidentifyTemplate.
type CreateDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DeidentifyTemplate to create.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	TemplateId string `protobuf:"bytes,3,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateDeidentifyTemplateRequest) Reset() {
	*x = CreateDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeidentifyTemplateRequest) ProtoMessage() {}

func (x *CreateDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{101}
}

func (x *CreateDeidentifyTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return nil
}

func (x *CreateDeidentifyTemplateRequest) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

func (x *CreateDeidentifyTemplateRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateDeidentifyTemplate.
type UpdateDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and deidentify template to be updated, for
	// example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New DeidentifyTemplate value.
	DeidentifyTemplate *DeidentifyTemplate `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDeidentifyTemplateRequest) Reset() {
	*x = UpdateDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeidentifyTemplateRequest) ProtoMessage() {}

func (x *UpdateDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{102}
}

func (x *UpdateDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateDeidentifyTemplateRequest) GetDeidentifyTemplate() *DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return nil
}

func (x *UpdateDeidentifyTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDeidentifyTemplate.
type GetDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and deidentify template to be read, for
	// example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeidentifyTemplateRequest) Reset() {
	*x = GetDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeidentifyTemplateRequest) ProtoMessage() {}

func (x *GetDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{103}
}

func (x *GetDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from previous call
	// to `ListDeidentifyTemplates`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page, can be limited by server. If zero server returns
	// a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case-insensitive,
	// default sorting order is ascending, redundant space characters are
	// insignificant.
	//
	// Example: `name asc,update_time, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to time the template was created.
	// - `update_time`: corresponds to time the template was last updated.
	// - `name`: corresponds to template's name.
	// - `display_name`: corresponds to template's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListDeidentifyTemplatesRequest) Reset() {
	*x = ListDeidentifyTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeidentifyTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeidentifyTemplatesRequest) ProtoMessage() {}

func (x *ListDeidentifyTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeidentifyTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListDeidentifyTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{104}
}

func (x *ListDeidentifyTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeidentifyTemplatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListDeidentifyTemplatesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListDeidentifyTemplates.
type ListDeidentifyTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of deidentify templates, up to page_size in
	// ListDeidentifyTemplatesRequest.
	DeidentifyTemplates []*DeidentifyTemplate `protobuf:"bytes,1,rep,name=deidentify_templates,json=deidentifyTemplates,proto3" json:"deidentify_templates,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListDeidentifyTemplates request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeidentifyTemplatesResponse) Reset() {
	*x = ListDeidentifyTemplatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeidentifyTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeidentifyTemplatesResponse) ProtoMessage() {}

func (x *ListDeidentifyTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeidentifyTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListDeidentifyTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{105}
}

func (x *ListDeidentifyTemplatesResponse) GetDeidentifyTemplates() []*DeidentifyTemplate {
	if x != nil {
		return x.DeidentifyTemplates
	}
	return nil
}

func (x *ListDeidentifyTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteDeidentifyTemplate.
type DeleteDeidentifyTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and deidentify template to be deleted,
	// for example `organizations/433245324/deidentifyTemplates/432452342` or
	// projects/project-id/deidentifyTemplates/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDeidentifyTemplateRequest) Reset() {
	*x = DeleteDeidentifyTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeidentifyTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeidentifyTemplateRequest) ProtoMessage() {}

func (x *DeleteDeidentifyTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeidentifyTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeidentifyTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{106}
}

func (x *DeleteDeidentifyTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration for a custom dictionary created from a data source of any size
// up to the maximum size defined in the
// [limits](https://cloud.google.com/dlp/limits) page. The artifacts of
// dictionary creation are stored in the specified Google Cloud Storage
// location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries
// that satisfy the size requirements.
type LargeCustomDictionaryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location to store dictionary artifacts in Google Cloud Storage. These files
	// will only be accessible by project owners and the DLP API. If any of these
	// artifacts are modified, the dictionary is considered invalid and can no
	// longer be used.
	OutputPath *CloudStoragePath `protobuf:"bytes,1,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// Types that are assignable to Source:
	//	*LargeCustomDictionaryConfig_CloudStorageFileSet
	//	*LargeCustomDictionaryConfig_BigQueryField
	Source isLargeCustomDictionaryConfig_Source `protobuf_oneof:"source"`
}

func (x *LargeCustomDictionaryConfig) Reset() {
	*x = LargeCustomDictionaryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LargeCustomDictionaryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCustomDictionaryConfig) ProtoMessage() {}

func (x *LargeCustomDictionaryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCustomDictionaryConfig.ProtoReflect.Descriptor instead.
func (*LargeCustomDictionaryConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{107}
}

func (x *LargeCustomDictionaryConfig) GetOutputPath() *CloudStoragePath {
	if x != nil {
		return x.OutputPath
	}
	return nil
}

func (m *LargeCustomDictionaryConfig) GetSource() isLargeCustomDictionaryConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *LargeCustomDictionaryConfig) GetCloudStorageFileSet() *CloudStorageFileSet {
	if x, ok := x.GetSource().(*LargeCustomDictionaryConfig_CloudStorageFileSet); ok {
		return x.CloudStorageFileSet
	}
	return nil
}

func (x *LargeCustomDictionaryConfig) GetBigQueryField() *BigQueryField {
	if x, ok := x.GetSource().(*LargeCustomDictionaryConfig_BigQueryField); ok {
		return x.BigQueryField
	}
	return nil
}

type isLargeCustomDictionaryConfig_Source interface {
	isLargeCustomDictionaryConfig_Source()
}

type LargeCustomDictionaryConfig_CloudStorageFileSet struct {
	// Set of files containing newline-delimited lists of dictionary phrases.
	CloudStorageFileSet *CloudStorageFileSet `protobuf:"bytes,2,opt,name=cloud_storage_file_set,json=cloudStorageFileSet,proto3,oneof"`
}

type LargeCustomDictionaryConfig_BigQueryField struct {
	// Field in a BigQuery table where each cell represents a dictionary phrase.
	BigQueryField *BigQueryField `protobuf:"bytes,3,opt,name=big_query_field,json=bigQueryField,proto3,oneof"`
}

func (*LargeCustomDictionaryConfig_CloudStorageFileSet) isLargeCustomDictionaryConfig_Source() {}

func (*LargeCustomDictionaryConfig_BigQueryField) isLargeCustomDictionaryConfig_Source() {}

// Summary statistics of a custom dictionary.
type LargeCustomDictionaryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approximate number of distinct phrases in the dictionary.
	ApproxNumPhrases int64 `protobuf:"varint,1,opt,name=approx_num_phrases,json=approxNumPhrases,proto3" json:"approx_num_phrases,omitempty"`
}

func (x *LargeCustomDictionaryStats) Reset() {
	*x = LargeCustomDictionaryStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LargeCustomDictionaryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LargeCustomDictionaryStats) ProtoMessage() {}

func (x *LargeCustomDictionaryStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LargeCustomDictionaryStats.ProtoReflect.Descriptor instead.
func (*LargeCustomDictionaryStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{108}
}

func (x *LargeCustomDictionaryStats) GetApproxNumPhrases() int64 {
	if x != nil {
		return x.ApproxNumPhrases
	}
	return 0
}

// Configuration for stored infoTypes. All fields and subfield are provided
// by the user. For more information, see
// https://cloud.google.com/dlp/docs/creating-custom-infotypes.
type StoredInfoTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of the StoredInfoType (max 256 characters).
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of the StoredInfoType (max 256 characters).
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Stored infotype types.
	//
	// Types that are assignable to Type:
	//	*StoredInfoTypeConfig_LargeCustomDictionary
	//	*StoredInfoTypeConfig_Dictionary
	//	*StoredInfoTypeConfig_Regex
	Type isStoredInfoTypeConfig_Type `protobuf_oneof:"type"`
}

func (x *StoredInfoTypeConfig) Reset() {
	*x = StoredInfoTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeConfig) ProtoMessage() {}

func (x *StoredInfoTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeConfig.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{109}
}

func (x *StoredInfoTypeConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *StoredInfoTypeConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *StoredInfoTypeConfig) GetType() isStoredInfoTypeConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetLargeCustomDictionary() *LargeCustomDictionaryConfig {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_LargeCustomDictionary); ok {
		return x.LargeCustomDictionary
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_Dictionary); ok {
		return x.Dictionary
	}
	return nil
}

func (x *StoredInfoTypeConfig) GetRegex() *CustomInfoType_Regex {
	if x, ok := x.GetType().(*StoredInfoTypeConfig_Regex); ok {
		return x.Regex
	}
	return nil
}

type isStoredInfoTypeConfig_Type interface {
	isStoredInfoTypeConfig_Type()
}

type StoredInfoTypeConfig_LargeCustomDictionary struct {
	// StoredInfoType where findings are defined by a dictionary of phrases.
	LargeCustomDictionary *LargeCustomDictionaryConfig `protobuf:"bytes,3,opt,name=large_custom_dictionary,json=largeCustomDictionary,proto3,oneof"`
}

type StoredInfoTypeConfig_Dictionary struct {
	// Store dictionary-based CustomInfoType.
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,4,opt,name=dictionary,proto3,oneof"`
}

type StoredInfoTypeConfig_Regex struct {
	// Store regular expression-based StoredInfoType.
	Regex *CustomInfoType_Regex `protobuf:"bytes,5,opt,name=regex,proto3,oneof"`
}

func (*StoredInfoTypeConfig_LargeCustomDictionary) isStoredInfoTypeConfig_Type() {}

func (*StoredInfoTypeConfig_Dictionary) isStoredInfoTypeConfig_Type() {}

func (*StoredInfoTypeConfig_Regex) isStoredInfoTypeConfig_Type() {}

// Statistics for a StoredInfoType.
type StoredInfoTypeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stat types
	//
	// Types that are assignable to Type:
	//	*StoredInfoTypeStats_LargeCustomDictionary
	Type isStoredInfoTypeStats_Type `protobuf_oneof:"type"`
}

func (x *StoredInfoTypeStats) Reset() {
	*x = StoredInfoTypeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeStats) ProtoMessage() {}

func (x *StoredInfoTypeStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeStats.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeStats) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{110}
}

func (m *StoredInfoTypeStats) GetType() isStoredInfoTypeStats_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StoredInfoTypeStats) GetLargeCustomDictionary() *LargeCustomDictionaryStats {
	if x, ok := x.GetType().(*StoredInfoTypeStats_LargeCustomDictionary); ok {
		return x.LargeCustomDictionary
	}
	return nil
}

type isStoredInfoTypeStats_Type interface {
	isStoredInfoTypeStats_Type()
}

type StoredInfoTypeStats_LargeCustomDictionary struct {
	// StoredInfoType where findings are defined by a dictionary of phrases.
	LargeCustomDictionary *LargeCustomDictionaryStats `protobuf:"bytes,1,opt,name=large_custom_dictionary,json=largeCustomDictionary,proto3,oneof"`
}

func (*StoredInfoTypeStats_LargeCustomDictionary) isStoredInfoTypeStats_Type() {}

// Version of a StoredInfoType, including the configuration used to build it,
// create timestamp, and current state.
type StoredInfoTypeVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// StoredInfoType configuration.
	Config *StoredInfoTypeConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Create timestamp of the version. Read-only, determined by the system
	// when the version is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Stored info type version state. Read-only, updated by the system
	// during dictionary creation.
	State StoredInfoTypeState `protobuf:"varint,3,opt,name=state,proto3,enum=google.privacy.dlp.v2.StoredInfoTypeState" json:"state,omitempty"`
	// Errors that occurred when creating this storedInfoType version, or
	// anomalies detected in the storedInfoType data that render it unusable. Only
	// the five most recent errors will be displayed, with the most recent error
	// appearing first.
	//
	// For example, some of the data for stored custom dictionaries is put in
	// the user's Google Cloud Storage bucket, and if this data is modified or
	// deleted by the user or another system, the dictionary becomes invalid.
	//
	// If any errors occur, fix the problem indicated by the error message and
	// use the UpdateStoredInfoType API method to create another version of the
	// storedInfoType to continue using it, reusing the same `config` if it was
	// not the source of the error.
	Errors []*Error `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
	// Statistics about this storedInfoType version.
	Stats *StoredInfoTypeStats `protobuf:"bytes,5,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *StoredInfoTypeVersion) Reset() {
	*x = StoredInfoTypeVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoTypeVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoTypeVersion) ProtoMessage() {}

func (x *StoredInfoTypeVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoTypeVersion.ProtoReflect.Descriptor instead.
func (*StoredInfoTypeVersion) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{111}
}

func (x *StoredInfoTypeVersion) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetState() StoredInfoTypeState {
	if x != nil {
		return x.State
	}
	return StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED
}

func (x *StoredInfoTypeVersion) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *StoredInfoTypeVersion) GetStats() *StoredInfoTypeStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

// StoredInfoType resource message that contains information about the current
// version and any pending updates.
type StoredInfoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Current version of the stored info type.
	CurrentVersion *StoredInfoTypeVersion `protobuf:"bytes,2,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	// Pending versions of the stored info type. Empty if no versions are
	// pending.
	PendingVersions []*StoredInfoTypeVersion `protobuf:"bytes,3,rep,name=pending_versions,json=pendingVersions,proto3" json:"pending_versions,omitempty"`
}

func (x *StoredInfoType) Reset() {
	*x = StoredInfoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredInfoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredInfoType) ProtoMessage() {}

func (x *StoredInfoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredInfoType.ProtoReflect.Descriptor instead.
func (*StoredInfoType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{112}
}

func (x *StoredInfoType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StoredInfoType) GetCurrentVersion() *StoredInfoTypeVersion {
	if x != nil {
		return x.CurrentVersion
	}
	return nil
}

func (x *StoredInfoType) GetPendingVersions() []*StoredInfoTypeVersion {
	if x != nil {
		return x.PendingVersions
	}
	return nil
}

// Request message for CreateStoredInfoType.
type CreateStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Configuration of the storedInfoType to create.
	Config *StoredInfoTypeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The storedInfoType ID can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\\d-_]+`. The maximum length is 100
	// characters. Can be empty to allow the system to generate one.
	StoredInfoTypeId string `protobuf:"bytes,3,opt,name=stored_info_type_id,json=storedInfoTypeId,proto3" json:"stored_info_type_id,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *CreateStoredInfoTypeRequest) Reset() {
	*x = CreateStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStoredInfoTypeRequest) ProtoMessage() {}

func (x *CreateStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{113}
}

func (x *CreateStoredInfoTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateStoredInfoTypeRequest) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateStoredInfoTypeRequest) GetStoredInfoTypeId() string {
	if x != nil {
		return x.StoredInfoTypeId
	}
	return ""
}

func (x *CreateStoredInfoTypeRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Request message for UpdateStoredInfoType.
type UpdateStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of organization and storedInfoType to be updated, for
	// example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Updated configuration for the storedInfoType. If not provided, a new
	// version of the storedInfoType will be created with the existing
	// configuration.
	Config *StoredInfoTypeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateStoredInfoTypeRequest) Reset() {
	*x = UpdateStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStoredInfoTypeRequest) ProtoMessage() {}

func (x *UpdateStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{114}
}

func (x *UpdateStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateStoredInfoTypeRequest) GetConfig() *StoredInfoTypeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *UpdateStoredInfoTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetStoredInfoType.
type GetStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and storedInfoType to be read, for
	// example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStoredInfoTypeRequest) Reset() {
	*x = GetStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoredInfoTypeRequest) ProtoMessage() {}

func (x *GetStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*GetStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{115}
}

func (x *GetStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListStoredInfoTypes.
type ListStoredInfoTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	// - Format:projects/[PROJECT-ID]
	// - Format:organizations/[ORGANIZATION-ID]
	// - Format:projects/[PROJECT-ID]/locations/[LOCATION-ID]
	// - Format:organizations/[ORGANIZATION-ID]/locations/[LOCATION-ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page token to continue retrieval. Comes from previous call
	// to `ListStoredInfoTypes`.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Size of the page, can be limited by server. If zero server returns
	// a page of max size 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Comma separated list of fields to order by,
	// followed by `asc` or `desc` postfix. This list is case-insensitive,
	// default sorting order is ascending, redundant space characters are
	// insignificant.
	//
	// Example: `name asc, display_name, create_time desc`
	//
	// Supported fields are:
	//
	// - `create_time`: corresponds to time the most recent version of the
	// resource was created.
	// - `state`: corresponds to the state of the resource.
	// - `name`: corresponds to resource name.
	// - `display_name`: corresponds to info type's display name.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Deprecated. This field has no effect.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *ListStoredInfoTypesRequest) Reset() {
	*x = ListStoredInfoTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStoredInfoTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoredInfoTypesRequest) ProtoMessage() {}

func (x *ListStoredInfoTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoredInfoTypesRequest.ProtoReflect.Descriptor instead.
func (*ListStoredInfoTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{116}
}

func (x *ListStoredInfoTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListStoredInfoTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListStoredInfoTypesRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Response message for ListStoredInfoTypes.
type ListStoredInfoTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of storedInfoTypes, up to page_size in ListStoredInfoTypesRequest.
	StoredInfoTypes []*StoredInfoType `protobuf:"bytes,1,rep,name=stored_info_types,json=storedInfoTypes,proto3" json:"stored_info_types,omitempty"`
	// If the next page is available then the next page token to be used
	// in following ListStoredInfoTypes request.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListStoredInfoTypesResponse) Reset() {
	*x = ListStoredInfoTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStoredInfoTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoredInfoTypesResponse) ProtoMessage() {}

func (x *ListStoredInfoTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoredInfoTypesResponse.ProtoReflect.Descriptor instead.
func (*ListStoredInfoTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{117}
}

func (x *ListStoredInfoTypesResponse) GetStoredInfoTypes() []*StoredInfoType {
	if x != nil {
		return x.StoredInfoTypes
	}
	return nil
}

func (x *ListStoredInfoTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteStoredInfoType.
type DeleteStoredInfoTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the organization and storedInfoType to be deleted, for
	// example `organizations/433245324/storedInfoTypes/432452342` or
	// projects/project-id/storedInfoTypes/432452342.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteStoredInfoTypeRequest) Reset() {
	*x = DeleteStoredInfoTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteStoredInfoTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStoredInfoTypeRequest) ProtoMessage() {}

func (x *DeleteStoredInfoTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStoredInfoTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteStoredInfoTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{118}
}

func (x *DeleteStoredInfoTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to search for potentially sensitive info in a custom location.
type HybridInspectJobTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the trigger to execute a hybrid inspect on, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The item to inspect.
	HybridItem *HybridContentItem `protobuf:"bytes,3,opt,name=hybrid_item,json=hybridItem,proto3" json:"hybrid_item,omitempty"`
}

func (x *HybridInspectJobTriggerRequest) Reset() {
	*x = HybridInspectJobTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectJobTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectJobTriggerRequest) ProtoMessage() {}

func (x *HybridInspectJobTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectJobTriggerRequest.ProtoReflect.Descriptor instead.
func (*HybridInspectJobTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{119}
}

func (x *HybridInspectJobTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HybridInspectJobTriggerRequest) GetHybridItem() *HybridContentItem {
	if x != nil {
		return x.HybridItem
	}
	return nil
}

// Request to search for potentially sensitive info in a custom location.
type HybridInspectDlpJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the job to execute a hybrid inspect on, for example
	// `projects/dlp-test-project/dlpJob/53234423`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The item to inspect.
	HybridItem *HybridContentItem `protobuf:"bytes,3,opt,name=hybrid_item,json=hybridItem,proto3" json:"hybrid_item,omitempty"`
}

func (x *HybridInspectDlpJobRequest) Reset() {
	*x = HybridInspectDlpJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectDlpJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectDlpJobRequest) ProtoMessage() {}

func (x *HybridInspectDlpJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectDlpJobRequest.ProtoReflect.Descriptor instead.
func (*HybridInspectDlpJobRequest) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{120}
}

func (x *HybridInspectDlpJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HybridInspectDlpJobRequest) GetHybridItem() *HybridContentItem {
	if x != nil {
		return x.HybridItem
	}
	return nil
}

// An individual hybrid item to inspect. Will be stored temporarily during
// processing.
type HybridContentItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The item to inspect.
	Item *ContentItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
	// Supplementary information that will be added to each finding.
	FindingDetails *HybridFindingDetails `protobuf:"bytes,2,opt,name=finding_details,json=findingDetails,proto3" json:"finding_details,omitempty"`
}

func (x *HybridContentItem) Reset() {
	*x = HybridContentItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridContentItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridContentItem) ProtoMessage() {}

func (x *HybridContentItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridContentItem.ProtoReflect.Descriptor instead.
func (*HybridContentItem) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{121}
}

func (x *HybridContentItem) GetItem() *ContentItem {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *HybridContentItem) GetFindingDetails() *HybridFindingDetails {
	if x != nil {
		return x.FindingDetails
	}
	return nil
}

// Populate to associate additional data with each finding.
type HybridFindingDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the container where the content being inspected is from.
	ContainerDetails *Container `protobuf:"bytes,1,opt,name=container_details,json=containerDetails,proto3" json:"container_details,omitempty"`
	// Offset in bytes of the line, from the beginning of the file, where the
	// finding  is located. Populate if the item being scanned is only part of a
	// bigger item, such as a shard of a file and you want to track the absolute
	// position of the finding.
	FileOffset int64 `protobuf:"varint,2,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
	// Offset of the row for tables. Populate if the row(s) being scanned are
	// part of a bigger dataset and you want to keep track of their absolute
	// position.
	RowOffset int64 `protobuf:"varint,3,opt,name=row_offset,json=rowOffset,proto3" json:"row_offset,omitempty"`
	// If the container is a table, additional information to make findings
	// meaningful such as the columns that are primary keys. If not known ahead
	// of time, can also be set within each inspect hybrid call and the two
	// will be merged. Note that identifying_fields will only be stored to
	// BigQuery, and only if the BigQuery action has been included.
	TableOptions *TableOptions `protobuf:"bytes,4,opt,name=table_options,json=tableOptions,proto3" json:"table_options,omitempty"`
	// Labels to represent user provided metadata about the data being inspected.
	// If configured by the job, some key values may be required.
	// The labels associated with `Finding`'s produced by hybrid
	// inspection.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// Label values must be between 0 and 63 characters long and must conform
	// to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//
	// No more than 10 labels can be associated with a given finding.
	//
	// Examples:
	// * `"environment" : "production"`
	// * `"pipeline" : "etl"`
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *HybridFindingDetails) Reset() {
	*x = HybridFindingDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridFindingDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridFindingDetails) ProtoMessage() {}

func (x *HybridFindingDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridFindingDetails.ProtoReflect.Descriptor instead.
func (*HybridFindingDetails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{122}
}

func (x *HybridFindingDetails) GetContainerDetails() *Container {
	if x != nil {
		return x.ContainerDetails
	}
	return nil
}

func (x *HybridFindingDetails) GetFileOffset() int64 {
	if x != nil {
		return x.FileOffset
	}
	return 0
}

func (x *HybridFindingDetails) GetRowOffset() int64 {
	if x != nil {
		return x.RowOffset
	}
	return 0
}

func (x *HybridFindingDetails) GetTableOptions() *TableOptions {
	if x != nil {
		return x.TableOptions
	}
	return nil
}

func (x *HybridFindingDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Quota exceeded errors will be thrown once quota has been met.
type HybridInspectResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HybridInspectResponse) Reset() {
	*x = HybridInspectResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridInspectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridInspectResponse) ProtoMessage() {}

func (x *HybridInspectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridInspectResponse.ProtoReflect.Descriptor instead.
func (*HybridInspectResponse) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{123}
}

// Configuration to control the number of findings returned.
type InspectConfig_FindingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max number of findings that will be returned for each item scanned.
	// When set within `InspectJobConfig`,
	// the maximum returned is 2000 regardless if this is set higher.
	// When set within `InspectContentRequest`, this field is ignored.
	MaxFindingsPerItem int32 `protobuf:"varint,1,opt,name=max_findings_per_item,json=maxFindingsPerItem,proto3" json:"max_findings_per_item,omitempty"`
	// Max number of findings that will be returned per request/job.
	// When set within `InspectContentRequest`, the maximum returned is 2000
	// regardless if this is set higher.
	MaxFindingsPerRequest int32 `protobuf:"varint,2,opt,name=max_findings_per_request,json=maxFindingsPerRequest,proto3" json:"max_findings_per_request,omitempty"`
	// Configuration of findings limit given for specified infoTypes.
	MaxFindingsPerInfoType []*InspectConfig_FindingLimits_InfoTypeLimit `protobuf:"bytes,3,rep,name=max_findings_per_info_type,json=maxFindingsPerInfoType,proto3" json:"max_findings_per_info_type,omitempty"`
}

func (x *InspectConfig_FindingLimits) Reset() {
	*x = InspectConfig_FindingLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig_FindingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig_FindingLimits) ProtoMessage() {}

func (x *InspectConfig_FindingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig_FindingLimits.ProtoReflect.Descriptor instead.
func (*InspectConfig_FindingLimits) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4, 0}
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerItem() int32 {
	if x != nil {
		return x.MaxFindingsPerItem
	}
	return 0
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerRequest() int32 {
	if x != nil {
		return x.MaxFindingsPerRequest
	}
	return 0
}

func (x *InspectConfig_FindingLimits) GetMaxFindingsPerInfoType() []*InspectConfig_FindingLimits_InfoTypeLimit {
	if x != nil {
		return x.MaxFindingsPerInfoType
	}
	return nil
}

// Max findings configuration per infoType, per content item or long
// running DlpJob.
type InspectConfig_FindingLimits_InfoTypeLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of information the findings limit applies to. Only one limit per
	// info_type should be provided. If InfoTypeLimit does not have an
	// info_type, the DLP API applies the limit against all info_types that
	// are found but not specified in another InfoTypeLimit.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Max findings limit for the given infoType.
	MaxFindings int32 `protobuf:"varint,2,opt,name=max_findings,json=maxFindings,proto3" json:"max_findings,omitempty"`
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) Reset() {
	*x = InspectConfig_FindingLimits_InfoTypeLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectConfig_FindingLimits_InfoTypeLimit) ProtoMessage() {}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectConfig_FindingLimits_InfoTypeLimit.ProtoReflect.Descriptor instead.
func (*InspectConfig_FindingLimits_InfoTypeLimit) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *InspectConfig_FindingLimits_InfoTypeLimit) GetMaxFindings() int32 {
	if x != nil {
		return x.MaxFindings
	}
	return 0
}

// Values of the row.
type Table_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual cells.
	Values []*Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Table_Row) Reset() {
	*x = Table_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table_Row) ProtoMessage() {}

func (x *Table_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table_Row.ProtoReflect.Descriptor instead.
func (*Table_Row) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Table_Row) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

// Configuration for determining how redaction of images should occur.
type RedactImageRequest_ImageRedactionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of information to redact from images.
	//
	// Types that are assignable to Target:
	//	*RedactImageRequest_ImageRedactionConfig_InfoType
	//	*RedactImageRequest_ImageRedactionConfig_RedactAllText
	Target isRedactImageRequest_ImageRedactionConfig_Target `protobuf_oneof:"target"`
	// The color to use when redacting content from an image. If not specified,
	// the default is black.
	RedactionColor *Color `protobuf:"bytes,3,opt,name=redaction_color,json=redactionColor,proto3" json:"redaction_color,omitempty"`
}

func (x *RedactImageRequest_ImageRedactionConfig) Reset() {
	*x = RedactImageRequest_ImageRedactionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RedactImageRequest_ImageRedactionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RedactImageRequest_ImageRedactionConfig) ProtoMessage() {}

func (x *RedactImageRequest_ImageRedactionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RedactImageRequest_ImageRedactionConfig.ProtoReflect.Descriptor instead.
func (*RedactImageRequest_ImageRedactionConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{21, 0}
}

func (m *RedactImageRequest_ImageRedactionConfig) GetTarget() isRedactImageRequest_ImageRedactionConfig_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *RedactImageRequest_ImageRedactionConfig) GetInfoType() *InfoType {
	if x, ok := x.GetTarget().(*RedactImageRequest_ImageRedactionConfig_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *RedactImageRequest_ImageRedactionConfig) GetRedactAllText() bool {
	if x, ok := x.GetTarget().(*RedactImageRequest_ImageRedactionConfig_RedactAllText); ok {
		return x.RedactAllText
	}
	return false
}

func (x *RedactImageRequest_ImageRedactionConfig) GetRedactionColor() *Color {
	if x != nil {
		return x.RedactionColor
	}
	return nil
}

type isRedactImageRequest_ImageRedactionConfig_Target interface {
	isRedactImageRequest_ImageRedactionConfig_Target()
}

type RedactImageRequest_ImageRedactionConfig_InfoType struct {
	// Only one per info_type should be provided per request. If not
	// specified, and redact_all_text is false, the DLP API will redact all
	// text that it matches against all info_types that are found, but not
	// specified in another ImageRedactionConfig.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3,oneof"`
}

type RedactImageRequest_ImageRedactionConfig_RedactAllText struct {
	// If true, all text found in the image, regardless whether it matches an
	// info_type, is redacted. Only one should be provided.
	RedactAllText bool `protobuf:"varint,2,opt,name=redact_all_text,json=redactAllText,proto3,oneof"`
}

func (*RedactImageRequest_ImageRedactionConfig_InfoType) isRedactImageRequest_ImageRedactionConfig_Target() {
}

func (*RedactImageRequest_ImageRedactionConfig_RedactAllText) isRedactImageRequest_ImageRedactionConfig_Target() {
}

// Snapshot of the inspection configuration.
type InspectDataSourceDetails_RequestedOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If run with an InspectTemplate, a snapshot of its state at the time of
	// this run.
	SnapshotInspectTemplate *InspectTemplate `protobuf:"bytes,1,opt,name=snapshot_inspect_template,json=snapshotInspectTemplate,proto3" json:"snapshot_inspect_template,omitempty"`
	// Inspect config.
	JobConfig *InspectJobConfig `protobuf:"bytes,3,opt,name=job_config,json=jobConfig,proto3" json:"job_config,omitempty"`
}

func (x *InspectDataSourceDetails_RequestedOptions) Reset() {
	*x = InspectDataSourceDetails_RequestedOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails_RequestedOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails_RequestedOptions) ProtoMessage() {}

func (x *InspectDataSourceDetails_RequestedOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails_RequestedOptions.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails_RequestedOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{32, 0}
}

func (x *InspectDataSourceDetails_RequestedOptions) GetSnapshotInspectTemplate() *InspectTemplate {
	if x != nil {
		return x.SnapshotInspectTemplate
	}
	return nil
}

func (x *InspectDataSourceDetails_RequestedOptions) GetJobConfig() *InspectJobConfig {
	if x != nil {
		return x.JobConfig
	}
	return nil
}

// All result fields mentioned below are updated while the job is processing.
type InspectDataSourceDetails_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total size in bytes that were processed.
	ProcessedBytes int64 `protobuf:"varint,1,opt,name=processed_bytes,json=processedBytes,proto3" json:"processed_bytes,omitempty"`
	// Estimate of the number of bytes to process.
	TotalEstimatedBytes int64 `protobuf:"varint,2,opt,name=total_estimated_bytes,json=totalEstimatedBytes,proto3" json:"total_estimated_bytes,omitempty"`
	// Statistics of how many instances of each info type were found during
	// inspect job.
	InfoTypeStats []*InfoTypeStats `protobuf:"bytes,3,rep,name=info_type_stats,json=infoTypeStats,proto3" json:"info_type_stats,omitempty"`
	// Statistics related to the processing of hybrid inspect.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridStats *HybridInspectStatistics `protobuf:"bytes,7,opt,name=hybrid_stats,json=hybridStats,proto3" json:"hybrid_stats,omitempty"`
}

func (x *InspectDataSourceDetails_Result) Reset() {
	*x = InspectDataSourceDetails_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InspectDataSourceDetails_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InspectDataSourceDetails_Result) ProtoMessage() {}

func (x *InspectDataSourceDetails_Result) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InspectDataSourceDetails_Result.ProtoReflect.Descriptor instead.
func (*InspectDataSourceDetails_Result) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{32, 1}
}

func (x *InspectDataSourceDetails_Result) GetProcessedBytes() int64 {
	if x != nil {
		return x.ProcessedBytes
	}
	return 0
}

func (x *InspectDataSourceDetails_Result) GetTotalEstimatedBytes() int64 {
	if x != nil {
		return x.TotalEstimatedBytes
	}
	return 0
}

func (x *InspectDataSourceDetails_Result) GetInfoTypeStats() []*InfoTypeStats {
	if x != nil {
		return x.InfoTypeStats
	}
	return nil
}

func (x *InspectDataSourceDetails_Result) GetHybridStats() *HybridInspectStatistics {
	if x != nil {
		return x.HybridStats
	}
	return nil
}

// A quasi-identifier column has a custom_tag, used to know which column
// in the data corresponds to which column in the statistical model.
type StatisticalTable_QuasiIdentifierField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,2,opt,name=custom_tag,json=customTag,proto3" json:"custom_tag,omitempty"`
}

func (x *StatisticalTable_QuasiIdentifierField) Reset() {
	*x = StatisticalTable_QuasiIdentifierField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatisticalTable_QuasiIdentifierField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticalTable_QuasiIdentifierField) ProtoMessage() {}

func (x *StatisticalTable_QuasiIdentifierField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticalTable_QuasiIdentifierField.ProtoReflect.Descriptor instead.
func (*StatisticalTable_QuasiIdentifierField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{39, 0}
}

func (x *StatisticalTable_QuasiIdentifierField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *StatisticalTable_QuasiIdentifierField) GetCustomTag() string {
	if x != nil {
		return x.CustomTag
	}
	return ""
}

// Compute numerical stats over an individual column, including
// min, max, and quantiles.
type PrivacyMetric_NumericalStatsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field to compute numerical stats on. Supported types are
	// integer, float, date, datetime, timestamp, time.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *PrivacyMetric_NumericalStatsConfig) Reset() {
	*x = PrivacyMetric_NumericalStatsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_NumericalStatsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_NumericalStatsConfig) ProtoMessage() {}

func (x *PrivacyMetric_NumericalStatsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_NumericalStatsConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_NumericalStatsConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 0}
}

func (x *PrivacyMetric_NumericalStatsConfig) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// Compute numerical stats over an individual column, including
// number of distinct values and value count distribution.
type PrivacyMetric_CategoricalStatsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field to compute categorical stats on. All column types are
	// supported except for arrays and structs. However, it may be more
	// informative to use NumericalStats when the field type is supported,
	// depending on the data.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *PrivacyMetric_CategoricalStatsConfig) Reset() {
	*x = PrivacyMetric_CategoricalStatsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_CategoricalStatsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_CategoricalStatsConfig) ProtoMessage() {}

func (x *PrivacyMetric_CategoricalStatsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_CategoricalStatsConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_CategoricalStatsConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 1}
}

func (x *PrivacyMetric_CategoricalStatsConfig) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// k-anonymity metric, used for analysis of reidentification risk.
type PrivacyMetric_KAnonymityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of fields to compute k-anonymity over. When multiple fields are
	// specified, they are considered a single composite key. Structs and
	// repeated data types are not supported; however, nested fields are
	// supported so long as they are not structs themselves or nested within
	// a repeated field.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Message indicating that multiple rows might be associated to a
	// single individual. If the same entity_id is associated to multiple
	// quasi-identifier tuples over distinct rows, we consider the entire
	// collection of tuples as the composite quasi-identifier. This collection
	// is a multiset: the order in which the different tuples appear in the
	// dataset is ignored, but their frequency is taken into account.
	//
	// Important note: a maximum of 1000 rows can be associated to a single
	// entity ID. If more rows are associated with the same entity ID, some
	// might be ignored.
	EntityId *EntityId `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
}

func (x *PrivacyMetric_KAnonymityConfig) Reset() {
	*x = PrivacyMetric_KAnonymityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KAnonymityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KAnonymityConfig) ProtoMessage() {}

func (x *PrivacyMetric_KAnonymityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KAnonymityConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KAnonymityConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 2}
}

func (x *PrivacyMetric_KAnonymityConfig) GetQuasiIds() []*FieldId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KAnonymityConfig) GetEntityId() *EntityId {
	if x != nil {
		return x.EntityId
	}
	return nil
}

// l-diversity metric, used for analysis of reidentification risk.
type PrivacyMetric_LDiversityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of quasi-identifiers indicating how equivalence classes are
	// defined for the l-diversity computation. When multiple fields are
	// specified, they are considered a single composite key.
	QuasiIds []*FieldId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Sensitive field for computing the l-value.
	SensitiveAttribute *FieldId `protobuf:"bytes,2,opt,name=sensitive_attribute,json=sensitiveAttribute,proto3" json:"sensitive_attribute,omitempty"`
}

func (x *PrivacyMetric_LDiversityConfig) Reset() {
	*x = PrivacyMetric_LDiversityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_LDiversityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_LDiversityConfig) ProtoMessage() {}

func (x *PrivacyMetric_LDiversityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_LDiversityConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_LDiversityConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 3}
}

func (x *PrivacyMetric_LDiversityConfig) GetQuasiIds() []*FieldId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_LDiversityConfig) GetSensitiveAttribute() *FieldId {
	if x != nil {
		return x.SensitiveAttribute
	}
	return nil
}

// Reidentifiability metric. This corresponds to a risk model similar to what
// is called "journalist risk" in the literature, except the attack dataset is
// statistically modeled instead of being perfectly known. This can be done
// using publicly available data (like the US Census), or using a custom
// statistical model (indicated as one or several BigQuery tables), or by
// extrapolating from the distribution of values in the input dataset.
type PrivacyMetric_KMapEstimationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fields considered to be quasi-identifiers. No two columns can have the
	// same tag.
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_TaggedField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// ISO 3166-1 alpha-2 region code to use in the statistical modeling.
	// Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Several auxiliary tables can be used in the analysis. Each custom_tag
	// used to tag a quasi-identifiers column must appear in exactly one column
	// of one auxiliary table.
	AuxiliaryTables []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable `protobuf:"bytes,3,rep,name=auxiliary_tables,json=auxiliaryTables,proto3" json:"auxiliary_tables,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 4}
}

func (x *PrivacyMetric_KMapEstimationConfig) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_TaggedField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *PrivacyMetric_KMapEstimationConfig) GetAuxiliaryTables() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable {
	if x != nil {
		return x.AuxiliaryTables
	}
	return nil
}

// δ-presence metric, used to estimate how likely it is for an attacker to
// figure out that one given individual appears in a de-identified dataset.
// Similarly to the k-map metric, we cannot compute δ-presence exactly without
// knowing the attack dataset, so we use a statistical model instead.
type PrivacyMetric_DeltaPresenceEstimationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fields considered to be quasi-identifiers. No two fields can have the
	// same tag.
	QuasiIds []*QuasiId `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// ISO 3166-1 alpha-2 region code to use in the statistical modeling.
	// Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Several auxiliary tables can be used in the analysis. Each custom_tag
	// used to tag a quasi-identifiers field must appear in exactly one
	// field of one auxiliary table.
	AuxiliaryTables []*StatisticalTable `protobuf:"bytes,3,rep,name=auxiliary_tables,json=auxiliaryTables,proto3" json:"auxiliary_tables,omitempty"`
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) Reset() {
	*x = PrivacyMetric_DeltaPresenceEstimationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_DeltaPresenceEstimationConfig) ProtoMessage() {}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_DeltaPresenceEstimationConfig.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_DeltaPresenceEstimationConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 5}
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetQuasiIds() []*QuasiId {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *PrivacyMetric_DeltaPresenceEstimationConfig) GetAuxiliaryTables() []*StatisticalTable {
	if x != nil {
		return x.AuxiliaryTables
	}
	return nil
}

// A column with a semantic tag attached.
type PrivacyMetric_KMapEstimationConfig_TaggedField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Semantic tag that identifies what a column contains, to determine which
	// statistical model to use to estimate the reidentifiability of each
	// value. [required]
	//
	// Types that are assignable to Tag:
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag
	//	*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred
	Tag isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag `protobuf_oneof:"tag"`
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_TaggedField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_TaggedField.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_TaggedField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 4, 0}
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (m *PrivacyMetric_KMapEstimationConfig_TaggedField) GetTag() isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInfoType() *InfoType {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType); ok {
		return x.InfoType
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetCustomTag() string {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag); ok {
		return x.CustomTag
	}
	return ""
}

func (x *PrivacyMetric_KMapEstimationConfig_TaggedField) GetInferred() *emptypb.Empty {
	if x, ok := x.GetTag().(*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred); ok {
		return x.Inferred
	}
	return nil
}

type isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag interface {
	isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag()
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType struct {
	// A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We
	// currently support US ZIP codes, region codes, ages and genders.
	// To programmatically obtain the list of supported InfoTypes, use
	// ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
	InfoType *InfoType `protobuf:"bytes,2,opt,name=info_type,json=infoType,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag struct {
	// A column can be tagged with a custom tag. In this case, the user must
	// indicate an auxiliary table that contains statistical information on
	// the possible values of this column (below).
	CustomTag string `protobuf:"bytes,3,opt,name=custom_tag,json=customTag,proto3,oneof"`
}

type PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred struct {
	// If no semantic tag is indicated, we infer the statistical model from
	// the distribution of values in the input data
	Inferred *emptypb.Empty `protobuf:"bytes,4,opt,name=inferred,proto3,oneof"`
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

func (*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred) isPrivacyMetric_KMapEstimationConfig_TaggedField_Tag() {
}

// An auxiliary table contains statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple.
// If a tuple is present in the data but not in the auxiliary table, the
// corresponding relative frequency is assumed to be zero (and thus, the
// tuple is highly reidentifiable).
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Auxiliary table location.
	Table *BigQueryTable `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// Required. Quasi-identifier columns.
	QuasiIds []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField `protobuf:"bytes,1,rep,name=quasi_ids,json=quasiIds,proto3" json:"quasi_ids,omitempty"`
	// Required. The relative frequency column must contain a floating-point number
	// between 0 and 1 (inclusive). Null values are assumed to be zero.
	RelativeFrequency *FieldId `protobuf:"bytes,2,opt,name=relative_frequency,json=relativeFrequency,proto3" json:"relative_frequency,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_AuxiliaryTable.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 4, 1}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetTable() *BigQueryTable {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetQuasiIds() []*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField {
	if x != nil {
		return x.QuasiIds
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable) GetRelativeFrequency() *FieldId {
	if x != nil {
		return x.RelativeFrequency
	}
	return nil
}

// A quasi-identifier column has a custom_tag, used to know which column
// in the data corresponds to which column in the statistical model.
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies the column.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A auxiliary field.
	CustomTag string `protobuf:"bytes,2,opt,name=custom_tag,json=customTag,proto3" json:"custom_tag,omitempty"`
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Reset() {
	*x = PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) ProtoMessage() {}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField.ProtoReflect.Descriptor instead.
func (*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{40, 4, 1, 0}
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField) GetCustomTag() string {
	if x != nil {
		return x.CustomTag
	}
	return ""
}

// Result of the numerical stats computation.
type AnalyzeDataSourceRiskDetails_NumericalStatsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum value appearing in the column.
	MinValue *Value `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Maximum value appearing in the column.
	MaxValue *Value `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// List of 99 values that partition the set of field values into 100 equal
	// sized buckets.
	QuantileValues []*Value `protobuf:"bytes,4,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_NumericalStatsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_NumericalStatsResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_NumericalStatsResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 0}
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMinValue() *Value {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetMaxValue() *Value {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_NumericalStatsResult) GetQuantileValues() []*Value {
	if x != nil {
		return x.QuantileValues
	}
	return nil
}

// Result of the categorical stats computation.
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of value frequencies in the column.
	ValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket `protobuf:"bytes,5,rep,name=value_frequency_histogram_buckets,json=valueFrequencyHistogramBuckets,proto3" json:"value_frequency_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_CategoricalStatsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_CategoricalStatsResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 1}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult) GetValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket {
	if x != nil {
		return x.ValueFrequencyHistogramBuckets
	}
	return nil
}

// Result of the k-anonymity computation.
type AnalyzeDataSourceRiskDetails_KAnonymityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of k-anonymity equivalence classes.
	EquivalenceClassHistogramBuckets []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket `protobuf:"bytes,5,rep,name=equivalence_class_histogram_buckets,json=equivalenceClassHistogramBuckets,proto3" json:"equivalence_class_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 2}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult) GetEquivalenceClassHistogramBuckets() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket {
	if x != nil {
		return x.EquivalenceClassHistogramBuckets
	}
	return nil
}

// Result of the l-diversity computation.
type AnalyzeDataSourceRiskDetails_LDiversityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Histogram of l-diversity equivalence class sensitive value frequencies.
	SensitiveValueFrequencyHistogramBuckets []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket `protobuf:"bytes,5,rep,name=sensitive_value_frequency_histogram_buckets,json=sensitiveValueFrequencyHistogramBuckets,proto3" json:"sensitive_value_frequency_histogram_buckets,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 3}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult) GetSensitiveValueFrequencyHistogramBuckets() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket {
	if x != nil {
		return x.SensitiveValueFrequencyHistogramBuckets
	}
	return nil
}

// Result of the reidentifiability analysis. Note that these results are an
// estimation, not exact values.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intervals [min_anonymity, max_anonymity] do not overlap. If a value
	// doesn't correspond to any such interval, the associated frequency is
	// zero. For example, the following records:
	//   {min_anonymity: 1, max_anonymity: 1, frequency: 17}
	//   {min_anonymity: 2, max_anonymity: 3, frequency: 42}
	//   {min_anonymity: 5, max_anonymity: 10, frequency: 99}
	// mean that there are no record with an estimated anonymity of 4, 5, or
	// larger than 10.
	KMapEstimationHistogram []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket `protobuf:"bytes,1,rep,name=k_map_estimation_histogram,json=kMapEstimationHistogram,proto3" json:"k_map_estimation_histogram,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 4}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult) GetKMapEstimationHistogram() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket {
	if x != nil {
		return x.KMapEstimationHistogram
	}
	return nil
}

// Result of the δ-presence computation. Note that these results are an
// estimation, not exact values.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intervals [min_probability, max_probability) do not overlap. If a
	// value doesn't correspond to any such interval, the associated frequency
	// is zero. For example, the following records:
	//   {min_probability: 0, max_probability: 0.1, frequency: 17}
	//   {min_probability: 0.2, max_probability: 0.3, frequency: 42}
	//   {min_probability: 0.3, max_probability: 0.4, frequency: 99}
	// mean that there are no record with an estimated probability in [0.1, 0.2)
	// nor larger or equal to 0.4.
	DeltaPresenceEstimationHistogram []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket `protobuf:"bytes,1,rep,name=delta_presence_estimation_histogram,json=deltaPresenceEstimationHistogram,proto3" json:"delta_presence_estimation_histogram,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 5}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult) GetDeltaPresenceEstimationHistogram() []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket {
	if x != nil {
		return x.DeltaPresenceEstimationHistogram
	}
	return nil
}

// Histogram of value frequencies in the column.
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the value frequency of the values in this bucket.
	ValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=value_frequency_lower_bound,json=valueFrequencyLowerBound,proto3" json:"value_frequency_lower_bound,omitempty"`
	// Upper bound on the value frequency of the values in this bucket.
	ValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=value_frequency_upper_bound,json=valueFrequencyUpperBound,proto3" json:"value_frequency_upper_bound,omitempty"`
	// Total number of values in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of value frequencies in this bucket. The total number of
	// values returned per bucket is capped at 20.
	BucketValues []*ValueFrequency `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct values in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 1, 0}
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyLowerBound() int64 {
	if x != nil {
		return x.ValueFrequencyLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetValueFrequencyUpperBound() int64 {
	if x != nil {
		return x.ValueFrequencyUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketValues() []*ValueFrequency {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// The set of columns' values that share the same ldiversity value
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of values defining the equivalence class. One value per
	// quasi-identifier column in the original KAnonymity metric message.
	// The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// Size of the equivalence class, for example number of rows with the
	// above set of values.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize,proto3" json:"equivalence_class_size,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 2, 0}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if x != nil {
		return x.EquivalenceClassSize
	}
	return 0
}

// Histogram of k-anonymity equivalence classes.
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeLowerBound int64 `protobuf:"varint,1,opt,name=equivalence_class_size_lower_bound,json=equivalenceClassSizeLowerBound,proto3" json:"equivalence_class_size_lower_bound,omitempty"`
	// Upper bound on the size of the equivalence classes in this bucket.
	EquivalenceClassSizeUpperBound int64 `protobuf:"varint,2,opt,name=equivalence_class_size_upper_bound,json=equivalenceClassSizeUpperBound,proto3" json:"equivalence_class_size_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct equivalence classes in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 2, 1}
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeLowerBound() int64 {
	if x != nil {
		return x.EquivalenceClassSizeLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetEquivalenceClassSizeUpperBound() int64 {
	if x != nil {
		return x.EquivalenceClassSizeUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// The set of columns' values that share the same ldiversity value.
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quasi-identifier values defining the k-anonymity equivalence
	// class. The order is always the same as the original request.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// Size of the k-anonymity equivalence class.
	EquivalenceClassSize int64 `protobuf:"varint,2,opt,name=equivalence_class_size,json=equivalenceClassSize,proto3" json:"equivalence_class_size,omitempty"`
	// Number of distinct sensitive values in this equivalence class.
	NumDistinctSensitiveValues int64 `protobuf:"varint,3,opt,name=num_distinct_sensitive_values,json=numDistinctSensitiveValues,proto3" json:"num_distinct_sensitive_values,omitempty"`
	// Estimated frequencies of top sensitive values.
	TopSensitiveValues []*ValueFrequency `protobuf:"bytes,4,rep,name=top_sensitive_values,json=topSensitiveValues,proto3" json:"top_sensitive_values,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 3, 0}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetEquivalenceClassSize() int64 {
	if x != nil {
		return x.EquivalenceClassSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetNumDistinctSensitiveValues() int64 {
	if x != nil {
		return x.NumDistinctSensitiveValues
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass) GetTopSensitiveValues() []*ValueFrequency {
	if x != nil {
		return x.TopSensitiveValues
	}
	return nil
}

// Histogram of l-diversity equivalence class sensitive value frequencies.
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyLowerBound int64 `protobuf:"varint,1,opt,name=sensitive_value_frequency_lower_bound,json=sensitiveValueFrequencyLowerBound,proto3" json:"sensitive_value_frequency_lower_bound,omitempty"`
	// Upper bound on the sensitive value frequencies of the equivalence
	// classes in this bucket.
	SensitiveValueFrequencyUpperBound int64 `protobuf:"varint,2,opt,name=sensitive_value_frequency_upper_bound,json=sensitiveValueFrequencyUpperBound,proto3" json:"sensitive_value_frequency_upper_bound,omitempty"`
	// Total number of equivalence classes in this bucket.
	BucketSize int64 `protobuf:"varint,3,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of equivalence classes in this bucket. The total number of
	// classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass `protobuf:"bytes,4,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct equivalence classes in this bucket.
	BucketValueCount int64 `protobuf:"varint,5,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 3, 1}
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyLowerBound() int64 {
	if x != nil {
		return x.SensitiveValueFrequencyLowerBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetSensitiveValueFrequencyUpperBound() int64 {
	if x != nil {
		return x.SensitiveValueFrequencyUpperBound
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// A tuple of values for the quasi-identifier columns.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quasi-identifier values.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// The estimated anonymity for these quasi-identifier values.
	EstimatedAnonymity int64 `protobuf:"varint,2,opt,name=estimated_anonymity,json=estimatedAnonymity,proto3" json:"estimated_anonymity,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) ProtoMessage() {}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 4, 0}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues) GetEstimatedAnonymity() int64 {
	if x != nil {
		return x.EstimatedAnonymity
	}
	return 0
}

// A KMapEstimationHistogramBucket message with the following values:
//   min_anonymity: 3
//   max_anonymity: 5
//   frequency: 42
// means that there are 42 records whose quasi-identifier values correspond
// to 3, 4 or 5 people in the overlying population. An important particular
// case is when min_anonymity = max_anonymity = 1: the frequency field then
// corresponds to the number of uniquely identifiable records.
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always positive.
	MinAnonymity int64 `protobuf:"varint,1,opt,name=min_anonymity,json=minAnonymity,proto3" json:"min_anonymity,omitempty"`
	// Always greater than or equal to min_anonymity.
	MaxAnonymity int64 `protobuf:"varint,2,opt,name=max_anonymity,json=maxAnonymity,proto3" json:"max_anonymity,omitempty"`
	// Number of records within these anonymity bounds.
	BucketSize int64 `protobuf:"varint,5,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of quasi-identifier tuple values in this bucket. The total
	// number of classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues `protobuf:"bytes,6,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct quasi-identifier tuple values in this bucket.
	BucketValueCount int64 `protobuf:"varint,7,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 4, 1}
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMinAnonymity() int64 {
	if x != nil {
		return x.MinAnonymity
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetMaxAnonymity() int64 {
	if x != nil {
		return x.MaxAnonymity
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// A tuple of values for the quasi-identifier columns.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quasi-identifier values.
	QuasiIdsValues []*Value `protobuf:"bytes,1,rep,name=quasi_ids_values,json=quasiIdsValues,proto3" json:"quasi_ids_values,omitempty"`
	// The estimated probability that a given individual sharing these
	// quasi-identifier values is in the dataset. This value, typically called
	// δ, is the ratio between the number of records in the dataset with these
	// quasi-identifier values, and the total number of individuals (inside
	// *and* outside the dataset) with these quasi-identifier values.
	// For example, if there are 15 individuals in the dataset who share the
	// same quasi-identifier values, and an estimated 100 people in the entire
	// population with these values, then δ is 0.15.
	EstimatedProbability float64 `protobuf:"fixed64,2,opt,name=estimated_probability,json=estimatedProbability,proto3" json:"estimated_probability,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 5, 0}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) GetQuasiIdsValues() []*Value {
	if x != nil {
		return x.QuasiIdsValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues) GetEstimatedProbability() float64 {
	if x != nil {
		return x.EstimatedProbability
	}
	return 0
}

// A DeltaPresenceEstimationHistogramBucket message with the following
// values:
//   min_probability: 0.1
//   max_probability: 0.2
//   frequency: 42
// means that there are 42 records for which δ is in [0.1, 0.2). An
// important particular case is when min_probability = max_probability = 1:
// then, every individual who shares this quasi-identifier combination is in
// the dataset.
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Between 0 and 1.
	MinProbability float64 `protobuf:"fixed64,1,opt,name=min_probability,json=minProbability,proto3" json:"min_probability,omitempty"`
	// Always greater than or equal to min_probability.
	MaxProbability float64 `protobuf:"fixed64,2,opt,name=max_probability,json=maxProbability,proto3" json:"max_probability,omitempty"`
	// Number of records within these probability bounds.
	BucketSize int64 `protobuf:"varint,5,opt,name=bucket_size,json=bucketSize,proto3" json:"bucket_size,omitempty"`
	// Sample of quasi-identifier tuple values in this bucket. The total
	// number of classes returned per bucket is capped at 20.
	BucketValues []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues `protobuf:"bytes,6,rep,name=bucket_values,json=bucketValues,proto3" json:"bucket_values,omitempty"`
	// Total number of distinct quasi-identifier tuple values in this bucket.
	BucketValueCount int64 `protobuf:"varint,7,opt,name=bucket_value_count,json=bucketValueCount,proto3" json:"bucket_value_count,omitempty"`
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) Reset() {
	*x = AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) ProtoMessage() {
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket.ProtoReflect.Descriptor instead.
func (*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{41, 5, 1}
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetMinProbability() float64 {
	if x != nil {
		return x.MinProbability
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetMaxProbability() float64 {
	if x != nil {
		return x.MaxProbability
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketSize() int64 {
	if x != nil {
		return x.BucketSize
	}
	return 0
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketValues() []*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues {
	if x != nil {
		return x.BucketValues
	}
	return nil
}

func (x *AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket) GetBucketValueCount() int64 {
	if x != nil {
		return x.BucketValueCount
	}
	return 0
}

// Time zone of the date time object.
type DateTime_TimeZone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set only if the offset can be determined. Positive for time ahead of UTC.
	// E.g. For "UTC-9", this value is -540.
	OffsetMinutes int32 `protobuf:"varint,1,opt,name=offset_minutes,json=offsetMinutes,proto3" json:"offset_minutes,omitempty"`
}

func (x *DateTime_TimeZone) Reset() {
	*x = DateTime_TimeZone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTime_TimeZone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTime_TimeZone) ProtoMessage() {}

func (x *DateTime_TimeZone) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTime_TimeZone.ProtoReflect.Descriptor instead.
func (*DateTime_TimeZone) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{45, 0}
}

func (x *DateTime_TimeZone) GetOffsetMinutes() int32 {
	if x != nil {
		return x.OffsetMinutes
	}
	return 0
}

// Throw an error and fail the request when a transformation error occurs.
type TransformationErrorHandling_ThrowError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransformationErrorHandling_ThrowError) Reset() {
	*x = TransformationErrorHandling_ThrowError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling_ThrowError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling_ThrowError) ProtoMessage() {}

func (x *TransformationErrorHandling_ThrowError) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling_ThrowError.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling_ThrowError) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 0}
}

// Skips the data without modifying it if the requested transformation would
// cause an error. For example, if a `DateShift` transformation were applied
// an an IP address, this mode would leave the IP address unchanged in the
// response.
type TransformationErrorHandling_LeaveUntransformed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TransformationErrorHandling_LeaveUntransformed) Reset() {
	*x = TransformationErrorHandling_LeaveUntransformed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationErrorHandling_LeaveUntransformed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationErrorHandling_LeaveUntransformed) ProtoMessage() {}

func (x *TransformationErrorHandling_LeaveUntransformed) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationErrorHandling_LeaveUntransformed.ProtoReflect.Descriptor instead.
func (*TransformationErrorHandling_LeaveUntransformed) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{47, 1}
}

// Bucket is represented as a range, along with replacement values.
type BucketingConfig_Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound of the range, inclusive. Type should be the same as max if
	// used.
	Min *Value `protobuf:"bytes,1,opt,name=min,proto3" json:"min,omitempty"`
	// Upper bound of the range, exclusive; type must match min.
	Max *Value `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
	// Required. Replacement value for this bucket.
	ReplacementValue *Value `protobuf:"bytes,3,opt,name=replacement_value,json=replacementValue,proto3" json:"replacement_value,omitempty"`
}

func (x *BucketingConfig_Bucket) Reset() {
	*x = BucketingConfig_Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[159]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketingConfig_Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketingConfig_Bucket) ProtoMessage() {}

func (x *BucketingConfig_Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[159]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketingConfig_Bucket.ProtoReflect.Descriptor instead.
func (*BucketingConfig_Bucket) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{58, 0}
}

func (x *BucketingConfig_Bucket) GetMin() *Value {
	if x != nil {
		return x.Min
	}
	return nil
}

func (x *BucketingConfig_Bucket) GetMax() *Value {
	if x != nil {
		return x.Max
	}
	return nil
}

func (x *BucketingConfig_Bucket) GetReplacementValue() *Value {
	if x != nil {
		return x.ReplacementValue
	}
	return nil
}

// A transformation to apply to text that is identified as a specific
// info_type.
type InfoTypeTransformations_InfoTypeTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// InfoTypes to apply the transformation to. An empty list will cause
	// this transformation to apply to all findings that correspond to
	// infoTypes that were requested in `InspectConfig`.
	InfoTypes []*InfoType `protobuf:"bytes,1,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
	// Required. Primitive transformation to apply to the infoType.
	PrimitiveTransformation *PrimitiveTransformation `protobuf:"bytes,2,opt,name=primitive_transformation,json=primitiveTransformation,proto3" json:"primitive_transformation,omitempty"`
}

func (x *InfoTypeTransformations_InfoTypeTransformation) Reset() {
	*x = InfoTypeTransformations_InfoTypeTransformation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoTypeTransformations_InfoTypeTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoTypeTransformations_InfoTypeTransformation) ProtoMessage() {}

func (x *InfoTypeTransformations_InfoTypeTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoTypeTransformations_InfoTypeTransformation.ProtoReflect.Descriptor instead.
func (*InfoTypeTransformations_InfoTypeTransformation) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{65, 0}
}

func (x *InfoTypeTransformations_InfoTypeTransformation) GetInfoTypes() []*InfoType {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

func (x *InfoTypeTransformations_InfoTypeTransformation) GetPrimitiveTransformation() *PrimitiveTransformation {
	if x != nil {
		return x.PrimitiveTransformation
	}
	return nil
}

// The field type of `value` and `field` do not need to match to be
// considered equal, but not all comparisons are possible.
// EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
// but all other comparisons are invalid with incompatible types.
// A `value` of type:
//
// - `string` can be compared against all other types
// - `boolean` can only be compared against other booleans
// - `integer` can be compared against doubles or a string if the string value
// can be parsed as an integer.
// - `double` can be compared against integers or a string if the string can
// be parsed as a double.
// - `Timestamp` can be compared against strings in RFC 3339 date string
// format.
// - `TimeOfDay` can be compared against timestamps and strings in the format
// of 'HH:mm:ss'.
//
// If we fail to compare do to type mismatch, a warning will be given and
// the condition will evaluate to false.
type RecordCondition_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field within the record this condition is evaluated against.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Required. Operator used to compare the field or infoType to the value.
	Operator RelationalOperator `protobuf:"varint,3,opt,name=operator,proto3,enum=google.privacy.dlp.v2.RelationalOperator" json:"operator,omitempty"`
	// Value to compare against. [Mandatory, except for `EXISTS` tests.]
	Value *Value `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RecordCondition_Condition) Reset() {
	*x = RecordCondition_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[161]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Condition) ProtoMessage() {}

func (x *RecordCondition_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[161]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Condition.ProtoReflect.Descriptor instead.
func (*RecordCondition_Condition) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69, 0}
}

func (x *RecordCondition_Condition) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *RecordCondition_Condition) GetOperator() RelationalOperator {
	if x != nil {
		return x.Operator
	}
	return RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED
}

func (x *RecordCondition_Condition) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// A collection of conditions.
type RecordCondition_Conditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of conditions.
	Conditions []*RecordCondition_Condition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *RecordCondition_Conditions) Reset() {
	*x = RecordCondition_Conditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[162]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Conditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Conditions) ProtoMessage() {}

func (x *RecordCondition_Conditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[162]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Conditions.ProtoReflect.Descriptor instead.
func (*RecordCondition_Conditions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69, 1}
}

func (x *RecordCondition_Conditions) GetConditions() []*RecordCondition_Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// An expression, consisting or an operator and conditions.
type RecordCondition_Expressions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operator to apply to the result of conditions. Default and currently
	// only supported value is `AND`.
	LogicalOperator RecordCondition_Expressions_LogicalOperator `protobuf:"varint,1,opt,name=logical_operator,json=logicalOperator,proto3,enum=google.privacy.dlp.v2.RecordCondition_Expressions_LogicalOperator" json:"logical_operator,omitempty"`
	// Expression types.
	//
	// Types that are assignable to Type:
	//	*RecordCondition_Expressions_Conditions
	Type isRecordCondition_Expressions_Type `protobuf_oneof:"type"`
}

func (x *RecordCondition_Expressions) Reset() {
	*x = RecordCondition_Expressions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordCondition_Expressions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordCondition_Expressions) ProtoMessage() {}

func (x *RecordCondition_Expressions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordCondition_Expressions.ProtoReflect.Descriptor instead.
func (*RecordCondition_Expressions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{69, 2}
}

func (x *RecordCondition_Expressions) GetLogicalOperator() RecordCondition_Expressions_LogicalOperator {
	if x != nil {
		return x.LogicalOperator
	}
	return RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED
}

func (m *RecordCondition_Expressions) GetType() isRecordCondition_Expressions_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *RecordCondition_Expressions) GetConditions() *RecordCondition_Conditions {
	if x, ok := x.GetType().(*RecordCondition_Expressions_Conditions); ok {
		return x.Conditions
	}
	return nil
}

type isRecordCondition_Expressions_Type interface {
	isRecordCondition_Expressions_Type()
}

type RecordCondition_Expressions_Conditions struct {
	// Conditions to apply to the expression.
	Conditions *RecordCondition_Conditions `protobuf:"bytes,3,opt,name=conditions,proto3,oneof"`
}

func (*RecordCondition_Expressions_Conditions) isRecordCondition_Expressions_Type() {}

// A collection that informs the user the number of times a particular
// `TransformationResultCode` and error details occurred.
type TransformationSummary_SummaryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of transformations counted by this result.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Outcome of the transformation.
	Code TransformationSummary_TransformationResultCode `protobuf:"varint,2,opt,name=code,proto3,enum=google.privacy.dlp.v2.TransformationSummary_TransformationResultCode" json:"code,omitempty"`
	// A place for warnings or errors to show up if a transformation didn't
	// work as expected.
	Details string `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *TransformationSummary_SummaryResult) Reset() {
	*x = TransformationSummary_SummaryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformationSummary_SummaryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformationSummary_SummaryResult) ProtoMessage() {}

func (x *TransformationSummary_SummaryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformationSummary_SummaryResult.ProtoReflect.Descriptor instead.
func (*TransformationSummary_SummaryResult) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{71, 0}
}

func (x *TransformationSummary_SummaryResult) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *TransformationSummary_SummaryResult) GetCode() TransformationSummary_TransformationResultCode {
	if x != nil {
		return x.Code
	}
	return TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED
}

func (x *TransformationSummary_SummaryResult) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// What event needs to occur for a new job to be started.
type JobTrigger_Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Trigger:
	//	*JobTrigger_Trigger_Schedule
	//	*JobTrigger_Trigger_Manual
	Trigger isJobTrigger_Trigger_Trigger `protobuf_oneof:"trigger"`
}

func (x *JobTrigger_Trigger) Reset() {
	*x = JobTrigger_Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTrigger_Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTrigger_Trigger) ProtoMessage() {}

func (x *JobTrigger_Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTrigger_Trigger.ProtoReflect.Descriptor instead.
func (*JobTrigger_Trigger) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{77, 0}
}

func (m *JobTrigger_Trigger) GetTrigger() isJobTrigger_Trigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *JobTrigger_Trigger) GetSchedule() *Schedule {
	if x, ok := x.GetTrigger().(*JobTrigger_Trigger_Schedule); ok {
		return x.Schedule
	}
	return nil
}

func (x *JobTrigger_Trigger) GetManual() *Manual {
	if x, ok := x.GetTrigger().(*JobTrigger_Trigger_Manual); ok {
		return x.Manual
	}
	return nil
}

type isJobTrigger_Trigger_Trigger interface {
	isJobTrigger_Trigger_Trigger()
}

type JobTrigger_Trigger_Schedule struct {
	// Create a job on a repeating basis based on the elapse of time.
	Schedule *Schedule `protobuf:"bytes,1,opt,name=schedule,proto3,oneof"`
}

type JobTrigger_Trigger_Manual struct {
	// For use with hybrid jobs. Jobs must be manually created and finished.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	Manual *Manual `protobuf:"bytes,2,opt,name=manual,proto3,oneof"`
}

func (*JobTrigger_Trigger_Schedule) isJobTrigger_Trigger_Trigger() {}

func (*JobTrigger_Trigger_Manual) isJobTrigger_Trigger_Trigger() {}

// If set, the detailed findings will be persisted to the specified
// OutputStorageConfig. Only a single instance of this action can be
// specified.
// Compatible with: Inspect, Risk
type Action_SaveFindings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location to store findings outside of DLP.
	OutputConfig *OutputStorageConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *Action_SaveFindings) Reset() {
	*x = Action_SaveFindings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_SaveFindings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_SaveFindings) ProtoMessage() {}

func (x *Action_SaveFindings) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_SaveFindings.ProtoReflect.Descriptor instead.
func (*Action_SaveFindings) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 0}
}

func (x *Action_SaveFindings) GetOutputConfig() *OutputStorageConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Publish a message into given Pub/Sub topic when DlpJob has completed. The
// message contains a single field, `DlpJobName`, which is equal to the
// finished job's
// [`DlpJob.name`](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
// Compatible with: Inspect, Risk
type Action_PublishToPubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Pub/Sub topic to send notifications to. The topic must have given
	// publishing access rights to the DLP API service account executing
	// the long running DlpJob sending the notifications.
	// Format is projects/{project}/topics/{topic}.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *Action_PublishToPubSub) Reset() {
	*x = Action_PublishToPubSub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishToPubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishToPubSub) ProtoMessage() {}

func (x *Action_PublishToPubSub) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishToPubSub.ProtoReflect.Descriptor instead.
func (*Action_PublishToPubSub) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 1}
}

func (x *Action_PublishToPubSub) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Publish the result summary of a DlpJob to the Cloud Security
// Command Center (CSCC Alpha).
// This action is only available for projects which are parts of
// an organization and whitelisted for the alpha Cloud Security Command
// Center.
// The action will publish count of finding instances and their info types.
// The summary of findings will be persisted in CSCC and are governed by CSCC
// service-specific policy, see https://cloud.google.com/terms/service-terms
// Only a single instance of this action can be specified.
// Compatible with: Inspect
type Action_PublishSummaryToCscc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishSummaryToCscc) Reset() {
	*x = Action_PublishSummaryToCscc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishSummaryToCscc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishSummaryToCscc) ProtoMessage() {}

func (x *Action_PublishSummaryToCscc) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishSummaryToCscc.ProtoReflect.Descriptor instead.
func (*Action_PublishSummaryToCscc) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 2}
}

// Publish findings of a DlpJob to Cloud Data Catalog. Labels summarizing the
// results of the DlpJob will be applied to the entry for the resource scanned
// in Cloud Data Catalog. Any labels previously written by another DlpJob will
// be deleted. InfoType naming patterns are strictly enforced when using this
// feature. Note that the findings will be persisted in Cloud Data Catalog
// storage and are governed by Data Catalog service-specific policy, see
// https://cloud.google.com/terms/service-terms
// Only a single instance of this action can be specified and only allowed if
// all resources being scanned are BigQuery tables.
// Compatible with: Inspect
type Action_PublishFindingsToCloudDataCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishFindingsToCloudDataCatalog) Reset() {
	*x = Action_PublishFindingsToCloudDataCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[169]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishFindingsToCloudDataCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishFindingsToCloudDataCatalog) ProtoMessage() {}

func (x *Action_PublishFindingsToCloudDataCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[169]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishFindingsToCloudDataCatalog.ProtoReflect.Descriptor instead.
func (*Action_PublishFindingsToCloudDataCatalog) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 3}
}

// Enable email notification to project owners and editors on jobs's
// completion/failure.
type Action_JobNotificationEmails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_JobNotificationEmails) Reset() {
	*x = Action_JobNotificationEmails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[170]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_JobNotificationEmails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_JobNotificationEmails) ProtoMessage() {}

func (x *Action_JobNotificationEmails) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[170]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_JobNotificationEmails.ProtoReflect.Descriptor instead.
func (*Action_JobNotificationEmails) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 4}
}

// Enable Stackdriver metric dlp.googleapis.com/finding_count. This
// will publish a metric to stack driver on each infotype requested and
// how many findings were found for it. CustomDetectors will be bucketed
// as 'Custom' under the Stackdriver label 'info_type'.
type Action_PublishToStackdriver struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_PublishToStackdriver) Reset() {
	*x = Action_PublishToStackdriver{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[171]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_PublishToStackdriver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_PublishToStackdriver) ProtoMessage() {}

func (x *Action_PublishToStackdriver) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_dlp_proto_msgTypes[171]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_PublishToStackdriver.ProtoReflect.Descriptor instead.
func (*Action_PublishToStackdriver) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP(), []int{78, 5}
}

var File_google_privacy_dlp_v2_dlp_proto protoreflect.FileDescriptor

var file_google_privacy_dlp_v2_dlp_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2f, 0x64, 0x6c, 0x70, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x6c, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2f, 0x64, 0x6c,
	0x70, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x52, 0x0a, 0x10, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22,
	0xd3, 0x02, 0x0a, 0x0d, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x52, 0x0a, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x67, 0x65,
	0x78, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x57, 0x0a, 0x12, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0c, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x0c, 0x68, 0x6f, 0x74, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x0b, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4d,
	0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3e, 0x0a, 0x0a, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x8d, 0x07, 0x0a, 0x0d, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0e, 0x6d, 0x69,
	0x6e, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69,
	0x68, 0x6f, 0x6f, 0x64, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x71, 0x75, 0x6f, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x51, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x08, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x1a, 0xeb, 0x02, 0x0a, 0x0d, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x15,
	0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6d, 0x61, 0x78,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x65, 0x72, 0x49, 0x74, 0x65, 0x6d, 0x12,
	0x37, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7c, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x16,
	0x6d, 0x61, 0x78, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x70, 0x0a, 0x0d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x78,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xa4, 0x02, 0x0a, 0x0f, 0x42, 0x79, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x44, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74,
	0x65, 0x6d, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xb6, 0x01, 0x0a, 0x09, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x59, 0x54, 0x45, 0x53, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x49,
	0x4d, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x50, 0x45, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x49,
	0x4d, 0x41, 0x47, 0x45, 0x5f, 0x42, 0x4d, 0x50, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d,
	0x41, 0x47, 0x45, 0x5f, 0x50, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x41,
	0x47, 0x45, 0x5f, 0x53, 0x56, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x45, 0x58, 0x54,
	0x5f, 0x55, 0x54, 0x46, 0x38, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x57, 0x4f, 0x52, 0x44, 0x5f,
	0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x07, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x44,
	0x46, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x56, 0x52, 0x4f, 0x10, 0x0b, 0x12, 0x07, 0x0a,
	0x03, 0x43, 0x53, 0x56, 0x10, 0x0c, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x53, 0x56, 0x10, 0x0d, 0x22,
	0xaf, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12,
	0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x45, 0x0a,
	0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x48, 0x00, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x22, 0xb4, 0x01, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x38, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x34, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x1a, 0x3b, 0x0a, 0x03, 0x52,
	0x6f, 0x77, 0x12, 0x34, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x7a, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3a, 0x0a, 0x08, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x22, 0xd6, 0x06, 0x0a, 0x07, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08,
	0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x6c, 0x69, 0x6b, 0x65,
	0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52,
	0x0a, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x3b, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0a, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x71, 0x75, 0x6f,
	0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x43, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xfa,
	0x41, 0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0c, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x42, 0x0a, 0x0f, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6a, 0x6f, 0x62,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x08, 0x6a, 0x6f,
	0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xfa, 0x41,
	0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x5b, 0xea, 0x41, 0x58, 0x0a, 0x1a, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x22, 0xa3, 0x02,
	0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0a, 0x62, 0x79,
	0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x62, 0x79,
	0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x6f, 0x64, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0e,
	0x63, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x53,
	0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x22, 0x8f, 0x04, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x50,
	0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x56, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x11, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2b, 0x0a, 0x11,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x10, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x22, 0x28, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x33, 0x0a, 0x10, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0xd9, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x4b, 0x65, 0x79, 0x12, 0x39, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x4b,
	0x0a, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2c, 0x0a, 0x0d, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x72, 0x6f, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xf4, 0x01, 0x0a, 0x09, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66,
	0x75, 0x6c, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x74, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x74,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x2f, 0x0a, 0x05, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x22, 0x5a, 0x0a, 0x0d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62,
	0x6f, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x0d,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x65, 0x73, 0x22, 0x61, 0x0a,
	0x0b, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x10, 0x0a, 0x03,
	0x74, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x74, 0x6f, 0x70, 0x12, 0x12,
	0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6c, 0x65,
	0x66, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x22, 0xfa, 0x04, 0x0a, 0x12, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x76, 0x0a, 0x17, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63,
	0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x15, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52,
	0x08, 0x62, 0x79, 0x74, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x1a, 0xd1, 0x01, 0x0a, 0x14, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3e, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x5f, 0x61, 0x6c, 0x6c,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x72,
	0x65, 0x64, 0x61, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x12, 0x45, 0x0a, 0x0f,
	0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x52, 0x0e, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x43, 0x0a,
	0x05, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x03, 0x72, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x65, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x62, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x62, 0x6c,
	0x75, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x64, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0d, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xc0, 0x03, 0x0a, 0x18, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54,
	0x0a, 0x11, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x10, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a,
	0x18, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9e, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x49,
	0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x52,
	0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc3, 0x03, 0x0a, 0x18, 0x52, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d,
	0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x11, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x72, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0e, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d,
	0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x13, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22,
	0x9e, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x49, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x76,
	0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77,
	0x22, 0xad, 0x02, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x12,
	0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x32, 0x0a, 0x15, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x56, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xcc, 0x02, 0x0a, 0x13, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3c, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x5c,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x90, 0x01, 0x0a,
	0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1d, 0x0a,
	0x19, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x47, 0x43, 0x53, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x49, 0x47, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x04, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x05, 0x42,
	0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x63, 0x0a, 0x0d, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa3, 0x05, 0x0a,
	0x18, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xbe, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a,
	0x19, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x17, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x46, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09,
	0x6a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x86, 0x02, 0x0a, 0x06, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x32, 0x0a,
	0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x4c, 0x0a, 0x0f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x0d, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x51, 0x0a, 0x0c, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79,
	0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x0b, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x22, 0x8c, 0x01, 0x0a, 0x17, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x62, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x61, 0x62, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0c, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xbd, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x52, 0x0b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x22, 0x62, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x22, 0xe6, 0x01, 0x0a, 0x15, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b,
	0x0a, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x47, 0x0a, 0x0c, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe2, 0x01,
	0x0a, 0x07, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x3e, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74,
	0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x54, 0x61, 0x67, 0x12, 0x34, 0x0a, 0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48,
	0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x74,
	0x61, 0x67, 0x22, 0xf4, 0x02, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x5e, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73,
	0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x6b, 0x0a, 0x14,
	0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x22, 0x86, 0x12, 0x0a, 0x0d, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x71, 0x0a, 0x16, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77,
	0x0a, 0x18, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x16, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x12, 0x6b, 0x5f, 0x61, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x6b, 0x41,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65,
	0x0a, 0x12, 0x6c, 0x5f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x2e, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x72, 0x0a, 0x17, 0x6b, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61,
	0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x14, 0x6b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8d, 0x01, 0x0a, 0x20, 0x64, 0x65,
	0x6c, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1d, 0x64, 0x65, 0x6c, 0x74,
	0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x4c, 0x0a, 0x14, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64,
	0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x4e, 0x0a, 0x16, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64,
	0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x1a, 0x8d, 0x01, 0x0a, 0x10, 0x4b, 0x41, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x09,
	0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52,
	0x08, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x09, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x52, 0x08, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x1a, 0xa0, 0x01, 0x0a, 0x10, 0x4c, 0x44, 0x69, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x09,
	0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52,
	0x08, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x13, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x12, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x1a, 0x84, 0x07, 0x0a, 0x14, 0x4b,
	0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61,
	0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x73, 0x0a,
	0x10, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d,
	0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x0f, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x1a, 0xe6, 0x01, 0x0a, 0x0b, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x39, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3e, 0x0a,
	0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a,
	0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61, 0x67, 0x12, 0x34,
	0x0a, 0x08, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x1a, 0x83, 0x03, 0x0a, 0x0e,
	0x41, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3f,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x77, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75,
	0x78, 0x69, 0x6c, 0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x51, 0x75, 0x61,
	0x73, 0x69, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x52, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x63, 0x0a, 0x0c,
	0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x34, 0x0a, 0x05,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x74, 0x61, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x61,
	0x67, 0x1a, 0xd6, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65,
	0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x51,
	0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x71, 0x75, 0x61,
	0x73, 0x69, 0x49, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x10, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69,
	0x61, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0f, 0x61, 0x75, 0x78, 0x69, 0x6c,
	0x69, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x93, 0x26, 0x0a, 0x1c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x5e, 0x0a, 0x18, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x5a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x80, 0x01, 0x0a, 0x16, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14, 0x6e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x86, 0x01, 0x0a, 0x18, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x16, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x74, 0x0a, 0x12, 0x6b,
	0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e,
	0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x10, 0x6b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x74, 0x0a, 0x12, 0x6c, 0x5f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x17, 0x6b, 0x5f, 0x6d, 0x61,
	0x70, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b,
	0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14, 0x6b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x9c, 0x01, 0x0a, 0x20,
	0x64, 0x65, 0x6c, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x74,
	0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x64, 0x65, 0x6c,
	0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xd3, 0x01, 0x0a, 0x14, 0x4e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x39, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x39,
	0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x71, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0e, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x1a, 0x8d, 0x04, 0x0a, 0x16, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xb5, 0x01, 0x0a, 0x21,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x1e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x1a, 0xba, 0x02, 0x0a, 0x1f, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69,
	0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x6f, 0x77, 0x65,
	0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x3d, 0x0a, 0x1b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x55, 0x70, 0x70, 0x65, 0x72,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0xeb, 0x05, 0x0a, 0x10, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xad, 0x01, 0x0a, 0x23, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61,
	0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x68, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x20, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x9a, 0x01, 0x0a, 0x1a, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x69, 0x74, 0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75,
	0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16,
	0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x65, 0x71,
	0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69,
	0x7a, 0x65, 0x1a, 0x89, 0x03, 0x0a, 0x19, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74,
	0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x4a, 0x0a, 0x22, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x65, 0x71,
	0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69,
	0x7a, 0x65, 0x4c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x4a, 0x0a, 0x22,
	0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61,
	0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x55, 0x70,
	0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x0d, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69,
	0x74, 0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xa2,
	0x07, 0x0a, 0x10, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0xbc, 0x01, 0x0a, 0x2b, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c,
	0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x27, 0x73, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x1a, 0xb6, 0x02, 0x0a, 0x1a, 0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74,
	0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x73, 0x69,
	0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x71, 0x75,
	0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x65, 0x71, 0x75, 0x69, 0x76,
	0x61, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x41, 0x0a, 0x1d, 0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f,
	0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x6e, 0x75, 0x6d, 0x44, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x63, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x57, 0x0a, 0x14, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x12, 0x74, 0x6f, 0x70, 0x53, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x95, 0x03, 0x0a, 0x19,
	0x4c, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x25, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x21, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x4c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x50, 0x0a, 0x25, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x21, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x55, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x84,
	0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x44, 0x69, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x44, 0x69,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x45, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e,
	0x63, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0x9c, 0x05, 0x0a, 0x14, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xa3, 0x01, 0x0a,
	0x1a, 0x6b, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x4d, 0x61, 0x70,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x17, 0x6b, 0x4d, 0x61, 0x70, 0x45,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x1a, 0x96, 0x01, 0x0a, 0x1b, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69, 0x5f, 0x69, 0x64, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x73,
	0x69, 0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x65, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x1a, 0xc4, 0x02, 0x0a, 0x1d,
	0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x69,
	0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x41, 0x6e,
	0x6f, 0x6e, 0x79, 0x6d, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4b, 0x4d, 0x61, 0x70, 0x45,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0xf9, 0x05, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73,
	0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0xc7, 0x01, 0x0a, 0x23, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x5f, 0x70,
	0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65,
	0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65,
	0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x20, 0x64, 0x65,
	0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x1a, 0xa3,
	0x01, 0x0a, 0x24, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65,
	0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x71, 0x75, 0x61, 0x73, 0x69,
	0x5f, 0x69, 0x64, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x71, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x33, 0x0a, 0x15, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x1a, 0xe7, 0x02, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f,
	0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x9b, 0x01, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x76, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x44, 0x65, 0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x44, 0x65,
	0x6c, 0x74, 0x61, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x73, 0x69, 0x49, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x5a, 0x0a, 0x0e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x9e, 0x03, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25,
	0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a,
	0x0d, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a, 0x11, 0x64, 0x61, 0x79, 0x5f,
	0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x64,
	0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5b, 0x0a, 0x09, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x3e, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x08, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x73, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x6f,
	0x74, 0x65, 0x22, 0x8f, 0x02, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66,
	0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57,
	0x65, 0x65, 0x6b, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x2a,
	0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f,
	0x66, 0x44, 0x61, 0x79, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x1a, 0x31, 0x0a, 0x08, 0x54, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x4d, 0x69, 0x6e,
	0x75, 0x74, 0x65, 0x73, 0x22, 0xf1, 0x02, 0x0a, 0x10, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6c, 0x0a, 0x19, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x17,
	0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x76,
	0x0a, 0x1d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x02, 0x0a, 0x1b, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x60, 0x0a, 0x0b, 0x74, 0x68, 0x72, 0x6f,
	0x77, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x54, 0x68, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0a,
	0x74, 0x68, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x78, 0x0a, 0x13, 0x6c, 0x65,
	0x61, 0x76, 0x65, 0x5f, 0x75, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x55, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x12, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x55, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x65, 0x64, 0x1a, 0x0c, 0x0a, 0x0a, 0x54, 0x68, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x1a, 0x14, 0x0a, 0x12, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x55, 0x6e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x42, 0x06, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x22, 0xd6, 0x08, 0x0a, 0x17, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0e,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4a, 0x0a, 0x0d, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c,
	0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x15,
	0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x13, 0x63, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74,
	0x0a, 0x1d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x5f, 0x66, 0x66, 0x78, 0x5f, 0x66, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x1b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x10, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x1d, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x57, 0x69, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x57,
	0x69, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x51, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x12, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x48,
	0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a,
	0x11, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x69, 0x66, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68, 0x69, 0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x65, 0x53, 0x68, 0x69, 0x66, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x72, 0x0a, 0x1b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xeb, 0x01, 0x0a, 0x0e, 0x54, 0x69,
	0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x0f,
	0x70, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x50, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x54, 0x6f, 0x45, 0x78, 0x74,
	0x72, 0x61, 0x63, 0x74, 0x22, 0x80, 0x01, 0x0a, 0x08, 0x54, 0x69, 0x6d, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x59, 0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10,
	0x02, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x41, 0x59, 0x5f, 0x4f, 0x46, 0x5f, 0x4d, 0x4f, 0x4e, 0x54,
	0x48, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x59, 0x5f, 0x4f, 0x46, 0x5f, 0x57, 0x45,
	0x45, 0x4b, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x57, 0x45, 0x45, 0x4b, 0x5f, 0x4f, 0x46, 0x5f,
	0x59, 0x45, 0x41, 0x52, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x4f,
	0x46, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x06, 0x22, 0x53, 0x0a, 0x10, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x0a, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x22, 0xe7, 0x01, 0x0a,
	0x19, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x0a, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x4f, 0x0a, 0x13, 0x73,
	0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x73, 0x75, 0x72, 0x72, 0x6f,
	0x67, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x4f, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x09,
	0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e,
	0x65, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x57, 0x69, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x0e, 0x0a, 0x0c, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xe2, 0x02, 0x0a, 0x0d, 0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f,
	0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73,
	0x54, 0x6f, 0x53, 0x6b, 0x69, 0x70, 0x12, 0x79, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72,
	0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4f, 0x4d,
	0x4d, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x53, 0x5f, 0x54, 0x4f, 0x5f, 0x49, 0x47, 0x4e,
	0x4f, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x41,
	0x53, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x4c, 0x4f,
	0x57, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x55,
	0x4e, 0x43, 0x54, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x57,
	0x48, 0x49, 0x54, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x05, 0x42, 0x0c, 0x0a, 0x0a, 0x63,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x22, 0xe5, 0x01, 0x0a, 0x13, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x61,
	0x73, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x12, 0x24,
	0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x54, 0x6f,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x5f,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x65, 0x76,
	0x65, 0x72, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x14, 0x63, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x69, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x68, 0x61, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x52, 0x12, 0x63,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x49, 0x67, 0x6e, 0x6f, 0x72,
	0x65, 0x22, 0xc8, 0x01, 0x0a, 0x18, 0x46, 0x69, 0x78, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42,
	0x0a, 0x0b, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x12, 0x42, 0x0a, 0x0b, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x70, 0x65,
	0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x95, 0x02, 0x0a,
	0x0f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x47, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0xb8, 0x01, 0x0a, 0x06, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x2e, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x6d, 0x69, 0x6e, 0x12, 0x2e, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x6d, 0x61, 0x78, 0x12, 0x4e, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xc7, 0x04, 0x0a, 0x19, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x44, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x73, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x62, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x46, 0x66, 0x78, 0x46, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x66,
	0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0x62, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x12, 0x29, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x62,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x72, 0x61, 0x64, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61, 0x64, 0x69, 0x78, 0x12, 0x4f, 0x0a, 0x13, 0x73, 0x75,
	0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x17,
	0x46, 0x66, 0x78, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x26, 0x46, 0x46, 0x58, 0x5f, 0x43,
	0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x5f, 0x4e, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x4c, 0x50,
	0x48, 0x41, 0x42, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x45, 0x58, 0x41, 0x44, 0x45, 0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10,
	0x02, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f,
	0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x03, 0x12,
	0x11, 0x0a, 0x0d, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43,
	0x10, 0x04, 0x42, 0x0a, 0x0a, 0x08, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x22, 0xfa,
	0x01, 0x0a, 0x09, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x49, 0x0a, 0x09,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x09, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x75, 0x6e, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x6e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x09, 0x75, 0x6e, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x4b, 0x6d, 0x73, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x2d, 0x0a, 0x12, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2b, 0x0a, 0x12, 0x55, 0x6e,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x68, 0x0a, 0x13, 0x4b, 0x6d, 0x73, 0x57, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x64, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x24,
	0x0a, 0x0b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x4b, 0x65, 0x79, 0x12, 0x2b, 0x0a, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0xf6, 0x01, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68, 0x69, 0x66, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x44, 0x61, 0x79, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x44,
	0x61, 0x79, 0x73, 0x12, 0x38, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x41, 0x0a,
	0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x09, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x42, 0x08, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xda, 0x02, 0x0a, 0x17, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x74, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xc8, 0x01, 0x0a,
	0x16, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x18, 0x70, 0x72, 0x69, 0x6d, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17,
	0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x03, 0x0a, 0x13, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3b, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x44, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x18, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x6c, 0x0a, 0x19, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x10, 0x0a,
	0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xd3, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x15, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x13, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x59, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53,
	0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xaa, 0x05, 0x0a, 0x0f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xc6, 0x01, 0x0a, 0x09, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x32, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x5e, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x50, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x97, 0x02, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6d, 0x0a, 0x10, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x53, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x3c, 0x0a, 0x0f, 0x4c, 0x6f, 0x67, 0x69, 0x63,
	0x61, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x4f,
	0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x41, 0x4e, 0x44, 0x10, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xae, 0x01,
	0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0x97,
	0x06, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x56, 0x0a, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69,
	0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x15, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f,
	0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x75, 0x70,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x53, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x2b,
	0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x9a, 0x01, 0x0a, 0x0d,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x5e, 0x0a, 0x18, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52,
	0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0x6f, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x1a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x08, 0x0a, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x08, 0x0a, 0x06, 0x4d, 0x61, 0x6e,
	0x75, 0x61, 0x6c, 0x22, 0x89, 0x05, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0xc6, 0x02, 0xea, 0x41, 0xc2, 0x02, 0x0a, 0x22, 0x64,
	0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x40, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x7d, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12, 0x55, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x7d, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x22,
	0xb0, 0x05, 0x0a, 0x12, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x64, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0xe1,
	0x02, 0xea, 0x41, 0xdd, 0x02, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x46, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x7d, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x7d, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x12,
	0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x7d, 0x22, 0x71, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2c, 0x0a, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x73, 0x22, 0xba, 0x07, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a,
	0x0b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0a, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x45, 0x0a, 0x08, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x12, 0x39, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x43, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x75, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x8c, 0x01, 0x0a, 0x07,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x08, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x42,
	0x09, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x48, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x3a, 0x94, 0x01, 0xea, 0x41, 0x90, 0x01, 0x0a, 0x1d, 0x64, 0x6c, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6a,
	0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x7d, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x7d, 0x42, 0x05, 0x0a, 0x03, 0x6a,
	0x6f, 0x62, 0x22, 0x86, 0x07, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a,
	0x0d, 0x73, 0x61, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x48, 0x00, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x48, 0x0a, 0x07, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x48, 0x00, 0x52, 0x06, 0x70, 0x75, 0x62, 0x53, 0x75, 0x62, 0x12, 0x6b, 0x0a, 0x17, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x6f,
	0x5f, 0x63, 0x73, 0x63, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x6f, 0x43, 0x73, 0x63, 0x63, 0x48,
	0x00, 0x52, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x54, 0x6f, 0x43, 0x73, 0x63, 0x63, 0x12, 0x94, 0x01, 0x0a, 0x26, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x74, 0x6f, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x6f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x48, 0x00, 0x52, 0x21, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x6f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x6d,
	0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4a,
	0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x15, 0x6a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6a, 0x0a,
	0x16, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x1a, 0x5f, 0x0a, 0x0c, 0x53, 0x61, 0x76,
	0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x27, 0x0a, 0x0f, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x1a, 0x16, 0x0a, 0x14, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x6f, 0x43, 0x73, 0x63, 0x63, 0x1a, 0x23, 0x0a, 0x21, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x54, 0x6f,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x1a, 0x17, 0x0a, 0x15, 0x4a, 0x6f, 0x62, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x16, 0x0a, 0x14, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x54, 0x6f, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfc, 0x01, 0x0a, 0x1c,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x56, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xee, 0x01, 0x0a, 0x1c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x10, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x19, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x12, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9b, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe1, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a,
	0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6a, 0x6f, 0x62, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x56, 0x0a, 0x19, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5,
	0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x0a, 0x6a,
	0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x51, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x02, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x12, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c,
	0x70, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0b,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x69, 0x73, 0x6b,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4a,
	0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x07, 0x72, 0x69, 0x73, 0x6b,
	0x4a, 0x6f, 0x62, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x42, 0x05, 0x0a, 0x03, 0x6a,
	0x6f, 0x62, 0x22, 0xe7, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x87, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x52, 0x0b, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x02, 0x0a,
	0x10, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x4b, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b,
	0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x37, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd3, 0x06, 0x0a, 0x06, 0x44, 0x6c, 0x70,
	0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c,
	0x70, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3c,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x58, 0x0a, 0x0c,
	0x72, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x69, 0x73, 0x6b,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x22, 0x6f, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a,
	0x15, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x06, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a,
	0x6f, 0x62, 0x12, 0x24, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b,
	0x64, 0x6c, 0x70, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x64, 0x6c, 0x70, 0x5f, 0x6a,
	0x6f, 0x62, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x49,
	0x0a, 0x10, 0x47, 0x65, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70,
	0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x02, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x12, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70,
	0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0x70, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x6a, 0x6f, 0x62,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4c, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x6c,
	0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x4c, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x44, 0x6c, 0x70, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a,
	0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x4c, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x64,
	0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8b,
	0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x6c, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x13, 0x64, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xfd, 0x01, 0x0a,
	0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x13, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x12, 0x64, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x61, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xdf, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x6c, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0xa7, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x14, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x13,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64, 0x0a, 0x1f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa4, 0x02, 0x0a, 0x1b, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x48, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52,
	0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x61, 0x0a, 0x16, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x4e,
	0x0a, 0x0f, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x48, 0x00, 0x52,
	0x0d, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x4a, 0x0a, 0x1a, 0x4c, 0x61, 0x72, 0x67,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72,
	0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78,
	0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x4e, 0x75, 0x6d, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x73, 0x22, 0xea, 0x02, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x17, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x72, 0x67,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x15, 0x6c, 0x61, 0x72, 0x67, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79,
	0x12, 0x52, 0x0a, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x72, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x67, 0x65, 0x78,
	0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x8a, 0x01, 0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x6b, 0x0a, 0x17, 0x6c, 0x61, 0x72,
	0x67, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52,
	0x15, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xd3,
	0x02, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x22, 0x98, 0x04, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x10, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0xc1, 0x02, 0xea, 0x41,
	0xbd, 0x02, 0x0a, 0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x12, 0x35, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x12, 0x54, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x7d, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x22,
	0xfa, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x13,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xde, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a,
	0x18, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12,
	0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0x98, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x51, 0x0a, 0x11, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x1e,
	0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x68, 0x79, 0x62,
	0x72, 0x69, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0a, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64,
	0x49, 0x74, 0x65, 0x6d, 0x22, 0x9e, 0x01, 0x0a, 0x1a, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x64, 0x6c, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c,
	0x70, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x68, 0x79,
	0x62, 0x72, 0x69, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0a, 0x68, 0x79, 0x62, 0x72, 0x69,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x22, 0xa1, 0x01, 0x0a, 0x11, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x36, 0x0a, 0x04, 0x69,
	0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04, 0x69,
	0x74, 0x65, 0x6d, 0x12, 0x54, 0x0a, 0x0f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xfb, 0x02, 0x0a, 0x14, 0x48, 0x79,
	0x62, 0x72, 0x69, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x4d, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x48, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x17, 0x0a, 0x15, 0x48, 0x79, 0x62, 0x72, 0x69,
	0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2a, 0xbb, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x4c, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x45, 0x51, 0x55, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f,
	0x54, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x5f, 0x54, 0x4f, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c,
	0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x04, 0x12, 0x1a, 0x0a,
	0x16, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52,
	0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x53, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x45, 0x53,
	0x53, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x53,
	0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x07, 0x2a, 0x8d,
	0x01, 0x0a, 0x0c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c,
	0x0a, 0x18, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x02, 0x12, 0x1f, 0x0a,
	0x1b, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49,
	0x4e, 0x56, 0x45, 0x52, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x03, 0x2a, 0x4d,
	0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f, 0x4e, 0x54,
	0x45, 0x4e, 0x54, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f,
	0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02, 0x2a, 0x42, 0x0a,
	0x0c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53,
	0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10,
	0x02, 0x2a, 0x50, 0x0a, 0x13, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x19, 0x0a, 0x15, 0x45, 0x4e, 0x55, 0x4d,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x54, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x52, 0x49, 0x53, 0x4b, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53, 0x49,
	0x53, 0x10, 0x02, 0x2a, 0x52, 0x0a, 0x0a, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x4c, 0x50, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x10, 0x01,
	0x12, 0x15, 0x0a, 0x11, 0x52, 0x49, 0x53, 0x4b, 0x5f, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53, 0x49,
	0x53, 0x5f, 0x4a, 0x4f, 0x42, 0x10, 0x02, 0x2a, 0x6e, 0x0a, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26,
	0x0a, 0x22, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x04, 0x32, 0xc3, 0x49, 0x0a, 0x0a, 0x44, 0x6c, 0x70, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x22, 0x27,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x38, 0x22, 0x33, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x3a, 0x01, 0x2a, 0x12, 0xcc, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64,
	0x61, 0x63, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x64, 0x61, 0x63, 0x74, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x60, 0x22, 0x24, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x3a, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x35, 0x22, 0x30,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x3a, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74,
	0x3a, 0x01, 0x2a, 0x12, 0xea, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x72, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x6c, 0x22, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79,
	0x3a, 0x01, 0x2a, 0x5a, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x3a, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x3a, 0x01, 0x2a,
	0x12, 0xea, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x6c, 0x22, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x3a, 0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x3a, 0x01, 0x2a,
	0x5a, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a,
	0x72, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x3a, 0x01, 0x2a, 0x12, 0xb0, 0x01,
	0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x35, 0x12, 0x0d, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xf4, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xfd, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdc,
	0x01, 0x22, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x3a, 0x01, 0x2a, 0x5a, 0x3e, 0x22, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x3a, 0x01, 0x2a, 0x5a, 0x2d, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a,
	0x01, 0x2a, 0x5a, 0x39, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0xfe, 0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x87,
	0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdc, 0x01, 0x32, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x3e, 0x32, 0x39, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x2d, 0x32, 0x28, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x39, 0x32, 0x34, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x21, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xcf, 0x02, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xde, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xd0, 0x01, 0x12, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x2a, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe2, 0x02, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe0, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xd0, 0x01, 0x12, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x5a, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x5a, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x5a, 0x36,
	0x12, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xc5, 0x02, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xde, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd0, 0x01,
	0x2a, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2a, 0x2a, 0x28,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8c, 0x03, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x8c, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe8,
	0x01, 0x22, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x41, 0x22, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x30, 0x22, 0x2b, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x3c, 0x22, 0x37, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x96, 0x03, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x96, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe8, 0x01,
	0x32, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x41, 0x32, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x30, 0x32, 0x2b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x3c, 0x32, 0x37, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x24, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12,
	0xe4, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xea, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xdc, 0x01, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf7, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xec, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdc, 0x01, 0x12, 0x30, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x5a, 0x3e, 0x12,
	0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x5a, 0x2d, 0x12,
	0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x5a, 0x39, 0x12, 0x37,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xd7, 0x02, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xea, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdc, 0x01, 0x2a, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe0, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x22, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x22, 0x23, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x3a,
	0x01, 0x2a, 0x5a, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0xeb, 0x01,
	0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x32, 0x23,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x34, 0x32, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1c, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xcf, 0x01, 0x0a, 0x17,
	0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc6, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x12, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd9, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4a,
	0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x58, 0x12, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0xc1, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x2a, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x2a, 0x2f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdd, 0x01, 0x0a, 0x12, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4a, 0x6f,
	0x62, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x22, 0x76,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x70, 0x22, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xdf, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6c, 0x70, 0x4a,
	0x6f, 0x62, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22, 0x1f, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x01, 0x2a, 0x5a,
	0x30, 0x22, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x72, 0x69, 0x73, 0x6b, 0x5f, 0x6a, 0x6f, 0x62, 0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x1f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x5a, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xb2, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x12, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x1f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb1, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x50, 0x2a, 0x1f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0c, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x6a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01,
	0x2a, 0x5a, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0x12, 0xe3, 0x02, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0xef,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd8, 0x01, 0x22, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x2c, 0x22, 0x27, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x38, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0xed, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x22, 0xf9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd8, 0x01, 0x32, 0x2c,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a,
	0x3d, 0x32, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x2c,
	0x32, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x38, 0x32, 0x33,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x17, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0xc8, 0x02, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0xda,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xcc, 0x01, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdb, 0x02, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xdc, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xcc, 0x01, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x5a, 0x29,
	0x12, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbf, 0x02, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xda,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xcc, 0x01, 0x2a, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x5a, 0x29, 0x2a, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x35, 0x2a,
	0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc3, 0x01, 0x0a, 0x13,
	0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x6c, 0x70,
	0x4a, 0x6f, 0x62, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72,
	0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48,
	0x79, 0x62, 0x72, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x91, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x44, 0x6c, 0x70, 0x4a,
	0x6f, 0x62, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x44, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x22, 0x32,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x6c, 0x70, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x3a, 0x01, 0x2a, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xfa, 0x02,
	0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x42, 0x08, 0x44, 0x6c, 0x70,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2f, 0x64, 0x6c, 0x70, 0x2f, 0x76, 0x32, 0x3b, 0x64, 0x6c,
	0x70, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x6c, 0x70, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6c, 0x70, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x16,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44,
	0x6c, 0x70, 0x3a, 0x3a, 0x56, 0x32, 0xea, 0x41, 0x72, 0x0a, 0x1d, 0x64, 0x6c, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6c,
	0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x6c, 0x70,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x64, 0x6c, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0xea, 0x41, 0x5c, 0x0a, 0x27,
	0x64, 0x6c, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_privacy_dlp_v2_dlp_proto_rawDescOnce sync.Once
	file_google_privacy_dlp_v2_dlp_proto_rawDescData = file_google_privacy_dlp_v2_dlp_proto_rawDesc
)

func file_google_privacy_dlp_v2_dlp_proto_rawDescGZIP() []byte {
	file_google_privacy_dlp_v2_dlp_proto_rawDescOnce.Do(func() {
		file_google_privacy_dlp_v2_dlp_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_privacy_dlp_v2_dlp_proto_rawDescData)
	})
	return file_google_privacy_dlp_v2_dlp_proto_rawDescData
}

var file_google_privacy_dlp_v2_dlp_proto_enumTypes = make([]protoimpl.EnumInfo, 16)
var file_google_privacy_dlp_v2_dlp_proto_msgTypes = make([]protoimpl.MessageInfo, 173)
var file_google_privacy_dlp_v2_dlp_proto_goTypes = []interface{}{
	(RelationalOperator)(0),                                   // 0: google.privacy.dlp.v2.RelationalOperator
	(MatchingType)(0),                                         // 1: google.privacy.dlp.v2.MatchingType
	(ContentOption)(0),                                        // 2: google.privacy.dlp.v2.ContentOption
	(MetadataType)(0),                                         // 3: google.privacy.dlp.v2.MetadataType
	(InfoTypeSupportedBy)(0),                                  // 4: google.privacy.dlp.v2.InfoTypeSupportedBy
	(DlpJobType)(0),                                           // 5: google.privacy.dlp.v2.DlpJobType
	(StoredInfoTypeState)(0),                                  // 6: google.privacy.dlp.v2.StoredInfoTypeState
	(ByteContentItem_BytesType)(0),                            // 7: google.privacy.dlp.v2.ByteContentItem.BytesType
	(OutputStorageConfig_OutputSchema)(0),                     // 8: google.privacy.dlp.v2.OutputStorageConfig.OutputSchema
	(TimePartConfig_TimePart)(0),                              // 9: google.privacy.dlp.v2.TimePartConfig.TimePart
	(CharsToIgnore_CommonCharsToIgnore)(0),                    // 10: google.privacy.dlp.v2.CharsToIgnore.CommonCharsToIgnore
	(CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet)(0),    // 11: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
	(RecordCondition_Expressions_LogicalOperator)(0),          // 12: google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
	(TransformationSummary_TransformationResultCode)(0),       // 13: google.privacy.dlp.v2.TransformationSummary.TransformationResultCode
	(JobTrigger_Status)(0),                                    // 14: google.privacy.dlp.v2.JobTrigger.Status
	(DlpJob_JobState)(0),                                      // 15: google.privacy.dlp.v2.DlpJob.JobState
	(*ExcludeInfoTypes)(nil),                                  // 16: google.privacy.dlp.v2.ExcludeInfoTypes
	(*ExclusionRule)(nil),                                     // 17: google.privacy.dlp.v2.ExclusionRule
	(*InspectionRule)(nil),                                    // 18: google.privacy.dlp.v2.InspectionRule
	(*InspectionRuleSet)(nil),                                 // 19: google.privacy.dlp.v2.InspectionRuleSet
	(*InspectConfig)(nil),                                     // 20: google.privacy.dlp.v2.InspectConfig
	(*ByteContentItem)(nil),                                   // 21: google.privacy.dlp.v2.ByteContentItem
	(*ContentItem)(nil),                                       // 22: google.privacy.dlp.v2.ContentItem
	(*Table)(nil),                                             // 23: google.privacy.dlp.v2.Table
	(*InspectResult)(nil),                                     // 24: google.privacy.dlp.v2.InspectResult
	(*Finding)(nil),                                           // 25: google.privacy.dlp.v2.Finding
	(*Location)(nil),                                          // 26: google.privacy.dlp.v2.Location
	(*ContentLocation)(nil),                                   // 27: google.privacy.dlp.v2.ContentLocation
	(*MetadataLocation)(nil),                                  // 28: google.privacy.dlp.v2.MetadataLocation
	(*StorageMetadataLabel)(nil),                              // 29: google.privacy.dlp.v2.StorageMetadataLabel
	(*DocumentLocation)(nil),                                  // 30: google.privacy.dlp.v2.DocumentLocation
	(*RecordLocation)(nil),                                    // 31: google.privacy.dlp.v2.RecordLocation
	(*TableLocation)(nil),                                     // 32: google.privacy.dlp.v2.TableLocation
	(*Container)(nil),                                         // 33: google.privacy.dlp.v2.Container
	(*Range)(nil),                                             // 34: google.privacy.dlp.v2.Range
	(*ImageLocation)(nil),                                     // 35: google.privacy.dlp.v2.ImageLocation
	(*BoundingBox)(nil),                                       // 36: google.privacy.dlp.v2.BoundingBox
	(*RedactImageRequest)(nil),                                // 37: google.privacy.dlp.v2.RedactImageRequest
	(*Color)(nil),                                             // 38: google.privacy.dlp.v2.Color
	(*RedactImageResponse)(nil),                               // 39: google.privacy.dlp.v2.RedactImageResponse
	(*DeidentifyContentRequest)(nil),                          // 40: google.privacy.dlp.v2.DeidentifyContentRequest
	(*DeidentifyContentResponse)(nil),                         // 41: google.privacy.dlp.v2.DeidentifyContentResponse
	(*ReidentifyContentRequest)(nil),                          // 42: google.privacy.dlp.v2.ReidentifyContentRequest
	(*ReidentifyContentResponse)(nil),                         // 43: google.privacy.dlp.v2.ReidentifyContentResponse
	(*InspectContentRequest)(nil),                             // 44: google.privacy.dlp.v2.InspectContentRequest
	(*InspectContentResponse)(nil),                            // 45: google.privacy.dlp.v2.InspectContentResponse
	(*OutputStorageConfig)(nil),                               // 46: google.privacy.dlp.v2.OutputStorageConfig
	(*InfoTypeStats)(nil),                                     // 47: google.privacy.dlp.v2.InfoTypeStats
	(*InspectDataSourceDetails)(nil),                          // 48: google.privacy.dlp.v2.InspectDataSourceDetails
	(*HybridInspectStatistics)(nil),                           // 49: google.privacy.dlp.v2.HybridInspectStatistics
	(*InfoTypeDescription)(nil),                               // 50: google.privacy.dlp.v2.InfoTypeDescription
	(*ListInfoTypesRequest)(nil),                              // 51: google.privacy.dlp.v2.ListInfoTypesRequest
	(*ListInfoTypesResponse)(nil),                             // 52: google.privacy.dlp.v2.ListInfoTypesResponse
	(*RiskAnalysisJobConfig)(nil),                             // 53: google.privacy.dlp.v2.RiskAnalysisJobConfig
	(*QuasiId)(nil),                                           // 54: google.privacy.dlp.v2.QuasiId
	(*StatisticalTable)(nil),                                  // 55: google.privacy.dlp.v2.StatisticalTable
	(*PrivacyMetric)(nil),                                     // 56: google.privacy.dlp.v2.PrivacyMetric
	(*AnalyzeDataSourceRiskDetails)(nil),                      // 57: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails
	(*ValueFrequency)(nil),                                    // 58: google.privacy.dlp.v2.ValueFrequency
	(*Value)(nil),                                             // 59: google.privacy.dlp.v2.Value
	(*QuoteInfo)(nil),                                         // 60: google.privacy.dlp.v2.QuoteInfo
	(*DateTime)(nil),                                          // 61: google.privacy.dlp.v2.DateTime
	(*DeidentifyConfig)(nil),                                  // 62: google.privacy.dlp.v2.DeidentifyConfig
	(*TransformationErrorHandling)(nil),                       // 63: google.privacy.dlp.v2.TransformationErrorHandling
	(*PrimitiveTransformation)(nil),                           // 64: google.privacy.dlp.v2.PrimitiveTransformation
	(*TimePartConfig)(nil),                                    // 65: google.privacy.dlp.v2.TimePartConfig
	(*CryptoHashConfig)(nil),                                  // 66: google.privacy.dlp.v2.CryptoHashConfig
	(*CryptoDeterministicConfig)(nil),                         // 67: google.privacy.dlp.v2.CryptoDeterministicConfig
	(*ReplaceValueConfig)(nil),                                // 68: google.privacy.dlp.v2.ReplaceValueConfig
	(*ReplaceWithInfoTypeConfig)(nil),                         // 69: google.privacy.dlp.v2.ReplaceWithInfoTypeConfig
	(*RedactConfig)(nil),                                      // 70: google.privacy.dlp.v2.RedactConfig
	(*CharsToIgnore)(nil),                                     // 71: google.privacy.dlp.v2.CharsToIgnore
	(*CharacterMaskConfig)(nil),                               // 72: google.privacy.dlp.v2.CharacterMaskConfig
	(*FixedSizeBucketingConfig)(nil),                          // 73: google.privacy.dlp.v2.FixedSizeBucketingConfig
	(*BucketingConfig)(nil),                                   // 74: google.privacy.dlp.v2.BucketingConfig
	(*CryptoReplaceFfxFpeConfig)(nil),                         // 75: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig
	(*CryptoKey)(nil),                                         // 76: google.privacy.dlp.v2.CryptoKey
	(*TransientCryptoKey)(nil),                                // 77: google.privacy.dlp.v2.TransientCryptoKey
	(*UnwrappedCryptoKey)(nil),                                // 78: google.privacy.dlp.v2.UnwrappedCryptoKey
	(*KmsWrappedCryptoKey)(nil),                               // 79: google.privacy.dlp.v2.KmsWrappedCryptoKey
	(*DateShiftConfig)(nil),                                   // 80: google.privacy.dlp.v2.DateShiftConfig
	(*InfoTypeTransformations)(nil),                           // 81: google.privacy.dlp.v2.InfoTypeTransformations
	(*FieldTransformation)(nil),                               // 82: google.privacy.dlp.v2.FieldTransformation
	(*RecordTransformations)(nil),                             // 83: google.privacy.dlp.v2.RecordTransformations
	(*RecordSuppression)(nil),                                 // 84: google.privacy.dlp.v2.RecordSuppression
	(*RecordCondition)(nil),                                   // 85: google.privacy.dlp.v2.RecordCondition
	(*TransformationOverview)(nil),                            // 86: google.privacy.dlp.v2.TransformationOverview
	(*TransformationSummary)(nil),                             // 87: google.privacy.dlp.v2.TransformationSummary
	(*Schedule)(nil),                                          // 88: google.privacy.dlp.v2.Schedule
	(*Manual)(nil),                                            // 89: google.privacy.dlp.v2.Manual
	(*InspectTemplate)(nil),                                   // 90: google.privacy.dlp.v2.InspectTemplate
	(*DeidentifyTemplate)(nil),                                // 91: google.privacy.dlp.v2.DeidentifyTemplate
	(*Error)(nil),                                             // 92: google.privacy.dlp.v2.Error
	(*JobTrigger)(nil),                                        // 93: google.privacy.dlp.v2.JobTrigger
	(*Action)(nil),                                            // 94: google.privacy.dlp.v2.Action
	(*CreateInspectTemplateRequest)(nil),                      // 95: google.privacy.dlp.v2.CreateInspectTemplateRequest
	(*UpdateInspectTemplateRequest)(nil),                      // 96: google.privacy.dlp.v2.UpdateInspectTemplateRequest
	(*GetInspectTemplateRequest)(nil),                         // 97: google.privacy.dlp.v2.GetInspectTemplateRequest
	(*ListInspectTemplatesRequest)(nil),                       // 98: google.privacy.dlp.v2.ListInspectTemplatesRequest
	(*ListInspectTemplatesResponse)(nil),                      // 99: google.privacy.dlp.v2.ListInspectTemplatesResponse
	(*DeleteInspectTemplateRequest)(nil),                      // 100: google.privacy.dlp.v2.DeleteInspectTemplateRequest
	(*CreateJobTriggerRequest)(nil),                           // 101: google.privacy.dlp.v2.CreateJobTriggerRequest
	(*ActivateJobTriggerRequest)(nil),                         // 102: google.privacy.dlp.v2.ActivateJobTriggerRequest
	(*UpdateJobTriggerRequest)(nil),                           // 103: google.privacy.dlp.v2.UpdateJobTriggerRequest
	(*GetJobTriggerRequest)(nil),                              // 104: google.privacy.dlp.v2.GetJobTriggerRequest
	(*CreateDlpJobRequest)(nil),                               // 105: google.privacy.dlp.v2.CreateDlpJobRequest
	(*ListJobTriggersRequest)(nil),                            // 106: google.privacy.dlp.v2.ListJobTriggersRequest
	(*ListJobTriggersResponse)(nil),                           // 107: google.privacy.dlp.v2.ListJobTriggersResponse
	(*DeleteJobTriggerRequest)(nil),                           // 108: google.privacy.dlp.v2.DeleteJobTriggerRequest
	(*InspectJobConfig)(nil),                                  // 109: google.privacy.dlp.v2.InspectJobConfig
	(*DlpJob)(nil),                                            // 110: google.privacy.dlp.v2.DlpJob
	(*GetDlpJobRequest)(nil),                                  // 111: google.privacy.dlp.v2.GetDlpJobRequest
	(*ListDlpJobsRequest)(nil),                                // 112: google.privacy.dlp.v2.ListDlpJobsRequest
	(*ListDlpJobsResponse)(nil),                               // 113: google.privacy.dlp.v2.ListDlpJobsResponse
	(*CancelDlpJobRequest)(nil),                               // 114: google.privacy.dlp.v2.CancelDlpJobRequest
	(*FinishDlpJobRequest)(nil),                               // 115: google.privacy.dlp.v2.FinishDlpJobRequest
	(*DeleteDlpJobRequest)(nil),                               // 116: google.privacy.dlp.v2.DeleteDlpJobRequest
	(*CreateDeidentifyTemplateRequest)(nil),                   // 117: google.privacy.dlp.v2.CreateDeidentifyTemplateRequest
	(*UpdateDeidentifyTemplateRequest)(nil),                   // 118: google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest
	(*GetDeidentifyTemplateRequest)(nil),                      // 119: google.privacy.dlp.v2.GetDeidentifyTemplateRequest
	(*ListDeidentifyTemplatesRequest)(nil),                    // 120: google.privacy.dlp.v2.ListDeidentifyTemplatesRequest
	(*ListDeidentifyTemplatesResponse)(nil),                   // 121: google.privacy.dlp.v2.ListDeidentifyTemplatesResponse
	(*DeleteDeidentifyTemplateRequest)(nil),                   // 122: google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest
	(*LargeCustomDictionaryConfig)(nil),                       // 123: google.privacy.dlp.v2.LargeCustomDictionaryConfig
	(*LargeCustomDictionaryStats)(nil),                        // 124: google.privacy.dlp.v2.LargeCustomDictionaryStats
	(*StoredInfoTypeConfig)(nil),                              // 125: google.privacy.dlp.v2.StoredInfoTypeConfig
	(*StoredInfoTypeStats)(nil),                               // 126: google.privacy.dlp.v2.StoredInfoTypeStats
	(*StoredInfoTypeVersion)(nil),                             // 127: google.privacy.dlp.v2.StoredInfoTypeVersion
	(*StoredInfoType)(nil),                                    // 128: google.privacy.dlp.v2.StoredInfoType
	(*CreateStoredInfoTypeRequest)(nil),                       // 129: google.privacy.dlp.v2.CreateStoredInfoTypeRequest
	(*UpdateStoredInfoTypeRequest)(nil),                       // 130: google.privacy.dlp.v2.UpdateStoredInfoTypeRequest
	(*GetStoredInfoTypeRequest)(nil),                          // 131: google.privacy.dlp.v2.GetStoredInfoTypeRequest
	(*ListStoredInfoTypesRequest)(nil),                        // 132: google.privacy.dlp.v2.ListStoredInfoTypesRequest
	(*ListStoredInfoTypesResponse)(nil),                       // 133: google.privacy.dlp.v2.ListStoredInfoTypesResponse
	(*DeleteStoredInfoTypeRequest)(nil),                       // 134: google.privacy.dlp.v2.DeleteStoredInfoTypeRequest
	(*HybridInspectJobTriggerRequest)(nil),                    // 135: google.privacy.dlp.v2.HybridInspectJobTriggerRequest
	(*HybridInspectDlpJobRequest)(nil),                        // 136: google.privacy.dlp.v2.HybridInspectDlpJobRequest
	(*HybridContentItem)(nil),                                 // 137: google.privacy.dlp.v2.HybridContentItem
	(*HybridFindingDetails)(nil),                              // 138: google.privacy.dlp.v2.HybridFindingDetails
	(*HybridInspectResponse)(nil),                             // 139: google.privacy.dlp.v2.HybridInspectResponse
	(*InspectConfig_FindingLimits)(nil),                       // 140: google.privacy.dlp.v2.InspectConfig.FindingLimits
	(*InspectConfig_FindingLimits_InfoTypeLimit)(nil),         // 141: google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
	(*Table_Row)(nil),                                         // 142: google.privacy.dlp.v2.Table.Row
	nil,                                                       // 143: google.privacy.dlp.v2.Finding.LabelsEntry
	(*RedactImageRequest_ImageRedactionConfig)(nil),           // 144: google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
	(*InspectDataSourceDetails_RequestedOptions)(nil),         // 145: google.privacy.dlp.v2.InspectDataSourceDetails.RequestedOptions
	(*InspectDataSourceDetails_Result)(nil),                   // 146: google.privacy.dlp.v2.InspectDataSourceDetails.Result
	(*StatisticalTable_QuasiIdentifierField)(nil),             // 147: google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
	(*PrivacyMetric_NumericalStatsConfig)(nil),                // 148: google.privacy.dlp.v2.PrivacyMetric.NumericalStatsConfig
	(*PrivacyMetric_CategoricalStatsConfig)(nil),              // 149: google.privacy.dlp.v2.PrivacyMetric.CategoricalStatsConfig
	(*PrivacyMetric_KAnonymityConfig)(nil),                    // 150: google.privacy.dlp.v2.PrivacyMetric.KAnonymityConfig
	(*PrivacyMetric_LDiversityConfig)(nil),                    // 151: google.privacy.dlp.v2.PrivacyMetric.LDiversityConfig
	(*PrivacyMetric_KMapEstimationConfig)(nil),                // 152: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig
	(*PrivacyMetric_DeltaPresenceEstimationConfig)(nil),       // 153: google.privacy.dlp.v2.PrivacyMetric.DeltaPresenceEstimationConfig
	(*PrivacyMetric_KMapEstimationConfig_TaggedField)(nil),    // 154: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.TaggedField
	(*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable)(nil), // 155: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable
	(*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField)(nil),                                    // 156: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.QuasiIdField
	(*AnalyzeDataSourceRiskDetails_NumericalStatsResult)(nil),                                                 // 157: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.NumericalStatsResult
	(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult)(nil),                                               // 158: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult
	(*AnalyzeDataSourceRiskDetails_KAnonymityResult)(nil),                                                     // 159: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult
	(*AnalyzeDataSourceRiskDetails_LDiversityResult)(nil),                                                     // 160: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult
	(*AnalyzeDataSourceRiskDetails_KMapEstimationResult)(nil),                                                 // 161: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult
	(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult)(nil),                                        // 162: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult
	(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket)(nil),               // 163: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult.CategoricalStatsHistogramBucket
	(*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass)(nil),                          // 164: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityEquivalenceClass
	(*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket)(nil),                           // 165: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityHistogramBucket
	(*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass)(nil),                          // 166: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityEquivalenceClass
	(*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket)(nil),                           // 167: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityHistogramBucket
	(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues)(nil),                     // 168: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationQuasiIdValues
	(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket)(nil),                   // 169: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationHistogramBucket
	(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues)(nil),   // 170: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationQuasiIdValues
	(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket)(nil), // 171: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationHistogramBucket
	(*DateTime_TimeZone)(nil),                              // 172: google.privacy.dlp.v2.DateTime.TimeZone
	(*TransformationErrorHandling_ThrowError)(nil),         // 173: google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
	(*TransformationErrorHandling_LeaveUntransformed)(nil), // 174: google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
	(*BucketingConfig_Bucket)(nil),                         // 175: google.privacy.dlp.v2.BucketingConfig.Bucket
	(*InfoTypeTransformations_InfoTypeTransformation)(nil), // 176: google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
	(*RecordCondition_Condition)(nil),                      // 177: google.privacy.dlp.v2.RecordCondition.Condition
	(*RecordCondition_Conditions)(nil),                     // 178: google.privacy.dlp.v2.RecordCondition.Conditions
	(*RecordCondition_Expressions)(nil),                    // 179: google.privacy.dlp.v2.RecordCondition.Expressions
	(*TransformationSummary_SummaryResult)(nil),            // 180: google.privacy.dlp.v2.TransformationSummary.SummaryResult
	(*JobTrigger_Trigger)(nil),                             // 181: google.privacy.dlp.v2.JobTrigger.Trigger
	(*Action_SaveFindings)(nil),                            // 182: google.privacy.dlp.v2.Action.SaveFindings
	(*Action_PublishToPubSub)(nil),                         // 183: google.privacy.dlp.v2.Action.PublishToPubSub
	(*Action_PublishSummaryToCscc)(nil),                    // 184: google.privacy.dlp.v2.Action.PublishSummaryToCscc
	(*Action_PublishFindingsToCloudDataCatalog)(nil),       // 185: google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
	(*Action_JobNotificationEmails)(nil),                   // 186: google.privacy.dlp.v2.Action.JobNotificationEmails
	(*Action_PublishToStackdriver)(nil),                    // 187: google.privacy.dlp.v2.Action.PublishToStackdriver
	nil,                                                    // 188: google.privacy.dlp.v2.HybridFindingDetails.LabelsEntry
	(*InfoType)(nil),                                       // 189: google.privacy.dlp.v2.InfoType
	(*CustomInfoType_Dictionary)(nil),                      // 190: google.privacy.dlp.v2.CustomInfoType.Dictionary
	(*CustomInfoType_Regex)(nil),                           // 191: google.privacy.dlp.v2.CustomInfoType.Regex
	(*CustomInfoType_DetectionRule_HotwordRule)(nil),       // 192: google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
	(Likelihood)(0),                                        // 193: google.privacy.dlp.v2.Likelihood
	(*CustomInfoType)(nil),                                 // 194: google.privacy.dlp.v2.CustomInfoType
	(*FieldId)(nil),                                        // 195: google.privacy.dlp.v2.FieldId
	(*timestamppb.Timestamp)(nil),                          // 196: google.protobuf.Timestamp
	(*RecordKey)(nil),                                      // 197: google.privacy.dlp.v2.RecordKey
	(*BigQueryTable)(nil),                                  // 198: google.privacy.dlp.v2.BigQueryTable
	(*emptypb.Empty)(nil),                                  // 199: google.protobuf.Empty
	(*timeofday.TimeOfDay)(nil),                            // 200: google.type.TimeOfDay
	(*date.Date)(nil),                                      // 201: google.type.Date
	(dayofweek.DayOfWeek)(0),                               // 202: google.type.DayOfWeek
	(*durationpb.Duration)(nil),                            // 203: google.protobuf.Duration
	(*status.Status)(nil),                                  // 204: google.rpc.Status
	(*fieldmaskpb.FieldMask)(nil),                          // 205: google.protobuf.FieldMask
	(*StorageConfig)(nil),                                  // 206: google.privacy.dlp.v2.StorageConfig
	(*CloudStoragePath)(nil),                               // 207: google.privacy.dlp.v2.CloudStoragePath
	(*CloudStorageFileSet)(nil),                            // 208: google.privacy.dlp.v2.CloudStorageFileSet
	(*BigQueryField)(nil),                                  // 209: google.privacy.dlp.v2.BigQueryField
	(*TableOptions)(nil),                                   // 210: google.privacy.dlp.v2.TableOptions
	(*EntityId)(nil),                                       // 211: google.privacy.dlp.v2.EntityId
}
var file_google_privacy_dlp_v2_dlp_proto_depIdxs = []int32{
	189, // 0: google.privacy.dlp.v2.ExcludeInfoTypes.info_types:type_name -> google.privacy.dlp.v2.InfoType
	190, // 1: google.privacy.dlp.v2.ExclusionRule.dictionary:type_name -> google.privacy.dlp.v2.CustomInfoType.Dictionary
	191, // 2: google.privacy.dlp.v2.ExclusionRule.regex:type_name -> google.privacy.dlp.v2.CustomInfoType.Regex
	16,  // 3: google.privacy.dlp.v2.ExclusionRule.exclude_info_types:type_name -> google.privacy.dlp.v2.ExcludeInfoTypes
	1,   // 4: google.privacy.dlp.v2.ExclusionRule.matching_type:type_name -> google.privacy.dlp.v2.MatchingType
	192, // 5: google.privacy.dlp.v2.InspectionRule.hotword_rule:type_name -> google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
	17,  // 6: google.privacy.dlp.v2.InspectionRule.exclusion_rule:type_name -> google.privacy.dlp.v2.ExclusionRule
	189, // 7: google.privacy.dlp.v2.InspectionRuleSet.info_types:type_name -> google.privacy.dlp.v2.InfoType
	18,  // 8: google.privacy.dlp.v2.InspectionRuleSet.rules:type_name -> google.privacy.dlp.v2.InspectionRule
	189, // 9: google.privacy.dlp.v2.InspectConfig.info_types:type_name -> google.privacy.dlp.v2.InfoType
	193, // 10: google.privacy.dlp.v2.InspectConfig.min_likelihood:type_name -> google.privacy.dlp.v2.Likelihood
	140, // 11: google.privacy.dlp.v2.InspectConfig.limits:type_name -> google.privacy.dlp.v2.InspectConfig.FindingLimits
	194, // 12: google.privacy.dlp.v2.InspectConfig.custom_info_types:type_name -> google.privacy.dlp.v2.CustomInfoType
	2,   // 13: google.privacy.dlp.v2.InspectConfig.content_options:type_name -> google.privacy.dlp.v2.ContentOption
	19,  // 14: google.privacy.dlp.v2.InspectConfig.rule_set:type_name -> google.privacy.dlp.v2.InspectionRuleSet
	7,   // 15: google.privacy.dlp.v2.ByteContentItem.type:type_name -> google.privacy.dlp.v2.ByteContentItem.BytesType
	23,  // 16: google.privacy.dlp.v2.ContentItem.table:type_name -> google.privacy.dlp.v2.Table
	21,  // 17: google.privacy.dlp.v2.ContentItem.byte_item:type_name -> google.privacy.dlp.v2.ByteContentItem
	195, // 18: google.privacy.dlp.v2.Table.headers:type_name -> google.privacy.dlp.v2.FieldId
	142, // 19: google.privacy.dlp.v2.Table.rows:type_name -> google.privacy.dlp.v2.Table.Row
	25,  // 20: google.privacy.dlp.v2.InspectResult.findings:type_name -> google.privacy.dlp.v2.Finding
	189, // 21: google.privacy.dlp.v2.Finding.info_type:type_name -> google.privacy.dlp.v2.InfoType
	193, // 22: google.privacy.dlp.v2.Finding.likelihood:type_name -> google.privacy.dlp.v2.Likelihood
	26,  // 23: google.privacy.dlp.v2.Finding.location:type_name -> google.privacy.dlp.v2.Location
	196, // 24: google.privacy.dlp.v2.Finding.create_time:type_name -> google.protobuf.Timestamp
	60,  // 25: google.privacy.dlp.v2.Finding.quote_info:type_name -> google.privacy.dlp.v2.QuoteInfo
	143, // 26: google.privacy.dlp.v2.Finding.labels:type_name -> google.privacy.dlp.v2.Finding.LabelsEntry
	196, // 27: google.privacy.dlp.v2.Finding.job_create_time:type_name -> google.protobuf.Timestamp
	34,  // 28: google.privacy.dlp.v2.Location.byte_range:type_name -> google.privacy.dlp.v2.Range
	34,  // 29: google.privacy.dlp.v2.Location.codepoint_range:type_name -> google.privacy.dlp.v2.Range
	27,  // 30: google.privacy.dlp.v2.Location.content_locations:type_name -> google.privacy.dlp.v2.ContentLocation
	33,  // 31: google.privacy.dlp.v2.Location.container:type_name -> google.privacy.dlp.v2.Container
	31,  // 32: google.privacy.dlp.v2.ContentLocation.record_location:type_name -> google.privacy.dlp.v2.RecordLocation
	35,  // 33: google.privacy.dlp.v2.ContentLocation.image_location:type_name -> google.privacy.dlp.v2.ImageLocation
	30,  // 34: google.privacy.dlp.v2.ContentLocation.document_location:type_name -> google.privacy.dlp.v2.DocumentLocation
	28,  // 35: google.privacy.dlp.v2.ContentLocation.metadata_location:type_name -> google.privacy.dlp.v2.MetadataLocation
	196, // 36: google.privacy.dlp.v2.ContentLocation.container_timestamp:type_name -> google.protobuf.Timestamp
	3,   // 37: google.privacy.dlp.v2.MetadataLocation.type:type_name -> google.privacy.dlp.v2.MetadataType
	29,  // 38: google.privacy.dlp.v2.MetadataLocation.storage_label:type_name -> google.privacy.dlp.v2.StorageMetadataLabel
	197, // 39: google.privacy.dlp.v2.RecordLocation.record_key:type_name -> google.privacy.dlp.v2.RecordKey
	195, // 40: google.privacy.dlp.v2.RecordLocation.field_id:type_name -> google.privacy.dlp.v2.FieldId
	32,  // 41: google.privacy.dlp.v2.RecordLocation.table_location:type_name -> google.privacy.dlp.v2.TableLocation
	196, // 42: google.privacy.dlp.v2.Container.update_time:type_name -> google.protobuf.Timestamp
	36,  // 43: google.privacy.dlp.v2.ImageLocation.bounding_boxes:type_name -> google.privacy.dlp.v2.BoundingBox
	20,  // 44: google.privacy.dlp.v2.RedactImageRequest.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	144, // 45: google.privacy.dlp.v2.RedactImageRequest.image_redaction_configs:type_name -> google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
	21,  // 46: google.privacy.dlp.v2.RedactImageRequest.byte_item:type_name -> google.privacy.dlp.v2.ByteContentItem
	24,  // 47: google.privacy.dlp.v2.RedactImageResponse.inspect_result:type_name -> google.privacy.dlp.v2.InspectResult
	62,  // 48: google.privacy.dlp.v2.DeidentifyContentRequest.deidentify_config:type_name -> google.privacy.dlp.v2.DeidentifyConfig
	20,  // 49: google.privacy.dlp.v2.DeidentifyContentRequest.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	22,  // 50: google.privacy.dlp.v2.DeidentifyContentRequest.item:type_name -> google.privacy.dlp.v2.ContentItem
	22,  // 51: google.privacy.dlp.v2.DeidentifyContentResponse.item:type_name -> google.privacy.dlp.v2.ContentItem
	86,  // 52: google.privacy.dlp.v2.DeidentifyContentResponse.overview:type_name -> google.privacy.dlp.v2.TransformationOverview
	62,  // 53: google.privacy.dlp.v2.ReidentifyContentRequest.reidentify_config:type_name -> google.privacy.dlp.v2.DeidentifyConfig
	20,  // 54: google.privacy.dlp.v2.ReidentifyContentRequest.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	22,  // 55: google.privacy.dlp.v2.ReidentifyContentRequest.item:type_name -> google.privacy.dlp.v2.ContentItem
	22,  // 56: google.privacy.dlp.v2.ReidentifyContentResponse.item:type_name -> google.privacy.dlp.v2.ContentItem
	86,  // 57: google.privacy.dlp.v2.ReidentifyContentResponse.overview:type_name -> google.privacy.dlp.v2.TransformationOverview
	20,  // 58: google.privacy.dlp.v2.InspectContentRequest.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	22,  // 59: google.privacy.dlp.v2.InspectContentRequest.item:type_name -> google.privacy.dlp.v2.ContentItem
	24,  // 60: google.privacy.dlp.v2.InspectContentResponse.result:type_name -> google.privacy.dlp.v2.InspectResult
	198, // 61: google.privacy.dlp.v2.OutputStorageConfig.table:type_name -> google.privacy.dlp.v2.BigQueryTable
	8,   // 62: google.privacy.dlp.v2.OutputStorageConfig.output_schema:type_name -> google.privacy.dlp.v2.OutputStorageConfig.OutputSchema
	189, // 63: google.privacy.dlp.v2.InfoTypeStats.info_type:type_name -> google.privacy.dlp.v2.InfoType
	145, // 64: google.privacy.dlp.v2.InspectDataSourceDetails.requested_options:type_name -> google.privacy.dlp.v2.InspectDataSourceDetails.RequestedOptions
	146, // 65: google.privacy.dlp.v2.InspectDataSourceDetails.result:type_name -> google.privacy.dlp.v2.InspectDataSourceDetails.Result
	4,   // 66: google.privacy.dlp.v2.InfoTypeDescription.supported_by:type_name -> google.privacy.dlp.v2.InfoTypeSupportedBy
	50,  // 67: google.privacy.dlp.v2.ListInfoTypesResponse.info_types:type_name -> google.privacy.dlp.v2.InfoTypeDescription
	56,  // 68: google.privacy.dlp.v2.RiskAnalysisJobConfig.privacy_metric:type_name -> google.privacy.dlp.v2.PrivacyMetric
	198, // 69: google.privacy.dlp.v2.RiskAnalysisJobConfig.source_table:type_name -> google.privacy.dlp.v2.BigQueryTable
	94,  // 70: google.privacy.dlp.v2.RiskAnalysisJobConfig.actions:type_name -> google.privacy.dlp.v2.Action
	195, // 71: google.privacy.dlp.v2.QuasiId.field:type_name -> google.privacy.dlp.v2.FieldId
	189, // 72: google.privacy.dlp.v2.QuasiId.info_type:type_name -> google.privacy.dlp.v2.InfoType
	199, // 73: google.privacy.dlp.v2.QuasiId.inferred:type_name -> google.protobuf.Empty
	198, // 74: google.privacy.dlp.v2.StatisticalTable.table:type_name -> google.privacy.dlp.v2.BigQueryTable
	147, // 75: google.privacy.dlp.v2.StatisticalTable.quasi_ids:type_name -> google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField
	195, // 76: google.privacy.dlp.v2.StatisticalTable.relative_frequency:type_name -> google.privacy.dlp.v2.FieldId
	148, // 77: google.privacy.dlp.v2.PrivacyMetric.numerical_stats_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.NumericalStatsConfig
	149, // 78: google.privacy.dlp.v2.PrivacyMetric.categorical_stats_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.CategoricalStatsConfig
	150, // 79: google.privacy.dlp.v2.PrivacyMetric.k_anonymity_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.KAnonymityConfig
	151, // 80: google.privacy.dlp.v2.PrivacyMetric.l_diversity_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.LDiversityConfig
	152, // 81: google.privacy.dlp.v2.PrivacyMetric.k_map_estimation_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig
	153, // 82: google.privacy.dlp.v2.PrivacyMetric.delta_presence_estimation_config:type_name -> google.privacy.dlp.v2.PrivacyMetric.DeltaPresenceEstimationConfig
	56,  // 83: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.requested_privacy_metric:type_name -> google.privacy.dlp.v2.PrivacyMetric
	198, // 84: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.requested_source_table:type_name -> google.privacy.dlp.v2.BigQueryTable
	157, // 85: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.numerical_stats_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.NumericalStatsResult
	158, // 86: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.categorical_stats_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult
	159, // 87: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.k_anonymity_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult
	160, // 88: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.l_diversity_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult
	161, // 89: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.k_map_estimation_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult
	162, // 90: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.delta_presence_estimation_result:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult
	59,  // 91: google.privacy.dlp.v2.ValueFrequency.value:type_name -> google.privacy.dlp.v2.Value
	196, // 92: google.privacy.dlp.v2.Value.timestamp_value:type_name -> google.protobuf.Timestamp
	200, // 93: google.privacy.dlp.v2.Value.time_value:type_name -> google.type.TimeOfDay
	201, // 94: google.privacy.dlp.v2.Value.date_value:type_name -> google.type.Date
	202, // 95: google.privacy.dlp.v2.Value.day_of_week_value:type_name -> google.type.DayOfWeek
	61,  // 96: google.privacy.dlp.v2.QuoteInfo.date_time:type_name -> google.privacy.dlp.v2.DateTime
	201, // 97: google.privacy.dlp.v2.DateTime.date:type_name -> google.type.Date
	202, // 98: google.privacy.dlp.v2.DateTime.day_of_week:type_name -> google.type.DayOfWeek
	200, // 99: google.privacy.dlp.v2.DateTime.time:type_name -> google.type.TimeOfDay
	172, // 100: google.privacy.dlp.v2.DateTime.time_zone:type_name -> google.privacy.dlp.v2.DateTime.TimeZone
	81,  // 101: google.privacy.dlp.v2.DeidentifyConfig.info_type_transformations:type_name -> google.privacy.dlp.v2.InfoTypeTransformations
	83,  // 102: google.privacy.dlp.v2.DeidentifyConfig.record_transformations:type_name -> google.privacy.dlp.v2.RecordTransformations
	63,  // 103: google.privacy.dlp.v2.DeidentifyConfig.transformation_error_handling:type_name -> google.privacy.dlp.v2.TransformationErrorHandling
	173, // 104: google.privacy.dlp.v2.TransformationErrorHandling.throw_error:type_name -> google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
	174, // 105: google.privacy.dlp.v2.TransformationErrorHandling.leave_untransformed:type_name -> google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
	68,  // 106: google.privacy.dlp.v2.PrimitiveTransformation.replace_config:type_name -> google.privacy.dlp.v2.ReplaceValueConfig
	70,  // 107: google.privacy.dlp.v2.PrimitiveTransformation.redact_config:type_name -> google.privacy.dlp.v2.RedactConfig
	72,  // 108: google.privacy.dlp.v2.PrimitiveTransformation.character_mask_config:type_name -> google.privacy.dlp.v2.CharacterMaskConfig
	75,  // 109: google.privacy.dlp.v2.PrimitiveTransformation.crypto_replace_ffx_fpe_config:type_name -> google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig
	73,  // 110: google.privacy.dlp.v2.PrimitiveTransformation.fixed_size_bucketing_config:type_name -> google.privacy.dlp.v2.FixedSizeBucketingConfig
	74,  // 111: google.privacy.dlp.v2.PrimitiveTransformation.bucketing_config:type_name -> google.privacy.dlp.v2.BucketingConfig
	69,  // 112: google.privacy.dlp.v2.PrimitiveTransformation.replace_with_info_type_config:type_name -> google.privacy.dlp.v2.ReplaceWithInfoTypeConfig
	65,  // 113: google.privacy.dlp.v2.PrimitiveTransformation.time_part_config:type_name -> google.privacy.dlp.v2.TimePartConfig
	66,  // 114: google.privacy.dlp.v2.PrimitiveTransformation.crypto_hash_config:type_name -> google.privacy.dlp.v2.CryptoHashConfig
	80,  // 115: google.privacy.dlp.v2.PrimitiveTransformation.date_shift_config:type_name -> google.privacy.dlp.v2.DateShiftConfig
	67,  // 116: google.privacy.dlp.v2.PrimitiveTransformation.crypto_deterministic_config:type_name -> google.privacy.dlp.v2.CryptoDeterministicConfig
	9,   // 117: google.privacy.dlp.v2.TimePartConfig.part_to_extract:type_name -> google.privacy.dlp.v2.TimePartConfig.TimePart
	76,  // 118: google.privacy.dlp.v2.CryptoHashConfig.crypto_key:type_name -> google.privacy.dlp.v2.CryptoKey
	76,  // 119: google.privacy.dlp.v2.CryptoDeterministicConfig.crypto_key:type_name -> google.privacy.dlp.v2.CryptoKey
	189, // 120: google.privacy.dlp.v2.CryptoDeterministicConfig.surrogate_info_type:type_name -> google.privacy.dlp.v2.InfoType
	195, // 121: google.privacy.dlp.v2.CryptoDeterministicConfig.context:type_name -> google.privacy.dlp.v2.FieldId
	59,  // 122: google.privacy.dlp.v2.ReplaceValueConfig.new_value:type_name -> google.privacy.dlp.v2.Value
	10,  // 123: google.privacy.dlp.v2.CharsToIgnore.common_characters_to_ignore:type_name -> google.privacy.dlp.v2.CharsToIgnore.CommonCharsToIgnore
	71,  // 124: google.privacy.dlp.v2.CharacterMaskConfig.characters_to_ignore:type_name -> google.privacy.dlp.v2.CharsToIgnore
	59,  // 125: google.privacy.dlp.v2.FixedSizeBucketingConfig.lower_bound:type_name -> google.privacy.dlp.v2.Value
	59,  // 126: google.privacy.dlp.v2.FixedSizeBucketingConfig.upper_bound:type_name -> google.privacy.dlp.v2.Value
	175, // 127: google.privacy.dlp.v2.BucketingConfig.buckets:type_name -> google.privacy.dlp.v2.BucketingConfig.Bucket
	76,  // 128: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.crypto_key:type_name -> google.privacy.dlp.v2.CryptoKey
	195, // 129: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.context:type_name -> google.privacy.dlp.v2.FieldId
	11,  // 130: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.common_alphabet:type_name -> google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.FfxCommonNativeAlphabet
	189, // 131: google.privacy.dlp.v2.CryptoReplaceFfxFpeConfig.surrogate_info_type:type_name -> google.privacy.dlp.v2.InfoType
	77,  // 132: google.privacy.dlp.v2.CryptoKey.transient:type_name -> google.privacy.dlp.v2.TransientCryptoKey
	78,  // 133: google.privacy.dlp.v2.CryptoKey.unwrapped:type_name -> google.privacy.dlp.v2.UnwrappedCryptoKey
	79,  // 134: google.privacy.dlp.v2.CryptoKey.kms_wrapped:type_name -> google.privacy.dlp.v2.KmsWrappedCryptoKey
	195, // 135: google.privacy.dlp.v2.DateShiftConfig.context:type_name -> google.privacy.dlp.v2.FieldId
	76,  // 136: google.privacy.dlp.v2.DateShiftConfig.crypto_key:type_name -> google.privacy.dlp.v2.CryptoKey
	176, // 137: google.privacy.dlp.v2.InfoTypeTransformations.transformations:type_name -> google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation
	195, // 138: google.privacy.dlp.v2.FieldTransformation.fields:type_name -> google.privacy.dlp.v2.FieldId
	85,  // 139: google.privacy.dlp.v2.FieldTransformation.condition:type_name -> google.privacy.dlp.v2.RecordCondition
	64,  // 140: google.privacy.dlp.v2.FieldTransformation.primitive_transformation:type_name -> google.privacy.dlp.v2.PrimitiveTransformation
	81,  // 141: google.privacy.dlp.v2.FieldTransformation.info_type_transformations:type_name -> google.privacy.dlp.v2.InfoTypeTransformations
	82,  // 142: google.privacy.dlp.v2.RecordTransformations.field_transformations:type_name -> google.privacy.dlp.v2.FieldTransformation
	84,  // 143: google.privacy.dlp.v2.RecordTransformations.record_suppressions:type_name -> google.privacy.dlp.v2.RecordSuppression
	85,  // 144: google.privacy.dlp.v2.RecordSuppression.condition:type_name -> google.privacy.dlp.v2.RecordCondition
	179, // 145: google.privacy.dlp.v2.RecordCondition.expressions:type_name -> google.privacy.dlp.v2.RecordCondition.Expressions
	87,  // 146: google.privacy.dlp.v2.TransformationOverview.transformation_summaries:type_name -> google.privacy.dlp.v2.TransformationSummary
	189, // 147: google.privacy.dlp.v2.TransformationSummary.info_type:type_name -> google.privacy.dlp.v2.InfoType
	195, // 148: google.privacy.dlp.v2.TransformationSummary.field:type_name -> google.privacy.dlp.v2.FieldId
	64,  // 149: google.privacy.dlp.v2.TransformationSummary.transformation:type_name -> google.privacy.dlp.v2.PrimitiveTransformation
	82,  // 150: google.privacy.dlp.v2.TransformationSummary.field_transformations:type_name -> google.privacy.dlp.v2.FieldTransformation
	84,  // 151: google.privacy.dlp.v2.TransformationSummary.record_suppress:type_name -> google.privacy.dlp.v2.RecordSuppression
	180, // 152: google.privacy.dlp.v2.TransformationSummary.results:type_name -> google.privacy.dlp.v2.TransformationSummary.SummaryResult
	203, // 153: google.privacy.dlp.v2.Schedule.recurrence_period_duration:type_name -> google.protobuf.Duration
	196, // 154: google.privacy.dlp.v2.InspectTemplate.create_time:type_name -> google.protobuf.Timestamp
	196, // 155: google.privacy.dlp.v2.InspectTemplate.update_time:type_name -> google.protobuf.Timestamp
	20,  // 156: google.privacy.dlp.v2.InspectTemplate.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	196, // 157: google.privacy.dlp.v2.DeidentifyTemplate.create_time:type_name -> google.protobuf.Timestamp
	196, // 158: google.privacy.dlp.v2.DeidentifyTemplate.update_time:type_name -> google.protobuf.Timestamp
	62,  // 159: google.privacy.dlp.v2.DeidentifyTemplate.deidentify_config:type_name -> google.privacy.dlp.v2.DeidentifyConfig
	204, // 160: google.privacy.dlp.v2.Error.details:type_name -> google.rpc.Status
	196, // 161: google.privacy.dlp.v2.Error.timestamps:type_name -> google.protobuf.Timestamp
	109, // 162: google.privacy.dlp.v2.JobTrigger.inspect_job:type_name -> google.privacy.dlp.v2.InspectJobConfig
	181, // 163: google.privacy.dlp.v2.JobTrigger.triggers:type_name -> google.privacy.dlp.v2.JobTrigger.Trigger
	92,  // 164: google.privacy.dlp.v2.JobTrigger.errors:type_name -> google.privacy.dlp.v2.Error
	196, // 165: google.privacy.dlp.v2.JobTrigger.create_time:type_name -> google.protobuf.Timestamp
	196, // 166: google.privacy.dlp.v2.JobTrigger.update_time:type_name -> google.protobuf.Timestamp
	196, // 167: google.privacy.dlp.v2.JobTrigger.last_run_time:type_name -> google.protobuf.Timestamp
	14,  // 168: google.privacy.dlp.v2.JobTrigger.status:type_name -> google.privacy.dlp.v2.JobTrigger.Status
	182, // 169: google.privacy.dlp.v2.Action.save_findings:type_name -> google.privacy.dlp.v2.Action.SaveFindings
	183, // 170: google.privacy.dlp.v2.Action.pub_sub:type_name -> google.privacy.dlp.v2.Action.PublishToPubSub
	184, // 171: google.privacy.dlp.v2.Action.publish_summary_to_cscc:type_name -> google.privacy.dlp.v2.Action.PublishSummaryToCscc
	185, // 172: google.privacy.dlp.v2.Action.publish_findings_to_cloud_data_catalog:type_name -> google.privacy.dlp.v2.Action.PublishFindingsToCloudDataCatalog
	186, // 173: google.privacy.dlp.v2.Action.job_notification_emails:type_name -> google.privacy.dlp.v2.Action.JobNotificationEmails
	187, // 174: google.privacy.dlp.v2.Action.publish_to_stackdriver:type_name -> google.privacy.dlp.v2.Action.PublishToStackdriver
	90,  // 175: google.privacy.dlp.v2.CreateInspectTemplateRequest.inspect_template:type_name -> google.privacy.dlp.v2.InspectTemplate
	90,  // 176: google.privacy.dlp.v2.UpdateInspectTemplateRequest.inspect_template:type_name -> google.privacy.dlp.v2.InspectTemplate
	205, // 177: google.privacy.dlp.v2.UpdateInspectTemplateRequest.update_mask:type_name -> google.protobuf.FieldMask
	90,  // 178: google.privacy.dlp.v2.ListInspectTemplatesResponse.inspect_templates:type_name -> google.privacy.dlp.v2.InspectTemplate
	93,  // 179: google.privacy.dlp.v2.CreateJobTriggerRequest.job_trigger:type_name -> google.privacy.dlp.v2.JobTrigger
	93,  // 180: google.privacy.dlp.v2.UpdateJobTriggerRequest.job_trigger:type_name -> google.privacy.dlp.v2.JobTrigger
	205, // 181: google.privacy.dlp.v2.UpdateJobTriggerRequest.update_mask:type_name -> google.protobuf.FieldMask
	109, // 182: google.privacy.dlp.v2.CreateDlpJobRequest.inspect_job:type_name -> google.privacy.dlp.v2.InspectJobConfig
	53,  // 183: google.privacy.dlp.v2.CreateDlpJobRequest.risk_job:type_name -> google.privacy.dlp.v2.RiskAnalysisJobConfig
	93,  // 184: google.privacy.dlp.v2.ListJobTriggersResponse.job_triggers:type_name -> google.privacy.dlp.v2.JobTrigger
	206, // 185: google.privacy.dlp.v2.InspectJobConfig.storage_config:type_name -> google.privacy.dlp.v2.StorageConfig
	20,  // 186: google.privacy.dlp.v2.InspectJobConfig.inspect_config:type_name -> google.privacy.dlp.v2.InspectConfig
	94,  // 187: google.privacy.dlp.v2.InspectJobConfig.actions:type_name -> google.privacy.dlp.v2.Action
	5,   // 188: google.privacy.dlp.v2.DlpJob.type:type_name -> google.privacy.dlp.v2.DlpJobType
	15,  // 189: google.privacy.dlp.v2.DlpJob.state:type_name -> google.privacy.dlp.v2.DlpJob.JobState
	57,  // 190: google.privacy.dlp.v2.DlpJob.risk_details:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails
	48,  // 191: google.privacy.dlp.v2.DlpJob.inspect_details:type_name -> google.privacy.dlp.v2.InspectDataSourceDetails
	196, // 192: google.privacy.dlp.v2.DlpJob.create_time:type_name -> google.protobuf.Timestamp
	196, // 193: google.privacy.dlp.v2.DlpJob.start_time:type_name -> google.protobuf.Timestamp
	196, // 194: google.privacy.dlp.v2.DlpJob.end_time:type_name -> google.protobuf.Timestamp
	92,  // 195: google.privacy.dlp.v2.DlpJob.errors:type_name -> google.privacy.dlp.v2.Error
	5,   // 196: google.privacy.dlp.v2.ListDlpJobsRequest.type:type_name -> google.privacy.dlp.v2.DlpJobType
	110, // 197: google.privacy.dlp.v2.ListDlpJobsResponse.jobs:type_name -> google.privacy.dlp.v2.DlpJob
	91,  // 198: google.privacy.dlp.v2.CreateDeidentifyTemplateRequest.deidentify_template:type_name -> google.privacy.dlp.v2.DeidentifyTemplate
	91,  // 199: google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest.deidentify_template:type_name -> google.privacy.dlp.v2.DeidentifyTemplate
	205, // 200: google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest.update_mask:type_name -> google.protobuf.FieldMask
	91,  // 201: google.privacy.dlp.v2.ListDeidentifyTemplatesResponse.deidentify_templates:type_name -> google.privacy.dlp.v2.DeidentifyTemplate
	207, // 202: google.privacy.dlp.v2.LargeCustomDictionaryConfig.output_path:type_name -> google.privacy.dlp.v2.CloudStoragePath
	208, // 203: google.privacy.dlp.v2.LargeCustomDictionaryConfig.cloud_storage_file_set:type_name -> google.privacy.dlp.v2.CloudStorageFileSet
	209, // 204: google.privacy.dlp.v2.LargeCustomDictionaryConfig.big_query_field:type_name -> google.privacy.dlp.v2.BigQueryField
	123, // 205: google.privacy.dlp.v2.StoredInfoTypeConfig.large_custom_dictionary:type_name -> google.privacy.dlp.v2.LargeCustomDictionaryConfig
	190, // 206: google.privacy.dlp.v2.StoredInfoTypeConfig.dictionary:type_name -> google.privacy.dlp.v2.CustomInfoType.Dictionary
	191, // 207: google.privacy.dlp.v2.StoredInfoTypeConfig.regex:type_name -> google.privacy.dlp.v2.CustomInfoType.Regex
	124, // 208: google.privacy.dlp.v2.StoredInfoTypeStats.large_custom_dictionary:type_name -> google.privacy.dlp.v2.LargeCustomDictionaryStats
	125, // 209: google.privacy.dlp.v2.StoredInfoTypeVersion.config:type_name -> google.privacy.dlp.v2.StoredInfoTypeConfig
	196, // 210: google.privacy.dlp.v2.StoredInfoTypeVersion.create_time:type_name -> google.protobuf.Timestamp
	6,   // 211: google.privacy.dlp.v2.StoredInfoTypeVersion.state:type_name -> google.privacy.dlp.v2.StoredInfoTypeState
	92,  // 212: google.privacy.dlp.v2.StoredInfoTypeVersion.errors:type_name -> google.privacy.dlp.v2.Error
	126, // 213: google.privacy.dlp.v2.StoredInfoTypeVersion.stats:type_name -> google.privacy.dlp.v2.StoredInfoTypeStats
	127, // 214: google.privacy.dlp.v2.StoredInfoType.current_version:type_name -> google.privacy.dlp.v2.StoredInfoTypeVersion
	127, // 215: google.privacy.dlp.v2.StoredInfoType.pending_versions:type_name -> google.privacy.dlp.v2.StoredInfoTypeVersion
	125, // 216: google.privacy.dlp.v2.CreateStoredInfoTypeRequest.config:type_name -> google.privacy.dlp.v2.StoredInfoTypeConfig
	125, // 217: google.privacy.dlp.v2.UpdateStoredInfoTypeRequest.config:type_name -> google.privacy.dlp.v2.StoredInfoTypeConfig
	205, // 218: google.privacy.dlp.v2.UpdateStoredInfoTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	128, // 219: google.privacy.dlp.v2.ListStoredInfoTypesResponse.stored_info_types:type_name -> google.privacy.dlp.v2.StoredInfoType
	137, // 220: google.privacy.dlp.v2.HybridInspectJobTriggerRequest.hybrid_item:type_name -> google.privacy.dlp.v2.HybridContentItem
	137, // 221: google.privacy.dlp.v2.HybridInspectDlpJobRequest.hybrid_item:type_name -> google.privacy.dlp.v2.HybridContentItem
	22,  // 222: google.privacy.dlp.v2.HybridContentItem.item:type_name -> google.privacy.dlp.v2.ContentItem
	138, // 223: google.privacy.dlp.v2.HybridContentItem.finding_details:type_name -> google.privacy.dlp.v2.HybridFindingDetails
	33,  // 224: google.privacy.dlp.v2.HybridFindingDetails.container_details:type_name -> google.privacy.dlp.v2.Container
	210, // 225: google.privacy.dlp.v2.HybridFindingDetails.table_options:type_name -> google.privacy.dlp.v2.TableOptions
	188, // 226: google.privacy.dlp.v2.HybridFindingDetails.labels:type_name -> google.privacy.dlp.v2.HybridFindingDetails.LabelsEntry
	141, // 227: google.privacy.dlp.v2.InspectConfig.FindingLimits.max_findings_per_info_type:type_name -> google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
	189, // 228: google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.info_type:type_name -> google.privacy.dlp.v2.InfoType
	59,  // 229: google.privacy.dlp.v2.Table.Row.values:type_name -> google.privacy.dlp.v2.Value
	189, // 230: google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.info_type:type_name -> google.privacy.dlp.v2.InfoType
	38,  // 231: google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.redaction_color:type_name -> google.privacy.dlp.v2.Color
	90,  // 232: google.privacy.dlp.v2.InspectDataSourceDetails.RequestedOptions.snapshot_inspect_template:type_name -> google.privacy.dlp.v2.InspectTemplate
	109, // 233: google.privacy.dlp.v2.InspectDataSourceDetails.RequestedOptions.job_config:type_name -> google.privacy.dlp.v2.InspectJobConfig
	47,  // 234: google.privacy.dlp.v2.InspectDataSourceDetails.Result.info_type_stats:type_name -> google.privacy.dlp.v2.InfoTypeStats
	49,  // 235: google.privacy.dlp.v2.InspectDataSourceDetails.Result.hybrid_stats:type_name -> google.privacy.dlp.v2.HybridInspectStatistics
	195, // 236: google.privacy.dlp.v2.StatisticalTable.QuasiIdentifierField.field:type_name -> google.privacy.dlp.v2.FieldId
	195, // 237: google.privacy.dlp.v2.PrivacyMetric.NumericalStatsConfig.field:type_name -> google.privacy.dlp.v2.FieldId
	195, // 238: google.privacy.dlp.v2.PrivacyMetric.CategoricalStatsConfig.field:type_name -> google.privacy.dlp.v2.FieldId
	195, // 239: google.privacy.dlp.v2.PrivacyMetric.KAnonymityConfig.quasi_ids:type_name -> google.privacy.dlp.v2.FieldId
	211, // 240: google.privacy.dlp.v2.PrivacyMetric.KAnonymityConfig.entity_id:type_name -> google.privacy.dlp.v2.EntityId
	195, // 241: google.privacy.dlp.v2.PrivacyMetric.LDiversityConfig.quasi_ids:type_name -> google.privacy.dlp.v2.FieldId
	195, // 242: google.privacy.dlp.v2.PrivacyMetric.LDiversityConfig.sensitive_attribute:type_name -> google.privacy.dlp.v2.FieldId
	154, // 243: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.quasi_ids:type_name -> google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.TaggedField
	155, // 244: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.auxiliary_tables:type_name -> google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable
	54,  // 245: google.privacy.dlp.v2.PrivacyMetric.DeltaPresenceEstimationConfig.quasi_ids:type_name -> google.privacy.dlp.v2.QuasiId
	55,  // 246: google.privacy.dlp.v2.PrivacyMetric.DeltaPresenceEstimationConfig.auxiliary_tables:type_name -> google.privacy.dlp.v2.StatisticalTable
	195, // 247: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.TaggedField.field:type_name -> google.privacy.dlp.v2.FieldId
	189, // 248: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.TaggedField.info_type:type_name -> google.privacy.dlp.v2.InfoType
	199, // 249: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.TaggedField.inferred:type_name -> google.protobuf.Empty
	198, // 250: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.table:type_name -> google.privacy.dlp.v2.BigQueryTable
	156, // 251: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.quasi_ids:type_name -> google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.QuasiIdField
	195, // 252: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.relative_frequency:type_name -> google.privacy.dlp.v2.FieldId
	195, // 253: google.privacy.dlp.v2.PrivacyMetric.KMapEstimationConfig.AuxiliaryTable.QuasiIdField.field:type_name -> google.privacy.dlp.v2.FieldId
	59,  // 254: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.NumericalStatsResult.min_value:type_name -> google.privacy.dlp.v2.Value
	59,  // 255: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.NumericalStatsResult.max_value:type_name -> google.privacy.dlp.v2.Value
	59,  // 256: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.NumericalStatsResult.quantile_values:type_name -> google.privacy.dlp.v2.Value
	163, // 257: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult.value_frequency_histogram_buckets:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult.CategoricalStatsHistogramBucket
	165, // 258: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.equivalence_class_histogram_buckets:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityHistogramBucket
	167, // 259: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.sensitive_value_frequency_histogram_buckets:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityHistogramBucket
	169, // 260: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.k_map_estimation_histogram:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationHistogramBucket
	171, // 261: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.delta_presence_estimation_histogram:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationHistogramBucket
	58,  // 262: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.CategoricalStatsResult.CategoricalStatsHistogramBucket.bucket_values:type_name -> google.privacy.dlp.v2.ValueFrequency
	59,  // 263: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityEquivalenceClass.quasi_ids_values:type_name -> google.privacy.dlp.v2.Value
	164, // 264: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityHistogramBucket.bucket_values:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KAnonymityResult.KAnonymityEquivalenceClass
	59,  // 265: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityEquivalenceClass.quasi_ids_values:type_name -> google.privacy.dlp.v2.Value
	58,  // 266: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityEquivalenceClass.top_sensitive_values:type_name -> google.privacy.dlp.v2.ValueFrequency
	166, // 267: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityHistogramBucket.bucket_values:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.LDiversityResult.LDiversityEquivalenceClass
	59,  // 268: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationQuasiIdValues.quasi_ids_values:type_name -> google.privacy.dlp.v2.Value
	168, // 269: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationHistogramBucket.bucket_values:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.KMapEstimationResult.KMapEstimationQuasiIdValues
	59,  // 270: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationQuasiIdValues.quasi_ids_values:type_name -> google.privacy.dlp.v2.Value
	170, // 271: google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationHistogramBucket.bucket_values:type_name -> google.privacy.dlp.v2.AnalyzeDataSourceRiskDetails.DeltaPresenceEstimationResult.DeltaPresenceEstimationQuasiIdValues
	59,  // 272: google.privacy.dlp.v2.BucketingConfig.Bucket.min:type_name -> google.privacy.dlp.v2.Value
	59,  // 273: google.privacy.dlp.v2.BucketingConfig.Bucket.max:type_name -> google.privacy.dlp.v2.Value
	59,  // 274: google.privacy.dlp.v2.BucketingConfig.Bucket.replacement_value:type_name -> google.privacy.dlp.v2.Value
	189, // 275: google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.info_types:type_name -> google.privacy.dlp.v2.InfoType
	64,  // 276: google.privacy.dlp.v2.InfoTypeTransformations.InfoTypeTransformation.primitive_transformation:type_name -> google.privacy.dlp.v2.PrimitiveTransformation
	195, // 277: google.privacy.dlp.v2.RecordCondition.Condition.field:type_name -> google.privacy.dlp.v2.FieldId
	0,   // 278: google.privacy.dlp.v2.RecordCondition.Condition.operator:type_name -> google.privacy.dlp.v2.RelationalOperator
	59,  // 279: google.privacy.dlp.v2.RecordCondition.Condition.value:type_name -> google.privacy.dlp.v2.Value
	177, // 280: google.privacy.dlp.v2.RecordCondition.Conditions.conditions:type_name -> google.privacy.dlp.v2.RecordCondition.Condition
	12,  // 281: google.privacy.dlp.v2.RecordCondition.Expressions.logical_operator:type_name -> google.privacy.dlp.v2.RecordCondition.Expressions.LogicalOperator
	178, // 282: google.privacy.dlp.v2.RecordCondition.Expressions.conditions:type_name -> google.privacy.dlp.v2.RecordCondition.Conditions
	13,  // 283: google.privacy.dlp.v2.TransformationSummary.SummaryResult.code:type_name -> google.privacy.dlp.v2.TransformationSummary.TransformationResultCode
	88,  // 284: google.privacy.dlp.v2.JobTrigger.Trigger.schedule:type_name -> google.privacy.dlp.v2.Schedule
	89,  // 285: google.privacy.dlp.v2.JobTrigger.Trigger.manual:type_name -> google.privacy.dlp.v2.Manual
	46,  // 286: google.privacy.dlp.v2.Action.SaveFindings.output_config:type_name -> google.privacy.dlp.v2.OutputStorageConfig
	44,  // 287: google.privacy.dlp.v2.DlpService.InspectContent:input_type -> google.privacy.dlp.v2.InspectContentRequest
	37,  // 288: google.privacy.dlp.v2.DlpService.RedactImage:input_type -> google.privacy.dlp.v2.RedactImageRequest
	40,  // 289: google.privacy.dlp.v2.DlpService.DeidentifyContent:input_type -> google.privacy.dlp.v2.DeidentifyContentRequest
	42,  // 290: google.privacy.dlp.v2.DlpService.ReidentifyContent:input_type -> google.privacy.dlp.v2.ReidentifyContentRequest
	51,  // 291: google.privacy.dlp.v2.DlpService.ListInfoTypes:input_type -> google.privacy.dlp.v2.ListInfoTypesRequest
	95,  // 292: google.privacy.dlp.v2.DlpService.CreateInspectTemplate:input_type -> google.privacy.dlp.v2.CreateInspectTemplateRequest
	96,  // 293: google.privacy.dlp.v2.DlpService.UpdateInspectTemplate:input_type -> google.privacy.dlp.v2.UpdateInspectTemplateRequest
	97,  // 294: google.privacy.dlp.v2.DlpService.GetInspectTemplate:input_type -> google.privacy.dlp.v2.GetInspectTemplateRequest
	98,  // 295: google.privacy.dlp.v2.DlpService.ListInspectTemplates:input_type -> google.privacy.dlp.v2.ListInspectTemplatesRequest
	100, // 296: google.privacy.dlp.v2.DlpService.DeleteInspectTemplate:input_type -> google.privacy.dlp.v2.DeleteInspectTemplateRequest
	117, // 297: google.privacy.dlp.v2.DlpService.CreateDeidentifyTemplate:input_type -> google.privacy.dlp.v2.CreateDeidentifyTemplateRequest
	118, // 298: google.privacy.dlp.v2.DlpService.UpdateDeidentifyTemplate:input_type -> google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest
	119, // 299: google.privacy.dlp.v2.DlpService.GetDeidentifyTemplate:input_type -> google.privacy.dlp.v2.GetDeidentifyTemplateRequest
	120, // 300: google.privacy.dlp.v2.DlpService.ListDeidentifyTemplates:input_type -> google.privacy.dlp.v2.ListDeidentifyTemplatesRequest
	122, // 301: google.privacy.dlp.v2.DlpService.DeleteDeidentifyTemplate:input_type -> google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest
	101, // 302: google.privacy.dlp.v2.DlpService.CreateJobTrigger:input_type -> google.privacy.dlp.v2.CreateJobTriggerRequest
	103, // 303: google.privacy.dlp.v2.DlpService.UpdateJobTrigger:input_type -> google.privacy.dlp.v2.UpdateJobTriggerRequest
	135, // 304: google.privacy.dlp.v2.DlpService.HybridInspectJobTrigger:input_type -> google.privacy.dlp.v2.HybridInspectJobTriggerRequest
	104, // 305: google.privacy.dlp.v2.DlpService.GetJobTrigger:input_type -> google.privacy.dlp.v2.GetJobTriggerRequest
	106, // 306: google.privacy.dlp.v2.DlpService.ListJobTriggers:input_type -> google.privacy.dlp.v2.ListJobTriggersRequest
	108, // 307: google.privacy.dlp.v2.DlpService.DeleteJobTrigger:input_type -> google.privacy.dlp.v2.DeleteJobTriggerRequest
	102, // 308: google.privacy.dlp.v2.DlpService.ActivateJobTrigger:input_type -> google.privacy.dlp.v2.ActivateJobTriggerRequest
	105, // 309: google.privacy.dlp.v2.DlpService.CreateDlpJob:input_type -> google.privacy.dlp.v2.CreateDlpJobRequest
	112, // 310: google.privacy.dlp.v2.DlpService.ListDlpJobs:input_type -> google.privacy.dlp.v2.ListDlpJobsRequest
	111, // 311: google.privacy.dlp.v2.DlpService.GetDlpJob:input_type -> google.privacy.dlp.v2.GetDlpJobRequest
	116, // 312: google.privacy.dlp.v2.DlpService.DeleteDlpJob:input_type -> google.privacy.dlp.v2.DeleteDlpJobRequest
	114, // 313: google.privacy.dlp.v2.DlpService.CancelDlpJob:input_type -> google.privacy.dlp.v2.CancelDlpJobRequest
	129, // 314: google.privacy.dlp.v2.DlpService.CreateStoredInfoType:input_type -> google.privacy.dlp.v2.CreateStoredInfoTypeRequest
	130, // 315: google.privacy.dlp.v2.DlpService.UpdateStoredInfoType:input_type -> google.privacy.dlp.v2.UpdateStoredInfoTypeRequest
	131, // 316: google.privacy.dlp.v2.DlpService.GetStoredInfoType:input_type -> google.privacy.dlp.v2.GetStoredInfoTypeRequest
	132, // 317: google.privacy.dlp.v2.DlpService.ListStoredInfoTypes:input_type -> google.privacy.dlp.v2.ListStoredInfoTypesRequest
	134, // 318: google.privacy.dlp.v2.DlpService.DeleteStoredInfoType:input_type -> google.privacy.dlp.v2.DeleteStoredInfoTypeRequest
	136, // 319: google.privacy.dlp.v2.DlpService.HybridInspectDlpJob:input_type -> google.privacy.dlp.v2.HybridInspectDlpJobRequest
	115, // 320: google.privacy.dlp.v2.DlpService.FinishDlpJob:input_type -> google.privacy.dlp.v2.FinishDlpJobRequest
	45,  // 321: google.privacy.dlp.v2.DlpService.InspectContent:output_type -> google.privacy.dlp.v2.InspectContentResponse
	39,  // 322: google.privacy.dlp.v2.DlpService.RedactImage:output_type -> google.privacy.dlp.v2.RedactImageResponse
	41,  // 323: google.privacy.dlp.v2.DlpService.DeidentifyContent:output_type -> google.privacy.dlp.v2.DeidentifyContentResponse
	43,  // 324: google.privacy.dlp.v2.DlpService.ReidentifyContent:output_type -> google.privacy.dlp.v2.ReidentifyContentResponse
	52,  // 325: google.privacy.dlp.v2.DlpService.ListInfoTypes:output_type -> google.privacy.dlp.v2.ListInfoTypesResponse
	90,  // 326: google.privacy.dlp.v2.DlpService.CreateInspectTemplate:output_type -> google.privacy.dlp.v2.InspectTemplate
	90,  // 327: google.privacy.dlp.v2.DlpService.UpdateInspectTemplate:output_type -> google.privacy.dlp.v2.InspectTemplate
	90,  // 328: google.privacy.dlp.v2.DlpService.GetInspectTemplate:output_type -> google.privacy.dlp.v2.InspectTemplate
	99,  // 329: google.privacy.dlp.v2.DlpService.ListInspectTemplates:output_type -> google.privacy.dlp.v2.ListInspectTemplatesResponse
	199, // 330: google.privacy.dlp.v2.DlpService.DeleteInspectTemplate:output_type -> google.protobuf.Empty
	91,  // 331: google.privacy.dlp.v2.DlpService.CreateDeidentifyTemplate:output_type -> google.privacy.dlp.v2.DeidentifyTemplate
	91,  // 332: google.privacy.dlp.v2.DlpService.UpdateDeidentifyTemplate:output_type -> google.privacy.dlp.v2.DeidentifyTemplate
	91,  // 333: google.privacy.dlp.v2.DlpService.GetDeidentifyTemplate:output_type -> google.privacy.dlp.v2.DeidentifyTemplate
	121, // 334: google.privacy.dlp.v2.DlpService.ListDeidentifyTemplates:output_type -> google.privacy.dlp.v2.ListDeidentifyTemplatesResponse
	199, // 335: google.privacy.dlp.v2.DlpService.DeleteDeidentifyTemplate:output_type -> google.protobuf.Empty
	93,  // 336: google.privacy.dlp.v2.DlpService.CreateJobTrigger:output_type -> google.privacy.dlp.v2.JobTrigger
	93,  // 337: google.privacy.dlp.v2.DlpService.UpdateJobTrigger:output_type -> google.privacy.dlp.v2.JobTrigger
	139, // 338: google.privacy.dlp.v2.DlpService.HybridInspectJobTrigger:output_type -> google.privacy.dlp.v2.HybridInspectResponse
	93,  // 339: google.privacy.dlp.v2.DlpService.GetJobTrigger:output_type -> google.privacy.dlp.v2.JobTrigger
	107, // 340: google.privacy.dlp.v2.DlpService.ListJobTriggers:output_type -> google.privacy.dlp.v2.ListJobTriggersResponse
	199, // 341: google.privacy.dlp.v2.DlpService.DeleteJobTrigger:output_type -> google.protobuf.Empty
	110, // 342: google.privacy.dlp.v2.DlpService.ActivateJobTrigger:output_type -> google.privacy.dlp.v2.DlpJob
	110, // 343: google.privacy.dlp.v2.DlpService.CreateDlpJob:output_type -> google.privacy.dlp.v2.DlpJob
	113, // 344: google.privacy.dlp.v2.DlpService.ListDlpJobs:output_type -> google.privacy.dlp.v2.ListDlpJobsResponse
	110, // 345: google.privacy.dlp.v2.DlpService.GetDlpJob:output_type -> google.privacy.dlp.v2.DlpJob
	199, // 346: google.privacy.dlp.v2.DlpService.DeleteDlpJob:output_type -> google.protobuf.Empty
	199, // 347: google.privacy.dlp.v2.DlpService.CancelDlpJob:output_type -> google.protobuf.Empty
	128, // 348: google.privacy.dlp.v2.DlpService.CreateStoredInfoType:output_type -> google.privacy.dlp.v2.StoredInfoType
	128, // 349: google.privacy.dlp.v2.DlpService.UpdateStoredInfoType:output_type -> google.privacy.dlp.v2.StoredInfoType
	128, // 350: google.privacy.dlp.v2.DlpService.GetStoredInfoType:output_type -> google.privacy.dlp.v2.StoredInfoType
	133, // 351: google.privacy.dlp.v2.DlpService.ListStoredInfoTypes:output_type -> google.privacy.dlp.v2.ListStoredInfoTypesResponse
	199, // 352: google.privacy.dlp.v2.DlpService.DeleteStoredInfoType:output_type -> google.protobuf.Empty
	139, // 353: google.privacy.dlp.v2.DlpService.HybridInspectDlpJob:output_type -> google.privacy.dlp.v2.HybridInspectResponse
	199, // 354: google.privacy.dlp.v2.DlpService.FinishDlpJob:output_type -> google.protobuf.Empty
	321, // [321:355] is the sub-list for method output_type
	287, // [287:321] is the sub-list for method input_type
	287, // [287:287] is the sub-list for extension type_name
	287, // [287:287] is the sub-list for extension extendee
	0,   // [0:287] is the sub-list for field type_name
}

func init() { file_google_privacy_dlp_v2_dlp_proto_init() }
func file_google_privacy_dlp_v2_dlp_proto_init() {
	if File_google_privacy_dlp_v2_dlp_proto != nil {
		return
	}
	file_google_privacy_dlp_v2_storage_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExcludeInfoTypes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExclusionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectionRuleSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ByteContentItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Finding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageMetadataLabel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedactImageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Color); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedactImageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeidentifyContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeidentifyContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReidentifyContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReidentifyContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputStorageConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfoTypeStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectDataSourceDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridInspectStatistics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfoTypeDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInfoTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInfoTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RiskAnalysisJobConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuasiId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatisticalTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueFrequency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuoteInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeidentifyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationErrorHandling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrimitiveTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimePartConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoHashConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoDeterministicConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplaceValueConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplaceWithInfoTypeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedactConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CharsToIgnore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CharacterMaskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FixedSizeBucketingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BucketingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoReplaceFfxFpeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransientCryptoKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnwrappedCryptoKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KmsWrappedCryptoKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateShiftConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfoTypeTransformations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordTransformations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordSuppression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationOverview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Manual); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeidentifyTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateInspectTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateInspectTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInspectTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInspectTemplatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInspectTemplatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteInspectTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActivateJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobTriggersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobTriggersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectJobConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DlpJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDlpJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDlpJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinishDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeidentifyTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDeidentifyTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeidentifyTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeidentifyTemplatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeidentifyTemplatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDeidentifyTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LargeCustomDictionaryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LargeCustomDictionaryStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredInfoTypeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredInfoTypeStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredInfoTypeVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredInfoType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateStoredInfoTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateStoredInfoTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoredInfoTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStoredInfoTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStoredInfoTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteStoredInfoTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridInspectJobTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridInspectDlpJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridContentItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridFindingDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridInspectResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectConfig_FindingLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectConfig_FindingLimits_InfoTypeLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table_Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RedactImageRequest_ImageRedactionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectDataSourceDetails_RequestedOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InspectDataSourceDetails_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatisticalTable_QuasiIdentifierField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_NumericalStatsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_CategoricalStatsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_KAnonymityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_LDiversityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_KMapEstimationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_DeltaPresenceEstimationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_KMapEstimationConfig_TaggedField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[140].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[141].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_NumericalStatsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[142].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[143].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KAnonymityResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_LDiversityResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KMapEstimationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[147].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[148].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[149].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[150].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[151].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[152].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[153].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[154].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTime_TimeZone); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationErrorHandling_ThrowError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationErrorHandling_LeaveUntransformed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[159].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BucketingConfig_Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[160].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfoTypeTransformations_InfoTypeTransformation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[161].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordCondition_Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[162].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordCondition_Conditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[163].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordCondition_Expressions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformationSummary_SummaryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[165].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobTrigger_Trigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[166].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_SaveFindings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[167].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_PublishToPubSub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[168].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_PublishSummaryToCscc); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[169].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_PublishFindingsToCloudDataCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[170].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_JobNotificationEmails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_dlp_proto_msgTypes[171].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_PublishToStackdriver); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ExclusionRule_Dictionary)(nil),
		(*ExclusionRule_Regex)(nil),
		(*ExclusionRule_ExcludeInfoTypes)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*InspectionRule_HotwordRule)(nil),
		(*InspectionRule_ExclusionRule)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*ContentItem_Value)(nil),
		(*ContentItem_Table)(nil),
		(*ContentItem_ByteItem)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*ContentLocation_RecordLocation)(nil),
		(*ContentLocation_ImageLocation)(nil),
		(*ContentLocation_DocumentLocation)(nil),
		(*ContentLocation_MetadataLocation)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*MetadataLocation_StorageLabel)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*OutputStorageConfig_Table)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*QuasiId_InfoType)(nil),
		(*QuasiId_CustomTag)(nil),
		(*QuasiId_Inferred)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*PrivacyMetric_NumericalStatsConfig_)(nil),
		(*PrivacyMetric_CategoricalStatsConfig_)(nil),
		(*PrivacyMetric_KAnonymityConfig_)(nil),
		(*PrivacyMetric_LDiversityConfig_)(nil),
		(*PrivacyMetric_KMapEstimationConfig_)(nil),
		(*PrivacyMetric_DeltaPresenceEstimationConfig_)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*AnalyzeDataSourceRiskDetails_NumericalStatsResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_CategoricalStatsResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_KAnonymityResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_LDiversityResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_KMapEstimationResult_)(nil),
		(*AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[43].OneofWrappers = []interface{}{
		(*Value_IntegerValue)(nil),
		(*Value_FloatValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BooleanValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_TimeValue)(nil),
		(*Value_DateValue)(nil),
		(*Value_DayOfWeekValue)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[44].OneofWrappers = []interface{}{
		(*QuoteInfo_DateTime)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[46].OneofWrappers = []interface{}{
		(*DeidentifyConfig_InfoTypeTransformations)(nil),
		(*DeidentifyConfig_RecordTransformations)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[47].OneofWrappers = []interface{}{
		(*TransformationErrorHandling_ThrowError_)(nil),
		(*TransformationErrorHandling_LeaveUntransformed_)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[48].OneofWrappers = []interface{}{
		(*PrimitiveTransformation_ReplaceConfig)(nil),
		(*PrimitiveTransformation_RedactConfig)(nil),
		(*PrimitiveTransformation_CharacterMaskConfig)(nil),
		(*PrimitiveTransformation_CryptoReplaceFfxFpeConfig)(nil),
		(*PrimitiveTransformation_FixedSizeBucketingConfig)(nil),
		(*PrimitiveTransformation_BucketingConfig)(nil),
		(*PrimitiveTransformation_ReplaceWithInfoTypeConfig)(nil),
		(*PrimitiveTransformation_TimePartConfig)(nil),
		(*PrimitiveTransformation_CryptoHashConfig)(nil),
		(*PrimitiveTransformation_DateShiftConfig)(nil),
		(*PrimitiveTransformation_CryptoDeterministicConfig)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[55].OneofWrappers = []interface{}{
		(*CharsToIgnore_CharactersToSkip)(nil),
		(*CharsToIgnore_CommonCharactersToIgnore)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[59].OneofWrappers = []interface{}{
		(*CryptoReplaceFfxFpeConfig_CommonAlphabet)(nil),
		(*CryptoReplaceFfxFpeConfig_CustomAlphabet)(nil),
		(*CryptoReplaceFfxFpeConfig_Radix)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[60].OneofWrappers = []interface{}{
		(*CryptoKey_Transient)(nil),
		(*CryptoKey_Unwrapped)(nil),
		(*CryptoKey_KmsWrapped)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[64].OneofWrappers = []interface{}{
		(*DateShiftConfig_CryptoKey)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[66].OneofWrappers = []interface{}{
		(*FieldTransformation_PrimitiveTransformation)(nil),
		(*FieldTransformation_InfoTypeTransformations)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[72].OneofWrappers = []interface{}{
		(*Schedule_RecurrencePeriodDuration)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[77].OneofWrappers = []interface{}{
		(*JobTrigger_InspectJob)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[78].OneofWrappers = []interface{}{
		(*Action_SaveFindings_)(nil),
		(*Action_PubSub)(nil),
		(*Action_PublishSummaryToCscc_)(nil),
		(*Action_PublishFindingsToCloudDataCatalog_)(nil),
		(*Action_JobNotificationEmails_)(nil),
		(*Action_PublishToStackdriver_)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[89].OneofWrappers = []interface{}{
		(*CreateDlpJobRequest_InspectJob)(nil),
		(*CreateDlpJobRequest_RiskJob)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[94].OneofWrappers = []interface{}{
		(*DlpJob_RiskDetails)(nil),
		(*DlpJob_InspectDetails)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[107].OneofWrappers = []interface{}{
		(*LargeCustomDictionaryConfig_CloudStorageFileSet)(nil),
		(*LargeCustomDictionaryConfig_BigQueryField)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[109].OneofWrappers = []interface{}{
		(*StoredInfoTypeConfig_LargeCustomDictionary)(nil),
		(*StoredInfoTypeConfig_Dictionary)(nil),
		(*StoredInfoTypeConfig_Regex)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[110].OneofWrappers = []interface{}{
		(*StoredInfoTypeStats_LargeCustomDictionary)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[128].OneofWrappers = []interface{}{
		(*RedactImageRequest_ImageRedactionConfig_InfoType)(nil),
		(*RedactImageRequest_ImageRedactionConfig_RedactAllText)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[138].OneofWrappers = []interface{}{
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType)(nil),
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag)(nil),
		(*PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[163].OneofWrappers = []interface{}{
		(*RecordCondition_Expressions_Conditions)(nil),
	}
	file_google_privacy_dlp_v2_dlp_proto_msgTypes[165].OneofWrappers = []interface{}{
		(*JobTrigger_Trigger_Schedule)(nil),
		(*JobTrigger_Trigger_Manual)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_privacy_dlp_v2_dlp_proto_rawDesc,
			NumEnums:      16,
			NumMessages:   173,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_privacy_dlp_v2_dlp_proto_goTypes,
		DependencyIndexes: file_google_privacy_dlp_v2_dlp_proto_depIdxs,
		EnumInfos:         file_google_privacy_dlp_v2_dlp_proto_enumTypes,
		MessageInfos:      file_google_privacy_dlp_v2_dlp_proto_msgTypes,
	}.Build()
	File_google_privacy_dlp_v2_dlp_proto = out.File
	file_google_privacy_dlp_v2_dlp_proto_rawDesc = nil
	file_google_privacy_dlp_v2_dlp_proto_goTypes = nil
	file_google_privacy_dlp_v2_dlp_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DlpServiceClient is the client API for DlpService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DlpServiceClient interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// For how to guides, see https://cloud.google.com/dlp/docs/inspecting-images
	// and https://cloud.google.com/dlp/docs/inspecting-text,
	InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// See https://cloud.google.com/dlp/docs/redacting-sensitive-data-images to
	// learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// See https://cloud.google.com/dlp/docs/deidentify-sensitive-data to
	// learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error)
	// Re-identifies content that has been de-identified.
	// See
	// https://cloud.google.com/dlp/docs/pseudonymization#re-identification_in_free_text_code_example
	// to learn more.
	ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error)
	// Returns a list of the sensitive information types that the DLP API
	// supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
	// learn more.
	ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error)
	// Creates an InspectTemplate for re-using frequently used configuration
	// for inspecting content, images, and storage.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Updates the InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Gets an InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error)
	// Lists InspectTemplates.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error)
	// Deletes an InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a DeidentifyTemplate for re-using frequently used configuration
	// for de-identifying content, images, and storage.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Updates the DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Gets a DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error)
	// Lists DeidentifyTemplates.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error)
	// Deletes a DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a job trigger to run DLP actions such as scanning storage for
	// sensitive information on a set schedule.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Updates a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Inspect hybrid content and store findings to a trigger. The inspection
	// will be processed asynchronously. To review the findings monitor the
	// jobs within the trigger.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridInspectJobTrigger(ctx context.Context, in *HybridInspectJobTriggerRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error)
	// Gets a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error)
	// Lists job triggers.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Activate a job trigger. Causes the immediate execute of a trigger
	// instead of waiting on the trigger event to occur.
	ActivateJobTrigger(ctx context.Context, in *ActivateJobTriggerRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Creates a new job to inspect storage or calculate risk metrics.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	CreateDlpJob(ctx context.Context, in *CreateDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Lists DlpJobs that match the specified filter in the request.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be cancelled if
	// possible.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob. The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a pre-built stored infoType to be used for inspection.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	CreateStoredInfoType(ctx context.Context, in *CreateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Updates the stored infoType by creating a new version. The existing version
	// will continue to be used until the new version is ready.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	UpdateStoredInfoType(ctx context.Context, in *UpdateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Gets a stored infoType.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	GetStoredInfoType(ctx context.Context, in *GetStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error)
	// Lists stored infoTypes.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	ListStoredInfoTypes(ctx context.Context, in *ListStoredInfoTypesRequest, opts ...grpc.CallOption) (*ListStoredInfoTypesResponse, error)
	// Deletes a stored infoType.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	DeleteStoredInfoType(ctx context.Context, in *DeleteStoredInfoTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Inspect hybrid content and store findings to a job.
	// To review the findings inspect the job. Inspection will occur
	// asynchronously.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridInspectDlpJob(ctx context.Context, in *HybridInspectDlpJobRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error)
	// Finish a running hybrid DlpJob. Triggers the finalization steps and running
	// of any enabled actions that have not yet run.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	FinishDlpJob(ctx context.Context, in *FinishDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type dlpServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDlpServiceClient(cc grpc.ClientConnInterface) DlpServiceClient {
	return &dlpServiceClient{cc}
}

func (c *dlpServiceClient) InspectContent(ctx context.Context, in *InspectContentRequest, opts ...grpc.CallOption) (*InspectContentResponse, error) {
	out := new(InspectContentResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/InspectContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) RedactImage(ctx context.Context, in *RedactImageRequest, opts ...grpc.CallOption) (*RedactImageResponse, error) {
	out := new(RedactImageResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/RedactImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeidentifyContent(ctx context.Context, in *DeidentifyContentRequest, opts ...grpc.CallOption) (*DeidentifyContentResponse, error) {
	out := new(DeidentifyContentResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeidentifyContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ReidentifyContent(ctx context.Context, in *ReidentifyContentRequest, opts ...grpc.CallOption) (*ReidentifyContentResponse, error) {
	out := new(ReidentifyContentResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ReidentifyContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInfoTypes(ctx context.Context, in *ListInfoTypesRequest, opts ...grpc.CallOption) (*ListInfoTypesResponse, error) {
	out := new(ListInfoTypesResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListInfoTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateInspectTemplate(ctx context.Context, in *CreateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CreateInspectTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateInspectTemplate(ctx context.Context, in *UpdateInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/UpdateInspectTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetInspectTemplate(ctx context.Context, in *GetInspectTemplateRequest, opts ...grpc.CallOption) (*InspectTemplate, error) {
	out := new(InspectTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/GetInspectTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListInspectTemplates(ctx context.Context, in *ListInspectTemplatesRequest, opts ...grpc.CallOption) (*ListInspectTemplatesResponse, error) {
	out := new(ListInspectTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListInspectTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteInspectTemplate(ctx context.Context, in *DeleteInspectTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeleteInspectTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDeidentifyTemplate(ctx context.Context, in *CreateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CreateDeidentifyTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateDeidentifyTemplate(ctx context.Context, in *UpdateDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/UpdateDeidentifyTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDeidentifyTemplate(ctx context.Context, in *GetDeidentifyTemplateRequest, opts ...grpc.CallOption) (*DeidentifyTemplate, error) {
	out := new(DeidentifyTemplate)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/GetDeidentifyTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDeidentifyTemplates(ctx context.Context, in *ListDeidentifyTemplatesRequest, opts ...grpc.CallOption) (*ListDeidentifyTemplatesResponse, error) {
	out := new(ListDeidentifyTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListDeidentifyTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDeidentifyTemplate(ctx context.Context, in *DeleteDeidentifyTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeleteDeidentifyTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateJobTrigger(ctx context.Context, in *CreateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CreateJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateJobTrigger(ctx context.Context, in *UpdateJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/UpdateJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) HybridInspectJobTrigger(ctx context.Context, in *HybridInspectJobTriggerRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error) {
	out := new(HybridInspectResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/HybridInspectJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetJobTrigger(ctx context.Context, in *GetJobTriggerRequest, opts ...grpc.CallOption) (*JobTrigger, error) {
	out := new(JobTrigger)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/GetJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListJobTriggers(ctx context.Context, in *ListJobTriggersRequest, opts ...grpc.CallOption) (*ListJobTriggersResponse, error) {
	out := new(ListJobTriggersResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListJobTriggers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteJobTrigger(ctx context.Context, in *DeleteJobTriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeleteJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ActivateJobTrigger(ctx context.Context, in *ActivateJobTriggerRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ActivateJobTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateDlpJob(ctx context.Context, in *CreateDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CreateDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListDlpJobs(ctx context.Context, in *ListDlpJobsRequest, opts ...grpc.CallOption) (*ListDlpJobsResponse, error) {
	out := new(ListDlpJobsResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListDlpJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetDlpJob(ctx context.Context, in *GetDlpJobRequest, opts ...grpc.CallOption) (*DlpJob, error) {
	out := new(DlpJob)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/GetDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteDlpJob(ctx context.Context, in *DeleteDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeleteDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CancelDlpJob(ctx context.Context, in *CancelDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CancelDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) CreateStoredInfoType(ctx context.Context, in *CreateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/CreateStoredInfoType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) UpdateStoredInfoType(ctx context.Context, in *UpdateStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/UpdateStoredInfoType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) GetStoredInfoType(ctx context.Context, in *GetStoredInfoTypeRequest, opts ...grpc.CallOption) (*StoredInfoType, error) {
	out := new(StoredInfoType)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/GetStoredInfoType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) ListStoredInfoTypes(ctx context.Context, in *ListStoredInfoTypesRequest, opts ...grpc.CallOption) (*ListStoredInfoTypesResponse, error) {
	out := new(ListStoredInfoTypesResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/ListStoredInfoTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) DeleteStoredInfoType(ctx context.Context, in *DeleteStoredInfoTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/DeleteStoredInfoType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) HybridInspectDlpJob(ctx context.Context, in *HybridInspectDlpJobRequest, opts ...grpc.CallOption) (*HybridInspectResponse, error) {
	out := new(HybridInspectResponse)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/HybridInspectDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dlpServiceClient) FinishDlpJob(ctx context.Context, in *FinishDlpJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.privacy.dlp.v2.DlpService/FinishDlpJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DlpServiceServer is the server API for DlpService service.
type DlpServiceServer interface {
	// Finds potentially sensitive info in content.
	// This method has limits on input size, processing time, and output size.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	//
	// For how to guides, see https://cloud.google.com/dlp/docs/inspecting-images
	// and https://cloud.google.com/dlp/docs/inspecting-text,
	InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error)
	// Redacts potentially sensitive info from an image.
	// This method has limits on input size, processing time, and output size.
	// See https://cloud.google.com/dlp/docs/redacting-sensitive-data-images to
	// learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	RedactImage(context.Context, *RedactImageRequest) (*RedactImageResponse, error)
	// De-identifies potentially sensitive info from a ContentItem.
	// This method has limits on input size and output size.
	// See https://cloud.google.com/dlp/docs/deidentify-sensitive-data to
	// learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in this request, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	DeidentifyContent(context.Context, *DeidentifyContentRequest) (*DeidentifyContentResponse, error)
	// Re-identifies content that has been de-identified.
	// See
	// https://cloud.google.com/dlp/docs/pseudonymization#re-identification_in_free_text_code_example
	// to learn more.
	ReidentifyContent(context.Context, *ReidentifyContentRequest) (*ReidentifyContentResponse, error)
	// Returns a list of the sensitive information types that the DLP API
	// supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
	// learn more.
	ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error)
	// Creates an InspectTemplate for re-using frequently used configuration
	// for inspecting content, images, and storage.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	CreateInspectTemplate(context.Context, *CreateInspectTemplateRequest) (*InspectTemplate, error)
	// Updates the InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	UpdateInspectTemplate(context.Context, *UpdateInspectTemplateRequest) (*InspectTemplate, error)
	// Gets an InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	GetInspectTemplate(context.Context, *GetInspectTemplateRequest) (*InspectTemplate, error)
	// Lists InspectTemplates.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	ListInspectTemplates(context.Context, *ListInspectTemplatesRequest) (*ListInspectTemplatesResponse, error)
	// Deletes an InspectTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
	DeleteInspectTemplate(context.Context, *DeleteInspectTemplateRequest) (*emptypb.Empty, error)
	// Creates a DeidentifyTemplate for re-using frequently used configuration
	// for de-identifying content, images, and storage.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	CreateDeidentifyTemplate(context.Context, *CreateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Updates the DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	UpdateDeidentifyTemplate(context.Context, *UpdateDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Gets a DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	GetDeidentifyTemplate(context.Context, *GetDeidentifyTemplateRequest) (*DeidentifyTemplate, error)
	// Lists DeidentifyTemplates.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	ListDeidentifyTemplates(context.Context, *ListDeidentifyTemplatesRequest) (*ListDeidentifyTemplatesResponse, error)
	// Deletes a DeidentifyTemplate.
	// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
	// more.
	DeleteDeidentifyTemplate(context.Context, *DeleteDeidentifyTemplateRequest) (*emptypb.Empty, error)
	// Creates a job trigger to run DLP actions such as scanning storage for
	// sensitive information on a set schedule.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	CreateJobTrigger(context.Context, *CreateJobTriggerRequest) (*JobTrigger, error)
	// Updates a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	UpdateJobTrigger(context.Context, *UpdateJobTriggerRequest) (*JobTrigger, error)
	// Inspect hybrid content and store findings to a trigger. The inspection
	// will be processed asynchronously. To review the findings monitor the
	// jobs within the trigger.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridInspectJobTrigger(context.Context, *HybridInspectJobTriggerRequest) (*HybridInspectResponse, error)
	// Gets a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	GetJobTrigger(context.Context, *GetJobTriggerRequest) (*JobTrigger, error)
	// Lists job triggers.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	ListJobTriggers(context.Context, *ListJobTriggersRequest) (*ListJobTriggersResponse, error)
	// Deletes a job trigger.
	// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
	DeleteJobTrigger(context.Context, *DeleteJobTriggerRequest) (*emptypb.Empty, error)
	// Activate a job trigger. Causes the immediate execute of a trigger
	// instead of waiting on the trigger event to occur.
	ActivateJobTrigger(context.Context, *ActivateJobTriggerRequest) (*DlpJob, error)
	// Creates a new job to inspect storage or calculate risk metrics.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	//
	// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
	// system will automatically choose what detectors to run. By default this may
	// be all types, but may change over time as detectors are updated.
	CreateDlpJob(context.Context, *CreateDlpJobRequest) (*DlpJob, error)
	// Lists DlpJobs that match the specified filter in the request.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	ListDlpJobs(context.Context, *ListDlpJobsRequest) (*ListDlpJobsResponse, error)
	// Gets the latest state of a long-running DlpJob.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	GetDlpJob(context.Context, *GetDlpJobRequest) (*DlpJob, error)
	// Deletes a long-running DlpJob. This method indicates that the client is
	// no longer interested in the DlpJob result. The job will be cancelled if
	// possible.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	DeleteDlpJob(context.Context, *DeleteDlpJobRequest) (*emptypb.Empty, error)
	// Starts asynchronous cancellation on a long-running DlpJob. The server
	// makes a best effort to cancel the DlpJob, but success is not
	// guaranteed.
	// See https://cloud.google.com/dlp/docs/inspecting-storage and
	// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
	CancelDlpJob(context.Context, *CancelDlpJobRequest) (*emptypb.Empty, error)
	// Creates a pre-built stored infoType to be used for inspection.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	CreateStoredInfoType(context.Context, *CreateStoredInfoTypeRequest) (*StoredInfoType, error)
	// Updates the stored infoType by creating a new version. The existing version
	// will continue to be used until the new version is ready.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	UpdateStoredInfoType(context.Context, *UpdateStoredInfoTypeRequest) (*StoredInfoType, error)
	// Gets a stored infoType.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	GetStoredInfoType(context.Context, *GetStoredInfoTypeRequest) (*StoredInfoType, error)
	// Lists stored infoTypes.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	ListStoredInfoTypes(context.Context, *ListStoredInfoTypesRequest) (*ListStoredInfoTypesResponse, error)
	// Deletes a stored infoType.
	// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
	// learn more.
	DeleteStoredInfoType(context.Context, *DeleteStoredInfoTypeRequest) (*emptypb.Empty, error)
	// Inspect hybrid content and store findings to a job.
	// To review the findings inspect the job. Inspection will occur
	// asynchronously.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridInspectDlpJob(context.Context, *HybridInspectDlpJobRequest) (*HybridInspectResponse, error)
	// Finish a running hybrid DlpJob. Triggers the finalization steps and running
	// of any enabled actions that have not yet run.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	FinishDlpJob(context.Context, *FinishDlpJobRequest) (*emptypb.Empty, error)
}

// UnimplementedDlpServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDlpServiceServer struct {
}

func (*UnimplementedDlpServiceServer) InspectContent(context.Context, *InspectContentRequest) (*InspectContentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method InspectContent not implemented")
}
func (*UnimplementedDlpServiceServer) RedactImage(context.Context, *RedactImageRequest) (*RedactImageResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RedactImage not implemented")
}
func (*UnimplementedDlpServiceServer) DeidentifyContent(context.Context, *DeidentifyContentRequest) (*DeidentifyContentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeidentifyContent not implemented")
}
func (*UnimplementedDlpServiceServer) ReidentifyContent(context.Context, *ReidentifyContentRequest) (*ReidentifyContentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReidentifyContent not implemented")
}
func (*UnimplementedDlpServiceServer) ListInfoTypes(context.Context, *ListInfoTypesRequest) (*ListInfoTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListInfoTypes not implemented")
}
func (*UnimplementedDlpServiceServer) CreateInspectTemplate(context.Context, *CreateInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateInspectTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) UpdateInspectTemplate(context.Context, *UpdateInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateInspectTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) GetInspectTemplate(context.Context, *GetInspectTemplateRequest) (*InspectTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetInspectTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) ListInspectTemplates(context.Context, *ListInspectTemplatesRequest) (*ListInspectTemplatesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListInspectTemplates not implemented")
}
func (*UnimplementedDlpServiceServer) DeleteInspectTemplate(context.Context, *DeleteInspectTemplateRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteInspectTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) CreateDeidentifyTemplate(context.Context, *CreateDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDeidentifyTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) UpdateDeidentifyTemplate(context.Context, *UpdateDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDeidentifyTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) GetDeidentifyTemplate(context.Context, *GetDeidentifyTemplateRequest) (*DeidentifyTemplate, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDeidentifyTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) ListDeidentifyTemplates(context.Context, *ListDeidentifyTemplatesRequest) (*ListDeidentifyTemplatesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDeidentifyTemplates not implemented")
}
func (*UnimplementedDlpServiceServer) DeleteDeidentifyTemplate(context.Context, *DeleteDeidentifyTemplateRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDeidentifyTemplate not implemented")
}
func (*UnimplementedDlpServiceServer) CreateJobTrigger(context.Context, *CreateJobTriggerRequest) (*JobTrigger, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) UpdateJobTrigger(context.Context, *UpdateJobTriggerRequest) (*JobTrigger, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) HybridInspectJobTrigger(context.Context, *HybridInspectJobTriggerRequest) (*HybridInspectResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method HybridInspectJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) GetJobTrigger(context.Context, *GetJobTriggerRequest) (*JobTrigger, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) ListJobTriggers(context.Context, *ListJobTriggersRequest) (*ListJobTriggersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListJobTriggers not implemented")
}
func (*UnimplementedDlpServiceServer) DeleteJobTrigger(context.Context, *DeleteJobTriggerRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) ActivateJobTrigger(context.Context, *ActivateJobTriggerRequest) (*DlpJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ActivateJobTrigger not implemented")
}
func (*UnimplementedDlpServiceServer) CreateDlpJob(context.Context, *CreateDlpJobRequest) (*DlpJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDlpJob not implemented")
}
func (*UnimplementedDlpServiceServer) ListDlpJobs(context.Context, *ListDlpJobsRequest) (*ListDlpJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDlpJobs not implemented")
}
func (*UnimplementedDlpServiceServer) GetDlpJob(context.Context, *GetDlpJobRequest) (*DlpJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDlpJob not implemented")
}
func (*UnimplementedDlpServiceServer) DeleteDlpJob(context.Context, *DeleteDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDlpJob not implemented")
}
func (*UnimplementedDlpServiceServer) CancelDlpJob(context.Context, *CancelDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelDlpJob not implemented")
}
func (*UnimplementedDlpServiceServer) CreateStoredInfoType(context.Context, *CreateStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateStoredInfoType not implemented")
}
func (*UnimplementedDlpServiceServer) UpdateStoredInfoType(context.Context, *UpdateStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateStoredInfoType not implemented")
}
func (*UnimplementedDlpServiceServer) GetStoredInfoType(context.Context, *GetStoredInfoTypeRequest) (*StoredInfoType, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetStoredInfoType not implemented")
}
func (*UnimplementedDlpServiceServer) ListStoredInfoTypes(context.Context, *ListStoredInfoTypesRequest) (*ListStoredInfoTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListStoredInfoTypes not implemented")
}
func (*UnimplementedDlpServiceServer) DeleteStoredInfoType(context.Context, *DeleteStoredInfoTypeRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteStoredInfoType not implemented")
}
func (*UnimplementedDlpServiceServer) HybridInspectDlpJob(context.Context, *HybridInspectDlpJobRequest) (*HybridInspectResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method HybridInspectDlpJob not implemented")
}
func (*UnimplementedDlpServiceServer) FinishDlpJob(context.Context, *FinishDlpJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FinishDlpJob not implemented")
}

func RegisterDlpServiceServer(s *grpc.Server, srv DlpServiceServer) {
	s.RegisterService(&_DlpService_serviceDesc, srv)
}

func _DlpService_InspectContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InspectContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).InspectContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/InspectContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).InspectContent(ctx, req.(*InspectContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_RedactImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RedactImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).RedactImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/RedactImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).RedactImage(ctx, req.(*RedactImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeidentifyContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeidentifyContent(ctx, req.(*DeidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ReidentifyContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReidentifyContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ReidentifyContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ReidentifyContent(ctx, req.(*ReidentifyContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListInfoTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInfoTypes(ctx, req.(*ListInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CreateInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateInspectTemplate(ctx, req.(*CreateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/UpdateInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateInspectTemplate(ctx, req.(*UpdateInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/GetInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetInspectTemplate(ctx, req.(*GetInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListInspectTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInspectTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListInspectTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListInspectTemplates(ctx, req.(*ListInspectTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteInspectTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInspectTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeleteInspectTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteInspectTemplate(ctx, req.(*DeleteInspectTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CreateDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDeidentifyTemplate(ctx, req.(*CreateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/UpdateDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateDeidentifyTemplate(ctx, req.(*UpdateDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/GetDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDeidentifyTemplate(ctx, req.(*GetDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDeidentifyTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeidentifyTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListDeidentifyTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDeidentifyTemplates(ctx, req.(*ListDeidentifyTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDeidentifyTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeidentifyTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeleteDeidentifyTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDeidentifyTemplate(ctx, req.(*DeleteDeidentifyTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CreateJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateJobTrigger(ctx, req.(*CreateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/UpdateJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateJobTrigger(ctx, req.(*UpdateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_HybridInspectJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HybridInspectJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).HybridInspectJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/HybridInspectJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).HybridInspectJobTrigger(ctx, req.(*HybridInspectJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/GetJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetJobTrigger(ctx, req.(*GetJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListJobTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListJobTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListJobTriggers(ctx, req.(*ListJobTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeleteJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteJobTrigger(ctx, req.(*DeleteJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ActivateJobTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateJobTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ActivateJobTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ActivateJobTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ActivateJobTrigger(ctx, req.(*ActivateJobTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CreateDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateDlpJob(ctx, req.(*CreateDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListDlpJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDlpJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListDlpJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListDlpJobs(ctx, req.(*ListDlpJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/GetDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetDlpJob(ctx, req.(*GetDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeleteDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteDlpJob(ctx, req.(*DeleteDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CancelDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CancelDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CancelDlpJob(ctx, req.(*CancelDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_CreateStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).CreateStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/CreateStoredInfoType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).CreateStoredInfoType(ctx, req.(*CreateStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_UpdateStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).UpdateStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/UpdateStoredInfoType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).UpdateStoredInfoType(ctx, req.(*UpdateStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_GetStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).GetStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/GetStoredInfoType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).GetStoredInfoType(ctx, req.(*GetStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_ListStoredInfoTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStoredInfoTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).ListStoredInfoTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/ListStoredInfoTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).ListStoredInfoTypes(ctx, req.(*ListStoredInfoTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_DeleteStoredInfoType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStoredInfoTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).DeleteStoredInfoType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/DeleteStoredInfoType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).DeleteStoredInfoType(ctx, req.(*DeleteStoredInfoTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_HybridInspectDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HybridInspectDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).HybridInspectDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/HybridInspectDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).HybridInspectDlpJob(ctx, req.(*HybridInspectDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DlpService_FinishDlpJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinishDlpJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DlpServiceServer).FinishDlpJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.privacy.dlp.v2.DlpService/FinishDlpJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DlpServiceServer).FinishDlpJob(ctx, req.(*FinishDlpJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DlpService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.privacy.dlp.v2.DlpService",
	HandlerType: (*DlpServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InspectContent",
			Handler:    _DlpService_InspectContent_Handler,
		},
		{
			MethodName: "RedactImage",
			Handler:    _DlpService_RedactImage_Handler,
		},
		{
			MethodName: "DeidentifyContent",
			Handler:    _DlpService_DeidentifyContent_Handler,
		},
		{
			MethodName: "ReidentifyContent",
			Handler:    _DlpService_ReidentifyContent_Handler,
		},
		{
			MethodName: "ListInfoTypes",
			Handler:    _DlpService_ListInfoTypes_Handler,
		},
		{
			MethodName: "CreateInspectTemplate",
			Handler:    _DlpService_CreateInspectTemplate_Handler,
		},
		{
			MethodName: "UpdateInspectTemplate",
			Handler:    _DlpService_UpdateInspectTemplate_Handler,
		},
		{
			MethodName: "GetInspectTemplate",
			Handler:    _DlpService_GetInspectTemplate_Handler,
		},
		{
			MethodName: "ListInspectTemplates",
			Handler:    _DlpService_ListInspectTemplates_Handler,
		},
		{
			MethodName: "DeleteInspectTemplate",
			Handler:    _DlpService_DeleteInspectTemplate_Handler,
		},
		{
			MethodName: "CreateDeidentifyTemplate",
			Handler:    _DlpService_CreateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "UpdateDeidentifyTemplate",
			Handler:    _DlpService_UpdateDeidentifyTemplate_Handler,
		},
		{
			MethodName: "GetDeidentifyTemplate",
			Handler:    _DlpService_GetDeidentifyTemplate_Handler,
		},
		{
			MethodName: "ListDeidentifyTemplates",
			Handler:    _DlpService_ListDeidentifyTemplates_Handler,
		},
		{
			MethodName: "DeleteDeidentifyTemplate",
			Handler:    _DlpService_DeleteDeidentifyTemplate_Handler,
		},
		{
			MethodName: "CreateJobTrigger",
			Handler:    _DlpService_CreateJobTrigger_Handler,
		},
		{
			MethodName: "UpdateJobTrigger",
			Handler:    _DlpService_UpdateJobTrigger_Handler,
		},
		{
			MethodName: "HybridInspectJobTrigger",
			Handler:    _DlpService_HybridInspectJobTrigger_Handler,
		},
		{
			MethodName: "GetJobTrigger",
			Handler:    _DlpService_GetJobTrigger_Handler,
		},
		{
			MethodName: "ListJobTriggers",
			Handler:    _DlpService_ListJobTriggers_Handler,
		},
		{
			MethodName: "DeleteJobTrigger",
			Handler:    _DlpService_DeleteJobTrigger_Handler,
		},
		{
			MethodName: "ActivateJobTrigger",
			Handler:    _DlpService_ActivateJobTrigger_Handler,
		},
		{
			MethodName: "CreateDlpJob",
			Handler:    _DlpService_CreateDlpJob_Handler,
		},
		{
			MethodName: "ListDlpJobs",
			Handler:    _DlpService_ListDlpJobs_Handler,
		},
		{
			MethodName: "GetDlpJob",
			Handler:    _DlpService_GetDlpJob_Handler,
		},
		{
			MethodName: "DeleteDlpJob",
			Handler:    _DlpService_DeleteDlpJob_Handler,
		},
		{
			MethodName: "CancelDlpJob",
			Handler:    _DlpService_CancelDlpJob_Handler,
		},
		{
			MethodName: "CreateStoredInfoType",
			Handler:    _DlpService_CreateStoredInfoType_Handler,
		},
		{
			MethodName: "UpdateStoredInfoType",
			Handler:    _DlpService_UpdateStoredInfoType_Handler,
		},
		{
			MethodName: "GetStoredInfoType",
			Handler:    _DlpService_GetStoredInfoType_Handler,
		},
		{
			MethodName: "ListStoredInfoTypes",
			Handler:    _DlpService_ListStoredInfoTypes_Handler,
		},
		{
			MethodName: "DeleteStoredInfoType",
			Handler:    _DlpService_DeleteStoredInfoType_Handler,
		},
		{
			MethodName: "HybridInspectDlpJob",
			Handler:    _DlpService_HybridInspectDlpJob_Handler,
		},
		{
			MethodName: "FinishDlpJob",
			Handler:    _DlpService_FinishDlpJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/privacy/dlp/v2/dlp.proto",
}
