// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v4/services/recommendation_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v4/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v4/enums"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v4/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [RecommendationService.GetRecommendation][google.ads.googleads.v4.services.RecommendationService.GetRecommendation].
type GetRecommendationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the recommendation to fetch.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetRecommendationRequest) Reset() {
	*x = GetRecommendationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRecommendationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRecommendationRequest) ProtoMessage() {}

func (x *GetRecommendationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRecommendationRequest.ProtoReflect.Descriptor instead.
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetRecommendationRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v4.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to apply recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*ApplyRecommendationOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried
	// out as a transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
}

func (x *ApplyRecommendationRequest) Reset() {
	*x = ApplyRecommendationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationRequest) ProtoMessage() {}

func (x *ApplyRecommendationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationRequest.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{1}
}

func (x *ApplyRecommendationRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *ApplyRecommendationRequest) GetOperations() []*ApplyRecommendationOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ApplyRecommendationRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

// Information about the operation to apply a recommendation and any parameters
// to customize it.
type ApplyRecommendationOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the recommendation to apply.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Parameters to use when applying the recommendation.
	//
	// Types that are assignable to ApplyParameters:
	//	*ApplyRecommendationOperation_CampaignBudget
	//	*ApplyRecommendationOperation_TextAd
	//	*ApplyRecommendationOperation_Keyword
	//	*ApplyRecommendationOperation_TargetCpaOptIn
	//	*ApplyRecommendationOperation_CalloutExtension
	//	*ApplyRecommendationOperation_CallExtension
	//	*ApplyRecommendationOperation_SitelinkExtension
	//	*ApplyRecommendationOperation_MoveUnusedBudget
	ApplyParameters isApplyRecommendationOperation_ApplyParameters `protobuf_oneof:"apply_parameters"`
}

func (x *ApplyRecommendationOperation) Reset() {
	*x = ApplyRecommendationOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation) ProtoMessage() {}

func (x *ApplyRecommendationOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2}
}

func (x *ApplyRecommendationOperation) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (m *ApplyRecommendationOperation) GetApplyParameters() isApplyRecommendationOperation_ApplyParameters {
	if m != nil {
		return m.ApplyParameters
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetCampaignBudget() *ApplyRecommendationOperation_CampaignBudgetParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_CampaignBudget); ok {
		return x.CampaignBudget
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetTextAd() *ApplyRecommendationOperation_TextAdParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetKeyword() *ApplyRecommendationOperation_KeywordParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetTargetCpaOptIn() *ApplyRecommendationOperation_TargetCpaOptInParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_TargetCpaOptIn); ok {
		return x.TargetCpaOptIn
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetCalloutExtension() *ApplyRecommendationOperation_CalloutExtensionParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_CalloutExtension); ok {
		return x.CalloutExtension
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetCallExtension() *ApplyRecommendationOperation_CallExtensionParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_CallExtension); ok {
		return x.CallExtension
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetSitelinkExtension() *ApplyRecommendationOperation_SitelinkExtensionParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_SitelinkExtension); ok {
		return x.SitelinkExtension
	}
	return nil
}

func (x *ApplyRecommendationOperation) GetMoveUnusedBudget() *ApplyRecommendationOperation_MoveUnusedBudgetParameters {
	if x, ok := x.GetApplyParameters().(*ApplyRecommendationOperation_MoveUnusedBudget); ok {
		return x.MoveUnusedBudget
	}
	return nil
}

type isApplyRecommendationOperation_ApplyParameters interface {
	isApplyRecommendationOperation_ApplyParameters()
}

type ApplyRecommendationOperation_CampaignBudget struct {
	// Optional parameters to use when applying a campaign budget
	// recommendation.
	CampaignBudget *ApplyRecommendationOperation_CampaignBudgetParameters `protobuf:"bytes,2,opt,name=campaign_budget,json=campaignBudget,proto3,oneof"`
}

type ApplyRecommendationOperation_TextAd struct {
	// Optional parameters to use when applying a text ad recommendation.
	TextAd *ApplyRecommendationOperation_TextAdParameters `protobuf:"bytes,3,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type ApplyRecommendationOperation_Keyword struct {
	// Optional parameters to use when applying keyword recommendation.
	Keyword *ApplyRecommendationOperation_KeywordParameters `protobuf:"bytes,4,opt,name=keyword,proto3,oneof"`
}

type ApplyRecommendationOperation_TargetCpaOptIn struct {
	// Optional parameters to use when applying target CPA opt-in
	// recommendation.
	TargetCpaOptIn *ApplyRecommendationOperation_TargetCpaOptInParameters `protobuf:"bytes,5,opt,name=target_cpa_opt_in,json=targetCpaOptIn,proto3,oneof"`
}

type ApplyRecommendationOperation_CalloutExtension struct {
	// Parameters to use when applying callout extension recommendation.
	CalloutExtension *ApplyRecommendationOperation_CalloutExtensionParameters `protobuf:"bytes,6,opt,name=callout_extension,json=calloutExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_CallExtension struct {
	// Parameters to use when applying call extension recommendation.
	CallExtension *ApplyRecommendationOperation_CallExtensionParameters `protobuf:"bytes,7,opt,name=call_extension,json=callExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_SitelinkExtension struct {
	// Parameters to use when applying sitelink extension recommendation.
	SitelinkExtension *ApplyRecommendationOperation_SitelinkExtensionParameters `protobuf:"bytes,8,opt,name=sitelink_extension,json=sitelinkExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_MoveUnusedBudget struct {
	// Parameters to use when applying move unused budget recommendation.
	MoveUnusedBudget *ApplyRecommendationOperation_MoveUnusedBudgetParameters `protobuf:"bytes,9,opt,name=move_unused_budget,json=moveUnusedBudget,proto3,oneof"`
}

func (*ApplyRecommendationOperation_CampaignBudget) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TextAd) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_Keyword) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TargetCpaOptIn) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_CalloutExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_CallExtension) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_SitelinkExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_MoveUnusedBudget) isApplyRecommendationOperation_ApplyParameters() {
}

// Response message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v4.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of operations to apply recommendations.
	Results []*ApplyRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
}

func (x *ApplyRecommendationResponse) Reset() {
	*x = ApplyRecommendationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationResponse) ProtoMessage() {}

func (x *ApplyRecommendationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationResponse.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{3}
}

func (x *ApplyRecommendationResponse) GetResults() []*ApplyRecommendationResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *ApplyRecommendationResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

// The result of applying a recommendation.
type ApplyRecommendationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned for successful applies.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *ApplyRecommendationResult) Reset() {
	*x = ApplyRecommendationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationResult) ProtoMessage() {}

func (x *ApplyRecommendationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationResult.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{4}
}

func (x *ApplyRecommendationResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.DismissRecommendation][google.ads.googleads.v4.services.RecommendationService.DismissRecommendation].
type DismissRecommendationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to dismiss recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*DismissRecommendationRequest_DismissRecommendationOperation `protobuf:"bytes,3,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried in a
	// single transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,2,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
}

func (x *DismissRecommendationRequest) Reset() {
	*x = DismissRecommendationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissRecommendationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissRecommendationRequest) ProtoMessage() {}

func (x *DismissRecommendationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissRecommendationRequest.ProtoReflect.Descriptor instead.
func (*DismissRecommendationRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{5}
}

func (x *DismissRecommendationRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *DismissRecommendationRequest) GetOperations() []*DismissRecommendationRequest_DismissRecommendationOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *DismissRecommendationRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

// Response message for [RecommendationService.DismissRecommendation][google.ads.googleads.v4.services.RecommendationService.DismissRecommendation].
type DismissRecommendationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of operations to dismiss recommendations.
	Results []*DismissRecommendationResponse_DismissRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
}

func (x *DismissRecommendationResponse) Reset() {
	*x = DismissRecommendationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissRecommendationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissRecommendationResponse) ProtoMessage() {}

func (x *DismissRecommendationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissRecommendationResponse.ProtoReflect.Descriptor instead.
func (*DismissRecommendationResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{6}
}

func (x *DismissRecommendationResponse) GetResults() []*DismissRecommendationResponse_DismissRecommendationResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *DismissRecommendationResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

// Parameters to use when applying a campaign budget recommendation.
type ApplyRecommendationOperation_CampaignBudgetParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New budget amount to set for target budget resource. This is a required
	// field.
	NewBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=new_budget_amount_micros,json=newBudgetAmountMicros,proto3" json:"new_budget_amount_micros,omitempty"`
}

func (x *ApplyRecommendationOperation_CampaignBudgetParameters) Reset() {
	*x = ApplyRecommendationOperation_CampaignBudgetParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_CampaignBudgetParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_CampaignBudgetParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_CampaignBudgetParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_CampaignBudgetParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_CampaignBudgetParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ApplyRecommendationOperation_CampaignBudgetParameters) GetNewBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.NewBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying a text ad recommendation.
type ApplyRecommendationOperation_TextAdParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New ad to add to recommended ad group. All necessary fields need to be
	// set in this message. This is a required field.
	Ad *resources.Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
}

func (x *ApplyRecommendationOperation_TextAdParameters) Reset() {
	*x = ApplyRecommendationOperation_TextAdParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_TextAdParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_TextAdParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_TextAdParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_TextAdParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_TextAdParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ApplyRecommendationOperation_TextAdParameters) GetAd() *resources.Ad {
	if x != nil {
		return x.Ad
	}
	return nil
}

// Parameters to use when applying keyword recommendation.
type ApplyRecommendationOperation_KeywordParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ad group resource to add keyword to. This is a required field.
	AdGroup *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The match type of the keyword. This is a required field.
	MatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v4.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	// Optional, CPC bid to set for the keyword. If not set, keyword will use
	// bid based on bidding strategy used by target ad group.
	CpcBidMicros *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
}

func (x *ApplyRecommendationOperation_KeywordParameters) Reset() {
	*x = ApplyRecommendationOperation_KeywordParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_KeywordParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_KeywordParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_KeywordParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_KeywordParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_KeywordParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ApplyRecommendationOperation_KeywordParameters) GetAdGroup() *wrapperspb.StringValue {
	if x != nil {
		return x.AdGroup
	}
	return nil
}

func (x *ApplyRecommendationOperation_KeywordParameters) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if x != nil {
		return x.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

func (x *ApplyRecommendationOperation_KeywordParameters) GetCpcBidMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.CpcBidMicros
	}
	return nil
}

// Parameters to use when applying Target CPA recommendation.
type ApplyRecommendationOperation_TargetCpaOptInParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average CPA to use for Target CPA bidding strategy. This is a required
	// field.
	TargetCpaMicros *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Optional, budget amount to set for the campaign.
	NewCampaignBudgetAmountMicros *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=new_campaign_budget_amount_micros,json=newCampaignBudgetAmountMicros,proto3" json:"new_campaign_budget_amount_micros,omitempty"`
}

func (x *ApplyRecommendationOperation_TargetCpaOptInParameters) Reset() {
	*x = ApplyRecommendationOperation_TargetCpaOptInParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_TargetCpaOptInParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_TargetCpaOptInParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_TargetCpaOptInParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_TargetCpaOptInParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 3}
}

func (x *ApplyRecommendationOperation_TargetCpaOptInParameters) GetTargetCpaMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.TargetCpaMicros
	}
	return nil
}

func (x *ApplyRecommendationOperation_TargetCpaOptInParameters) GetNewCampaignBudgetAmountMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.NewCampaignBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying callout extension recommendation.
type ApplyRecommendationOperation_CalloutExtensionParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Callout extensions to be added. This is a required field.
	CalloutExtensions []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=callout_extensions,json=calloutExtensions,proto3" json:"callout_extensions,omitempty"`
}

func (x *ApplyRecommendationOperation_CalloutExtensionParameters) Reset() {
	*x = ApplyRecommendationOperation_CalloutExtensionParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_CalloutExtensionParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_CalloutExtensionParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_CalloutExtensionParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_CalloutExtensionParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_CalloutExtensionParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 4}
}

func (x *ApplyRecommendationOperation_CalloutExtensionParameters) GetCalloutExtensions() []*common.CalloutFeedItem {
	if x != nil {
		return x.CalloutExtensions
	}
	return nil
}

// Parameters to use when applying call extension recommendation.
type ApplyRecommendationOperation_CallExtensionParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Call extensions to be added. This is a required field.
	CallExtensions []*common.CallFeedItem `protobuf:"bytes,1,rep,name=call_extensions,json=callExtensions,proto3" json:"call_extensions,omitempty"`
}

func (x *ApplyRecommendationOperation_CallExtensionParameters) Reset() {
	*x = ApplyRecommendationOperation_CallExtensionParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_CallExtensionParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_CallExtensionParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_CallExtensionParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_CallExtensionParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_CallExtensionParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 5}
}

func (x *ApplyRecommendationOperation_CallExtensionParameters) GetCallExtensions() []*common.CallFeedItem {
	if x != nil {
		return x.CallExtensions
	}
	return nil
}

// Parameters to use when applying sitelink extension recommendation.
type ApplyRecommendationOperation_SitelinkExtensionParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sitelink extensions to be added. This is a required field.
	SitelinkExtensions []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=sitelink_extensions,json=sitelinkExtensions,proto3" json:"sitelink_extensions,omitempty"`
}

func (x *ApplyRecommendationOperation_SitelinkExtensionParameters) Reset() {
	*x = ApplyRecommendationOperation_SitelinkExtensionParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_SitelinkExtensionParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_SitelinkExtensionParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_SitelinkExtensionParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_SitelinkExtensionParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_SitelinkExtensionParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 6}
}

func (x *ApplyRecommendationOperation_SitelinkExtensionParameters) GetSitelinkExtensions() []*common.SitelinkFeedItem {
	if x != nil {
		return x.SitelinkExtensions
	}
	return nil
}

// Parameters to use when applying move unused budget recommendation.
type ApplyRecommendationOperation_MoveUnusedBudgetParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Budget amount to move from excess budget to constrained budget. This is
	// a required field.
	BudgetMicrosToMove *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=budget_micros_to_move,json=budgetMicrosToMove,proto3" json:"budget_micros_to_move,omitempty"`
}

func (x *ApplyRecommendationOperation_MoveUnusedBudgetParameters) Reset() {
	*x = ApplyRecommendationOperation_MoveUnusedBudgetParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyRecommendationOperation_MoveUnusedBudgetParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) ProtoMessage() {}

func (x *ApplyRecommendationOperation_MoveUnusedBudgetParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyRecommendationOperation_MoveUnusedBudgetParameters.ProtoReflect.Descriptor instead.
func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{2, 7}
}

func (x *ApplyRecommendationOperation_MoveUnusedBudgetParameters) GetBudgetMicrosToMove() *wrapperspb.Int64Value {
	if x != nil {
		return x.BudgetMicrosToMove
	}
	return nil
}

// Operation to dismiss a single recommendation identified by resource_name.
type DismissRecommendationRequest_DismissRecommendationOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the recommendation to dismiss.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *DismissRecommendationRequest_DismissRecommendationOperation) Reset() {
	*x = DismissRecommendationRequest_DismissRecommendationOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissRecommendationRequest_DismissRecommendationOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissRecommendationRequest_DismissRecommendationOperation) ProtoMessage() {}

func (x *DismissRecommendationRequest_DismissRecommendationOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissRecommendationRequest_DismissRecommendationOperation.ProtoReflect.Descriptor instead.
func (*DismissRecommendationRequest_DismissRecommendationOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *DismissRecommendationRequest_DismissRecommendationOperation) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// The result of dismissing a recommendation.
type DismissRecommendationResponse_DismissRecommendationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned for successful dismissals.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *DismissRecommendationResponse_DismissRecommendationResult) Reset() {
	*x = DismissRecommendationResponse_DismissRecommendationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissRecommendationResponse_DismissRecommendationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissRecommendationResponse_DismissRecommendationResult) ProtoMessage() {}

func (x *DismissRecommendationResponse_DismissRecommendationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissRecommendationResponse_DismissRecommendationResult.ProtoReflect.Descriptor instead.
func (*DismissRecommendationResponse_DismissRecommendationResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *DismissRecommendationResponse_DismissRecommendationResult) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

var File_google_ads_googleads_v4_services_recommendation_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v4_services_recommendation_service_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x34, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x70, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a,
	0x1a, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x63, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x22,
	0xc5, 0x11, 0x0a, 0x1c, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x6a, 0x0a, 0x07, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x78, 0x74,
	0x41, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x06,
	0x74, 0x65, 0x78, 0x74, 0x41, 0x64, 0x12, 0x6c, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x07, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x84, 0x01, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x70, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x12, 0x88, 0x01, 0x0a, 0x11,
	0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x48, 0x00, 0x52, 0x10, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x0e, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x61, 0x6c, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x61, 0x6c, 0x6c, 0x45, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x8b, 0x01, 0x0a, 0x12, 0x73, 0x69, 0x74, 0x65,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x48, 0x00, 0x52, 0x11, 0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x89, 0x01, 0x0a, 0x12, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x75,
	0x6e, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52,
	0x10, 0x6d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x1a, 0x70, 0x0a, 0x18, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x54, 0x0a,
	0x18, 0x6e, 0x65, 0x77, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x6e, 0x65,
	0x77, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x1a, 0x49, 0x0a, 0x10, 0x54, 0x65, 0x78, 0x74, 0x41, 0x64, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x02, 0x61, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x52, 0x02, 0x61, 0x64, 0x1a, 0xf4,
	0x01, 0x0a, 0x11, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a, 0x08, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x63, 0x0a,
	0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x41, 0x0a, 0x0e, 0x63, 0x70, 0x63, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x70, 0x63, 0x42, 0x69, 0x64, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x1a, 0xca, 0x01, 0x0a, 0x18, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x43, 0x70, 0x61, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x47, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61,
	0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x70, 0x61, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x65, 0x0a, 0x21, 0x6e,
	0x65, 0x77, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x1d, 0x6e, 0x65, 0x77, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x1a, 0x7c, 0x0a, 0x1a, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x5e, 0x0a, 0x12, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x11, 0x63,
	0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x70, 0x0a, 0x17, 0x43, 0x61, 0x6c, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x0f, 0x63,
	0x61, 0x6c, 0x6c, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74,
	0x65, 0x6d, 0x52, 0x0e, 0x63, 0x61, 0x6c, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x80, 0x01, 0x0a, 0x1b, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65,
	0x6d, 0x52, 0x12, 0x73, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x6c, 0x0a, 0x1a, 0x4d, 0x6f, 0x76, 0x65, 0x55, 0x6e, 0x75,
	0x73, 0x65, 0x64, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x4e, 0x0a, 0x15, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x12, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x54, 0x6f, 0x4d,
	0x6f, 0x76, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x1b, 0x41, 0x70, 0x70, 0x6c,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x46,
	0x0a, 0x15, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x40, 0x0a, 0x19, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x02, 0x0a, 0x1c, 0x44, 0x69, 0x73,
	0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x82, 0x01, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x1a, 0x45, 0x0a,
	0x1e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69,
	0x73, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x46, 0x0a,
	0x15, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x42, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0xe8, 0x05, 0x0a, 0x15, 0x52, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x12, 0x31, 0x2f, 0x76, 0x34, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xeb, 0x01, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x22, 0x33, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f,
	0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x61, 0x70, 0x70, 0x6c, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0xf3, 0x01, 0x0a, 0x15, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x44,
	0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x44,
	0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x3d, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x16, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x81, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x34, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x1a, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x34, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x20, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x2e, 0x56, 0x34, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xca, 0x02,
	0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x34, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a,
	0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x34, 0x3a, 0x3a,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescData = file_google_ads_googleads_v4_services_recommendation_service_proto_rawDesc
)

func file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v4_services_recommendation_service_proto_rawDescData
}

var file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_ads_googleads_v4_services_recommendation_service_proto_goTypes = []interface{}{
	(*GetRecommendationRequest)(nil),                                    // 0: google.ads.googleads.v4.services.GetRecommendationRequest
	(*ApplyRecommendationRequest)(nil),                                  // 1: google.ads.googleads.v4.services.ApplyRecommendationRequest
	(*ApplyRecommendationOperation)(nil),                                // 2: google.ads.googleads.v4.services.ApplyRecommendationOperation
	(*ApplyRecommendationResponse)(nil),                                 // 3: google.ads.googleads.v4.services.ApplyRecommendationResponse
	(*ApplyRecommendationResult)(nil),                                   // 4: google.ads.googleads.v4.services.ApplyRecommendationResult
	(*DismissRecommendationRequest)(nil),                                // 5: google.ads.googleads.v4.services.DismissRecommendationRequest
	(*DismissRecommendationResponse)(nil),                               // 6: google.ads.googleads.v4.services.DismissRecommendationResponse
	(*ApplyRecommendationOperation_CampaignBudgetParameters)(nil),       // 7: google.ads.googleads.v4.services.ApplyRecommendationOperation.CampaignBudgetParameters
	(*ApplyRecommendationOperation_TextAdParameters)(nil),               // 8: google.ads.googleads.v4.services.ApplyRecommendationOperation.TextAdParameters
	(*ApplyRecommendationOperation_KeywordParameters)(nil),              // 9: google.ads.googleads.v4.services.ApplyRecommendationOperation.KeywordParameters
	(*ApplyRecommendationOperation_TargetCpaOptInParameters)(nil),       // 10: google.ads.googleads.v4.services.ApplyRecommendationOperation.TargetCpaOptInParameters
	(*ApplyRecommendationOperation_CalloutExtensionParameters)(nil),     // 11: google.ads.googleads.v4.services.ApplyRecommendationOperation.CalloutExtensionParameters
	(*ApplyRecommendationOperation_CallExtensionParameters)(nil),        // 12: google.ads.googleads.v4.services.ApplyRecommendationOperation.CallExtensionParameters
	(*ApplyRecommendationOperation_SitelinkExtensionParameters)(nil),    // 13: google.ads.googleads.v4.services.ApplyRecommendationOperation.SitelinkExtensionParameters
	(*ApplyRecommendationOperation_MoveUnusedBudgetParameters)(nil),     // 14: google.ads.googleads.v4.services.ApplyRecommendationOperation.MoveUnusedBudgetParameters
	(*DismissRecommendationRequest_DismissRecommendationOperation)(nil), // 15: google.ads.googleads.v4.services.DismissRecommendationRequest.DismissRecommendationOperation
	(*DismissRecommendationResponse_DismissRecommendationResult)(nil),   // 16: google.ads.googleads.v4.services.DismissRecommendationResponse.DismissRecommendationResult
	(*status.Status)(nil),                                               // 17: google.rpc.Status
	(*wrapperspb.Int64Value)(nil),                                       // 18: google.protobuf.Int64Value
	(*resources.Ad)(nil),                                                // 19: google.ads.googleads.v4.resources.Ad
	(*wrapperspb.StringValue)(nil),                                      // 20: google.protobuf.StringValue
	(enums.KeywordMatchTypeEnum_KeywordMatchType)(0),                    // 21: google.ads.googleads.v4.enums.KeywordMatchTypeEnum.KeywordMatchType
	(*common.CalloutFeedItem)(nil),                                      // 22: google.ads.googleads.v4.common.CalloutFeedItem
	(*common.CallFeedItem)(nil),                                         // 23: google.ads.googleads.v4.common.CallFeedItem
	(*common.SitelinkFeedItem)(nil),                                     // 24: google.ads.googleads.v4.common.SitelinkFeedItem
	(*resources.Recommendation)(nil),                                    // 25: google.ads.googleads.v4.resources.Recommendation
}
var file_google_ads_googleads_v4_services_recommendation_service_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v4.services.ApplyRecommendationRequest.operations:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation
	7,  // 1: google.ads.googleads.v4.services.ApplyRecommendationOperation.campaign_budget:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.CampaignBudgetParameters
	8,  // 2: google.ads.googleads.v4.services.ApplyRecommendationOperation.text_ad:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.TextAdParameters
	9,  // 3: google.ads.googleads.v4.services.ApplyRecommendationOperation.keyword:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.KeywordParameters
	10, // 4: google.ads.googleads.v4.services.ApplyRecommendationOperation.target_cpa_opt_in:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.TargetCpaOptInParameters
	11, // 5: google.ads.googleads.v4.services.ApplyRecommendationOperation.callout_extension:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.CalloutExtensionParameters
	12, // 6: google.ads.googleads.v4.services.ApplyRecommendationOperation.call_extension:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.CallExtensionParameters
	13, // 7: google.ads.googleads.v4.services.ApplyRecommendationOperation.sitelink_extension:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.SitelinkExtensionParameters
	14, // 8: google.ads.googleads.v4.services.ApplyRecommendationOperation.move_unused_budget:type_name -> google.ads.googleads.v4.services.ApplyRecommendationOperation.MoveUnusedBudgetParameters
	4,  // 9: google.ads.googleads.v4.services.ApplyRecommendationResponse.results:type_name -> google.ads.googleads.v4.services.ApplyRecommendationResult
	17, // 10: google.ads.googleads.v4.services.ApplyRecommendationResponse.partial_failure_error:type_name -> google.rpc.Status
	15, // 11: google.ads.googleads.v4.services.DismissRecommendationRequest.operations:type_name -> google.ads.googleads.v4.services.DismissRecommendationRequest.DismissRecommendationOperation
	16, // 12: google.ads.googleads.v4.services.DismissRecommendationResponse.results:type_name -> google.ads.googleads.v4.services.DismissRecommendationResponse.DismissRecommendationResult
	17, // 13: google.ads.googleads.v4.services.DismissRecommendationResponse.partial_failure_error:type_name -> google.rpc.Status
	18, // 14: google.ads.googleads.v4.services.ApplyRecommendationOperation.CampaignBudgetParameters.new_budget_amount_micros:type_name -> google.protobuf.Int64Value
	19, // 15: google.ads.googleads.v4.services.ApplyRecommendationOperation.TextAdParameters.ad:type_name -> google.ads.googleads.v4.resources.Ad
	20, // 16: google.ads.googleads.v4.services.ApplyRecommendationOperation.KeywordParameters.ad_group:type_name -> google.protobuf.StringValue
	21, // 17: google.ads.googleads.v4.services.ApplyRecommendationOperation.KeywordParameters.match_type:type_name -> google.ads.googleads.v4.enums.KeywordMatchTypeEnum.KeywordMatchType
	18, // 18: google.ads.googleads.v4.services.ApplyRecommendationOperation.KeywordParameters.cpc_bid_micros:type_name -> google.protobuf.Int64Value
	18, // 19: google.ads.googleads.v4.services.ApplyRecommendationOperation.TargetCpaOptInParameters.target_cpa_micros:type_name -> google.protobuf.Int64Value
	18, // 20: google.ads.googleads.v4.services.ApplyRecommendationOperation.TargetCpaOptInParameters.new_campaign_budget_amount_micros:type_name -> google.protobuf.Int64Value
	22, // 21: google.ads.googleads.v4.services.ApplyRecommendationOperation.CalloutExtensionParameters.callout_extensions:type_name -> google.ads.googleads.v4.common.CalloutFeedItem
	23, // 22: google.ads.googleads.v4.services.ApplyRecommendationOperation.CallExtensionParameters.call_extensions:type_name -> google.ads.googleads.v4.common.CallFeedItem
	24, // 23: google.ads.googleads.v4.services.ApplyRecommendationOperation.SitelinkExtensionParameters.sitelink_extensions:type_name -> google.ads.googleads.v4.common.SitelinkFeedItem
	18, // 24: google.ads.googleads.v4.services.ApplyRecommendationOperation.MoveUnusedBudgetParameters.budget_micros_to_move:type_name -> google.protobuf.Int64Value
	0,  // 25: google.ads.googleads.v4.services.RecommendationService.GetRecommendation:input_type -> google.ads.googleads.v4.services.GetRecommendationRequest
	1,  // 26: google.ads.googleads.v4.services.RecommendationService.ApplyRecommendation:input_type -> google.ads.googleads.v4.services.ApplyRecommendationRequest
	5,  // 27: google.ads.googleads.v4.services.RecommendationService.DismissRecommendation:input_type -> google.ads.googleads.v4.services.DismissRecommendationRequest
	25, // 28: google.ads.googleads.v4.services.RecommendationService.GetRecommendation:output_type -> google.ads.googleads.v4.resources.Recommendation
	3,  // 29: google.ads.googleads.v4.services.RecommendationService.ApplyRecommendation:output_type -> google.ads.googleads.v4.services.ApplyRecommendationResponse
	6,  // 30: google.ads.googleads.v4.services.RecommendationService.DismissRecommendation:output_type -> google.ads.googleads.v4.services.DismissRecommendationResponse
	28, // [28:31] is the sub-list for method output_type
	25, // [25:28] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v4_services_recommendation_service_proto_init() }
func file_google_ads_googleads_v4_services_recommendation_service_proto_init() {
	if File_google_ads_googleads_v4_services_recommendation_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRecommendationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissRecommendationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissRecommendationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_CampaignBudgetParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_TextAdParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_KeywordParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_TargetCpaOptInParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_CalloutExtensionParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_CallExtensionParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_SitelinkExtensionParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyRecommendationOperation_MoveUnusedBudgetParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissRecommendationRequest_DismissRecommendationOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissRecommendationResponse_DismissRecommendationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ApplyRecommendationOperation_CampaignBudget)(nil),
		(*ApplyRecommendationOperation_TextAd)(nil),
		(*ApplyRecommendationOperation_Keyword)(nil),
		(*ApplyRecommendationOperation_TargetCpaOptIn)(nil),
		(*ApplyRecommendationOperation_CalloutExtension)(nil),
		(*ApplyRecommendationOperation_CallExtension)(nil),
		(*ApplyRecommendationOperation_SitelinkExtension)(nil),
		(*ApplyRecommendationOperation_MoveUnusedBudget)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v4_services_recommendation_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v4_services_recommendation_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v4_services_recommendation_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v4_services_recommendation_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v4_services_recommendation_service_proto = out.File
	file_google_ads_googleads_v4_services_recommendation_service_proto_rawDesc = nil
	file_google_ads_googleads_v4_services_recommendation_service_proto_goTypes = nil
	file_google_ads_googleads_v4_services_recommendation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecommendationServiceClient is the client API for RecommendationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommendationServiceClient interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error)
}

type recommendationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecommendationServiceClient(cc grpc.ClientConnInterface) RecommendationServiceClient {
	return &recommendationServiceClient{cc}
}

func (c *recommendationServiceClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error) {
	out := new(resources.Recommendation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v4.services.RecommendationService/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error) {
	out := new(ApplyRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v4.services.RecommendationService/ApplyRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error) {
	out := new(DismissRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v4.services.RecommendationService/DismissRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommendationServiceServer is the server API for RecommendationService service.
type RecommendationServiceServer interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(context.Context, *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(context.Context, *DismissRecommendationRequest) (*DismissRecommendationResponse, error)
}

// UnimplementedRecommendationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRecommendationServiceServer struct {
}

func (*UnimplementedRecommendationServiceServer) GetRecommendation(context.Context, *GetRecommendationRequest) (*resources.Recommendation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (*UnimplementedRecommendationServiceServer) ApplyRecommendation(context.Context, *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ApplyRecommendation not implemented")
}
func (*UnimplementedRecommendationServiceServer) DismissRecommendation(context.Context, *DismissRecommendationRequest) (*DismissRecommendationResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DismissRecommendation not implemented")
}

func RegisterRecommendationServiceServer(s *grpc.Server, srv RecommendationServiceServer) {
	s.RegisterService(&_RecommendationService_serviceDesc, srv)
}

func _RecommendationService_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v4.services.RecommendationService/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_ApplyRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v4.services.RecommendationService/ApplyRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, req.(*ApplyRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_DismissRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v4.services.RecommendationService/DismissRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, req.(*DismissRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecommendationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v4.services.RecommendationService",
	HandlerType: (*RecommendationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRecommendation",
			Handler:    _RecommendationService_GetRecommendation_Handler,
		},
		{
			MethodName: "ApplyRecommendation",
			Handler:    _RecommendationService_ApplyRecommendation_Handler,
		},
		{
			MethodName: "DismissRecommendation",
			Handler:    _RecommendationService_DismissRecommendation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v4/services/recommendation_service.proto",
}
