/* Vaio Brightness gkrellm plugin
 *
 * Includes and typedefs
 *
 * Mike Kershaw <dragorn@nerv-un.net> 2001
 * Strongly based on Volume 0.8 gkrellm plugin headers, by Sjoerd Simons
 *
 */

#include <gkrellm2/gkrellm.h> 

#define VBRIGHT_MAJOR_VERSION 2
#define VBRIGHT_MINOR_VERSION 5

#define CONFIG_KEYWORD "gbright_plugin_config"

// Make this a config in the future
#define WHEEL_ADJUST 25

#define MIN_VAL 0
#define MAX_VAL 255

#define LOCATION MON_APM 
/* The location of the plugin, choose between :
|*   MON_CLOCK, MON_CPU, MON_PROC, MON_DISK,
|*   MON_INET, MON_NET, MON_FS, MON_MAIL,       
|*   MON_APM, or MON_UPTIME                    
*/

#define REVERSE_TOGGLE 0

#define DEFAULT_DEVICE_PATH "/dev/sonypi"

typedef struct {
    GkrellmKrell *krell;
    int setting;
    GkrellmPanel *panel;

    int slider_in_motion;
    GtkWidget *panelbox;

    // Are we reversed?  (255 brightest 0 darkest)
    int reversed;
    int config_reversed;

    // Are we broken?  (did the open fail?)
    int broken;

    // Path to the sony device
    char *device_path;
    char *config_device_path;

    // FD of the sonypi device node
    int sony_fd;

    // Label
    gchar *text;
} BrightSlider;
