/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;

class DefaultMutableAttributeContainer
implements AttributeContainerInternal {
    private final ImmutableAttributesFactory cache;
    private final AttributeContainerInternal parent;
    private ImmutableAttributes state = ImmutableAttributes.EMPTY;

    public DefaultMutableAttributeContainer(ImmutableAttributesFactory cache) {
        this(cache, null);
    }

    public DefaultMutableAttributeContainer(ImmutableAttributesFactory cache, AttributeContainerInternal parent) {
        this.cache = cache;
        this.parent = parent;
    }

    public String toString() {
        return this.asImmutable().toString();
    }

    public Set<Attribute<?>> keySet() {
        if (this.parent == null) {
            return this.state.keySet();
        }
        return Sets.union((Set)this.parent.keySet(), this.state.keySet());
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        DefaultMutableAttributeContainer.assertAttributeConstraints(value, key);
        this.checkInsertionAllowed(key);
        this.state = this.cache.concat(this.state, key, value);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        for (Attribute attribute : this.state.keySet()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException("Cannot have two attributes with the same name but different types. This container already has an attribute named '" + name + "' of type '" + attribute.getType().getName() + "' and you are trying to store another one of type '" + key.getType().getName() + "'");
        }
    }

    private static void assertAttributeConstraints(Object value, Attribute<?> attribute) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
        if (!attribute.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Unexpected type for attribute '" + attribute.getName() + "'. Expected " + attribute.getType().getName() + " but was:" + value.getClass().getName());
        }
    }

    public <T> T getAttribute(Attribute<T> key) {
        Object attribute = this.state.getAttribute(key);
        if (attribute == null && this.parent != null) {
            return (T)this.parent.getAttribute(key);
        }
        return (T)attribute;
    }

    public boolean isEmpty() {
        return this.state.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    public boolean contains(Attribute<?> key) {
        return this.state.contains(key) || this.parent != null && this.parent.contains(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        if (this.parent == null) {
            return this.state;
        }
        ImmutableAttributes attributes = this.parent.asImmutable();
        if (!this.state.isEmpty()) {
            attributes = this.cache.concat(attributes, this.state);
        }
        return attributes;
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.state.equals(that.state);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.state.hashCode();
        return result;
    }
}

