/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

class AggregatingProcessingStrategy
extends IncrementalProcessingStrategy {
    private final AnnotationProcessingResult result;

    AggregatingProcessingStrategy(AnnotationProcessingResult result) {
        super(result);
        this.result = result;
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.validateAnnotations(annotations);
        this.recordAggregatedTypes(supportedAnnotationTypes, annotations, roundEnv);
    }

    private void validateAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            Retention retention = typeElement.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.SOURCE) continue;
            this.result.setFullRebuildCause("'@" + typeElement.getSimpleName() + "' has source retention. Aggregating annotation processors require class or runtime retention");
        }
    }

    private void recordAggregatedTypes(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (supportedAnnotationTypes.contains("*")) {
            this.result.getAggregatedTypes().addAll(ElementUtils.getTopLevelTypeNames(roundEnv.getRootElements()));
        } else {
            for (TypeElement typeElement : annotations) {
                this.result.getAggregatedTypes().addAll(ElementUtils.getTopLevelTypeNames(roundEnv.getElementsAnnotatedWith(typeElement)));
            }
        }
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        this.result.getGeneratedAggregatingTypes().add(name.toString());
    }
}

