use crate::common_macro::schema_imports::*;

fn common_map_i32() -> BTreeMap<String, Definition> {
    schema_map! {

        "i32" => Definition::Primitive(4)
    }
}

fn common_map_slice_i32() -> BTreeMap<String, Definition> {
    schema_map! {
        "Vec<i32>" => Definition::Sequence {
            length_width: Definition::DEFAULT_LENGTH_WIDTH,
            length_range: Definition::DEFAULT_LENGTH_RANGE,
            elements: "i32".to_string()
        },
        "i32" => Definition::Primitive(4)
    }
}

#[test]
fn test_cell() {
    assert_eq!("i32", <core::cell::Cell<i32> as BorshSchema>::declaration());

    let mut actual_defs = schema_map!();
    <core::cell::Cell<i32> as BorshSchema>::add_definitions_recursively(&mut actual_defs);
    assert_eq!(common_map_i32(), actual_defs);
}

#[test]
fn test_ref_cell_vec() {
    assert_eq!(
        "Vec<i32>",
        <core::cell::RefCell<Vec<i32>> as BorshSchema>::declaration()
    );

    let mut actual_defs = schema_map!();
    <core::cell::RefCell<Vec<i32>> as BorshSchema>::add_definitions_recursively(&mut actual_defs);
    assert_eq!(common_map_slice_i32(), actual_defs);
}
