package network

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2022-05-01/network"

// AadAuthenticationParameters AAD Vpn authentication type related parameters.
type AadAuthenticationParameters struct {
	// AadTenant - AAD Vpn authentication parameter AAD tenant.
	AadTenant *string `json:"aadTenant,omitempty"`
	// AadAudience - AAD Vpn authentication parameter AAD audience.
	AadAudience *string `json:"aadAudience,omitempty"`
	// AadIssuer - AAD Vpn authentication parameter AAD issuer.
	AadIssuer *string `json:"aadIssuer,omitempty"`
}

// Action action to be taken on a route matching a RouteMap criterion.
type Action struct {
	// Type - Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'. Possible values include: 'RouteMapActionTypeUnknown', 'RouteMapActionTypeRemove', 'RouteMapActionTypeAdd', 'RouteMapActionTypeReplace', 'RouteMapActionTypeDrop'
	Type RouteMapActionType `json:"type,omitempty"`
	// Parameters - List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
	Parameters *[]Parameter `json:"parameters,omitempty"`
}

// BasicActiveBaseSecurityAdminRule network base admin rule.
type BasicActiveBaseSecurityAdminRule interface {
	AsActiveSecurityAdminRule() (*ActiveSecurityAdminRule, bool)
	AsActiveDefaultSecurityAdminRule() (*ActiveDefaultSecurityAdminRule, bool)
	AsActiveBaseSecurityAdminRule() (*ActiveBaseSecurityAdminRule, bool)
}

// ActiveBaseSecurityAdminRule network base admin rule.
type ActiveBaseSecurityAdminRule struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// CommitTime - Deployment time string.
	CommitTime *date.Time `json:"commitTime,omitempty"`
	// Region - Deployment region.
	Region *string `json:"region,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindActiveBaseSecurityAdminRule', 'KindCustom', 'KindDefault'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicActiveBaseSecurityAdminRule(body []byte) (BasicActiveBaseSecurityAdminRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCustom):
		var asar ActiveSecurityAdminRule
		err := json.Unmarshal(body, &asar)
		return asar, err
	case string(KindDefault):
		var adsar ActiveDefaultSecurityAdminRule
		err := json.Unmarshal(body, &adsar)
		return adsar, err
	default:
		var absar ActiveBaseSecurityAdminRule
		err := json.Unmarshal(body, &absar)
		return absar, err
	}
}
func unmarshalBasicActiveBaseSecurityAdminRuleArray(body []byte) ([]BasicActiveBaseSecurityAdminRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	absarArray := make([]BasicActiveBaseSecurityAdminRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		absar, err := unmarshalBasicActiveBaseSecurityAdminRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		absarArray[index] = absar
	}
	return absarArray, nil
}

// MarshalJSON is the custom marshaler for ActiveBaseSecurityAdminRule.
func (absar ActiveBaseSecurityAdminRule) MarshalJSON() ([]byte, error) {
	absar.Kind = KindActiveBaseSecurityAdminRule
	objectMap := make(map[string]interface{})
	if absar.ID != nil {
		objectMap["id"] = absar.ID
	}
	if absar.CommitTime != nil {
		objectMap["commitTime"] = absar.CommitTime
	}
	if absar.Region != nil {
		objectMap["region"] = absar.Region
	}
	if absar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = absar.ConfigurationDescription
	}
	if absar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = absar.RuleCollectionDescription
	}
	if absar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = absar.RuleCollectionAppliesToGroups
	}
	if absar.RuleGroups != nil {
		objectMap["ruleGroups"] = absar.RuleGroups
	}
	if absar.Kind != "" {
		objectMap["kind"] = absar.Kind
	}
	return json.Marshal(objectMap)
}

// AsActiveSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveBaseSecurityAdminRule.
func (absar ActiveBaseSecurityAdminRule) AsActiveSecurityAdminRule() (*ActiveSecurityAdminRule, bool) {
	return nil, false
}

// AsActiveDefaultSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveBaseSecurityAdminRule.
func (absar ActiveBaseSecurityAdminRule) AsActiveDefaultSecurityAdminRule() (*ActiveDefaultSecurityAdminRule, bool) {
	return nil, false
}

// AsActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveBaseSecurityAdminRule.
func (absar ActiveBaseSecurityAdminRule) AsActiveBaseSecurityAdminRule() (*ActiveBaseSecurityAdminRule, bool) {
	return &absar, true
}

// AsBasicActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveBaseSecurityAdminRule.
func (absar ActiveBaseSecurityAdminRule) AsBasicActiveBaseSecurityAdminRule() (BasicActiveBaseSecurityAdminRule, bool) {
	return &absar, true
}

// ActiveConfigurationParameter effective Virtual Networks Parameter.
type ActiveConfigurationParameter struct {
	// Regions - List of regions.
	Regions *[]string `json:"regions,omitempty"`
	// SkipToken - When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ActiveConnectivityConfiguration active connectivity configuration.
type ActiveConnectivityConfiguration struct {
	// CommitTime - Deployment time string.
	CommitTime *date.Time `json:"commitTime,omitempty"`
	// Region - Deployment region.
	Region *string `json:"region,omitempty"`
	// ID - Connectivity configuration ID.
	ID *string `json:"id,omitempty"`
	// ConnectivityConfigurationProperties - Properties of a network manager connectivity configuration
	*ConnectivityConfigurationProperties `json:"properties,omitempty"`
	// ConfigurationGroups - Effective configuration groups.
	ConfigurationGroups *[]ConfigurationGroup `json:"configurationGroups,omitempty"`
}

// MarshalJSON is the custom marshaler for ActiveConnectivityConfiguration.
func (acc ActiveConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acc.CommitTime != nil {
		objectMap["commitTime"] = acc.CommitTime
	}
	if acc.Region != nil {
		objectMap["region"] = acc.Region
	}
	if acc.ID != nil {
		objectMap["id"] = acc.ID
	}
	if acc.ConnectivityConfigurationProperties != nil {
		objectMap["properties"] = acc.ConnectivityConfigurationProperties
	}
	if acc.ConfigurationGroups != nil {
		objectMap["configurationGroups"] = acc.ConfigurationGroups
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActiveConnectivityConfiguration struct.
func (acc *ActiveConnectivityConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "commitTime":
			if v != nil {
				var commitTime date.Time
				err = json.Unmarshal(*v, &commitTime)
				if err != nil {
					return err
				}
				acc.CommitTime = &commitTime
			}
		case "region":
			if v != nil {
				var region string
				err = json.Unmarshal(*v, &region)
				if err != nil {
					return err
				}
				acc.Region = &region
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acc.ID = &ID
			}
		case "properties":
			if v != nil {
				var connectivityConfigurationProperties ConnectivityConfigurationProperties
				err = json.Unmarshal(*v, &connectivityConfigurationProperties)
				if err != nil {
					return err
				}
				acc.ConnectivityConfigurationProperties = &connectivityConfigurationProperties
			}
		case "configurationGroups":
			if v != nil {
				var configurationGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &configurationGroups)
				if err != nil {
					return err
				}
				acc.ConfigurationGroups = &configurationGroups
			}
		}
	}

	return nil
}

// ActiveConnectivityConfigurationsListResult result of the request to list active connectivity
// configurations. It contains a list of active connectivity configurations and a skiptoken to get the next
// set of results.
type ActiveConnectivityConfigurationsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of active connectivity configurations.
	Value *[]ActiveConnectivityConfiguration `json:"value,omitempty"`
	// SkipToken - When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ActiveDefaultSecurityAdminRule network default admin rule.
type ActiveDefaultSecurityAdminRule struct {
	// DefaultAdminPropertiesFormat - Indicates the properties of the default security admin rule
	*DefaultAdminPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// CommitTime - Deployment time string.
	CommitTime *date.Time `json:"commitTime,omitempty"`
	// Region - Deployment region.
	Region *string `json:"region,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindActiveBaseSecurityAdminRule', 'KindCustom', 'KindDefault'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ActiveDefaultSecurityAdminRule.
func (adsar ActiveDefaultSecurityAdminRule) MarshalJSON() ([]byte, error) {
	adsar.Kind = KindDefault
	objectMap := make(map[string]interface{})
	if adsar.DefaultAdminPropertiesFormat != nil {
		objectMap["properties"] = adsar.DefaultAdminPropertiesFormat
	}
	if adsar.ID != nil {
		objectMap["id"] = adsar.ID
	}
	if adsar.CommitTime != nil {
		objectMap["commitTime"] = adsar.CommitTime
	}
	if adsar.Region != nil {
		objectMap["region"] = adsar.Region
	}
	if adsar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = adsar.ConfigurationDescription
	}
	if adsar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = adsar.RuleCollectionDescription
	}
	if adsar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = adsar.RuleCollectionAppliesToGroups
	}
	if adsar.RuleGroups != nil {
		objectMap["ruleGroups"] = adsar.RuleGroups
	}
	if adsar.Kind != "" {
		objectMap["kind"] = adsar.Kind
	}
	return json.Marshal(objectMap)
}

// AsActiveSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveDefaultSecurityAdminRule.
func (adsar ActiveDefaultSecurityAdminRule) AsActiveSecurityAdminRule() (*ActiveSecurityAdminRule, bool) {
	return nil, false
}

// AsActiveDefaultSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveDefaultSecurityAdminRule.
func (adsar ActiveDefaultSecurityAdminRule) AsActiveDefaultSecurityAdminRule() (*ActiveDefaultSecurityAdminRule, bool) {
	return &adsar, true
}

// AsActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveDefaultSecurityAdminRule.
func (adsar ActiveDefaultSecurityAdminRule) AsActiveBaseSecurityAdminRule() (*ActiveBaseSecurityAdminRule, bool) {
	return nil, false
}

// AsBasicActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveDefaultSecurityAdminRule.
func (adsar ActiveDefaultSecurityAdminRule) AsBasicActiveBaseSecurityAdminRule() (BasicActiveBaseSecurityAdminRule, bool) {
	return &adsar, true
}

// UnmarshalJSON is the custom unmarshaler for ActiveDefaultSecurityAdminRule struct.
func (adsar *ActiveDefaultSecurityAdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var defaultAdminPropertiesFormat DefaultAdminPropertiesFormat
				err = json.Unmarshal(*v, &defaultAdminPropertiesFormat)
				if err != nil {
					return err
				}
				adsar.DefaultAdminPropertiesFormat = &defaultAdminPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adsar.ID = &ID
			}
		case "commitTime":
			if v != nil {
				var commitTime date.Time
				err = json.Unmarshal(*v, &commitTime)
				if err != nil {
					return err
				}
				adsar.CommitTime = &commitTime
			}
		case "region":
			if v != nil {
				var region string
				err = json.Unmarshal(*v, &region)
				if err != nil {
					return err
				}
				adsar.Region = &region
			}
		case "configurationDescription":
			if v != nil {
				var configurationDescription string
				err = json.Unmarshal(*v, &configurationDescription)
				if err != nil {
					return err
				}
				adsar.ConfigurationDescription = &configurationDescription
			}
		case "ruleCollectionDescription":
			if v != nil {
				var ruleCollectionDescription string
				err = json.Unmarshal(*v, &ruleCollectionDescription)
				if err != nil {
					return err
				}
				adsar.RuleCollectionDescription = &ruleCollectionDescription
			}
		case "ruleCollectionAppliesToGroups":
			if v != nil {
				var ruleCollectionAppliesToGroups []ManagerSecurityGroupItem
				err = json.Unmarshal(*v, &ruleCollectionAppliesToGroups)
				if err != nil {
					return err
				}
				adsar.RuleCollectionAppliesToGroups = &ruleCollectionAppliesToGroups
			}
		case "ruleGroups":
			if v != nil {
				var ruleGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &ruleGroups)
				if err != nil {
					return err
				}
				adsar.RuleGroups = &ruleGroups
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adsar.Kind = kind
			}
		}
	}

	return nil
}

// ActiveSecurityAdminRule network admin rule.
type ActiveSecurityAdminRule struct {
	// AdminPropertiesFormat - Indicates the properties of the security admin rule
	*AdminPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// CommitTime - Deployment time string.
	CommitTime *date.Time `json:"commitTime,omitempty"`
	// Region - Deployment region.
	Region *string `json:"region,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindActiveBaseSecurityAdminRule', 'KindCustom', 'KindDefault'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ActiveSecurityAdminRule.
func (asar ActiveSecurityAdminRule) MarshalJSON() ([]byte, error) {
	asar.Kind = KindCustom
	objectMap := make(map[string]interface{})
	if asar.AdminPropertiesFormat != nil {
		objectMap["properties"] = asar.AdminPropertiesFormat
	}
	if asar.ID != nil {
		objectMap["id"] = asar.ID
	}
	if asar.CommitTime != nil {
		objectMap["commitTime"] = asar.CommitTime
	}
	if asar.Region != nil {
		objectMap["region"] = asar.Region
	}
	if asar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = asar.ConfigurationDescription
	}
	if asar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = asar.RuleCollectionDescription
	}
	if asar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = asar.RuleCollectionAppliesToGroups
	}
	if asar.RuleGroups != nil {
		objectMap["ruleGroups"] = asar.RuleGroups
	}
	if asar.Kind != "" {
		objectMap["kind"] = asar.Kind
	}
	return json.Marshal(objectMap)
}

// AsActiveSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveSecurityAdminRule.
func (asar ActiveSecurityAdminRule) AsActiveSecurityAdminRule() (*ActiveSecurityAdminRule, bool) {
	return &asar, true
}

// AsActiveDefaultSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveSecurityAdminRule.
func (asar ActiveSecurityAdminRule) AsActiveDefaultSecurityAdminRule() (*ActiveDefaultSecurityAdminRule, bool) {
	return nil, false
}

// AsActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveSecurityAdminRule.
func (asar ActiveSecurityAdminRule) AsActiveBaseSecurityAdminRule() (*ActiveBaseSecurityAdminRule, bool) {
	return nil, false
}

// AsBasicActiveBaseSecurityAdminRule is the BasicActiveBaseSecurityAdminRule implementation for ActiveSecurityAdminRule.
func (asar ActiveSecurityAdminRule) AsBasicActiveBaseSecurityAdminRule() (BasicActiveBaseSecurityAdminRule, bool) {
	return &asar, true
}

// UnmarshalJSON is the custom unmarshaler for ActiveSecurityAdminRule struct.
func (asar *ActiveSecurityAdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adminPropertiesFormat AdminPropertiesFormat
				err = json.Unmarshal(*v, &adminPropertiesFormat)
				if err != nil {
					return err
				}
				asar.AdminPropertiesFormat = &adminPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asar.ID = &ID
			}
		case "commitTime":
			if v != nil {
				var commitTime date.Time
				err = json.Unmarshal(*v, &commitTime)
				if err != nil {
					return err
				}
				asar.CommitTime = &commitTime
			}
		case "region":
			if v != nil {
				var region string
				err = json.Unmarshal(*v, &region)
				if err != nil {
					return err
				}
				asar.Region = &region
			}
		case "configurationDescription":
			if v != nil {
				var configurationDescription string
				err = json.Unmarshal(*v, &configurationDescription)
				if err != nil {
					return err
				}
				asar.ConfigurationDescription = &configurationDescription
			}
		case "ruleCollectionDescription":
			if v != nil {
				var ruleCollectionDescription string
				err = json.Unmarshal(*v, &ruleCollectionDescription)
				if err != nil {
					return err
				}
				asar.RuleCollectionDescription = &ruleCollectionDescription
			}
		case "ruleCollectionAppliesToGroups":
			if v != nil {
				var ruleCollectionAppliesToGroups []ManagerSecurityGroupItem
				err = json.Unmarshal(*v, &ruleCollectionAppliesToGroups)
				if err != nil {
					return err
				}
				asar.RuleCollectionAppliesToGroups = &ruleCollectionAppliesToGroups
			}
		case "ruleGroups":
			if v != nil {
				var ruleGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &ruleGroups)
				if err != nil {
					return err
				}
				asar.RuleGroups = &ruleGroups
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asar.Kind = kind
			}
		}
	}

	return nil
}

// ActiveSecurityAdminRulesListResult result of the request to list active security admin rules. It
// contains a list of active security admin rules and a skiptoken to get the next set of results.
type ActiveSecurityAdminRulesListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of active security admin rules.
	Value *[]BasicActiveBaseSecurityAdminRule `json:"value,omitempty"`
	// SkipToken - When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
	SkipToken *string `json:"skipToken,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ActiveSecurityAdminRulesListResult struct.
func (asarlr *ActiveSecurityAdminRulesListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicActiveBaseSecurityAdminRuleArray(*v)
				if err != nil {
					return err
				}
				asarlr.Value = &value
			}
		case "skipToken":
			if v != nil {
				var skipToken string
				err = json.Unmarshal(*v, &skipToken)
				if err != nil {
					return err
				}
				asarlr.SkipToken = &skipToken
			}
		}
	}

	return nil
}

// AddressPrefixItem address prefix item.
type AddressPrefixItem struct {
	// AddressPrefix - Address prefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AddressPrefixType - Address prefix type. Possible values include: 'IPPrefix', 'ServiceTag'
	AddressPrefixType AddressPrefixType `json:"addressPrefixType,omitempty"`
}

// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets of the
// virtual network.
type AddressSpace struct {
	// AddressPrefixes - A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// AdminPropertiesFormat security admin rule resource.
type AdminPropertiesFormat struct {
	// Description - A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Network protocol this rule applies to. Possible values include: 'SecurityConfigurationRuleProtocolTCP', 'SecurityConfigurationRuleProtocolUDP', 'SecurityConfigurationRuleProtocolIcmp', 'SecurityConfigurationRuleProtocolEsp', 'SecurityConfigurationRuleProtocolAny', 'SecurityConfigurationRuleProtocolAh'
	Protocol SecurityConfigurationRuleProtocol `json:"protocol,omitempty"`
	// Sources - The CIDR or source IP ranges.
	Sources *[]AddressPrefixItem `json:"sources,omitempty"`
	// Destinations - The destination address prefixes. CIDR or destination IP ranges.
	Destinations *[]AddressPrefixItem `json:"destinations,omitempty"`
	// SourcePortRanges - The source port ranges.
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - The destination port ranges.
	DestinationPortRanges *[]string `json:"destinationPortRanges,omitempty"`
	// Access - Indicates the access allowed for this particular rule. Possible values include: 'SecurityConfigurationRuleAccessAllow', 'SecurityConfigurationRuleAccessDeny', 'SecurityConfigurationRuleAccessAlwaysAllow'
	Access SecurityConfigurationRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - Indicates if the traffic matched against the rule in inbound or outbound. Possible values include: 'SecurityConfigurationRuleDirectionInbound', 'SecurityConfigurationRuleDirectionOutbound'
	Direction SecurityConfigurationRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AdminPropertiesFormat.
func (apf AdminPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apf.Description != nil {
		objectMap["description"] = apf.Description
	}
	if apf.Protocol != "" {
		objectMap["protocol"] = apf.Protocol
	}
	if apf.Sources != nil {
		objectMap["sources"] = apf.Sources
	}
	if apf.Destinations != nil {
		objectMap["destinations"] = apf.Destinations
	}
	if apf.SourcePortRanges != nil {
		objectMap["sourcePortRanges"] = apf.SourcePortRanges
	}
	if apf.DestinationPortRanges != nil {
		objectMap["destinationPortRanges"] = apf.DestinationPortRanges
	}
	if apf.Access != "" {
		objectMap["access"] = apf.Access
	}
	if apf.Priority != nil {
		objectMap["priority"] = apf.Priority
	}
	if apf.Direction != "" {
		objectMap["direction"] = apf.Direction
	}
	return json.Marshal(objectMap)
}

// AdminRule network admin rule.
type AdminRule struct {
	// AdminPropertiesFormat - Indicates the properties of the security admin rule
	*AdminPropertiesFormat `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicBaseAdminRuleKindBaseAdminRule', 'KindBasicBaseAdminRuleKindCustom', 'KindBasicBaseAdminRuleKindDefault'
	Kind KindBasicBaseAdminRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AdminRule.
func (ar AdminRule) MarshalJSON() ([]byte, error) {
	ar.Kind = KindBasicBaseAdminRuleKindCustom
	objectMap := make(map[string]interface{})
	if ar.AdminPropertiesFormat != nil {
		objectMap["properties"] = ar.AdminPropertiesFormat
	}
	if ar.Kind != "" {
		objectMap["kind"] = ar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAdminRule is the BasicBaseAdminRule implementation for AdminRule.
func (ar AdminRule) AsAdminRule() (*AdminRule, bool) {
	return &ar, true
}

// AsDefaultAdminRule is the BasicBaseAdminRule implementation for AdminRule.
func (ar AdminRule) AsDefaultAdminRule() (*DefaultAdminRule, bool) {
	return nil, false
}

// AsBaseAdminRule is the BasicBaseAdminRule implementation for AdminRule.
func (ar AdminRule) AsBaseAdminRule() (*BaseAdminRule, bool) {
	return nil, false
}

// AsBasicBaseAdminRule is the BasicBaseAdminRule implementation for AdminRule.
func (ar AdminRule) AsBasicBaseAdminRule() (BasicBaseAdminRule, bool) {
	return &ar, true
}

// UnmarshalJSON is the custom unmarshaler for AdminRule struct.
func (ar *AdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adminPropertiesFormat AdminPropertiesFormat
				err = json.Unmarshal(*v, &adminPropertiesFormat)
				if err != nil {
					return err
				}
				ar.AdminPropertiesFormat = &adminPropertiesFormat
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ar.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicBaseAdminRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// AdminRuleCollection defines the admin rule collection.
type AdminRuleCollection struct {
	autorest.Response `json:"-"`
	// AdminRuleCollectionPropertiesFormat - Indicates the properties for the network manager admin rule collection.
	*AdminRuleCollectionPropertiesFormat `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for AdminRuleCollection.
func (arc AdminRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arc.AdminRuleCollectionPropertiesFormat != nil {
		objectMap["properties"] = arc.AdminRuleCollectionPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdminRuleCollection struct.
func (arc *AdminRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adminRuleCollectionPropertiesFormat AdminRuleCollectionPropertiesFormat
				err = json.Unmarshal(*v, &adminRuleCollectionPropertiesFormat)
				if err != nil {
					return err
				}
				arc.AdminRuleCollectionPropertiesFormat = &adminRuleCollectionPropertiesFormat
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				arc.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				arc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				arc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				arc.Etag = &etag
			}
		}
	}

	return nil
}

// AdminRuleCollectionListResult security admin configuration rule collection list result.
type AdminRuleCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network manager security admin configuration rule collections
	Value *[]AdminRuleCollection `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AdminRuleCollectionListResultIterator provides access to a complete listing of AdminRuleCollection
// values.
type AdminRuleCollectionListResultIterator struct {
	i    int
	page AdminRuleCollectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdminRuleCollectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdminRuleCollectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdminRuleCollectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdminRuleCollectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdminRuleCollectionListResultIterator) Response() AdminRuleCollectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdminRuleCollectionListResultIterator) Value() AdminRuleCollection {
	if !iter.page.NotDone() {
		return AdminRuleCollection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdminRuleCollectionListResultIterator type.
func NewAdminRuleCollectionListResultIterator(page AdminRuleCollectionListResultPage) AdminRuleCollectionListResultIterator {
	return AdminRuleCollectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arclr AdminRuleCollectionListResult) IsEmpty() bool {
	return arclr.Value == nil || len(*arclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arclr AdminRuleCollectionListResult) hasNextLink() bool {
	return arclr.NextLink != nil && len(*arclr.NextLink) != 0
}

// adminRuleCollectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arclr AdminRuleCollectionListResult) adminRuleCollectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !arclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arclr.NextLink)))
}

// AdminRuleCollectionListResultPage contains a page of AdminRuleCollection values.
type AdminRuleCollectionListResultPage struct {
	fn    func(context.Context, AdminRuleCollectionListResult) (AdminRuleCollectionListResult, error)
	arclr AdminRuleCollectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdminRuleCollectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdminRuleCollectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arclr)
		if err != nil {
			return err
		}
		page.arclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdminRuleCollectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdminRuleCollectionListResultPage) NotDone() bool {
	return !page.arclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdminRuleCollectionListResultPage) Response() AdminRuleCollectionListResult {
	return page.arclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdminRuleCollectionListResultPage) Values() []AdminRuleCollection {
	if page.arclr.IsEmpty() {
		return nil
	}
	return *page.arclr.Value
}

// Creates a new instance of the AdminRuleCollectionListResultPage type.
func NewAdminRuleCollectionListResultPage(cur AdminRuleCollectionListResult, getNextPage func(context.Context, AdminRuleCollectionListResult) (AdminRuleCollectionListResult, error)) AdminRuleCollectionListResultPage {
	return AdminRuleCollectionListResultPage{
		fn:    getNextPage,
		arclr: cur,
	}
}

// AdminRuleCollectionPropertiesFormat defines the admin rule collection properties.
type AdminRuleCollectionPropertiesFormat struct {
	// Description - A description of the admin rule collection.
	Description *string `json:"description,omitempty"`
	// AppliesToGroups - Groups for configuration
	AppliesToGroups *[]ManagerSecurityGroupItem `json:"appliesToGroups,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AdminRuleCollectionPropertiesFormat.
func (arcpf AdminRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arcpf.Description != nil {
		objectMap["description"] = arcpf.Description
	}
	if arcpf.AppliesToGroups != nil {
		objectMap["appliesToGroups"] = arcpf.AppliesToGroups
	}
	return json.Marshal(objectMap)
}

// AdminRuleCollectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AdminRuleCollectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AdminRuleCollectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AdminRuleCollectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AdminRuleCollectionsDeleteFuture.Result.
func (future *AdminRuleCollectionsDeleteFuture) result(client AdminRuleCollectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AdminRuleCollectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AdminRuleCollectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AdminRuleListResult security configuration admin rule list result.
type AdminRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of admin rules
	Value *[]BasicBaseAdminRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AdminRuleListResult struct.
func (arlr *AdminRuleListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicBaseAdminRuleArray(*v)
				if err != nil {
					return err
				}
				arlr.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				arlr.NextLink = &nextLink
			}
		}
	}

	return nil
}

// AdminRuleListResultIterator provides access to a complete listing of BaseAdminRule values.
type AdminRuleListResultIterator struct {
	i    int
	page AdminRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdminRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdminRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdminRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdminRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdminRuleListResultIterator) Response() AdminRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdminRuleListResultIterator) Value() BasicBaseAdminRule {
	if !iter.page.NotDone() {
		return BaseAdminRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdminRuleListResultIterator type.
func NewAdminRuleListResultIterator(page AdminRuleListResultPage) AdminRuleListResultIterator {
	return AdminRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr AdminRuleListResult) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arlr AdminRuleListResult) hasNextLink() bool {
	return arlr.NextLink != nil && len(*arlr.NextLink) != 0
}

// adminRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr AdminRuleListResult) adminRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !arlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// AdminRuleListResultPage contains a page of BasicBaseAdminRule values.
type AdminRuleListResultPage struct {
	fn   func(context.Context, AdminRuleListResult) (AdminRuleListResult, error)
	arlr AdminRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdminRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdminRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arlr)
		if err != nil {
			return err
		}
		page.arlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdminRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdminRuleListResultPage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdminRuleListResultPage) Response() AdminRuleListResult {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdminRuleListResultPage) Values() []BasicBaseAdminRule {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// Creates a new instance of the AdminRuleListResultPage type.
func NewAdminRuleListResultPage(cur AdminRuleListResult, getNextPage func(context.Context, AdminRuleListResult) (AdminRuleListResult, error)) AdminRuleListResultPage {
	return AdminRuleListResultPage{
		fn:   getNextPage,
		arlr: cur,
	}
}

// AdminRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AdminRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AdminRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AdminRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AdminRulesDeleteFuture.Result.
func (future *AdminRulesDeleteFuture) result(client AdminRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AdminRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AdminRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGateway application gateway resource.
type ApplicationGateway struct {
	autorest.Response `json:"-"`
	// ApplicationGatewayPropertiesFormat - Properties of the application gateway.
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Identity - The identity of the application gateway, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Zones != nil {
		objectMap["zones"] = ag.Zones
	}
	if ag.Identity != nil {
		objectMap["identity"] = ag.Identity
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				ag.Zones = &zones
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ag.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificate authentication certificates of an application gateway.
type ApplicationGatewayAuthenticationCertificate struct {
	// ApplicationGatewayAuthenticationCertificatePropertiesFormat - Properties of the application gateway authentication certificate.
	*ApplicationGatewayAuthenticationCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the authentication certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAuthenticationCertificate.
func (agac ApplicationGatewayAuthenticationCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat != nil {
		objectMap["properties"] = agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat
	}
	if agac.Name != nil {
		objectMap["name"] = agac.Name
	}
	if agac.ID != nil {
		objectMap["id"] = agac.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAuthenticationCertificate struct.
func (agac *ApplicationGatewayAuthenticationCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAuthenticationCertificatePropertiesFormat ApplicationGatewayAuthenticationCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAuthenticationCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agac.ApplicationGatewayAuthenticationCertificatePropertiesFormat = &applicationGatewayAuthenticationCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agac.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agac.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agac.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agac.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayAuthenticationCertificatePropertiesFormat authentication certificates properties of an
// application gateway.
type ApplicationGatewayAuthenticationCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the authentication certificate resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAuthenticationCertificatePropertiesFormat.
func (agacpf ApplicationGatewayAuthenticationCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agacpf.Data != nil {
		objectMap["data"] = agacpf.Data
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayAutoscaleConfiguration application Gateway autoscale configuration.
type ApplicationGatewayAutoscaleConfiguration struct {
	// MinCapacity - Lower bound on number of Application Gateway capacity.
	MinCapacity *int32 `json:"minCapacity,omitempty"`
	// MaxCapacity - Upper bound on number of Application Gateway capacity.
	MaxCapacity *int32 `json:"maxCapacity,omitempty"`
}

// ApplicationGatewayAvailableSslOptions response for ApplicationGatewayAvailableSslOptions API service
// call.
type ApplicationGatewayAvailableSslOptions struct {
	autorest.Response `json:"-"`
	// ApplicationGatewayAvailableSslOptionsPropertiesFormat - Properties of the application gateway available SSL options.
	*ApplicationGatewayAvailableSslOptionsPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayAvailableSslOptions.
func (agaso ApplicationGatewayAvailableSslOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat != nil {
		objectMap["properties"] = agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat
	}
	if agaso.ID != nil {
		objectMap["id"] = agaso.ID
	}
	if agaso.Location != nil {
		objectMap["location"] = agaso.Location
	}
	if agaso.Tags != nil {
		objectMap["tags"] = agaso.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayAvailableSslOptions struct.
func (agaso *ApplicationGatewayAvailableSslOptions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayAvailableSslOptionsPropertiesFormat ApplicationGatewayAvailableSslOptionsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayAvailableSslOptionsPropertiesFormat)
				if err != nil {
					return err
				}
				agaso.ApplicationGatewayAvailableSslOptionsPropertiesFormat = &applicationGatewayAvailableSslOptionsPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agaso.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agaso.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agaso.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agaso.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agaso.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayAvailableSslOptionsPropertiesFormat properties of
// ApplicationGatewayAvailableSslOptions.
type ApplicationGatewayAvailableSslOptionsPropertiesFormat struct {
	// PredefinedPolicies - List of available Ssl predefined policy.
	PredefinedPolicies *[]SubResource `json:"predefinedPolicies,omitempty"`
	// DefaultPolicy - Name of the Ssl predefined policy applied by default to application gateway. Possible values include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401', 'AppGwSslPolicy20170401S', 'AppGwSslPolicy20220101', 'AppGwSslPolicy20220101S'
	DefaultPolicy ApplicationGatewaySslPolicyName `json:"defaultPolicy,omitempty"`
	// AvailableCipherSuites - List of available Ssl cipher suites.
	AvailableCipherSuites *[]ApplicationGatewaySslCipherSuite `json:"availableCipherSuites,omitempty"`
	// AvailableProtocols - List of available Ssl protocols.
	AvailableProtocols *[]ApplicationGatewaySslProtocol `json:"availableProtocols,omitempty"`
}

// ApplicationGatewayAvailableSslPredefinedPolicies response for ApplicationGatewayAvailableSslOptions API
// service call.
type ApplicationGatewayAvailableSslPredefinedPolicies struct {
	autorest.Response `json:"-"`
	// Value - List of available Ssl predefined policy.
	Value *[]ApplicationGatewaySslPredefinedPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayAvailableSslPredefinedPoliciesIterator provides access to a complete listing of
// ApplicationGatewaySslPredefinedPolicy values.
type ApplicationGatewayAvailableSslPredefinedPoliciesIterator struct {
	i    int
	page ApplicationGatewayAvailableSslPredefinedPoliciesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayAvailableSslPredefinedPoliciesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayAvailableSslPredefinedPoliciesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Response() ApplicationGatewayAvailableSslPredefinedPolicies {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayAvailableSslPredefinedPoliciesIterator) Value() ApplicationGatewaySslPredefinedPolicy {
	if !iter.page.NotDone() {
		return ApplicationGatewaySslPredefinedPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayAvailableSslPredefinedPoliciesIterator type.
func NewApplicationGatewayAvailableSslPredefinedPoliciesIterator(page ApplicationGatewayAvailableSslPredefinedPoliciesPage) ApplicationGatewayAvailableSslPredefinedPoliciesIterator {
	return ApplicationGatewayAvailableSslPredefinedPoliciesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) IsEmpty() bool {
	return agaspp.Value == nil || len(*agaspp.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) hasNextLink() bool {
	return agaspp.NextLink != nil && len(*agaspp.NextLink) != 0
}

// applicationGatewayAvailableSslPredefinedPoliciesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agaspp ApplicationGatewayAvailableSslPredefinedPolicies) applicationGatewayAvailableSslPredefinedPoliciesPreparer(ctx context.Context) (*http.Request, error) {
	if !agaspp.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agaspp.NextLink)))
}

// ApplicationGatewayAvailableSslPredefinedPoliciesPage contains a page of
// ApplicationGatewaySslPredefinedPolicy values.
type ApplicationGatewayAvailableSslPredefinedPoliciesPage struct {
	fn     func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)
	agaspp ApplicationGatewayAvailableSslPredefinedPolicies
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayAvailableSslPredefinedPoliciesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayAvailableSslPredefinedPoliciesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agaspp)
		if err != nil {
			return err
		}
		page.agaspp = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayAvailableSslPredefinedPoliciesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) NotDone() bool {
	return !page.agaspp.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) Response() ApplicationGatewayAvailableSslPredefinedPolicies {
	return page.agaspp
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayAvailableSslPredefinedPoliciesPage) Values() []ApplicationGatewaySslPredefinedPolicy {
	if page.agaspp.IsEmpty() {
		return nil
	}
	return *page.agaspp.Value
}

// Creates a new instance of the ApplicationGatewayAvailableSslPredefinedPoliciesPage type.
func NewApplicationGatewayAvailableSslPredefinedPoliciesPage(cur ApplicationGatewayAvailableSslPredefinedPolicies, getNextPage func(context.Context, ApplicationGatewayAvailableSslPredefinedPolicies) (ApplicationGatewayAvailableSslPredefinedPolicies, error)) ApplicationGatewayAvailableSslPredefinedPoliciesPage {
	return ApplicationGatewayAvailableSslPredefinedPoliciesPage{
		fn:     getNextPage,
		agaspp: cur,
	}
}

// ApplicationGatewayAvailableWafRuleSetsResult response for ApplicationGatewayAvailableWafRuleSets API
// service call.
type ApplicationGatewayAvailableWafRuleSetsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of application gateway rule sets.
	Value *[]ApplicationGatewayFirewallRuleSet `json:"value,omitempty"`
}

// ApplicationGatewayBackendAddress backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	// ApplicationGatewayBackendAddressPoolPropertiesFormat - Properties of the application gateway backend address pool.
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the backend address pool that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agbap.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of an
// application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - READ-ONLY; Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Backend addresses.
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the backend address pool resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPoolPropertiesFormat.
func (agbappf ApplicationGatewayBackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbappf.BackendAddresses != nil {
		objectMap["backendAddresses"] = agbappf.BackendAddresses
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayBackendHealth response for ApplicationGatewayBackendHealth API service call.
type ApplicationGatewayBackendHealth struct {
	autorest.Response `json:"-"`
	// BackendAddressPools - A list of ApplicationGatewayBackendHealthPool resources.
	BackendAddressPools *[]ApplicationGatewayBackendHealthPool `json:"backendAddressPools,omitempty"`
}

// ApplicationGatewayBackendHealthHTTPSettings application gateway BackendHealthHttp settings.
type ApplicationGatewayBackendHealthHTTPSettings struct {
	// BackendHTTPSettings - Reference to an ApplicationGatewayBackendHttpSettings resource.
	BackendHTTPSettings *ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettings,omitempty"`
	// Servers - List of ApplicationGatewayBackendHealthServer resources.
	Servers *[]ApplicationGatewayBackendHealthServer `json:"servers,omitempty"`
}

// ApplicationGatewayBackendHealthOnDemand result of on demand test probe.
type ApplicationGatewayBackendHealthOnDemand struct {
	autorest.Response `json:"-"`
	// BackendAddressPool - Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`
	// BackendHealthHTTPSettings - Application gateway BackendHealthHttp settings.
	BackendHealthHTTPSettings *ApplicationGatewayBackendHealthHTTPSettings `json:"backendHealthHttpSettings,omitempty"`
}

// ApplicationGatewayBackendHealthPool application gateway BackendHealth pool.
type ApplicationGatewayBackendHealthPool struct {
	// BackendAddressPool - Reference to an ApplicationGatewayBackendAddressPool resource.
	BackendAddressPool *ApplicationGatewayBackendAddressPool `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettingsCollection - List of ApplicationGatewayBackendHealthHttpSettings resources.
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHealthHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
}

// ApplicationGatewayBackendHealthServer application gateway backendhealth http settings.
type ApplicationGatewayBackendHealthServer struct {
	// Address - IP address or FQDN of backend server.
	Address *string `json:"address,omitempty"`
	// IPConfiguration - Reference to IP configuration of backend server.
	IPConfiguration *InterfaceIPConfiguration `json:"ipConfiguration,omitempty"`
	// Health - Health of backend server. Possible values include: 'Unknown', 'Up', 'Down', 'Partial', 'Draining'
	Health ApplicationGatewayBackendHealthServerHealth `json:"health,omitempty"`
	// HealthProbeLog - Health Probe Log.
	HealthProbeLog *string `json:"healthProbeLog,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	// ApplicationGatewayBackendHTTPSettingsPropertiesFormat - Properties of the application gateway backend HTTP settings.
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the backend http settings that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agbhs.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - The destination port on the backend.
	Port *int32 `json:"port,omitempty"`
	// Protocol - The protocol used to communicate with the backend. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Cookie based affinity. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// RequestTimeout - Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`
	// Probe - Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`
	// AuthenticationCertificates - Array of references to application gateway authentication certificates.
	AuthenticationCertificates *[]SubResource `json:"authenticationCertificates,omitempty"`
	// TrustedRootCertificates - Array of references to application gateway trusted root certificates.
	TrustedRootCertificates *[]SubResource `json:"trustedRootCertificates,omitempty"`
	// ConnectionDraining - Connection draining of the backend http settings resource.
	ConnectionDraining *ApplicationGatewayConnectionDraining `json:"connectionDraining,omitempty"`
	// HostName - Host header to be sent to the backend servers.
	HostName *string `json:"hostName,omitempty"`
	// PickHostNameFromBackendAddress - Whether to pick host header should be picked from the host name of the backend server. Default value is false.
	PickHostNameFromBackendAddress *bool `json:"pickHostNameFromBackendAddress,omitempty"`
	// AffinityCookieName - Cookie name to use for the affinity cookie.
	AffinityCookieName *string `json:"affinityCookieName,omitempty"`
	// ProbeEnabled - Whether the probe is enabled. Default value is false.
	ProbeEnabled *bool `json:"probeEnabled,omitempty"`
	// Path - Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
	Path *string `json:"path,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the backend HTTP settings resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettingsPropertiesFormat.
func (agbhspf ApplicationGatewayBackendHTTPSettingsPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhspf.Port != nil {
		objectMap["port"] = agbhspf.Port
	}
	if agbhspf.Protocol != "" {
		objectMap["protocol"] = agbhspf.Protocol
	}
	if agbhspf.CookieBasedAffinity != "" {
		objectMap["cookieBasedAffinity"] = agbhspf.CookieBasedAffinity
	}
	if agbhspf.RequestTimeout != nil {
		objectMap["requestTimeout"] = agbhspf.RequestTimeout
	}
	if agbhspf.Probe != nil {
		objectMap["probe"] = agbhspf.Probe
	}
	if agbhspf.AuthenticationCertificates != nil {
		objectMap["authenticationCertificates"] = agbhspf.AuthenticationCertificates
	}
	if agbhspf.TrustedRootCertificates != nil {
		objectMap["trustedRootCertificates"] = agbhspf.TrustedRootCertificates
	}
	if agbhspf.ConnectionDraining != nil {
		objectMap["connectionDraining"] = agbhspf.ConnectionDraining
	}
	if agbhspf.HostName != nil {
		objectMap["hostName"] = agbhspf.HostName
	}
	if agbhspf.PickHostNameFromBackendAddress != nil {
		objectMap["pickHostNameFromBackendAddress"] = agbhspf.PickHostNameFromBackendAddress
	}
	if agbhspf.AffinityCookieName != nil {
		objectMap["affinityCookieName"] = agbhspf.AffinityCookieName
	}
	if agbhspf.ProbeEnabled != nil {
		objectMap["probeEnabled"] = agbhspf.ProbeEnabled
	}
	if agbhspf.Path != nil {
		objectMap["path"] = agbhspf.Path
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayBackendSettings backend address pool settings of an application gateway.
type ApplicationGatewayBackendSettings struct {
	// ApplicationGatewayBackendSettingsPropertiesFormat - Properties of the application gateway backend settings.
	*ApplicationGatewayBackendSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the backend settings that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendSettings.
func (agbs ApplicationGatewayBackendSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbs.ApplicationGatewayBackendSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbs.ApplicationGatewayBackendSettingsPropertiesFormat
	}
	if agbs.Name != nil {
		objectMap["name"] = agbs.Name
	}
	if agbs.ID != nil {
		objectMap["id"] = agbs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendSettings struct.
func (agbs *ApplicationGatewayBackendSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendSettingsPropertiesFormat ApplicationGatewayBackendSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbs.ApplicationGatewayBackendSettingsPropertiesFormat = &applicationGatewayBackendSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbs.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agbs.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendSettingsPropertiesFormat properties of Backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendSettingsPropertiesFormat struct {
	// Port - The destination port on the backend.
	Port *int32 `json:"port,omitempty"`
	// Protocol - The protocol used to communicate with the backend. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Timeout - Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Probe - Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`
	// TrustedRootCertificates - Array of references to application gateway trusted root certificates.
	TrustedRootCertificates *[]SubResource `json:"trustedRootCertificates,omitempty"`
	// HostName - Server name indication to be sent to the backend servers for Tls protocol.
	HostName *string `json:"hostName,omitempty"`
	// PickHostNameFromBackendAddress - Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
	PickHostNameFromBackendAddress *bool `json:"pickHostNameFromBackendAddress,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the backend HTTP settings resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendSettingsPropertiesFormat.
func (agbspf ApplicationGatewayBackendSettingsPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbspf.Port != nil {
		objectMap["port"] = agbspf.Port
	}
	if agbspf.Protocol != "" {
		objectMap["protocol"] = agbspf.Protocol
	}
	if agbspf.Timeout != nil {
		objectMap["timeout"] = agbspf.Timeout
	}
	if agbspf.Probe != nil {
		objectMap["probe"] = agbspf.Probe
	}
	if agbspf.TrustedRootCertificates != nil {
		objectMap["trustedRootCertificates"] = agbspf.TrustedRootCertificates
	}
	if agbspf.HostName != nil {
		objectMap["hostName"] = agbspf.HostName
	}
	if agbspf.PickHostNameFromBackendAddress != nil {
		objectMap["pickHostNameFromBackendAddress"] = agbspf.PickHostNameFromBackendAddress
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayClientAuthConfiguration application gateway client authentication configuration.
type ApplicationGatewayClientAuthConfiguration struct {
	// VerifyClientCertIssuerDN - Verify client certificate issuer name on the application gateway.
	VerifyClientCertIssuerDN *bool `json:"verifyClientCertIssuerDN,omitempty"`
	// VerifyClientRevocation - Verify client certificate revocation status. Possible values include: 'None', 'OCSP'
	VerifyClientRevocation ApplicationGatewayClientRevocationOptions `json:"verifyClientRevocation,omitempty"`
}

// ApplicationGatewayConnectionDraining connection draining allows open connections to a backend server to
// be active for a specified time after the backend server got removed from the configuration.
type ApplicationGatewayConnectionDraining struct {
	// Enabled - Whether connection draining is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// DrainTimeoutInSec - The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
	DrainTimeoutInSec *int32 `json:"drainTimeoutInSec,omitempty"`
}

// ApplicationGatewayCustomError customer error of an application gateway.
type ApplicationGatewayCustomError struct {
	// StatusCode - Status code of the application gateway customer error. Possible values include: 'HTTPStatus403', 'HTTPStatus502'
	StatusCode ApplicationGatewayCustomErrorStatusCode `json:"statusCode,omitempty"`
	// CustomErrorPageURL - Error page URL of the application gateway customer error.
	CustomErrorPageURL *string `json:"customErrorPageUrl,omitempty"`
}

// ApplicationGatewayFirewallDisabledRuleGroup allows to disable rules within a rule group or an entire
// rule group.
type ApplicationGatewayFirewallDisabledRuleGroup struct {
	// RuleGroupName - The name of the rule group that will be disabled.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
	Rules *[]int32 `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallExclusion allow to exclude some variable satisfy the condition for the WAF
// check.
type ApplicationGatewayFirewallExclusion struct {
	// MatchVariable - The variable to be excluded.
	MatchVariable *string `json:"matchVariable,omitempty"`
	// SelectorMatchOperator - When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
	SelectorMatchOperator *string `json:"selectorMatchOperator,omitempty"`
	// Selector - When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
	Selector *string `json:"selector,omitempty"`
}

// ApplicationGatewayFirewallManifestRuleSet properties of the web application firewall rule set.
type ApplicationGatewayFirewallManifestRuleSet struct {
	// RuleSetType - The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// Status - The rule set status. Possible values include: 'Preview', 'GA', 'Supported', 'Deprecated'
	Status ApplicationGatewayRuleSetStatusOptions `json:"status,omitempty"`
	// Tiers - Tier of an application gateway that support the rule set.
	Tiers *[]ApplicationGatewayTierTypes `json:"tiers,omitempty"`
	// RuleGroups - The rule groups of the web application firewall rule set.
	RuleGroups *[]ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`
}

// ApplicationGatewayFirewallRule a web application firewall rule.
type ApplicationGatewayFirewallRule struct {
	// RuleID - The identifier of the web application firewall rule.
	RuleID *int32 `json:"ruleId,omitempty"`
	// RuleIDString - The string representation of the web application firewall rule identifier.
	RuleIDString *string `json:"ruleIdString,omitempty"`
	// State - The string representation of the web application firewall rule state. Possible values include: 'ApplicationGatewayWafRuleStateTypesEnabled', 'ApplicationGatewayWafRuleStateTypesDisabled'
	State ApplicationGatewayWafRuleStateTypes `json:"state,omitempty"`
	// Action - The string representation of the web application firewall rule action. Possible values include: 'ApplicationGatewayWafRuleActionTypesNone', 'ApplicationGatewayWafRuleActionTypesAnomalyScoring', 'ApplicationGatewayWafRuleActionTypesAllow', 'ApplicationGatewayWafRuleActionTypesBlock', 'ApplicationGatewayWafRuleActionTypesLog'
	Action ApplicationGatewayWafRuleActionTypes `json:"action,omitempty"`
	// Description - The description of the web application firewall rule.
	Description *string `json:"description,omitempty"`
}

// ApplicationGatewayFirewallRuleGroup a web application firewall rule group.
type ApplicationGatewayFirewallRuleGroup struct {
	// RuleGroupName - The name of the web application firewall rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Description - The description of the web application firewall rule group.
	Description *string `json:"description,omitempty"`
	// Rules - The rules of the web application firewall rule group.
	Rules *[]ApplicationGatewayFirewallRule `json:"rules,omitempty"`
}

// ApplicationGatewayFirewallRuleSet a web application firewall rule set.
type ApplicationGatewayFirewallRuleSet struct {
	// ApplicationGatewayFirewallRuleSetPropertiesFormat - Properties of the application gateway firewall rule set.
	*ApplicationGatewayFirewallRuleSetPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFirewallRuleSet.
func (agfrs ApplicationGatewayFirewallRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat != nil {
		objectMap["properties"] = agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat
	}
	if agfrs.ID != nil {
		objectMap["id"] = agfrs.ID
	}
	if agfrs.Location != nil {
		objectMap["location"] = agfrs.Location
	}
	if agfrs.Tags != nil {
		objectMap["tags"] = agfrs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFirewallRuleSet struct.
func (agfrs *ApplicationGatewayFirewallRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFirewallRuleSetPropertiesFormat ApplicationGatewayFirewallRuleSetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFirewallRuleSetPropertiesFormat)
				if err != nil {
					return err
				}
				agfrs.ApplicationGatewayFirewallRuleSetPropertiesFormat = &applicationGatewayFirewallRuleSetPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfrs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfrs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agfrs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agfrs.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayFirewallRuleSetPropertiesFormat properties of the web application firewall rule set.
type ApplicationGatewayFirewallRuleSetPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the web application firewall rule set. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// RuleSetType - The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - The rule groups of the web application firewall rule set.
	RuleGroups *[]ApplicationGatewayFirewallRuleGroup `json:"ruleGroups,omitempty"`
	// Tiers - Tier of an application gateway that support the rule set.
	Tiers *[]ApplicationGatewayTierTypes `json:"tiers,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFirewallRuleSetPropertiesFormat.
func (agfrspf ApplicationGatewayFirewallRuleSetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfrspf.RuleSetType != nil {
		objectMap["ruleSetType"] = agfrspf.RuleSetType
	}
	if agfrspf.RuleSetVersion != nil {
		objectMap["ruleSetVersion"] = agfrspf.RuleSetVersion
	}
	if agfrspf.RuleGroups != nil {
		objectMap["ruleGroups"] = agfrspf.RuleGroups
	}
	if agfrspf.Tiers != nil {
		objectMap["tiers"] = agfrspf.Tiers
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	// ApplicationGatewayFrontendIPConfigurationPropertiesFormat - Properties of the application gateway frontend IP configuration.
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the frontend IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of an
// application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference to the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference to the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// PrivateLinkConfiguration - Reference to the application gateway private link configuration.
	PrivateLinkConfiguration *SubResource `json:"privateLinkConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the frontend IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfigurationPropertiesFormat.
func (agficpf ApplicationGatewayFrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agficpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = agficpf.PrivateIPAddress
	}
	if agficpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = agficpf.PrivateIPAllocationMethod
	}
	if agficpf.Subnet != nil {
		objectMap["subnet"] = agficpf.Subnet
	}
	if agficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = agficpf.PublicIPAddress
	}
	if agficpf.PrivateLinkConfiguration != nil {
		objectMap["privateLinkConfiguration"] = agficpf.PrivateLinkConfiguration
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayFrontendPort frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	// ApplicationGatewayFrontendPortPropertiesFormat - Properties of the application gateway frontend port.
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the frontend port that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agfp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Frontend port.
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the frontend port resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPortPropertiesFormat.
func (agfppf ApplicationGatewayFrontendPortPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfppf.Port != nil {
		objectMap["port"] = agfppf.Port
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayGlobalConfiguration application Gateway global configuration.
type ApplicationGatewayGlobalConfiguration struct {
	// EnableRequestBuffering - Enable request buffering.
	EnableRequestBuffering *bool `json:"enableRequestBuffering,omitempty"`
	// EnableResponseBuffering - Enable response buffering.
	EnableResponseBuffering *bool `json:"enableResponseBuffering,omitempty"`
}

// ApplicationGatewayHeaderConfiguration header configuration of the Actions set in Application Gateway.
type ApplicationGatewayHeaderConfiguration struct {
	// HeaderName - Header name of the header configuration.
	HeaderName *string `json:"headerName,omitempty"`
	// HeaderValue - Header value of the header configuration.
	HeaderValue *string `json:"headerValue,omitempty"`
}

// ApplicationGatewayHTTPListener http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	// ApplicationGatewayHTTPListenerPropertiesFormat - Properties of the application gateway HTTP listener.
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the HTTP listener that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aghl.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayHTTPListenerPropertiesFormat properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol of the HTTP listener. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// HostName - Host name of HTTP listener.
	HostName *string `json:"hostName,omitempty"`
	// SslCertificate - SSL certificate resource of an application gateway.
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// SslProfile - SSL profile resource of the application gateway.
	SslProfile *SubResource `json:"sslProfile,omitempty"`
	// RequireServerNameIndication - Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the HTTP listener resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CustomErrorConfigurations - Custom error configurations of the HTTP listener.
	CustomErrorConfigurations *[]ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`
	// FirewallPolicy - Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
	// HostNames - List of Host names for HTTP Listener that allows special wildcard characters as well.
	HostNames *[]string `json:"hostNames,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListenerPropertiesFormat.
func (aghlpf ApplicationGatewayHTTPListenerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghlpf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = aghlpf.FrontendIPConfiguration
	}
	if aghlpf.FrontendPort != nil {
		objectMap["frontendPort"] = aghlpf.FrontendPort
	}
	if aghlpf.Protocol != "" {
		objectMap["protocol"] = aghlpf.Protocol
	}
	if aghlpf.HostName != nil {
		objectMap["hostName"] = aghlpf.HostName
	}
	if aghlpf.SslCertificate != nil {
		objectMap["sslCertificate"] = aghlpf.SslCertificate
	}
	if aghlpf.SslProfile != nil {
		objectMap["sslProfile"] = aghlpf.SslProfile
	}
	if aghlpf.RequireServerNameIndication != nil {
		objectMap["requireServerNameIndication"] = aghlpf.RequireServerNameIndication
	}
	if aghlpf.CustomErrorConfigurations != nil {
		objectMap["customErrorConfigurations"] = aghlpf.CustomErrorConfigurations
	}
	if aghlpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = aghlpf.FirewallPolicy
	}
	if aghlpf.HostNames != nil {
		objectMap["hostNames"] = aghlpf.HostNames
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayIPConfiguration IP configuration of an application gateway. Currently 1 public and 1
// private IP configuration is allowed.
type ApplicationGatewayIPConfiguration struct {
	// ApplicationGatewayIPConfigurationPropertiesFormat - Properties of the application gateway IP configuration.
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the IP configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of an application
// gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Reference to the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application gateway IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfigurationPropertiesFormat.
func (agicpf ApplicationGatewayIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agicpf.Subnet != nil {
		objectMap["subnet"] = agicpf.Subnet
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayListener listener of an application gateway.
type ApplicationGatewayListener struct {
	// ApplicationGatewayListenerPropertiesFormat - Properties of the application gateway listener.
	*ApplicationGatewayListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the listener that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayListener.
func (agl ApplicationGatewayListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agl.ApplicationGatewayListenerPropertiesFormat != nil {
		objectMap["properties"] = agl.ApplicationGatewayListenerPropertiesFormat
	}
	if agl.Name != nil {
		objectMap["name"] = agl.Name
	}
	if agl.ID != nil {
		objectMap["id"] = agl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayListener struct.
func (agl *ApplicationGatewayListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayListenerPropertiesFormat ApplicationGatewayListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayListenerPropertiesFormat)
				if err != nil {
					return err
				}
				agl.ApplicationGatewayListenerPropertiesFormat = &applicationGatewayListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agl.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agl.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayListenerPropertiesFormat properties of listener of an application gateway.
type ApplicationGatewayListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol of the listener. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// SslCertificate - SSL certificate resource of an application gateway.
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// SslProfile - SSL profile resource of the application gateway.
	SslProfile *SubResource `json:"sslProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the listener resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayListenerPropertiesFormat.
func (aglpf ApplicationGatewayListenerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aglpf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = aglpf.FrontendIPConfiguration
	}
	if aglpf.FrontendPort != nil {
		objectMap["frontendPort"] = aglpf.FrontendPort
	}
	if aglpf.Protocol != "" {
		objectMap["protocol"] = aglpf.Protocol
	}
	if aglpf.SslCertificate != nil {
		objectMap["sslCertificate"] = aglpf.SslCertificate
	}
	if aglpf.SslProfile != nil {
		objectMap["sslProfile"] = aglpf.SslProfile
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayListResult response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - List of an application gateways in a resource group.
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayListResultIterator type.
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return ApplicationGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aglr ApplicationGatewayListResult) hasNextLink() bool {
	return aglr.NextLink != nil && len(*aglr.NextLink) != 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aglr)
		if err != nil {
			return err
		}
		page.aglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// Creates a new instance of the ApplicationGatewayListResultPage type.
func NewApplicationGatewayListResultPage(cur ApplicationGatewayListResult, getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return ApplicationGatewayListResultPage{
		fn:   getNextPage,
		aglr: cur,
	}
}

// ApplicationGatewayLoadDistributionPolicy load Distribution Policy of an application gateway.
type ApplicationGatewayLoadDistributionPolicy struct {
	// ApplicationGatewayLoadDistributionPolicyPropertiesFormat - Properties of the application gateway load distribution policy.
	*ApplicationGatewayLoadDistributionPolicyPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the load distribution policy that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayLoadDistributionPolicy.
func (agldp ApplicationGatewayLoadDistributionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agldp.ApplicationGatewayLoadDistributionPolicyPropertiesFormat != nil {
		objectMap["properties"] = agldp.ApplicationGatewayLoadDistributionPolicyPropertiesFormat
	}
	if agldp.Name != nil {
		objectMap["name"] = agldp.Name
	}
	if agldp.ID != nil {
		objectMap["id"] = agldp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayLoadDistributionPolicy struct.
func (agldp *ApplicationGatewayLoadDistributionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayLoadDistributionPolicyPropertiesFormat ApplicationGatewayLoadDistributionPolicyPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayLoadDistributionPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				agldp.ApplicationGatewayLoadDistributionPolicyPropertiesFormat = &applicationGatewayLoadDistributionPolicyPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agldp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agldp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agldp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agldp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayLoadDistributionPolicyPropertiesFormat properties of Load Distribution Policy of an
// application gateway.
type ApplicationGatewayLoadDistributionPolicyPropertiesFormat struct {
	// LoadDistributionTargets - Load Distribution Targets resource of an application gateway.
	LoadDistributionTargets *[]ApplicationGatewayLoadDistributionTarget `json:"loadDistributionTargets,omitempty"`
	// LoadDistributionAlgorithm - Load Distribution Targets resource of an application gateway. Possible values include: 'RoundRobin', 'LeastConnections', 'IPHash'
	LoadDistributionAlgorithm ApplicationGatewayLoadDistributionAlgorithm `json:"loadDistributionAlgorithm,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the Load Distribution Policy resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayLoadDistributionPolicyPropertiesFormat.
func (agldppf ApplicationGatewayLoadDistributionPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agldppf.LoadDistributionTargets != nil {
		objectMap["loadDistributionTargets"] = agldppf.LoadDistributionTargets
	}
	if agldppf.LoadDistributionAlgorithm != "" {
		objectMap["loadDistributionAlgorithm"] = agldppf.LoadDistributionAlgorithm
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayLoadDistributionTarget load Distribution Target of an application gateway.
type ApplicationGatewayLoadDistributionTarget struct {
	// ApplicationGatewayLoadDistributionTargetPropertiesFormat - Properties of the application gateway load distribution target.
	*ApplicationGatewayLoadDistributionTargetPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the load distribution policy that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayLoadDistributionTarget.
func (agldt ApplicationGatewayLoadDistributionTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agldt.ApplicationGatewayLoadDistributionTargetPropertiesFormat != nil {
		objectMap["properties"] = agldt.ApplicationGatewayLoadDistributionTargetPropertiesFormat
	}
	if agldt.Name != nil {
		objectMap["name"] = agldt.Name
	}
	if agldt.ID != nil {
		objectMap["id"] = agldt.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayLoadDistributionTarget struct.
func (agldt *ApplicationGatewayLoadDistributionTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayLoadDistributionTargetPropertiesFormat ApplicationGatewayLoadDistributionTargetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayLoadDistributionTargetPropertiesFormat)
				if err != nil {
					return err
				}
				agldt.ApplicationGatewayLoadDistributionTargetPropertiesFormat = &applicationGatewayLoadDistributionTargetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agldt.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agldt.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agldt.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agldt.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayLoadDistributionTargetPropertiesFormat ...
type ApplicationGatewayLoadDistributionTargetPropertiesFormat struct {
	// WeightPerServer - Weight per server. Range between 1 and 100.
	WeightPerServer *int32 `json:"weightPerServer,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
}

// ApplicationGatewayOnDemandProbe details of on demand test probe request.
type ApplicationGatewayOnDemandProbe struct {
	// Protocol - The protocol used for the probe. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
	Path *string `json:"path,omitempty"`
	// Timeout - The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// PickHostNameFromBackendHTTPSettings - Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`
	// Match - Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`
	// BackendAddressPool - Reference to backend pool of application gateway to which probe request will be sent.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Reference to backend http setting of application gateway to be used for test probe.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
}

// ApplicationGatewayPathRule path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	// ApplicationGatewayPathRulePropertiesFormat - Properties of the application gateway path rule.
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the path rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRule.
func (agpr ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpr.ApplicationGatewayPathRulePropertiesFormat != nil {
		objectMap["properties"] = agpr.ApplicationGatewayPathRulePropertiesFormat
	}
	if agpr.Name != nil {
		objectMap["name"] = agpr.Name
	}
	if agpr.ID != nil {
		objectMap["id"] = agpr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPathRule struct.
func (agpr *ApplicationGatewayPathRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPathRulePropertiesFormat ApplicationGatewayPathRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPathRulePropertiesFormat)
				if err != nil {
					return err
				}
				agpr.ApplicationGatewayPathRulePropertiesFormat = &applicationGatewayPathRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agpr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPathRulePropertiesFormat properties of path rule of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Paths - Path rules of URL path map.
	Paths *[]string `json:"paths,omitempty"`
	// BackendAddressPool - Backend address pool resource of URL path map path rule.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of URL path map path rule.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// RedirectConfiguration - Redirect configuration resource of URL path map path rule.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`
	// RewriteRuleSet - Rewrite rule set resource of URL path map path rule.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`
	// LoadDistributionPolicy - Load Distribution Policy resource of URL path map path rule.
	LoadDistributionPolicy *SubResource `json:"loadDistributionPolicy,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the path rule resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// FirewallPolicy - Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRulePropertiesFormat.
func (agprpf ApplicationGatewayPathRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agprpf.Paths != nil {
		objectMap["paths"] = agprpf.Paths
	}
	if agprpf.BackendAddressPool != nil {
		objectMap["backendAddressPool"] = agprpf.BackendAddressPool
	}
	if agprpf.BackendHTTPSettings != nil {
		objectMap["backendHttpSettings"] = agprpf.BackendHTTPSettings
	}
	if agprpf.RedirectConfiguration != nil {
		objectMap["redirectConfiguration"] = agprpf.RedirectConfiguration
	}
	if agprpf.RewriteRuleSet != nil {
		objectMap["rewriteRuleSet"] = agprpf.RewriteRuleSet
	}
	if agprpf.LoadDistributionPolicy != nil {
		objectMap["loadDistributionPolicy"] = agprpf.LoadDistributionPolicy
	}
	if agprpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = agprpf.FirewallPolicy
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayPrivateEndpointConnection private Endpoint connection on an application gateway.
type ApplicationGatewayPrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ApplicationGatewayPrivateEndpointConnectionProperties - Properties of the application gateway private endpoint connection.
	*ApplicationGatewayPrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// Name - Name of the private endpoint connection on an application gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateEndpointConnection.
func (agpec ApplicationGatewayPrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpec.ApplicationGatewayPrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = agpec.ApplicationGatewayPrivateEndpointConnectionProperties
	}
	if agpec.Name != nil {
		objectMap["name"] = agpec.Name
	}
	if agpec.ID != nil {
		objectMap["id"] = agpec.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPrivateEndpointConnection struct.
func (agpec *ApplicationGatewayPrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPrivateEndpointConnectionProperties ApplicationGatewayPrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &applicationGatewayPrivateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				agpec.ApplicationGatewayPrivateEndpointConnectionProperties = &applicationGatewayPrivateEndpointConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpec.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpec.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agpec.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpec.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPrivateEndpointConnectionListResult response for
// ListApplicationGatewayPrivateEndpointConnection API service call. Gets all private endpoint connections
// for an application gateway.
type ApplicationGatewayPrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - List of private endpoint connections on an application gateway.
	Value *[]ApplicationGatewayPrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayPrivateEndpointConnectionListResultIterator provides access to a complete listing of
// ApplicationGatewayPrivateEndpointConnection values.
type ApplicationGatewayPrivateEndpointConnectionListResultIterator struct {
	i    int
	page ApplicationGatewayPrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayPrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayPrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayPrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayPrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayPrivateEndpointConnectionListResultIterator) Response() ApplicationGatewayPrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayPrivateEndpointConnectionListResultIterator) Value() ApplicationGatewayPrivateEndpointConnection {
	if !iter.page.NotDone() {
		return ApplicationGatewayPrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayPrivateEndpointConnectionListResultIterator type.
func NewApplicationGatewayPrivateEndpointConnectionListResultIterator(page ApplicationGatewayPrivateEndpointConnectionListResultPage) ApplicationGatewayPrivateEndpointConnectionListResultIterator {
	return ApplicationGatewayPrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agpeclr ApplicationGatewayPrivateEndpointConnectionListResult) IsEmpty() bool {
	return agpeclr.Value == nil || len(*agpeclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agpeclr ApplicationGatewayPrivateEndpointConnectionListResult) hasNextLink() bool {
	return agpeclr.NextLink != nil && len(*agpeclr.NextLink) != 0
}

// applicationGatewayPrivateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agpeclr ApplicationGatewayPrivateEndpointConnectionListResult) applicationGatewayPrivateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !agpeclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agpeclr.NextLink)))
}

// ApplicationGatewayPrivateEndpointConnectionListResultPage contains a page of
// ApplicationGatewayPrivateEndpointConnection values.
type ApplicationGatewayPrivateEndpointConnectionListResultPage struct {
	fn      func(context.Context, ApplicationGatewayPrivateEndpointConnectionListResult) (ApplicationGatewayPrivateEndpointConnectionListResult, error)
	agpeclr ApplicationGatewayPrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayPrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayPrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agpeclr)
		if err != nil {
			return err
		}
		page.agpeclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayPrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayPrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.agpeclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayPrivateEndpointConnectionListResultPage) Response() ApplicationGatewayPrivateEndpointConnectionListResult {
	return page.agpeclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayPrivateEndpointConnectionListResultPage) Values() []ApplicationGatewayPrivateEndpointConnection {
	if page.agpeclr.IsEmpty() {
		return nil
	}
	return *page.agpeclr.Value
}

// Creates a new instance of the ApplicationGatewayPrivateEndpointConnectionListResultPage type.
func NewApplicationGatewayPrivateEndpointConnectionListResultPage(cur ApplicationGatewayPrivateEndpointConnectionListResult, getNextPage func(context.Context, ApplicationGatewayPrivateEndpointConnectionListResult) (ApplicationGatewayPrivateEndpointConnectionListResult, error)) ApplicationGatewayPrivateEndpointConnectionListResultPage {
	return ApplicationGatewayPrivateEndpointConnectionListResultPage{
		fn:      getNextPage,
		agpeclr: cur,
	}
}

// ApplicationGatewayPrivateEndpointConnectionProperties properties of Private Link Resource of an
// application gateway.
type ApplicationGatewayPrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - READ-ONLY; The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application gateway private endpoint connection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// LinkIdentifier - READ-ONLY; The consumer link id.
	LinkIdentifier *string `json:"linkIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateEndpointConnectionProperties.
func (agpecp ApplicationGatewayPrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = agpecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayPrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ApplicationGatewayPrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewayPrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewayPrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewayPrivateEndpointConnectionsDeleteFuture.Result.
func (future *ApplicationGatewayPrivateEndpointConnectionsDeleteFuture) result(client ApplicationGatewayPrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewayPrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewayPrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewayPrivateEndpointConnectionsUpdateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ApplicationGatewayPrivateEndpointConnectionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewayPrivateEndpointConnectionsClient) (ApplicationGatewayPrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewayPrivateEndpointConnectionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewayPrivateEndpointConnectionsUpdateFuture.Result.
func (future *ApplicationGatewayPrivateEndpointConnectionsUpdateFuture) result(client ApplicationGatewayPrivateEndpointConnectionsClient) (agpec ApplicationGatewayPrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewayPrivateEndpointConnectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		agpec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewayPrivateEndpointConnectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if agpec.Response.Response, err = future.GetResult(sender); err == nil && agpec.Response.Response.StatusCode != http.StatusNoContent {
		agpec, err = client.UpdateResponder(agpec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewayPrivateEndpointConnectionsUpdateFuture", "Result", agpec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationGatewayPrivateLinkConfiguration private Link Configuration on an application gateway.
type ApplicationGatewayPrivateLinkConfiguration struct {
	// ApplicationGatewayPrivateLinkConfigurationProperties - Properties of the application gateway private link configuration.
	*ApplicationGatewayPrivateLinkConfigurationProperties `json:"properties,omitempty"`
	// Name - Name of the private link configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkConfiguration.
func (agplc ApplicationGatewayPrivateLinkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplc.ApplicationGatewayPrivateLinkConfigurationProperties != nil {
		objectMap["properties"] = agplc.ApplicationGatewayPrivateLinkConfigurationProperties
	}
	if agplc.Name != nil {
		objectMap["name"] = agplc.Name
	}
	if agplc.ID != nil {
		objectMap["id"] = agplc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPrivateLinkConfiguration struct.
func (agplc *ApplicationGatewayPrivateLinkConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPrivateLinkConfigurationProperties ApplicationGatewayPrivateLinkConfigurationProperties
				err = json.Unmarshal(*v, &applicationGatewayPrivateLinkConfigurationProperties)
				if err != nil {
					return err
				}
				agplc.ApplicationGatewayPrivateLinkConfigurationProperties = &applicationGatewayPrivateLinkConfigurationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agplc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agplc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agplc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agplc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPrivateLinkConfigurationProperties properties of private link configuration on an
// application gateway.
type ApplicationGatewayPrivateLinkConfigurationProperties struct {
	// IPConfigurations - An array of application gateway private link ip configurations.
	IPConfigurations *[]ApplicationGatewayPrivateLinkIPConfiguration `json:"ipConfigurations,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application gateway private link configuration. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkConfigurationProperties.
func (agplcp ApplicationGatewayPrivateLinkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplcp.IPConfigurations != nil {
		objectMap["ipConfigurations"] = agplcp.IPConfigurations
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayPrivateLinkIPConfiguration the application gateway private link ip configuration.
type ApplicationGatewayPrivateLinkIPConfiguration struct {
	// ApplicationGatewayPrivateLinkIPConfigurationProperties - Properties of an application gateway private link ip configuration.
	*ApplicationGatewayPrivateLinkIPConfigurationProperties `json:"properties,omitempty"`
	// Name - The name of application gateway private link ip configuration.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkIPConfiguration.
func (agplic ApplicationGatewayPrivateLinkIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplic.ApplicationGatewayPrivateLinkIPConfigurationProperties != nil {
		objectMap["properties"] = agplic.ApplicationGatewayPrivateLinkIPConfigurationProperties
	}
	if agplic.Name != nil {
		objectMap["name"] = agplic.Name
	}
	if agplic.ID != nil {
		objectMap["id"] = agplic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPrivateLinkIPConfiguration struct.
func (agplic *ApplicationGatewayPrivateLinkIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPrivateLinkIPConfigurationProperties ApplicationGatewayPrivateLinkIPConfigurationProperties
				err = json.Unmarshal(*v, &applicationGatewayPrivateLinkIPConfigurationProperties)
				if err != nil {
					return err
				}
				agplic.ApplicationGatewayPrivateLinkIPConfigurationProperties = &applicationGatewayPrivateLinkIPConfigurationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agplic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agplic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agplic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agplic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPrivateLinkIPConfigurationProperties properties of an application gateway private link
// IP configuration.
type ApplicationGatewayPrivateLinkIPConfigurationProperties struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference to the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// Primary - Whether the ip configuration is primary or not.
	Primary *bool `json:"primary,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application gateway private link IP configuration. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkIPConfigurationProperties.
func (agplicp ApplicationGatewayPrivateLinkIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplicp.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = agplicp.PrivateIPAddress
	}
	if agplicp.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = agplicp.PrivateIPAllocationMethod
	}
	if agplicp.Subnet != nil {
		objectMap["subnet"] = agplicp.Subnet
	}
	if agplicp.Primary != nil {
		objectMap["primary"] = agplicp.Primary
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayPrivateLinkResource privateLink Resource of an application gateway.
type ApplicationGatewayPrivateLinkResource struct {
	// ApplicationGatewayPrivateLinkResourceProperties - Properties of the application gateway private link resource.
	*ApplicationGatewayPrivateLinkResourceProperties `json:"properties,omitempty"`
	// Name - Name of the private link resource that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkResource.
func (agplr ApplicationGatewayPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplr.ApplicationGatewayPrivateLinkResourceProperties != nil {
		objectMap["properties"] = agplr.ApplicationGatewayPrivateLinkResourceProperties
	}
	if agplr.Name != nil {
		objectMap["name"] = agplr.Name
	}
	if agplr.ID != nil {
		objectMap["id"] = agplr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPrivateLinkResource struct.
func (agplr *ApplicationGatewayPrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPrivateLinkResourceProperties ApplicationGatewayPrivateLinkResourceProperties
				err = json.Unmarshal(*v, &applicationGatewayPrivateLinkResourceProperties)
				if err != nil {
					return err
				}
				agplr.ApplicationGatewayPrivateLinkResourceProperties = &applicationGatewayPrivateLinkResourceProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agplr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agplr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agplr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agplr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPrivateLinkResourceListResult response for ListApplicationGatewayPrivateLinkResources
// API service call. Gets all private link resources for an application gateway.
type ApplicationGatewayPrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - List of private link resources of an application gateway.
	Value *[]ApplicationGatewayPrivateLinkResource `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayPrivateLinkResourceListResultIterator provides access to a complete listing of
// ApplicationGatewayPrivateLinkResource values.
type ApplicationGatewayPrivateLinkResourceListResultIterator struct {
	i    int
	page ApplicationGatewayPrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayPrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayPrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayPrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayPrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayPrivateLinkResourceListResultIterator) Response() ApplicationGatewayPrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayPrivateLinkResourceListResultIterator) Value() ApplicationGatewayPrivateLinkResource {
	if !iter.page.NotDone() {
		return ApplicationGatewayPrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayPrivateLinkResourceListResultIterator type.
func NewApplicationGatewayPrivateLinkResourceListResultIterator(page ApplicationGatewayPrivateLinkResourceListResultPage) ApplicationGatewayPrivateLinkResourceListResultIterator {
	return ApplicationGatewayPrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agplrlr ApplicationGatewayPrivateLinkResourceListResult) IsEmpty() bool {
	return agplrlr.Value == nil || len(*agplrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agplrlr ApplicationGatewayPrivateLinkResourceListResult) hasNextLink() bool {
	return agplrlr.NextLink != nil && len(*agplrlr.NextLink) != 0
}

// applicationGatewayPrivateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agplrlr ApplicationGatewayPrivateLinkResourceListResult) applicationGatewayPrivateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !agplrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agplrlr.NextLink)))
}

// ApplicationGatewayPrivateLinkResourceListResultPage contains a page of
// ApplicationGatewayPrivateLinkResource values.
type ApplicationGatewayPrivateLinkResourceListResultPage struct {
	fn      func(context.Context, ApplicationGatewayPrivateLinkResourceListResult) (ApplicationGatewayPrivateLinkResourceListResult, error)
	agplrlr ApplicationGatewayPrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayPrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayPrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agplrlr)
		if err != nil {
			return err
		}
		page.agplrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayPrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayPrivateLinkResourceListResultPage) NotDone() bool {
	return !page.agplrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayPrivateLinkResourceListResultPage) Response() ApplicationGatewayPrivateLinkResourceListResult {
	return page.agplrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayPrivateLinkResourceListResultPage) Values() []ApplicationGatewayPrivateLinkResource {
	if page.agplrlr.IsEmpty() {
		return nil
	}
	return *page.agplrlr.Value
}

// Creates a new instance of the ApplicationGatewayPrivateLinkResourceListResultPage type.
func NewApplicationGatewayPrivateLinkResourceListResultPage(cur ApplicationGatewayPrivateLinkResourceListResult, getNextPage func(context.Context, ApplicationGatewayPrivateLinkResourceListResult) (ApplicationGatewayPrivateLinkResourceListResult, error)) ApplicationGatewayPrivateLinkResourceListResultPage {
	return ApplicationGatewayPrivateLinkResourceListResultPage{
		fn:      getNextPage,
		agplrlr: cur,
	}
}

// ApplicationGatewayPrivateLinkResourceProperties properties of a private link resource.
type ApplicationGatewayPrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; Required member names of private link resource.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - Required DNS zone names of the the private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPrivateLinkResourceProperties.
func (agplrp ApplicationGatewayPrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agplrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = agplrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayProbe probe of the application gateway.
type ApplicationGatewayProbe struct {
	// ApplicationGatewayProbePropertiesFormat - Properties of the application gateway probe.
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the probe that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbe.
func (agp ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.ApplicationGatewayProbePropertiesFormat != nil {
		objectMap["properties"] = agp.ApplicationGatewayProbePropertiesFormat
	}
	if agp.Name != nil {
		objectMap["name"] = agp.Name
	}
	if agp.ID != nil {
		objectMap["id"] = agp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayProbe struct.
func (agp *ApplicationGatewayProbe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayProbePropertiesFormat ApplicationGatewayProbePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayProbePropertiesFormat)
				if err != nil {
					return err
				}
				agp.ApplicationGatewayProbePropertiesFormat = &applicationGatewayProbePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayProbeHealthResponseMatch application gateway probe health response match.
type ApplicationGatewayProbeHealthResponseMatch struct {
	// Body - Body that must be contained in the health response. Default value is empty.
	Body *string `json:"body,omitempty"`
	// StatusCodes - Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
	StatusCodes *[]string `json:"statusCodes,omitempty"`
}

// ApplicationGatewayProbePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Protocol - The protocol used for the probe. Possible values include: 'HTTP', 'HTTPS', 'TCP', 'TLS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
	Path *string `json:"path,omitempty"`
	// Interval - The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
	Interval *int32 `json:"interval,omitempty"`
	// Timeout - The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// UnhealthyThreshold - The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`
	// PickHostNameFromBackendHTTPSettings - Whether the host header should be picked from the backend http settings. Default value is false.
	PickHostNameFromBackendHTTPSettings *bool `json:"pickHostNameFromBackendHttpSettings,omitempty"`
	// PickHostNameFromBackendSettings - Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
	PickHostNameFromBackendSettings *bool `json:"pickHostNameFromBackendSettings,omitempty"`
	// MinServers - Minimum number of servers that are always marked healthy. Default value is 0.
	MinServers *int32 `json:"minServers,omitempty"`
	// Match - Criterion for classifying a healthy probe response.
	Match *ApplicationGatewayProbeHealthResponseMatch `json:"match,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the probe resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Port - Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
	Port *int32 `json:"port,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbePropertiesFormat.
func (agppf ApplicationGatewayProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agppf.Protocol != "" {
		objectMap["protocol"] = agppf.Protocol
	}
	if agppf.Host != nil {
		objectMap["host"] = agppf.Host
	}
	if agppf.Path != nil {
		objectMap["path"] = agppf.Path
	}
	if agppf.Interval != nil {
		objectMap["interval"] = agppf.Interval
	}
	if agppf.Timeout != nil {
		objectMap["timeout"] = agppf.Timeout
	}
	if agppf.UnhealthyThreshold != nil {
		objectMap["unhealthyThreshold"] = agppf.UnhealthyThreshold
	}
	if agppf.PickHostNameFromBackendHTTPSettings != nil {
		objectMap["pickHostNameFromBackendHttpSettings"] = agppf.PickHostNameFromBackendHTTPSettings
	}
	if agppf.PickHostNameFromBackendSettings != nil {
		objectMap["pickHostNameFromBackendSettings"] = agppf.PickHostNameFromBackendSettings
	}
	if agppf.MinServers != nil {
		objectMap["minServers"] = agppf.MinServers
	}
	if agppf.Match != nil {
		objectMap["match"] = agppf.Match
	}
	if agppf.Port != nil {
		objectMap["port"] = agppf.Port
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayPropertiesFormat properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Sku - SKU of the application gateway resource.
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// SslPolicy - SSL policy of the application gateway resource.
	SslPolicy *ApplicationGatewaySslPolicy `json:"sslPolicy,omitempty"`
	// OperationalState - READ-ONLY; Operational state of the application gateway resource. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// AuthenticationCertificates - Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	AuthenticationCertificates *[]ApplicationGatewayAuthenticationCertificate `json:"authenticationCertificates,omitempty"`
	// TrustedRootCertificates - Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	TrustedRootCertificates *[]ApplicationGatewayTrustedRootCertificate `json:"trustedRootCertificates,omitempty"`
	// TrustedClientCertificates - Trusted client certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	TrustedClientCertificates *[]ApplicationGatewayTrustedClientCertificate `json:"trustedClientCertificates,omitempty"`
	// SslCertificates - SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// Probes - Probes of the application gateway resource.
	Probes *[]ApplicationGatewayProbe `json:"probes,omitempty"`
	// BackendAddressPools - Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// BackendSettingsCollection - Backend settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	BackendSettingsCollection *[]ApplicationGatewayBackendSettings `json:"backendSettingsCollection,omitempty"`
	// HTTPListeners - Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// Listeners - Listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	Listeners *[]ApplicationGatewayListener `json:"listeners,omitempty"`
	// SslProfiles - SSL profiles of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	SslProfiles *[]ApplicationGatewaySslProfile `json:"sslProfiles,omitempty"`
	// URLPathMaps - URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	URLPathMaps *[]ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`
	// RequestRoutingRules - Request routing rules of the application gateway resource.
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// RoutingRules - Routing rules of the application gateway resource.
	RoutingRules *[]ApplicationGatewayRoutingRule `json:"routingRules,omitempty"`
	// RewriteRuleSets - Rewrite rules for the application gateway resource.
	RewriteRuleSets *[]ApplicationGatewayRewriteRuleSet `json:"rewriteRuleSets,omitempty"`
	// RedirectConfigurations - Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
	RedirectConfigurations *[]ApplicationGatewayRedirectConfiguration `json:"redirectConfigurations,omitempty"`
	// WebApplicationFirewallConfiguration - Web application firewall configuration.
	WebApplicationFirewallConfiguration *ApplicationGatewayWebApplicationFirewallConfiguration `json:"webApplicationFirewallConfiguration,omitempty"`
	// FirewallPolicy - Reference to the FirewallPolicy resource.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
	// EnableHTTP2 - Whether HTTP2 is enabled on the application gateway resource.
	EnableHTTP2 *bool `json:"enableHttp2,omitempty"`
	// EnableFips - Whether FIPS is enabled on the application gateway resource.
	EnableFips *bool `json:"enableFips,omitempty"`
	// AutoscaleConfiguration - Autoscale Configuration.
	AutoscaleConfiguration *ApplicationGatewayAutoscaleConfiguration `json:"autoscaleConfiguration,omitempty"`
	// PrivateLinkConfigurations - PrivateLink configurations on application gateway.
	PrivateLinkConfigurations *[]ApplicationGatewayPrivateLinkConfiguration `json:"privateLinkConfigurations,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Private Endpoint connections on application gateway.
	PrivateEndpointConnections *[]ApplicationGatewayPrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the application gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application gateway resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CustomErrorConfigurations - Custom error configurations of the application gateway resource.
	CustomErrorConfigurations *[]ApplicationGatewayCustomError `json:"customErrorConfigurations,omitempty"`
	// ForceFirewallPolicyAssociation - If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
	ForceFirewallPolicyAssociation *bool `json:"forceFirewallPolicyAssociation,omitempty"`
	// LoadDistributionPolicies - Load distribution policies of the application gateway resource.
	LoadDistributionPolicies *[]ApplicationGatewayLoadDistributionPolicy `json:"loadDistributionPolicies,omitempty"`
	// GlobalConfiguration - Global Configuration.
	GlobalConfiguration *ApplicationGatewayGlobalConfiguration `json:"globalConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPropertiesFormat.
func (agpf ApplicationGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpf.Sku != nil {
		objectMap["sku"] = agpf.Sku
	}
	if agpf.SslPolicy != nil {
		objectMap["sslPolicy"] = agpf.SslPolicy
	}
	if agpf.GatewayIPConfigurations != nil {
		objectMap["gatewayIPConfigurations"] = agpf.GatewayIPConfigurations
	}
	if agpf.AuthenticationCertificates != nil {
		objectMap["authenticationCertificates"] = agpf.AuthenticationCertificates
	}
	if agpf.TrustedRootCertificates != nil {
		objectMap["trustedRootCertificates"] = agpf.TrustedRootCertificates
	}
	if agpf.TrustedClientCertificates != nil {
		objectMap["trustedClientCertificates"] = agpf.TrustedClientCertificates
	}
	if agpf.SslCertificates != nil {
		objectMap["sslCertificates"] = agpf.SslCertificates
	}
	if agpf.FrontendIPConfigurations != nil {
		objectMap["frontendIPConfigurations"] = agpf.FrontendIPConfigurations
	}
	if agpf.FrontendPorts != nil {
		objectMap["frontendPorts"] = agpf.FrontendPorts
	}
	if agpf.Probes != nil {
		objectMap["probes"] = agpf.Probes
	}
	if agpf.BackendAddressPools != nil {
		objectMap["backendAddressPools"] = agpf.BackendAddressPools
	}
	if agpf.BackendHTTPSettingsCollection != nil {
		objectMap["backendHttpSettingsCollection"] = agpf.BackendHTTPSettingsCollection
	}
	if agpf.BackendSettingsCollection != nil {
		objectMap["backendSettingsCollection"] = agpf.BackendSettingsCollection
	}
	if agpf.HTTPListeners != nil {
		objectMap["httpListeners"] = agpf.HTTPListeners
	}
	if agpf.Listeners != nil {
		objectMap["listeners"] = agpf.Listeners
	}
	if agpf.SslProfiles != nil {
		objectMap["sslProfiles"] = agpf.SslProfiles
	}
	if agpf.URLPathMaps != nil {
		objectMap["urlPathMaps"] = agpf.URLPathMaps
	}
	if agpf.RequestRoutingRules != nil {
		objectMap["requestRoutingRules"] = agpf.RequestRoutingRules
	}
	if agpf.RoutingRules != nil {
		objectMap["routingRules"] = agpf.RoutingRules
	}
	if agpf.RewriteRuleSets != nil {
		objectMap["rewriteRuleSets"] = agpf.RewriteRuleSets
	}
	if agpf.RedirectConfigurations != nil {
		objectMap["redirectConfigurations"] = agpf.RedirectConfigurations
	}
	if agpf.WebApplicationFirewallConfiguration != nil {
		objectMap["webApplicationFirewallConfiguration"] = agpf.WebApplicationFirewallConfiguration
	}
	if agpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = agpf.FirewallPolicy
	}
	if agpf.EnableHTTP2 != nil {
		objectMap["enableHttp2"] = agpf.EnableHTTP2
	}
	if agpf.EnableFips != nil {
		objectMap["enableFips"] = agpf.EnableFips
	}
	if agpf.AutoscaleConfiguration != nil {
		objectMap["autoscaleConfiguration"] = agpf.AutoscaleConfiguration
	}
	if agpf.PrivateLinkConfigurations != nil {
		objectMap["privateLinkConfigurations"] = agpf.PrivateLinkConfigurations
	}
	if agpf.CustomErrorConfigurations != nil {
		objectMap["customErrorConfigurations"] = agpf.CustomErrorConfigurations
	}
	if agpf.ForceFirewallPolicyAssociation != nil {
		objectMap["forceFirewallPolicyAssociation"] = agpf.ForceFirewallPolicyAssociation
	}
	if agpf.LoadDistributionPolicies != nil {
		objectMap["loadDistributionPolicies"] = agpf.LoadDistributionPolicies
	}
	if agpf.GlobalConfiguration != nil {
		objectMap["globalConfiguration"] = agpf.GlobalConfiguration
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayRedirectConfiguration redirect configuration of an application gateway.
type ApplicationGatewayRedirectConfiguration struct {
	// ApplicationGatewayRedirectConfigurationPropertiesFormat - Properties of the application gateway redirect configuration.
	*ApplicationGatewayRedirectConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the redirect configuration that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRedirectConfiguration.
func (agrc ApplicationGatewayRedirectConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat
	}
	if agrc.Name != nil {
		objectMap["name"] = agrc.Name
	}
	if agrc.ID != nil {
		objectMap["id"] = agrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRedirectConfiguration struct.
func (agrc *ApplicationGatewayRedirectConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRedirectConfigurationPropertiesFormat ApplicationGatewayRedirectConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRedirectConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agrc.ApplicationGatewayRedirectConfigurationPropertiesFormat = &applicationGatewayRedirectConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agrc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRedirectConfigurationPropertiesFormat properties of redirect configuration of the
// application gateway.
type ApplicationGatewayRedirectConfigurationPropertiesFormat struct {
	// RedirectType - HTTP redirection type. Possible values include: 'Permanent', 'Found', 'SeeOther', 'Temporary'
	RedirectType ApplicationGatewayRedirectType `json:"redirectType,omitempty"`
	// TargetListener - Reference to a listener to redirect the request to.
	TargetListener *SubResource `json:"targetListener,omitempty"`
	// TargetURL - Url to redirect the request to.
	TargetURL *string `json:"targetUrl,omitempty"`
	// IncludePath - Include path in the redirected url.
	IncludePath *bool `json:"includePath,omitempty"`
	// IncludeQueryString - Include query string in the redirected url.
	IncludeQueryString *bool `json:"includeQueryString,omitempty"`
	// RequestRoutingRules - Request routing specifying redirect configuration.
	RequestRoutingRules *[]SubResource `json:"requestRoutingRules,omitempty"`
	// URLPathMaps - Url path maps specifying default redirect configuration.
	URLPathMaps *[]SubResource `json:"urlPathMaps,omitempty"`
	// PathRules - Path rules specifying redirect configuration.
	PathRules *[]SubResource `json:"pathRules,omitempty"`
}

// ApplicationGatewayRequestRoutingRule request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	// ApplicationGatewayRequestRoutingRulePropertiesFormat - Properties of the application gateway request routing rule.
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the request routing rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agrrr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of request routing rule of the
// application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// Priority - Priority of the request routing rule.
	Priority *int32 `json:"priority,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of the application gateway.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Http listener resource of the application gateway.
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// URLPathMap - URL path map resource of the application gateway.
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`
	// RewriteRuleSet - Rewrite Rule Set resource in Basic rule of the application gateway.
	RewriteRuleSet *SubResource `json:"rewriteRuleSet,omitempty"`
	// RedirectConfiguration - Redirect configuration resource of the application gateway.
	RedirectConfiguration *SubResource `json:"redirectConfiguration,omitempty"`
	// LoadDistributionPolicy - Load Distribution Policy resource of the application gateway.
	LoadDistributionPolicy *SubResource `json:"loadDistributionPolicy,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the request routing rule resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRulePropertiesFormat.
func (agrrrpf ApplicationGatewayRequestRoutingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrrpf.RuleType != "" {
		objectMap["ruleType"] = agrrrpf.RuleType
	}
	if agrrrpf.Priority != nil {
		objectMap["priority"] = agrrrpf.Priority
	}
	if agrrrpf.BackendAddressPool != nil {
		objectMap["backendAddressPool"] = agrrrpf.BackendAddressPool
	}
	if agrrrpf.BackendHTTPSettings != nil {
		objectMap["backendHttpSettings"] = agrrrpf.BackendHTTPSettings
	}
	if agrrrpf.HTTPListener != nil {
		objectMap["httpListener"] = agrrrpf.HTTPListener
	}
	if agrrrpf.URLPathMap != nil {
		objectMap["urlPathMap"] = agrrrpf.URLPathMap
	}
	if agrrrpf.RewriteRuleSet != nil {
		objectMap["rewriteRuleSet"] = agrrrpf.RewriteRuleSet
	}
	if agrrrpf.RedirectConfiguration != nil {
		objectMap["redirectConfiguration"] = agrrrpf.RedirectConfiguration
	}
	if agrrrpf.LoadDistributionPolicy != nil {
		objectMap["loadDistributionPolicy"] = agrrrpf.LoadDistributionPolicy
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayRewriteRule rewrite rule of an application gateway.
type ApplicationGatewayRewriteRule struct {
	// Name - Name of the rewrite rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// RuleSequence - Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
	RuleSequence *int32 `json:"ruleSequence,omitempty"`
	// Conditions - Conditions based on which the action set execution will be evaluated.
	Conditions *[]ApplicationGatewayRewriteRuleCondition `json:"conditions,omitempty"`
	// ActionSet - Set of actions to be done as part of the rewrite Rule.
	ActionSet *ApplicationGatewayRewriteRuleActionSet `json:"actionSet,omitempty"`
}

// ApplicationGatewayRewriteRuleActionSet set of actions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleActionSet struct {
	// RequestHeaderConfigurations - Request Header Actions in the Action Set.
	RequestHeaderConfigurations *[]ApplicationGatewayHeaderConfiguration `json:"requestHeaderConfigurations,omitempty"`
	// ResponseHeaderConfigurations - Response Header Actions in the Action Set.
	ResponseHeaderConfigurations *[]ApplicationGatewayHeaderConfiguration `json:"responseHeaderConfigurations,omitempty"`
	// URLConfiguration - Url Configuration Action in the Action Set.
	URLConfiguration *ApplicationGatewayURLConfiguration `json:"urlConfiguration,omitempty"`
}

// ApplicationGatewayRewriteRuleCondition set of conditions in the Rewrite Rule in Application Gateway.
type ApplicationGatewayRewriteRuleCondition struct {
	// Variable - The condition parameter of the RewriteRuleCondition.
	Variable *string `json:"variable,omitempty"`
	// Pattern - The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
	Pattern *string `json:"pattern,omitempty"`
	// IgnoreCase - Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
	IgnoreCase *bool `json:"ignoreCase,omitempty"`
	// Negate - Setting this value as truth will force to check the negation of the condition given by the user.
	Negate *bool `json:"negate,omitempty"`
}

// ApplicationGatewayRewriteRuleSet rewrite rule set of an application gateway.
type ApplicationGatewayRewriteRuleSet struct {
	// ApplicationGatewayRewriteRuleSetPropertiesFormat - Properties of the application gateway rewrite rule set.
	*ApplicationGatewayRewriteRuleSetPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the rewrite rule set that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRewriteRuleSet.
func (agrrs ApplicationGatewayRewriteRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat != nil {
		objectMap["properties"] = agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat
	}
	if agrrs.Name != nil {
		objectMap["name"] = agrrs.Name
	}
	if agrrs.ID != nil {
		objectMap["id"] = agrrs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRewriteRuleSet struct.
func (agrrs *ApplicationGatewayRewriteRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRewriteRuleSetPropertiesFormat ApplicationGatewayRewriteRuleSetPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRewriteRuleSetPropertiesFormat)
				if err != nil {
					return err
				}
				agrrs.ApplicationGatewayRewriteRuleSetPropertiesFormat = &applicationGatewayRewriteRuleSetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRewriteRuleSetPropertiesFormat properties of rewrite rule set of the application
// gateway.
type ApplicationGatewayRewriteRuleSetPropertiesFormat struct {
	// RewriteRules - Rewrite rules in the rewrite rule set.
	RewriteRules *[]ApplicationGatewayRewriteRule `json:"rewriteRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the rewrite rule set resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRewriteRuleSetPropertiesFormat.
func (agrrspf ApplicationGatewayRewriteRuleSetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrspf.RewriteRules != nil {
		objectMap["rewriteRules"] = agrrspf.RewriteRules
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayRoutingRule routing rule of an application gateway.
type ApplicationGatewayRoutingRule struct {
	// ApplicationGatewayRoutingRulePropertiesFormat - Properties of the application gateway routing rule.
	*ApplicationGatewayRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the routing rule that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRoutingRule.
func (agrr ApplicationGatewayRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrr.ApplicationGatewayRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrr.ApplicationGatewayRoutingRulePropertiesFormat
	}
	if agrr.Name != nil {
		objectMap["name"] = agrr.Name
	}
	if agrr.ID != nil {
		objectMap["id"] = agrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRoutingRule struct.
func (agrr *ApplicationGatewayRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRoutingRulePropertiesFormat ApplicationGatewayRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrr.ApplicationGatewayRoutingRulePropertiesFormat = &applicationGatewayRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agrr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRoutingRulePropertiesFormat properties of routing rule of the application gateway.
type ApplicationGatewayRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// Priority - Priority of the routing rule.
	Priority *int32 `json:"priority,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendSettings - Backend settings resource of the application gateway.
	BackendSettings *SubResource `json:"backendSettings,omitempty"`
	// Listener - Listener resource of the application gateway.
	Listener *SubResource `json:"listener,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the request routing rule resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRoutingRulePropertiesFormat.
func (agrrpf ApplicationGatewayRoutingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrpf.RuleType != "" {
		objectMap["ruleType"] = agrrpf.RuleType
	}
	if agrrpf.Priority != nil {
		objectMap["priority"] = agrrpf.Priority
	}
	if agrrpf.BackendAddressPool != nil {
		objectMap["backendAddressPool"] = agrrpf.BackendAddressPool
	}
	if agrrpf.BackendSettings != nil {
		objectMap["backendSettings"] = agrrpf.BackendSettings
	}
	if agrrpf.Listener != nil {
		objectMap["listener"] = agrrpf.Listener
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewaysBackendHealthFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysBackendHealthFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGatewayBackendHealth, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysBackendHealthFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysBackendHealthFuture.Result.
func (future *ApplicationGatewaysBackendHealthFuture) result(client ApplicationGatewaysClient) (agbh ApplicationGatewayBackendHealth, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		agbh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysBackendHealthFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if agbh.Response.Response, err = future.GetResult(sender); err == nil && agbh.Response.Response.StatusCode != http.StatusNoContent {
		agbh, err = client.BackendHealthResponder(agbh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthFuture", "Result", agbh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationGatewaysBackendHealthOnDemandFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ApplicationGatewaysBackendHealthOnDemandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGatewayBackendHealthOnDemand, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysBackendHealthOnDemandFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysBackendHealthOnDemandFuture.Result.
func (future *ApplicationGatewaysBackendHealthOnDemandFuture) result(client ApplicationGatewaysClient) (agbhod ApplicationGatewayBackendHealthOnDemand, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthOnDemandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		agbhod.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysBackendHealthOnDemandFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if agbhod.Response.Response, err = future.GetResult(sender); err == nil && agbhod.Response.Response.StatusCode != http.StatusNoContent {
		agbhod, err = client.BackendHealthOnDemandResponder(agbhod.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysBackendHealthOnDemandFuture", "Result", agbhod.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (ApplicationGateway, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysCreateOrUpdateFuture.Result.
func (future *ApplicationGatewaysCreateOrUpdateFuture) result(client ApplicationGatewaysClient) (ag ApplicationGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ag.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ag.Response.Response, err = future.GetResult(sender); err == nil && ag.Response.Response.StatusCode != http.StatusNoContent {
		ag, err = client.CreateOrUpdateResponder(ag.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", ag.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysDeleteFuture.Result.
func (future *ApplicationGatewaysDeleteFuture) result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewaySku SKU of an application gateway.
type ApplicationGatewaySku struct {
	// Name - Name of an application gateway SKU. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge', 'WAFMedium', 'WAFLarge', 'StandardV2', 'WAFV2'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Tier of an application gateway. Possible values include: 'ApplicationGatewayTierStandard', 'ApplicationGatewayTierWAF', 'ApplicationGatewayTierStandardV2', 'ApplicationGatewayTierWAFV2'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Capacity (instance count) of an application gateway.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate SSL certificates of an application gateway.
type ApplicationGatewaySslCertificate struct {
	// ApplicationGatewaySslCertificatePropertiesFormat - Properties of the application gateway SSL certificate.
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the SSL certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agsc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of an application
// gateway.
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string `json:"data,omitempty"`
	// Password - Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string `json:"password,omitempty"`
	// PublicCertData - READ-ONLY; Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// KeyVaultSecretID - Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the SSL certificate resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificatePropertiesFormat.
func (agscpf ApplicationGatewaySslCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agscpf.Data != nil {
		objectMap["data"] = agscpf.Data
	}
	if agscpf.Password != nil {
		objectMap["password"] = agscpf.Password
	}
	if agscpf.KeyVaultSecretID != nil {
		objectMap["keyVaultSecretId"] = agscpf.KeyVaultSecretID
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewaySslPolicy application Gateway Ssl policy.
type ApplicationGatewaySslPolicy struct {
	// DisabledSslProtocols - Ssl protocols to be disabled on application gateway.
	DisabledSslProtocols *[]ApplicationGatewaySslProtocol `json:"disabledSslProtocols,omitempty"`
	// PolicyType - Type of Ssl Policy. Possible values include: 'Predefined', 'Custom', 'CustomV2'
	PolicyType ApplicationGatewaySslPolicyType `json:"policyType,omitempty"`
	// PolicyName - Name of Ssl predefined policy. Possible values include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401', 'AppGwSslPolicy20170401S', 'AppGwSslPolicy20220101', 'AppGwSslPolicy20220101S'
	PolicyName ApplicationGatewaySslPolicyName `json:"policyName,omitempty"`
	// CipherSuites - Ssl cipher suites to be enabled in the specified order to application gateway.
	CipherSuites *[]ApplicationGatewaySslCipherSuite `json:"cipherSuites,omitempty"`
	// MinProtocolVersion - Minimum version of Ssl protocol to be supported on application gateway. Possible values include: 'TLSv10', 'TLSv11', 'TLSv12', 'TLSv13'
	MinProtocolVersion ApplicationGatewaySslProtocol `json:"minProtocolVersion,omitempty"`
}

// ApplicationGatewaySslPredefinedPolicy an Ssl predefined policy.
type ApplicationGatewaySslPredefinedPolicy struct {
	autorest.Response `json:"-"`
	// Name - Name of the Ssl predefined policy.
	Name *string `json:"name,omitempty"`
	// ApplicationGatewaySslPredefinedPolicyPropertiesFormat - Properties of the application gateway SSL predefined policy.
	*ApplicationGatewaySslPredefinedPolicyPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslPredefinedPolicy.
func (agspp ApplicationGatewaySslPredefinedPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agspp.Name != nil {
		objectMap["name"] = agspp.Name
	}
	if agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat != nil {
		objectMap["properties"] = agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat
	}
	if agspp.ID != nil {
		objectMap["id"] = agspp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslPredefinedPolicy struct.
func (agspp *ApplicationGatewaySslPredefinedPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agspp.Name = &name
			}
		case "properties":
			if v != nil {
				var applicationGatewaySslPredefinedPolicyPropertiesFormat ApplicationGatewaySslPredefinedPolicyPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslPredefinedPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				agspp.ApplicationGatewaySslPredefinedPolicyPropertiesFormat = &applicationGatewaySslPredefinedPolicyPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agspp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslPredefinedPolicyPropertiesFormat properties of
// ApplicationGatewaySslPredefinedPolicy.
type ApplicationGatewaySslPredefinedPolicyPropertiesFormat struct {
	// CipherSuites - Ssl cipher suites to be enabled in the specified order for application gateway.
	CipherSuites *[]ApplicationGatewaySslCipherSuite `json:"cipherSuites,omitempty"`
	// MinProtocolVersion - Minimum version of Ssl protocol to be supported on application gateway. Possible values include: 'TLSv10', 'TLSv11', 'TLSv12', 'TLSv13'
	MinProtocolVersion ApplicationGatewaySslProtocol `json:"minProtocolVersion,omitempty"`
}

// ApplicationGatewaySslProfile SSL profile of an application gateway.
type ApplicationGatewaySslProfile struct {
	// ApplicationGatewaySslProfilePropertiesFormat - Properties of the application gateway SSL profile.
	*ApplicationGatewaySslProfilePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the SSL profile that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslProfile.
func (agsp ApplicationGatewaySslProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsp.ApplicationGatewaySslProfilePropertiesFormat != nil {
		objectMap["properties"] = agsp.ApplicationGatewaySslProfilePropertiesFormat
	}
	if agsp.Name != nil {
		objectMap["name"] = agsp.Name
	}
	if agsp.ID != nil {
		objectMap["id"] = agsp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslProfile struct.
func (agsp *ApplicationGatewaySslProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslProfilePropertiesFormat ApplicationGatewaySslProfilePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslProfilePropertiesFormat)
				if err != nil {
					return err
				}
				agsp.ApplicationGatewaySslProfilePropertiesFormat = &applicationGatewaySslProfilePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agsp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslProfilePropertiesFormat properties of SSL profile of an application gateway.
type ApplicationGatewaySslProfilePropertiesFormat struct {
	// TrustedClientCertificates - Array of references to application gateway trusted client certificates.
	TrustedClientCertificates *[]SubResource `json:"trustedClientCertificates,omitempty"`
	// SslPolicy - SSL policy of the application gateway resource.
	SslPolicy *ApplicationGatewaySslPolicy `json:"sslPolicy,omitempty"`
	// ClientAuthConfiguration - Client authentication configuration of the application gateway resource.
	ClientAuthConfiguration *ApplicationGatewayClientAuthConfiguration `json:"clientAuthConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the HTTP listener resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslProfilePropertiesFormat.
func (agsppf ApplicationGatewaySslProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsppf.TrustedClientCertificates != nil {
		objectMap["trustedClientCertificates"] = agsppf.TrustedClientCertificates
	}
	if agsppf.SslPolicy != nil {
		objectMap["sslPolicy"] = agsppf.SslPolicy
	}
	if agsppf.ClientAuthConfiguration != nil {
		objectMap["clientAuthConfiguration"] = agsppf.ClientAuthConfiguration
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysStartFuture.Result.
func (future *ApplicationGatewaysStartFuture) result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationGatewaysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationGatewaysStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationGatewaysStopFuture.Result.
func (future *ApplicationGatewaysStopFuture) result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewayTrustedClientCertificate trusted client certificates of an application gateway.
type ApplicationGatewayTrustedClientCertificate struct {
	// ApplicationGatewayTrustedClientCertificatePropertiesFormat - Properties of the application gateway trusted client certificate.
	*ApplicationGatewayTrustedClientCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the trusted client certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayTrustedClientCertificate.
func (agtcc ApplicationGatewayTrustedClientCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agtcc.ApplicationGatewayTrustedClientCertificatePropertiesFormat != nil {
		objectMap["properties"] = agtcc.ApplicationGatewayTrustedClientCertificatePropertiesFormat
	}
	if agtcc.Name != nil {
		objectMap["name"] = agtcc.Name
	}
	if agtcc.ID != nil {
		objectMap["id"] = agtcc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayTrustedClientCertificate struct.
func (agtcc *ApplicationGatewayTrustedClientCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayTrustedClientCertificatePropertiesFormat ApplicationGatewayTrustedClientCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayTrustedClientCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agtcc.ApplicationGatewayTrustedClientCertificatePropertiesFormat = &applicationGatewayTrustedClientCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agtcc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agtcc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agtcc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agtcc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayTrustedClientCertificatePropertiesFormat trusted client certificates properties of an
// application gateway.
type ApplicationGatewayTrustedClientCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// ValidatedCertData - READ-ONLY; Validated certificate data.
	ValidatedCertData *string `json:"validatedCertData,omitempty"`
	// ClientCertIssuerDN - READ-ONLY; Distinguished name of client certificate issuer.
	ClientCertIssuerDN *string `json:"clientCertIssuerDN,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the trusted client certificate resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayTrustedClientCertificatePropertiesFormat.
func (agtccpf ApplicationGatewayTrustedClientCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agtccpf.Data != nil {
		objectMap["data"] = agtccpf.Data
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayTrustedRootCertificate trusted Root certificates of an application gateway.
type ApplicationGatewayTrustedRootCertificate struct {
	// ApplicationGatewayTrustedRootCertificatePropertiesFormat - Properties of the application gateway trusted root certificate.
	*ApplicationGatewayTrustedRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the trusted root certificate that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayTrustedRootCertificate.
func (agtrc ApplicationGatewayTrustedRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat
	}
	if agtrc.Name != nil {
		objectMap["name"] = agtrc.Name
	}
	if agtrc.ID != nil {
		objectMap["id"] = agtrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayTrustedRootCertificate struct.
func (agtrc *ApplicationGatewayTrustedRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayTrustedRootCertificatePropertiesFormat ApplicationGatewayTrustedRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayTrustedRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agtrc.ApplicationGatewayTrustedRootCertificatePropertiesFormat = &applicationGatewayTrustedRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agtrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agtrc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agtrc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agtrc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayTrustedRootCertificatePropertiesFormat trusted Root certificates properties of an
// application gateway.
type ApplicationGatewayTrustedRootCertificatePropertiesFormat struct {
	// Data - Certificate public data.
	Data *string `json:"data,omitempty"`
	// KeyVaultSecretID - Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the trusted root certificate resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayTrustedRootCertificatePropertiesFormat.
func (agtrcpf ApplicationGatewayTrustedRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agtrcpf.Data != nil {
		objectMap["data"] = agtrcpf.Data
	}
	if agtrcpf.KeyVaultSecretID != nil {
		objectMap["keyVaultSecretId"] = agtrcpf.KeyVaultSecretID
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayURLConfiguration url configuration of the Actions set in Application Gateway.
type ApplicationGatewayURLConfiguration struct {
	// ModifiedPath - Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
	ModifiedPath *string `json:"modifiedPath,omitempty"`
	// ModifiedQueryString - Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
	ModifiedQueryString *string `json:"modifiedQueryString,omitempty"`
	// Reroute - If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
	Reroute *bool `json:"reroute,omitempty"`
}

// ApplicationGatewayURLPathMap urlPathMaps give a url path to the backend mapping information for
// PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	// ApplicationGatewayURLPathMapPropertiesFormat - Properties of the application gateway URL path map.
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the URL path map that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMap.
func (agupm ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupm.ApplicationGatewayURLPathMapPropertiesFormat != nil {
		objectMap["properties"] = agupm.ApplicationGatewayURLPathMapPropertiesFormat
	}
	if agupm.Name != nil {
		objectMap["name"] = agupm.Name
	}
	if agupm.ID != nil {
		objectMap["id"] = agupm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayURLPathMap struct.
func (agupm *ApplicationGatewayURLPathMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayURLPathMapPropertiesFormat ApplicationGatewayURLPathMapPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayURLPathMapPropertiesFormat)
				if err != nil {
					return err
				}
				agupm.ApplicationGatewayURLPathMapPropertiesFormat = &applicationGatewayURLPathMapPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agupm.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agupm.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agupm.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agupm.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayURLPathMapPropertiesFormat properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// DefaultBackendAddressPool - Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`
	// DefaultBackendHTTPSettings - Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`
	// DefaultRewriteRuleSet - Default Rewrite rule set resource of URL path map.
	DefaultRewriteRuleSet *SubResource `json:"defaultRewriteRuleSet,omitempty"`
	// DefaultRedirectConfiguration - Default redirect configuration resource of URL path map.
	DefaultRedirectConfiguration *SubResource `json:"defaultRedirectConfiguration,omitempty"`
	// DefaultLoadDistributionPolicy - Default Load Distribution Policy resource of URL path map.
	DefaultLoadDistributionPolicy *SubResource `json:"defaultLoadDistributionPolicy,omitempty"`
	// PathRules - Path rule of URL path map resource.
	PathRules *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the URL path map resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMapPropertiesFormat.
func (agupmpf ApplicationGatewayURLPathMapPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupmpf.DefaultBackendAddressPool != nil {
		objectMap["defaultBackendAddressPool"] = agupmpf.DefaultBackendAddressPool
	}
	if agupmpf.DefaultBackendHTTPSettings != nil {
		objectMap["defaultBackendHttpSettings"] = agupmpf.DefaultBackendHTTPSettings
	}
	if agupmpf.DefaultRewriteRuleSet != nil {
		objectMap["defaultRewriteRuleSet"] = agupmpf.DefaultRewriteRuleSet
	}
	if agupmpf.DefaultRedirectConfiguration != nil {
		objectMap["defaultRedirectConfiguration"] = agupmpf.DefaultRedirectConfiguration
	}
	if agupmpf.DefaultLoadDistributionPolicy != nil {
		objectMap["defaultLoadDistributionPolicy"] = agupmpf.DefaultLoadDistributionPolicy
	}
	if agupmpf.PathRules != nil {
		objectMap["pathRules"] = agupmpf.PathRules
	}
	return json.Marshal(objectMap)
}

// ApplicationGatewayWafDynamicManifestPropertiesResult properties of ApplicationGatewayWafDynamicManifest.
type ApplicationGatewayWafDynamicManifestPropertiesResult struct {
	// DefaultRuleSetPropertyFormat - The default ruleset.
	*DefaultRuleSetPropertyFormat `json:"defaultRuleSet,omitempty"`
	// AvailableRuleSets - The available rulesets.
	AvailableRuleSets *[]ApplicationGatewayFirewallManifestRuleSet `json:"availableRuleSets,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayWafDynamicManifestPropertiesResult.
func (agwdmpr ApplicationGatewayWafDynamicManifestPropertiesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agwdmpr.DefaultRuleSetPropertyFormat != nil {
		objectMap["defaultRuleSet"] = agwdmpr.DefaultRuleSetPropertyFormat
	}
	if agwdmpr.AvailableRuleSets != nil {
		objectMap["availableRuleSets"] = agwdmpr.AvailableRuleSets
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayWafDynamicManifestPropertiesResult struct.
func (agwdmpr *ApplicationGatewayWafDynamicManifestPropertiesResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "defaultRuleSet":
			if v != nil {
				var defaultRuleSetPropertyFormat DefaultRuleSetPropertyFormat
				err = json.Unmarshal(*v, &defaultRuleSetPropertyFormat)
				if err != nil {
					return err
				}
				agwdmpr.DefaultRuleSetPropertyFormat = &defaultRuleSetPropertyFormat
			}
		case "availableRuleSets":
			if v != nil {
				var availableRuleSets []ApplicationGatewayFirewallManifestRuleSet
				err = json.Unmarshal(*v, &availableRuleSets)
				if err != nil {
					return err
				}
				agwdmpr.AvailableRuleSets = &availableRuleSets
			}
		}
	}

	return nil
}

// ApplicationGatewayWafDynamicManifestResult response for ApplicationGatewayWafDynamicManifest API service
// call.
type ApplicationGatewayWafDynamicManifestResult struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ApplicationGatewayWafDynamicManifestPropertiesResult - Properties of the ApplicationGatewayWafDynamicManifest .
	*ApplicationGatewayWafDynamicManifestPropertiesResult `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayWafDynamicManifestResult.
func (agwdmr ApplicationGatewayWafDynamicManifestResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agwdmr.ID != nil {
		objectMap["id"] = agwdmr.ID
	}
	if agwdmr.ApplicationGatewayWafDynamicManifestPropertiesResult != nil {
		objectMap["properties"] = agwdmr.ApplicationGatewayWafDynamicManifestPropertiesResult
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayWafDynamicManifestResult struct.
func (agwdmr *ApplicationGatewayWafDynamicManifestResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agwdmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agwdmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agwdmr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var applicationGatewayWafDynamicManifestPropertiesResult ApplicationGatewayWafDynamicManifestPropertiesResult
				err = json.Unmarshal(*v, &applicationGatewayWafDynamicManifestPropertiesResult)
				if err != nil {
					return err
				}
				agwdmr.ApplicationGatewayWafDynamicManifestPropertiesResult = &applicationGatewayWafDynamicManifestPropertiesResult
			}
		}
	}

	return nil
}

// ApplicationGatewayWafDynamicManifestResultList response for ApplicationGatewayWafDynamicManifests API
// service call.
type ApplicationGatewayWafDynamicManifestResultList struct {
	autorest.Response `json:"-"`
	// Value - The list of application gateway waf manifest.
	Value *[]ApplicationGatewayWafDynamicManifestResult `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayWafDynamicManifestResultListIterator provides access to a complete listing of
// ApplicationGatewayWafDynamicManifestResult values.
type ApplicationGatewayWafDynamicManifestResultListIterator struct {
	i    int
	page ApplicationGatewayWafDynamicManifestResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayWafDynamicManifestResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayWafDynamicManifestResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayWafDynamicManifestResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayWafDynamicManifestResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayWafDynamicManifestResultListIterator) Response() ApplicationGatewayWafDynamicManifestResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayWafDynamicManifestResultListIterator) Value() ApplicationGatewayWafDynamicManifestResult {
	if !iter.page.NotDone() {
		return ApplicationGatewayWafDynamicManifestResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayWafDynamicManifestResultListIterator type.
func NewApplicationGatewayWafDynamicManifestResultListIterator(page ApplicationGatewayWafDynamicManifestResultListPage) ApplicationGatewayWafDynamicManifestResultListIterator {
	return ApplicationGatewayWafDynamicManifestResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agwdmrl ApplicationGatewayWafDynamicManifestResultList) IsEmpty() bool {
	return agwdmrl.Value == nil || len(*agwdmrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (agwdmrl ApplicationGatewayWafDynamicManifestResultList) hasNextLink() bool {
	return agwdmrl.NextLink != nil && len(*agwdmrl.NextLink) != 0
}

// applicationGatewayWafDynamicManifestResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agwdmrl ApplicationGatewayWafDynamicManifestResultList) applicationGatewayWafDynamicManifestResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !agwdmrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agwdmrl.NextLink)))
}

// ApplicationGatewayWafDynamicManifestResultListPage contains a page of
// ApplicationGatewayWafDynamicManifestResult values.
type ApplicationGatewayWafDynamicManifestResultListPage struct {
	fn      func(context.Context, ApplicationGatewayWafDynamicManifestResultList) (ApplicationGatewayWafDynamicManifestResultList, error)
	agwdmrl ApplicationGatewayWafDynamicManifestResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayWafDynamicManifestResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayWafDynamicManifestResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.agwdmrl)
		if err != nil {
			return err
		}
		page.agwdmrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayWafDynamicManifestResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayWafDynamicManifestResultListPage) NotDone() bool {
	return !page.agwdmrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayWafDynamicManifestResultListPage) Response() ApplicationGatewayWafDynamicManifestResultList {
	return page.agwdmrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayWafDynamicManifestResultListPage) Values() []ApplicationGatewayWafDynamicManifestResult {
	if page.agwdmrl.IsEmpty() {
		return nil
	}
	return *page.agwdmrl.Value
}

// Creates a new instance of the ApplicationGatewayWafDynamicManifestResultListPage type.
func NewApplicationGatewayWafDynamicManifestResultListPage(cur ApplicationGatewayWafDynamicManifestResultList, getNextPage func(context.Context, ApplicationGatewayWafDynamicManifestResultList) (ApplicationGatewayWafDynamicManifestResultList, error)) ApplicationGatewayWafDynamicManifestResultListPage {
	return ApplicationGatewayWafDynamicManifestResultListPage{
		fn:      getNextPage,
		agwdmrl: cur,
	}
}

// ApplicationGatewayWebApplicationFirewallConfiguration application gateway web application firewall
// configuration.
type ApplicationGatewayWebApplicationFirewallConfiguration struct {
	// Enabled - Whether the web application firewall is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// FirewallMode - Web application firewall mode. Possible values include: 'Detection', 'Prevention'
	FirewallMode ApplicationGatewayFirewallMode `json:"firewallMode,omitempty"`
	// RuleSetType - The type of the web application firewall rule set. Possible values are: 'OWASP'.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// DisabledRuleGroups - The disabled rule groups.
	DisabledRuleGroups *[]ApplicationGatewayFirewallDisabledRuleGroup `json:"disabledRuleGroups,omitempty"`
	// RequestBodyCheck - Whether allow WAF to check request Body.
	RequestBodyCheck *bool `json:"requestBodyCheck,omitempty"`
	// MaxRequestBodySize - Maximum request body size for WAF.
	MaxRequestBodySize *int32 `json:"maxRequestBodySize,omitempty"`
	// MaxRequestBodySizeInKb - Maximum request body size in Kb for WAF.
	MaxRequestBodySizeInKb *int32 `json:"maxRequestBodySizeInKb,omitempty"`
	// FileUploadLimitInMb - Maximum file upload size in Mb for WAF.
	FileUploadLimitInMb *int32 `json:"fileUploadLimitInMb,omitempty"`
	// Exclusions - The exclusion list.
	Exclusions *[]ApplicationGatewayFirewallExclusion `json:"exclusions,omitempty"`
}

// ApplicationRule rule of type application.
type ApplicationRule struct {
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses or Service Tags.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// Protocols - Array of Application Protocols.
	Protocols *[]FirewallPolicyRuleApplicationProtocol `json:"protocols,omitempty"`
	// TargetFqdns - List of FQDNs for this rule.
	TargetFqdns *[]string `json:"targetFqdns,omitempty"`
	// TargetUrls - List of Urls for this rule condition.
	TargetUrls *[]string `json:"targetUrls,omitempty"`
	// FqdnTags - List of FQDN Tags for this rule.
	FqdnTags *[]string `json:"fqdnTags,omitempty"`
	// SourceIPGroups - List of source IpGroups for this rule.
	SourceIPGroups *[]string `json:"sourceIpGroups,omitempty"`
	// TerminateTLS - Terminate TLS connections for this rule.
	TerminateTLS *bool `json:"terminateTLS,omitempty"`
	// WebCategories - List of destination azure web categories.
	WebCategories *[]string `json:"webCategories,omitempty"`
	// Name - Name of the rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// RuleType - Possible values include: 'RuleTypeFirewallPolicyRule', 'RuleTypeApplicationRule', 'RuleTypeNatRule', 'RuleTypeNetworkRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationRule.
func (ar ApplicationRule) MarshalJSON() ([]byte, error) {
	ar.RuleType = RuleTypeApplicationRule
	objectMap := make(map[string]interface{})
	if ar.SourceAddresses != nil {
		objectMap["sourceAddresses"] = ar.SourceAddresses
	}
	if ar.DestinationAddresses != nil {
		objectMap["destinationAddresses"] = ar.DestinationAddresses
	}
	if ar.Protocols != nil {
		objectMap["protocols"] = ar.Protocols
	}
	if ar.TargetFqdns != nil {
		objectMap["targetFqdns"] = ar.TargetFqdns
	}
	if ar.TargetUrls != nil {
		objectMap["targetUrls"] = ar.TargetUrls
	}
	if ar.FqdnTags != nil {
		objectMap["fqdnTags"] = ar.FqdnTags
	}
	if ar.SourceIPGroups != nil {
		objectMap["sourceIpGroups"] = ar.SourceIPGroups
	}
	if ar.TerminateTLS != nil {
		objectMap["terminateTLS"] = ar.TerminateTLS
	}
	if ar.WebCategories != nil {
		objectMap["webCategories"] = ar.WebCategories
	}
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Description != nil {
		objectMap["description"] = ar.Description
	}
	if ar.RuleType != "" {
		objectMap["ruleType"] = ar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsApplicationRule is the BasicFirewallPolicyRule implementation for ApplicationRule.
func (ar ApplicationRule) AsApplicationRule() (*ApplicationRule, bool) {
	return &ar, true
}

// AsNatRule is the BasicFirewallPolicyRule implementation for ApplicationRule.
func (ar ApplicationRule) AsNatRule() (*NatRule, bool) {
	return nil, false
}

// AsRule is the BasicFirewallPolicyRule implementation for ApplicationRule.
func (ar ApplicationRule) AsRule() (*Rule, bool) {
	return nil, false
}

// AsFirewallPolicyRule is the BasicFirewallPolicyRule implementation for ApplicationRule.
func (ar ApplicationRule) AsFirewallPolicyRule() (*FirewallPolicyRule, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRule is the BasicFirewallPolicyRule implementation for ApplicationRule.
func (ar ApplicationRule) AsBasicFirewallPolicyRule() (BasicFirewallPolicyRule, bool) {
	return &ar, true
}

// ApplicationSecurityGroup an application security group in a resource group.
type ApplicationSecurityGroup struct {
	autorest.Response `json:"-"`
	// ApplicationSecurityGroupPropertiesFormat - Properties of the application security group.
	*ApplicationSecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationSecurityGroup.
func (asg ApplicationSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asg.ApplicationSecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = asg.ApplicationSecurityGroupPropertiesFormat
	}
	if asg.ID != nil {
		objectMap["id"] = asg.ID
	}
	if asg.Location != nil {
		objectMap["location"] = asg.Location
	}
	if asg.Tags != nil {
		objectMap["tags"] = asg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationSecurityGroup struct.
func (asg *ApplicationSecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationSecurityGroupPropertiesFormat ApplicationSecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &applicationSecurityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				asg.ApplicationSecurityGroupPropertiesFormat = &applicationSecurityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				asg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asg.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationSecurityGroupListResult a list of application security groups.
type ApplicationSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of application security groups.
	Value *[]ApplicationSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationSecurityGroupListResult.
func (asglr ApplicationSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asglr.Value != nil {
		objectMap["value"] = asglr.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationSecurityGroupListResultIterator provides access to a complete listing of
// ApplicationSecurityGroup values.
type ApplicationSecurityGroupListResultIterator struct {
	i    int
	page ApplicationSecurityGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationSecurityGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationSecurityGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationSecurityGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationSecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationSecurityGroupListResultIterator) Response() ApplicationSecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationSecurityGroupListResultIterator) Value() ApplicationSecurityGroup {
	if !iter.page.NotDone() {
		return ApplicationSecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationSecurityGroupListResultIterator type.
func NewApplicationSecurityGroupListResultIterator(page ApplicationSecurityGroupListResultPage) ApplicationSecurityGroupListResultIterator {
	return ApplicationSecurityGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asglr ApplicationSecurityGroupListResult) IsEmpty() bool {
	return asglr.Value == nil || len(*asglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asglr ApplicationSecurityGroupListResult) hasNextLink() bool {
	return asglr.NextLink != nil && len(*asglr.NextLink) != 0
}

// applicationSecurityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asglr ApplicationSecurityGroupListResult) applicationSecurityGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !asglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asglr.NextLink)))
}

// ApplicationSecurityGroupListResultPage contains a page of ApplicationSecurityGroup values.
type ApplicationSecurityGroupListResultPage struct {
	fn    func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)
	asglr ApplicationSecurityGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationSecurityGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationSecurityGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asglr)
		if err != nil {
			return err
		}
		page.asglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationSecurityGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationSecurityGroupListResultPage) NotDone() bool {
	return !page.asglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationSecurityGroupListResultPage) Response() ApplicationSecurityGroupListResult {
	return page.asglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationSecurityGroupListResultPage) Values() []ApplicationSecurityGroup {
	if page.asglr.IsEmpty() {
		return nil
	}
	return *page.asglr.Value
}

// Creates a new instance of the ApplicationSecurityGroupListResultPage type.
func NewApplicationSecurityGroupListResultPage(cur ApplicationSecurityGroupListResult, getNextPage func(context.Context, ApplicationSecurityGroupListResult) (ApplicationSecurityGroupListResult, error)) ApplicationSecurityGroupListResultPage {
	return ApplicationSecurityGroupListResultPage{
		fn:    getNextPage,
		asglr: cur,
	}
}

// ApplicationSecurityGroupPropertiesFormat application security group properties.
type ApplicationSecurityGroupPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application security group resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationSecurityGroupPropertiesFormat.
func (asgpf ApplicationSecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationSecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ApplicationSecurityGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationSecurityGroupsClient) (ApplicationSecurityGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationSecurityGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationSecurityGroupsCreateOrUpdateFuture.Result.
func (future *ApplicationSecurityGroupsCreateOrUpdateFuture) result(client ApplicationSecurityGroupsClient) (asg ApplicationSecurityGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationSecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		asg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationSecurityGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if asg.Response.Response, err = future.GetResult(sender); err == nil && asg.Response.Response.StatusCode != http.StatusNoContent {
		asg, err = client.CreateOrUpdateResponder(asg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationSecurityGroupsCreateOrUpdateFuture", "Result", asg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationSecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationSecurityGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationSecurityGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationSecurityGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationSecurityGroupsDeleteFuture.Result.
func (future *ApplicationSecurityGroupsDeleteFuture) result(client ApplicationSecurityGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationSecurityGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ApplicationSecurityGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AuthorizationListResult response for ListAuthorizations API service call retrieves all authorizations
// that belongs to an ExpressRouteCircuit.
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - The authorizations in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationListResultIterator provides access to a complete listing of
// ExpressRouteCircuitAuthorization values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationListResultIterator type.
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return AuthorizationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AuthorizationListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AuthorizationListResultPage type.
func NewAuthorizationListResultPage(cur AuthorizationListResult, getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return AuthorizationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AuthorizationPropertiesFormat properties of ExpressRouteCircuitAuthorization.
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - The authorization use status. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the authorization resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationPropertiesFormat.
func (apf AuthorizationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apf.AuthorizationKey != nil {
		objectMap["authorizationKey"] = apf.AuthorizationKey
	}
	if apf.AuthorizationUseStatus != "" {
		objectMap["authorizationUseStatus"] = apf.AuthorizationUseStatus
	}
	return json.Marshal(objectMap)
}

// AutoApprovedPrivateLinkService the information of an AutoApprovedPrivateLinkService.
type AutoApprovedPrivateLinkService struct {
	// PrivateLinkService - The id of the private link service resource.
	PrivateLinkService *string `json:"privateLinkService,omitempty"`
}

// AutoApprovedPrivateLinkServicesResult an array of private link service id that can be linked to a
// private end point with auto approved.
type AutoApprovedPrivateLinkServicesResult struct {
	autorest.Response `json:"-"`
	// Value - An array of auto approved private link service.
	Value *[]AutoApprovedPrivateLinkService `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoApprovedPrivateLinkServicesResult.
func (aaplsr AutoApprovedPrivateLinkServicesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aaplsr.Value != nil {
		objectMap["value"] = aaplsr.Value
	}
	return json.Marshal(objectMap)
}

// AutoApprovedPrivateLinkServicesResultIterator provides access to a complete listing of
// AutoApprovedPrivateLinkService values.
type AutoApprovedPrivateLinkServicesResultIterator struct {
	i    int
	page AutoApprovedPrivateLinkServicesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoApprovedPrivateLinkServicesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoApprovedPrivateLinkServicesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoApprovedPrivateLinkServicesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoApprovedPrivateLinkServicesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoApprovedPrivateLinkServicesResultIterator) Response() AutoApprovedPrivateLinkServicesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoApprovedPrivateLinkServicesResultIterator) Value() AutoApprovedPrivateLinkService {
	if !iter.page.NotDone() {
		return AutoApprovedPrivateLinkService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoApprovedPrivateLinkServicesResultIterator type.
func NewAutoApprovedPrivateLinkServicesResultIterator(page AutoApprovedPrivateLinkServicesResultPage) AutoApprovedPrivateLinkServicesResultIterator {
	return AutoApprovedPrivateLinkServicesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aaplsr AutoApprovedPrivateLinkServicesResult) IsEmpty() bool {
	return aaplsr.Value == nil || len(*aaplsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aaplsr AutoApprovedPrivateLinkServicesResult) hasNextLink() bool {
	return aaplsr.NextLink != nil && len(*aaplsr.NextLink) != 0
}

// autoApprovedPrivateLinkServicesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aaplsr AutoApprovedPrivateLinkServicesResult) autoApprovedPrivateLinkServicesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aaplsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aaplsr.NextLink)))
}

// AutoApprovedPrivateLinkServicesResultPage contains a page of AutoApprovedPrivateLinkService values.
type AutoApprovedPrivateLinkServicesResultPage struct {
	fn     func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)
	aaplsr AutoApprovedPrivateLinkServicesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoApprovedPrivateLinkServicesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoApprovedPrivateLinkServicesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aaplsr)
		if err != nil {
			return err
		}
		page.aaplsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoApprovedPrivateLinkServicesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoApprovedPrivateLinkServicesResultPage) NotDone() bool {
	return !page.aaplsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoApprovedPrivateLinkServicesResultPage) Response() AutoApprovedPrivateLinkServicesResult {
	return page.aaplsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoApprovedPrivateLinkServicesResultPage) Values() []AutoApprovedPrivateLinkService {
	if page.aaplsr.IsEmpty() {
		return nil
	}
	return *page.aaplsr.Value
}

// Creates a new instance of the AutoApprovedPrivateLinkServicesResultPage type.
func NewAutoApprovedPrivateLinkServicesResultPage(cur AutoApprovedPrivateLinkServicesResult, getNextPage func(context.Context, AutoApprovedPrivateLinkServicesResult) (AutoApprovedPrivateLinkServicesResult, error)) AutoApprovedPrivateLinkServicesResultPage {
	return AutoApprovedPrivateLinkServicesResultPage{
		fn:     getNextPage,
		aaplsr: cur,
	}
}

// Availability availability of the metric.
type Availability struct {
	// TimeGrain - The time grain of the availability.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - The retention of the availability.
	Retention *string `json:"retention,omitempty"`
	// BlobDuration - Duration of the availability blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// AvailableDelegation the serviceName of an AvailableDelegation indicates a possible delegation for a
// subnet.
type AvailableDelegation struct {
	// Name - The name of the AvailableDelegation resource.
	Name *string `json:"name,omitempty"`
	// ID - A unique identifier of the AvailableDelegation resource.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ServiceName - The name of the service and resource.
	ServiceName *string `json:"serviceName,omitempty"`
	// Actions - The actions permitted to the service upon delegation.
	Actions *[]string `json:"actions,omitempty"`
}

// AvailableDelegationsResult an array of available delegations.
type AvailableDelegationsResult struct {
	autorest.Response `json:"-"`
	// Value - An array of available delegations.
	Value *[]AvailableDelegation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableDelegationsResult.
func (adr AvailableDelegationsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adr.Value != nil {
		objectMap["value"] = adr.Value
	}
	return json.Marshal(objectMap)
}

// AvailableDelegationsResultIterator provides access to a complete listing of AvailableDelegation values.
type AvailableDelegationsResultIterator struct {
	i    int
	page AvailableDelegationsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableDelegationsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableDelegationsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableDelegationsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableDelegationsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableDelegationsResultIterator) Response() AvailableDelegationsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableDelegationsResultIterator) Value() AvailableDelegation {
	if !iter.page.NotDone() {
		return AvailableDelegation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableDelegationsResultIterator type.
func NewAvailableDelegationsResultIterator(page AvailableDelegationsResultPage) AvailableDelegationsResultIterator {
	return AvailableDelegationsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adr AvailableDelegationsResult) IsEmpty() bool {
	return adr.Value == nil || len(*adr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (adr AvailableDelegationsResult) hasNextLink() bool {
	return adr.NextLink != nil && len(*adr.NextLink) != 0
}

// availableDelegationsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adr AvailableDelegationsResult) availableDelegationsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !adr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adr.NextLink)))
}

// AvailableDelegationsResultPage contains a page of AvailableDelegation values.
type AvailableDelegationsResultPage struct {
	fn  func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)
	adr AvailableDelegationsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableDelegationsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableDelegationsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.adr)
		if err != nil {
			return err
		}
		page.adr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableDelegationsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableDelegationsResultPage) NotDone() bool {
	return !page.adr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableDelegationsResultPage) Response() AvailableDelegationsResult {
	return page.adr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableDelegationsResultPage) Values() []AvailableDelegation {
	if page.adr.IsEmpty() {
		return nil
	}
	return *page.adr.Value
}

// Creates a new instance of the AvailableDelegationsResultPage type.
func NewAvailableDelegationsResultPage(cur AvailableDelegationsResult, getNextPage func(context.Context, AvailableDelegationsResult) (AvailableDelegationsResult, error)) AvailableDelegationsResultPage {
	return AvailableDelegationsResultPage{
		fn:  getNextPage,
		adr: cur,
	}
}

// AvailablePrivateEndpointType the information of an AvailablePrivateEndpointType.
type AvailablePrivateEndpointType struct {
	// Name - The name of the service and resource.
	Name *string `json:"name,omitempty"`
	// ID - A unique identifier of the AvailablePrivateEndpoint Type resource.
	ID *string `json:"id,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ResourceName - The name of the service and resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - Display name of the resource.
	DisplayName *string `json:"displayName,omitempty"`
}

// AvailablePrivateEndpointTypesResult an array of available PrivateEndpoint types.
type AvailablePrivateEndpointTypesResult struct {
	autorest.Response `json:"-"`
	// Value - An array of available privateEndpoint type.
	Value *[]AvailablePrivateEndpointType `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailablePrivateEndpointTypesResult.
func (apetr AvailablePrivateEndpointTypesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apetr.Value != nil {
		objectMap["value"] = apetr.Value
	}
	return json.Marshal(objectMap)
}

// AvailablePrivateEndpointTypesResultIterator provides access to a complete listing of
// AvailablePrivateEndpointType values.
type AvailablePrivateEndpointTypesResultIterator struct {
	i    int
	page AvailablePrivateEndpointTypesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailablePrivateEndpointTypesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailablePrivateEndpointTypesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailablePrivateEndpointTypesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailablePrivateEndpointTypesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailablePrivateEndpointTypesResultIterator) Response() AvailablePrivateEndpointTypesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailablePrivateEndpointTypesResultIterator) Value() AvailablePrivateEndpointType {
	if !iter.page.NotDone() {
		return AvailablePrivateEndpointType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailablePrivateEndpointTypesResultIterator type.
func NewAvailablePrivateEndpointTypesResultIterator(page AvailablePrivateEndpointTypesResultPage) AvailablePrivateEndpointTypesResultIterator {
	return AvailablePrivateEndpointTypesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apetr AvailablePrivateEndpointTypesResult) IsEmpty() bool {
	return apetr.Value == nil || len(*apetr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apetr AvailablePrivateEndpointTypesResult) hasNextLink() bool {
	return apetr.NextLink != nil && len(*apetr.NextLink) != 0
}

// availablePrivateEndpointTypesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apetr AvailablePrivateEndpointTypesResult) availablePrivateEndpointTypesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !apetr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apetr.NextLink)))
}

// AvailablePrivateEndpointTypesResultPage contains a page of AvailablePrivateEndpointType values.
type AvailablePrivateEndpointTypesResultPage struct {
	fn    func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)
	apetr AvailablePrivateEndpointTypesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailablePrivateEndpointTypesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailablePrivateEndpointTypesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apetr)
		if err != nil {
			return err
		}
		page.apetr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailablePrivateEndpointTypesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailablePrivateEndpointTypesResultPage) NotDone() bool {
	return !page.apetr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailablePrivateEndpointTypesResultPage) Response() AvailablePrivateEndpointTypesResult {
	return page.apetr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailablePrivateEndpointTypesResultPage) Values() []AvailablePrivateEndpointType {
	if page.apetr.IsEmpty() {
		return nil
	}
	return *page.apetr.Value
}

// Creates a new instance of the AvailablePrivateEndpointTypesResultPage type.
func NewAvailablePrivateEndpointTypesResultPage(cur AvailablePrivateEndpointTypesResult, getNextPage func(context.Context, AvailablePrivateEndpointTypesResult) (AvailablePrivateEndpointTypesResult, error)) AvailablePrivateEndpointTypesResultPage {
	return AvailablePrivateEndpointTypesResultPage{
		fn:    getNextPage,
		apetr: cur,
	}
}

// AvailableProvidersList list of available countries with details.
type AvailableProvidersList struct {
	autorest.Response `json:"-"`
	// Countries - List of available countries.
	Countries *[]AvailableProvidersListCountry `json:"countries,omitempty"`
}

// AvailableProvidersListCity city or town details.
type AvailableProvidersListCity struct {
	// CityName - The city or town name.
	CityName *string `json:"cityName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
}

// AvailableProvidersListCountry country details.
type AvailableProvidersListCountry struct {
	// CountryName - The country name.
	CountryName *string `json:"countryName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// States - List of available states in the country.
	States *[]AvailableProvidersListState `json:"states,omitempty"`
}

// AvailableProvidersListParameters constraints that determine the list of available Internet service
// providers.
type AvailableProvidersListParameters struct {
	// AzureLocations - A list of Azure regions.
	AzureLocations *[]string `json:"azureLocations,omitempty"`
	// Country - The country for available providers list.
	Country *string `json:"country,omitempty"`
	// State - The state for available providers list.
	State *string `json:"state,omitempty"`
	// City - The city or town for available providers list.
	City *string `json:"city,omitempty"`
}

// AvailableProvidersListState state details.
type AvailableProvidersListState struct {
	// StateName - The state name.
	StateName *string `json:"stateName,omitempty"`
	// Providers - A list of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// Cities - List of available cities or towns in the state.
	Cities *[]AvailableProvidersListCity `json:"cities,omitempty"`
}

// AvailableServiceAlias the available service alias.
type AvailableServiceAlias struct {
	// Name - The name of the service alias.
	Name *string `json:"name,omitempty"`
	// ID - The ID of the service alias.
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// ResourceName - The resource name of the service alias.
	ResourceName *string `json:"resourceName,omitempty"`
}

// AvailableServiceAliasesResult an array of available service aliases.
type AvailableServiceAliasesResult struct {
	autorest.Response `json:"-"`
	// Value - An array of available service aliases.
	Value *[]AvailableServiceAlias `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableServiceAliasesResult.
func (asar AvailableServiceAliasesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asar.Value != nil {
		objectMap["value"] = asar.Value
	}
	return json.Marshal(objectMap)
}

// AvailableServiceAliasesResultIterator provides access to a complete listing of AvailableServiceAlias
// values.
type AvailableServiceAliasesResultIterator struct {
	i    int
	page AvailableServiceAliasesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableServiceAliasesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableServiceAliasesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableServiceAliasesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableServiceAliasesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableServiceAliasesResultIterator) Response() AvailableServiceAliasesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableServiceAliasesResultIterator) Value() AvailableServiceAlias {
	if !iter.page.NotDone() {
		return AvailableServiceAlias{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableServiceAliasesResultIterator type.
func NewAvailableServiceAliasesResultIterator(page AvailableServiceAliasesResultPage) AvailableServiceAliasesResultIterator {
	return AvailableServiceAliasesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asar AvailableServiceAliasesResult) IsEmpty() bool {
	return asar.Value == nil || len(*asar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asar AvailableServiceAliasesResult) hasNextLink() bool {
	return asar.NextLink != nil && len(*asar.NextLink) != 0
}

// availableServiceAliasesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asar AvailableServiceAliasesResult) availableServiceAliasesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !asar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asar.NextLink)))
}

// AvailableServiceAliasesResultPage contains a page of AvailableServiceAlias values.
type AvailableServiceAliasesResultPage struct {
	fn   func(context.Context, AvailableServiceAliasesResult) (AvailableServiceAliasesResult, error)
	asar AvailableServiceAliasesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableServiceAliasesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableServiceAliasesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asar)
		if err != nil {
			return err
		}
		page.asar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableServiceAliasesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableServiceAliasesResultPage) NotDone() bool {
	return !page.asar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableServiceAliasesResultPage) Response() AvailableServiceAliasesResult {
	return page.asar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableServiceAliasesResultPage) Values() []AvailableServiceAlias {
	if page.asar.IsEmpty() {
		return nil
	}
	return *page.asar.Value
}

// Creates a new instance of the AvailableServiceAliasesResultPage type.
func NewAvailableServiceAliasesResultPage(cur AvailableServiceAliasesResult, getNextPage func(context.Context, AvailableServiceAliasesResult) (AvailableServiceAliasesResult, error)) AvailableServiceAliasesResultPage {
	return AvailableServiceAliasesResultPage{
		fn:   getNextPage,
		asar: cur,
	}
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values include: 'OperationStatusInProgress', 'OperationStatusSucceeded', 'OperationStatusFailed'
	Status OperationStatus `json:"status,omitempty"`
	// Error - Details of the error occurred during specified asynchronous operation.
	Error *Error `json:"error,omitempty"`
}

// AzureFirewall azure Firewall resource.
type AzureFirewall struct {
	autorest.Response `json:"-"`
	// AzureFirewallPropertiesFormat - Properties of the azure firewall.
	*AzureFirewallPropertiesFormat `json:"properties,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureFirewall.
func (af AzureFirewall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if af.AzureFirewallPropertiesFormat != nil {
		objectMap["properties"] = af.AzureFirewallPropertiesFormat
	}
	if af.Zones != nil {
		objectMap["zones"] = af.Zones
	}
	if af.ID != nil {
		objectMap["id"] = af.ID
	}
	if af.Location != nil {
		objectMap["location"] = af.Location
	}
	if af.Tags != nil {
		objectMap["tags"] = af.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewall struct.
func (af *AzureFirewall) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallPropertiesFormat AzureFirewallPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallPropertiesFormat)
				if err != nil {
					return err
				}
				af.AzureFirewallPropertiesFormat = &azureFirewallPropertiesFormat
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				af.Zones = &zones
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				af.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				af.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				af.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				af.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				af.Tags = tags
			}
		}
	}

	return nil
}

// AzureFirewallApplicationRule properties of an application rule.
type AzureFirewallApplicationRule struct {
	// Name - Name of the application rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// Protocols - Array of ApplicationRuleProtocols.
	Protocols *[]AzureFirewallApplicationRuleProtocol `json:"protocols,omitempty"`
	// TargetFqdns - List of FQDNs for this rule.
	TargetFqdns *[]string `json:"targetFqdns,omitempty"`
	// FqdnTags - List of FQDN Tags for this rule.
	FqdnTags *[]string `json:"fqdnTags,omitempty"`
	// SourceIPGroups - List of source IpGroups for this rule.
	SourceIPGroups *[]string `json:"sourceIpGroups,omitempty"`
}

// AzureFirewallApplicationRuleCollection application rule collection resource.
type AzureFirewallApplicationRuleCollection struct {
	// AzureFirewallApplicationRuleCollectionPropertiesFormat - Properties of the azure firewall application rule collection.
	*AzureFirewallApplicationRuleCollectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallApplicationRuleCollection.
func (afarc AzureFirewallApplicationRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat != nil {
		objectMap["properties"] = afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat
	}
	if afarc.Name != nil {
		objectMap["name"] = afarc.Name
	}
	if afarc.ID != nil {
		objectMap["id"] = afarc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallApplicationRuleCollection struct.
func (afarc *AzureFirewallApplicationRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallApplicationRuleCollectionPropertiesFormat AzureFirewallApplicationRuleCollectionPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallApplicationRuleCollectionPropertiesFormat)
				if err != nil {
					return err
				}
				afarc.AzureFirewallApplicationRuleCollectionPropertiesFormat = &azureFirewallApplicationRuleCollectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afarc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afarc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afarc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallApplicationRuleCollectionPropertiesFormat properties of the application rule collection.
type AzureFirewallApplicationRuleCollectionPropertiesFormat struct {
	// Priority - Priority of the application rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a application rule collection.
	Rules *[]AzureFirewallApplicationRule `json:"rules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the application rule collection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallApplicationRuleCollectionPropertiesFormat.
func (afarcpf AzureFirewallApplicationRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afarcpf.Priority != nil {
		objectMap["priority"] = afarcpf.Priority
	}
	if afarcpf.Action != nil {
		objectMap["action"] = afarcpf.Action
	}
	if afarcpf.Rules != nil {
		objectMap["rules"] = afarcpf.Rules
	}
	return json.Marshal(objectMap)
}

// AzureFirewallApplicationRuleProtocol properties of the application rule protocol.
type AzureFirewallApplicationRuleProtocol struct {
	// ProtocolType - Protocol type. Possible values include: 'AzureFirewallApplicationRuleProtocolTypeHTTP', 'AzureFirewallApplicationRuleProtocolTypeHTTPS', 'AzureFirewallApplicationRuleProtocolTypeMssql'
	ProtocolType AzureFirewallApplicationRuleProtocolType `json:"protocolType,omitempty"`
	// Port - Port number for the protocol, cannot be greater than 64000. This field is optional.
	Port *int32 `json:"port,omitempty"`
}

// AzureFirewallFqdnTag azure Firewall FQDN Tag Resource.
type AzureFirewallFqdnTag struct {
	// AzureFirewallFqdnTagPropertiesFormat - Properties of the azure firewall FQDN tag.
	*AzureFirewallFqdnTagPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureFirewallFqdnTag.
func (afft AzureFirewallFqdnTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afft.AzureFirewallFqdnTagPropertiesFormat != nil {
		objectMap["properties"] = afft.AzureFirewallFqdnTagPropertiesFormat
	}
	if afft.ID != nil {
		objectMap["id"] = afft.ID
	}
	if afft.Location != nil {
		objectMap["location"] = afft.Location
	}
	if afft.Tags != nil {
		objectMap["tags"] = afft.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallFqdnTag struct.
func (afft *AzureFirewallFqdnTag) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallFqdnTagPropertiesFormat AzureFirewallFqdnTagPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallFqdnTagPropertiesFormat)
				if err != nil {
					return err
				}
				afft.AzureFirewallFqdnTagPropertiesFormat = &azureFirewallFqdnTagPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afft.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afft.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afft.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				afft.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				afft.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				afft.Tags = tags
			}
		}
	}

	return nil
}

// AzureFirewallFqdnTagListResult response for ListAzureFirewallFqdnTags API service call.
type AzureFirewallFqdnTagListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Firewall FQDN Tags in a resource group.
	Value *[]AzureFirewallFqdnTag `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureFirewallFqdnTagListResultIterator provides access to a complete listing of AzureFirewallFqdnTag
// values.
type AzureFirewallFqdnTagListResultIterator struct {
	i    int
	page AzureFirewallFqdnTagListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureFirewallFqdnTagListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallFqdnTagListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureFirewallFqdnTagListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureFirewallFqdnTagListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureFirewallFqdnTagListResultIterator) Response() AzureFirewallFqdnTagListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureFirewallFqdnTagListResultIterator) Value() AzureFirewallFqdnTag {
	if !iter.page.NotDone() {
		return AzureFirewallFqdnTag{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureFirewallFqdnTagListResultIterator type.
func NewAzureFirewallFqdnTagListResultIterator(page AzureFirewallFqdnTagListResultPage) AzureFirewallFqdnTagListResultIterator {
	return AzureFirewallFqdnTagListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (afftlr AzureFirewallFqdnTagListResult) IsEmpty() bool {
	return afftlr.Value == nil || len(*afftlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (afftlr AzureFirewallFqdnTagListResult) hasNextLink() bool {
	return afftlr.NextLink != nil && len(*afftlr.NextLink) != 0
}

// azureFirewallFqdnTagListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (afftlr AzureFirewallFqdnTagListResult) azureFirewallFqdnTagListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !afftlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(afftlr.NextLink)))
}

// AzureFirewallFqdnTagListResultPage contains a page of AzureFirewallFqdnTag values.
type AzureFirewallFqdnTagListResultPage struct {
	fn     func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)
	afftlr AzureFirewallFqdnTagListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureFirewallFqdnTagListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallFqdnTagListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.afftlr)
		if err != nil {
			return err
		}
		page.afftlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureFirewallFqdnTagListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureFirewallFqdnTagListResultPage) NotDone() bool {
	return !page.afftlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureFirewallFqdnTagListResultPage) Response() AzureFirewallFqdnTagListResult {
	return page.afftlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureFirewallFqdnTagListResultPage) Values() []AzureFirewallFqdnTag {
	if page.afftlr.IsEmpty() {
		return nil
	}
	return *page.afftlr.Value
}

// Creates a new instance of the AzureFirewallFqdnTagListResultPage type.
func NewAzureFirewallFqdnTagListResultPage(cur AzureFirewallFqdnTagListResult, getNextPage func(context.Context, AzureFirewallFqdnTagListResult) (AzureFirewallFqdnTagListResult, error)) AzureFirewallFqdnTagListResultPage {
	return AzureFirewallFqdnTagListResultPage{
		fn:     getNextPage,
		afftlr: cur,
	}
}

// AzureFirewallFqdnTagPropertiesFormat azure Firewall FQDN Tag Properties.
type AzureFirewallFqdnTagPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the Azure firewall FQDN tag resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// FqdnTagName - READ-ONLY; The name of this FQDN Tag.
	FqdnTagName *string `json:"fqdnTagName,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallFqdnTagPropertiesFormat.
func (afftpf AzureFirewallFqdnTagPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFirewallIPConfiguration IP configuration of an Azure Firewall.
type AzureFirewallIPConfiguration struct {
	// AzureFirewallIPConfigurationPropertiesFormat - Properties of the azure firewall IP configuration.
	*AzureFirewallIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallIPConfiguration.
func (afic AzureFirewallIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afic.AzureFirewallIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = afic.AzureFirewallIPConfigurationPropertiesFormat
	}
	if afic.Name != nil {
		objectMap["name"] = afic.Name
	}
	if afic.ID != nil {
		objectMap["id"] = afic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallIPConfiguration struct.
func (afic *AzureFirewallIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallIPConfigurationPropertiesFormat AzureFirewallIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				afic.AzureFirewallIPConfigurationPropertiesFormat = &azureFirewallIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				afic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afic.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallIPConfigurationPropertiesFormat properties of IP configuration of an Azure Firewall.
type AzureFirewallIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - READ-ONLY; The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// Subnet - Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the Azure firewall IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallIPConfigurationPropertiesFormat.
func (aficpf AzureFirewallIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aficpf.Subnet != nil {
		objectMap["subnet"] = aficpf.Subnet
	}
	if aficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = aficpf.PublicIPAddress
	}
	return json.Marshal(objectMap)
}

// AzureFirewallIPGroups ipGroups associated with azure firewall.
type AzureFirewallIPGroups struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// ChangeNumber - READ-ONLY; The iteration number.
	ChangeNumber *string `json:"changeNumber,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallIPGroups.
func (afig AzureFirewallIPGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFirewallListResult response for ListAzureFirewalls API service call.
type AzureFirewallListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Firewalls in a resource group.
	Value *[]AzureFirewall `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureFirewallListResultIterator provides access to a complete listing of AzureFirewall values.
type AzureFirewallListResultIterator struct {
	i    int
	page AzureFirewallListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureFirewallListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureFirewallListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureFirewallListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureFirewallListResultIterator) Response() AzureFirewallListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureFirewallListResultIterator) Value() AzureFirewall {
	if !iter.page.NotDone() {
		return AzureFirewall{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureFirewallListResultIterator type.
func NewAzureFirewallListResultIterator(page AzureFirewallListResultPage) AzureFirewallListResultIterator {
	return AzureFirewallListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aflr AzureFirewallListResult) IsEmpty() bool {
	return aflr.Value == nil || len(*aflr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aflr AzureFirewallListResult) hasNextLink() bool {
	return aflr.NextLink != nil && len(*aflr.NextLink) != 0
}

// azureFirewallListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aflr AzureFirewallListResult) azureFirewallListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aflr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aflr.NextLink)))
}

// AzureFirewallListResultPage contains a page of AzureFirewall values.
type AzureFirewallListResultPage struct {
	fn   func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)
	aflr AzureFirewallListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureFirewallListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureFirewallListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aflr)
		if err != nil {
			return err
		}
		page.aflr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureFirewallListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureFirewallListResultPage) NotDone() bool {
	return !page.aflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureFirewallListResultPage) Response() AzureFirewallListResult {
	return page.aflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureFirewallListResultPage) Values() []AzureFirewall {
	if page.aflr.IsEmpty() {
		return nil
	}
	return *page.aflr.Value
}

// Creates a new instance of the AzureFirewallListResultPage type.
func NewAzureFirewallListResultPage(cur AzureFirewallListResult, getNextPage func(context.Context, AzureFirewallListResult) (AzureFirewallListResult, error)) AzureFirewallListResultPage {
	return AzureFirewallListResultPage{
		fn:   getNextPage,
		aflr: cur,
	}
}

// AzureFirewallNatRCAction azureFirewall NAT Rule Collection Action.
type AzureFirewallNatRCAction struct {
	// Type - The type of action. Possible values include: 'Snat', 'Dnat'
	Type AzureFirewallNatRCActionType `json:"type,omitempty"`
}

// AzureFirewallNatRule properties of a NAT rule.
type AzureFirewallNatRule struct {
	// Name - Name of the NAT rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
	// Protocols - Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
	Protocols *[]AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`
	// TranslatedAddress - The translated address for this NAT rule.
	TranslatedAddress *string `json:"translatedAddress,omitempty"`
	// TranslatedPort - The translated port for this NAT rule.
	TranslatedPort *string `json:"translatedPort,omitempty"`
	// TranslatedFqdn - The translated FQDN for this NAT rule.
	TranslatedFqdn *string `json:"translatedFqdn,omitempty"`
	// SourceIPGroups - List of source IpGroups for this rule.
	SourceIPGroups *[]string `json:"sourceIpGroups,omitempty"`
}

// AzureFirewallNatRuleCollection NAT rule collection resource.
type AzureFirewallNatRuleCollection struct {
	// AzureFirewallNatRuleCollectionProperties - Properties of the azure firewall NAT rule collection.
	*AzureFirewallNatRuleCollectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNatRuleCollection.
func (afnrc AzureFirewallNatRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrc.AzureFirewallNatRuleCollectionProperties != nil {
		objectMap["properties"] = afnrc.AzureFirewallNatRuleCollectionProperties
	}
	if afnrc.Name != nil {
		objectMap["name"] = afnrc.Name
	}
	if afnrc.ID != nil {
		objectMap["id"] = afnrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallNatRuleCollection struct.
func (afnrc *AzureFirewallNatRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallNatRuleCollectionProperties AzureFirewallNatRuleCollectionProperties
				err = json.Unmarshal(*v, &azureFirewallNatRuleCollectionProperties)
				if err != nil {
					return err
				}
				afnrc.AzureFirewallNatRuleCollectionProperties = &azureFirewallNatRuleCollectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afnrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afnrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afnrc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallNatRuleCollectionProperties properties of the NAT rule collection.
type AzureFirewallNatRuleCollectionProperties struct {
	// Priority - Priority of the NAT rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a NAT rule collection.
	Action *AzureFirewallNatRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a NAT rule collection.
	Rules *[]AzureFirewallNatRule `json:"rules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the NAT rule collection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNatRuleCollectionProperties.
func (afnrcp AzureFirewallNatRuleCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrcp.Priority != nil {
		objectMap["priority"] = afnrcp.Priority
	}
	if afnrcp.Action != nil {
		objectMap["action"] = afnrcp.Action
	}
	if afnrcp.Rules != nil {
		objectMap["rules"] = afnrcp.Rules
	}
	return json.Marshal(objectMap)
}

// AzureFirewallNetworkRule properties of the network rule.
type AzureFirewallNetworkRule struct {
	// Name - Name of the network rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// Protocols - Array of AzureFirewallNetworkRuleProtocols.
	Protocols *[]AzureFirewallNetworkRuleProtocol `json:"protocols,omitempty"`
	// SourceAddresses - List of source IP addresses for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
	// DestinationFqdns - List of destination FQDNs.
	DestinationFqdns *[]string `json:"destinationFqdns,omitempty"`
	// SourceIPGroups - List of source IpGroups for this rule.
	SourceIPGroups *[]string `json:"sourceIpGroups,omitempty"`
	// DestinationIPGroups - List of destination IpGroups for this rule.
	DestinationIPGroups *[]string `json:"destinationIpGroups,omitempty"`
}

// AzureFirewallNetworkRuleCollection network rule collection resource.
type AzureFirewallNetworkRuleCollection struct {
	// AzureFirewallNetworkRuleCollectionPropertiesFormat - Properties of the azure firewall network rule collection.
	*AzureFirewallNetworkRuleCollectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNetworkRuleCollection.
func (afnrc AzureFirewallNetworkRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat != nil {
		objectMap["properties"] = afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat
	}
	if afnrc.Name != nil {
		objectMap["name"] = afnrc.Name
	}
	if afnrc.ID != nil {
		objectMap["id"] = afnrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureFirewallNetworkRuleCollection struct.
func (afnrc *AzureFirewallNetworkRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureFirewallNetworkRuleCollectionPropertiesFormat AzureFirewallNetworkRuleCollectionPropertiesFormat
				err = json.Unmarshal(*v, &azureFirewallNetworkRuleCollectionPropertiesFormat)
				if err != nil {
					return err
				}
				afnrc.AzureFirewallNetworkRuleCollectionPropertiesFormat = &azureFirewallNetworkRuleCollectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				afnrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				afnrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				afnrc.ID = &ID
			}
		}
	}

	return nil
}

// AzureFirewallNetworkRuleCollectionPropertiesFormat properties of the network rule collection.
type AzureFirewallNetworkRuleCollectionPropertiesFormat struct {
	// Priority - Priority of the network rule collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// Action - The action type of a rule collection.
	Action *AzureFirewallRCAction `json:"action,omitempty"`
	// Rules - Collection of rules used by a network rule collection.
	Rules *[]AzureFirewallNetworkRule `json:"rules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network rule collection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirewallNetworkRuleCollectionPropertiesFormat.
func (afnrcpf AzureFirewallNetworkRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afnrcpf.Priority != nil {
		objectMap["priority"] = afnrcpf.Priority
	}
	if afnrcpf.Action != nil {
		objectMap["action"] = afnrcpf.Action
	}
	if afnrcpf.Rules != nil {
		objectMap["rules"] = afnrcpf.Rules
	}
	return json.Marshal(objectMap)
}

// AzureFirewallPropertiesFormat properties of the Azure Firewall.
type AzureFirewallPropertiesFormat struct {
	// ApplicationRuleCollections - Collection of application rule collections used by Azure Firewall.
	ApplicationRuleCollections *[]AzureFirewallApplicationRuleCollection `json:"applicationRuleCollections,omitempty"`
	// NatRuleCollections - Collection of NAT rule collections used by Azure Firewall.
	NatRuleCollections *[]AzureFirewallNatRuleCollection `json:"natRuleCollections,omitempty"`
	// NetworkRuleCollections - Collection of network rule collections used by Azure Firewall.
	NetworkRuleCollections *[]AzureFirewallNetworkRuleCollection `json:"networkRuleCollections,omitempty"`
	// IPConfigurations - IP configuration of the Azure Firewall resource.
	IPConfigurations *[]AzureFirewallIPConfiguration `json:"ipConfigurations,omitempty"`
	// ManagementIPConfiguration - IP configuration of the Azure Firewall used for management traffic.
	ManagementIPConfiguration *AzureFirewallIPConfiguration `json:"managementIpConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the Azure firewall resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ThreatIntelMode - The operation mode for Threat Intelligence. Possible values include: 'AzureFirewallThreatIntelModeAlert', 'AzureFirewallThreatIntelModeDeny', 'AzureFirewallThreatIntelModeOff'
	ThreatIntelMode AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`
	// VirtualHub - The virtualHub to which the firewall belongs.
	VirtualHub *SubResource `json:"virtualHub,omitempty"`
	// FirewallPolicy - The firewallPolicy associated with this azure firewall.
	FirewallPolicy *SubResource `json:"firewallPolicy,omitempty"`
	// HubIPAddresses - IP addresses associated with AzureFirewall.
	HubIPAddresses *HubIPAddresses `json:"hubIPAddresses,omitempty"`
	// IPGroups - READ-ONLY; IpGroups associated with AzureFirewall.
	IPGroups *[]AzureFirewallIPGroups `json:"ipGroups,omitempty"`
	// Sku - The Azure Firewall Resource SKU.
	Sku *AzureFirewallSku `json:"sku,omitempty"`
	// AdditionalProperties - The additional properties used to further config this azure firewall.
	AdditionalProperties map[string]*string `json:"additionalProperties"`
}

// MarshalJSON is the custom marshaler for AzureFirewallPropertiesFormat.
func (afpf AzureFirewallPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afpf.ApplicationRuleCollections != nil {
		objectMap["applicationRuleCollections"] = afpf.ApplicationRuleCollections
	}
	if afpf.NatRuleCollections != nil {
		objectMap["natRuleCollections"] = afpf.NatRuleCollections
	}
	if afpf.NetworkRuleCollections != nil {
		objectMap["networkRuleCollections"] = afpf.NetworkRuleCollections
	}
	if afpf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = afpf.IPConfigurations
	}
	if afpf.ManagementIPConfiguration != nil {
		objectMap["managementIpConfiguration"] = afpf.ManagementIPConfiguration
	}
	if afpf.ThreatIntelMode != "" {
		objectMap["threatIntelMode"] = afpf.ThreatIntelMode
	}
	if afpf.VirtualHub != nil {
		objectMap["virtualHub"] = afpf.VirtualHub
	}
	if afpf.FirewallPolicy != nil {
		objectMap["firewallPolicy"] = afpf.FirewallPolicy
	}
	if afpf.HubIPAddresses != nil {
		objectMap["hubIPAddresses"] = afpf.HubIPAddresses
	}
	if afpf.Sku != nil {
		objectMap["sku"] = afpf.Sku
	}
	if afpf.AdditionalProperties != nil {
		objectMap["additionalProperties"] = afpf.AdditionalProperties
	}
	return json.Marshal(objectMap)
}

// AzureFirewallPublicIPAddress public IP Address associated with azure firewall.
type AzureFirewallPublicIPAddress struct {
	// Address - Public IP Address value.
	Address *string `json:"address,omitempty"`
}

// AzureFirewallRCAction properties of the AzureFirewallRCAction.
type AzureFirewallRCAction struct {
	// Type - The type of action. Possible values include: 'AzureFirewallRCActionTypeAllow', 'AzureFirewallRCActionTypeDeny'
	Type AzureFirewallRCActionType `json:"type,omitempty"`
}

// AzureFirewallsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureFirewallsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (AzureFirewall, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AzureFirewallsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AzureFirewallsCreateOrUpdateFuture.Result.
func (future *AzureFirewallsCreateOrUpdateFuture) result(client AzureFirewallsClient) (af AzureFirewall, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AzureFirewallsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		af.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AzureFirewallsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if af.Response.Response, err = future.GetResult(sender); err == nil && af.Response.Response.StatusCode != http.StatusNoContent {
		af, err = client.CreateOrUpdateResponder(af.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.AzureFirewallsCreateOrUpdateFuture", "Result", af.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AzureFirewallsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AzureFirewallsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AzureFirewallsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AzureFirewallsDeleteFuture.Result.
func (future *AzureFirewallsDeleteFuture) result(client AzureFirewallsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AzureFirewallsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AzureFirewallsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AzureFirewallSku SKU of an Azure Firewall.
type AzureFirewallSku struct {
	// Name - Name of an Azure Firewall SKU. Possible values include: 'AZFWVNet', 'AZFWHub'
	Name AzureFirewallSkuName `json:"name,omitempty"`
	// Tier - Tier of an Azure Firewall. Possible values include: 'AzureFirewallSkuTierStandard', 'AzureFirewallSkuTierPremium', 'AzureFirewallSkuTierBasic'
	Tier AzureFirewallSkuTier `json:"tier,omitempty"`
}

// AzureFirewallsListLearnedPrefixesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureFirewallsListLearnedPrefixesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (IPPrefixesList, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AzureFirewallsListLearnedPrefixesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AzureFirewallsListLearnedPrefixesFuture.Result.
func (future *AzureFirewallsListLearnedPrefixesFuture) result(client AzureFirewallsClient) (ipl IPPrefixesList, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AzureFirewallsListLearnedPrefixesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ipl.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AzureFirewallsListLearnedPrefixesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ipl.Response.Response, err = future.GetResult(sender); err == nil && ipl.Response.Response.StatusCode != http.StatusNoContent {
		ipl, err = client.ListLearnedPrefixesResponder(ipl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.AzureFirewallsListLearnedPrefixesFuture", "Result", ipl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AzureFirewallsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AzureFirewallsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AzureFirewallsClient) (AzureFirewall, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AzureFirewallsUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AzureFirewallsUpdateTagsFuture.Result.
func (future *AzureFirewallsUpdateTagsFuture) result(client AzureFirewallsClient) (af AzureFirewall, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.AzureFirewallsUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		af.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.AzureFirewallsUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if af.Response.Response, err = future.GetResult(sender); err == nil && af.Response.Response.StatusCode != http.StatusNoContent {
		af, err = client.UpdateTagsResponder(af.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.AzureFirewallsUpdateTagsFuture", "Result", af.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AzureReachabilityReport azure reachability report details.
type AzureReachabilityReport struct {
	autorest.Response `json:"-"`
	// AggregationLevel - The aggregation level of Azure reachability report. Can be Country, State or City.
	AggregationLevel *string `json:"aggregationLevel,omitempty"`
	// ProviderLocation - Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`
	// ReachabilityReport - List of Azure reachability report items.
	ReachabilityReport *[]AzureReachabilityReportItem `json:"reachabilityReport,omitempty"`
}

// AzureReachabilityReportItem azure reachability report details for a given provider location.
type AzureReachabilityReportItem struct {
	// Provider - The Internet service provider.
	Provider *string `json:"provider,omitempty"`
	// AzureLocation - The Azure region.
	AzureLocation *string `json:"azureLocation,omitempty"`
	// Latencies - List of latency details for each of the time series.
	Latencies *[]AzureReachabilityReportLatencyInfo `json:"latencies,omitempty"`
}

// AzureReachabilityReportLatencyInfo details on latency for a time series.
type AzureReachabilityReportLatencyInfo struct {
	// TimeStamp - The time stamp.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Score - The relative latency score between 1 and 100, higher values indicating a faster connection.
	Score *int32 `json:"score,omitempty"`
}

// AzureReachabilityReportLocation parameters that define a geographic location.
type AzureReachabilityReportLocation struct {
	// Country - The name of the country.
	Country *string `json:"country,omitempty"`
	// State - The name of the state.
	State *string `json:"state,omitempty"`
	// City - The name of the city or town.
	City *string `json:"city,omitempty"`
}

// AzureReachabilityReportParameters geographic and time constraints for Azure reachability report.
type AzureReachabilityReportParameters struct {
	// ProviderLocation - Parameters that define a geographic location.
	ProviderLocation *AzureReachabilityReportLocation `json:"providerLocation,omitempty"`
	// Providers - List of Internet service providers.
	Providers *[]string `json:"providers,omitempty"`
	// AzureLocations - Optional Azure regions to scope the query to.
	AzureLocations *[]string `json:"azureLocations,omitempty"`
	// StartTime - The start time for the Azure reachability report.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the Azure reachability report.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// AzureWebCategory azure Web Category Resource.
type AzureWebCategory struct {
	autorest.Response `json:"-"`
	// AzureWebCategoryPropertiesFormat - Properties of the Azure Web Category.
	*AzureWebCategoryPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWebCategory.
func (awc AzureWebCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if awc.AzureWebCategoryPropertiesFormat != nil {
		objectMap["properties"] = awc.AzureWebCategoryPropertiesFormat
	}
	if awc.ID != nil {
		objectMap["id"] = awc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureWebCategory struct.
func (awc *AzureWebCategory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureWebCategoryPropertiesFormat AzureWebCategoryPropertiesFormat
				err = json.Unmarshal(*v, &azureWebCategoryPropertiesFormat)
				if err != nil {
					return err
				}
				awc.AzureWebCategoryPropertiesFormat = &azureWebCategoryPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				awc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				awc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				awc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				awc.Etag = &etag
			}
		}
	}

	return nil
}

// AzureWebCategoryListResult response for ListAzureWebCategories API service call.
type AzureWebCategoryListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Azure Web Categories for a given Subscription.
	Value *[]AzureWebCategory `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AzureWebCategoryListResultIterator provides access to a complete listing of AzureWebCategory values.
type AzureWebCategoryListResultIterator struct {
	i    int
	page AzureWebCategoryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureWebCategoryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureWebCategoryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureWebCategoryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureWebCategoryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureWebCategoryListResultIterator) Response() AzureWebCategoryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureWebCategoryListResultIterator) Value() AzureWebCategory {
	if !iter.page.NotDone() {
		return AzureWebCategory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureWebCategoryListResultIterator type.
func NewAzureWebCategoryListResultIterator(page AzureWebCategoryListResultPage) AzureWebCategoryListResultIterator {
	return AzureWebCategoryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (awclr AzureWebCategoryListResult) IsEmpty() bool {
	return awclr.Value == nil || len(*awclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (awclr AzureWebCategoryListResult) hasNextLink() bool {
	return awclr.NextLink != nil && len(*awclr.NextLink) != 0
}

// azureWebCategoryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (awclr AzureWebCategoryListResult) azureWebCategoryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !awclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(awclr.NextLink)))
}

// AzureWebCategoryListResultPage contains a page of AzureWebCategory values.
type AzureWebCategoryListResultPage struct {
	fn    func(context.Context, AzureWebCategoryListResult) (AzureWebCategoryListResult, error)
	awclr AzureWebCategoryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureWebCategoryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureWebCategoryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.awclr)
		if err != nil {
			return err
		}
		page.awclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureWebCategoryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureWebCategoryListResultPage) NotDone() bool {
	return !page.awclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureWebCategoryListResultPage) Response() AzureWebCategoryListResult {
	return page.awclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureWebCategoryListResultPage) Values() []AzureWebCategory {
	if page.awclr.IsEmpty() {
		return nil
	}
	return *page.awclr.Value
}

// Creates a new instance of the AzureWebCategoryListResultPage type.
func NewAzureWebCategoryListResultPage(cur AzureWebCategoryListResult, getNextPage func(context.Context, AzureWebCategoryListResult) (AzureWebCategoryListResult, error)) AzureWebCategoryListResultPage {
	return AzureWebCategoryListResultPage{
		fn:    getNextPage,
		awclr: cur,
	}
}

// AzureWebCategoryPropertiesFormat azure Web Category Properties.
type AzureWebCategoryPropertiesFormat struct {
	// Group - READ-ONLY; The name of the group that the category belongs to.
	Group *string `json:"group,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureWebCategoryPropertiesFormat.
func (awcpf AzureWebCategoryPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackendAddressInboundNatRulePortMappings the response for a QueryInboundNatRulePortMapping API.
type BackendAddressInboundNatRulePortMappings struct {
	autorest.Response `json:"-"`
	// InboundNatRulePortMappings - Collection of inbound NAT rule port mappings.
	InboundNatRulePortMappings *[]InboundNatRulePortMapping `json:"inboundNatRulePortMappings,omitempty"`
}

// BackendAddressPool pool of backend IP addresses.
type BackendAddressPool struct {
	autorest.Response `json:"-"`
	// BackendAddressPoolPropertiesFormat - Properties of load balancer backend address pool.
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bap.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// BackendAddressPoolPropertiesFormat properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// Location - The location of the backend address pool.
	Location *string `json:"location,omitempty"`
	// TunnelInterfaces - An array of gateway load balancer tunnel interfaces.
	TunnelInterfaces *[]GatewayLoadBalancerTunnelInterface `json:"tunnelInterfaces,omitempty"`
	// LoadBalancerBackendAddresses - An array of backend addresses.
	LoadBalancerBackendAddresses *[]LoadBalancerBackendAddress `json:"loadBalancerBackendAddresses,omitempty"`
	// BackendIPConfigurations - READ-ONLY; An array of references to IP addresses defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - READ-ONLY; An array of references to load balancing rules that use this backend address pool.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundRule - READ-ONLY; A reference to an outbound rule that uses this backend address pool.
	OutboundRule *SubResource `json:"outboundRule,omitempty"`
	// OutboundRules - READ-ONLY; An array of references to outbound rules that use this backend address pool.
	OutboundRules *[]SubResource `json:"outboundRules,omitempty"`
	// InboundNatRules - READ-ONLY; An array of references to inbound NAT rules that use this backend address pool.
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the backend address pool resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DrainPeriodInSeconds - Amount of seconds Load Balancer waits for before sending RESET to client and backend address.
	DrainPeriodInSeconds *int32 `json:"drainPeriodInSeconds,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPoolPropertiesFormat.
func (bappf BackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bappf.Location != nil {
		objectMap["location"] = bappf.Location
	}
	if bappf.TunnelInterfaces != nil {
		objectMap["tunnelInterfaces"] = bappf.TunnelInterfaces
	}
	if bappf.LoadBalancerBackendAddresses != nil {
		objectMap["loadBalancerBackendAddresses"] = bappf.LoadBalancerBackendAddresses
	}
	if bappf.DrainPeriodInSeconds != nil {
		objectMap["drainPeriodInSeconds"] = bappf.DrainPeriodInSeconds
	}
	return json.Marshal(objectMap)
}

// BasicBaseAdminRule network base admin rule.
type BasicBaseAdminRule interface {
	AsAdminRule() (*AdminRule, bool)
	AsDefaultAdminRule() (*DefaultAdminRule, bool)
	AsBaseAdminRule() (*BaseAdminRule, bool)
}

// BaseAdminRule network base admin rule.
type BaseAdminRule struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindBasicBaseAdminRuleKindBaseAdminRule', 'KindBasicBaseAdminRuleKindCustom', 'KindBasicBaseAdminRuleKindDefault'
	Kind KindBasicBaseAdminRule `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

func unmarshalBasicBaseAdminRule(body []byte) (BasicBaseAdminRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicBaseAdminRuleKindCustom):
		var ar AdminRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	case string(KindBasicBaseAdminRuleKindDefault):
		var dar DefaultAdminRule
		err := json.Unmarshal(body, &dar)
		return dar, err
	default:
		var bar BaseAdminRule
		err := json.Unmarshal(body, &bar)
		return bar, err
	}
}
func unmarshalBasicBaseAdminRuleArray(body []byte) ([]BasicBaseAdminRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	barArray := make([]BasicBaseAdminRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bar, err := unmarshalBasicBaseAdminRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		barArray[index] = bar
	}
	return barArray, nil
}

// MarshalJSON is the custom marshaler for BaseAdminRule.
func (bar BaseAdminRule) MarshalJSON() ([]byte, error) {
	bar.Kind = KindBasicBaseAdminRuleKindBaseAdminRule
	objectMap := make(map[string]interface{})
	if bar.Kind != "" {
		objectMap["kind"] = bar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAdminRule is the BasicBaseAdminRule implementation for BaseAdminRule.
func (bar BaseAdminRule) AsAdminRule() (*AdminRule, bool) {
	return nil, false
}

// AsDefaultAdminRule is the BasicBaseAdminRule implementation for BaseAdminRule.
func (bar BaseAdminRule) AsDefaultAdminRule() (*DefaultAdminRule, bool) {
	return nil, false
}

// AsBaseAdminRule is the BasicBaseAdminRule implementation for BaseAdminRule.
func (bar BaseAdminRule) AsBaseAdminRule() (*BaseAdminRule, bool) {
	return &bar, true
}

// AsBasicBaseAdminRule is the BasicBaseAdminRule implementation for BaseAdminRule.
func (bar BaseAdminRule) AsBasicBaseAdminRule() (BasicBaseAdminRule, bool) {
	return &bar, true
}

// BaseAdminRuleModel ...
type BaseAdminRuleModel struct {
	autorest.Response `json:"-"`
	Value             BasicBaseAdminRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BaseAdminRuleModel struct.
func (barm *BaseAdminRuleModel) UnmarshalJSON(body []byte) error {
	bar, err := unmarshalBasicBaseAdminRule(body)
	if err != nil {
		return err
	}
	barm.Value = bar

	return nil
}

// BastionActiveSession the session detail for a target.
type BastionActiveSession struct {
	// SessionID - READ-ONLY; A unique id for the session.
	SessionID *string `json:"sessionId,omitempty"`
	// StartTime - READ-ONLY; The time when the session started.
	StartTime interface{} `json:"startTime,omitempty"`
	// TargetSubscriptionID - READ-ONLY; The subscription id for the target virtual machine.
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`
	// ResourceType - READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
	// TargetHostName - READ-ONLY; The host name of the target.
	TargetHostName *string `json:"targetHostName,omitempty"`
	// TargetResourceGroup - READ-ONLY; The resource group of the target.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
	// UserName - READ-ONLY; The user name who is active on this session.
	UserName *string `json:"userName,omitempty"`
	// TargetIPAddress - READ-ONLY; The IP Address of the target.
	TargetIPAddress *string `json:"targetIpAddress,omitempty"`
	// Protocol - READ-ONLY; The protocol used to connect to the target. Possible values include: 'SSH', 'RDP'
	Protocol BastionConnectProtocol `json:"protocol,omitempty"`
	// TargetResourceID - READ-ONLY; The resource id of the target.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// SessionDurationInMins - READ-ONLY; Duration in mins the session has been active.
	SessionDurationInMins *float64 `json:"sessionDurationInMins,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionActiveSession.
func (bas BastionActiveSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BastionActiveSessionListResult response for GetActiveSessions.
type BastionActiveSessionListResult struct {
	autorest.Response `json:"-"`
	// Value - List of active sessions on the bastion.
	Value *[]BastionActiveSession `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BastionActiveSessionListResultIterator provides access to a complete listing of BastionActiveSession
// values.
type BastionActiveSessionListResultIterator struct {
	i    int
	page BastionActiveSessionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BastionActiveSessionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionActiveSessionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BastionActiveSessionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BastionActiveSessionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BastionActiveSessionListResultIterator) Response() BastionActiveSessionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BastionActiveSessionListResultIterator) Value() BastionActiveSession {
	if !iter.page.NotDone() {
		return BastionActiveSession{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BastionActiveSessionListResultIterator type.
func NewBastionActiveSessionListResultIterator(page BastionActiveSessionListResultPage) BastionActiveSessionListResultIterator {
	return BastionActiveSessionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (baslr BastionActiveSessionListResult) IsEmpty() bool {
	return baslr.Value == nil || len(*baslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (baslr BastionActiveSessionListResult) hasNextLink() bool {
	return baslr.NextLink != nil && len(*baslr.NextLink) != 0
}

// bastionActiveSessionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (baslr BastionActiveSessionListResult) bastionActiveSessionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !baslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(baslr.NextLink)))
}

// BastionActiveSessionListResultPage contains a page of BastionActiveSession values.
type BastionActiveSessionListResultPage struct {
	fn    func(context.Context, BastionActiveSessionListResult) (BastionActiveSessionListResult, error)
	baslr BastionActiveSessionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BastionActiveSessionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionActiveSessionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.baslr)
		if err != nil {
			return err
		}
		page.baslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BastionActiveSessionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BastionActiveSessionListResultPage) NotDone() bool {
	return !page.baslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BastionActiveSessionListResultPage) Response() BastionActiveSessionListResult {
	return page.baslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BastionActiveSessionListResultPage) Values() []BastionActiveSession {
	if page.baslr.IsEmpty() {
		return nil
	}
	return *page.baslr.Value
}

// Creates a new instance of the BastionActiveSessionListResultPage type.
func NewBastionActiveSessionListResultPage(cur BastionActiveSessionListResult, getNextPage func(context.Context, BastionActiveSessionListResult) (BastionActiveSessionListResult, error)) BastionActiveSessionListResultPage {
	return BastionActiveSessionListResultPage{
		fn:    getNextPage,
		baslr: cur,
	}
}

// BastionHost bastion Host resource.
type BastionHost struct {
	autorest.Response `json:"-"`
	// BastionHostPropertiesFormat - Represents the bastion host resource.
	*BastionHostPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Sku - The sku of this Bastion Host.
	Sku *Sku `json:"sku,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BastionHost.
func (bh BastionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bh.BastionHostPropertiesFormat != nil {
		objectMap["properties"] = bh.BastionHostPropertiesFormat
	}
	if bh.Sku != nil {
		objectMap["sku"] = bh.Sku
	}
	if bh.ID != nil {
		objectMap["id"] = bh.ID
	}
	if bh.Location != nil {
		objectMap["location"] = bh.Location
	}
	if bh.Tags != nil {
		objectMap["tags"] = bh.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BastionHost struct.
func (bh *BastionHost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bastionHostPropertiesFormat BastionHostPropertiesFormat
				err = json.Unmarshal(*v, &bastionHostPropertiesFormat)
				if err != nil {
					return err
				}
				bh.BastionHostPropertiesFormat = &bastionHostPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bh.Etag = &etag
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				bh.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bh.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bh.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bh.Tags = tags
			}
		}
	}

	return nil
}

// BastionHostIPConfiguration IP configuration of an Bastion Host.
type BastionHostIPConfiguration struct {
	// BastionHostIPConfigurationPropertiesFormat - Represents the ip configuration associated with the resource.
	*BastionHostIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Ip configuration type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionHostIPConfiguration.
func (bhic BastionHostIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bhic.BastionHostIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = bhic.BastionHostIPConfigurationPropertiesFormat
	}
	if bhic.Name != nil {
		objectMap["name"] = bhic.Name
	}
	if bhic.ID != nil {
		objectMap["id"] = bhic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BastionHostIPConfiguration struct.
func (bhic *BastionHostIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bastionHostIPConfigurationPropertiesFormat BastionHostIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &bastionHostIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				bhic.BastionHostIPConfigurationPropertiesFormat = &bastionHostIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bhic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bhic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bhic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bhic.ID = &ID
			}
		}
	}

	return nil
}

// BastionHostIPConfigurationPropertiesFormat properties of IP configuration of an Bastion Host.
type BastionHostIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the bastion host IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateIPAllocationMethod - Private IP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionHostIPConfigurationPropertiesFormat.
func (bhicpf BastionHostIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bhicpf.Subnet != nil {
		objectMap["subnet"] = bhicpf.Subnet
	}
	if bhicpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = bhicpf.PublicIPAddress
	}
	if bhicpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = bhicpf.PrivateIPAllocationMethod
	}
	return json.Marshal(objectMap)
}

// BastionHostListResult response for ListBastionHosts API service call.
type BastionHostListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Bastion Hosts in a resource group.
	Value *[]BastionHost `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BastionHostListResultIterator provides access to a complete listing of BastionHost values.
type BastionHostListResultIterator struct {
	i    int
	page BastionHostListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BastionHostListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionHostListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BastionHostListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BastionHostListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BastionHostListResultIterator) Response() BastionHostListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BastionHostListResultIterator) Value() BastionHost {
	if !iter.page.NotDone() {
		return BastionHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BastionHostListResultIterator type.
func NewBastionHostListResultIterator(page BastionHostListResultPage) BastionHostListResultIterator {
	return BastionHostListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bhlr BastionHostListResult) IsEmpty() bool {
	return bhlr.Value == nil || len(*bhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bhlr BastionHostListResult) hasNextLink() bool {
	return bhlr.NextLink != nil && len(*bhlr.NextLink) != 0
}

// bastionHostListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bhlr BastionHostListResult) bastionHostListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bhlr.NextLink)))
}

// BastionHostListResultPage contains a page of BastionHost values.
type BastionHostListResultPage struct {
	fn   func(context.Context, BastionHostListResult) (BastionHostListResult, error)
	bhlr BastionHostListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BastionHostListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionHostListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bhlr)
		if err != nil {
			return err
		}
		page.bhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BastionHostListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BastionHostListResultPage) NotDone() bool {
	return !page.bhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BastionHostListResultPage) Response() BastionHostListResult {
	return page.bhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BastionHostListResultPage) Values() []BastionHost {
	if page.bhlr.IsEmpty() {
		return nil
	}
	return *page.bhlr.Value
}

// Creates a new instance of the BastionHostListResultPage type.
func NewBastionHostListResultPage(cur BastionHostListResult, getNextPage func(context.Context, BastionHostListResult) (BastionHostListResult, error)) BastionHostListResultPage {
	return BastionHostListResultPage{
		fn:   getNextPage,
		bhlr: cur,
	}
}

// BastionHostPropertiesFormat properties of the Bastion Host.
type BastionHostPropertiesFormat struct {
	// IPConfigurations - IP configuration of the Bastion Host resource.
	IPConfigurations *[]BastionHostIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSName - FQDN for the endpoint on which bastion host is accessible.
	DNSName *string `json:"dnsName,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the bastion host resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ScaleUnits - The scale units for the Bastion Host resource.
	ScaleUnits *int32 `json:"scaleUnits,omitempty"`
	// DisableCopyPaste - Enable/Disable Copy/Paste feature of the Bastion Host resource.
	DisableCopyPaste *bool `json:"disableCopyPaste,omitempty"`
	// EnableFileCopy - Enable/Disable File Copy feature of the Bastion Host resource.
	EnableFileCopy *bool `json:"enableFileCopy,omitempty"`
	// EnableIPConnect - Enable/Disable IP Connect feature of the Bastion Host resource.
	EnableIPConnect *bool `json:"enableIpConnect,omitempty"`
	// EnableShareableLink - Enable/Disable Shareable Link of the Bastion Host resource.
	EnableShareableLink *bool `json:"enableShareableLink,omitempty"`
	// EnableTunneling - Enable/Disable Tunneling feature of the Bastion Host resource.
	EnableTunneling *bool `json:"enableTunneling,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionHostPropertiesFormat.
func (bhpf BastionHostPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bhpf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = bhpf.IPConfigurations
	}
	if bhpf.DNSName != nil {
		objectMap["dnsName"] = bhpf.DNSName
	}
	if bhpf.ScaleUnits != nil {
		objectMap["scaleUnits"] = bhpf.ScaleUnits
	}
	if bhpf.DisableCopyPaste != nil {
		objectMap["disableCopyPaste"] = bhpf.DisableCopyPaste
	}
	if bhpf.EnableFileCopy != nil {
		objectMap["enableFileCopy"] = bhpf.EnableFileCopy
	}
	if bhpf.EnableIPConnect != nil {
		objectMap["enableIpConnect"] = bhpf.EnableIPConnect
	}
	if bhpf.EnableShareableLink != nil {
		objectMap["enableShareableLink"] = bhpf.EnableShareableLink
	}
	if bhpf.EnableTunneling != nil {
		objectMap["enableTunneling"] = bhpf.EnableTunneling
	}
	return json.Marshal(objectMap)
}

// BastionHostsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type BastionHostsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BastionHostsClient) (BastionHost, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BastionHostsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BastionHostsCreateOrUpdateFuture.Result.
func (future *BastionHostsCreateOrUpdateFuture) result(client BastionHostsClient) (bh BastionHost, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.BastionHostsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.BastionHostsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bh.Response.Response, err = future.GetResult(sender); err == nil && bh.Response.Response.StatusCode != http.StatusNoContent {
		bh, err = client.CreateOrUpdateResponder(bh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.BastionHostsCreateOrUpdateFuture", "Result", bh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BastionHostsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BastionHostsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BastionHostsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BastionHostsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BastionHostsDeleteFuture.Result.
func (future *BastionHostsDeleteFuture) result(client BastionHostsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.BastionHostsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.BastionHostsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BastionHostsUpdateTagsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BastionHostsUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BastionHostsClient) (BastionHost, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BastionHostsUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BastionHostsUpdateTagsFuture.Result.
func (future *BastionHostsUpdateTagsFuture) result(client BastionHostsClient) (bh BastionHost, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.BastionHostsUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.BastionHostsUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bh.Response.Response, err = future.GetResult(sender); err == nil && bh.Response.Response.StatusCode != http.StatusNoContent {
		bh, err = client.UpdateTagsResponder(bh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.BastionHostsUpdateTagsFuture", "Result", bh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BastionSessionDeleteResult response for DisconnectActiveSessions.
type BastionSessionDeleteResult struct {
	autorest.Response `json:"-"`
	// Value - List of sessions with their corresponding state.
	Value *[]BastionSessionState `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BastionSessionDeleteResultIterator provides access to a complete listing of BastionSessionState values.
type BastionSessionDeleteResultIterator struct {
	i    int
	page BastionSessionDeleteResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BastionSessionDeleteResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionSessionDeleteResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BastionSessionDeleteResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BastionSessionDeleteResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BastionSessionDeleteResultIterator) Response() BastionSessionDeleteResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BastionSessionDeleteResultIterator) Value() BastionSessionState {
	if !iter.page.NotDone() {
		return BastionSessionState{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BastionSessionDeleteResultIterator type.
func NewBastionSessionDeleteResultIterator(page BastionSessionDeleteResultPage) BastionSessionDeleteResultIterator {
	return BastionSessionDeleteResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsdr BastionSessionDeleteResult) IsEmpty() bool {
	return bsdr.Value == nil || len(*bsdr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsdr BastionSessionDeleteResult) hasNextLink() bool {
	return bsdr.NextLink != nil && len(*bsdr.NextLink) != 0
}

// bastionSessionDeleteResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsdr BastionSessionDeleteResult) bastionSessionDeleteResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bsdr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsdr.NextLink)))
}

// BastionSessionDeleteResultPage contains a page of BastionSessionState values.
type BastionSessionDeleteResultPage struct {
	fn   func(context.Context, BastionSessionDeleteResult) (BastionSessionDeleteResult, error)
	bsdr BastionSessionDeleteResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BastionSessionDeleteResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionSessionDeleteResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsdr)
		if err != nil {
			return err
		}
		page.bsdr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BastionSessionDeleteResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BastionSessionDeleteResultPage) NotDone() bool {
	return !page.bsdr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BastionSessionDeleteResultPage) Response() BastionSessionDeleteResult {
	return page.bsdr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BastionSessionDeleteResultPage) Values() []BastionSessionState {
	if page.bsdr.IsEmpty() {
		return nil
	}
	return *page.bsdr.Value
}

// Creates a new instance of the BastionSessionDeleteResultPage type.
func NewBastionSessionDeleteResultPage(cur BastionSessionDeleteResult, getNextPage func(context.Context, BastionSessionDeleteResult) (BastionSessionDeleteResult, error)) BastionSessionDeleteResultPage {
	return BastionSessionDeleteResultPage{
		fn:   getNextPage,
		bsdr: cur,
	}
}

// BastionSessionState the session state detail for a target.
type BastionSessionState struct {
	// SessionID - READ-ONLY; A unique id for the session.
	SessionID *string `json:"sessionId,omitempty"`
	// Message - READ-ONLY; Used for extra information.
	Message *string `json:"message,omitempty"`
	// State - READ-ONLY; The state of the session. Disconnected/Failed/NotFound.
	State *string `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionSessionState.
func (bss BastionSessionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BastionShareableLink bastion Shareable Link.
type BastionShareableLink struct {
	// VM - Reference of the virtual machine resource.
	VM *VM `json:"vm,omitempty"`
	// Bsl - READ-ONLY; The unique Bastion Shareable Link to the virtual machine.
	Bsl *string `json:"bsl,omitempty"`
	// CreatedAt - READ-ONLY; The time when the link was created.
	CreatedAt *string `json:"createdAt,omitempty"`
	// Message - READ-ONLY; Optional field indicating the warning or error message related to the vm in case of partial failure.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for BastionShareableLink.
func (bsl BastionShareableLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsl.VM != nil {
		objectMap["vm"] = bsl.VM
	}
	return json.Marshal(objectMap)
}

// BastionShareableLinkListRequest post request for all the Bastion Shareable Link endpoints.
type BastionShareableLinkListRequest struct {
	// Vms - List of VM references.
	Vms *[]BastionShareableLink `json:"vms,omitempty"`
}

// BastionShareableLinkListResult response for all the Bastion Shareable Link endpoints.
type BastionShareableLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Bastion Shareable Links for the request.
	Value *[]BastionShareableLink `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BastionShareableLinkListResultIterator provides access to a complete listing of BastionShareableLink
// values.
type BastionShareableLinkListResultIterator struct {
	i    int
	page BastionShareableLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BastionShareableLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionShareableLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BastionShareableLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BastionShareableLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BastionShareableLinkListResultIterator) Response() BastionShareableLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BastionShareableLinkListResultIterator) Value() BastionShareableLink {
	if !iter.page.NotDone() {
		return BastionShareableLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BastionShareableLinkListResultIterator type.
func NewBastionShareableLinkListResultIterator(page BastionShareableLinkListResultPage) BastionShareableLinkListResultIterator {
	return BastionShareableLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsllr BastionShareableLinkListResult) IsEmpty() bool {
	return bsllr.Value == nil || len(*bsllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsllr BastionShareableLinkListResult) hasNextLink() bool {
	return bsllr.NextLink != nil && len(*bsllr.NextLink) != 0
}

// bastionShareableLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsllr BastionShareableLinkListResult) bastionShareableLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bsllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsllr.NextLink)))
}

// BastionShareableLinkListResultPage contains a page of BastionShareableLink values.
type BastionShareableLinkListResultPage struct {
	fn    func(context.Context, BastionShareableLinkListResult) (BastionShareableLinkListResult, error)
	bsllr BastionShareableLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BastionShareableLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BastionShareableLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsllr)
		if err != nil {
			return err
		}
		page.bsllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BastionShareableLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BastionShareableLinkListResultPage) NotDone() bool {
	return !page.bsllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BastionShareableLinkListResultPage) Response() BastionShareableLinkListResult {
	return page.bsllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BastionShareableLinkListResultPage) Values() []BastionShareableLink {
	if page.bsllr.IsEmpty() {
		return nil
	}
	return *page.bsllr.Value
}

// Creates a new instance of the BastionShareableLinkListResultPage type.
func NewBastionShareableLinkListResultPage(cur BastionShareableLinkListResult, getNextPage func(context.Context, BastionShareableLinkListResult) (BastionShareableLinkListResult, error)) BastionShareableLinkListResultPage {
	return BastionShareableLinkListResultPage{
		fn:    getNextPage,
		bsllr: cur,
	}
}

// BGPCommunity contains bgp community information offered in Service Community resources.
type BGPCommunity struct {
	// ServiceSupportedRegion - The region which the service support. e.g. For O365, region is Global.
	ServiceSupportedRegion *string `json:"serviceSupportedRegion,omitempty"`
	// CommunityName - The name of the bgp community. e.g. Skype.
	CommunityName *string `json:"communityName,omitempty"`
	// CommunityValue - The value of the bgp community. For more information: https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
	CommunityValue *string `json:"communityValue,omitempty"`
	// CommunityPrefixes - The prefixes that the bgp community contains.
	CommunityPrefixes *[]string `json:"communityPrefixes,omitempty"`
	// IsAuthorizedToUse - Customer is authorized to use bgp community or not.
	IsAuthorizedToUse *bool `json:"isAuthorizedToUse,omitempty"`
	// ServiceGroup - The service group of the bgp community contains.
	ServiceGroup *string `json:"serviceGroup,omitempty"`
}

// BgpConnection virtual Appliance Site resource.
type BgpConnection struct {
	autorest.Response `json:"-"`
	// BgpConnectionProperties - The properties of the Bgp connections.
	*BgpConnectionProperties `json:"properties,omitempty"`
	// Name - Name of the connection.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Connection type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BgpConnection.
func (bc BgpConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.BgpConnectionProperties != nil {
		objectMap["properties"] = bc.BgpConnectionProperties
	}
	if bc.Name != nil {
		objectMap["name"] = bc.Name
	}
	if bc.ID != nil {
		objectMap["id"] = bc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BgpConnection struct.
func (bc *BgpConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bgpConnectionProperties BgpConnectionProperties
				err = json.Unmarshal(*v, &bgpConnectionProperties)
				if err != nil {
					return err
				}
				bc.BgpConnectionProperties = &bgpConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		}
	}

	return nil
}

// BgpConnectionProperties properties of the bgp connection.
type BgpConnectionProperties struct {
	// PeerAsn - Peer ASN.
	PeerAsn *int64 `json:"peerAsn,omitempty"`
	// PeerIP - Peer IP.
	PeerIP *string `json:"peerIp,omitempty"`
	// HubVirtualNetworkConnection - The reference to the HubVirtualNetworkConnection resource.
	HubVirtualNetworkConnection *SubResource `json:"hubVirtualNetworkConnection,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ConnectionState - READ-ONLY; The current state of the VirtualHub to Peer. Possible values include: 'HubBgpConnectionStatusUnknown', 'HubBgpConnectionStatusConnecting', 'HubBgpConnectionStatusConnected', 'HubBgpConnectionStatusNotConnected'
	ConnectionState HubBgpConnectionStatus `json:"connectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for BgpConnectionProperties.
func (bcp BgpConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bcp.PeerAsn != nil {
		objectMap["peerAsn"] = bcp.PeerAsn
	}
	if bcp.PeerIP != nil {
		objectMap["peerIp"] = bcp.PeerIP
	}
	if bcp.HubVirtualNetworkConnection != nil {
		objectMap["hubVirtualNetworkConnection"] = bcp.HubVirtualNetworkConnection
	}
	return json.Marshal(objectMap)
}

// BgpPeerStatus BGP peer status details.
type BgpPeerStatus struct {
	// LocalAddress - READ-ONLY; The virtual network gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty"`
	// Neighbor - READ-ONLY; The remote BGP peer.
	Neighbor *string `json:"neighbor,omitempty"`
	// Asn - READ-ONLY; The autonomous system number of the remote BGP peer.
	Asn *int64 `json:"asn,omitempty"`
	// State - READ-ONLY; The BGP peer state. Possible values include: 'BgpPeerStateUnknown', 'BgpPeerStateStopped', 'BgpPeerStateIdle', 'BgpPeerStateConnecting', 'BgpPeerStateConnected'
	State BgpPeerState `json:"state,omitempty"`
	// ConnectedDuration - READ-ONLY; For how long the peering has been up.
	ConnectedDuration *string `json:"connectedDuration,omitempty"`
	// RoutesReceived - READ-ONLY; The number of routes learned from this peer.
	RoutesReceived *int64 `json:"routesReceived,omitempty"`
	// MessagesSent - READ-ONLY; The number of BGP messages sent.
	MessagesSent *int64 `json:"messagesSent,omitempty"`
	// MessagesReceived - READ-ONLY; The number of BGP messages received.
	MessagesReceived *int64 `json:"messagesReceived,omitempty"`
}

// MarshalJSON is the custom marshaler for BgpPeerStatus.
func (bps BgpPeerStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BgpPeerStatusListResult response for list BGP peer status API service call.
type BgpPeerStatusListResult struct {
	autorest.Response `json:"-"`
	// Value - List of BGP peers.
	Value *[]BgpPeerStatus `json:"value,omitempty"`
}

// BgpServiceCommunity service Community Properties.
type BgpServiceCommunity struct {
	// BgpServiceCommunityPropertiesFormat - Properties of the BGP service community.
	*BgpServiceCommunityPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for BgpServiceCommunity.
func (bsc BgpServiceCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsc.BgpServiceCommunityPropertiesFormat != nil {
		objectMap["properties"] = bsc.BgpServiceCommunityPropertiesFormat
	}
	if bsc.ID != nil {
		objectMap["id"] = bsc.ID
	}
	if bsc.Location != nil {
		objectMap["location"] = bsc.Location
	}
	if bsc.Tags != nil {
		objectMap["tags"] = bsc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BgpServiceCommunity struct.
func (bsc *BgpServiceCommunity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bgpServiceCommunityPropertiesFormat BgpServiceCommunityPropertiesFormat
				err = json.Unmarshal(*v, &bgpServiceCommunityPropertiesFormat)
				if err != nil {
					return err
				}
				bsc.BgpServiceCommunityPropertiesFormat = &bgpServiceCommunityPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bsc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bsc.Tags = tags
			}
		}
	}

	return nil
}

// BgpServiceCommunityListResult response for the ListServiceCommunity API service call.
type BgpServiceCommunityListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of service community resources.
	Value *[]BgpServiceCommunity `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BgpServiceCommunityListResultIterator provides access to a complete listing of BgpServiceCommunity
// values.
type BgpServiceCommunityListResultIterator struct {
	i    int
	page BgpServiceCommunityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BgpServiceCommunityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BgpServiceCommunityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BgpServiceCommunityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BgpServiceCommunityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BgpServiceCommunityListResultIterator) Response() BgpServiceCommunityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BgpServiceCommunityListResultIterator) Value() BgpServiceCommunity {
	if !iter.page.NotDone() {
		return BgpServiceCommunity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BgpServiceCommunityListResultIterator type.
func NewBgpServiceCommunityListResultIterator(page BgpServiceCommunityListResultPage) BgpServiceCommunityListResultIterator {
	return BgpServiceCommunityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bsclr BgpServiceCommunityListResult) IsEmpty() bool {
	return bsclr.Value == nil || len(*bsclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bsclr BgpServiceCommunityListResult) hasNextLink() bool {
	return bsclr.NextLink != nil && len(*bsclr.NextLink) != 0
}

// bgpServiceCommunityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bsclr BgpServiceCommunityListResult) bgpServiceCommunityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bsclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bsclr.NextLink)))
}

// BgpServiceCommunityListResultPage contains a page of BgpServiceCommunity values.
type BgpServiceCommunityListResultPage struct {
	fn    func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)
	bsclr BgpServiceCommunityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BgpServiceCommunityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BgpServiceCommunityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bsclr)
		if err != nil {
			return err
		}
		page.bsclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BgpServiceCommunityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BgpServiceCommunityListResultPage) NotDone() bool {
	return !page.bsclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BgpServiceCommunityListResultPage) Response() BgpServiceCommunityListResult {
	return page.bsclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BgpServiceCommunityListResultPage) Values() []BgpServiceCommunity {
	if page.bsclr.IsEmpty() {
		return nil
	}
	return *page.bsclr.Value
}

// Creates a new instance of the BgpServiceCommunityListResultPage type.
func NewBgpServiceCommunityListResultPage(cur BgpServiceCommunityListResult, getNextPage func(context.Context, BgpServiceCommunityListResult) (BgpServiceCommunityListResult, error)) BgpServiceCommunityListResultPage {
	return BgpServiceCommunityListResultPage{
		fn:    getNextPage,
		bsclr: cur,
	}
}

// BgpServiceCommunityPropertiesFormat properties of Service Community.
type BgpServiceCommunityPropertiesFormat struct {
	// ServiceName - The name of the bgp community. e.g. Skype.
	ServiceName *string `json:"serviceName,omitempty"`
	// BgpCommunities - A list of bgp communities.
	BgpCommunities *[]BGPCommunity `json:"bgpCommunities,omitempty"`
}

// BgpSettings BGP settings details.
type BgpSettings struct {
	// Asn - The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`
	// BgpPeeringAddress - The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	// PeerWeight - The weight added to routes learned from this BGP speaker.
	PeerWeight *int32 `json:"peerWeight,omitempty"`
	// BgpPeeringAddresses - BGP peering address with IP configuration ID for virtual network gateway.
	BgpPeeringAddresses *[]IPConfigurationBgpPeeringAddress `json:"bgpPeeringAddresses,omitempty"`
}

// BreakOutCategoryPolicies network Virtual Appliance Sku Properties.
type BreakOutCategoryPolicies struct {
	// Allow - Flag to control breakout of o365 allow category.
	Allow *bool `json:"allow,omitempty"`
	// Optimize - Flag to control breakout of o365 optimize category.
	Optimize *bool `json:"optimize,omitempty"`
	// Default - Flag to control breakout of o365 default category.
	Default *bool `json:"default,omitempty"`
}

// CheckPrivateLinkServiceVisibilityRequest request body of the CheckPrivateLinkServiceVisibility API
// service call.
type CheckPrivateLinkServiceVisibilityRequest struct {
	// PrivateLinkServiceAlias - The alias of the private link service.
	PrivateLinkServiceAlias *string `json:"privateLinkServiceAlias,omitempty"`
}

// ChildResource proxy resource representation.
type ChildResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ChildResource.
func (cr ChildResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ConfigurationDiagnosticParameters parameters to get network configuration diagnostic.
type ConfigurationDiagnosticParameters struct {
	// TargetResourceID - The ID of the target resource to perform network configuration diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application Gateway.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// VerbosityLevel - Verbosity level. Possible values include: 'VerbosityLevelNormal', 'VerbosityLevelMinimum', 'VerbosityLevelFull'
	VerbosityLevel VerbosityLevel `json:"verbosityLevel,omitempty"`
	// Profiles - List of network configuration diagnostic profiles.
	Profiles *[]ConfigurationDiagnosticProfile `json:"profiles,omitempty"`
}

// ConfigurationDiagnosticProfile parameters to compare with network configuration.
type ConfigurationDiagnosticProfile struct {
	// Direction - The direction of the traffic. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// Protocol - Protocol to be verified on. Accepted values are '*', TCP, UDP.
	Protocol *string `json:"protocol,omitempty"`
	// Source - Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
	Source *string `json:"source,omitempty"`
	// Destination - Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
	Destination *string `json:"destination,omitempty"`
	// DestinationPort - Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535).
	DestinationPort *string `json:"destinationPort,omitempty"`
}

// ConfigurationDiagnosticResponse results of network configuration diagnostic on the target resource.
type ConfigurationDiagnosticResponse struct {
	autorest.Response `json:"-"`
	// Results - READ-ONLY; List of network configuration diagnostic results.
	Results *[]ConfigurationDiagnosticResult `json:"results,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationDiagnosticResponse.
func (cdr ConfigurationDiagnosticResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConfigurationDiagnosticResult network configuration diagnostic result corresponded to provided traffic
// query.
type ConfigurationDiagnosticResult struct {
	// Profile - Network configuration diagnostic profile.
	Profile *ConfigurationDiagnosticProfile `json:"profile,omitempty"`
	// NetworkSecurityGroupResult - Network security group result.
	NetworkSecurityGroupResult *SecurityGroupResult `json:"networkSecurityGroupResult,omitempty"`
}

// ConfigurationGroup the network configuration group resource
type ConfigurationGroup struct {
	// ID - Network group ID.
	ID *string `json:"id,omitempty"`
	// GroupProperties - The network configuration group properties
	*GroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationGroup.
func (cg ConfigurationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cg.ID != nil {
		objectMap["id"] = cg.ID
	}
	if cg.GroupProperties != nil {
		objectMap["properties"] = cg.GroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConfigurationGroup struct.
func (cg *ConfigurationGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cg.ID = &ID
			}
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				cg.GroupProperties = &groupProperties
			}
		}
	}

	return nil
}

// ConfigurationPolicyGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ConfigurationPolicyGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationPolicyGroupsClient) (VpnServerConfigurationPolicyGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationPolicyGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationPolicyGroupsCreateOrUpdateFuture.Result.
func (future *ConfigurationPolicyGroupsCreateOrUpdateFuture) result(client ConfigurationPolicyGroupsClient) (vscpg VpnServerConfigurationPolicyGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConfigurationPolicyGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vscpg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConfigurationPolicyGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vscpg.Response.Response, err = future.GetResult(sender); err == nil && vscpg.Response.Response.StatusCode != http.StatusNoContent {
		vscpg, err = client.CreateOrUpdateResponder(vscpg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ConfigurationPolicyGroupsCreateOrUpdateFuture", "Result", vscpg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationPolicyGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationPolicyGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConfigurationPolicyGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConfigurationPolicyGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConfigurationPolicyGroupsDeleteFuture.Result.
func (future *ConfigurationPolicyGroupsDeleteFuture) result(client ConfigurationPolicyGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConfigurationPolicyGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConfigurationPolicyGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectionMonitor parameters that define the operation to create a connection monitor.
type ConnectionMonitor struct {
	// Location - Connection monitor location.
	Location *string `json:"location,omitempty"`
	// Tags - Connection monitor tags.
	Tags map[string]*string `json:"tags"`
	// ConnectionMonitorParameters - Properties of the connection monitor.
	*ConnectionMonitorParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionMonitor.
func (cm ConnectionMonitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cm.Location != nil {
		objectMap["location"] = cm.Location
	}
	if cm.Tags != nil {
		objectMap["tags"] = cm.Tags
	}
	if cm.ConnectionMonitorParameters != nil {
		objectMap["properties"] = cm.ConnectionMonitorParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionMonitor struct.
func (cm *ConnectionMonitor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cm.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectionMonitorParameters ConnectionMonitorParameters
				err = json.Unmarshal(*v, &connectionMonitorParameters)
				if err != nil {
					return err
				}
				cm.ConnectionMonitorParameters = &connectionMonitorParameters
			}
		}
	}

	return nil
}

// ConnectionMonitorDestination describes the destination of connection monitor.
type ConnectionMonitorDestination struct {
	// ResourceID - The ID of the resource used as the destination by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - Address of the connection monitor destination (IP or domain name).
	Address *string `json:"address,omitempty"`
	// Port - The destination port used by connection monitor.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorEndpoint describes the connection monitor endpoint.
type ConnectionMonitorEndpoint struct {
	// Name - The name of the connection monitor endpoint.
	Name *string `json:"name,omitempty"`
	// Type - The endpoint type. Possible values include: 'AzureVM', 'AzureVNet', 'AzureSubnet', 'ExternalAddress', 'MMAWorkspaceMachine', 'MMAWorkspaceNetwork', 'AzureArcVM', 'AzureVMSS'
	Type EndpointType `json:"type,omitempty"`
	// ResourceID - Resource ID of the connection monitor endpoint.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - Address of the connection monitor endpoint (IP or domain name).
	Address *string `json:"address,omitempty"`
	// Filter - Filter for sub-items within the endpoint.
	Filter *ConnectionMonitorEndpointFilter `json:"filter,omitempty"`
	// Scope - Endpoint scope.
	Scope *ConnectionMonitorEndpointScope `json:"scope,omitempty"`
	// CoverageLevel - Test coverage for the endpoint. Possible values include: 'Default', 'Low', 'BelowAverage', 'Average', 'AboveAverage', 'Full'
	CoverageLevel CoverageLevel `json:"coverageLevel,omitempty"`
}

// ConnectionMonitorEndpointFilter describes the connection monitor endpoint filter.
type ConnectionMonitorEndpointFilter struct {
	// Type - The behavior of the endpoint filter. Currently only 'Include' is supported. Possible values include: 'Include'
	Type ConnectionMonitorEndpointFilterType `json:"type,omitempty"`
	// Items - List of items in the filter.
	Items *[]ConnectionMonitorEndpointFilterItem `json:"items,omitempty"`
}

// ConnectionMonitorEndpointFilterItem describes the connection monitor endpoint filter item.
type ConnectionMonitorEndpointFilterItem struct {
	// Type - The type of item included in the filter. Currently only 'AgentAddress' is supported. Possible values include: 'AgentAddress'
	Type ConnectionMonitorEndpointFilterItemType `json:"type,omitempty"`
	// Address - The address of the filter item.
	Address *string `json:"address,omitempty"`
}

// ConnectionMonitorEndpointScope describes the connection monitor endpoint scope.
type ConnectionMonitorEndpointScope struct {
	// Include - List of items which needs to be included to the endpoint scope.
	Include *[]ConnectionMonitorEndpointScopeItem `json:"include,omitempty"`
	// Exclude - List of items which needs to be excluded from the endpoint scope.
	Exclude *[]ConnectionMonitorEndpointScopeItem `json:"exclude,omitempty"`
}

// ConnectionMonitorEndpointScopeItem describes the connection monitor endpoint scope item.
type ConnectionMonitorEndpointScopeItem struct {
	// Address - The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
	Address *string `json:"address,omitempty"`
}

// ConnectionMonitorHTTPConfiguration describes the HTTP configuration.
type ConnectionMonitorHTTPConfiguration struct {
	// Port - The port to connect to.
	Port *int32 `json:"port,omitempty"`
	// Method - The HTTP method to use. Possible values include: 'Get', 'Post'
	Method HTTPConfigurationMethod `json:"method,omitempty"`
	// Path - The path component of the URI. For instance, "/dir1/dir2".
	Path *string `json:"path,omitempty"`
	// RequestHeaders - The HTTP headers to transmit with the request.
	RequestHeaders *[]HTTPHeader `json:"requestHeaders,omitempty"`
	// ValidStatusCodeRanges - HTTP status codes to consider successful. For instance, "2xx,301-304,418".
	ValidStatusCodeRanges *[]string `json:"validStatusCodeRanges,omitempty"`
	// PreferHTTPS - Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
	PreferHTTPS *bool `json:"preferHTTPS,omitempty"`
}

// ConnectionMonitorIcmpConfiguration describes the ICMP configuration.
type ConnectionMonitorIcmpConfiguration struct {
	// DisableTraceRoute - Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool `json:"disableTraceRoute,omitempty"`
}

// ConnectionMonitorListResult list of connection monitors.
type ConnectionMonitorListResult struct {
	autorest.Response `json:"-"`
	// Value - Information about connection monitors.
	Value *[]ConnectionMonitorResult `json:"value,omitempty"`
}

// ConnectionMonitorOutput describes a connection monitor output destination.
type ConnectionMonitorOutput struct {
	// Type - Connection monitor output destination type. Currently, only "Workspace" is supported. Possible values include: 'Workspace'
	Type OutputType `json:"type,omitempty"`
	// WorkspaceSettings - Describes the settings for producing output into a log analytics workspace.
	WorkspaceSettings *ConnectionMonitorWorkspaceSettings `json:"workspaceSettings,omitempty"`
}

// ConnectionMonitorParameters parameters that define the operation to create a connection monitor.
type ConnectionMonitorParameters struct {
	// Source - Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`
	// Destination - Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`
	// AutoStart - Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`
	// MonitoringIntervalInSeconds - Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`
	// Endpoints - List of connection monitor endpoints.
	Endpoints *[]ConnectionMonitorEndpoint `json:"endpoints,omitempty"`
	// TestConfigurations - List of connection monitor test configurations.
	TestConfigurations *[]ConnectionMonitorTestConfiguration `json:"testConfigurations,omitempty"`
	// TestGroups - List of connection monitor test groups.
	TestGroups *[]ConnectionMonitorTestGroup `json:"testGroups,omitempty"`
	// Outputs - List of connection monitor outputs.
	Outputs *[]ConnectionMonitorOutput `json:"outputs,omitempty"`
	// Notes - Optional notes to be associated with the connection monitor.
	Notes *string `json:"notes,omitempty"`
}

// ConnectionMonitorQueryResult list of connection states snapshots.
type ConnectionMonitorQueryResult struct {
	autorest.Response `json:"-"`
	// SourceStatus - Status of connection monitor source. Possible values include: 'ConnectionMonitorSourceStatusUnknown', 'ConnectionMonitorSourceStatusActive', 'ConnectionMonitorSourceStatusInactive'
	SourceStatus ConnectionMonitorSourceStatus `json:"sourceStatus,omitempty"`
	// States - Information about connection states.
	States *[]ConnectionStateSnapshot `json:"states,omitempty"`
}

// ConnectionMonitorResult information about the connection monitor.
type ConnectionMonitorResult struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the connection monitor.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; ID of the connection monitor.
	ID *string `json:"id,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Connection monitor type.
	Type *string `json:"type,omitempty"`
	// Location - Connection monitor location.
	Location *string `json:"location,omitempty"`
	// Tags - Connection monitor tags.
	Tags map[string]*string `json:"tags"`
	// ConnectionMonitorResultProperties - Properties of the connection monitor result.
	*ConnectionMonitorResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionMonitorResult.
func (cmr ConnectionMonitorResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmr.Location != nil {
		objectMap["location"] = cmr.Location
	}
	if cmr.Tags != nil {
		objectMap["tags"] = cmr.Tags
	}
	if cmr.ConnectionMonitorResultProperties != nil {
		objectMap["properties"] = cmr.ConnectionMonitorResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectionMonitorResult struct.
func (cmr *ConnectionMonitorResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cmr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cmr.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cmr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cmr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cmr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cmr.Tags = tags
			}
		case "properties":
			if v != nil {
				var connectionMonitorResultProperties ConnectionMonitorResultProperties
				err = json.Unmarshal(*v, &connectionMonitorResultProperties)
				if err != nil {
					return err
				}
				cmr.ConnectionMonitorResultProperties = &connectionMonitorResultProperties
			}
		}
	}

	return nil
}

// ConnectionMonitorResultProperties describes the properties of a connection monitor.
type ConnectionMonitorResultProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the connection monitor. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - READ-ONLY; The date and time when the connection monitor was started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// MonitoringStatus - READ-ONLY; The monitoring status of the connection monitor.
	MonitoringStatus *string `json:"monitoringStatus,omitempty"`
	// ConnectionMonitorType - READ-ONLY; Type of connection monitor. Possible values include: 'MultiEndpoint', 'SingleSourceDestination'
	ConnectionMonitorType ConnectionMonitorType `json:"connectionMonitorType,omitempty"`
	// Source - Describes the source of connection monitor.
	Source *ConnectionMonitorSource `json:"source,omitempty"`
	// Destination - Describes the destination of connection monitor.
	Destination *ConnectionMonitorDestination `json:"destination,omitempty"`
	// AutoStart - Determines if the connection monitor will start automatically once created.
	AutoStart *bool `json:"autoStart,omitempty"`
	// MonitoringIntervalInSeconds - Monitoring interval in seconds.
	MonitoringIntervalInSeconds *int32 `json:"monitoringIntervalInSeconds,omitempty"`
	// Endpoints - List of connection monitor endpoints.
	Endpoints *[]ConnectionMonitorEndpoint `json:"endpoints,omitempty"`
	// TestConfigurations - List of connection monitor test configurations.
	TestConfigurations *[]ConnectionMonitorTestConfiguration `json:"testConfigurations,omitempty"`
	// TestGroups - List of connection monitor test groups.
	TestGroups *[]ConnectionMonitorTestGroup `json:"testGroups,omitempty"`
	// Outputs - List of connection monitor outputs.
	Outputs *[]ConnectionMonitorOutput `json:"outputs,omitempty"`
	// Notes - Optional notes to be associated with the connection monitor.
	Notes *string `json:"notes,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionMonitorResultProperties.
func (cmrp ConnectionMonitorResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmrp.Source != nil {
		objectMap["source"] = cmrp.Source
	}
	if cmrp.Destination != nil {
		objectMap["destination"] = cmrp.Destination
	}
	if cmrp.AutoStart != nil {
		objectMap["autoStart"] = cmrp.AutoStart
	}
	if cmrp.MonitoringIntervalInSeconds != nil {
		objectMap["monitoringIntervalInSeconds"] = cmrp.MonitoringIntervalInSeconds
	}
	if cmrp.Endpoints != nil {
		objectMap["endpoints"] = cmrp.Endpoints
	}
	if cmrp.TestConfigurations != nil {
		objectMap["testConfigurations"] = cmrp.TestConfigurations
	}
	if cmrp.TestGroups != nil {
		objectMap["testGroups"] = cmrp.TestGroups
	}
	if cmrp.Outputs != nil {
		objectMap["outputs"] = cmrp.Outputs
	}
	if cmrp.Notes != nil {
		objectMap["notes"] = cmrp.Notes
	}
	return json.Marshal(objectMap)
}

// ConnectionMonitorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectionMonitorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (ConnectionMonitorResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectionMonitorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectionMonitorsCreateOrUpdateFuture.Result.
func (future *ConnectionMonitorsCreateOrUpdateFuture) result(client ConnectionMonitorsClient) (cmr ConnectionMonitorResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cmr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectionMonitorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cmr.Response.Response, err = future.GetResult(sender); err == nil && cmr.Response.Response.StatusCode != http.StatusNoContent {
		cmr, err = client.CreateOrUpdateResponder(cmr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsCreateOrUpdateFuture", "Result", cmr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectionMonitorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectionMonitorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectionMonitorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectionMonitorsDeleteFuture.Result.
func (future *ConnectionMonitorsDeleteFuture) result(client ConnectionMonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectionMonitorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectionMonitorSource describes the source of connection monitor.
type ConnectionMonitorSource struct {
	// ResourceID - The ID of the resource used as the source by connection monitor.
	ResourceID *string `json:"resourceId,omitempty"`
	// Port - The source port used by connection monitor.
	Port *int32 `json:"port,omitempty"`
}

// ConnectionMonitorsQueryFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsQueryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (ConnectionMonitorQueryResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectionMonitorsQueryFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectionMonitorsQueryFuture.Result.
func (future *ConnectionMonitorsQueryFuture) result(client ConnectionMonitorsClient) (cmqr ConnectionMonitorQueryResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsQueryFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cmqr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectionMonitorsQueryFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cmqr.Response.Response, err = future.GetResult(sender); err == nil && cmqr.Response.Response.StatusCode != http.StatusNoContent {
		cmqr, err = client.QueryResponder(cmqr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsQueryFuture", "Result", cmqr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectionMonitorsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectionMonitorsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectionMonitorsStartFuture.Result.
func (future *ConnectionMonitorsStartFuture) result(client ConnectionMonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectionMonitorsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectionMonitorsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ConnectionMonitorsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectionMonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectionMonitorsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectionMonitorsStopFuture.Result.
func (future *ConnectionMonitorsStopFuture) result(client ConnectionMonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectionMonitorsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectionMonitorsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectionMonitorSuccessThreshold describes the threshold for declaring a test successful.
type ConnectionMonitorSuccessThreshold struct {
	// ChecksFailedPercent - The maximum percentage of failed checks permitted for a test to evaluate as successful.
	ChecksFailedPercent *int32 `json:"checksFailedPercent,omitempty"`
	// RoundTripTimeMs - The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
	RoundTripTimeMs *float64 `json:"roundTripTimeMs,omitempty"`
}

// ConnectionMonitorTCPConfiguration describes the TCP configuration.
type ConnectionMonitorTCPConfiguration struct {
	// Port - The port to connect to.
	Port *int32 `json:"port,omitempty"`
	// DisableTraceRoute - Value indicating whether path evaluation with trace route should be disabled.
	DisableTraceRoute *bool `json:"disableTraceRoute,omitempty"`
	// DestinationPortBehavior - Destination port behavior. Possible values include: 'DestinationPortBehaviorNone', 'DestinationPortBehaviorListenIfAvailable'
	DestinationPortBehavior DestinationPortBehavior `json:"destinationPortBehavior,omitempty"`
}

// ConnectionMonitorTestConfiguration describes a connection monitor test configuration.
type ConnectionMonitorTestConfiguration struct {
	// Name - The name of the connection monitor test configuration.
	Name *string `json:"name,omitempty"`
	// TestFrequencySec - The frequency of test evaluation, in seconds.
	TestFrequencySec *int32 `json:"testFrequencySec,omitempty"`
	// Protocol - The protocol to use in test evaluation. Possible values include: 'ConnectionMonitorTestConfigurationProtocolTCP', 'ConnectionMonitorTestConfigurationProtocolHTTP', 'ConnectionMonitorTestConfigurationProtocolIcmp'
	Protocol ConnectionMonitorTestConfigurationProtocol `json:"protocol,omitempty"`
	// PreferredIPVersion - The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters. Possible values include: 'PreferredIPVersionIPv4', 'PreferredIPVersionIPv6'
	PreferredIPVersion PreferredIPVersion `json:"preferredIPVersion,omitempty"`
	// HTTPConfiguration - The parameters used to perform test evaluation over HTTP.
	HTTPConfiguration *ConnectionMonitorHTTPConfiguration `json:"httpConfiguration,omitempty"`
	// TCPConfiguration - The parameters used to perform test evaluation over TCP.
	TCPConfiguration *ConnectionMonitorTCPConfiguration `json:"tcpConfiguration,omitempty"`
	// IcmpConfiguration - The parameters used to perform test evaluation over ICMP.
	IcmpConfiguration *ConnectionMonitorIcmpConfiguration `json:"icmpConfiguration,omitempty"`
	// SuccessThreshold - The threshold for declaring a test successful.
	SuccessThreshold *ConnectionMonitorSuccessThreshold `json:"successThreshold,omitempty"`
}

// ConnectionMonitorTestGroup describes the connection monitor test group.
type ConnectionMonitorTestGroup struct {
	// Name - The name of the connection monitor test group.
	Name *string `json:"name,omitempty"`
	// Disable - Value indicating whether test group is disabled.
	Disable *bool `json:"disable,omitempty"`
	// TestConfigurations - List of test configuration names.
	TestConfigurations *[]string `json:"testConfigurations,omitempty"`
	// Sources - List of source endpoint names.
	Sources *[]string `json:"sources,omitempty"`
	// Destinations - List of destination endpoint names.
	Destinations *[]string `json:"destinations,omitempty"`
}

// ConnectionMonitorWorkspaceSettings describes the settings for producing output into a log analytics
// workspace.
type ConnectionMonitorWorkspaceSettings struct {
	// WorkspaceResourceID - Log analytics workspace resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
}

// ConnectionResetSharedKey the virtual network connection reset shared key.
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey response for GetConnectionSharedKey API service call.
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value.
	Value *string `json:"value,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ConnectionStateSnapshot connection state snapshot.
type ConnectionStateSnapshot struct {
	// ConnectionState - The connection state. Possible values include: 'ConnectionStateReachable', 'ConnectionStateUnreachable', 'ConnectionStateUnknown'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// StartTime - The start time of the connection snapshot.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the connection snapshot.
	EndTime *date.Time `json:"endTime,omitempty"`
	// EvaluationState - Connectivity analysis evaluation state. Possible values include: 'EvaluationStateNotStarted', 'EvaluationStateInProgress', 'EvaluationStateCompleted'
	EvaluationState EvaluationState `json:"evaluationState,omitempty"`
	// AvgLatencyInMs - Average latency in ms.
	AvgLatencyInMs *int64 `json:"avgLatencyInMs,omitempty"`
	// MinLatencyInMs - Minimum latency in ms.
	MinLatencyInMs *int64 `json:"minLatencyInMs,omitempty"`
	// MaxLatencyInMs - Maximum latency in ms.
	MaxLatencyInMs *int64 `json:"maxLatencyInMs,omitempty"`
	// ProbesSent - The number of sent probes.
	ProbesSent *int64 `json:"probesSent,omitempty"`
	// ProbesFailed - The number of failed probes.
	ProbesFailed *int64 `json:"probesFailed,omitempty"`
	// Hops - READ-ONLY; List of hops between the source and the destination.
	Hops *[]ConnectivityHop `json:"hops,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionStateSnapshot.
func (CSS ConnectionStateSnapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if CSS.ConnectionState != "" {
		objectMap["connectionState"] = CSS.ConnectionState
	}
	if CSS.StartTime != nil {
		objectMap["startTime"] = CSS.StartTime
	}
	if CSS.EndTime != nil {
		objectMap["endTime"] = CSS.EndTime
	}
	if CSS.EvaluationState != "" {
		objectMap["evaluationState"] = CSS.EvaluationState
	}
	if CSS.AvgLatencyInMs != nil {
		objectMap["avgLatencyInMs"] = CSS.AvgLatencyInMs
	}
	if CSS.MinLatencyInMs != nil {
		objectMap["minLatencyInMs"] = CSS.MinLatencyInMs
	}
	if CSS.MaxLatencyInMs != nil {
		objectMap["maxLatencyInMs"] = CSS.MaxLatencyInMs
	}
	if CSS.ProbesSent != nil {
		objectMap["probesSent"] = CSS.ProbesSent
	}
	if CSS.ProbesFailed != nil {
		objectMap["probesFailed"] = CSS.ProbesFailed
	}
	return json.Marshal(objectMap)
}

// ConnectivityConfiguration the network manager connectivity configuration resource
type ConnectivityConfiguration struct {
	autorest.Response `json:"-"`
	// ConnectivityConfigurationProperties - Properties of a network manager connectivity configuration
	*ConnectivityConfigurationProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectivityConfiguration.
func (cc ConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.ConnectivityConfigurationProperties != nil {
		objectMap["properties"] = cc.ConnectivityConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectivityConfiguration struct.
func (cc *ConnectivityConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectivityConfigurationProperties ConnectivityConfigurationProperties
				err = json.Unmarshal(*v, &connectivityConfigurationProperties)
				if err != nil {
					return err
				}
				cc.ConnectivityConfigurationProperties = &connectivityConfigurationProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cc.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cc.Etag = &etag
			}
		}
	}

	return nil
}

// ConnectivityConfigurationListResult result of the request to list network manager connectivity
// configurations. It contains a list of configurations and a link to get the next set of results.
type ConnectivityConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of Connectivity Configurations
	Value *[]ConnectivityConfiguration `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectivityConfigurationListResultIterator provides access to a complete listing of
// ConnectivityConfiguration values.
type ConnectivityConfigurationListResultIterator struct {
	i    int
	page ConnectivityConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectivityConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectivityConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectivityConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectivityConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectivityConfigurationListResultIterator) Response() ConnectivityConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectivityConfigurationListResultIterator) Value() ConnectivityConfiguration {
	if !iter.page.NotDone() {
		return ConnectivityConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectivityConfigurationListResultIterator type.
func NewConnectivityConfigurationListResultIterator(page ConnectivityConfigurationListResultPage) ConnectivityConfigurationListResultIterator {
	return ConnectivityConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cclr ConnectivityConfigurationListResult) IsEmpty() bool {
	return cclr.Value == nil || len(*cclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cclr ConnectivityConfigurationListResult) hasNextLink() bool {
	return cclr.NextLink != nil && len(*cclr.NextLink) != 0
}

// connectivityConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cclr ConnectivityConfigurationListResult) connectivityConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cclr.NextLink)))
}

// ConnectivityConfigurationListResultPage contains a page of ConnectivityConfiguration values.
type ConnectivityConfigurationListResultPage struct {
	fn   func(context.Context, ConnectivityConfigurationListResult) (ConnectivityConfigurationListResult, error)
	cclr ConnectivityConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectivityConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectivityConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cclr)
		if err != nil {
			return err
		}
		page.cclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectivityConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectivityConfigurationListResultPage) NotDone() bool {
	return !page.cclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectivityConfigurationListResultPage) Response() ConnectivityConfigurationListResult {
	return page.cclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectivityConfigurationListResultPage) Values() []ConnectivityConfiguration {
	if page.cclr.IsEmpty() {
		return nil
	}
	return *page.cclr.Value
}

// Creates a new instance of the ConnectivityConfigurationListResultPage type.
func NewConnectivityConfigurationListResultPage(cur ConnectivityConfigurationListResult, getNextPage func(context.Context, ConnectivityConfigurationListResult) (ConnectivityConfigurationListResult, error)) ConnectivityConfigurationListResultPage {
	return ConnectivityConfigurationListResultPage{
		fn:   getNextPage,
		cclr: cur,
	}
}

// ConnectivityConfigurationProperties properties of network manager connectivity configuration
type ConnectivityConfigurationProperties struct {
	// Description - A description of the connectivity configuration.
	Description *string `json:"description,omitempty"`
	// ConnectivityTopology - Connectivity topology type. Possible values include: 'HubAndSpoke', 'Mesh'
	ConnectivityTopology ConnectivityTopology `json:"connectivityTopology,omitempty"`
	// Hubs - List of hubItems
	Hubs *[]Hub `json:"hubs,omitempty"`
	// IsGlobal - Flag if global mesh is supported. Possible values include: 'IsGlobalFalse', 'IsGlobalTrue'
	IsGlobal IsGlobal `json:"isGlobal,omitempty"`
	// AppliesToGroups - Groups for configuration
	AppliesToGroups *[]ConnectivityGroupItem `json:"appliesToGroups,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the connectivity configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// DeleteExistingPeering - Flag if need to remove current existing peerings. Possible values include: 'False', 'True'
	DeleteExistingPeering DeleteExistingPeering `json:"deleteExistingPeering,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectivityConfigurationProperties.
func (ccp ConnectivityConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.Description != nil {
		objectMap["description"] = ccp.Description
	}
	if ccp.ConnectivityTopology != "" {
		objectMap["connectivityTopology"] = ccp.ConnectivityTopology
	}
	if ccp.Hubs != nil {
		objectMap["hubs"] = ccp.Hubs
	}
	if ccp.IsGlobal != "" {
		objectMap["isGlobal"] = ccp.IsGlobal
	}
	if ccp.AppliesToGroups != nil {
		objectMap["appliesToGroups"] = ccp.AppliesToGroups
	}
	if ccp.DeleteExistingPeering != "" {
		objectMap["deleteExistingPeering"] = ccp.DeleteExistingPeering
	}
	return json.Marshal(objectMap)
}

// ConnectivityConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectivityConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectivityConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectivityConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectivityConfigurationsDeleteFuture.Result.
func (future *ConnectivityConfigurationsDeleteFuture) result(client ConnectivityConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ConnectivityConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ConnectivityConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectivityDestination parameters that define destination of connection.
type ConnectivityDestination struct {
	// ResourceID - The ID of the resource to which a connection attempt will be made.
	ResourceID *string `json:"resourceId,omitempty"`
	// Address - The IP address or URI the resource to which a connection attempt will be made.
	Address *string `json:"address,omitempty"`
	// Port - Port on which check connectivity will be performed.
	Port *int32 `json:"port,omitempty"`
}

// ConnectivityGroupItem connectivity group item.
type ConnectivityGroupItem struct {
	// NetworkGroupID - Network group Id.
	NetworkGroupID *string `json:"networkGroupId,omitempty"`
	// UseHubGateway - Flag if need to use hub gateway. Possible values include: 'UseHubGatewayFalse', 'UseHubGatewayTrue'
	UseHubGateway UseHubGateway `json:"useHubGateway,omitempty"`
	// IsGlobal - Flag if global is supported. Possible values include: 'IsGlobalFalse', 'IsGlobalTrue'
	IsGlobal IsGlobal `json:"isGlobal,omitempty"`
	// GroupConnectivity - Group connectivity type. Possible values include: 'GroupConnectivityNone', 'GroupConnectivityDirectlyConnected'
	GroupConnectivity GroupConnectivity `json:"groupConnectivity,omitempty"`
}

// ConnectivityHop information about a hop between the source and the destination.
type ConnectivityHop struct {
	// Type - READ-ONLY; The type of the hop.
	Type *string `json:"type,omitempty"`
	// ID - READ-ONLY; The ID of the hop.
	ID *string `json:"id,omitempty"`
	// Address - READ-ONLY; The IP address of the hop.
	Address *string `json:"address,omitempty"`
	// ResourceID - READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string `json:"resourceId,omitempty"`
	// NextHopIds - READ-ONLY; List of next hop identifiers.
	NextHopIds *[]string `json:"nextHopIds,omitempty"`
	// PreviousHopIds - READ-ONLY; List of previous hop identifiers.
	PreviousHopIds *[]string `json:"previousHopIds,omitempty"`
	// Links - READ-ONLY; List of hop links.
	Links *[]HopLink `json:"links,omitempty"`
	// PreviousLinks - READ-ONLY; List of previous hop links.
	PreviousLinks *[]HopLink `json:"previousLinks,omitempty"`
	// Issues - READ-ONLY; List of issues.
	Issues *[]ConnectivityIssue `json:"issues,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectivityHop.
func (ch ConnectivityHop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectivityInformation information on the connectivity status.
type ConnectivityInformation struct {
	autorest.Response `json:"-"`
	// Hops - READ-ONLY; List of hops between the source and the destination.
	Hops *[]ConnectivityHop `json:"hops,omitempty"`
	// ConnectionStatus - READ-ONLY; The connection status. Possible values include: 'ConnectionStatusUnknown', 'ConnectionStatusConnected', 'ConnectionStatusDisconnected', 'ConnectionStatusDegraded'
	ConnectionStatus ConnectionStatus `json:"connectionStatus,omitempty"`
	// AvgLatencyInMs - READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int32 `json:"avgLatencyInMs,omitempty"`
	// MinLatencyInMs - READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int32 `json:"minLatencyInMs,omitempty"`
	// MaxLatencyInMs - READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int32 `json:"maxLatencyInMs,omitempty"`
	// ProbesSent - READ-ONLY; Total number of probes sent.
	ProbesSent *int32 `json:"probesSent,omitempty"`
	// ProbesFailed - READ-ONLY; Number of failed probes.
	ProbesFailed *int32 `json:"probesFailed,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectivityInformation.
func (ci ConnectivityInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectivityIssue information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// Origin - READ-ONLY; The origin of the issue. Possible values include: 'OriginLocal', 'OriginInbound', 'OriginOutbound'
	Origin Origin `json:"origin,omitempty"`
	// Severity - READ-ONLY; The severity of the issue. Possible values include: 'SeverityError', 'SeverityWarning'
	Severity Severity `json:"severity,omitempty"`
	// Type - READ-ONLY; The type of issue. Possible values include: 'IssueTypeUnknown', 'IssueTypeAgentStopped', 'IssueTypeGuestFirewall', 'IssueTypeDNSResolution', 'IssueTypeSocketBind', 'IssueTypeNetworkSecurityRule', 'IssueTypeUserDefinedRoute', 'IssueTypePortThrottled', 'IssueTypePlatform'
	Type IssueType `json:"type,omitempty"`
	// Context - READ-ONLY; Provides additional context on the issue.
	Context *[]map[string]*string `json:"context,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectivityIssue.
func (ci ConnectivityIssue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectivityParameters parameters that determine how the connectivity check will be performed.
type ConnectivityParameters struct {
	// Source - The source of the connection.
	Source *ConnectivitySource `json:"source,omitempty"`
	// Destination - The destination of connection.
	Destination *ConnectivityDestination `json:"destination,omitempty"`
	// Protocol - Network protocol. Possible values include: 'ProtocolTCP', 'ProtocolHTTP', 'ProtocolHTTPS', 'ProtocolIcmp'
	Protocol Protocol `json:"protocol,omitempty"`
	// ProtocolConfiguration - Configuration of the protocol.
	ProtocolConfiguration *ProtocolConfiguration `json:"protocolConfiguration,omitempty"`
	// PreferredIPVersion - Preferred IP version of the connection. Possible values include: 'IPv4', 'IPv6'
	PreferredIPVersion IPVersion `json:"preferredIPVersion,omitempty"`
}

// ConnectivitySource parameters that define the source of the connection.
type ConnectivitySource struct {
	// ResourceID - The ID of the resource from which a connectivity check will be initiated.
	ResourceID *string `json:"resourceId,omitempty"`
	// Port - The source port from which a connectivity check will be performed.
	Port *int32 `json:"port,omitempty"`
}

// Container reference to container resource in remote resource provider.
type Container struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ContainerNetworkInterface container network interface child resource.
type ContainerNetworkInterface struct {
	// ContainerNetworkInterfacePropertiesFormat - Container network interface properties.
	*ContainerNetworkInterfacePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterface.
func (cni ContainerNetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cni.ContainerNetworkInterfacePropertiesFormat != nil {
		objectMap["properties"] = cni.ContainerNetworkInterfacePropertiesFormat
	}
	if cni.Name != nil {
		objectMap["name"] = cni.Name
	}
	if cni.ID != nil {
		objectMap["id"] = cni.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterface struct.
func (cni *ContainerNetworkInterface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfacePropertiesFormat ContainerNetworkInterfacePropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfacePropertiesFormat)
				if err != nil {
					return err
				}
				cni.ContainerNetworkInterfacePropertiesFormat = &containerNetworkInterfacePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cni.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cni.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cni.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cni.ID = &ID
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceConfiguration container network interface configuration child resource.
type ContainerNetworkInterfaceConfiguration struct {
	// ContainerNetworkInterfaceConfigurationPropertiesFormat - Container network interface configuration properties.
	*ContainerNetworkInterfaceConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceConfiguration.
func (cnic ContainerNetworkInterfaceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat != nil {
		objectMap["properties"] = cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat
	}
	if cnic.Name != nil {
		objectMap["name"] = cnic.Name
	}
	if cnic.ID != nil {
		objectMap["id"] = cnic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterfaceConfiguration struct.
func (cnic *ContainerNetworkInterfaceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfaceConfigurationPropertiesFormat ContainerNetworkInterfaceConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfaceConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				cnic.ContainerNetworkInterfaceConfigurationPropertiesFormat = &containerNetworkInterfaceConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cnic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cnic.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cnic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cnic.ID = &ID
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceConfigurationPropertiesFormat container network interface configuration
// properties.
type ContainerNetworkInterfaceConfigurationPropertiesFormat struct {
	// IPConfigurations - A list of ip configurations of the container network interface configuration.
	IPConfigurations *[]IPConfigurationProfile `json:"ipConfigurations,omitempty"`
	// ContainerNetworkInterfaces - A list of container network interfaces created from this container network interface configuration.
	ContainerNetworkInterfaces *[]SubResource `json:"containerNetworkInterfaces,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceConfigurationPropertiesFormat.
func (cnicpf ContainerNetworkInterfaceConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnicpf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = cnicpf.IPConfigurations
	}
	if cnicpf.ContainerNetworkInterfaces != nil {
		objectMap["containerNetworkInterfaces"] = cnicpf.ContainerNetworkInterfaces
	}
	return json.Marshal(objectMap)
}

// ContainerNetworkInterfaceIPConfiguration the ip configuration for a container network interface.
type ContainerNetworkInterfaceIPConfiguration struct {
	// ContainerNetworkInterfaceIPConfigurationPropertiesFormat - Properties of the container network interface IP configuration.
	*ContainerNetworkInterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceIPConfiguration.
func (cniic ContainerNetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat
	}
	if cniic.Name != nil {
		objectMap["name"] = cniic.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerNetworkInterfaceIPConfiguration struct.
func (cniic *ContainerNetworkInterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var containerNetworkInterfaceIPConfigurationPropertiesFormat ContainerNetworkInterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &containerNetworkInterfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				cniic.ContainerNetworkInterfaceIPConfigurationPropertiesFormat = &containerNetworkInterfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cniic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cniic.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cniic.Etag = &etag
			}
		}
	}

	return nil
}

// ContainerNetworkInterfaceIPConfigurationPropertiesFormat properties of the container network interface
// IP configuration.
type ContainerNetworkInterfaceIPConfigurationPropertiesFormat struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfaceIPConfigurationPropertiesFormat.
func (cniicpf ContainerNetworkInterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContainerNetworkInterfacePropertiesFormat properties of container network interface.
type ContainerNetworkInterfacePropertiesFormat struct {
	// ContainerNetworkInterfaceConfiguration - READ-ONLY; Container network interface configuration from which this container network interface is created.
	ContainerNetworkInterfaceConfiguration *ContainerNetworkInterfaceConfiguration `json:"containerNetworkInterfaceConfiguration,omitempty"`
	// Container - Reference to the container to which this container network interface is attached.
	Container *Container `json:"container,omitempty"`
	// IPConfigurations - READ-ONLY; Reference to the ip configuration on this container nic.
	IPConfigurations *[]ContainerNetworkInterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container network interface resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerNetworkInterfacePropertiesFormat.
func (cnipf ContainerNetworkInterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnipf.Container != nil {
		objectMap["container"] = cnipf.Container
	}
	return json.Marshal(objectMap)
}

// Criterion a matching criteria which matches routes based on route prefix, community, and AS path.
type Criterion struct {
	// RoutePrefix - List of route prefixes which this criteria matches.
	RoutePrefix *[]string `json:"routePrefix,omitempty"`
	// Community - List of BGP communities which this criteria matches.
	Community *[]string `json:"community,omitempty"`
	// AsPath - List of AS paths which this criteria matches.
	AsPath *[]string `json:"asPath,omitempty"`
	// MatchCondition - Match condition to apply RouteMap rules. Possible values include: 'RouteMapMatchConditionUnknown', 'RouteMapMatchConditionContains', 'RouteMapMatchConditionEquals', 'RouteMapMatchConditionNotContains', 'RouteMapMatchConditionNotEquals'
	MatchCondition RouteMapMatchCondition `json:"matchCondition,omitempty"`
}

// CrossTenantScopes cross tenant scopes.
type CrossTenantScopes struct {
	// TenantID - READ-ONLY; Tenant ID.
	TenantID *string `json:"tenantId,omitempty"`
	// ManagementGroups - READ-ONLY; List of management groups.
	ManagementGroups *[]string `json:"managementGroups,omitempty"`
	// Subscriptions - READ-ONLY; List of subscriptions.
	Subscriptions *[]string `json:"subscriptions,omitempty"`
}

// MarshalJSON is the custom marshaler for CrossTenantScopes.
func (cts CrossTenantScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CustomDNSConfigPropertiesFormat contains custom Dns resolution configuration from customer.
type CustomDNSConfigPropertiesFormat struct {
	// Fqdn - Fqdn that resolves to private endpoint ip address.
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddresses - A list of private ip addresses of the private endpoint.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
}

// CustomIPPrefix custom IP prefix resource.
type CustomIPPrefix struct {
	autorest.Response `json:"-"`
	// ExtendedLocation - The extended location of the custom IP prefix.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// CustomIPPrefixPropertiesFormat - Custom IP prefix properties.
	*CustomIPPrefixPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Zones - A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomIPPrefix.
func (cip CustomIPPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cip.ExtendedLocation != nil {
		objectMap["extendedLocation"] = cip.ExtendedLocation
	}
	if cip.CustomIPPrefixPropertiesFormat != nil {
		objectMap["properties"] = cip.CustomIPPrefixPropertiesFormat
	}
	if cip.Zones != nil {
		objectMap["zones"] = cip.Zones
	}
	if cip.ID != nil {
		objectMap["id"] = cip.ID
	}
	if cip.Location != nil {
		objectMap["location"] = cip.Location
	}
	if cip.Tags != nil {
		objectMap["tags"] = cip.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomIPPrefix struct.
func (cip *CustomIPPrefix) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				cip.ExtendedLocation = &extendedLocation
			}
		case "properties":
			if v != nil {
				var customIPPrefixPropertiesFormat CustomIPPrefixPropertiesFormat
				err = json.Unmarshal(*v, &customIPPrefixPropertiesFormat)
				if err != nil {
					return err
				}
				cip.CustomIPPrefixPropertiesFormat = &customIPPrefixPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cip.Etag = &etag
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				cip.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cip.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cip.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cip.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cip.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cip.Tags = tags
			}
		}
	}

	return nil
}

// CustomIPPrefixesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CustomIPPrefixesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomIPPrefixesClient) (CustomIPPrefix, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomIPPrefixesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomIPPrefixesCreateOrUpdateFuture.Result.
func (future *CustomIPPrefixesCreateOrUpdateFuture) result(client CustomIPPrefixesClient) (cip CustomIPPrefix, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.CustomIPPrefixesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cip.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.CustomIPPrefixesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cip.Response.Response, err = future.GetResult(sender); err == nil && cip.Response.Response.StatusCode != http.StatusNoContent {
		cip, err = client.CreateOrUpdateResponder(cip.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.CustomIPPrefixesCreateOrUpdateFuture", "Result", cip.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomIPPrefixesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomIPPrefixesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomIPPrefixesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomIPPrefixesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomIPPrefixesDeleteFuture.Result.
func (future *CustomIPPrefixesDeleteFuture) result(client CustomIPPrefixesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.CustomIPPrefixesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.CustomIPPrefixesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CustomIPPrefixListResult response for ListCustomIpPrefixes API service call.
type CustomIPPrefixListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of Custom IP prefixes that exists in a resource group.
	Value *[]CustomIPPrefix `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomIPPrefixListResultIterator provides access to a complete listing of CustomIPPrefix values.
type CustomIPPrefixListResultIterator struct {
	i    int
	page CustomIPPrefixListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomIPPrefixListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomIPPrefixListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomIPPrefixListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomIPPrefixListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomIPPrefixListResultIterator) Response() CustomIPPrefixListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomIPPrefixListResultIterator) Value() CustomIPPrefix {
	if !iter.page.NotDone() {
		return CustomIPPrefix{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomIPPrefixListResultIterator type.
func NewCustomIPPrefixListResultIterator(page CustomIPPrefixListResultPage) CustomIPPrefixListResultIterator {
	return CustomIPPrefixListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ciplr CustomIPPrefixListResult) IsEmpty() bool {
	return ciplr.Value == nil || len(*ciplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ciplr CustomIPPrefixListResult) hasNextLink() bool {
	return ciplr.NextLink != nil && len(*ciplr.NextLink) != 0
}

// customIPPrefixListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ciplr CustomIPPrefixListResult) customIPPrefixListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ciplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ciplr.NextLink)))
}

// CustomIPPrefixListResultPage contains a page of CustomIPPrefix values.
type CustomIPPrefixListResultPage struct {
	fn    func(context.Context, CustomIPPrefixListResult) (CustomIPPrefixListResult, error)
	ciplr CustomIPPrefixListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomIPPrefixListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomIPPrefixListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ciplr)
		if err != nil {
			return err
		}
		page.ciplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomIPPrefixListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomIPPrefixListResultPage) NotDone() bool {
	return !page.ciplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomIPPrefixListResultPage) Response() CustomIPPrefixListResult {
	return page.ciplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomIPPrefixListResultPage) Values() []CustomIPPrefix {
	if page.ciplr.IsEmpty() {
		return nil
	}
	return *page.ciplr.Value
}

// Creates a new instance of the CustomIPPrefixListResultPage type.
func NewCustomIPPrefixListResultPage(cur CustomIPPrefixListResult, getNextPage func(context.Context, CustomIPPrefixListResult) (CustomIPPrefixListResult, error)) CustomIPPrefixListResultPage {
	return CustomIPPrefixListResultPage{
		fn:    getNextPage,
		ciplr: cur,
	}
}

// CustomIPPrefixPropertiesFormat custom IP prefix properties.
type CustomIPPrefixPropertiesFormat struct {
	// Asn - The ASN for CIDR advertising. Should be an integer as string.
	Asn *string `json:"asn,omitempty"`
	// Cidr - The prefix range in CIDR notation. Should include the start address and the prefix length.
	Cidr *string `json:"cidr,omitempty"`
	// SignedMessage - Signed message for WAN validation.
	SignedMessage *string `json:"signedMessage,omitempty"`
	// AuthorizationMessage - Authorization message for WAN validation.
	AuthorizationMessage *string `json:"authorizationMessage,omitempty"`
	// CustomIPPrefixParent - The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
	CustomIPPrefixParent *SubResource `json:"customIpPrefixParent,omitempty"`
	// ChildCustomIPPrefixes - READ-ONLY; The list of all Children for IPv6 /48 CustomIpPrefix.
	ChildCustomIPPrefixes *[]SubResource `json:"childCustomIpPrefixes,omitempty"`
	// CommissionedState - The commissioned state of the Custom IP Prefix. Possible values include: 'Provisioning', 'Provisioned', 'Commissioning', 'CommissionedNoInternetAdvertise', 'Commissioned', 'Decommissioning', 'Deprovisioning', 'Deprovisioned'
	CommissionedState CommissionedState `json:"commissionedState,omitempty"`
	// ExpressRouteAdvertise - Whether to do express route advertise.
	ExpressRouteAdvertise *bool `json:"expressRouteAdvertise,omitempty"`
	// Geo - The Geo for CIDR advertising. Should be an Geo code. Possible values include: 'GLOBAL', 'AFRI', 'APAC', 'EURO', 'LATAM', 'NAM', 'ME', 'OCEANIA', 'AQ'
	Geo Geo `json:"geo,omitempty"`
	// NoInternetAdvertise - Whether to Advertise the range to Internet.
	NoInternetAdvertise *bool `json:"noInternetAdvertise,omitempty"`
	// PrefixType - Type of custom IP prefix. Should be Singular, Parent, or Child. Possible values include: 'Singular', 'Parent', 'Child'
	PrefixType CustomIPPrefixType `json:"prefixType,omitempty"`
	// PublicIPPrefixes - READ-ONLY; The list of all referenced PublicIpPrefixes.
	PublicIPPrefixes *[]SubResource `json:"publicIpPrefixes,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the custom IP prefix resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// FailedReason - READ-ONLY; The reason why resource is in failed state.
	FailedReason *string `json:"failedReason,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the custom IP prefix resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomIPPrefixPropertiesFormat.
func (cippf CustomIPPrefixPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cippf.Asn != nil {
		objectMap["asn"] = cippf.Asn
	}
	if cippf.Cidr != nil {
		objectMap["cidr"] = cippf.Cidr
	}
	if cippf.SignedMessage != nil {
		objectMap["signedMessage"] = cippf.SignedMessage
	}
	if cippf.AuthorizationMessage != nil {
		objectMap["authorizationMessage"] = cippf.AuthorizationMessage
	}
	if cippf.CustomIPPrefixParent != nil {
		objectMap["customIpPrefixParent"] = cippf.CustomIPPrefixParent
	}
	if cippf.CommissionedState != "" {
		objectMap["commissionedState"] = cippf.CommissionedState
	}
	if cippf.ExpressRouteAdvertise != nil {
		objectMap["expressRouteAdvertise"] = cippf.ExpressRouteAdvertise
	}
	if cippf.Geo != "" {
		objectMap["geo"] = cippf.Geo
	}
	if cippf.NoInternetAdvertise != nil {
		objectMap["noInternetAdvertise"] = cippf.NoInternetAdvertise
	}
	if cippf.PrefixType != "" {
		objectMap["prefixType"] = cippf.PrefixType
	}
	return json.Marshal(objectMap)
}

// DdosCustomPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosCustomPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosCustomPoliciesClient) (DdosCustomPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DdosCustomPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DdosCustomPoliciesCreateOrUpdateFuture.Result.
func (future *DdosCustomPoliciesCreateOrUpdateFuture) result(client DdosCustomPoliciesClient) (dcp DdosCustomPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DdosCustomPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dcp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DdosCustomPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dcp.Response.Response, err = future.GetResult(sender); err == nil && dcp.Response.Response.StatusCode != http.StatusNoContent {
		dcp, err = client.CreateOrUpdateResponder(dcp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.DdosCustomPoliciesCreateOrUpdateFuture", "Result", dcp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DdosCustomPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosCustomPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosCustomPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DdosCustomPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DdosCustomPoliciesDeleteFuture.Result.
func (future *DdosCustomPoliciesDeleteFuture) result(client DdosCustomPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DdosCustomPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DdosCustomPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DdosCustomPolicy a DDoS custom policy in a resource group.
type DdosCustomPolicy struct {
	autorest.Response `json:"-"`
	// DdosCustomPolicyPropertiesFormat - Properties of the DDoS custom policy.
	*DdosCustomPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DdosCustomPolicy.
func (dcp DdosCustomPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcp.DdosCustomPolicyPropertiesFormat != nil {
		objectMap["properties"] = dcp.DdosCustomPolicyPropertiesFormat
	}
	if dcp.ID != nil {
		objectMap["id"] = dcp.ID
	}
	if dcp.Location != nil {
		objectMap["location"] = dcp.Location
	}
	if dcp.Tags != nil {
		objectMap["tags"] = dcp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DdosCustomPolicy struct.
func (dcp *DdosCustomPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ddosCustomPolicyPropertiesFormat DdosCustomPolicyPropertiesFormat
				err = json.Unmarshal(*v, &ddosCustomPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				dcp.DdosCustomPolicyPropertiesFormat = &ddosCustomPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dcp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dcp.Tags = tags
			}
		}
	}

	return nil
}

// DdosCustomPolicyPropertiesFormat dDoS custom policy properties.
type DdosCustomPolicyPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the DDoS custom policy resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosCustomPolicyPropertiesFormat.
func (dcppf DdosCustomPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DdosProtectionPlan a DDoS protection plan in a resource group.
type DdosProtectionPlan struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// DdosProtectionPlanPropertiesFormat - Properties of the DDoS protection plan.
	*DdosProtectionPlanPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosProtectionPlan.
func (dpp DdosProtectionPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpp.Location != nil {
		objectMap["location"] = dpp.Location
	}
	if dpp.Tags != nil {
		objectMap["tags"] = dpp.Tags
	}
	if dpp.DdosProtectionPlanPropertiesFormat != nil {
		objectMap["properties"] = dpp.DdosProtectionPlanPropertiesFormat
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DdosProtectionPlan struct.
func (dpp *DdosProtectionPlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dpp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var ddosProtectionPlanPropertiesFormat DdosProtectionPlanPropertiesFormat
				err = json.Unmarshal(*v, &ddosProtectionPlanPropertiesFormat)
				if err != nil {
					return err
				}
				dpp.DdosProtectionPlanPropertiesFormat = &ddosProtectionPlanPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dpp.Etag = &etag
			}
		}
	}

	return nil
}

// DdosProtectionPlanListResult a list of DDoS protection plans.
type DdosProtectionPlanListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of DDoS protection plans.
	Value *[]DdosProtectionPlan `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosProtectionPlanListResult.
func (dpplr DdosProtectionPlanListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpplr.Value != nil {
		objectMap["value"] = dpplr.Value
	}
	return json.Marshal(objectMap)
}

// DdosProtectionPlanListResultIterator provides access to a complete listing of DdosProtectionPlan values.
type DdosProtectionPlanListResultIterator struct {
	i    int
	page DdosProtectionPlanListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DdosProtectionPlanListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DdosProtectionPlanListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DdosProtectionPlanListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DdosProtectionPlanListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DdosProtectionPlanListResultIterator) Response() DdosProtectionPlanListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DdosProtectionPlanListResultIterator) Value() DdosProtectionPlan {
	if !iter.page.NotDone() {
		return DdosProtectionPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DdosProtectionPlanListResultIterator type.
func NewDdosProtectionPlanListResultIterator(page DdosProtectionPlanListResultPage) DdosProtectionPlanListResultIterator {
	return DdosProtectionPlanListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dpplr DdosProtectionPlanListResult) IsEmpty() bool {
	return dpplr.Value == nil || len(*dpplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dpplr DdosProtectionPlanListResult) hasNextLink() bool {
	return dpplr.NextLink != nil && len(*dpplr.NextLink) != 0
}

// ddosProtectionPlanListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dpplr DdosProtectionPlanListResult) ddosProtectionPlanListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dpplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dpplr.NextLink)))
}

// DdosProtectionPlanListResultPage contains a page of DdosProtectionPlan values.
type DdosProtectionPlanListResultPage struct {
	fn    func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)
	dpplr DdosProtectionPlanListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DdosProtectionPlanListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DdosProtectionPlanListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dpplr)
		if err != nil {
			return err
		}
		page.dpplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DdosProtectionPlanListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DdosProtectionPlanListResultPage) NotDone() bool {
	return !page.dpplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DdosProtectionPlanListResultPage) Response() DdosProtectionPlanListResult {
	return page.dpplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DdosProtectionPlanListResultPage) Values() []DdosProtectionPlan {
	if page.dpplr.IsEmpty() {
		return nil
	}
	return *page.dpplr.Value
}

// Creates a new instance of the DdosProtectionPlanListResultPage type.
func NewDdosProtectionPlanListResultPage(cur DdosProtectionPlanListResult, getNextPage func(context.Context, DdosProtectionPlanListResult) (DdosProtectionPlanListResult, error)) DdosProtectionPlanListResultPage {
	return DdosProtectionPlanListResultPage{
		fn:    getNextPage,
		dpplr: cur,
	}
}

// DdosProtectionPlanPropertiesFormat dDoS protection plan properties.
type DdosProtectionPlanPropertiesFormat struct {
	// ResourceGUID - READ-ONLY; The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the DDoS protection plan resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PublicIPAddresses - READ-ONLY; The list of public IPs associated with the DDoS protection plan resource. This list is read-only.
	PublicIPAddresses *[]SubResource `json:"publicIpAddresses,omitempty"`
	// VirtualNetworks - READ-ONLY; The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
	VirtualNetworks *[]SubResource `json:"virtualNetworks,omitempty"`
}

// MarshalJSON is the custom marshaler for DdosProtectionPlanPropertiesFormat.
func (dpppf DdosProtectionPlanPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DdosProtectionPlansCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosProtectionPlansCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosProtectionPlansClient) (DdosProtectionPlan, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DdosProtectionPlansCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DdosProtectionPlansCreateOrUpdateFuture.Result.
func (future *DdosProtectionPlansCreateOrUpdateFuture) result(client DdosProtectionPlansClient) (dpp DdosProtectionPlan, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DdosProtectionPlansCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dpp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DdosProtectionPlansCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dpp.Response.Response, err = future.GetResult(sender); err == nil && dpp.Response.Response.StatusCode != http.StatusNoContent {
		dpp, err = client.CreateOrUpdateResponder(dpp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.DdosProtectionPlansCreateOrUpdateFuture", "Result", dpp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DdosProtectionPlansDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DdosProtectionPlansDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DdosProtectionPlansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DdosProtectionPlansDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DdosProtectionPlansDeleteFuture.Result.
func (future *DdosProtectionPlansDeleteFuture) result(client DdosProtectionPlansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DdosProtectionPlansDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DdosProtectionPlansDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DdosSettings contains the DDoS protection settings of the public IP.
type DdosSettings struct {
	// ProtectionMode - The DDoS protection mode of the public IP. Possible values include: 'DdosSettingsProtectionModeVirtualNetworkInherited', 'DdosSettingsProtectionModeEnabled', 'DdosSettingsProtectionModeDisabled'
	ProtectionMode DdosSettingsProtectionMode `json:"protectionMode,omitempty"`
	// DdosProtectionPlan - The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
	DdosProtectionPlan *SubResource `json:"ddosProtectionPlan,omitempty"`
}

// DefaultAdminPropertiesFormat security default admin rule resource.
type DefaultAdminPropertiesFormat struct {
	// Description - READ-ONLY; A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Flag - Default rule flag.
	Flag *string `json:"flag,omitempty"`
	// Protocol - READ-ONLY; Network protocol this rule applies to. Possible values include: 'SecurityConfigurationRuleProtocolTCP', 'SecurityConfigurationRuleProtocolUDP', 'SecurityConfigurationRuleProtocolIcmp', 'SecurityConfigurationRuleProtocolEsp', 'SecurityConfigurationRuleProtocolAny', 'SecurityConfigurationRuleProtocolAh'
	Protocol SecurityConfigurationRuleProtocol `json:"protocol,omitempty"`
	// Sources - READ-ONLY; The CIDR or source IP ranges.
	Sources *[]AddressPrefixItem `json:"sources,omitempty"`
	// Destinations - READ-ONLY; The destination address prefixes. CIDR or destination IP ranges.
	Destinations *[]AddressPrefixItem `json:"destinations,omitempty"`
	// SourcePortRanges - READ-ONLY; The source port ranges.
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - READ-ONLY; The destination port ranges.
	DestinationPortRanges *[]string `json:"destinationPortRanges,omitempty"`
	// Access - READ-ONLY; Indicates the access allowed for this particular rule. Possible values include: 'SecurityConfigurationRuleAccessAllow', 'SecurityConfigurationRuleAccessDeny', 'SecurityConfigurationRuleAccessAlwaysAllow'
	Access SecurityConfigurationRuleAccess `json:"access,omitempty"`
	// Priority - READ-ONLY; The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - READ-ONLY; Indicates if the traffic matched against the rule in inbound or outbound. Possible values include: 'SecurityConfigurationRuleDirectionInbound', 'SecurityConfigurationRuleDirectionOutbound'
	Direction SecurityConfigurationRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DefaultAdminPropertiesFormat.
func (dapf DefaultAdminPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dapf.Flag != nil {
		objectMap["flag"] = dapf.Flag
	}
	return json.Marshal(objectMap)
}

// DefaultAdminRule network default admin rule.
type DefaultAdminRule struct {
	// DefaultAdminPropertiesFormat - Indicates the properties of the security admin rule
	*DefaultAdminPropertiesFormat `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Kind - Possible values include: 'KindBasicBaseAdminRuleKindBaseAdminRule', 'KindBasicBaseAdminRuleKindCustom', 'KindBasicBaseAdminRuleKindDefault'
	Kind KindBasicBaseAdminRule `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for DefaultAdminRule.
func (dar DefaultAdminRule) MarshalJSON() ([]byte, error) {
	dar.Kind = KindBasicBaseAdminRuleKindDefault
	objectMap := make(map[string]interface{})
	if dar.DefaultAdminPropertiesFormat != nil {
		objectMap["properties"] = dar.DefaultAdminPropertiesFormat
	}
	if dar.Kind != "" {
		objectMap["kind"] = dar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAdminRule is the BasicBaseAdminRule implementation for DefaultAdminRule.
func (dar DefaultAdminRule) AsAdminRule() (*AdminRule, bool) {
	return nil, false
}

// AsDefaultAdminRule is the BasicBaseAdminRule implementation for DefaultAdminRule.
func (dar DefaultAdminRule) AsDefaultAdminRule() (*DefaultAdminRule, bool) {
	return &dar, true
}

// AsBaseAdminRule is the BasicBaseAdminRule implementation for DefaultAdminRule.
func (dar DefaultAdminRule) AsBaseAdminRule() (*BaseAdminRule, bool) {
	return nil, false
}

// AsBasicBaseAdminRule is the BasicBaseAdminRule implementation for DefaultAdminRule.
func (dar DefaultAdminRule) AsBasicBaseAdminRule() (BasicBaseAdminRule, bool) {
	return &dar, true
}

// UnmarshalJSON is the custom unmarshaler for DefaultAdminRule struct.
func (dar *DefaultAdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var defaultAdminPropertiesFormat DefaultAdminPropertiesFormat
				err = json.Unmarshal(*v, &defaultAdminPropertiesFormat)
				if err != nil {
					return err
				}
				dar.DefaultAdminPropertiesFormat = &defaultAdminPropertiesFormat
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dar.SystemData = &systemData
			}
		case "kind":
			if v != nil {
				var kind KindBasicBaseAdminRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dar.Etag = &etag
			}
		}
	}

	return nil
}

// DefaultRuleSetPropertyFormat the default web application firewall rule set.
type DefaultRuleSetPropertyFormat struct {
	// RuleSetType - The type of the web application firewall rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - The version of the web application firewall rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
}

// Delegation details the service to which the subnet is delegated.
type Delegation struct {
	// ServiceDelegationPropertiesFormat - Properties of the subnet.
	*ServiceDelegationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a subnet. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Delegation.
func (d Delegation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.ServiceDelegationPropertiesFormat != nil {
		objectMap["properties"] = d.ServiceDelegationPropertiesFormat
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Delegation struct.
func (d *Delegation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceDelegationPropertiesFormat ServiceDelegationPropertiesFormat
				err = json.Unmarshal(*v, &serviceDelegationPropertiesFormat)
				if err != nil {
					return err
				}
				d.ServiceDelegationPropertiesFormat = &serviceDelegationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		}
	}

	return nil
}

// DeleteBastionShareableLinkFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeleteBastionShareableLinkFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteBastionShareableLinkFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteBastionShareableLinkFuture.Result.
func (future *DeleteBastionShareableLinkFuture) result(client BaseClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DeleteBastionShareableLinkFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DeleteBastionShareableLinkFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeviceProperties list of properties of the device.
type DeviceProperties struct {
	// DeviceVendor - Name of the device Vendor.
	DeviceVendor *string `json:"deviceVendor,omitempty"`
	// DeviceModel - Model of the device.
	DeviceModel *string `json:"deviceModel,omitempty"`
	// LinkSpeedInMbps - Link speed.
	LinkSpeedInMbps *int32 `json:"linkSpeedInMbps,omitempty"`
}

// DhcpOptions dhcpOptions contains an array of DNS servers available to VMs deployed in the virtual
// network. Standard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// Dimension dimension of the metric.
type Dimension struct {
	// Name - The name of the dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - The internal name of the dimension.
	InternalName *string `json:"internalName,omitempty"`
}

// DNSNameAvailabilityResult response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False).
	Available *bool `json:"available,omitempty"`
}

// DNSSettings DNS Proxy Settings in Firewall Policy.
type DNSSettings struct {
	// Servers - List of Custom DNS Servers.
	Servers *[]string `json:"servers,omitempty"`
	// EnableProxy - Enable DNS Proxy on Firewalls attached to the Firewall Policy.
	EnableProxy *bool `json:"enableProxy,omitempty"`
	// RequireProxyForNetworkRules - FQDNs in Network Rules are supported when set to true.
	RequireProxyForNetworkRules *bool `json:"requireProxyForNetworkRules,omitempty"`
}

// DscpConfiguration differentiated Services Code Point configuration for any given network interface
type DscpConfiguration struct {
	autorest.Response `json:"-"`
	// DscpConfigurationPropertiesFormat - Properties of the network interface.
	*DscpConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DscpConfiguration.
func (dc DscpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DscpConfigurationPropertiesFormat != nil {
		objectMap["properties"] = dc.DscpConfigurationPropertiesFormat
	}
	if dc.ID != nil {
		objectMap["id"] = dc.ID
	}
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	if dc.Tags != nil {
		objectMap["tags"] = dc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DscpConfiguration struct.
func (dc *DscpConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dscpConfigurationPropertiesFormat DscpConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &dscpConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				dc.DscpConfigurationPropertiesFormat = &dscpConfigurationPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				dc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dc.Tags = tags
			}
		}
	}

	return nil
}

// DscpConfigurationCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DscpConfigurationCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DscpConfigurationClient) (DscpConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DscpConfigurationCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DscpConfigurationCreateOrUpdateFuture.Result.
func (future *DscpConfigurationCreateOrUpdateFuture) result(client DscpConfigurationClient) (dc DscpConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DscpConfigurationCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DscpConfigurationCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dc.Response.Response, err = future.GetResult(sender); err == nil && dc.Response.Response.StatusCode != http.StatusNoContent {
		dc, err = client.CreateOrUpdateResponder(dc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.DscpConfigurationCreateOrUpdateFuture", "Result", dc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DscpConfigurationDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DscpConfigurationDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DscpConfigurationClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DscpConfigurationDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DscpConfigurationDeleteFuture.Result.
func (future *DscpConfigurationDeleteFuture) result(client DscpConfigurationClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.DscpConfigurationDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.DscpConfigurationDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DscpConfigurationListResult response for the DscpConfigurationList API service call.
type DscpConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of dscp configurations in a resource group.
	Value *[]DscpConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DscpConfigurationListResult.
func (dclr DscpConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dclr.Value != nil {
		objectMap["value"] = dclr.Value
	}
	return json.Marshal(objectMap)
}

// DscpConfigurationListResultIterator provides access to a complete listing of DscpConfiguration values.
type DscpConfigurationListResultIterator struct {
	i    int
	page DscpConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DscpConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscpConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DscpConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DscpConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DscpConfigurationListResultIterator) Response() DscpConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DscpConfigurationListResultIterator) Value() DscpConfiguration {
	if !iter.page.NotDone() {
		return DscpConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DscpConfigurationListResultIterator type.
func NewDscpConfigurationListResultIterator(page DscpConfigurationListResultPage) DscpConfigurationListResultIterator {
	return DscpConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DscpConfigurationListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dclr DscpConfigurationListResult) hasNextLink() bool {
	return dclr.NextLink != nil && len(*dclr.NextLink) != 0
}

// dscpConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DscpConfigurationListResult) dscpConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DscpConfigurationListResultPage contains a page of DscpConfiguration values.
type DscpConfigurationListResultPage struct {
	fn   func(context.Context, DscpConfigurationListResult) (DscpConfigurationListResult, error)
	dclr DscpConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DscpConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DscpConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dclr)
		if err != nil {
			return err
		}
		page.dclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DscpConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DscpConfigurationListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DscpConfigurationListResultPage) Response() DscpConfigurationListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DscpConfigurationListResultPage) Values() []DscpConfiguration {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// Creates a new instance of the DscpConfigurationListResultPage type.
func NewDscpConfigurationListResultPage(cur DscpConfigurationListResult, getNextPage func(context.Context, DscpConfigurationListResult) (DscpConfigurationListResult, error)) DscpConfigurationListResultPage {
	return DscpConfigurationListResultPage{
		fn:   getNextPage,
		dclr: cur,
	}
}

// DscpConfigurationPropertiesFormat differentiated Services Code Point configuration properties.
type DscpConfigurationPropertiesFormat struct {
	// Markings - List of markings to be used in the configuration.
	Markings *[]int32 `json:"markings,omitempty"`
	// SourceIPRanges - Source IP ranges.
	SourceIPRanges *[]QosIPRange `json:"sourceIpRanges,omitempty"`
	// DestinationIPRanges - Destination IP ranges.
	DestinationIPRanges *[]QosIPRange `json:"destinationIpRanges,omitempty"`
	// SourcePortRanges - Sources port ranges.
	SourcePortRanges *[]QosPortRange `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - Destination port ranges.
	DestinationPortRanges *[]QosPortRange `json:"destinationPortRanges,omitempty"`
	// Protocol - RNM supported protocol types. Possible values include: 'ProtocolTypeDoNotUse', 'ProtocolTypeIcmp', 'ProtocolTypeTCP', 'ProtocolTypeUDP', 'ProtocolTypeGre', 'ProtocolTypeEsp', 'ProtocolTypeAh', 'ProtocolTypeVxlan', 'ProtocolTypeAll'
	Protocol ProtocolType `json:"protocol,omitempty"`
	// QosDefinitionCollection - QoS object definitions
	QosDefinitionCollection *[]QosDefinition `json:"qosDefinitionCollection,omitempty"`
	// QosCollectionID - READ-ONLY; Qos Collection ID generated by RNM.
	QosCollectionID *string `json:"qosCollectionId,omitempty"`
	// AssociatedNetworkInterfaces - READ-ONLY; Associated Network Interfaces to the DSCP Configuration.
	AssociatedNetworkInterfaces *[]Interface `json:"associatedNetworkInterfaces,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the DSCP Configuration resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the DSCP Configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for DscpConfigurationPropertiesFormat.
func (dcpf DscpConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcpf.Markings != nil {
		objectMap["markings"] = dcpf.Markings
	}
	if dcpf.SourceIPRanges != nil {
		objectMap["sourceIpRanges"] = dcpf.SourceIPRanges
	}
	if dcpf.DestinationIPRanges != nil {
		objectMap["destinationIpRanges"] = dcpf.DestinationIPRanges
	}
	if dcpf.SourcePortRanges != nil {
		objectMap["sourcePortRanges"] = dcpf.SourcePortRanges
	}
	if dcpf.DestinationPortRanges != nil {
		objectMap["destinationPortRanges"] = dcpf.DestinationPortRanges
	}
	if dcpf.Protocol != "" {
		objectMap["protocol"] = dcpf.Protocol
	}
	if dcpf.QosDefinitionCollection != nil {
		objectMap["qosDefinitionCollection"] = dcpf.QosDefinitionCollection
	}
	return json.Marshal(objectMap)
}

// BasicEffectiveBaseSecurityAdminRule network base admin rule.
type BasicEffectiveBaseSecurityAdminRule interface {
	AsEffectiveSecurityAdminRule() (*EffectiveSecurityAdminRule, bool)
	AsEffectiveDefaultSecurityAdminRule() (*EffectiveDefaultSecurityAdminRule, bool)
	AsEffectiveBaseSecurityAdminRule() (*EffectiveBaseSecurityAdminRule, bool)
}

// EffectiveBaseSecurityAdminRule network base admin rule.
type EffectiveBaseSecurityAdminRule struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule', 'KindBasicEffectiveBaseSecurityAdminRuleKindCustom', 'KindBasicEffectiveBaseSecurityAdminRuleKindDefault'
	Kind KindBasicEffectiveBaseSecurityAdminRule `json:"kind,omitempty"`
}

func unmarshalBasicEffectiveBaseSecurityAdminRule(body []byte) (BasicEffectiveBaseSecurityAdminRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicEffectiveBaseSecurityAdminRuleKindCustom):
		var esar EffectiveSecurityAdminRule
		err := json.Unmarshal(body, &esar)
		return esar, err
	case string(KindBasicEffectiveBaseSecurityAdminRuleKindDefault):
		var edsar EffectiveDefaultSecurityAdminRule
		err := json.Unmarshal(body, &edsar)
		return edsar, err
	default:
		var ebsar EffectiveBaseSecurityAdminRule
		err := json.Unmarshal(body, &ebsar)
		return ebsar, err
	}
}
func unmarshalBasicEffectiveBaseSecurityAdminRuleArray(body []byte) ([]BasicEffectiveBaseSecurityAdminRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebsarArray := make([]BasicEffectiveBaseSecurityAdminRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ebsar, err := unmarshalBasicEffectiveBaseSecurityAdminRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebsarArray[index] = ebsar
	}
	return ebsarArray, nil
}

// MarshalJSON is the custom marshaler for EffectiveBaseSecurityAdminRule.
func (ebsar EffectiveBaseSecurityAdminRule) MarshalJSON() ([]byte, error) {
	ebsar.Kind = KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule
	objectMap := make(map[string]interface{})
	if ebsar.ID != nil {
		objectMap["id"] = ebsar.ID
	}
	if ebsar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = ebsar.ConfigurationDescription
	}
	if ebsar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = ebsar.RuleCollectionDescription
	}
	if ebsar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = ebsar.RuleCollectionAppliesToGroups
	}
	if ebsar.RuleGroups != nil {
		objectMap["ruleGroups"] = ebsar.RuleGroups
	}
	if ebsar.Kind != "" {
		objectMap["kind"] = ebsar.Kind
	}
	return json.Marshal(objectMap)
}

// AsEffectiveSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveBaseSecurityAdminRule.
func (ebsar EffectiveBaseSecurityAdminRule) AsEffectiveSecurityAdminRule() (*EffectiveSecurityAdminRule, bool) {
	return nil, false
}

// AsEffectiveDefaultSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveBaseSecurityAdminRule.
func (ebsar EffectiveBaseSecurityAdminRule) AsEffectiveDefaultSecurityAdminRule() (*EffectiveDefaultSecurityAdminRule, bool) {
	return nil, false
}

// AsEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveBaseSecurityAdminRule.
func (ebsar EffectiveBaseSecurityAdminRule) AsEffectiveBaseSecurityAdminRule() (*EffectiveBaseSecurityAdminRule, bool) {
	return &ebsar, true
}

// AsBasicEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveBaseSecurityAdminRule.
func (ebsar EffectiveBaseSecurityAdminRule) AsBasicEffectiveBaseSecurityAdminRule() (BasicEffectiveBaseSecurityAdminRule, bool) {
	return &ebsar, true
}

// EffectiveConnectivityConfiguration the network manager effective connectivity configuration
type EffectiveConnectivityConfiguration struct {
	// ID - Connectivity configuration ID.
	ID *string `json:"id,omitempty"`
	// ConnectivityConfigurationProperties - Properties of a network manager connectivity configuration
	*ConnectivityConfigurationProperties `json:"properties,omitempty"`
	// ConfigurationGroups - Effective configuration groups.
	ConfigurationGroups *[]ConfigurationGroup `json:"configurationGroups,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveConnectivityConfiguration.
func (ecc EffectiveConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ecc.ID != nil {
		objectMap["id"] = ecc.ID
	}
	if ecc.ConnectivityConfigurationProperties != nil {
		objectMap["properties"] = ecc.ConnectivityConfigurationProperties
	}
	if ecc.ConfigurationGroups != nil {
		objectMap["configurationGroups"] = ecc.ConfigurationGroups
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EffectiveConnectivityConfiguration struct.
func (ecc *EffectiveConnectivityConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ecc.ID = &ID
			}
		case "properties":
			if v != nil {
				var connectivityConfigurationProperties ConnectivityConfigurationProperties
				err = json.Unmarshal(*v, &connectivityConfigurationProperties)
				if err != nil {
					return err
				}
				ecc.ConnectivityConfigurationProperties = &connectivityConfigurationProperties
			}
		case "configurationGroups":
			if v != nil {
				var configurationGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &configurationGroups)
				if err != nil {
					return err
				}
				ecc.ConfigurationGroups = &configurationGroups
			}
		}
	}

	return nil
}

// EffectiveDefaultSecurityAdminRule network default admin rule.
type EffectiveDefaultSecurityAdminRule struct {
	// DefaultAdminPropertiesFormat - Indicates the properties of the default security admin rule
	*DefaultAdminPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule', 'KindBasicEffectiveBaseSecurityAdminRuleKindCustom', 'KindBasicEffectiveBaseSecurityAdminRuleKindDefault'
	Kind KindBasicEffectiveBaseSecurityAdminRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveDefaultSecurityAdminRule.
func (edsar EffectiveDefaultSecurityAdminRule) MarshalJSON() ([]byte, error) {
	edsar.Kind = KindBasicEffectiveBaseSecurityAdminRuleKindDefault
	objectMap := make(map[string]interface{})
	if edsar.DefaultAdminPropertiesFormat != nil {
		objectMap["properties"] = edsar.DefaultAdminPropertiesFormat
	}
	if edsar.ID != nil {
		objectMap["id"] = edsar.ID
	}
	if edsar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = edsar.ConfigurationDescription
	}
	if edsar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = edsar.RuleCollectionDescription
	}
	if edsar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = edsar.RuleCollectionAppliesToGroups
	}
	if edsar.RuleGroups != nil {
		objectMap["ruleGroups"] = edsar.RuleGroups
	}
	if edsar.Kind != "" {
		objectMap["kind"] = edsar.Kind
	}
	return json.Marshal(objectMap)
}

// AsEffectiveSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveDefaultSecurityAdminRule.
func (edsar EffectiveDefaultSecurityAdminRule) AsEffectiveSecurityAdminRule() (*EffectiveSecurityAdminRule, bool) {
	return nil, false
}

// AsEffectiveDefaultSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveDefaultSecurityAdminRule.
func (edsar EffectiveDefaultSecurityAdminRule) AsEffectiveDefaultSecurityAdminRule() (*EffectiveDefaultSecurityAdminRule, bool) {
	return &edsar, true
}

// AsEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveDefaultSecurityAdminRule.
func (edsar EffectiveDefaultSecurityAdminRule) AsEffectiveBaseSecurityAdminRule() (*EffectiveBaseSecurityAdminRule, bool) {
	return nil, false
}

// AsBasicEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveDefaultSecurityAdminRule.
func (edsar EffectiveDefaultSecurityAdminRule) AsBasicEffectiveBaseSecurityAdminRule() (BasicEffectiveBaseSecurityAdminRule, bool) {
	return &edsar, true
}

// UnmarshalJSON is the custom unmarshaler for EffectiveDefaultSecurityAdminRule struct.
func (edsar *EffectiveDefaultSecurityAdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var defaultAdminPropertiesFormat DefaultAdminPropertiesFormat
				err = json.Unmarshal(*v, &defaultAdminPropertiesFormat)
				if err != nil {
					return err
				}
				edsar.DefaultAdminPropertiesFormat = &defaultAdminPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				edsar.ID = &ID
			}
		case "configurationDescription":
			if v != nil {
				var configurationDescription string
				err = json.Unmarshal(*v, &configurationDescription)
				if err != nil {
					return err
				}
				edsar.ConfigurationDescription = &configurationDescription
			}
		case "ruleCollectionDescription":
			if v != nil {
				var ruleCollectionDescription string
				err = json.Unmarshal(*v, &ruleCollectionDescription)
				if err != nil {
					return err
				}
				edsar.RuleCollectionDescription = &ruleCollectionDescription
			}
		case "ruleCollectionAppliesToGroups":
			if v != nil {
				var ruleCollectionAppliesToGroups []ManagerSecurityGroupItem
				err = json.Unmarshal(*v, &ruleCollectionAppliesToGroups)
				if err != nil {
					return err
				}
				edsar.RuleCollectionAppliesToGroups = &ruleCollectionAppliesToGroups
			}
		case "ruleGroups":
			if v != nil {
				var ruleGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &ruleGroups)
				if err != nil {
					return err
				}
				edsar.RuleGroups = &ruleGroups
			}
		case "kind":
			if v != nil {
				var kind KindBasicEffectiveBaseSecurityAdminRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				edsar.Kind = kind
			}
		}
	}

	return nil
}

// EffectiveNetworkSecurityGroup effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// NetworkSecurityGroup - The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`
	// Association - Associated resources.
	Association *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`
	// EffectiveSecurityRules - A collection of effective security rules.
	EffectiveSecurityRules *[]EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`
	// TagMap - Mapping of tags to list of IP Addresses included within the tag.
	TagMap map[string][]string `json:"tagMap"`
}

// MarshalJSON is the custom marshaler for EffectiveNetworkSecurityGroup.
func (ensg EffectiveNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensg.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = ensg.NetworkSecurityGroup
	}
	if ensg.Association != nil {
		objectMap["association"] = ensg.Association
	}
	if ensg.EffectiveSecurityRules != nil {
		objectMap["effectiveSecurityRules"] = ensg.EffectiveSecurityRules
	}
	if ensg.TagMap != nil {
		objectMap["tagMap"] = ensg.TagMap
	}
	return json.Marshal(objectMap)
}

// EffectiveNetworkSecurityGroupAssociation the effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// NetworkManager - The ID of the Azure network manager if assigned.
	NetworkManager *SubResource `json:"networkManager,omitempty"`
	// Subnet - The ID of the subnet if assigned.
	Subnet *SubResource `json:"subnet,omitempty"`
	// NetworkInterface - The ID of the network interface if assigned.
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult response for list effective network security groups API service
// call.
type EffectiveNetworkSecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective network security groups.
	Value *[]EffectiveNetworkSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveNetworkSecurityGroupListResult.
func (ensglr EffectiveNetworkSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensglr.Value != nil {
		objectMap["value"] = ensglr.Value
	}
	return json.Marshal(objectMap)
}

// EffectiveNetworkSecurityRule effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Name - The name of the security rule specified by the user (if created by the user).
	Name *string `json:"name,omitempty"`
	// Protocol - The network protocol this rule applies to. Possible values include: 'EffectiveSecurityRuleProtocolTCP', 'EffectiveSecurityRuleProtocolUDP', 'EffectiveSecurityRuleProtocolAll'
	Protocol EffectiveSecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourcePortRanges - The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
	// DestinationPortRanges - The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
	DestinationPortRanges *[]string `json:"destinationPortRanges,omitempty"`
	// SourceAddressPrefix - The source address prefix.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - The destination address prefix.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// SourceAddressPrefixes - The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
	SourceAddressPrefixes *[]string `json:"sourceAddressPrefixes,omitempty"`
	// DestinationAddressPrefixes - The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
	DestinationAddressPrefixes *[]string `json:"destinationAddressPrefixes,omitempty"`
	// ExpandedSourceAddressPrefix - The expanded source address prefix.
	ExpandedSourceAddressPrefix *[]string `json:"expandedSourceAddressPrefix,omitempty"`
	// ExpandedDestinationAddressPrefix - Expanded destination address prefix.
	ExpandedDestinationAddressPrefix *[]string `json:"expandedDestinationAddressPrefix,omitempty"`
	// Access - Whether network traffic is allowed or denied. Possible values include: 'SecurityRuleAccessAllow', 'SecurityRuleAccessDeny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. Possible values include: 'SecurityRuleDirectionInbound', 'SecurityRuleDirectionOutbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
}

// EffectiveRoute effective Route.
type EffectiveRoute struct {
	// Name - The name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`
	// DisableBgpRoutePropagation - If true, on-premises routes are not propagated to the network interfaces in the subnet.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`
	// Source - Who created the route. Possible values include: 'EffectiveRouteSourceUnknown', 'EffectiveRouteSourceUser', 'EffectiveRouteSourceVirtualNetworkGateway', 'EffectiveRouteSourceDefault'
	Source EffectiveRouteSource `json:"source,omitempty"`
	// State - The value of effective route. Possible values include: 'Active', 'Invalid'
	State EffectiveRouteState `json:"state,omitempty"`
	// AddressPrefix - The address prefixes of the effective routes in CIDR notation.
	AddressPrefix *[]string `json:"addressPrefix,omitempty"`
	// NextHopIPAddress - The IP address of the next hop of the effective route.
	NextHopIPAddress *[]string `json:"nextHopIpAddress,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
}

// EffectiveRouteListResult response for list effective route API service call.
type EffectiveRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of effective routes.
	Value *[]EffectiveRoute `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveRouteListResult.
func (erlr EffectiveRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erlr.Value != nil {
		objectMap["value"] = erlr.Value
	}
	return json.Marshal(objectMap)
}

// EffectiveRouteMapRoute the effective RouteMap route configured on the connection resource.
type EffectiveRouteMapRoute struct {
	// Prefix - The address prefix of the route.
	Prefix *[]string `json:"prefix,omitempty"`
	// BgpCommunities - BGP communities of the route.
	BgpCommunities *string `json:"bgpCommunities,omitempty"`
	// AsPath - The ASPath of this route.
	AsPath *string `json:"asPath,omitempty"`
}

// EffectiveRoutesParameters the parameters specifying the resource whose effective routes are being
// requested.
type EffectiveRoutesParameters struct {
	// ResourceID - The resource whose effective routes are being requested.
	ResourceID *string `json:"resourceId,omitempty"`
	// VirtualWanResourceType - The type of the specified resource like RouteTable, ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
	VirtualWanResourceType *string `json:"virtualWanResourceType,omitempty"`
}

// EffectiveSecurityAdminRule network admin rule.
type EffectiveSecurityAdminRule struct {
	// AdminPropertiesFormat - Indicates the properties of the security admin rule
	*AdminPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// ConfigurationDescription - A description of the security admin configuration.
	ConfigurationDescription *string `json:"configurationDescription,omitempty"`
	// RuleCollectionDescription - A description of the rule collection.
	RuleCollectionDescription *string `json:"ruleCollectionDescription,omitempty"`
	// RuleCollectionAppliesToGroups - Groups for rule collection
	RuleCollectionAppliesToGroups *[]ManagerSecurityGroupItem `json:"ruleCollectionAppliesToGroups,omitempty"`
	// RuleGroups - Effective configuration groups.
	RuleGroups *[]ConfigurationGroup `json:"ruleGroups,omitempty"`
	// Kind - Possible values include: 'KindBasicEffectiveBaseSecurityAdminRuleKindEffectiveBaseSecurityAdminRule', 'KindBasicEffectiveBaseSecurityAdminRuleKindCustom', 'KindBasicEffectiveBaseSecurityAdminRuleKindDefault'
	Kind KindBasicEffectiveBaseSecurityAdminRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EffectiveSecurityAdminRule.
func (esar EffectiveSecurityAdminRule) MarshalJSON() ([]byte, error) {
	esar.Kind = KindBasicEffectiveBaseSecurityAdminRuleKindCustom
	objectMap := make(map[string]interface{})
	if esar.AdminPropertiesFormat != nil {
		objectMap["properties"] = esar.AdminPropertiesFormat
	}
	if esar.ID != nil {
		objectMap["id"] = esar.ID
	}
	if esar.ConfigurationDescription != nil {
		objectMap["configurationDescription"] = esar.ConfigurationDescription
	}
	if esar.RuleCollectionDescription != nil {
		objectMap["ruleCollectionDescription"] = esar.RuleCollectionDescription
	}
	if esar.RuleCollectionAppliesToGroups != nil {
		objectMap["ruleCollectionAppliesToGroups"] = esar.RuleCollectionAppliesToGroups
	}
	if esar.RuleGroups != nil {
		objectMap["ruleGroups"] = esar.RuleGroups
	}
	if esar.Kind != "" {
		objectMap["kind"] = esar.Kind
	}
	return json.Marshal(objectMap)
}

// AsEffectiveSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveSecurityAdminRule.
func (esar EffectiveSecurityAdminRule) AsEffectiveSecurityAdminRule() (*EffectiveSecurityAdminRule, bool) {
	return &esar, true
}

// AsEffectiveDefaultSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveSecurityAdminRule.
func (esar EffectiveSecurityAdminRule) AsEffectiveDefaultSecurityAdminRule() (*EffectiveDefaultSecurityAdminRule, bool) {
	return nil, false
}

// AsEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveSecurityAdminRule.
func (esar EffectiveSecurityAdminRule) AsEffectiveBaseSecurityAdminRule() (*EffectiveBaseSecurityAdminRule, bool) {
	return nil, false
}

// AsBasicEffectiveBaseSecurityAdminRule is the BasicEffectiveBaseSecurityAdminRule implementation for EffectiveSecurityAdminRule.
func (esar EffectiveSecurityAdminRule) AsBasicEffectiveBaseSecurityAdminRule() (BasicEffectiveBaseSecurityAdminRule, bool) {
	return &esar, true
}

// UnmarshalJSON is the custom unmarshaler for EffectiveSecurityAdminRule struct.
func (esar *EffectiveSecurityAdminRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adminPropertiesFormat AdminPropertiesFormat
				err = json.Unmarshal(*v, &adminPropertiesFormat)
				if err != nil {
					return err
				}
				esar.AdminPropertiesFormat = &adminPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esar.ID = &ID
			}
		case "configurationDescription":
			if v != nil {
				var configurationDescription string
				err = json.Unmarshal(*v, &configurationDescription)
				if err != nil {
					return err
				}
				esar.ConfigurationDescription = &configurationDescription
			}
		case "ruleCollectionDescription":
			if v != nil {
				var ruleCollectionDescription string
				err = json.Unmarshal(*v, &ruleCollectionDescription)
				if err != nil {
					return err
				}
				esar.RuleCollectionDescription = &ruleCollectionDescription
			}
		case "ruleCollectionAppliesToGroups":
			if v != nil {
				var ruleCollectionAppliesToGroups []ManagerSecurityGroupItem
				err = json.Unmarshal(*v, &ruleCollectionAppliesToGroups)
				if err != nil {
					return err
				}
				esar.RuleCollectionAppliesToGroups = &ruleCollectionAppliesToGroups
			}
		case "ruleGroups":
			if v != nil {
				var ruleGroups []ConfigurationGroup
				err = json.Unmarshal(*v, &ruleGroups)
				if err != nil {
					return err
				}
				esar.RuleGroups = &ruleGroups
			}
		case "kind":
			if v != nil {
				var kind KindBasicEffectiveBaseSecurityAdminRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				esar.Kind = kind
			}
		}
	}

	return nil
}

// EndpointServiceResult endpoint service.
type EndpointServiceResult struct {
	// Name - READ-ONLY; Name of the endpoint service.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the endpoint service.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointServiceResult.
func (esr EndpointServiceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esr.ID != nil {
		objectMap["id"] = esr.ID
	}
	return json.Marshal(objectMap)
}

// EndpointServicesListResult response for the ListAvailableEndpointServices API service call.
type EndpointServicesListResult struct {
	autorest.Response `json:"-"`
	// Value - List of available endpoint services in a region.
	Value *[]EndpointServiceResult `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointServicesListResultIterator provides access to a complete listing of EndpointServiceResult
// values.
type EndpointServicesListResultIterator struct {
	i    int
	page EndpointServicesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointServicesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointServicesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointServicesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointServicesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointServicesListResultIterator) Response() EndpointServicesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointServicesListResultIterator) Value() EndpointServiceResult {
	if !iter.page.NotDone() {
		return EndpointServiceResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointServicesListResultIterator type.
func NewEndpointServicesListResultIterator(page EndpointServicesListResultPage) EndpointServicesListResultIterator {
	return EndpointServicesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eslr EndpointServicesListResult) IsEmpty() bool {
	return eslr.Value == nil || len(*eslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eslr EndpointServicesListResult) hasNextLink() bool {
	return eslr.NextLink != nil && len(*eslr.NextLink) != 0
}

// endpointServicesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eslr EndpointServicesListResult) endpointServicesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eslr.NextLink)))
}

// EndpointServicesListResultPage contains a page of EndpointServiceResult values.
type EndpointServicesListResultPage struct {
	fn   func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)
	eslr EndpointServicesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointServicesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointServicesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eslr)
		if err != nil {
			return err
		}
		page.eslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointServicesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointServicesListResultPage) NotDone() bool {
	return !page.eslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointServicesListResultPage) Response() EndpointServicesListResult {
	return page.eslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointServicesListResultPage) Values() []EndpointServiceResult {
	if page.eslr.IsEmpty() {
		return nil
	}
	return *page.eslr.Value
}

// Creates a new instance of the EndpointServicesListResultPage type.
func NewEndpointServicesListResultPage(cur EndpointServicesListResult, getNextPage func(context.Context, EndpointServicesListResult) (EndpointServicesListResult, error)) EndpointServicesListResultPage {
	return EndpointServicesListResultPage{
		fn:   getNextPage,
		eslr: cur,
	}
}

// Error common error representation.
type Error struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Details - Error details.
	Details *[]ErrorDetails `json:"details,omitempty"`
	// InnerError - Inner error message.
	InnerError *string `json:"innerError,omitempty"`
}

// ErrorDetails common error details representation.
type ErrorDetails struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Target - Error target.
	Target *string `json:"target,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse the error object.
type ErrorResponse struct {
	// Error - The error details object.
	Error *ErrorDetails `json:"error,omitempty"`
}

// EvaluatedNetworkSecurityGroup results of network security group evaluation.
type EvaluatedNetworkSecurityGroup struct {
	// NetworkSecurityGroupID - Network security group ID.
	NetworkSecurityGroupID *string `json:"networkSecurityGroupId,omitempty"`
	// AppliedTo - Resource ID of nic or subnet to which network security group is applied.
	AppliedTo *string `json:"appliedTo,omitempty"`
	// MatchedRule - Matched network security rule.
	MatchedRule *MatchedRule `json:"matchedRule,omitempty"`
	// RulesEvaluationResult - READ-ONLY; List of network security rules evaluation results.
	RulesEvaluationResult *[]SecurityRulesEvaluationResult `json:"rulesEvaluationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for EvaluatedNetworkSecurityGroup.
func (ensg EvaluatedNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ensg.NetworkSecurityGroupID != nil {
		objectMap["networkSecurityGroupId"] = ensg.NetworkSecurityGroupID
	}
	if ensg.AppliedTo != nil {
		objectMap["appliedTo"] = ensg.AppliedTo
	}
	if ensg.MatchedRule != nil {
		objectMap["matchedRule"] = ensg.MatchedRule
	}
	return json.Marshal(objectMap)
}

// ExclusionManagedRule defines a managed rule to use for exclusion.
type ExclusionManagedRule struct {
	// RuleID - Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
}

// ExclusionManagedRuleGroup defines a managed rule group to use for exclusion.
type ExclusionManagedRuleGroup struct {
	// RuleGroupName - The managed rule group for exclusion.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - List of rules that will be excluded. If none specified, all rules in the group will be excluded.
	Rules *[]ExclusionManagedRule `json:"rules,omitempty"`
}

// ExclusionManagedRuleSet defines a managed rule set for Exclusions.
type ExclusionManagedRuleSet struct {
	// RuleSetType - Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - Defines the rule groups to apply to the rule set.
	RuleGroups *[]ExclusionManagedRuleGroup `json:"ruleGroups,omitempty"`
}

// ExplicitProxy explicit Proxy Settings in Firewall Policy.
type ExplicitProxy struct {
	// EnableExplicitProxy - When set to true, explicit proxy mode is enabled.
	EnableExplicitProxy *bool `json:"enableExplicitProxy,omitempty"`
	// HTTPPort - Port number for explicit proxy http protocol, cannot be greater than 64000.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - Port number for explicit proxy https protocol, cannot be greater than 64000.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// EnablePacFile - When set to true, pac file port and url needs to be provided.
	EnablePacFile *bool `json:"enablePacFile,omitempty"`
	// PacFilePort - Port number for firewall to serve PAC file.
	PacFilePort *int32 `json:"pacFilePort,omitempty"`
	// PacFile - SAS URL for PAC file.
	PacFile *string `json:"pacFile,omitempty"`
}

// ExpressRouteCircuit expressRouteCircuit resource.
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - The SKU.
	Sku *ExpressRouteCircuitSku `json:"sku,omitempty"`
	// ExpressRouteCircuitPropertiesFormat - Properties of the express route circuit.
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCircuitArpTable the ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// Age - Entry age in minutes.
	Age *int32 `json:"age,omitempty"`
	// Interface - Interface address.
	Interface *string `json:"interface,omitempty"`
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - The MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	autorest.Response `json:"-"`
	// AuthorizationPropertiesFormat - Properties of the express route circuit authorization.
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erca.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (ExpressRouteCircuitAuthorization, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture) result(client ExpressRouteCircuitAuthorizationsClient) (erca ExpressRouteCircuitAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erca.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erca.Response.Response, err = future.GetResult(sender); err == nil && erca.Response.Response.StatusCode != http.StatusNoContent {
		erca, err = client.CreateOrUpdateResponder(erca.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", erca.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitAuthorizationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitAuthorizationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitAuthorizationsDeleteFuture.Result.
func (future *ExpressRouteCircuitAuthorizationsDeleteFuture) result(client ExpressRouteCircuitAuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitConnection express Route Circuit Connection in an ExpressRouteCircuitPeering
// resource.
type ExpressRouteCircuitConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteCircuitConnectionPropertiesFormat - Properties of the express route circuit connection.
	*ExpressRouteCircuitConnectionPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitConnection.
func (ercc ExpressRouteCircuitConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercc.ExpressRouteCircuitConnectionPropertiesFormat != nil {
		objectMap["properties"] = ercc.ExpressRouteCircuitConnectionPropertiesFormat
	}
	if ercc.Name != nil {
		objectMap["name"] = ercc.Name
	}
	if ercc.ID != nil {
		objectMap["id"] = ercc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitConnection struct.
func (ercc *ExpressRouteCircuitConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitConnectionPropertiesFormat ExpressRouteCircuitConnectionPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				ercc.ExpressRouteCircuitConnectionPropertiesFormat = &expressRouteCircuitConnectionPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercc.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitConnectionListResult response for ListConnections API service call retrieves all
// global reach connections that belongs to a Private Peering for an ExpressRouteCircuit.
type ExpressRouteCircuitConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The global reach connection associated with Private Peering in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitConnectionListResultIterator provides access to a complete listing of
// ExpressRouteCircuitConnection values.
type ExpressRouteCircuitConnectionListResultIterator struct {
	i    int
	page ExpressRouteCircuitConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitConnectionListResultIterator) Response() ExpressRouteCircuitConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitConnectionListResultIterator) Value() ExpressRouteCircuitConnection {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitConnectionListResultIterator type.
func NewExpressRouteCircuitConnectionListResultIterator(page ExpressRouteCircuitConnectionListResultPage) ExpressRouteCircuitConnectionListResultIterator {
	return ExpressRouteCircuitConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercclr ExpressRouteCircuitConnectionListResult) IsEmpty() bool {
	return ercclr.Value == nil || len(*ercclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercclr ExpressRouteCircuitConnectionListResult) hasNextLink() bool {
	return ercclr.NextLink != nil && len(*ercclr.NextLink) != 0
}

// expressRouteCircuitConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercclr ExpressRouteCircuitConnectionListResult) expressRouteCircuitConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercclr.NextLink)))
}

// ExpressRouteCircuitConnectionListResultPage contains a page of ExpressRouteCircuitConnection values.
type ExpressRouteCircuitConnectionListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)
	ercclr ExpressRouteCircuitConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercclr)
		if err != nil {
			return err
		}
		page.ercclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitConnectionListResultPage) NotDone() bool {
	return !page.ercclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitConnectionListResultPage) Response() ExpressRouteCircuitConnectionListResult {
	return page.ercclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitConnectionListResultPage) Values() []ExpressRouteCircuitConnection {
	if page.ercclr.IsEmpty() {
		return nil
	}
	return *page.ercclr.Value
}

// Creates a new instance of the ExpressRouteCircuitConnectionListResultPage type.
func NewExpressRouteCircuitConnectionListResultPage(cur ExpressRouteCircuitConnectionListResult, getNextPage func(context.Context, ExpressRouteCircuitConnectionListResult) (ExpressRouteCircuitConnectionListResult, error)) ExpressRouteCircuitConnectionListResultPage {
	return ExpressRouteCircuitConnectionListResultPage{
		fn:     getNextPage,
		ercclr: cur,
	}
}

// ExpressRouteCircuitConnectionPropertiesFormat properties of the express route circuit connection.
type ExpressRouteCircuitConnectionPropertiesFormat struct {
	// ExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
	ExpressRouteCircuitPeering *SubResource `json:"expressRouteCircuitPeering,omitempty"`
	// PeerExpressRouteCircuitPeering - Reference to Express Route Circuit Private Peering Resource of the peered circuit.
	PeerExpressRouteCircuitPeering *SubResource `json:"peerExpressRouteCircuitPeering,omitempty"`
	// AddressPrefix - /29 IP address space to carve out Customer addresses for tunnels.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// Ipv6CircuitConnectionConfig - IPv6 Address PrefixProperties of the express route circuit connection.
	Ipv6CircuitConnectionConfig *Ipv6CircuitConnectionConfig `json:"ipv6CircuitConnectionConfig,omitempty"`
	// CircuitConnectionStatus - Express Route Circuit connection state. Possible values include: 'Connected', 'Connecting', 'Disconnected'
	CircuitConnectionStatus CircuitConnectionStatus `json:"circuitConnectionStatus,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route circuit connection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitConnectionPropertiesFormat.
func (erccpf ExpressRouteCircuitConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpf.ExpressRouteCircuitPeering != nil {
		objectMap["expressRouteCircuitPeering"] = erccpf.ExpressRouteCircuitPeering
	}
	if erccpf.PeerExpressRouteCircuitPeering != nil {
		objectMap["peerExpressRouteCircuitPeering"] = erccpf.PeerExpressRouteCircuitPeering
	}
	if erccpf.AddressPrefix != nil {
		objectMap["addressPrefix"] = erccpf.AddressPrefix
	}
	if erccpf.AuthorizationKey != nil {
		objectMap["authorizationKey"] = erccpf.AuthorizationKey
	}
	if erccpf.Ipv6CircuitConnectionConfig != nil {
		objectMap["ipv6CircuitConnectionConfig"] = erccpf.Ipv6CircuitConnectionConfig
	}
	if erccpf.CircuitConnectionStatus != "" {
		objectMap["circuitConnectionStatus"] = erccpf.CircuitConnectionStatus
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitConnectionsClient) (ExpressRouteCircuitConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitConnectionsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCircuitConnectionsCreateOrUpdateFuture) result(client ExpressRouteCircuitConnectionsClient) (ercc ExpressRouteCircuitConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercc.Response.Response, err = future.GetResult(sender); err == nil && ercc.Response.Response.StatusCode != http.StatusNoContent {
		ercc, err = client.CreateOrUpdateResponder(ercc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitConnectionsCreateOrUpdateFuture", "Result", ercc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitConnectionsDeleteFuture.Result.
func (future *ExpressRouteCircuitConnectionsDeleteFuture) result(client ExpressRouteCircuitConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitListResult response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCircuits in a resource group.
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit
// values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitListResultIterator type.
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return ExpressRouteCircuitListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erclr ExpressRouteCircuitListResult) hasNextLink() bool {
	return erclr.NextLink != nil && len(*erclr.NextLink) != 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erclr)
		if err != nil {
			return err
		}
		page.erclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// Creates a new instance of the ExpressRouteCircuitListResultPage type.
func NewExpressRouteCircuitListResultPage(cur ExpressRouteCircuitListResult, getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return ExpressRouteCircuitListResultPage{
		fn:    getNextPage,
		erclr: cur,
	}
}

// ExpressRouteCircuitPeering peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	autorest.Response `json:"-"`
	// ExpressRouteCircuitPeeringPropertiesFormat - Properties of the express route circuit peering.
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitPeeringConfig specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - The reference to AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedCommunities - The communities of bgp peering. Specified for microsoft peering.
	AdvertisedCommunities *[]string `json:"advertisedCommunities,omitempty"`
	// AdvertisedPublicPrefixesState - READ-ONLY; The advertised public prefix state of the Peering resource. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// LegacyMode - The legacy mode of the peering.
	LegacyMode *int32 `json:"legacyMode,omitempty"`
	// CustomerASN - The CustomerASN of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - The RoutingRegistryName of the configuration.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeeringConfig.
func (ercpc ExpressRouteCircuitPeeringConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercpc.AdvertisedPublicPrefixes != nil {
		objectMap["advertisedPublicPrefixes"] = ercpc.AdvertisedPublicPrefixes
	}
	if ercpc.AdvertisedCommunities != nil {
		objectMap["advertisedCommunities"] = ercpc.AdvertisedCommunities
	}
	if ercpc.LegacyMode != nil {
		objectMap["legacyMode"] = ercpc.LegacyMode
	}
	if ercpc.CustomerASN != nil {
		objectMap["customerASN"] = ercpc.CustomerASN
	}
	if ercpc.RoutingRegistryName != nil {
		objectMap["routingRegistryName"] = ercpc.RoutingRegistryName
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitPeeringID expressRoute circuit peering identifier.
type ExpressRouteCircuitPeeringID struct {
	// ID - The ID of the ExpressRoute circuit peering.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitPeeringListResult response for ListPeering API service call retrieves all peerings
// that belong to an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route circuit.
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of
// ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultIterator type.
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return ExpressRouteCircuitPeeringListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercplr ExpressRouteCircuitPeeringListResult) hasNextLink() bool {
	return ercplr.NextLink != nil && len(*ercplr.NextLink) != 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercplr)
		if err != nil {
			return err
		}
		page.ercplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultPage type.
func NewExpressRouteCircuitPeeringListResultPage(cur ExpressRouteCircuitPeeringListResult, getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return ExpressRouteCircuitPeeringListResultPage{
		fn:     getNextPage,
		ercplr: cur,
	}
}

// ExpressRouteCircuitPeeringPropertiesFormat properties of the express route circuit peering.
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - The peering type. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRoutePeeringType `json:"peeringType,omitempty"`
	// State - The peering state. Possible values include: 'ExpressRoutePeeringStateDisabled', 'ExpressRoutePeeringStateEnabled'
	State ExpressRoutePeeringState `json:"state,omitempty"`
	// AzureASN - The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - The peering stats of express route circuit.
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route circuit peering resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// RouteFilter - The reference to the RouteFilter resource.
	RouteFilter *SubResource `json:"routeFilter,omitempty"`
	// Ipv6PeeringConfig - The IPv6 peering configuration.
	Ipv6PeeringConfig *Ipv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`
	// ExpressRouteConnection - The ExpressRoute connection.
	ExpressRouteConnection *ExpressRouteConnectionID `json:"expressRouteConnection,omitempty"`
	// Connections - The list of circuit connections associated with Azure Private Peering for this circuit.
	Connections *[]ExpressRouteCircuitConnection `json:"connections,omitempty"`
	// PeeredConnections - READ-ONLY; The list of peered circuit connections associated with Azure Private Peering for this circuit.
	PeeredConnections *[]PeerExpressRouteCircuitConnection `json:"peeredConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeeringPropertiesFormat.
func (ercppf ExpressRouteCircuitPeeringPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercppf.PeeringType != "" {
		objectMap["peeringType"] = ercppf.PeeringType
	}
	if ercppf.State != "" {
		objectMap["state"] = ercppf.State
	}
	if ercppf.AzureASN != nil {
		objectMap["azureASN"] = ercppf.AzureASN
	}
	if ercppf.PeerASN != nil {
		objectMap["peerASN"] = ercppf.PeerASN
	}
	if ercppf.PrimaryPeerAddressPrefix != nil {
		objectMap["primaryPeerAddressPrefix"] = ercppf.PrimaryPeerAddressPrefix
	}
	if ercppf.SecondaryPeerAddressPrefix != nil {
		objectMap["secondaryPeerAddressPrefix"] = ercppf.SecondaryPeerAddressPrefix
	}
	if ercppf.PrimaryAzurePort != nil {
		objectMap["primaryAzurePort"] = ercppf.PrimaryAzurePort
	}
	if ercppf.SecondaryAzurePort != nil {
		objectMap["secondaryAzurePort"] = ercppf.SecondaryAzurePort
	}
	if ercppf.SharedKey != nil {
		objectMap["sharedKey"] = ercppf.SharedKey
	}
	if ercppf.VlanID != nil {
		objectMap["vlanId"] = ercppf.VlanID
	}
	if ercppf.MicrosoftPeeringConfig != nil {
		objectMap["microsoftPeeringConfig"] = ercppf.MicrosoftPeeringConfig
	}
	if ercppf.Stats != nil {
		objectMap["stats"] = ercppf.Stats
	}
	if ercppf.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = ercppf.GatewayManagerEtag
	}
	if ercppf.RouteFilter != nil {
		objectMap["routeFilter"] = ercppf.RouteFilter
	}
	if ercppf.Ipv6PeeringConfig != nil {
		objectMap["ipv6PeeringConfig"] = ercppf.Ipv6PeeringConfig
	}
	if ercppf.ExpressRouteConnection != nil {
		objectMap["expressRouteConnection"] = ercppf.ExpressRouteConnection
	}
	if ercppf.Connections != nil {
		objectMap["connections"] = ercppf.Connections
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (ExpressRouteCircuitPeering, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitPeeringsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitPeeringsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCircuitPeeringsCreateOrUpdateFuture) result(client ExpressRouteCircuitPeeringsClient) (ercp ExpressRouteCircuitPeering, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercp.Response.Response, err = future.GetResult(sender); err == nil && ercp.Response.Response.StatusCode != http.StatusNoContent {
		ercp, err = client.CreateOrUpdateResponder(ercp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", ercp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitPeeringsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitPeeringsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitPeeringsDeleteFuture.Result.
func (future *ExpressRouteCircuitPeeringsDeleteFuture) result(client ExpressRouteCircuitPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// AllowClassicOperations - Allow classic operations.
	AllowClassicOperations *bool `json:"allowClassicOperations,omitempty"`
	// CircuitProvisioningState - The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - The ServiceProviderProvisioningState state of the resource. Possible values include: 'ServiceProviderProvisioningStateNotProvisioned', 'ServiceProviderProvisioningStateProvisioning', 'ServiceProviderProvisioningStateProvisioned', 'ServiceProviderProvisioningStateDeprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - The list of authorizations.
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - The ServiceKey.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - The ServiceProviderNotes.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ExpressRoutePort - The reference to the ExpressRoutePort resource when the circuit is provisioned on an ExpressRoutePort resource.
	ExpressRoutePort *SubResource `json:"expressRoutePort,omitempty"`
	// BandwidthInGbps - The bandwidth of the circuit when the circuit is provisioned on an ExpressRoutePort resource.
	BandwidthInGbps *float64 `json:"bandwidthInGbps,omitempty"`
	// Stag - READ-ONLY; The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
	Stag *int32 `json:"stag,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route circuit resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// GlobalReachEnabled - Flag denoting global reach status.
	GlobalReachEnabled *bool `json:"globalReachEnabled,omitempty"`
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPropertiesFormat.
func (ercpf ExpressRouteCircuitPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercpf.AllowClassicOperations != nil {
		objectMap["allowClassicOperations"] = ercpf.AllowClassicOperations
	}
	if ercpf.CircuitProvisioningState != nil {
		objectMap["circuitProvisioningState"] = ercpf.CircuitProvisioningState
	}
	if ercpf.ServiceProviderProvisioningState != "" {
		objectMap["serviceProviderProvisioningState"] = ercpf.ServiceProviderProvisioningState
	}
	if ercpf.Authorizations != nil {
		objectMap["authorizations"] = ercpf.Authorizations
	}
	if ercpf.Peerings != nil {
		objectMap["peerings"] = ercpf.Peerings
	}
	if ercpf.ServiceKey != nil {
		objectMap["serviceKey"] = ercpf.ServiceKey
	}
	if ercpf.ServiceProviderNotes != nil {
		objectMap["serviceProviderNotes"] = ercpf.ServiceProviderNotes
	}
	if ercpf.ServiceProviderProperties != nil {
		objectMap["serviceProviderProperties"] = ercpf.ServiceProviderProperties
	}
	if ercpf.ExpressRoutePort != nil {
		objectMap["expressRoutePort"] = ercpf.ExpressRoutePort
	}
	if ercpf.BandwidthInGbps != nil {
		objectMap["bandwidthInGbps"] = ercpf.BandwidthInGbps
	}
	if ercpf.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = ercpf.GatewayManagerEtag
	}
	if ercpf.GlobalReachEnabled != nil {
		objectMap["globalReachEnabled"] = ercpf.GlobalReachEnabled
	}
	if ercpf.AuthorizationKey != nil {
		objectMap["authorizationKey"] = ercpf.AuthorizationKey
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCircuitReference reference to an express route circuit.
type ExpressRouteCircuitReference struct {
	// ID - Corresponding Express Route Circuit Id.
	ID *string `json:"id,omitempty"`
}

// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTable struct {
	// NetworkProperty - IP address of a network entity.
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - NextHop address.
	NextHop *string `json:"nextHop,omitempty"`
	// LocPrf - Local preference value as set with the set local-preference route-map configuration command.
	LocPrf *string `json:"locPrf,omitempty"`
	// Weight - Route Weight.
	Weight *int32 `json:"weight,omitempty"`
	// Path - Autonomous system paths to the destination network.
	Path *string `json:"path,omitempty"`
}

// ExpressRouteCircuitRoutesTableSummary the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitRoutesTableSummary struct {
	// Neighbor - IP address of the neighbor.
	Neighbor *string `json:"neighbor,omitempty"`
	// V - BGP version number spoken to the neighbor.
	V *int32 `json:"v,omitempty"`
	// As - Autonomous system number.
	As *int32 `json:"as,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StatePfxRcd - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StatePfxRcd *string `json:"statePfxRcd,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the ARP tables.
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuit, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCircuitsCreateOrUpdateFuture) result(client ExpressRouteCircuitsClient) (erc ExpressRouteCircuit, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erc.Response.Response, err = future.GetResult(sender); err == nil && erc.Response.Response.StatusCode != http.StatusNoContent {
		erc, err = client.CreateOrUpdateResponder(erc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", erc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitsDeleteFuture.Result.
func (future *ExpressRouteCircuitsDeleteFuture) result(client ExpressRouteCircuitsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an
// ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - The serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - The peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - The BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium', 'ExpressRouteCircuitSkuTierBasic', 'ExpressRouteCircuitSkuTierLocal'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - The family of the SKU. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsListArpTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListArpTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsArpTableListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitsListArpTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitsListArpTableFuture.Result.
func (future *ExpressRouteCircuitsListArpTableFuture) result(client ExpressRouteCircuitsClient) (ercatlr ExpressRouteCircuitsArpTableListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercatlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListArpTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercatlr.Response.Response, err = future.GetResult(sender); err == nil && ercatlr.Response.Response.StatusCode != http.StatusNoContent {
		ercatlr, err = client.ListArpTableResponder(ercatlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListArpTableFuture", "Result", ercatlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitsListRoutesTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsListRoutesTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitsListRoutesTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitsListRoutesTableFuture.Result.
func (future *ExpressRouteCircuitsListRoutesTableFuture) result(client ExpressRouteCircuitsClient) (ercrtlr ExpressRouteCircuitsRoutesTableListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercrtlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListRoutesTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercrtlr.Response.Response, err = future.GetResult(sender); err == nil && ercrtlr.Response.Response.StatusCode != http.StatusNoContent {
		ercrtlr, err = client.ListRoutesTableResponder(ercrtlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableFuture", "Result", ercrtlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitsListRoutesTableSummaryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCircuitsClient) (ExpressRouteCircuitsRoutesTableSummaryListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCircuitsListRoutesTableSummaryFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCircuitsListRoutesTableSummaryFuture.Result.
func (future *ExpressRouteCircuitsListRoutesTableSummaryFuture) result(client ExpressRouteCircuitsClient) (ercrtslr ExpressRouteCircuitsRoutesTableSummaryListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercrtslr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsListRoutesTableSummaryFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercrtslr.Response.Response, err = future.GetResult(sender); err == nil && ercrtslr.Response.Response.StatusCode != http.StatusNoContent {
		ercrtslr, err = client.ListRoutesTableSummaryResponder(ercrtslr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsListRoutesTableSummaryFuture", "Result", ercrtslr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of routes table.
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableSummaryListResult response for ListRoutesTable associated with the
// Express Route Circuits API.
type ExpressRouteCircuitsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the routes table.
	Value *[]ExpressRouteCircuitRoutesTableSummary `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitStats contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	autorest.Response `json:"-"`
	// PrimarybytesIn - The Primary BytesIn of the peering.
	PrimarybytesIn *int64 `json:"primarybytesIn,omitempty"`
	// PrimarybytesOut - The primary BytesOut of the peering.
	PrimarybytesOut *int64 `json:"primarybytesOut,omitempty"`
	// SecondarybytesIn - The secondary BytesIn of the peering.
	SecondarybytesIn *int64 `json:"secondarybytesIn,omitempty"`
	// SecondarybytesOut - The secondary BytesOut of the peering.
	SecondarybytesOut *int64 `json:"secondarybytesOut,omitempty"`
}

// ExpressRouteConnection expressRouteConnection resource.
type ExpressRouteConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteConnectionProperties - Properties of the express route connection.
	*ExpressRouteConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteConnection.
func (erc ExpressRouteConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.ExpressRouteConnectionProperties != nil {
		objectMap["properties"] = erc.ExpressRouteConnectionProperties
	}
	if erc.Name != nil {
		objectMap["name"] = erc.Name
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteConnection struct.
func (erc *ExpressRouteConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteConnectionProperties ExpressRouteConnectionProperties
				err = json.Unmarshal(*v, &expressRouteConnectionProperties)
				if err != nil {
					return err
				}
				erc.ExpressRouteConnectionProperties = &expressRouteConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteConnectionID the ID of the ExpressRouteConnection.
type ExpressRouteConnectionID struct {
	// ID - READ-ONLY; The ID of the ExpressRouteConnection.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteConnectionID.
func (erci ExpressRouteConnectionID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExpressRouteConnectionList expressRouteConnection list.
type ExpressRouteConnectionList struct {
	autorest.Response `json:"-"`
	// Value - The list of ExpressRoute connections.
	Value *[]ExpressRouteConnection `json:"value,omitempty"`
}

// ExpressRouteConnectionProperties properties of the ExpressRouteConnection subresource.
type ExpressRouteConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the express route connection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ExpressRouteCircuitPeering - The ExpressRoute circuit peering.
	ExpressRouteCircuitPeering *ExpressRouteCircuitPeeringID `json:"expressRouteCircuitPeering,omitempty"`
	// AuthorizationKey - Authorization key to establish the connection.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// RoutingWeight - The routing weight associated to the connection.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// EnableInternetSecurity - Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`
	// ExpressRouteGatewayBypass - Enable FastPath to vWan Firewall hub.
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`
	// EnablePrivateLinkFastPath - Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
	EnablePrivateLinkFastPath *bool `json:"enablePrivateLinkFastPath,omitempty"`
	// RoutingConfiguration - The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteConnectionProperties.
func (ercp ExpressRouteConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeering != nil {
		objectMap["expressRouteCircuitPeering"] = ercp.ExpressRouteCircuitPeering
	}
	if ercp.AuthorizationKey != nil {
		objectMap["authorizationKey"] = ercp.AuthorizationKey
	}
	if ercp.RoutingWeight != nil {
		objectMap["routingWeight"] = ercp.RoutingWeight
	}
	if ercp.EnableInternetSecurity != nil {
		objectMap["enableInternetSecurity"] = ercp.EnableInternetSecurity
	}
	if ercp.ExpressRouteGatewayBypass != nil {
		objectMap["expressRouteGatewayBypass"] = ercp.ExpressRouteGatewayBypass
	}
	if ercp.EnablePrivateLinkFastPath != nil {
		objectMap["enablePrivateLinkFastPath"] = ercp.EnablePrivateLinkFastPath
	}
	if ercp.RoutingConfiguration != nil {
		objectMap["routingConfiguration"] = ercp.RoutingConfiguration
	}
	return json.Marshal(objectMap)
}

// ExpressRouteConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ExpressRouteConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteConnectionsClient) (ExpressRouteConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteConnectionsCreateOrUpdateFuture.Result.
func (future *ExpressRouteConnectionsCreateOrUpdateFuture) result(client ExpressRouteConnectionsClient) (erc ExpressRouteConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erc.Response.Response, err = future.GetResult(sender); err == nil && erc.Response.Response.StatusCode != http.StatusNoContent {
		erc, err = client.CreateOrUpdateResponder(erc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteConnectionsCreateOrUpdateFuture", "Result", erc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteConnectionsDeleteFuture.Result.
func (future *ExpressRouteConnectionsDeleteFuture) result(client ExpressRouteConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCrossConnection expressRouteCrossConnection resource.
type ExpressRouteCrossConnection struct {
	autorest.Response `json:"-"`
	// ExpressRouteCrossConnectionProperties - Properties of the express route cross connection.
	*ExpressRouteCrossConnectionProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnection.
func (ercc ExpressRouteCrossConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercc.ExpressRouteCrossConnectionProperties != nil {
		objectMap["properties"] = ercc.ExpressRouteCrossConnectionProperties
	}
	if ercc.ID != nil {
		objectMap["id"] = ercc.ID
	}
	if ercc.Location != nil {
		objectMap["location"] = ercc.Location
	}
	if ercc.Tags != nil {
		objectMap["tags"] = ercc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCrossConnection struct.
func (ercc *ExpressRouteCrossConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCrossConnectionProperties ExpressRouteCrossConnectionProperties
				err = json.Unmarshal(*v, &expressRouteCrossConnectionProperties)
				if err != nil {
					return err
				}
				ercc.ExpressRouteCrossConnectionProperties = &expressRouteCrossConnectionProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ercc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ercc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ercc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCrossConnectionListResult response for ListExpressRouteCrossConnection API service call.
type ExpressRouteCrossConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCrossConnection resources.
	Value *[]ExpressRouteCrossConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionListResult.
func (ercclr ExpressRouteCrossConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercclr.Value != nil {
		objectMap["value"] = ercclr.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionListResultIterator provides access to a complete listing of
// ExpressRouteCrossConnection values.
type ExpressRouteCrossConnectionListResultIterator struct {
	i    int
	page ExpressRouteCrossConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCrossConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCrossConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCrossConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCrossConnectionListResultIterator) Response() ExpressRouteCrossConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCrossConnectionListResultIterator) Value() ExpressRouteCrossConnection {
	if !iter.page.NotDone() {
		return ExpressRouteCrossConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCrossConnectionListResultIterator type.
func NewExpressRouteCrossConnectionListResultIterator(page ExpressRouteCrossConnectionListResultPage) ExpressRouteCrossConnectionListResultIterator {
	return ExpressRouteCrossConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercclr ExpressRouteCrossConnectionListResult) IsEmpty() bool {
	return ercclr.Value == nil || len(*ercclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ercclr ExpressRouteCrossConnectionListResult) hasNextLink() bool {
	return ercclr.NextLink != nil && len(*ercclr.NextLink) != 0
}

// expressRouteCrossConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercclr ExpressRouteCrossConnectionListResult) expressRouteCrossConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ercclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercclr.NextLink)))
}

// ExpressRouteCrossConnectionListResultPage contains a page of ExpressRouteCrossConnection values.
type ExpressRouteCrossConnectionListResultPage struct {
	fn     func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)
	ercclr ExpressRouteCrossConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCrossConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ercclr)
		if err != nil {
			return err
		}
		page.ercclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCrossConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCrossConnectionListResultPage) NotDone() bool {
	return !page.ercclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCrossConnectionListResultPage) Response() ExpressRouteCrossConnectionListResult {
	return page.ercclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCrossConnectionListResultPage) Values() []ExpressRouteCrossConnection {
	if page.ercclr.IsEmpty() {
		return nil
	}
	return *page.ercclr.Value
}

// Creates a new instance of the ExpressRouteCrossConnectionListResultPage type.
func NewExpressRouteCrossConnectionListResultPage(cur ExpressRouteCrossConnectionListResult, getNextPage func(context.Context, ExpressRouteCrossConnectionListResult) (ExpressRouteCrossConnectionListResult, error)) ExpressRouteCrossConnectionListResultPage {
	return ExpressRouteCrossConnectionListResultPage{
		fn:     getNextPage,
		ercclr: cur,
	}
}

// ExpressRouteCrossConnectionPeering peering in an ExpressRoute Cross Connection resource.
type ExpressRouteCrossConnectionPeering struct {
	autorest.Response `json:"-"`
	// ExpressRouteCrossConnectionPeeringProperties - Properties of the express route cross connection peering.
	*ExpressRouteCrossConnectionPeeringProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeering.
func (erccp ExpressRouteCrossConnectionPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccp.ExpressRouteCrossConnectionPeeringProperties != nil {
		objectMap["properties"] = erccp.ExpressRouteCrossConnectionPeeringProperties
	}
	if erccp.Name != nil {
		objectMap["name"] = erccp.Name
	}
	if erccp.ID != nil {
		objectMap["id"] = erccp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCrossConnectionPeering struct.
func (erccp *ExpressRouteCrossConnectionPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCrossConnectionPeeringProperties ExpressRouteCrossConnectionPeeringProperties
				err = json.Unmarshal(*v, &expressRouteCrossConnectionPeeringProperties)
				if err != nil {
					return err
				}
				erccp.ExpressRouteCrossConnectionPeeringProperties = &expressRouteCrossConnectionPeeringProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erccp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erccp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erccp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCrossConnectionPeeringList response for ListPeering API service call retrieves all peerings
// that belong to an ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionPeeringList struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route cross connection.
	Value *[]ExpressRouteCrossConnectionPeering `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeeringList.
func (erccpl ExpressRouteCrossConnectionPeeringList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpl.Value != nil {
		objectMap["value"] = erccpl.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionPeeringListIterator provides access to a complete listing of
// ExpressRouteCrossConnectionPeering values.
type ExpressRouteCrossConnectionPeeringListIterator struct {
	i    int
	page ExpressRouteCrossConnectionPeeringListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCrossConnectionPeeringListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionPeeringListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCrossConnectionPeeringListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCrossConnectionPeeringListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCrossConnectionPeeringListIterator) Response() ExpressRouteCrossConnectionPeeringList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCrossConnectionPeeringListIterator) Value() ExpressRouteCrossConnectionPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCrossConnectionPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCrossConnectionPeeringListIterator type.
func NewExpressRouteCrossConnectionPeeringListIterator(page ExpressRouteCrossConnectionPeeringListPage) ExpressRouteCrossConnectionPeeringListIterator {
	return ExpressRouteCrossConnectionPeeringListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erccpl ExpressRouteCrossConnectionPeeringList) IsEmpty() bool {
	return erccpl.Value == nil || len(*erccpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erccpl ExpressRouteCrossConnectionPeeringList) hasNextLink() bool {
	return erccpl.NextLink != nil && len(*erccpl.NextLink) != 0
}

// expressRouteCrossConnectionPeeringListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erccpl ExpressRouteCrossConnectionPeeringList) expressRouteCrossConnectionPeeringListPreparer(ctx context.Context) (*http.Request, error) {
	if !erccpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erccpl.NextLink)))
}

// ExpressRouteCrossConnectionPeeringListPage contains a page of ExpressRouteCrossConnectionPeering values.
type ExpressRouteCrossConnectionPeeringListPage struct {
	fn     func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)
	erccpl ExpressRouteCrossConnectionPeeringList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCrossConnectionPeeringListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCrossConnectionPeeringListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erccpl)
		if err != nil {
			return err
		}
		page.erccpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCrossConnectionPeeringListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCrossConnectionPeeringListPage) NotDone() bool {
	return !page.erccpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCrossConnectionPeeringListPage) Response() ExpressRouteCrossConnectionPeeringList {
	return page.erccpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCrossConnectionPeeringListPage) Values() []ExpressRouteCrossConnectionPeering {
	if page.erccpl.IsEmpty() {
		return nil
	}
	return *page.erccpl.Value
}

// Creates a new instance of the ExpressRouteCrossConnectionPeeringListPage type.
func NewExpressRouteCrossConnectionPeeringListPage(cur ExpressRouteCrossConnectionPeeringList, getNextPage func(context.Context, ExpressRouteCrossConnectionPeeringList) (ExpressRouteCrossConnectionPeeringList, error)) ExpressRouteCrossConnectionPeeringListPage {
	return ExpressRouteCrossConnectionPeeringListPage{
		fn:     getNextPage,
		erccpl: cur,
	}
}

// ExpressRouteCrossConnectionPeeringProperties properties of express route cross connection peering.
type ExpressRouteCrossConnectionPeeringProperties struct {
	// PeeringType - The peering type. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRoutePeeringType `json:"peeringType,omitempty"`
	// State - The peering state. Possible values include: 'ExpressRoutePeeringStateDisabled', 'ExpressRoutePeeringStateEnabled'
	State ExpressRoutePeeringState `json:"state,omitempty"`
	// AzureASN - READ-ONLY; The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int64 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - READ-ONLY; The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - READ-ONLY; The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route cross connection peering resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// GatewayManagerEtag - The GatewayManager Etag.
	GatewayManagerEtag *string `json:"gatewayManagerEtag,omitempty"`
	// LastModifiedBy - READ-ONLY; Who was the last to modify the peering.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// Ipv6PeeringConfig - The IPv6 peering configuration.
	Ipv6PeeringConfig *Ipv6ExpressRouteCircuitPeeringConfig `json:"ipv6PeeringConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionPeeringProperties.
func (erccpp ExpressRouteCrossConnectionPeeringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccpp.PeeringType != "" {
		objectMap["peeringType"] = erccpp.PeeringType
	}
	if erccpp.State != "" {
		objectMap["state"] = erccpp.State
	}
	if erccpp.PeerASN != nil {
		objectMap["peerASN"] = erccpp.PeerASN
	}
	if erccpp.PrimaryPeerAddressPrefix != nil {
		objectMap["primaryPeerAddressPrefix"] = erccpp.PrimaryPeerAddressPrefix
	}
	if erccpp.SecondaryPeerAddressPrefix != nil {
		objectMap["secondaryPeerAddressPrefix"] = erccpp.SecondaryPeerAddressPrefix
	}
	if erccpp.SharedKey != nil {
		objectMap["sharedKey"] = erccpp.SharedKey
	}
	if erccpp.VlanID != nil {
		objectMap["vlanId"] = erccpp.VlanID
	}
	if erccpp.MicrosoftPeeringConfig != nil {
		objectMap["microsoftPeeringConfig"] = erccpp.MicrosoftPeeringConfig
	}
	if erccpp.GatewayManagerEtag != nil {
		objectMap["gatewayManagerEtag"] = erccpp.GatewayManagerEtag
	}
	if erccpp.Ipv6PeeringConfig != nil {
		objectMap["ipv6PeeringConfig"] = erccpp.Ipv6PeeringConfig
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionPeeringsClient) (ExpressRouteCrossConnectionPeering, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture) result(client ExpressRouteCrossConnectionPeeringsClient) (erccp ExpressRouteCrossConnectionPeering, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erccp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erccp.Response.Response, err = future.GetResult(sender); err == nil && erccp.Response.Response.StatusCode != http.StatusNoContent {
		erccp, err = client.CreateOrUpdateResponder(erccp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionPeeringsCreateOrUpdateFuture", "Result", erccp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCrossConnectionPeeringsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCrossConnectionPeeringsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionPeeringsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionPeeringsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionPeeringsDeleteFuture.Result.
func (future *ExpressRouteCrossConnectionPeeringsDeleteFuture) result(client ExpressRouteCrossConnectionPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionPeeringsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCrossConnectionProperties properties of ExpressRouteCrossConnection.
type ExpressRouteCrossConnectionProperties struct {
	// PrimaryAzurePort - READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// STag - READ-ONLY; The identifier of the circuit traffic.
	STag *int32 `json:"sTag,omitempty"`
	// PeeringLocation - READ-ONLY; The peering location of the ExpressRoute circuit.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - READ-ONLY; The circuit bandwidth In Mbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// ExpressRouteCircuit - The ExpressRouteCircuit.
	ExpressRouteCircuit *ExpressRouteCircuitReference `json:"expressRouteCircuit,omitempty"`
	// ServiceProviderProvisioningState - The provisioning state of the circuit in the connectivity provider system. Possible values include: 'ServiceProviderProvisioningStateNotProvisioned', 'ServiceProviderProvisioningStateProvisioning', 'ServiceProviderProvisioningStateProvisioned', 'ServiceProviderProvisioningStateDeprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// ServiceProviderNotes - Additional read only notes set by the connectivity provider.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route cross connection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCrossConnectionPeering `json:"peerings,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionProperties.
func (erccp ExpressRouteCrossConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccp.ExpressRouteCircuit != nil {
		objectMap["expressRouteCircuit"] = erccp.ExpressRouteCircuit
	}
	if erccp.ServiceProviderProvisioningState != "" {
		objectMap["serviceProviderProvisioningState"] = erccp.ServiceProviderProvisioningState
	}
	if erccp.ServiceProviderNotes != nil {
		objectMap["serviceProviderNotes"] = erccp.ServiceProviderNotes
	}
	if erccp.Peerings != nil {
		objectMap["peerings"] = erccp.Peerings
	}
	return json.Marshal(objectMap)
}

// ExpressRouteCrossConnectionRoutesTableSummary the routes table associated with the ExpressRouteCircuit.
type ExpressRouteCrossConnectionRoutesTableSummary struct {
	// Neighbor - IP address of Neighbor router.
	Neighbor *string `json:"neighbor,omitempty"`
	// Asn - Autonomous system number.
	Asn *int32 `json:"asn,omitempty"`
	// UpDown - The length of time that the BGP session has been in the Established state, or the current status if not in the Established state.
	UpDown *string `json:"upDown,omitempty"`
	// StateOrPrefixesReceived - Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer group.
	StateOrPrefixesReceived *string `json:"stateOrPrefixesReceived,omitempty"`
}

// ExpressRouteCrossConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCrossConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionsCreateOrUpdateFuture.Result.
func (future *ExpressRouteCrossConnectionsCreateOrUpdateFuture) result(client ExpressRouteCrossConnectionsClient) (ercc ExpressRouteCrossConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercc.Response.Response, err = future.GetResult(sender); err == nil && ercc.Response.Response.StatusCode != http.StatusNoContent {
		ercc, err = client.CreateOrUpdateResponder(ercc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsCreateOrUpdateFuture", "Result", ercc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCrossConnectionsListArpTableFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCrossConnectionsListArpTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCircuitsArpTableListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionsListArpTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionsListArpTableFuture.Result.
func (future *ExpressRouteCrossConnectionsListArpTableFuture) result(client ExpressRouteCrossConnectionsClient) (ercatlr ExpressRouteCircuitsArpTableListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListArpTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercatlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionsListArpTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercatlr.Response.Response, err = future.GetResult(sender); err == nil && ercatlr.Response.Response.StatusCode != http.StatusNoContent {
		ercatlr, err = client.ListArpTableResponder(ercatlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListArpTableFuture", "Result", ercatlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCrossConnectionsListRoutesTableFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCrossConnectionsListRoutesTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCircuitsRoutesTableListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionsListRoutesTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionsListRoutesTableFuture.Result.
func (future *ExpressRouteCrossConnectionsListRoutesTableFuture) result(client ExpressRouteCrossConnectionsClient) (ercrtlr ExpressRouteCircuitsRoutesTableListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListRoutesTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ercrtlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionsListRoutesTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercrtlr.Response.Response, err = future.GetResult(sender); err == nil && ercrtlr.Response.Response.StatusCode != http.StatusNoContent {
		ercrtlr, err = client.ListRoutesTableResponder(ercrtlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListRoutesTableFuture", "Result", ercrtlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCrossConnectionsListRoutesTableSummaryFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ExpressRouteCrossConnectionsListRoutesTableSummaryFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteCrossConnectionsClient) (ExpressRouteCrossConnectionsRoutesTableSummaryListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteCrossConnectionsListRoutesTableSummaryFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteCrossConnectionsListRoutesTableSummaryFuture.Result.
func (future *ExpressRouteCrossConnectionsListRoutesTableSummaryFuture) result(client ExpressRouteCrossConnectionsClient) (erccrtslr ExpressRouteCrossConnectionsRoutesTableSummaryListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erccrtslr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erccrtslr.Response.Response, err = future.GetResult(sender); err == nil && erccrtslr.Response.Response.StatusCode != http.StatusNoContent {
		erccrtslr, err = client.ListRoutesTableSummaryResponder(erccrtslr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCrossConnectionsListRoutesTableSummaryFuture", "Result", erccrtslr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCrossConnectionsRoutesTableSummaryListResult response for ListRoutesTable associated with
// the Express Route Cross Connections.
type ExpressRouteCrossConnectionsRoutesTableSummaryListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of the routes table.
	Value *[]ExpressRouteCrossConnectionRoutesTableSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCrossConnectionsRoutesTableSummaryListResult.
func (erccrtslr ExpressRouteCrossConnectionsRoutesTableSummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erccrtslr.Value != nil {
		objectMap["value"] = erccrtslr.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteGateway expressRoute gateway resource.
type ExpressRouteGateway struct {
	autorest.Response `json:"-"`
	// ExpressRouteGatewayProperties - Properties of the express route gateway.
	*ExpressRouteGatewayProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteGateway.
func (erg ExpressRouteGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erg.ExpressRouteGatewayProperties != nil {
		objectMap["properties"] = erg.ExpressRouteGatewayProperties
	}
	if erg.ID != nil {
		objectMap["id"] = erg.ID
	}
	if erg.Location != nil {
		objectMap["location"] = erg.Location
	}
	if erg.Tags != nil {
		objectMap["tags"] = erg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteGateway struct.
func (erg *ExpressRouteGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteGatewayProperties ExpressRouteGatewayProperties
				err = json.Unmarshal(*v, &expressRouteGatewayProperties)
				if err != nil {
					return err
				}
				erg.ExpressRouteGatewayProperties = &expressRouteGatewayProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erg.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteGatewayList list of ExpressRoute gateways.
type ExpressRouteGatewayList struct {
	autorest.Response `json:"-"`
	// Value - List of ExpressRoute gateways.
	Value *[]ExpressRouteGateway `json:"value,omitempty"`
}

// ExpressRouteGatewayProperties expressRoute gateway resource properties.
type ExpressRouteGatewayProperties struct {
	// AutoScaleConfiguration - Configuration for auto scaling.
	AutoScaleConfiguration *ExpressRouteGatewayPropertiesAutoScaleConfiguration `json:"autoScaleConfiguration,omitempty"`
	// ExpressRouteConnections - List of ExpressRoute connections to the ExpressRoute gateway.
	ExpressRouteConnections *[]ExpressRouteConnection `json:"expressRouteConnections,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route gateway resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VirtualHub - The Virtual Hub where the ExpressRoute gateway is or will be deployed.
	VirtualHub *VirtualHubID `json:"virtualHub,omitempty"`
	// AllowNonVirtualWanTraffic - Configures this gateway to accept traffic from non Virtual WAN networks.
	AllowNonVirtualWanTraffic *bool `json:"allowNonVirtualWanTraffic,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteGatewayProperties.
func (ergp ExpressRouteGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ergp.AutoScaleConfiguration != nil {
		objectMap["autoScaleConfiguration"] = ergp.AutoScaleConfiguration
	}
	if ergp.ExpressRouteConnections != nil {
		objectMap["expressRouteConnections"] = ergp.ExpressRouteConnections
	}
	if ergp.VirtualHub != nil {
		objectMap["virtualHub"] = ergp.VirtualHub
	}
	if ergp.AllowNonVirtualWanTraffic != nil {
		objectMap["allowNonVirtualWanTraffic"] = ergp.AllowNonVirtualWanTraffic
	}
	return json.Marshal(objectMap)
}

// ExpressRouteGatewayPropertiesAutoScaleConfiguration configuration for auto scaling.
type ExpressRouteGatewayPropertiesAutoScaleConfiguration struct {
	// Bounds - Minimum and maximum number of scale units to deploy.
	Bounds *ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds `json:"bounds,omitempty"`
}

// ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds minimum and maximum number of scale units to
// deploy.
type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds struct {
	// Min - Minimum number of scale units deployed for ExpressRoute gateway.
	Min *int32 `json:"min,omitempty"`
	// Max - Maximum number of scale units deployed for ExpressRoute gateway.
	Max *int32 `json:"max,omitempty"`
}

// ExpressRouteGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteGatewaysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteGatewaysClient) (ExpressRouteGateway, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteGatewaysCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteGatewaysCreateOrUpdateFuture.Result.
func (future *ExpressRouteGatewaysCreateOrUpdateFuture) result(client ExpressRouteGatewaysClient) (erg ExpressRouteGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteGatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erg.Response.Response, err = future.GetResult(sender); err == nil && erg.Response.Response.StatusCode != http.StatusNoContent {
		erg, err = client.CreateOrUpdateResponder(erg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteGatewaysCreateOrUpdateFuture", "Result", erg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteGatewaysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteGatewaysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteGatewaysDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteGatewaysDeleteFuture.Result.
func (future *ExpressRouteGatewaysDeleteFuture) result(client ExpressRouteGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteGatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteGatewaysUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteGatewaysUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRouteGatewaysClient) (ExpressRouteGateway, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRouteGatewaysUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRouteGatewaysUpdateTagsFuture.Result.
func (future *ExpressRouteGatewaysUpdateTagsFuture) result(client ExpressRouteGatewaysClient) (erg ExpressRouteGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteGatewaysUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteGatewaysUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erg.Response.Response, err = future.GetResult(sender); err == nil && erg.Response.Response.StatusCode != http.StatusNoContent {
		erg, err = client.UpdateTagsResponder(erg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteGatewaysUpdateTagsFuture", "Result", erg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteLink expressRouteLink child resource definition.
type ExpressRouteLink struct {
	autorest.Response `json:"-"`
	// ExpressRouteLinkPropertiesFormat - ExpressRouteLink properties.
	*ExpressRouteLinkPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of child port resource that is unique among child port resources of the parent.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteLink.
func (erl ExpressRouteLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erl.ExpressRouteLinkPropertiesFormat != nil {
		objectMap["properties"] = erl.ExpressRouteLinkPropertiesFormat
	}
	if erl.Name != nil {
		objectMap["name"] = erl.Name
	}
	if erl.ID != nil {
		objectMap["id"] = erl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteLink struct.
func (erl *ExpressRouteLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteLinkPropertiesFormat ExpressRouteLinkPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteLinkPropertiesFormat)
				if err != nil {
					return err
				}
				erl.ExpressRouteLinkPropertiesFormat = &expressRouteLinkPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erl.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteLinkListResult response for ListExpressRouteLinks API service call.
type ExpressRouteLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of ExpressRouteLink sub-resources.
	Value *[]ExpressRouteLink `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteLinkListResultIterator provides access to a complete listing of ExpressRouteLink values.
type ExpressRouteLinkListResultIterator struct {
	i    int
	page ExpressRouteLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteLinkListResultIterator) Response() ExpressRouteLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteLinkListResultIterator) Value() ExpressRouteLink {
	if !iter.page.NotDone() {
		return ExpressRouteLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteLinkListResultIterator type.
func NewExpressRouteLinkListResultIterator(page ExpressRouteLinkListResultPage) ExpressRouteLinkListResultIterator {
	return ExpressRouteLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erllr ExpressRouteLinkListResult) IsEmpty() bool {
	return erllr.Value == nil || len(*erllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erllr ExpressRouteLinkListResult) hasNextLink() bool {
	return erllr.NextLink != nil && len(*erllr.NextLink) != 0
}

// expressRouteLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erllr ExpressRouteLinkListResult) expressRouteLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erllr.NextLink)))
}

// ExpressRouteLinkListResultPage contains a page of ExpressRouteLink values.
type ExpressRouteLinkListResultPage struct {
	fn    func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)
	erllr ExpressRouteLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erllr)
		if err != nil {
			return err
		}
		page.erllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteLinkListResultPage) NotDone() bool {
	return !page.erllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteLinkListResultPage) Response() ExpressRouteLinkListResult {
	return page.erllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteLinkListResultPage) Values() []ExpressRouteLink {
	if page.erllr.IsEmpty() {
		return nil
	}
	return *page.erllr.Value
}

// Creates a new instance of the ExpressRouteLinkListResultPage type.
func NewExpressRouteLinkListResultPage(cur ExpressRouteLinkListResult, getNextPage func(context.Context, ExpressRouteLinkListResult) (ExpressRouteLinkListResult, error)) ExpressRouteLinkListResultPage {
	return ExpressRouteLinkListResultPage{
		fn:    getNextPage,
		erllr: cur,
	}
}

// ExpressRouteLinkMacSecConfig expressRouteLink Mac Security Configuration.
type ExpressRouteLinkMacSecConfig struct {
	// CknSecretIdentifier - Keyvault Secret Identifier URL containing Mac security CKN key.
	CknSecretIdentifier *string `json:"cknSecretIdentifier,omitempty"`
	// CakSecretIdentifier - Keyvault Secret Identifier URL containing Mac security CAK key.
	CakSecretIdentifier *string `json:"cakSecretIdentifier,omitempty"`
	// Cipher - Mac security cipher. Possible values include: 'GcmAes256', 'GcmAes128', 'GcmAesXpn128', 'GcmAesXpn256'
	Cipher ExpressRouteLinkMacSecCipher `json:"cipher,omitempty"`
	// SciState - Sci mode enabled/disabled. Possible values include: 'ExpressRouteLinkMacSecSciStateDisabled', 'ExpressRouteLinkMacSecSciStateEnabled'
	SciState ExpressRouteLinkMacSecSciState `json:"sciState,omitempty"`
}

// ExpressRouteLinkPropertiesFormat properties specific to ExpressRouteLink resources.
type ExpressRouteLinkPropertiesFormat struct {
	// RouterName - READ-ONLY; Name of Azure router associated with physical port.
	RouterName *string `json:"routerName,omitempty"`
	// InterfaceName - READ-ONLY; Name of Azure router interface.
	InterfaceName *string `json:"interfaceName,omitempty"`
	// PatchPanelID - READ-ONLY; Mapping between physical port to patch panel port.
	PatchPanelID *string `json:"patchPanelId,omitempty"`
	// RackID - READ-ONLY; Mapping of physical patch panel to rack.
	RackID *string `json:"rackId,omitempty"`
	// ColoLocation - READ-ONLY; Cololocation for ExpressRoute Hybrid Direct.
	ColoLocation *string `json:"coloLocation,omitempty"`
	// ConnectorType - READ-ONLY; Physical fiber port type. Possible values include: 'LC', 'SC'
	ConnectorType ExpressRouteLinkConnectorType `json:"connectorType,omitempty"`
	// AdminState - Administrative state of the physical port. Possible values include: 'ExpressRouteLinkAdminStateEnabled', 'ExpressRouteLinkAdminStateDisabled'
	AdminState ExpressRouteLinkAdminState `json:"adminState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route link resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// MacSecConfig - MacSec configuration.
	MacSecConfig *ExpressRouteLinkMacSecConfig `json:"macSecConfig,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteLinkPropertiesFormat.
func (erlpf ExpressRouteLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erlpf.AdminState != "" {
		objectMap["adminState"] = erlpf.AdminState
	}
	if erlpf.MacSecConfig != nil {
		objectMap["macSecConfig"] = erlpf.MacSecConfig
	}
	return json.Marshal(objectMap)
}

// ExpressRoutePort expressRoutePort resource definition.
type ExpressRoutePort struct {
	autorest.Response `json:"-"`
	// ExpressRoutePortPropertiesFormat - ExpressRoutePort properties.
	*ExpressRoutePortPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Identity - The identity of ExpressRoutePort, if configured.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePort.
func (erp ExpressRoutePort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erp.ExpressRoutePortPropertiesFormat != nil {
		objectMap["properties"] = erp.ExpressRoutePortPropertiesFormat
	}
	if erp.Identity != nil {
		objectMap["identity"] = erp.Identity
	}
	if erp.ID != nil {
		objectMap["id"] = erp.ID
	}
	if erp.Location != nil {
		objectMap["location"] = erp.Location
	}
	if erp.Tags != nil {
		objectMap["tags"] = erp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRoutePort struct.
func (erp *ExpressRoutePort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRoutePortPropertiesFormat ExpressRoutePortPropertiesFormat
				err = json.Unmarshal(*v, &expressRoutePortPropertiesFormat)
				if err != nil {
					return err
				}
				erp.ExpressRoutePortPropertiesFormat = &expressRoutePortPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erp.Etag = &etag
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				erp.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRoutePortAuthorization expressRoutePort Authorization resource definition.
type ExpressRoutePortAuthorization struct {
	autorest.Response `json:"-"`
	// ExpressRoutePortAuthorizationPropertiesFormat - ExpressRoutePort properties.
	*ExpressRoutePortAuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortAuthorization.
func (erpa ExpressRoutePortAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erpa.ExpressRoutePortAuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erpa.ExpressRoutePortAuthorizationPropertiesFormat
	}
	if erpa.Name != nil {
		objectMap["name"] = erpa.Name
	}
	if erpa.ID != nil {
		objectMap["id"] = erpa.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRoutePortAuthorization struct.
func (erpa *ExpressRoutePortAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRoutePortAuthorizationPropertiesFormat ExpressRoutePortAuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &expressRoutePortAuthorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erpa.ExpressRoutePortAuthorizationPropertiesFormat = &expressRoutePortAuthorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erpa.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erpa.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erpa.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erpa.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRoutePortAuthorizationListResult response for ListExpressRoutePortAuthorizations API service
// call.
type ExpressRoutePortAuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - The authorizations in an ExpressRoute Port.
	Value *[]ExpressRoutePortAuthorization `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRoutePortAuthorizationListResultIterator provides access to a complete listing of
// ExpressRoutePortAuthorization values.
type ExpressRoutePortAuthorizationListResultIterator struct {
	i    int
	page ExpressRoutePortAuthorizationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRoutePortAuthorizationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortAuthorizationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRoutePortAuthorizationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRoutePortAuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRoutePortAuthorizationListResultIterator) Response() ExpressRoutePortAuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRoutePortAuthorizationListResultIterator) Value() ExpressRoutePortAuthorization {
	if !iter.page.NotDone() {
		return ExpressRoutePortAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRoutePortAuthorizationListResultIterator type.
func NewExpressRoutePortAuthorizationListResultIterator(page ExpressRoutePortAuthorizationListResultPage) ExpressRoutePortAuthorizationListResultIterator {
	return ExpressRoutePortAuthorizationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erpalr ExpressRoutePortAuthorizationListResult) IsEmpty() bool {
	return erpalr.Value == nil || len(*erpalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erpalr ExpressRoutePortAuthorizationListResult) hasNextLink() bool {
	return erpalr.NextLink != nil && len(*erpalr.NextLink) != 0
}

// expressRoutePortAuthorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erpalr ExpressRoutePortAuthorizationListResult) expressRoutePortAuthorizationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erpalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erpalr.NextLink)))
}

// ExpressRoutePortAuthorizationListResultPage contains a page of ExpressRoutePortAuthorization values.
type ExpressRoutePortAuthorizationListResultPage struct {
	fn     func(context.Context, ExpressRoutePortAuthorizationListResult) (ExpressRoutePortAuthorizationListResult, error)
	erpalr ExpressRoutePortAuthorizationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRoutePortAuthorizationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortAuthorizationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erpalr)
		if err != nil {
			return err
		}
		page.erpalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRoutePortAuthorizationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRoutePortAuthorizationListResultPage) NotDone() bool {
	return !page.erpalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRoutePortAuthorizationListResultPage) Response() ExpressRoutePortAuthorizationListResult {
	return page.erpalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRoutePortAuthorizationListResultPage) Values() []ExpressRoutePortAuthorization {
	if page.erpalr.IsEmpty() {
		return nil
	}
	return *page.erpalr.Value
}

// Creates a new instance of the ExpressRoutePortAuthorizationListResultPage type.
func NewExpressRoutePortAuthorizationListResultPage(cur ExpressRoutePortAuthorizationListResult, getNextPage func(context.Context, ExpressRoutePortAuthorizationListResult) (ExpressRoutePortAuthorizationListResult, error)) ExpressRoutePortAuthorizationListResultPage {
	return ExpressRoutePortAuthorizationListResultPage{
		fn:     getNextPage,
		erpalr: cur,
	}
}

// ExpressRoutePortAuthorizationPropertiesFormat properties of ExpressRoutePort Authorization.
type ExpressRoutePortAuthorizationPropertiesFormat struct {
	// AuthorizationKey - READ-ONLY; The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - READ-ONLY; The authorization use status. Possible values include: 'ExpressRoutePortAuthorizationUseStatusAvailable', 'ExpressRoutePortAuthorizationUseStatusInUse'
	AuthorizationUseStatus ExpressRoutePortAuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// CircuitResourceURI - READ-ONLY; The reference to the ExpressRoute circuit resource using the authorization.
	CircuitResourceURI *string `json:"circuitResourceUri,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the authorization resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortAuthorizationPropertiesFormat.
func (erpapf ExpressRoutePortAuthorizationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExpressRoutePortAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRoutePortAuthorizationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortAuthorizationsClient) (ExpressRoutePortAuthorization, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRoutePortAuthorizationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRoutePortAuthorizationsCreateOrUpdateFuture.Result.
func (future *ExpressRoutePortAuthorizationsCreateOrUpdateFuture) result(client ExpressRoutePortAuthorizationsClient) (erpa ExpressRoutePortAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRoutePortAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erpa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRoutePortAuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erpa.Response.Response, err = future.GetResult(sender); err == nil && erpa.Response.Response.StatusCode != http.StatusNoContent {
		erpa, err = client.CreateOrUpdateResponder(erpa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRoutePortAuthorizationsCreateOrUpdateFuture", "Result", erpa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRoutePortAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRoutePortAuthorizationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortAuthorizationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRoutePortAuthorizationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRoutePortAuthorizationsDeleteFuture.Result.
func (future *ExpressRoutePortAuthorizationsDeleteFuture) result(client ExpressRoutePortAuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRoutePortAuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRoutePortAuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRoutePortListResult response for ListExpressRoutePorts API service call.
type ExpressRoutePortListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRoutePort resources.
	Value *[]ExpressRoutePort `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRoutePortListResultIterator provides access to a complete listing of ExpressRoutePort values.
type ExpressRoutePortListResultIterator struct {
	i    int
	page ExpressRoutePortListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRoutePortListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRoutePortListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRoutePortListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRoutePortListResultIterator) Response() ExpressRoutePortListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRoutePortListResultIterator) Value() ExpressRoutePort {
	if !iter.page.NotDone() {
		return ExpressRoutePort{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRoutePortListResultIterator type.
func NewExpressRoutePortListResultIterator(page ExpressRoutePortListResultPage) ExpressRoutePortListResultIterator {
	return ExpressRoutePortListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erplr ExpressRoutePortListResult) IsEmpty() bool {
	return erplr.Value == nil || len(*erplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erplr ExpressRoutePortListResult) hasNextLink() bool {
	return erplr.NextLink != nil && len(*erplr.NextLink) != 0
}

// expressRoutePortListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erplr ExpressRoutePortListResult) expressRoutePortListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erplr.NextLink)))
}

// ExpressRoutePortListResultPage contains a page of ExpressRoutePort values.
type ExpressRoutePortListResultPage struct {
	fn    func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)
	erplr ExpressRoutePortListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRoutePortListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erplr)
		if err != nil {
			return err
		}
		page.erplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRoutePortListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRoutePortListResultPage) NotDone() bool {
	return !page.erplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRoutePortListResultPage) Response() ExpressRoutePortListResult {
	return page.erplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRoutePortListResultPage) Values() []ExpressRoutePort {
	if page.erplr.IsEmpty() {
		return nil
	}
	return *page.erplr.Value
}

// Creates a new instance of the ExpressRoutePortListResultPage type.
func NewExpressRoutePortListResultPage(cur ExpressRoutePortListResult, getNextPage func(context.Context, ExpressRoutePortListResult) (ExpressRoutePortListResult, error)) ExpressRoutePortListResultPage {
	return ExpressRoutePortListResultPage{
		fn:    getNextPage,
		erplr: cur,
	}
}

// ExpressRoutePortPropertiesFormat properties specific to ExpressRoutePort resources.
type ExpressRoutePortPropertiesFormat struct {
	// PeeringLocation - The name of the peering location that the ExpressRoutePort is mapped to physically.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInGbps - Bandwidth of procured ports in Gbps.
	BandwidthInGbps *int32 `json:"bandwidthInGbps,omitempty"`
	// ProvisionedBandwidthInGbps - READ-ONLY; Aggregate Gbps of associated circuit bandwidths.
	ProvisionedBandwidthInGbps *float64 `json:"provisionedBandwidthInGbps,omitempty"`
	// Mtu - READ-ONLY; Maximum transmission unit of the physical port pair(s).
	Mtu *string `json:"mtu,omitempty"`
	// Encapsulation - Encapsulation method on physical ports. Possible values include: 'Dot1Q', 'QinQ'
	Encapsulation ExpressRoutePortsEncapsulation `json:"encapsulation,omitempty"`
	// EtherType - READ-ONLY; Ether type of the physical port.
	EtherType *string `json:"etherType,omitempty"`
	// AllocationDate - READ-ONLY; Date of the physical port allocation to be used in Letter of Authorization.
	AllocationDate *string `json:"allocationDate,omitempty"`
	// Links - The set of physical links of the ExpressRoutePort resource.
	Links *[]ExpressRouteLink `json:"links,omitempty"`
	// Circuits - READ-ONLY; Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
	Circuits *[]SubResource `json:"circuits,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route port resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the express route port resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// BillingType - The billing type of the ExpressRoutePort resource. Possible values include: 'ExpressRoutePortsBillingTypeMeteredData', 'ExpressRoutePortsBillingTypeUnlimitedData'
	BillingType ExpressRoutePortsBillingType `json:"billingType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortPropertiesFormat.
func (erppf ExpressRoutePortPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erppf.PeeringLocation != nil {
		objectMap["peeringLocation"] = erppf.PeeringLocation
	}
	if erppf.BandwidthInGbps != nil {
		objectMap["bandwidthInGbps"] = erppf.BandwidthInGbps
	}
	if erppf.Encapsulation != "" {
		objectMap["encapsulation"] = erppf.Encapsulation
	}
	if erppf.Links != nil {
		objectMap["links"] = erppf.Links
	}
	if erppf.BillingType != "" {
		objectMap["billingType"] = erppf.BillingType
	}
	return json.Marshal(objectMap)
}

// ExpressRoutePortsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRoutePortsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortsClient) (ExpressRoutePort, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRoutePortsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRoutePortsCreateOrUpdateFuture.Result.
func (future *ExpressRoutePortsCreateOrUpdateFuture) result(client ExpressRoutePortsClient) (erp ExpressRoutePort, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRoutePortsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRoutePortsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erp.Response.Response, err = future.GetResult(sender); err == nil && erp.Response.Response.StatusCode != http.StatusNoContent {
		erp, err = client.CreateOrUpdateResponder(erp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRoutePortsCreateOrUpdateFuture", "Result", erp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRoutePortsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExpressRoutePortsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExpressRoutePortsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExpressRoutePortsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExpressRoutePortsDeleteFuture.Result.
func (future *ExpressRoutePortsDeleteFuture) result(client ExpressRoutePortsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRoutePortsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.ExpressRoutePortsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRoutePortsLocation definition of the ExpressRoutePorts peering location resource.
type ExpressRoutePortsLocation struct {
	autorest.Response `json:"-"`
	// ExpressRoutePortsLocationPropertiesFormat - ExpressRoutePort peering location properties.
	*ExpressRoutePortsLocationPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortsLocation.
func (erpl ExpressRoutePortsLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erpl.ExpressRoutePortsLocationPropertiesFormat != nil {
		objectMap["properties"] = erpl.ExpressRoutePortsLocationPropertiesFormat
	}
	if erpl.ID != nil {
		objectMap["id"] = erpl.ID
	}
	if erpl.Location != nil {
		objectMap["location"] = erpl.Location
	}
	if erpl.Tags != nil {
		objectMap["tags"] = erpl.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRoutePortsLocation struct.
func (erpl *ExpressRoutePortsLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRoutePortsLocationPropertiesFormat ExpressRoutePortsLocationPropertiesFormat
				err = json.Unmarshal(*v, &expressRoutePortsLocationPropertiesFormat)
				if err != nil {
					return err
				}
				erpl.ExpressRoutePortsLocationPropertiesFormat = &expressRoutePortsLocationPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erpl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erpl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erpl.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erpl.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erpl.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRoutePortsLocationBandwidths real-time inventory of available ExpressRoute port bandwidths.
type ExpressRoutePortsLocationBandwidths struct {
	// OfferName - READ-ONLY; Bandwidth descriptive name.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInGbps - READ-ONLY; Bandwidth value in Gbps.
	ValueInGbps *int32 `json:"valueInGbps,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortsLocationBandwidths.
func (erplb ExpressRoutePortsLocationBandwidths) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExpressRoutePortsLocationListResult response for ListExpressRoutePortsLocations API service call.
type ExpressRoutePortsLocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of all ExpressRoutePort peering locations.
	Value *[]ExpressRoutePortsLocation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRoutePortsLocationListResultIterator provides access to a complete listing of
// ExpressRoutePortsLocation values.
type ExpressRoutePortsLocationListResultIterator struct {
	i    int
	page ExpressRoutePortsLocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRoutePortsLocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortsLocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRoutePortsLocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRoutePortsLocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRoutePortsLocationListResultIterator) Response() ExpressRoutePortsLocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRoutePortsLocationListResultIterator) Value() ExpressRoutePortsLocation {
	if !iter.page.NotDone() {
		return ExpressRoutePortsLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRoutePortsLocationListResultIterator type.
func NewExpressRoutePortsLocationListResultIterator(page ExpressRoutePortsLocationListResultPage) ExpressRoutePortsLocationListResultIterator {
	return ExpressRoutePortsLocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erpllr ExpressRoutePortsLocationListResult) IsEmpty() bool {
	return erpllr.Value == nil || len(*erpllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erpllr ExpressRoutePortsLocationListResult) hasNextLink() bool {
	return erpllr.NextLink != nil && len(*erpllr.NextLink) != 0
}

// expressRoutePortsLocationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erpllr ExpressRoutePortsLocationListResult) expressRoutePortsLocationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erpllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erpllr.NextLink)))
}

// ExpressRoutePortsLocationListResultPage contains a page of ExpressRoutePortsLocation values.
type ExpressRoutePortsLocationListResultPage struct {
	fn     func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)
	erpllr ExpressRoutePortsLocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRoutePortsLocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRoutePortsLocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erpllr)
		if err != nil {
			return err
		}
		page.erpllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRoutePortsLocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRoutePortsLocationListResultPage) NotDone() bool {
	return !page.erpllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRoutePortsLocationListResultPage) Response() ExpressRoutePortsLocationListResult {
	return page.erpllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRoutePortsLocationListResultPage) Values() []ExpressRoutePortsLocation {
	if page.erpllr.IsEmpty() {
		return nil
	}
	return *page.erpllr.Value
}

// Creates a new instance of the ExpressRoutePortsLocationListResultPage type.
func NewExpressRoutePortsLocationListResultPage(cur ExpressRoutePortsLocationListResult, getNextPage func(context.Context, ExpressRoutePortsLocationListResult) (ExpressRoutePortsLocationListResult, error)) ExpressRoutePortsLocationListResultPage {
	return ExpressRoutePortsLocationListResultPage{
		fn:     getNextPage,
		erpllr: cur,
	}
}

// ExpressRoutePortsLocationPropertiesFormat properties specific to ExpressRoutePorts peering location
// resources.
type ExpressRoutePortsLocationPropertiesFormat struct {
	// Address - READ-ONLY; Address of peering location.
	Address *string `json:"address,omitempty"`
	// Contact - READ-ONLY; Contact details of peering locations.
	Contact *string `json:"contact,omitempty"`
	// AvailableBandwidths - The inventory of available ExpressRoutePort bandwidths.
	AvailableBandwidths *[]ExpressRoutePortsLocationBandwidths `json:"availableBandwidths,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route port location resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRoutePortsLocationPropertiesFormat.
func (erplpf ExpressRoutePortsLocationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erplpf.AvailableBandwidths != nil {
		objectMap["availableBandwidths"] = erplpf.AvailableBandwidths
	}
	return json.Marshal(objectMap)
}

// ExpressRouteProviderPort expressRouteProviderPort resource.
type ExpressRouteProviderPort struct {
	autorest.Response `json:"-"`
	// ExpressRouteProviderPortProperties - Properties of the express route Service Provider Port.
	*ExpressRouteProviderPortProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteProviderPort.
func (erpp ExpressRouteProviderPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erpp.ExpressRouteProviderPortProperties != nil {
		objectMap["properties"] = erpp.ExpressRouteProviderPortProperties
	}
	if erpp.ID != nil {
		objectMap["id"] = erpp.ID
	}
	if erpp.Location != nil {
		objectMap["location"] = erpp.Location
	}
	if erpp.Tags != nil {
		objectMap["tags"] = erpp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteProviderPort struct.
func (erpp *ExpressRouteProviderPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteProviderPortProperties ExpressRouteProviderPortProperties
				err = json.Unmarshal(*v, &expressRouteProviderPortProperties)
				if err != nil {
					return err
				}
				erpp.ExpressRouteProviderPortProperties = &expressRouteProviderPortProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erpp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erpp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erpp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erpp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteProviderPortListResult response for ListExpressRouteProviderPort API service call.
type ExpressRouteProviderPortListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteProviderPort resources.
	Value *[]ExpressRouteProviderPort `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteProviderPortListResult.
func (erpplr ExpressRouteProviderPortListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erpplr.Value != nil {
		objectMap["value"] = erpplr.Value
	}
	return json.Marshal(objectMap)
}

// ExpressRouteProviderPortProperties properties of ExpressRouteProviderPort.
type ExpressRouteProviderPortProperties struct {
	// PortPairDescriptor - READ-ONLY; The name of the port pair.
	PortPairDescriptor *string `json:"portPairDescriptor,omitempty"`
	// PrimaryAzurePort - READ-ONLY; The name of the primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - READ-ONLY; The name of the secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// PeeringLocation - The peering location of the port pair.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// OverprovisionFactor - Overprovisioning factor for the port pair.
	OverprovisionFactor *int32 `json:"overprovisionFactor,omitempty"`
	// PortBandwidthInMbps - Bandwidth of the port in Mbps
	PortBandwidthInMbps *int32 `json:"portBandwidthInMbps,omitempty"`
	// UsedBandwidthInMbps - Used Bandwidth of the port in Mbps
	UsedBandwidthInMbps *int32 `json:"usedBandwidthInMbps,omitempty"`
	// RemainingBandwidthInMbps - Remaining Bandwidth of the port in Mbps
	RemainingBandwidthInMbps *int32 `json:"remainingBandwidthInMbps,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteProviderPortProperties.
func (erppp ExpressRouteProviderPortProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erppp.PeeringLocation != nil {
		objectMap["peeringLocation"] = erppp.PeeringLocation
	}
	if erppp.OverprovisionFactor != nil {
		objectMap["overprovisionFactor"] = erppp.OverprovisionFactor
	}
	if erppp.PortBandwidthInMbps != nil {
		objectMap["portBandwidthInMbps"] = erppp.PortBandwidthInMbps
	}
	if erppp.UsedBandwidthInMbps != nil {
		objectMap["usedBandwidthInMbps"] = erppp.UsedBandwidthInMbps
	}
	if erppp.RemainingBandwidthInMbps != nil {
		objectMap["remainingBandwidthInMbps"] = erppp.RemainingBandwidthInMbps
	}
	return json.Marshal(objectMap)
}

// ExpressRouteServiceProvider a ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	// ExpressRouteServiceProviderPropertiesFormat - Properties of the express route service provider.
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProvider.
func (ersp ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersp.ExpressRouteServiceProviderPropertiesFormat != nil {
		objectMap["properties"] = ersp.ExpressRouteServiceProviderPropertiesFormat
	}
	if ersp.ID != nil {
		objectMap["id"] = ersp.ID
	}
	if ersp.Location != nil {
		objectMap["location"] = ersp.Location
	}
	if ersp.Tags != nil {
		objectMap["tags"] = ersp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteServiceProvider struct.
func (ersp *ExpressRouteServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteServiceProviderPropertiesFormat ExpressRouteServiceProviderPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteServiceProviderPropertiesFormat)
				if err != nil {
					return err
				}
				ersp.ExpressRouteServiceProviderPropertiesFormat = &expressRouteServiceProviderPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ersp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ersp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ersp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ersp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ersp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteServiceProviderBandwidthsOffered contains bandwidths offered in ExpressRouteServiceProvider
// resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - The OfferName.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteResourceProvider resources.
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteServiceProviderListResultIterator type.
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return ExpressRouteServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ersplr ExpressRouteServiceProviderListResult) hasNextLink() bool {
	return ersplr.NextLink != nil && len(*ersplr.NextLink) != 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ersplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ersplr)
		if err != nil {
			return err
		}
		page.ersplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// Creates a new instance of the ExpressRouteServiceProviderListResultPage type.
func NewExpressRouteServiceProviderListResultPage(cur ExpressRouteServiceProviderListResult, getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return ExpressRouteServiceProviderListResultPage{
		fn:     getNextPage,
		ersplr: cur,
	}
}

// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - A list of peering locations.
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - A list of bandwidths offered.
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the express route service provider resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProviderPropertiesFormat.
func (ersppf ExpressRouteServiceProviderPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersppf.PeeringLocations != nil {
		objectMap["peeringLocations"] = ersppf.PeeringLocations
	}
	if ersppf.BandwidthsOffered != nil {
		objectMap["bandwidthsOffered"] = ersppf.BandwidthsOffered
	}
	return json.Marshal(objectMap)
}

// ExtendedLocation extendedLocation complex type.
type ExtendedLocation struct {
	// Name - The name of the extended location.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extended location. Possible values include: 'EdgeZone'
	Type ExtendedLocationTypes `json:"type,omitempty"`
}

// FilterItems will contain the filter name and values to operate on
type FilterItems struct {
	// Field - The name of the field we would like to filter
	Field *string `json:"field,omitempty"`
	// Values - List of values to filter the current field by
	Values *[]string `json:"values,omitempty"`
}

// FirewallPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FirewallPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPoliciesClient) (FirewallPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallPoliciesCreateOrUpdateFuture.Result.
func (future *FirewallPoliciesCreateOrUpdateFuture) result(client FirewallPoliciesClient) (fp FirewallPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FirewallPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FirewallPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fp.Response.Response, err = future.GetResult(sender); err == nil && fp.Response.Response.StatusCode != http.StatusNoContent {
		fp, err = client.CreateOrUpdateResponder(fp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.FirewallPoliciesCreateOrUpdateFuture", "Result", fp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FirewallPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FirewallPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallPoliciesDeleteFuture.Result.
func (future *FirewallPoliciesDeleteFuture) result(client FirewallPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FirewallPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FirewallPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FirewallPolicy firewallPolicy Resource.
type FirewallPolicy struct {
	autorest.Response `json:"-"`
	// FirewallPolicyPropertiesFormat - Properties of the firewall policy.
	*FirewallPolicyPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Identity - The identity of the firewall policy.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FirewallPolicy.
func (fp FirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.FirewallPolicyPropertiesFormat != nil {
		objectMap["properties"] = fp.FirewallPolicyPropertiesFormat
	}
	if fp.Identity != nil {
		objectMap["identity"] = fp.Identity
	}
	if fp.ID != nil {
		objectMap["id"] = fp.ID
	}
	if fp.Location != nil {
		objectMap["location"] = fp.Location
	}
	if fp.Tags != nil {
		objectMap["tags"] = fp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicy struct.
func (fp *FirewallPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallPolicyPropertiesFormat FirewallPolicyPropertiesFormat
				err = json.Unmarshal(*v, &firewallPolicyPropertiesFormat)
				if err != nil {
					return err
				}
				fp.FirewallPolicyPropertiesFormat = &firewallPolicyPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fp.Etag = &etag
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				fp.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fp.Tags = tags
			}
		}
	}

	return nil
}

// FirewallPolicyCertificateAuthority trusted Root certificates properties for tls.
type FirewallPolicyCertificateAuthority struct {
	// KeyVaultSecretID - Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
	KeyVaultSecretID *string `json:"keyVaultSecretId,omitempty"`
	// Name - Name of the CA certificate.
	Name *string `json:"name,omitempty"`
}

// FirewallPolicyFilterRuleCollection firewall Policy Filter Rule Collection.
type FirewallPolicyFilterRuleCollection struct {
	// Action - The action type of a Filter rule collection.
	Action *FirewallPolicyFilterRuleCollectionAction `json:"action,omitempty"`
	// Rules - List of rules included in a rule collection.
	Rules *[]BasicFirewallPolicyRule `json:"rules,omitempty"`
	// Name - The name of the rule collection.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleCollectionType - Possible values include: 'RuleCollectionTypeFirewallPolicyRuleCollection', 'RuleCollectionTypeFirewallPolicyNatRuleCollection', 'RuleCollectionTypeFirewallPolicyFilterRuleCollection'
	RuleCollectionType RuleCollectionType `json:"ruleCollectionType,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyFilterRuleCollection.
func (fpfrc FirewallPolicyFilterRuleCollection) MarshalJSON() ([]byte, error) {
	fpfrc.RuleCollectionType = RuleCollectionTypeFirewallPolicyFilterRuleCollection
	objectMap := make(map[string]interface{})
	if fpfrc.Action != nil {
		objectMap["action"] = fpfrc.Action
	}
	if fpfrc.Rules != nil {
		objectMap["rules"] = fpfrc.Rules
	}
	if fpfrc.Name != nil {
		objectMap["name"] = fpfrc.Name
	}
	if fpfrc.Priority != nil {
		objectMap["priority"] = fpfrc.Priority
	}
	if fpfrc.RuleCollectionType != "" {
		objectMap["ruleCollectionType"] = fpfrc.RuleCollectionType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyFilterRuleCollection.
func (fpfrc FirewallPolicyFilterRuleCollection) AsFirewallPolicyNatRuleCollection() (*FirewallPolicyNatRuleCollection, bool) {
	return nil, false
}

// AsFirewallPolicyFilterRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyFilterRuleCollection.
func (fpfrc FirewallPolicyFilterRuleCollection) AsFirewallPolicyFilterRuleCollection() (*FirewallPolicyFilterRuleCollection, bool) {
	return &fpfrc, true
}

// AsFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyFilterRuleCollection.
func (fpfrc FirewallPolicyFilterRuleCollection) AsFirewallPolicyRuleCollection() (*FirewallPolicyRuleCollection, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyFilterRuleCollection.
func (fpfrc FirewallPolicyFilterRuleCollection) AsBasicFirewallPolicyRuleCollection() (BasicFirewallPolicyRuleCollection, bool) {
	return &fpfrc, true
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyFilterRuleCollection struct.
func (fpfrc *FirewallPolicyFilterRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "action":
			if v != nil {
				var action FirewallPolicyFilterRuleCollectionAction
				err = json.Unmarshal(*v, &action)
				if err != nil {
					return err
				}
				fpfrc.Action = &action
			}
		case "rules":
			if v != nil {
				rules, err := unmarshalBasicFirewallPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				fpfrc.Rules = &rules
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fpfrc.Name = &name
			}
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fpfrc.Priority = &priority
			}
		case "ruleCollectionType":
			if v != nil {
				var ruleCollectionType RuleCollectionType
				err = json.Unmarshal(*v, &ruleCollectionType)
				if err != nil {
					return err
				}
				fpfrc.RuleCollectionType = ruleCollectionType
			}
		}
	}

	return nil
}

// FirewallPolicyFilterRuleCollectionAction properties of the FirewallPolicyFilterRuleCollectionAction.
type FirewallPolicyFilterRuleCollectionAction struct {
	// Type - The type of action. Possible values include: 'FirewallPolicyFilterRuleCollectionActionTypeAllow', 'FirewallPolicyFilterRuleCollectionActionTypeDeny'
	Type FirewallPolicyFilterRuleCollectionActionType `json:"type,omitempty"`
}

// FirewallPolicyInsights firewall Policy Insights.
type FirewallPolicyInsights struct {
	// IsEnabled - A flag to indicate if the insights are enabled on the policy.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RetentionDays - Number of days the insights should be enabled on the policy.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// LogAnalyticsResources - Workspaces needed to configure the Firewall Policy Insights.
	LogAnalyticsResources *FirewallPolicyLogAnalyticsResources `json:"logAnalyticsResources,omitempty"`
}

// FirewallPolicyIntrusionDetection configuration for intrusion detection mode and rules.
type FirewallPolicyIntrusionDetection struct {
	// Mode - Intrusion detection general state. Possible values include: 'FirewallPolicyIntrusionDetectionStateTypeOff', 'FirewallPolicyIntrusionDetectionStateTypeAlert', 'FirewallPolicyIntrusionDetectionStateTypeDeny'
	Mode FirewallPolicyIntrusionDetectionStateType `json:"mode,omitempty"`
	// Configuration - Intrusion detection configuration properties.
	Configuration *FirewallPolicyIntrusionDetectionConfiguration `json:"configuration,omitempty"`
}

// FirewallPolicyIntrusionDetectionBypassTrafficSpecifications intrusion detection bypass traffic
// specification.
type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications struct {
	// Name - Name of the bypass traffic rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the bypass traffic rule.
	Description *string `json:"description,omitempty"`
	// Protocol - The rule bypass protocol. Possible values include: 'FirewallPolicyIntrusionDetectionProtocolTCP', 'FirewallPolicyIntrusionDetectionProtocolUDP', 'FirewallPolicyIntrusionDetectionProtocolICMP', 'FirewallPolicyIntrusionDetectionProtocolANY'
	Protocol FirewallPolicyIntrusionDetectionProtocol `json:"protocol,omitempty"`
	// SourceAddresses - List of source IP addresses or ranges for this rule.
	SourceAddresses *[]string `json:"sourceAddresses,omitempty"`
	// DestinationAddresses - List of destination IP addresses or ranges for this rule.
	DestinationAddresses *[]string `json:"destinationAddresses,omitempty"`
	// DestinationPorts - List of destination ports or ranges.
	DestinationPorts *[]string `json:"destinationPorts,omitempty"`
	// SourceIPGroups - List of source IpGroups for this rule.
	SourceIPGroups *[]string `json:"sourceIpGroups,omitempty"`
	// DestinationIPGroups - List of destination IpGroups for this rule.
	DestinationIPGroups *[]string `json:"destinationIpGroups,omitempty"`
}

// FirewallPolicyIntrusionDetectionConfiguration the operation for configuring intrusion detection.
type FirewallPolicyIntrusionDetectionConfiguration struct {
	// SignatureOverrides - List of specific signatures states.
	SignatureOverrides *[]FirewallPolicyIntrusionDetectionSignatureSpecification `json:"signatureOverrides,omitempty"`
	// BypassTrafficSettings - List of rules for traffic to bypass.
	BypassTrafficSettings *[]FirewallPolicyIntrusionDetectionBypassTrafficSpecifications `json:"bypassTrafficSettings,omitempty"`
	// PrivateRanges - IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
	PrivateRanges *[]string `json:"privateRanges,omitempty"`
}

// FirewallPolicyIntrusionDetectionSignatureSpecification intrusion detection signatures specification
// states.
type FirewallPolicyIntrusionDetectionSignatureSpecification struct {
	// ID - Signature id.
	ID *string `json:"id,omitempty"`
	// Mode - The signature state. Possible values include: 'FirewallPolicyIntrusionDetectionStateTypeOff', 'FirewallPolicyIntrusionDetectionStateTypeAlert', 'FirewallPolicyIntrusionDetectionStateTypeDeny'
	Mode FirewallPolicyIntrusionDetectionStateType `json:"mode,omitempty"`
}

// FirewallPolicyListResult response for ListFirewallPolicies API service call.
type FirewallPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Firewall Policies in a resource group.
	Value *[]FirewallPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallPolicyListResultIterator provides access to a complete listing of FirewallPolicy values.
type FirewallPolicyListResultIterator struct {
	i    int
	page FirewallPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallPolicyListResultIterator) Response() FirewallPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallPolicyListResultIterator) Value() FirewallPolicy {
	if !iter.page.NotDone() {
		return FirewallPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallPolicyListResultIterator type.
func NewFirewallPolicyListResultIterator(page FirewallPolicyListResultPage) FirewallPolicyListResultIterator {
	return FirewallPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fplr FirewallPolicyListResult) IsEmpty() bool {
	return fplr.Value == nil || len(*fplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fplr FirewallPolicyListResult) hasNextLink() bool {
	return fplr.NextLink != nil && len(*fplr.NextLink) != 0
}

// firewallPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fplr FirewallPolicyListResult) firewallPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fplr.NextLink)))
}

// FirewallPolicyListResultPage contains a page of FirewallPolicy values.
type FirewallPolicyListResultPage struct {
	fn   func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)
	fplr FirewallPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fplr)
		if err != nil {
			return err
		}
		page.fplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallPolicyListResultPage) NotDone() bool {
	return !page.fplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallPolicyListResultPage) Response() FirewallPolicyListResult {
	return page.fplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallPolicyListResultPage) Values() []FirewallPolicy {
	if page.fplr.IsEmpty() {
		return nil
	}
	return *page.fplr.Value
}

// Creates a new instance of the FirewallPolicyListResultPage type.
func NewFirewallPolicyListResultPage(cur FirewallPolicyListResult, getNextPage func(context.Context, FirewallPolicyListResult) (FirewallPolicyListResult, error)) FirewallPolicyListResultPage {
	return FirewallPolicyListResultPage{
		fn:   getNextPage,
		fplr: cur,
	}
}

// FirewallPolicyLogAnalyticsResources log Analytics Resources for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsResources struct {
	// Workspaces - List of workspaces for Firewall Policy Insights.
	Workspaces *[]FirewallPolicyLogAnalyticsWorkspace `json:"workspaces,omitempty"`
	// DefaultWorkspaceID - The default workspace Id for Firewall Policy Insights.
	DefaultWorkspaceID *SubResource `json:"defaultWorkspaceId,omitempty"`
}

// FirewallPolicyLogAnalyticsWorkspace log Analytics Workspace for Firewall Policy Insights.
type FirewallPolicyLogAnalyticsWorkspace struct {
	// Region - Region to configure the Workspace.
	Region *string `json:"region,omitempty"`
	// WorkspaceID - The workspace Id for Firewall Policy Insights.
	WorkspaceID *SubResource `json:"workspaceId,omitempty"`
}

// FirewallPolicyNatRuleCollection firewall Policy NAT Rule Collection.
type FirewallPolicyNatRuleCollection struct {
	// Action - The action type of a Nat rule collection.
	Action *FirewallPolicyNatRuleCollectionAction `json:"action,omitempty"`
	// Rules - List of rules included in a rule collection.
	Rules *[]BasicFirewallPolicyRule `json:"rules,omitempty"`
	// Name - The name of the rule collection.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleCollectionType - Possible values include: 'RuleCollectionTypeFirewallPolicyRuleCollection', 'RuleCollectionTypeFirewallPolicyNatRuleCollection', 'RuleCollectionTypeFirewallPolicyFilterRuleCollection'
	RuleCollectionType RuleCollectionType `json:"ruleCollectionType,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyNatRuleCollection.
func (fpnrc FirewallPolicyNatRuleCollection) MarshalJSON() ([]byte, error) {
	fpnrc.RuleCollectionType = RuleCollectionTypeFirewallPolicyNatRuleCollection
	objectMap := make(map[string]interface{})
	if fpnrc.Action != nil {
		objectMap["action"] = fpnrc.Action
	}
	if fpnrc.Rules != nil {
		objectMap["rules"] = fpnrc.Rules
	}
	if fpnrc.Name != nil {
		objectMap["name"] = fpnrc.Name
	}
	if fpnrc.Priority != nil {
		objectMap["priority"] = fpnrc.Priority
	}
	if fpnrc.RuleCollectionType != "" {
		objectMap["ruleCollectionType"] = fpnrc.RuleCollectionType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyNatRuleCollection.
func (fpnrc FirewallPolicyNatRuleCollection) AsFirewallPolicyNatRuleCollection() (*FirewallPolicyNatRuleCollection, bool) {
	return &fpnrc, true
}

// AsFirewallPolicyFilterRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyNatRuleCollection.
func (fpnrc FirewallPolicyNatRuleCollection) AsFirewallPolicyFilterRuleCollection() (*FirewallPolicyFilterRuleCollection, bool) {
	return nil, false
}

// AsFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyNatRuleCollection.
func (fpnrc FirewallPolicyNatRuleCollection) AsFirewallPolicyRuleCollection() (*FirewallPolicyRuleCollection, bool) {
	return nil, false
}

// AsBasicFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyNatRuleCollection.
func (fpnrc FirewallPolicyNatRuleCollection) AsBasicFirewallPolicyRuleCollection() (BasicFirewallPolicyRuleCollection, bool) {
	return &fpnrc, true
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyNatRuleCollection struct.
func (fpnrc *FirewallPolicyNatRuleCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "action":
			if v != nil {
				var action FirewallPolicyNatRuleCollectionAction
				err = json.Unmarshal(*v, &action)
				if err != nil {
					return err
				}
				fpnrc.Action = &action
			}
		case "rules":
			if v != nil {
				rules, err := unmarshalBasicFirewallPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				fpnrc.Rules = &rules
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fpnrc.Name = &name
			}
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fpnrc.Priority = &priority
			}
		case "ruleCollectionType":
			if v != nil {
				var ruleCollectionType RuleCollectionType
				err = json.Unmarshal(*v, &ruleCollectionType)
				if err != nil {
					return err
				}
				fpnrc.RuleCollectionType = ruleCollectionType
			}
		}
	}

	return nil
}

// FirewallPolicyNatRuleCollectionAction properties of the FirewallPolicyNatRuleCollectionAction.
type FirewallPolicyNatRuleCollectionAction struct {
	// Type - The type of action. Possible values include: 'DNAT'
	Type FirewallPolicyNatRuleCollectionActionType `json:"type,omitempty"`
}

// FirewallPolicyPropertiesFormat firewall Policy definition.
type FirewallPolicyPropertiesFormat struct {
	// RuleCollectionGroups - READ-ONLY; List of references to FirewallPolicyRuleCollectionGroups.
	RuleCollectionGroups *[]SubResource `json:"ruleCollectionGroups,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the firewall policy resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// BasePolicy - The parent firewall policy from which rules are inherited.
	BasePolicy *SubResource `json:"basePolicy,omitempty"`
	// Firewalls - READ-ONLY; List of references to Azure Firewalls that this Firewall Policy is associated with.
	Firewalls *[]SubResource `json:"firewalls,omitempty"`
	// ChildPolicies - READ-ONLY; List of references to Child Firewall Policies.
	ChildPolicies *[]SubResource `json:"childPolicies,omitempty"`
	// ThreatIntelMode - The operation mode for Threat Intelligence. Possible values include: 'AzureFirewallThreatIntelModeAlert', 'AzureFirewallThreatIntelModeDeny', 'AzureFirewallThreatIntelModeOff'
	ThreatIntelMode AzureFirewallThreatIntelMode `json:"threatIntelMode,omitempty"`
	// ThreatIntelWhitelist - ThreatIntel Whitelist for Firewall Policy.
	ThreatIntelWhitelist *FirewallPolicyThreatIntelWhitelist `json:"threatIntelWhitelist,omitempty"`
	// Insights - Insights on Firewall Policy.
	Insights *FirewallPolicyInsights `json:"insights,omitempty"`
	// Snat - The private IP addresses/IP ranges to which traffic will not be SNAT.
	Snat *FirewallPolicySNAT `json:"snat,omitempty"`
	// SQL - SQL Settings definition.
	SQL *FirewallPolicySQL `json:"sql,omitempty"`
	// DNSSettings - DNS Proxy Settings definition.
	DNSSettings *DNSSettings `json:"dnsSettings,omitempty"`
	// ExplicitProxy - Explicit Proxy Settings definition.
	ExplicitProxy *ExplicitProxy `json:"explicitProxy,omitempty"`
	// IntrusionDetection - The configuration for Intrusion detection.
	IntrusionDetection *FirewallPolicyIntrusionDetection `json:"intrusionDetection,omitempty"`
	// TransportSecurity - TLS Configuration definition.
	TransportSecurity *FirewallPolicyTransportSecurity `json:"transportSecurity,omitempty"`
	// Sku - The Firewall Policy SKU.
	Sku *FirewallPolicySku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyPropertiesFormat.
func (fppf FirewallPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fppf.BasePolicy != nil {
		objectMap["basePolicy"] = fppf.BasePolicy
	}
	if fppf.ThreatIntelMode != "" {
		objectMap["threatIntelMode"] = fppf.ThreatIntelMode
	}
	if fppf.ThreatIntelWhitelist != nil {
		objectMap["threatIntelWhitelist"] = fppf.ThreatIntelWhitelist
	}
	if fppf.Insights != nil {
		objectMap["insights"] = fppf.Insights
	}
	if fppf.Snat != nil {
		objectMap["snat"] = fppf.Snat
	}
	if fppf.SQL != nil {
		objectMap["sql"] = fppf.SQL
	}
	if fppf.DNSSettings != nil {
		objectMap["dnsSettings"] = fppf.DNSSettings
	}
	if fppf.ExplicitProxy != nil {
		objectMap["explicitProxy"] = fppf.ExplicitProxy
	}
	if fppf.IntrusionDetection != nil {
		objectMap["intrusionDetection"] = fppf.IntrusionDetection
	}
	if fppf.TransportSecurity != nil {
		objectMap["transportSecurity"] = fppf.TransportSecurity
	}
	if fppf.Sku != nil {
		objectMap["sku"] = fppf.Sku
	}
	return json.Marshal(objectMap)
}

// BasicFirewallPolicyRule properties of a rule.
type BasicFirewallPolicyRule interface {
	AsApplicationRule() (*ApplicationRule, bool)
	AsNatRule() (*NatRule, bool)
	AsRule() (*Rule, bool)
	AsFirewallPolicyRule() (*FirewallPolicyRule, bool)
}

// FirewallPolicyRule properties of a rule.
type FirewallPolicyRule struct {
	// Name - Name of the rule.
	Name *string `json:"name,omitempty"`
	// Description - Description of the rule.
	Description *string `json:"description,omitempty"`
	// RuleType - Possible values include: 'RuleTypeFirewallPolicyRule', 'RuleTypeApplicationRule', 'RuleTypeNatRule', 'RuleTypeNetworkRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

func unmarshalBasicFirewallPolicyRule(body []byte) (BasicFirewallPolicyRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeApplicationRule):
		var ar ApplicationRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	case string(RuleTypeNatRule):
		var nr NatRule
		err := json.Unmarshal(body, &nr)
		return nr, err
	case string(RuleTypeNetworkRule):
		var r Rule
		err := json.Unmarshal(body, &r)
		return r, err
	default:
		var fpr FirewallPolicyRule
		err := json.Unmarshal(body, &fpr)
		return fpr, err
	}
}
func unmarshalBasicFirewallPolicyRuleArray(body []byte) ([]BasicFirewallPolicyRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fprArray := make([]BasicFirewallPolicyRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fpr, err := unmarshalBasicFirewallPolicyRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		fprArray[index] = fpr
	}
	return fprArray, nil
}

// MarshalJSON is the custom marshaler for FirewallPolicyRule.
func (fpr FirewallPolicyRule) MarshalJSON() ([]byte, error) {
	fpr.RuleType = RuleTypeFirewallPolicyRule
	objectMap := make(map[string]interface{})
	if fpr.Name != nil {
		objectMap["name"] = fpr.Name
	}
	if fpr.Description != nil {
		objectMap["description"] = fpr.Description
	}
	if fpr.RuleType != "" {
		objectMap["ruleType"] = fpr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsApplicationRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsApplicationRule() (*ApplicationRule, bool) {
	return nil, false
}

// AsNatRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsNatRule() (*NatRule, bool) {
	return nil, false
}

// AsRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsRule() (*Rule, bool) {
	return nil, false
}

// AsFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsFirewallPolicyRule() (*FirewallPolicyRule, bool) {
	return &fpr, true
}

// AsBasicFirewallPolicyRule is the BasicFirewallPolicyRule implementation for FirewallPolicyRule.
func (fpr FirewallPolicyRule) AsBasicFirewallPolicyRule() (BasicFirewallPolicyRule, bool) {
	return &fpr, true
}

// FirewallPolicyRuleApplicationProtocol properties of the application rule protocol.
type FirewallPolicyRuleApplicationProtocol struct {
	// ProtocolType - Protocol type. Possible values include: 'FirewallPolicyRuleApplicationProtocolTypeHTTP', 'FirewallPolicyRuleApplicationProtocolTypeHTTPS'
	ProtocolType FirewallPolicyRuleApplicationProtocolType `json:"protocolType,omitempty"`
	// Port - Port number for the protocol, cannot be greater than 64000.
	Port *int32 `json:"port,omitempty"`
}

// BasicFirewallPolicyRuleCollection properties of the rule collection.
type BasicFirewallPolicyRuleCollection interface {
	AsFirewallPolicyNatRuleCollection() (*FirewallPolicyNatRuleCollection, bool)
	AsFirewallPolicyFilterRuleCollection() (*FirewallPolicyFilterRuleCollection, bool)
	AsFirewallPolicyRuleCollection() (*FirewallPolicyRuleCollection, bool)
}

// FirewallPolicyRuleCollection properties of the rule collection.
type FirewallPolicyRuleCollection struct {
	// Name - The name of the rule collection.
	Name *string `json:"name,omitempty"`
	// Priority - Priority of the Firewall Policy Rule Collection resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleCollectionType - Possible values include: 'RuleCollectionTypeFirewallPolicyRuleCollection', 'RuleCollectionTypeFirewallPolicyNatRuleCollection', 'RuleCollectionTypeFirewallPolicyFilterRuleCollection'
	RuleCollectionType RuleCollectionType `json:"ruleCollectionType,omitempty"`
}

func unmarshalBasicFirewallPolicyRuleCollection(body []byte) (BasicFirewallPolicyRuleCollection, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleCollectionType"] {
	case string(RuleCollectionTypeFirewallPolicyNatRuleCollection):
		var fpnrc FirewallPolicyNatRuleCollection
		err := json.Unmarshal(body, &fpnrc)
		return fpnrc, err
	case string(RuleCollectionTypeFirewallPolicyFilterRuleCollection):
		var fpfrc FirewallPolicyFilterRuleCollection
		err := json.Unmarshal(body, &fpfrc)
		return fpfrc, err
	default:
		var fprc FirewallPolicyRuleCollection
		err := json.Unmarshal(body, &fprc)
		return fprc, err
	}
}
func unmarshalBasicFirewallPolicyRuleCollectionArray(body []byte) ([]BasicFirewallPolicyRuleCollection, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fprcArray := make([]BasicFirewallPolicyRuleCollection, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fprc, err := unmarshalBasicFirewallPolicyRuleCollection(*rawMessage)
		if err != nil {
			return nil, err
		}
		fprcArray[index] = fprc
	}
	return fprcArray, nil
}

// MarshalJSON is the custom marshaler for FirewallPolicyRuleCollection.
func (fprc FirewallPolicyRuleCollection) MarshalJSON() ([]byte, error) {
	fprc.RuleCollectionType = RuleCollectionTypeFirewallPolicyRuleCollection
	objectMap := make(map[string]interface{})
	if fprc.Name != nil {
		objectMap["name"] = fprc.Name
	}
	if fprc.Priority != nil {
		objectMap["priority"] = fprc.Priority
	}
	if fprc.RuleCollectionType != "" {
		objectMap["ruleCollectionType"] = fprc.RuleCollectionType
	}
	return json.Marshal(objectMap)
}

// AsFirewallPolicyNatRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyRuleCollection.
func (fprc FirewallPolicyRuleCollection) AsFirewallPolicyNatRuleCollection() (*FirewallPolicyNatRuleCollection, bool) {
	return nil, false
}

// AsFirewallPolicyFilterRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyRuleCollection.
func (fprc FirewallPolicyRuleCollection) AsFirewallPolicyFilterRuleCollection() (*FirewallPolicyFilterRuleCollection, bool) {
	return nil, false
}

// AsFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyRuleCollection.
func (fprc FirewallPolicyRuleCollection) AsFirewallPolicyRuleCollection() (*FirewallPolicyRuleCollection, bool) {
	return &fprc, true
}

// AsBasicFirewallPolicyRuleCollection is the BasicFirewallPolicyRuleCollection implementation for FirewallPolicyRuleCollection.
func (fprc FirewallPolicyRuleCollection) AsBasicFirewallPolicyRuleCollection() (BasicFirewallPolicyRuleCollection, bool) {
	return &fprc, true
}

// FirewallPolicyRuleCollectionGroup rule Collection Group resource.
type FirewallPolicyRuleCollectionGroup struct {
	autorest.Response `json:"-"`
	// FirewallPolicyRuleCollectionGroupProperties - The properties of the firewall policy rule collection group.
	*FirewallPolicyRuleCollectionGroupProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Rule Group type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyRuleCollectionGroup.
func (fprcg FirewallPolicyRuleCollectionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fprcg.FirewallPolicyRuleCollectionGroupProperties != nil {
		objectMap["properties"] = fprcg.FirewallPolicyRuleCollectionGroupProperties
	}
	if fprcg.Name != nil {
		objectMap["name"] = fprcg.Name
	}
	if fprcg.ID != nil {
		objectMap["id"] = fprcg.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyRuleCollectionGroup struct.
func (fprcg *FirewallPolicyRuleCollectionGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallPolicyRuleCollectionGroupProperties FirewallPolicyRuleCollectionGroupProperties
				err = json.Unmarshal(*v, &firewallPolicyRuleCollectionGroupProperties)
				if err != nil {
					return err
				}
				fprcg.FirewallPolicyRuleCollectionGroupProperties = &firewallPolicyRuleCollectionGroupProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fprcg.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fprcg.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fprcg.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fprcg.ID = &ID
			}
		}
	}

	return nil
}

// FirewallPolicyRuleCollectionGroupListResult response for ListFirewallPolicyRuleCollectionGroups API
// service call.
type FirewallPolicyRuleCollectionGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - List of FirewallPolicyRuleCollectionGroups in a FirewallPolicy.
	Value *[]FirewallPolicyRuleCollectionGroup `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallPolicyRuleCollectionGroupListResultIterator provides access to a complete listing of
// FirewallPolicyRuleCollectionGroup values.
type FirewallPolicyRuleCollectionGroupListResultIterator struct {
	i    int
	page FirewallPolicyRuleCollectionGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallPolicyRuleCollectionGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyRuleCollectionGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallPolicyRuleCollectionGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallPolicyRuleCollectionGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallPolicyRuleCollectionGroupListResultIterator) Response() FirewallPolicyRuleCollectionGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallPolicyRuleCollectionGroupListResultIterator) Value() FirewallPolicyRuleCollectionGroup {
	if !iter.page.NotDone() {
		return FirewallPolicyRuleCollectionGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallPolicyRuleCollectionGroupListResultIterator type.
func NewFirewallPolicyRuleCollectionGroupListResultIterator(page FirewallPolicyRuleCollectionGroupListResultPage) FirewallPolicyRuleCollectionGroupListResultIterator {
	return FirewallPolicyRuleCollectionGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fprcglr FirewallPolicyRuleCollectionGroupListResult) IsEmpty() bool {
	return fprcglr.Value == nil || len(*fprcglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fprcglr FirewallPolicyRuleCollectionGroupListResult) hasNextLink() bool {
	return fprcglr.NextLink != nil && len(*fprcglr.NextLink) != 0
}

// firewallPolicyRuleCollectionGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fprcglr FirewallPolicyRuleCollectionGroupListResult) firewallPolicyRuleCollectionGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fprcglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fprcglr.NextLink)))
}

// FirewallPolicyRuleCollectionGroupListResultPage contains a page of FirewallPolicyRuleCollectionGroup
// values.
type FirewallPolicyRuleCollectionGroupListResultPage struct {
	fn      func(context.Context, FirewallPolicyRuleCollectionGroupListResult) (FirewallPolicyRuleCollectionGroupListResult, error)
	fprcglr FirewallPolicyRuleCollectionGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallPolicyRuleCollectionGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallPolicyRuleCollectionGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fprcglr)
		if err != nil {
			return err
		}
		page.fprcglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallPolicyRuleCollectionGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallPolicyRuleCollectionGroupListResultPage) NotDone() bool {
	return !page.fprcglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallPolicyRuleCollectionGroupListResultPage) Response() FirewallPolicyRuleCollectionGroupListResult {
	return page.fprcglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallPolicyRuleCollectionGroupListResultPage) Values() []FirewallPolicyRuleCollectionGroup {
	if page.fprcglr.IsEmpty() {
		return nil
	}
	return *page.fprcglr.Value
}

// Creates a new instance of the FirewallPolicyRuleCollectionGroupListResultPage type.
func NewFirewallPolicyRuleCollectionGroupListResultPage(cur FirewallPolicyRuleCollectionGroupListResult, getNextPage func(context.Context, FirewallPolicyRuleCollectionGroupListResult) (FirewallPolicyRuleCollectionGroupListResult, error)) FirewallPolicyRuleCollectionGroupListResultPage {
	return FirewallPolicyRuleCollectionGroupListResultPage{
		fn:      getNextPage,
		fprcglr: cur,
	}
}

// FirewallPolicyRuleCollectionGroupProperties properties of the rule collection group.
type FirewallPolicyRuleCollectionGroupProperties struct {
	// Priority - Priority of the Firewall Policy Rule Collection Group resource.
	Priority *int32 `json:"priority,omitempty"`
	// RuleCollections - Group of Firewall Policy rule collections.
	RuleCollections *[]BasicFirewallPolicyRuleCollection `json:"ruleCollections,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the firewall policy rule collection group resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallPolicyRuleCollectionGroupProperties.
func (fprcgp FirewallPolicyRuleCollectionGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fprcgp.Priority != nil {
		objectMap["priority"] = fprcgp.Priority
	}
	if fprcgp.RuleCollections != nil {
		objectMap["ruleCollections"] = fprcgp.RuleCollections
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallPolicyRuleCollectionGroupProperties struct.
func (fprcgp *FirewallPolicyRuleCollectionGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "priority":
			if v != nil {
				var priority int32
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				fprcgp.Priority = &priority
			}
		case "ruleCollections":
			if v != nil {
				ruleCollections, err := unmarshalBasicFirewallPolicyRuleCollectionArray(*v)
				if err != nil {
					return err
				}
				fprcgp.RuleCollections = &ruleCollections
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				fprcgp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPolicyRuleCollectionGroupsClient) (FirewallPolicyRuleCollectionGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture.Result.
func (future *FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture) result(client FirewallPolicyRuleCollectionGroupsClient) (fprcg FirewallPolicyRuleCollectionGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fprcg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fprcg.Response.Response, err = future.GetResult(sender); err == nil && fprcg.Response.Response.StatusCode != http.StatusNoContent {
		fprcg, err = client.CreateOrUpdateResponder(fprcg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.FirewallPolicyRuleCollectionGroupsCreateOrUpdateFuture", "Result", fprcg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FirewallPolicyRuleCollectionGroupsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type FirewallPolicyRuleCollectionGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FirewallPolicyRuleCollectionGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FirewallPolicyRuleCollectionGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FirewallPolicyRuleCollectionGroupsDeleteFuture.Result.
func (future *FirewallPolicyRuleCollectionGroupsDeleteFuture) result(client FirewallPolicyRuleCollectionGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FirewallPolicyRuleCollectionGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FirewallPolicyRuleCollectionGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FirewallPolicySku SKU of Firewall policy.
type FirewallPolicySku struct {
	// Tier - Tier of Firewall Policy. Possible values include: 'FirewallPolicySkuTierStandard', 'FirewallPolicySkuTierPremium', 'FirewallPolicySkuTierBasic'
	Tier FirewallPolicySkuTier `json:"tier,omitempty"`
}

// FirewallPolicySNAT the private IP addresses/IP ranges to which traffic will not be SNAT.
type FirewallPolicySNAT struct {
	// PrivateRanges - List of private IP addresses/IP address ranges to not be SNAT.
	PrivateRanges *[]string `json:"privateRanges,omitempty"`
	// AutoLearnPrivateRanges - The operation mode for automatically learning private ranges to not be SNAT. Possible values include: 'AutoLearnPrivateRangesModeEnabled', 'AutoLearnPrivateRangesModeDisabled'
	AutoLearnPrivateRanges AutoLearnPrivateRangesMode `json:"autoLearnPrivateRanges,omitempty"`
}

// FirewallPolicySQL SQL Settings in Firewall Policy.
type FirewallPolicySQL struct {
	// AllowSQLRedirect - A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
	AllowSQLRedirect *bool `json:"allowSqlRedirect,omitempty"`
}

// FirewallPolicyThreatIntelWhitelist threatIntel Whitelist for Firewall Policy.
type FirewallPolicyThreatIntelWhitelist struct {
	// IPAddresses - List of IP addresses for the ThreatIntel Whitelist.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// Fqdns - List of FQDNs for the ThreatIntel Whitelist.
	Fqdns *[]string `json:"fqdns,omitempty"`
}

// FirewallPolicyTransportSecurity configuration needed to perform TLS termination & initiation.
type FirewallPolicyTransportSecurity struct {
	// CertificateAuthority - The CA used for intermediate CA generation.
	CertificateAuthority *FirewallPolicyCertificateAuthority `json:"certificateAuthority,omitempty"`
}

// FlowLog a flow log resource.
type FlowLog struct {
	autorest.Response `json:"-"`
	// FlowLogPropertiesFormat - Properties of the flow log.
	*FlowLogPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FlowLog.
func (fl FlowLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fl.FlowLogPropertiesFormat != nil {
		objectMap["properties"] = fl.FlowLogPropertiesFormat
	}
	if fl.ID != nil {
		objectMap["id"] = fl.ID
	}
	if fl.Location != nil {
		objectMap["location"] = fl.Location
	}
	if fl.Tags != nil {
		objectMap["tags"] = fl.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FlowLog struct.
func (fl *FlowLog) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var flowLogPropertiesFormat FlowLogPropertiesFormat
				err = json.Unmarshal(*v, &flowLogPropertiesFormat)
				if err != nil {
					return err
				}
				fl.FlowLogPropertiesFormat = &flowLogPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fl.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fl.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fl.Tags = tags
			}
		}
	}

	return nil
}

// FlowLogFormatParameters parameters that define the flow log format.
type FlowLogFormatParameters struct {
	// Type - The file type of flow log. Possible values include: 'JSON'
	Type FlowLogFormatType `json:"type,omitempty"`
	// Version - The version (revision) of the flow log.
	Version *int32 `json:"version,omitempty"`
}

// FlowLogInformation information on the configuration of flow log and traffic analytics (optional) .
type FlowLogInformation struct {
	autorest.Response `json:"-"`
	// TargetResourceID - The ID of the resource to configure for flow log and traffic analytics (optional) .
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// FlowLogProperties - Properties of the flow log.
	*FlowLogProperties `json:"properties,omitempty"`
	// FlowAnalyticsConfiguration - Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties `json:"flowAnalyticsConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for FlowLogInformation.
func (fli FlowLogInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fli.TargetResourceID != nil {
		objectMap["targetResourceId"] = fli.TargetResourceID
	}
	if fli.FlowLogProperties != nil {
		objectMap["properties"] = fli.FlowLogProperties
	}
	if fli.FlowAnalyticsConfiguration != nil {
		objectMap["flowAnalyticsConfiguration"] = fli.FlowAnalyticsConfiguration
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FlowLogInformation struct.
func (fli *FlowLogInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetResourceId":
			if v != nil {
				var targetResourceID string
				err = json.Unmarshal(*v, &targetResourceID)
				if err != nil {
					return err
				}
				fli.TargetResourceID = &targetResourceID
			}
		case "properties":
			if v != nil {
				var flowLogProperties FlowLogProperties
				err = json.Unmarshal(*v, &flowLogProperties)
				if err != nil {
					return err
				}
				fli.FlowLogProperties = &flowLogProperties
			}
		case "flowAnalyticsConfiguration":
			if v != nil {
				var flowAnalyticsConfiguration TrafficAnalyticsProperties
				err = json.Unmarshal(*v, &flowAnalyticsConfiguration)
				if err != nil {
					return err
				}
				fli.FlowAnalyticsConfiguration = &flowAnalyticsConfiguration
			}
		}
	}

	return nil
}

// FlowLogListResult list of flow logs.
type FlowLogListResult struct {
	autorest.Response `json:"-"`
	// Value - Information about flow log resource.
	Value *[]FlowLog `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FlowLogListResult.
func (fllr FlowLogListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fllr.Value != nil {
		objectMap["value"] = fllr.Value
	}
	return json.Marshal(objectMap)
}

// FlowLogListResultIterator provides access to a complete listing of FlowLog values.
type FlowLogListResultIterator struct {
	i    int
	page FlowLogListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FlowLogListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FlowLogListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FlowLogListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FlowLogListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FlowLogListResultIterator) Response() FlowLogListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FlowLogListResultIterator) Value() FlowLog {
	if !iter.page.NotDone() {
		return FlowLog{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FlowLogListResultIterator type.
func NewFlowLogListResultIterator(page FlowLogListResultPage) FlowLogListResultIterator {
	return FlowLogListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fllr FlowLogListResult) IsEmpty() bool {
	return fllr.Value == nil || len(*fllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fllr FlowLogListResult) hasNextLink() bool {
	return fllr.NextLink != nil && len(*fllr.NextLink) != 0
}

// flowLogListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fllr FlowLogListResult) flowLogListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fllr.NextLink)))
}

// FlowLogListResultPage contains a page of FlowLog values.
type FlowLogListResultPage struct {
	fn   func(context.Context, FlowLogListResult) (FlowLogListResult, error)
	fllr FlowLogListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FlowLogListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FlowLogListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fllr)
		if err != nil {
			return err
		}
		page.fllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FlowLogListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FlowLogListResultPage) NotDone() bool {
	return !page.fllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FlowLogListResultPage) Response() FlowLogListResult {
	return page.fllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FlowLogListResultPage) Values() []FlowLog {
	if page.fllr.IsEmpty() {
		return nil
	}
	return *page.fllr.Value
}

// Creates a new instance of the FlowLogListResultPage type.
func NewFlowLogListResultPage(cur FlowLogListResult, getNextPage func(context.Context, FlowLogListResult) (FlowLogListResult, error)) FlowLogListResultPage {
	return FlowLogListResultPage{
		fn:   getNextPage,
		fllr: cur,
	}
}

// FlowLogProperties parameters that define the configuration of flow log.
type FlowLogProperties struct {
	// StorageID - ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`
	// Enabled - Flag to enable/disable flow logging.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
	// Format - Parameters that define the flow log format.
	Format *FlowLogFormatParameters `json:"format,omitempty"`
}

// FlowLogPropertiesFormat parameters that define the configuration of flow log.
type FlowLogPropertiesFormat struct {
	// TargetResourceID - ID of network security group to which flow log will be applied.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// TargetResourceGUID - READ-ONLY; Guid of network security group to which flow log will be applied.
	TargetResourceGUID *string `json:"targetResourceGuid,omitempty"`
	// StorageID - ID of the storage account which is used to store the flow log.
	StorageID *string `json:"storageId,omitempty"`
	// Enabled - Flag to enable/disable flow logging.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - Parameters that define the retention policy for flow log.
	RetentionPolicy *RetentionPolicyParameters `json:"retentionPolicy,omitempty"`
	// Format - Parameters that define the flow log format.
	Format *FlowLogFormatParameters `json:"format,omitempty"`
	// FlowAnalyticsConfiguration - Parameters that define the configuration of traffic analytics.
	FlowAnalyticsConfiguration *TrafficAnalyticsProperties `json:"flowAnalyticsConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the flow log. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FlowLogPropertiesFormat.
func (flpf FlowLogPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if flpf.TargetResourceID != nil {
		objectMap["targetResourceId"] = flpf.TargetResourceID
	}
	if flpf.StorageID != nil {
		objectMap["storageId"] = flpf.StorageID
	}
	if flpf.Enabled != nil {
		objectMap["enabled"] = flpf.Enabled
	}
	if flpf.RetentionPolicy != nil {
		objectMap["retentionPolicy"] = flpf.RetentionPolicy
	}
	if flpf.Format != nil {
		objectMap["format"] = flpf.Format
	}
	if flpf.FlowAnalyticsConfiguration != nil {
		objectMap["flowAnalyticsConfiguration"] = flpf.FlowAnalyticsConfiguration
	}
	return json.Marshal(objectMap)
}

// FlowLogsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FlowLogsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FlowLogsClient) (FlowLog, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FlowLogsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FlowLogsCreateOrUpdateFuture.Result.
func (future *FlowLogsCreateOrUpdateFuture) result(client FlowLogsClient) (fl FlowLog, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FlowLogsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fl.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FlowLogsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fl.Response.Response, err = future.GetResult(sender); err == nil && fl.Response.Response.StatusCode != http.StatusNoContent {
		fl, err = client.CreateOrUpdateResponder(fl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.FlowLogsCreateOrUpdateFuture", "Result", fl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FlowLogsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FlowLogsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FlowLogsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FlowLogsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FlowLogsDeleteFuture.Result.
func (future *FlowLogsDeleteFuture) result(client FlowLogsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.FlowLogsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.FlowLogsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FlowLogStatusParameters parameters that define a resource to query flow log and traffic analytics
// (optional) status.
type FlowLogStatusParameters struct {
	// TargetResourceID - The target resource where getting the flow log and traffic analytics (optional) status.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// FrontendIPConfiguration frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	autorest.Response `json:"-"`
	// FrontendIPConfigurationPropertiesFormat - Properties of the load balancer probe.
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// Zones - A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Zones != nil {
		objectMap["zones"] = fic.Zones
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fic.Type = &typeVar
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				fic.Zones = &zones
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// InboundNatRules - READ-ONLY; An array of references to inbound rules that use this frontend IP.
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - READ-ONLY; An array of references to inbound pools that use this frontend IP.
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundRules - READ-ONLY; An array of references to outbound rules that use this frontend IP.
	OutboundRules *[]SubResource `json:"outboundRules,omitempty"`
	// LoadBalancingRules - READ-ONLY; An array of references to load balancing rules that use this frontend IP.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The Private IP allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// Subnet - The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference to the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// PublicIPPrefix - The reference to the Public IP Prefix resource.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`
	// GatewayLoadBalancer - The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource `json:"gatewayLoadBalancer,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the frontend IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfigurationPropertiesFormat.
func (ficpf FrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ficpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = ficpf.PrivateIPAddress
	}
	if ficpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = ficpf.PrivateIPAllocationMethod
	}
	if ficpf.PrivateIPAddressVersion != "" {
		objectMap["privateIPAddressVersion"] = ficpf.PrivateIPAddressVersion
	}
	if ficpf.Subnet != nil {
		objectMap["subnet"] = ficpf.Subnet
	}
	if ficpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = ficpf.PublicIPAddress
	}
	if ficpf.PublicIPPrefix != nil {
		objectMap["publicIPPrefix"] = ficpf.PublicIPPrefix
	}
	if ficpf.GatewayLoadBalancer != nil {
		objectMap["gatewayLoadBalancer"] = ficpf.GatewayLoadBalancer
	}
	return json.Marshal(objectMap)
}

// GatewayCustomBgpIPAddressIPConfiguration gatewayCustomBgpIpAddressIpConfiguration for a virtual network
// gateway connection.
type GatewayCustomBgpIPAddressIPConfiguration struct {
	// IPConfigurationID - The IpconfigurationId of ipconfiguration which belongs to gateway.
	IPConfigurationID *string `json:"ipConfigurationId,omitempty"`
	// CustomBgpIPAddress - The custom BgpPeeringAddress which belongs to IpconfigurationId.
	CustomBgpIPAddress *string `json:"customBgpIpAddress,omitempty"`
}

// GatewayLoadBalancerTunnelInterface gateway load balancer tunnel interface of a load balancer backend
// address pool.
type GatewayLoadBalancerTunnelInterface struct {
	// Port - Port of gateway load balancer tunnel interface.
	Port *int32 `json:"port,omitempty"`
	// Identifier - Identifier of gateway load balancer tunnel interface.
	Identifier *int32 `json:"identifier,omitempty"`
	// Protocol - Protocol of gateway load balancer tunnel interface. Possible values include: 'GatewayLoadBalancerTunnelProtocolNone', 'GatewayLoadBalancerTunnelProtocolNative', 'GatewayLoadBalancerTunnelProtocolVXLAN'
	Protocol GatewayLoadBalancerTunnelProtocol `json:"protocol,omitempty"`
	// Type - Traffic type of gateway load balancer tunnel interface. Possible values include: 'GatewayLoadBalancerTunnelInterfaceTypeNone', 'GatewayLoadBalancerTunnelInterfaceTypeInternal', 'GatewayLoadBalancerTunnelInterfaceTypeExternal'
	Type GatewayLoadBalancerTunnelInterfaceType `json:"type,omitempty"`
}

// GatewayRoute gateway routing details.
type GatewayRoute struct {
	// LocalAddress - READ-ONLY; The gateway's local address.
	LocalAddress *string `json:"localAddress,omitempty"`
	// NetworkProperty - READ-ONLY; The route's network prefix.
	NetworkProperty *string `json:"network,omitempty"`
	// NextHop - READ-ONLY; The route's next hop.
	NextHop *string `json:"nextHop,omitempty"`
	// SourcePeer - READ-ONLY; The peer this route was learned from.
	SourcePeer *string `json:"sourcePeer,omitempty"`
	// Origin - READ-ONLY; The source this route was learned from.
	Origin *string `json:"origin,omitempty"`
	// AsPath - READ-ONLY; The route's AS path sequence.
	AsPath *string `json:"asPath,omitempty"`
	// Weight - READ-ONLY; The route's weight.
	Weight *int32 `json:"weight,omitempty"`
}

// MarshalJSON is the custom marshaler for GatewayRoute.
func (gr GatewayRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GatewayRouteListResult list of virtual network gateway routes.
type GatewayRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - List of gateway routes.
	Value *[]GatewayRoute `json:"value,omitempty"`
}

// GenerateExpressRoutePortsLOARequest the customer name to be printed on a letter of authorization.
type GenerateExpressRoutePortsLOARequest struct {
	// CustomerName - The customer name.
	CustomerName *string `json:"customerName,omitempty"`
}

// GenerateExpressRoutePortsLOAResult response for GenerateExpressRoutePortsLOA API service call.
type GenerateExpressRoutePortsLOAResult struct {
	autorest.Response `json:"-"`
	// EncodedContent - The content as a base64 encoded string.
	EncodedContent *string `json:"encodedContent,omitempty"`
}

// GeneratevirtualwanvpnserverconfigurationvpnprofileFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type GeneratevirtualwanvpnserverconfigurationvpnprofileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (VpnProfileResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GeneratevirtualwanvpnserverconfigurationvpnprofileFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GeneratevirtualwanvpnserverconfigurationvpnprofileFuture.Result.
func (future *GeneratevirtualwanvpnserverconfigurationvpnprofileFuture) result(client BaseClient) (vpr VpnProfileResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.GeneratevirtualwanvpnserverconfigurationvpnprofileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vpr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.GeneratevirtualwanvpnserverconfigurationvpnprofileFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vpr.Response.Response, err = future.GetResult(sender); err == nil && vpr.Response.Response.StatusCode != http.StatusNoContent {
		vpr, err = client.GeneratevirtualwanvpnserverconfigurationvpnprofileResponder(vpr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.GeneratevirtualwanvpnserverconfigurationvpnprofileFuture", "Result", vpr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GetActiveSessionsAllFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GetActiveSessionsAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (BastionActiveSessionListResultPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GetActiveSessionsAllFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GetActiveSessionsAllFuture.Result.
func (future *GetActiveSessionsAllFuture) result(client BaseClient) (baslrp BastionActiveSessionListResultPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.GetActiveSessionsAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		baslrp.baslr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.GetActiveSessionsAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if baslrp.baslr.Response.Response, err = future.GetResult(sender); err == nil && baslrp.baslr.Response.Response.StatusCode != http.StatusNoContent {
		baslrp, err = client.GetActiveSessionsResponder(baslrp.baslr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.GetActiveSessionsAllFuture", "Result", baslrp.baslr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GetActiveSessionsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GetActiveSessionsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (BastionActiveSessionListResultPage, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GetActiveSessionsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GetActiveSessionsFuture.Result.
func (future *GetActiveSessionsFuture) result(client BaseClient) (baslrp BastionActiveSessionListResultPage, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.GetActiveSessionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		baslrp.baslr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.GetActiveSessionsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if baslrp.baslr.Response.Response, err = future.GetResult(sender); err == nil && baslrp.baslr.Response.Response.StatusCode != http.StatusNoContent {
		baslrp, err = client.GetActiveSessionsResponder(baslrp.baslr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.GetActiveSessionsFuture", "Result", baslrp.baslr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GetInboundRoutesParameters the parameters specifying the connection resource whose inbound routes are
// being requested.
type GetInboundRoutesParameters struct {
	// ResourceURI - The connection resource whose inbound routes are being requested.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// ConnectionType - The type of the specified connection resource like ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
	ConnectionType *string `json:"connectionType,omitempty"`
}

// GetOutboundRoutesParameters the parameters specifying the connection resource whose outbound routes are
// being requested.
type GetOutboundRoutesParameters struct {
	// ResourceURI - The connection resource whose outbound routes are being requested.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// ConnectionType - The type of the specified connection resource like ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
	ConnectionType *string `json:"connectionType,omitempty"`
}

// GetVpnSitesConfigurationRequest list of Vpn-Sites.
type GetVpnSitesConfigurationRequest struct {
	// VpnSites - List of resource-ids of the vpn-sites for which config is to be downloaded.
	VpnSites *[]string `json:"vpnSites,omitempty"`
	// OutputBlobSasURL - The sas-url to download the configurations for vpn-sites.
	OutputBlobSasURL *string `json:"outputBlobSasUrl,omitempty"`
}

// Group the network group resource
type Group struct {
	autorest.Response `json:"-"`
	// GroupProperties - The Network Group properties
	*GroupProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.GroupProperties != nil {
		objectMap["properties"] = g.GroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				g.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				g.Etag = &etag
			}
		}
	}

	return nil
}

// GroupListResult result of the request to list NetworkGroup. It contains a list of groups and a URL link
// to get the next set of results.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a page of NetworkGroup
	Value *[]Group `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (glr GroupListResult) hasNextLink() bool {
	return glr.NextLink != nil && len(*glr.NextLink) != 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !glr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.glr)
		if err != nil {
			return err
		}
		page.glr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{
		fn:  getNextPage,
		glr: cur,
	}
}

// GroupProperties properties of network group
type GroupProperties struct {
	// Description - A description of the network group.
	Description *string `json:"description,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the scope assignment resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupProperties.
func (gp GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Description != nil {
		objectMap["description"] = gp.Description
	}
	return json.Marshal(objectMap)
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GroupsDeleteFuture.Result.
func (future *GroupsDeleteFuture) result(client GroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.GroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.GroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HopLink hop link.
type HopLink struct {
	// NextHopID - READ-ONLY; The ID of the next hop.
	NextHopID *string `json:"nextHopId,omitempty"`
	// LinkType - READ-ONLY; Link type.
	LinkType *string `json:"linkType,omitempty"`
	// HopLinkProperties - Hop link properties.
	*HopLinkProperties `json:"properties,omitempty"`
	// Issues - READ-ONLY; List of issues.
	Issues *[]ConnectivityIssue `json:"issues,omitempty"`
	// Context - READ-ONLY; Provides additional context on links.
	Context map[string]*string `json:"context"`
	// ResourceID - READ-ONLY; Resource ID.
	ResourceID *string `json:"resourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for HopLink.
func (hl HopLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hl.HopLinkProperties != nil {
		objectMap["properties"] = hl.HopLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HopLink struct.
func (hl *HopLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextHopId":
			if v != nil {
				var nextHopID string
				err = json.Unmarshal(*v, &nextHopID)
				if err != nil {
					return err
				}
				hl.NextHopID = &nextHopID
			}
		case "linkType":
			if v != nil {
				var linkType string
				err = json.Unmarshal(*v, &linkType)
				if err != nil {
					return err
				}
				hl.LinkType = &linkType
			}
		case "properties":
			if v != nil {
				var hopLinkProperties HopLinkProperties
				err = json.Unmarshal(*v, &hopLinkProperties)
				if err != nil {
					return err
				}
				hl.HopLinkProperties = &hopLinkProperties
			}
		case "issues":
			if v != nil {
				var issues []ConnectivityIssue
				err = json.Unmarshal(*v, &issues)
				if err != nil {
					return err
				}
				hl.Issues = &issues
			}
		case "context":
			if v != nil {
				var context map[string]*string
				err = json.Unmarshal(*v, &context)
				if err != nil {
					return err
				}
				hl.Context = context
			}
		case "resourceId":
			if v != nil {
				var resourceID string
				err = json.Unmarshal(*v, &resourceID)
				if err != nil {
					return err
				}
				hl.ResourceID = &resourceID
			}
		}
	}

	return nil
}

// HopLinkProperties hop link properties.
type HopLinkProperties struct {
	// RoundTripTimeMin - READ-ONLY; Minimum roundtrip time in milliseconds.
	RoundTripTimeMin *int64 `json:"roundTripTimeMin,omitempty"`
	// RoundTripTimeAvg - READ-ONLY; Average roundtrip time in milliseconds.
	RoundTripTimeAvg *int64 `json:"roundTripTimeAvg,omitempty"`
	// RoundTripTimeMax - READ-ONLY; Maximum roundtrip time in milliseconds.
	RoundTripTimeMax *int64 `json:"roundTripTimeMax,omitempty"`
}

// MarshalJSON is the custom marshaler for HopLinkProperties.
func (hlp HopLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HTTPConfiguration HTTP configuration of the connectivity check.
type HTTPConfiguration struct {
	// Method - HTTP method. Possible values include: 'HTTPMethodGet'
	Method HTTPMethod `json:"method,omitempty"`
	// Headers - List of HTTP headers.
	Headers *[]HTTPHeader `json:"headers,omitempty"`
	// ValidStatusCodes - Valid status codes.
	ValidStatusCodes *[]int32 `json:"validStatusCodes,omitempty"`
}

// HTTPHeader the HTTP header.
type HTTPHeader struct {
	// Name - The name in HTTP header.
	Name *string `json:"name,omitempty"`
	// Value - The value in HTTP header.
	Value *string `json:"value,omitempty"`
}

// Hub hub Item.
type Hub struct {
	// ResourceID - Resource Id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceType - Resource Type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// HubIPAddresses IP addresses associated with azure firewall.
type HubIPAddresses struct {
	// PublicIPs - Public IP addresses associated with azure firewall.
	PublicIPs *HubPublicIPAddresses `json:"publicIPs,omitempty"`
	// PrivateIPAddress - Private IP Address associated with azure firewall.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
}

// HubIPConfiguration ipConfigurations.
type HubIPConfiguration struct {
	autorest.Response `json:"-"`
	// HubIPConfigurationPropertiesFormat - The properties of the Virtual Hub IPConfigurations.
	*HubIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the Ip Configuration.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Ipconfiguration type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HubIPConfiguration.
func (hic HubIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hic.HubIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = hic.HubIPConfigurationPropertiesFormat
	}
	if hic.Name != nil {
		objectMap["name"] = hic.Name
	}
	if hic.ID != nil {
		objectMap["id"] = hic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HubIPConfiguration struct.
func (hic *HubIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hubIPConfigurationPropertiesFormat HubIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &hubIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				hic.HubIPConfigurationPropertiesFormat = &hubIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				hic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hic.ID = &ID
			}
		}
	}

	return nil
}

// HubIPConfigurationPropertiesFormat properties of IP configuration.
type HubIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference to the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference to the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the IP configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for HubIPConfigurationPropertiesFormat.
func (hicpf HubIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hicpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = hicpf.PrivateIPAddress
	}
	if hicpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = hicpf.PrivateIPAllocationMethod
	}
	if hicpf.Subnet != nil {
		objectMap["subnet"] = hicpf.Subnet
	}
	if hicpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = hicpf.PublicIPAddress
	}
	return json.Marshal(objectMap)
}

// HubPublicIPAddresses public IP addresses associated with azure firewall.
type HubPublicIPAddresses struct {
	// Addresses - The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
	Addresses *[]AzureFirewallPublicIPAddress `json:"addresses,omitempty"`
	// Count - The number of Public IP addresses associated with azure firewall.
	Count *int32 `json:"count,omitempty"`
}

// HubRoute routeTable route.
type HubRoute struct {
	// Name - The name of the Route that is unique within a RouteTable. This name can be used to access this route.
	Name *string `json:"name,omitempty"`
	// DestinationType - The type of destinations (eg: CIDR, ResourceId, Service).
	DestinationType *string `json:"destinationType,omitempty"`
	// Destinations - List of all destinations.
	Destinations *[]string `json:"destinations,omitempty"`
	// NextHopType - The type of next hop (eg: ResourceId).
	NextHopType *string `json:"nextHopType,omitempty"`
	// NextHop - NextHop resource ID.
	NextHop *string `json:"nextHop,omitempty"`
}

// HubRouteTable routeTable resource in a virtual hub.
type HubRouteTable struct {
	autorest.Response `json:"-"`
	// HubRouteTableProperties - Properties of the RouteTable resource.
	*HubRouteTableProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HubRouteTable.
func (hrt HubRouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hrt.HubRouteTableProperties != nil {
		objectMap["properties"] = hrt.HubRouteTableProperties
	}
	if hrt.Name != nil {
		objectMap["name"] = hrt.Name
	}
	if hrt.ID != nil {
		objectMap["id"] = hrt.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HubRouteTable struct.
func (hrt *HubRouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hubRouteTableProperties HubRouteTableProperties
				err = json.Unmarshal(*v, &hubRouteTableProperties)
				if err != nil {
					return err
				}
				hrt.HubRouteTableProperties = &hubRouteTableProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hrt.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				hrt.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hrt.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hrt.ID = &ID
			}
		}
	}

	return nil
}

// HubRouteTableProperties parameters for RouteTable.
type HubRouteTableProperties struct {
	// Routes - List of all routes.
	Routes *[]HubRoute `json:"routes,omitempty"`
	// Labels - List of labels associated with this route table.
	Labels *[]string `json:"labels,omitempty"`
	// AssociatedConnections - READ-ONLY; List of all connections associated with this route table.
	AssociatedConnections *[]string `json:"associatedConnections,omitempty"`
	// PropagatingConnections - READ-ONLY; List of all connections that advertise to this route table.
	PropagatingConnections *[]string `json:"propagatingConnections,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the RouteTable resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for HubRouteTableProperties.
func (hrtp HubRouteTableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hrtp.Routes != nil {
		objectMap["routes"] = hrtp.Routes
	}
	if hrtp.Labels != nil {
		objectMap["labels"] = hrtp.Labels
	}
	return json.Marshal(objectMap)
}

// HubRouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type HubRouteTablesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubRouteTablesClient) (HubRouteTable, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubRouteTablesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubRouteTablesCreateOrUpdateFuture.Result.
func (future *HubRouteTablesCreateOrUpdateFuture) result(client HubRouteTablesClient) (hrt HubRouteTable, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.HubRouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		hrt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.HubRouteTablesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if hrt.Response.Response, err = future.GetResult(sender); err == nil && hrt.Response.Response.StatusCode != http.StatusNoContent {
		hrt, err = client.CreateOrUpdateResponder(hrt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.HubRouteTablesCreateOrUpdateFuture", "Result", hrt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HubRouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type HubRouteTablesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubRouteTablesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubRouteTablesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubRouteTablesDeleteFuture.Result.
func (future *HubRouteTablesDeleteFuture) result(client HubRouteTablesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.HubRouteTablesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.HubRouteTablesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HubVirtualNetworkConnection hubVirtualNetworkConnection Resource.
type HubVirtualNetworkConnection struct {
	autorest.Response `json:"-"`
	// HubVirtualNetworkConnectionProperties - Properties of the hub virtual network connection.
	*HubVirtualNetworkConnectionProperties `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for HubVirtualNetworkConnection.
func (hvnc HubVirtualNetworkConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvnc.HubVirtualNetworkConnectionProperties != nil {
		objectMap["properties"] = hvnc.HubVirtualNetworkConnectionProperties
	}
	if hvnc.Name != nil {
		objectMap["name"] = hvnc.Name
	}
	if hvnc.ID != nil {
		objectMap["id"] = hvnc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HubVirtualNetworkConnection struct.
func (hvnc *HubVirtualNetworkConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hubVirtualNetworkConnectionProperties HubVirtualNetworkConnectionProperties
				err = json.Unmarshal(*v, &hubVirtualNetworkConnectionProperties)
				if err != nil {
					return err
				}
				hvnc.HubVirtualNetworkConnectionProperties = &hubVirtualNetworkConnectionProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hvnc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				hvnc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hvnc.ID = &ID
			}
		}
	}

	return nil
}

// HubVirtualNetworkConnectionProperties parameters for HubVirtualNetworkConnection.
type HubVirtualNetworkConnectionProperties struct {
	// RemoteVirtualNetwork - Reference to the remote virtual network.
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`
	// AllowHubToRemoteVnetTransit - Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
	AllowHubToRemoteVnetTransit *bool `json:"allowHubToRemoteVnetTransit,omitempty"`
	// AllowRemoteVnetToUseHubVnetGateways - Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
	AllowRemoteVnetToUseHubVnetGateways *bool `json:"allowRemoteVnetToUseHubVnetGateways,omitempty"`
	// EnableInternetSecurity - Enable internet security.
	EnableInternetSecurity *bool `json:"enableInternetSecurity,omitempty"`
	// RoutingConfiguration - The Routing Configuration indicating the associated and propagated route tables on this connection.
	RoutingConfiguration *RoutingConfiguration `json:"routingConfiguration,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the hub virtual network connection resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for HubVirtualNetworkConnectionProperties.
func (hvncp HubVirtualNetworkConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hvncp.RemoteVirtualNetwork != nil {
		objectMap["remoteVirtualNetwork"] = hvncp.RemoteVirtualNetwork
	}
	if hvncp.AllowHubToRemoteVnetTransit != nil {
		objectMap["allowHubToRemoteVnetTransit"] = hvncp.AllowHubToRemoteVnetTransit
	}
	if hvncp.AllowRemoteVnetToUseHubVnetGateways != nil {
		objectMap["allowRemoteVnetToUseHubVnetGateways"] = hvncp.AllowRemoteVnetToUseHubVnetGateways
	}
	if hvncp.EnableInternetSecurity != nil {
		objectMap["enableInternetSecurity"] = hvncp.EnableInternetSecurity
	}
	if hvncp.RoutingConfiguration != nil {
		objectMap["routingConfiguration"] = hvncp.RoutingConfiguration
	}
	return json.Marshal(objectMap)
}

// HubVirtualNetworkConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type HubVirtualNetworkConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubVirtualNetworkConnectionsClient) (HubVirtualNetworkConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubVirtualNetworkConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubVirtualNetworkConnectionsCreateOrUpdateFuture.Result.
func (future *HubVirtualNetworkConnectionsCreateOrUpdateFuture) result(client HubVirtualNetworkConnectionsClient) (hvnc HubVirtualNetworkConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.HubVirtualNetworkConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		hvnc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.HubVirtualNetworkConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if hvnc.Response.Response, err = future.GetResult(sender); err == nil && hvnc.Response.Response.StatusCode != http.StatusNoContent {
		hvnc, err = client.CreateOrUpdateResponder(hvnc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.HubVirtualNetworkConnectionsCreateOrUpdateFuture", "Result", hvnc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HubVirtualNetworkConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type HubVirtualNetworkConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubVirtualNetworkConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubVirtualNetworkConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubVirtualNetworkConnectionsDeleteFuture.Result.
func (future *HubVirtualNetworkConnectionsDeleteFuture) result(client HubVirtualNetworkConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.HubVirtualNetworkConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.HubVirtualNetworkConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IDPSQueryObject will describe the query to run against the IDPS signatures DB
type IDPSQueryObject struct {
	// Filters - Contain all filters names and values
	Filters *[]FilterItems `json:"filters,omitempty"`
	// Search - Search term in all columns
	Search *string `json:"search,omitempty"`
	// OrderBy - Column to sort response by
	OrderBy *OrderBy `json:"orderBy,omitempty"`
	// ResultsPerPage - The number of the results to return in each page
	ResultsPerPage *int32 `json:"resultsPerPage,omitempty"`
	// Skip - The number of records matching the filter to skip
	Skip *int32 `json:"skip,omitempty"`
}

// InboundNatPool inbound NAT pool of the load balancer.
type InboundNatPool struct {
	// InboundNatPoolPropertiesFormat - Properties of load balancer inbound nat pool.
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				inp.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatPoolPropertiesFormat properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - The reference to the transport protocol used by the inbound NAT pool. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the inbound NAT pool resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPoolPropertiesFormat.
func (inppf InboundNatPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inppf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = inppf.FrontendIPConfiguration
	}
	if inppf.Protocol != "" {
		objectMap["protocol"] = inppf.Protocol
	}
	if inppf.FrontendPortRangeStart != nil {
		objectMap["frontendPortRangeStart"] = inppf.FrontendPortRangeStart
	}
	if inppf.FrontendPortRangeEnd != nil {
		objectMap["frontendPortRangeEnd"] = inppf.FrontendPortRangeEnd
	}
	if inppf.BackendPort != nil {
		objectMap["backendPort"] = inppf.BackendPort
	}
	if inppf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = inppf.IdleTimeoutInMinutes
	}
	if inppf.EnableFloatingIP != nil {
		objectMap["enableFloatingIP"] = inppf.EnableFloatingIP
	}
	if inppf.EnableTCPReset != nil {
		objectMap["enableTcpReset"] = inppf.EnableTCPReset
	}
	return json.Marshal(objectMap)
}

// InboundNatRule inbound NAT rule of the load balancer.
type InboundNatRule struct {
	autorest.Response `json:"-"`
	// InboundNatRulePropertiesFormat - Properties of load balancer inbound NAT rule.
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				inr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatRuleListResult response for ListInboundNatRule API service call.
type InboundNatRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of inbound NAT rules in a load balancer.
	Value *[]InboundNatRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRuleListResult.
func (inrlr InboundNatRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inrlr.Value != nil {
		objectMap["value"] = inrlr.Value
	}
	return json.Marshal(objectMap)
}

// InboundNatRuleListResultIterator provides access to a complete listing of InboundNatRule values.
type InboundNatRuleListResultIterator struct {
	i    int
	page InboundNatRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InboundNatRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundNatRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InboundNatRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InboundNatRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InboundNatRuleListResultIterator) Response() InboundNatRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InboundNatRuleListResultIterator) Value() InboundNatRule {
	if !iter.page.NotDone() {
		return InboundNatRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InboundNatRuleListResultIterator type.
func NewInboundNatRuleListResultIterator(page InboundNatRuleListResultPage) InboundNatRuleListResultIterator {
	return InboundNatRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (inrlr InboundNatRuleListResult) IsEmpty() bool {
	return inrlr.Value == nil || len(*inrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (inrlr InboundNatRuleListResult) hasNextLink() bool {
	return inrlr.NextLink != nil && len(*inrlr.NextLink) != 0
}

// inboundNatRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (inrlr InboundNatRuleListResult) inboundNatRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !inrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(inrlr.NextLink)))
}

// InboundNatRuleListResultPage contains a page of InboundNatRule values.
type InboundNatRuleListResultPage struct {
	fn    func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)
	inrlr InboundNatRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InboundNatRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundNatRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.inrlr)
		if err != nil {
			return err
		}
		page.inrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InboundNatRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InboundNatRuleListResultPage) NotDone() bool {
	return !page.inrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InboundNatRuleListResultPage) Response() InboundNatRuleListResult {
	return page.inrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InboundNatRuleListResultPage) Values() []InboundNatRule {
	if page.inrlr.IsEmpty() {
		return nil
	}
	return *page.inrlr.Value
}

// Creates a new instance of the InboundNatRuleListResultPage type.
func NewInboundNatRuleListResultPage(cur InboundNatRuleListResult, getNextPage func(context.Context, InboundNatRuleListResult) (InboundNatRuleListResult, error)) InboundNatRuleListResultPage {
	return InboundNatRuleListResultPage{
		fn:    getNextPage,
		inrlr: cur,
	}
}

// InboundNatRulePortMapping individual port mappings for inbound NAT rule created for backend pool.
type InboundNatRulePortMapping struct {
	// InboundNatRuleName - READ-ONLY; Name of inbound NAT rule.
	InboundNatRuleName *string `json:"inboundNatRuleName,omitempty"`
	// Protocol - READ-ONLY; The reference to the transport protocol used by the inbound NAT rule. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - READ-ONLY; Frontend port.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - READ-ONLY; Backend port.
	BackendPort *int32 `json:"backendPort,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRulePortMapping.
func (inrpm InboundNatRulePortMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InboundNatRulePropertiesFormat properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - READ-ONLY; A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	// Protocol - The reference to the transport protocol used by the load balancing rule. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP', 'TransportProtocolAll'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// EnableTCPReset - Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`
	// FrontendPortRangeStart - The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendAddressPool - A reference to backendAddressPool resource.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the inbound NAT rule resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRulePropertiesFormat.
func (inrpf InboundNatRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inrpf.FrontendIPConfiguration != nil {
		objectMap["frontendIPConfiguration"] = inrpf.FrontendIPConfiguration
	}
	if inrpf.Protocol != "" {
		objectMap["protocol"] = inrpf.Protocol
	}
	if inrpf.FrontendPort != nil {
		objectMap["frontendPort"] = inrpf.FrontendPort
	}
	if inrpf.BackendPort != nil {
		objectMap["backendPort"] = inrpf.BackendPort
	}
	if inrpf.IdleTimeoutInMinutes != nil {
		objectMap["idleTimeoutInMinutes"] = inrpf.IdleTimeoutInMinutes
	}
	if inrpf.EnableFloatingIP != nil {
		objectMap["enableFloatingIP"] = inrpf.EnableFloatingIP
	}
	if inrpf.EnableTCPReset != nil {
		objectMap["enableTcpReset"] = inrpf.EnableTCPReset
	}
	if inrpf.FrontendPortRangeStart != nil {
		objectMap["frontendPortRangeStart"] = inrpf.FrontendPortRangeStart
	}
	if inrpf.FrontendPortRangeEnd != nil {
		objectMap["frontendPortRangeEnd"] = inrpf.FrontendPortRangeEnd
	}
	if inrpf.BackendAddressPool != nil {
		objectMap["backendAddressPool"] = inrpf.BackendAddressPool
	}
	return json.Marshal(objectMap)
}

// InboundNatRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InboundNatRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InboundNatRulesClient) (InboundNatRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InboundNatRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InboundNatRulesCreateOrUpdateFuture.Result.
func (future *InboundNatRulesCreateOrUpdateFuture) result(client InboundNatRulesClient) (inr InboundNatRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InboundNatRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		inr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InboundNatRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if inr.Response.Response, err = future.GetResult(sender); err == nil && inr.Response.Response.StatusCode != http.StatusNoContent {
		inr, err = client.CreateOrUpdateResponder(inr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InboundNatRulesCreateOrUpdateFuture", "Result", inr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InboundNatRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InboundNatRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InboundNatRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InboundNatRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InboundNatRulesDeleteFuture.Result.
func (future *InboundNatRulesDeleteFuture) result(client InboundNatRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InboundNatRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InboundNatRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InboundSecurityRule NVA Inbound Security Rule resource.
type InboundSecurityRule struct {
	autorest.Response `json:"-"`
	// InboundSecurityRuleProperties - The properties of the Inbound Security Rules.
	*InboundSecurityRuleProperties `json:"properties,omitempty"`
	// Name - Name of security rule collection.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; NVA inbound security rule type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundSecurityRule.
func (isr InboundSecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if isr.InboundSecurityRuleProperties != nil {
		objectMap["properties"] = isr.InboundSecurityRuleProperties
	}
	if isr.Name != nil {
		objectMap["name"] = isr.Name
	}
	if isr.ID != nil {
		objectMap["id"] = isr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundSecurityRule struct.
func (isr *InboundSecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundSecurityRuleProperties InboundSecurityRuleProperties
				err = json.Unmarshal(*v, &inboundSecurityRuleProperties)
				if err != nil {
					return err
				}
				isr.InboundSecurityRuleProperties = &inboundSecurityRuleProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				isr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				isr.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				isr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				isr.ID = &ID
			}
		}
	}

	return nil
}

// InboundSecurityRuleCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InboundSecurityRuleCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InboundSecurityRuleClient) (InboundSecurityRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InboundSecurityRuleCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InboundSecurityRuleCreateOrUpdateFuture.Result.
func (future *InboundSecurityRuleCreateOrUpdateFuture) result(client InboundSecurityRuleClient) (isr InboundSecurityRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InboundSecurityRuleCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		isr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InboundSecurityRuleCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if isr.Response.Response, err = future.GetResult(sender); err == nil && isr.Response.Response.StatusCode != http.StatusNoContent {
		isr, err = client.CreateOrUpdateResponder(isr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InboundSecurityRuleCreateOrUpdateFuture", "Result", isr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InboundSecurityRuleProperties properties of the Inbound Security Rules resource.
type InboundSecurityRuleProperties struct {
	// Rules - List of allowed rules.
	Rules *[]InboundSecurityRules `json:"rules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundSecurityRuleProperties.
func (isrp InboundSecurityRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if isrp.Rules != nil {
		objectMap["rules"] = isrp.Rules
	}
	return json.Marshal(objectMap)
}

// InboundSecurityRules properties of the Inbound Security Rules resource.
type InboundSecurityRules struct {
	// Protocol - Protocol. This should be either TCP or UDP. Possible values include: 'InboundSecurityRulesProtocolTCP', 'InboundSecurityRulesProtocolUDP'
	Protocol InboundSecurityRulesProtocol `json:"protocol,omitempty"`
	// SourceAddressPrefix - The CIDR or source IP range. Only /30, /31 and /32 Ip ranges are allowed.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationPortRange - NVA port ranges to be opened up. One needs to provide specific ports.
	DestinationPortRange *int32 `json:"destinationPortRange,omitempty"`
}

// IntentPolicy network Intent Policy resource.
type IntentPolicy struct {
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IntentPolicy.
func (IP IntentPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.ID != nil {
		objectMap["id"] = IP.ID
	}
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Tags != nil {
		objectMap["tags"] = IP.Tags
	}
	return json.Marshal(objectMap)
}

// IntentPolicyConfiguration details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.
type IntentPolicyConfiguration struct {
	// NetworkIntentPolicyName - The name of the Network Intent Policy for storing in target subscription.
	NetworkIntentPolicyName *string `json:"networkIntentPolicyName,omitempty"`
	// SourceNetworkIntentPolicy - Source network intent policy.
	SourceNetworkIntentPolicy *IntentPolicy `json:"sourceNetworkIntentPolicy,omitempty"`
}

// Interface a network interface in a resource group.
type Interface struct {
	autorest.Response `json:"-"`
	// ExtendedLocation - The extended location of the network interface.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// InterfacePropertiesFormat - Properties of the network interface.
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.ExtendedLocation != nil {
		objectMap["extendedLocation"] = i.ExtendedLocation
	}
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				i.ExtendedLocation = &extendedLocation
			}
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// InterfaceAssociation network interface and its custom security rules.
type InterfaceAssociation struct {
	// ID - READ-ONLY; Network interface ID.
	ID *string `json:"id,omitempty"`
	// SecurityRules - Collection of custom security rules.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceAssociation.
func (ia InterfaceAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ia.SecurityRules != nil {
		objectMap["securityRules"] = ia.SecurityRules
	}
	return json.Marshal(objectMap)
}

// InterfaceDNSSettings DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// DNSServers - List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - READ-ONLY; If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - READ-ONLY; Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
	// InternalDomainNameSuffix - READ-ONLY; Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceDNSSettings.
func (ids InterfaceDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ids.DNSServers != nil {
		objectMap["dnsServers"] = ids.DNSServers
	}
	if ids.InternalDNSNameLabel != nil {
		objectMap["internalDnsNameLabel"] = ids.InternalDNSNameLabel
	}
	return json.Marshal(objectMap)
}

// InterfaceIPConfiguration iPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	autorest.Response `json:"-"`
	// InterfaceIPConfigurationPropertiesFormat - Network interface IP configuration properties.
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Type != nil {
		objectMap["type"] = iic.Type
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iic.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceIPConfigurationListResult response for list ip configurations API service call.
type InterfaceIPConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ip configurations.
	Value *[]InterfaceIPConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfigurationListResult.
func (iiclr InterfaceIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iiclr.Value != nil {
		objectMap["value"] = iiclr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceIPConfigurationListResultIterator provides access to a complete listing of
// InterfaceIPConfiguration values.
type InterfaceIPConfigurationListResultIterator struct {
	i    int
	page InterfaceIPConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceIPConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceIPConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceIPConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceIPConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceIPConfigurationListResultIterator) Response() InterfaceIPConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceIPConfigurationListResultIterator) Value() InterfaceIPConfiguration {
	if !iter.page.NotDone() {
		return InterfaceIPConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceIPConfigurationListResultIterator type.
func NewInterfaceIPConfigurationListResultIterator(page InterfaceIPConfigurationListResultPage) InterfaceIPConfigurationListResultIterator {
	return InterfaceIPConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iiclr InterfaceIPConfigurationListResult) IsEmpty() bool {
	return iiclr.Value == nil || len(*iiclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iiclr InterfaceIPConfigurationListResult) hasNextLink() bool {
	return iiclr.NextLink != nil && len(*iiclr.NextLink) != 0
}

// interfaceIPConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iiclr InterfaceIPConfigurationListResult) interfaceIPConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iiclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iiclr.NextLink)))
}

// InterfaceIPConfigurationListResultPage contains a page of InterfaceIPConfiguration values.
type InterfaceIPConfigurationListResultPage struct {
	fn    func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)
	iiclr InterfaceIPConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceIPConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceIPConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iiclr)
		if err != nil {
			return err
		}
		page.iiclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceIPConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceIPConfigurationListResultPage) NotDone() bool {
	return !page.iiclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceIPConfigurationListResultPage) Response() InterfaceIPConfigurationListResult {
	return page.iiclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceIPConfigurationListResultPage) Values() []InterfaceIPConfiguration {
	if page.iiclr.IsEmpty() {
		return nil
	}
	return *page.iiclr.Value
}

// Creates a new instance of the InterfaceIPConfigurationListResultPage type.
func NewInterfaceIPConfigurationListResultPage(cur InterfaceIPConfigurationListResult, getNextPage func(context.Context, InterfaceIPConfigurationListResult) (InterfaceIPConfigurationListResult, error)) InterfaceIPConfigurationListResultPage {
	return InterfaceIPConfigurationListResultPage{
		fn:    getNextPage,
		iiclr: cur,
	}
}

// InterfaceIPConfigurationPrivateLinkConnectionProperties privateLinkConnection properties for the network
// interface.
type InterfaceIPConfigurationPrivateLinkConnectionProperties struct {
	// GroupID - READ-ONLY; The group ID for current private link connection.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMemberName - READ-ONLY; The required member name for current private link connection.
	RequiredMemberName *string `json:"requiredMemberName,omitempty"`
	// Fqdns - READ-ONLY; List of FQDNs for current private link connection.
	Fqdns *[]string `json:"fqdns,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfigurationPrivateLinkConnectionProperties.
func (iicplcp InterfaceIPConfigurationPrivateLinkConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// GatewayLoadBalancer - The reference to gateway load balancer frontend IP.
	GatewayLoadBalancer *SubResource `json:"gatewayLoadBalancer,omitempty"`
	// VirtualNetworkTaps - The reference to Virtual Network Taps.
	VirtualNetworkTaps *[]VirtualNetworkTap `json:"virtualNetworkTaps,omitempty"`
	// ApplicationGatewayBackendAddressPools - The reference to ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`
	// LoadBalancerBackendAddressPools - The reference to LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools *[]BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules *[]InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`
	// PrivateIPAddress - Private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// PrivateIPAddressVersion - Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4. Possible values include: 'IPv4', 'IPv6'
	PrivateIPAddressVersion IPVersion `json:"privateIPAddressVersion,omitempty"`
	// Subnet - Subnet bound to the IP configuration.
	Subnet *Subnet `json:"subnet,omitempty"`
	// Primary - Whether this is a primary customer address on the network interface.
	Primary *bool `json:"primary,omitempty"`
	// PublicIPAddress - Public IP address bound to the IP configuration.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ApplicationSecurityGroups - Application security groups in which the IP configuration is included.
	ApplicationSecurityGroups *[]ApplicationSecurityGroup `json:"applicationSecurityGroups,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network interface IP configuration. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateLinkConnectionProperties - READ-ONLY; PrivateLinkConnection properties for the network interface.
	PrivateLinkConnectionProperties *InterfaceIPConfigurationPrivateLinkConnectionProperties `json:"privateLinkConnectionProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfigurationPropertiesFormat.
func (iicpf InterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iicpf.GatewayLoadBalancer != nil {
		objectMap["gatewayLoadBalancer"] = iicpf.GatewayLoadBalancer
	}
	if iicpf.VirtualNetworkTaps != nil {
		objectMap["virtualNetworkTaps"] = iicpf.VirtualNetworkTaps
	}
	if iicpf.ApplicationGatewayBackendAddressPools != nil {
		objectMap["applicationGatewayBackendAddressPools"] = iicpf.ApplicationGatewayBackendAddressPools
	}
	if iicpf.LoadBalancerBackendAddressPools != nil {
		objectMap["loadBalancerBackendAddressPools"] = iicpf.LoadBalancerBackendAddressPools
	}
	if iicpf.LoadBalancerInboundNatRules != nil {
		objectMap["loadBalancerInboundNatRules"] = iicpf.LoadBalancerInboundNatRules
	}
	if iicpf.PrivateIPAddress != nil {
		objectMap["privateIPAddress"] = iicpf.PrivateIPAddress
	}
	if iicpf.PrivateIPAllocationMethod != "" {
		objectMap["privateIPAllocationMethod"] = iicpf.PrivateIPAllocationMethod
	}
	if iicpf.PrivateIPAddressVersion != "" {
		objectMap["privateIPAddressVersion"] = iicpf.PrivateIPAddressVersion
	}
	if iicpf.Subnet != nil {
		objectMap["subnet"] = iicpf.Subnet
	}
	if iicpf.Primary != nil {
		objectMap["primary"] = iicpf.Primary
	}
	if iicpf.PublicIPAddress != nil {
		objectMap["publicIPAddress"] = iicpf.PublicIPAddress
	}
	if iicpf.ApplicationSecurityGroups != nil {
		objectMap["applicationSecurityGroups"] = iicpf.ApplicationSecurityGroups
	}
	return json.Marshal(objectMap)
}

// InterfaceListResult response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network interfaces in a resource group.
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceListResult.
func (ilr InterfaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ilr.Value != nil {
		objectMap["value"] = ilr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceListResultIterator type.
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return InterfaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InterfaceListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(context.Context, InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InterfaceListResultPage type.
func NewInterfaceListResultPage(cur InterfaceListResult, getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return InterfaceListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// InterfaceLoadBalancerListResult response for list ip configurations API service call.
type InterfaceLoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancers.
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceLoadBalancerListResult.
func (ilblr InterfaceLoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ilblr.Value != nil {
		objectMap["value"] = ilblr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceLoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type InterfaceLoadBalancerListResultIterator struct {
	i    int
	page InterfaceLoadBalancerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceLoadBalancerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceLoadBalancerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceLoadBalancerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceLoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceLoadBalancerListResultIterator) Response() InterfaceLoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceLoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceLoadBalancerListResultIterator type.
func NewInterfaceLoadBalancerListResultIterator(page InterfaceLoadBalancerListResultPage) InterfaceLoadBalancerListResultIterator {
	return InterfaceLoadBalancerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilblr InterfaceLoadBalancerListResult) IsEmpty() bool {
	return ilblr.Value == nil || len(*ilblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilblr InterfaceLoadBalancerListResult) hasNextLink() bool {
	return ilblr.NextLink != nil && len(*ilblr.NextLink) != 0
}

// interfaceLoadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilblr InterfaceLoadBalancerListResult) interfaceLoadBalancerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilblr.NextLink)))
}

// InterfaceLoadBalancerListResultPage contains a page of LoadBalancer values.
type InterfaceLoadBalancerListResultPage struct {
	fn    func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)
	ilblr InterfaceLoadBalancerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceLoadBalancerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceLoadBalancerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilblr)
		if err != nil {
			return err
		}
		page.ilblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceLoadBalancerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceLoadBalancerListResultPage) NotDone() bool {
	return !page.ilblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceLoadBalancerListResultPage) Response() InterfaceLoadBalancerListResult {
	return page.ilblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceLoadBalancerListResultPage) Values() []LoadBalancer {
	if page.ilblr.IsEmpty() {
		return nil
	}
	return *page.ilblr.Value
}

// Creates a new instance of the InterfaceLoadBalancerListResultPage type.
func NewInterfaceLoadBalancerListResultPage(cur InterfaceLoadBalancerListResult, getNextPage func(context.Context, InterfaceLoadBalancerListResult) (InterfaceLoadBalancerListResult, error)) InterfaceLoadBalancerListResultPage {
	return InterfaceLoadBalancerListResultPage{
		fn:    getNextPage,
		ilblr: cur,
	}
}

// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - READ-ONLY; The reference to a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - The reference to the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// PrivateEndpoint - READ-ONLY; A reference to the private endpoint to which the network interface is linked.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// IPConfigurations - A list of IPConfigurations of the network interface.
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// TapConfigurations - READ-ONLY; A list of TapConfigurations of the network interface.
	TapConfigurations *[]InterfaceTapConfiguration `json:"tapConfigurations,omitempty"`
	// DNSSettings - The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - READ-ONLY; The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - READ-ONLY; Whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
	// VnetEncryptionSupported - READ-ONLY; Whether the virtual machine this nic is attached to supports encryption.
	VnetEncryptionSupported *bool `json:"vnetEncryptionSupported,omitempty"`
	// EnableAcceleratedNetworking - If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// DisableTCPStateTracking - Indicates whether to disable tcp state tracking.
	DisableTCPStateTracking *bool `json:"disableTcpStateTracking,omitempty"`
	// EnableIPForwarding - Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// HostedWorkloads - READ-ONLY; A list of references to linked BareMetal resources.
	HostedWorkloads *[]string `json:"hostedWorkloads,omitempty"`
	// DscpConfiguration - READ-ONLY; A reference to the dscp configuration to which the network interface is linked.
	DscpConfiguration *SubResource `json:"dscpConfiguration,omitempty"`
	// ResourceGUID - READ-ONLY; The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network interface resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// WorkloadType - WorkloadType of the NetworkInterface for BareMetal resources
	WorkloadType *string `json:"workloadType,omitempty"`
	// NicType - Type of Network Interface resource. Possible values include: 'Standard', 'Elastic'
	NicType InterfaceNicType `json:"nicType,omitempty"`
	// PrivateLinkService - Privatelinkservice of the network interface resource.
	PrivateLinkService *PrivateLinkService `json:"privateLinkService,omitempty"`
	// MigrationPhase - Migration phase of Network Interface resource. Possible values include: 'InterfaceMigrationPhaseNone', 'InterfaceMigrationPhasePrepare', 'InterfaceMigrationPhaseCommit', 'InterfaceMigrationPhaseAbort', 'InterfaceMigrationPhaseCommitted'
	MigrationPhase InterfaceMigrationPhase `json:"migrationPhase,omitempty"`
	// AuxiliaryMode - Auxiliary mode of Network Interface resource. Possible values include: 'InterfaceAuxiliaryModeNone', 'InterfaceAuxiliaryModeMaxConnections', 'InterfaceAuxiliaryModeFloating'
	AuxiliaryMode InterfaceAuxiliaryMode `json:"auxiliaryMode,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfacePropertiesFormat.
func (ipf InterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipf.NetworkSecurityGroup != nil {
		objectMap["networkSecurityGroup"] = ipf.NetworkSecurityGroup
	}
	if ipf.IPConfigurations != nil {
		objectMap["ipConfigurations"] = ipf.IPConfigurations
	}
	if ipf.DNSSettings != nil {
		objectMap["dnsSettings"] = ipf.DNSSettings
	}
	if ipf.EnableAcceleratedNetworking != nil {
		objectMap["enableAcceleratedNetworking"] = ipf.EnableAcceleratedNetworking
	}
	if ipf.DisableTCPStateTracking != nil {
		objectMap["disableTcpStateTracking"] = ipf.DisableTCPStateTracking
	}
	if ipf.EnableIPForwarding != nil {
		objectMap["enableIPForwarding"] = ipf.EnableIPForwarding
	}
	if ipf.WorkloadType != nil {
		objectMap["workloadType"] = ipf.WorkloadType
	}
	if ipf.NicType != "" {
		objectMap["nicType"] = ipf.NicType
	}
	if ipf.PrivateLinkService != nil {
		objectMap["privateLinkService"] = ipf.PrivateLinkService
	}
	if ipf.MigrationPhase != "" {
		objectMap["migrationPhase"] = ipf.MigrationPhase
	}
	if ipf.AuxiliaryMode != "" {
		objectMap["auxiliaryMode"] = ipf.AuxiliaryMode
	}
	return json.Marshal(objectMap)
}

// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (Interface, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfacesCreateOrUpdateFuture.Result.
func (future *InterfacesCreateOrUpdateFuture) result(client InterfacesClient) (i Interface, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		i.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if i.Response.Response, err = future.GetResult(sender); err == nil && i.Response.Response.StatusCode != http.StatusNoContent {
		i, err = client.CreateOrUpdateResponder(i.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", i.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfacesDeleteFuture.Result.
func (future *InterfacesDeleteFuture) result(client InterfacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InterfacesGetEffectiveRouteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesGetEffectiveRouteTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveRouteListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfacesGetEffectiveRouteTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfacesGetEffectiveRouteTableFuture.Result.
func (future *InterfacesGetEffectiveRouteTableFuture) result(client InterfacesClient) (erlr EffectiveRouteListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		erlr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfacesGetEffectiveRouteTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erlr.Response.Response, err = future.GetResult(sender); err == nil && erlr.Response.Response.StatusCode != http.StatusNoContent {
		erlr, err = client.GetEffectiveRouteTableResponder(erlr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesGetEffectiveRouteTableFuture", "Result", erlr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InterfacesListEffectiveNetworkSecurityGroupsFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InterfacesListEffectiveNetworkSecurityGroupsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfacesClient) (EffectiveNetworkSecurityGroupListResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfacesListEffectiveNetworkSecurityGroupsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfacesListEffectiveNetworkSecurityGroupsFuture.Result.
func (future *InterfacesListEffectiveNetworkSecurityGroupsFuture) result(client InterfacesClient) (ensglr EffectiveNetworkSecurityGroupListResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ensglr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfacesListEffectiveNetworkSecurityGroupsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ensglr.Response.Response, err = future.GetResult(sender); err == nil && ensglr.Response.Response.StatusCode != http.StatusNoContent {
		ensglr, err = client.ListEffectiveNetworkSecurityGroupsResponder(ensglr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesListEffectiveNetworkSecurityGroupsFuture", "Result", ensglr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InterfaceTapConfiguration tap configuration in a Network Interface.
type InterfaceTapConfiguration struct {
	autorest.Response `json:"-"`
	// InterfaceTapConfigurationPropertiesFormat - Properties of the Virtual Network Tap configuration.
	*InterfaceTapConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfiguration.
func (itc InterfaceTapConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itc.InterfaceTapConfigurationPropertiesFormat != nil {
		objectMap["properties"] = itc.InterfaceTapConfigurationPropertiesFormat
	}
	if itc.Name != nil {
		objectMap["name"] = itc.Name
	}
	if itc.ID != nil {
		objectMap["id"] = itc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceTapConfiguration struct.
func (itc *InterfaceTapConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceTapConfigurationPropertiesFormat InterfaceTapConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceTapConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				itc.InterfaceTapConfigurationPropertiesFormat = &interfaceTapConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				itc.Etag = &etag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itc.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itc.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceTapConfigurationListResult response for list tap configurations API service call.
type InterfaceTapConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of tap configurations.
	Value *[]InterfaceTapConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfigurationListResult.
func (itclr InterfaceTapConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itclr.Value != nil {
		objectMap["value"] = itclr.Value
	}
	return json.Marshal(objectMap)
}

// InterfaceTapConfigurationListResultIterator provides access to a complete listing of
// InterfaceTapConfiguration values.
type InterfaceTapConfigurationListResultIterator struct {
	i    int
	page InterfaceTapConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceTapConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceTapConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceTapConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceTapConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceTapConfigurationListResultIterator) Response() InterfaceTapConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceTapConfigurationListResultIterator) Value() InterfaceTapConfiguration {
	if !iter.page.NotDone() {
		return InterfaceTapConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceTapConfigurationListResultIterator type.
func NewInterfaceTapConfigurationListResultIterator(page InterfaceTapConfigurationListResultPage) InterfaceTapConfigurationListResultIterator {
	return InterfaceTapConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itclr InterfaceTapConfigurationListResult) IsEmpty() bool {
	return itclr.Value == nil || len(*itclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itclr InterfaceTapConfigurationListResult) hasNextLink() bool {
	return itclr.NextLink != nil && len(*itclr.NextLink) != 0
}

// interfaceTapConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itclr InterfaceTapConfigurationListResult) interfaceTapConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !itclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itclr.NextLink)))
}

// InterfaceTapConfigurationListResultPage contains a page of InterfaceTapConfiguration values.
type InterfaceTapConfigurationListResultPage struct {
	fn    func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)
	itclr InterfaceTapConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceTapConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceTapConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itclr)
		if err != nil {
			return err
		}
		page.itclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceTapConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceTapConfigurationListResultPage) NotDone() bool {
	return !page.itclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceTapConfigurationListResultPage) Response() InterfaceTapConfigurationListResult {
	return page.itclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceTapConfigurationListResultPage) Values() []InterfaceTapConfiguration {
	if page.itclr.IsEmpty() {
		return nil
	}
	return *page.itclr.Value
}

// Creates a new instance of the InterfaceTapConfigurationListResultPage type.
func NewInterfaceTapConfigurationListResultPage(cur InterfaceTapConfigurationListResult, getNextPage func(context.Context, InterfaceTapConfigurationListResult) (InterfaceTapConfigurationListResult, error)) InterfaceTapConfigurationListResultPage {
	return InterfaceTapConfigurationListResultPage{
		fn:    getNextPage,
		itclr: cur,
	}
}

// InterfaceTapConfigurationPropertiesFormat properties of Virtual Network Tap configuration.
type InterfaceTapConfigurationPropertiesFormat struct {
	// VirtualNetworkTap - The reference to the Virtual Network Tap resource.
	VirtualNetworkTap *VirtualNetworkTap `json:"virtualNetworkTap,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the network interface tap configuration resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceTapConfigurationPropertiesFormat.
func (itcpf InterfaceTapConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itcpf.VirtualNetworkTap != nil {
		objectMap["virtualNetworkTap"] = itcpf.VirtualNetworkTap
	}
	return json.Marshal(objectMap)
}

// InterfaceTapConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type InterfaceTapConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfaceTapConfigurationsClient) (InterfaceTapConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfaceTapConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfaceTapConfigurationsCreateOrUpdateFuture.Result.
func (future *InterfaceTapConfigurationsCreateOrUpdateFuture) result(client InterfaceTapConfigurationsClient) (itc InterfaceTapConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfaceTapConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		itc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfaceTapConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if itc.Response.Response, err = future.GetResult(sender); err == nil && itc.Response.Response.StatusCode != http.StatusNoContent {
		itc, err = client.CreateOrUpdateResponder(itc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfaceTapConfigurationsCreateOrUpdateFuture", "Result", itc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InterfaceTapConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfaceTapConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InterfaceTapConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InterfaceTapConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InterfaceTapConfigurationsDeleteFuture.Result.
func (future *InterfaceTapConfigurationsDeleteFuture) result(client InterfaceTapConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfaceTapConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("network.InterfaceTapConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IPAddressAvailabilityResult response for CheckIPAddressAvailability API service call.
type IPAddressAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Private IP address availability.
	Available *bool `json:"available,omitempty"`
	// AvailableIPAddresses - Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses *[]string `json:"availableIPAddresses,omitempty"`
	// IsPlatformReserved - Private IP address platform reserved.
	IsPlatformReserved *bool `json:"isPlatformReserved,omitempty"`
}

// IPAllocation ipAllocation resource.
type IPAllocation struct {
	autorest.Response `json:"-"`
	// IPAllocationPropertiesFormat - Properties of the IpAllocation.
	*IPAllocationPropertiesFormat `json:"properties,omitempty"`
	// Etag - READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IPAllocation.
func (ia IPAlloc