/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2020  Intel Corporation. All rights reserved.
 *
 */

#ifndef __packed
#define __packed __attribute__((packed))
#endif

struct bt_mcs_cp_rsp {
	uint8_t	op;
	uint8_t	result;
} __packed;

/* MCP Track Position */
#define BT_MCS_POSITION_UNAVAILABLE	((int32_t)0xffffffffu)
#define BT_MCS_DURATION_UNAVAILABLE	((int32_t)0xffffffffu)

/* MCP Media State */
#define BT_MCS_STATE_INACTIVE	0x00
#define BT_MCS_STATE_PLAYING	0x01
#define BT_MCS_STATE_PAUSED	0x02
#define BT_MCS_STATE_SEEKING	0x03

/* MCP Playing Order */
#define BT_MCS_ORDER_SINGLE_ONCE	0x01
#define BT_MCS_ORDER_SINGLE_REPEAT	0x02
#define BT_MCS_ORDER_IN_ORDER_ONCE	0x03
#define BT_MCS_ORDER_IN_ORDER_REPEAT	0x04
#define BT_MCS_ORDER_OLDEST_ONCE	0x05
#define BT_MCS_ORDER_OLDEST_REPEAT	0x06
#define BT_MCS_ORDER_NEWEST_ONCE	0x07
#define BT_MCS_ORDER_NEWEST_REPEAT	0x08
#define BT_MCS_ORDER_SHUFFLE_ONCE	0x09
#define BT_MCS_ORDER_SHUFFLE_REPEAT	0x0a

/* MCP Playing Order Supported */
#define BT_MCS_ORDER_SUPPORTED_SINGLE_ONCE	0x0001
#define BT_MCS_ORDER_SUPPORTED_SINGLE_REPEAT	0x0002
#define BT_MCS_ORDER_SUPPORTED_IN_ORDER_ONCE	0x0004
#define BT_MCS_ORDER_SUPPORTED_IN_ORDER_REPEAT	0x0008
#define BT_MCS_ORDER_SUPPORTED_OLDEST_ONCE	0x0010
#define BT_MCS_ORDER_SUPPORTED_OLDEST_REPEAT	0x0020
#define BT_MCS_ORDER_SUPPORTED_NEWEST_ONCE	0x0040
#define BT_MCS_ORDER_SUPPORTED_NEWEST_REPEAT	0x0080
#define BT_MCS_ORDER_SUPPORTED_SHUFFLE_ONCE	0x0100
#define BT_MCS_ORDER_SUPPORTED_SHUFFLE_REPEAT	0x0200

/* Control Point result codes */
#define BT_MCS_RESULT_SUCCESS			0x01
#define BT_MCS_RESULT_OP_NOT_SUPPORTED		0x02
#define BT_MCS_RESULT_MEDIA_PLAYER_INACTIVE	0x03
#define BT_MCS_RESULT_COMMAND_CANNOT_COMPLETE	0x04

/* MCP Control Point Opcodes */
#define BT_MCS_CMD_PLAY			    0x01
#define BT_MCS_CMD_PAUSE		    0x02
#define BT_MCS_CMD_FAST_REWIND	    0x03
#define BT_MCS_CMD_FAST_FORWARD	    0x04
#define BT_MCS_CMD_STOP			    0x05

#define BT_MCS_CMD_MOVE_RELATIVE    0x10

#define BT_MCS_CMD_PREV_SEGMENT     0x20
#define BT_MCS_CMD_NEXT_SEGMENT     0x21
#define BT_MCS_CMD_FIRST_SEGMENT    0x22
#define BT_MCS_CMD_LAST_SEGMENT     0x23
#define BT_MCS_CMD_GOTO_SEGMENT     0x24

#define BT_MCS_CMD_PREV_TRACK       0x30
#define BT_MCS_CMD_NEXT_TRACK       0x31
#define BT_MCS_CMD_FIRST_TRACK      0x32
#define BT_MCS_CMD_LAST_TRACK       0x33
#define BT_MCS_CMD_GOTO_TRACK       0x34

#define BT_MCS_CMD_PREV_GROUP       0x40
#define BT_MCS_CMD_NEXT_GROUP       0x41
#define BT_MCS_CMD_FIRST_GROUP      0x42
#define BT_MCS_CMD_LAST_GROUP       0x43
#define BT_MCS_CMD_GOTO_GROUP       0x44


/* MCP Control Point Opcodes Supported */
#define BT_MCS_CMD_PLAY_SUPPORTED		0x00000001
#define BT_MCS_CMD_PAUSE_SUPPORTED		0x00000002
#define BT_MCS_CMD_FAST_REWIND_SUPPORTED	0x00000004
#define BT_MCS_CMD_FAST_FORWARD_SUPPORTED	0x00000008
#define BT_MCS_CMD_STOP_SUPPORTED		0x00000010
#define BT_MCS_CMD_MOVE_RELATIVE_SUPPORTED	0x00000020
#define BT_MCS_CMD_PREV_SEGMENT_SUPPORTED	0x00000040
#define BT_MCS_CMD_NEXT_SEGMENT_SUPPORTED	0x00000080
#define BT_MCS_CMD_FIRST_SEGMENT_SUPPORTED	0x00000100
#define BT_MCS_CMD_LAST_SEGMENT_SUPPORTED	0x00000200
#define BT_MCS_CMD_GOTO_SEGMENT_SUPPORTED	0x00000400
#define BT_MCS_CMD_PREV_TRACK_SUPPORTED		0x00000800
#define BT_MCS_CMD_NEXT_TRACK_SUPPORTED		0x00001000
#define BT_MCS_CMD_FIRST_TRACK_SUPPORTED	0x00002000
#define BT_MCS_CMD_LAST_TRACK_SUPPORTED		0x00004000
#define BT_MCS_CMD_GOTO_TRACK_SUPPORTED		0x00008000
#define BT_MCS_CMD_PREV_GROUP_SUPPORTED		0x00010000
#define BT_MCS_CMD_NEXT_GROUP_SUPPORTED		0x00020000
#define BT_MCS_CMD_FIRST_GROUP_SUPPORTED	0x00040000
#define BT_MCS_CMD_LAST_GROUP_SUPPORTED		0x00080000
#define BT_MCS_CMD_GOTO_GROUP_SUPPORTED		0x00100000
