/*
 * Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLER
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: js.c,v 1.1 2009/02/24 09:36:15 nishida Exp $
 */
/*
 * Paper size selection code is based on psutil.c by Angus J. C. Duggan
 */

#include "mgp.h"

/*------------------------------------------------------------*/

int
main(argc, argv)
	int argc;
	char **argv;
{
	u_int opt;
	extern char *optarg;
	extern int optind;
	char *progname;
	static char pathbuf[MAXPATHLEN];

	progname = argv[0];

	while ((opt = getopt(argc, argv, "mciVrf:x:y:p:e:X:Ptg:")) != -1) {
		switch (opt) {
#if 0
		case 'm':         /* Added by Arnd Schmitter 23.07.2004 */
		  PauseMode=1;
		  break;
		case 'c':
			colorps++;
			break;

		case 'i':
			painticon++;
			break;

		case 'f':
			strcpy(outputfile, optarg);
			break;

		case 'r':
			reverse = 1;
			break;

		case 'V':
			mgp_flag |= FL_VERBOSE;
			break;

		case 'x':
			paper_xmargin = atoi(optarg);
			break;

		case 'y':
			paper_ymargin = atoi(optarg);
			break;

		case 'p':
			paper = findpaper(optarg);
			if (!paper) {
				fprintf(stderr,
"Paper size '%s' not recognised. Using %s instead.\n",
					optarg, DEFAULT_PAPER_SIZE);
				paper = findpaper(DEFAULT_PAPER_SIZE);
			}
			break;

		case 'e':
			for (encoding = &encodings[0];
			     encoding->name;
			     encoding++) {
				if (strcmp(encoding->name, optarg) == 0)
					break;
			}
			if (!encoding->name) {
				fprintf(stderr, "unknown encoding %s\n", optarg);
				exit(1);
			}
			break;

		case 'P':
			parse_debug++;
			break;

		case 't':
#ifdef FREETYPE
			usetfont = 1;
#else
			fprintf(stderr, "you can't use this function with this version\n");
			exit(-1);
#endif
			break;

       case 'X':
			if (strcmp(optarg, "freetype") == 0)
				mgp_flag |= FL_NOFREETYPE;
			else {
				fprintf(stderr, "unknown rendering engine %s\n", optarg);
			}
			break;

		case 'g':
			gaplevel = atoi(optarg);
			break;

		default:
			print_usage(progname);
			/*NOTREACHED*/
		}
#endif
	}

	argc -= optind;
	argv += optind;

#if 0
	if (argc != 1) {
		print_usage(progname);
		/*NOTREACHED*/
	}
#endif

	mgp_fname = argv[0];

//	init_win1(NULL);
	load_file(mgp_fname);
//	init_win2();
	fore = 0UL;
	back = (1UL << depth) - 1;
//	print_out();

	exit(0);
}

static struct fontmap *
findfont(ctrl, lang, font)
	int ctrl;
	int lang;
	char *font;
{
	struct fontmap *p, *q;
	char *star;

	if (!font[0])
		return NULL;

#ifdef FREETYPE
	if (mgp_flag & FL_NOFREETYPE && ctrl == CTL_TFONT)
		return NULL;
	if (lang == ASCII && usetfont)
		if ((p = findttfont(ctrl, lang, font))) goto found;
#endif

	for (p = fontmap; 0 <= p->ctrl; p++) {
		if (p->ctrl != ctrl || p->lang != lang)
			continue;
		star = strchr(p->font, '*');
		if (!star && strcmp(p->font, font) == 0)
			goto found;
		if (star && strncmp(p->font, font, star - p->font) == 0)
		{
			if(strcmp(font,"k14")==0)
				goto found;
			if(ctrl ==CTL_PSFONT)
				fprintf(stderr,"PSFONT: %s  not found\n",font);  
			goto found;
		}
	}
	return NULL;

found:
	if (p->fontid)
		return p;

	p->fontid = ++maxfontid;

	if (mgp_flag & FL_VERBOSE) {
		char fonttype;

		switch (ctrl) {
#ifdef FREETYPE
		case CTL_TFONT: fonttype = 't'; break;
#endif
#ifdef VFLIB
		case CTL_VFONT: fonttype = 'v'; break;
#endif
#if 0
		case CTL_XFONT: fonttype = 'x'; break;
#endif
		case CTL_XFONT2: fonttype = 'x'; break;
		
		case CTL_PSFONT: fonttype = 'p'; break;
		default:	fonttype = '?'; break;
		}
		fprintf(fp, "%% %cfont \"%s\" seen, mapped to ps font \"%s\"\n",
			fonttype, font, p->psfont);
		if (strcmp(font, p->font) != 0) {
			fprintf(fp, "%%\t(wildcard match against \"%s\")\n",
				p->font);
		}
	}
	/* use the same font index for same PS font names */
	for (q = fontmap; 0 <= q->ctrl; q++) {
		if (strcmp(p->psfont, q->psfont) == 0)
			q->fontid = maxfontid;
	}

	return p;
}

static char *
fontstring(font)
	struct fontmap *font;
{
	static char fontname[10];

	sprintf(fontname, "F%03d", font->fontid);
	return fontname;
}

static void
loadfont(font, name)
	struct fontmap *font;
	char *name;
{
	if (!font) {
		fprintf(stderr, "unable to find proper font for %s\n", name);
		exit(1);
	}

	if (font->loaded)
		return;

	/* define font calling sequence */
	if (mgp_flag & FL_VERBOSE) {
		fprintf(fp, "%% loading font \"%s\" for %s\n",
			font->psfont, font->font);
	}
	if (font->lang == ASCII && encoding) {
		/*
		 * Symbol font does not need latin1-encoding
		 */
		if (strcmp(font->psfont, "Symbol") == 0) {
			fprintf(fp,
				"/%s%s\n"
				"	/%s findfont\n"
				"		dup length dict begin\n"
				"		{1 index /FID ne {def} {pop "
				"pop} ifelse} forall\n"
				"	currentdict end\n"
				"definefont pop\n",
				fontstring(font), "t", font->psfont);
		} else {
			fprintf(fp,
"/%s%s\n"
"	/%s findfont\n"
"		dup length dict begin\n"
"		{1 index /FID ne {def} {pop pop} ifelse} forall\n"
"		/Encoding %s def\n"
"	currentdict end\n"
"definefont pop\n",
			fontstring(font), "t", font->psfont, encoding->defstr);
		}

		fprintf(fp, "/%s {/%s%s findfont exch scalefont setfont} def\n",
			fontstring(font), fontstring(font), "t");
	} else {
		fprintf(fp, "/%s {/%s findfont exch scalefont setfont} def\n",
			fontstring(font), font->psfont);
	}
	font->loaded = 1;
}

void
cleanup(int sig)
{
	/* dummy */
}

#ifdef FREETYPE
/* 
	get fontname from ttffile for ttfps 
 */
static struct fontmap *
findttfont(ctrl, lang, font)
	int ctrl;
	int lang;
	char *font;
{
	TT_Error	error;
	TT_Face		face; 
	TT_Face_Properties	properties;
	u_short		platform, encoding, language, id;
	u_short		string_len;
	struct 		fontmap	*pfont;
	char		*string;
	char		pathname[256];
	int			i, n, found = 0;
	static TT_Engine	engine;
	static int	initdone = 0, findex = 0; 
	static struct fontmap	**loadedfont;

	if (!font) return NULL;

	/* already registed? */
	for (i = 0; i < findex; i ++){
		if (!strcmp(font, loadedfont[i]->font)) 
			return loadedfont[i];
	}

	if (!initdone){
		/* Initialize engine */
		if ((error = TT_Init_FreeType(&engine))){
			fprintf(stderr, "Error while initializing engine, code = %d.\n",
				(int)error);
				exit(-1);
		}
		initdone ++;
	}
	error = TT_Open_Face(engine, font, &face);
	if (error) {
		/* add freetypefontdir and try again */
		snprintf(pathname, sizeof(pathname), "%s/%s", freetypefontdir, font);
		error = TT_Open_Face(engine, pathname, &face);
		if (error) return NULL;
	}

	TT_Get_Face_Properties(face, &properties);
	n = properties.num_Names;
	for (i = 0; i < n; i++) {
		TT_Get_Name_ID(face, i, &platform, &encoding, &language, &id);
		TT_Get_Name_String(face, i, &string, &string_len);
		/* this check may be weak.. */
		if (*string && id == 6){
			found = 1;
			break;
		}
	}
	if (!found) return NULL;

	/* create fontmap */
	pfont = (struct fontmap *)malloc(sizeof(struct fontmap));
	pfont->ctrl = ctrl;
	pfont->lang = lang;
	pfont->font = font;
	pfont->psfont = strdup(string);
	pfont->fontid = 0;
	pfont->loaded = 0;

	/* regist loaded font */
	if (!findex)
		loadedfont = (struct fontmap **)malloc(sizeof(struct fontmap *));
	else
		loadedfont = (struct fontmap **)realloc(loadedfont, 
								sizeof(struct fontmap *) * (findex +1));
	loadedfont[findex++] = pfont;

	return pfont;
}
#endif /* FREETYPE */

