// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhubrefactorspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateApplication
func (c *MigrationHubRefactorSpaces) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Migration Hub Refactor Spaces.
//
// Creates an Amazon Web Services Migration Hub Refactor Spaces application.
// The account that owns the environment also owns the applications created
// inside the environment, regardless of the account that creates the application.
// Refactor Spaces provisions the Amazon API Gateway and Network Load Balancer
// for the application proxy inside your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateApplication
func (c *MigrationHubRefactorSpaces) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEnvironmentRequest method.
//    req, resp := client.CreateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateEnvironment
func (c *MigrationHubRefactorSpaces) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/environments",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for AWS Migration Hub Refactor Spaces.
//
// Creates an Amazon Web Services Migration Hub Refactor Spaces environment.
// The caller owns the environment resource, and they are referred to as the
// environment owner. The environment owner has cross-account visibility and
// control of Refactor Spaces resources that are added to the environment by
// other accounts that the environment is shared with. When creating an environment,
// Refactor Spaces provisions a transit gateway in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateEnvironment
func (c *MigrationHubRefactorSpaces) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRouteRequest method.
//    req, resp := client.CreateRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateRoute
func (c *MigrationHubRefactorSpaces) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for AWS Migration Hub Refactor Spaces.
//
// Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account
// owner of the service resource is always the environment owner, regardless
// of which account creates the route. Routes target a service in the application.
// If an application does not have any routes, then the first route must be
// created as a DEFAULT RouteType.
//
// When you create a route, Refactor Spaces configures the Amazon API Gateway
// to send traffic to the target service as follows:
//
//    * If the service has a URL endpoint, and the endpoint resolves to a private
//    IP address, Refactor Spaces routes traffic using the API Gateway VPC link.
//
//    * If the service has a URL endpoint, and the endpoint resolves to a public
//    IP address, Refactor Spaces routes traffic over the public internet.
//
//    * If the service has an Lambda function endpoint, then Refactor Spaces
//    uses the API Gateway Lambda integration.
//
// A health check is performed on the service when the route is created. If
// the health check fails, the route transitions to FAILED, and no traffic is
// sent to the service.
//
// For Lambda functions, the Lambda function state is checked. If the function
// is not active, the function configuration is updated so that Lambda resources
// are provisioned. If the Lambda state is Failed, then the route creation fails.
// For more information, see the GetFunctionConfiguration's State response parameter
// (https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State)
// in the Lambda Developer Guide.
//
// For public URLs, a connection is opened to the public endpoint. If the URL
// is not reachable, the health check fails. For private URLs, a target group
// is created and the target group health check is run.
//
// The HealthCheckProtocol, HealthCheckPort, and HealthCheckPath are the same
// protocol, port, and path specified in the URL or health URL, if used. All
// other settings use the default values, as described in Health checks for
// your target groups (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html).
// The health check is considered successful if at least one target within the
// target group transitions to a healthy state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation CreateRoute for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateRoute
func (c *MigrationHubRefactorSpaces) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServiceRequest method.
//    req, resp := client.CreateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateService
func (c *MigrationHubRefactorSpaces) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for AWS Migration Hub Refactor Spaces.
//
// Creates an Amazon Web Services Migration Hub Refactor Spaces service. The
// account owner of the service is always the environment owner, regardless
// of which account in the environment creates the service. Services have either
// a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.
//
// If an Amazon Web Services resourceis launched in a service VPC, and you want
// it to be accessible to all of an environment’s services with VPCs and routes,
// apply the RefactorSpacesSecurityGroup to the resource. Alternatively, to
// add more cross-account constraints, apply your own security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/CreateService
func (c *MigrationHubRefactorSpaces) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteApplication
func (c *MigrationHubRefactorSpaces) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplication API operation for AWS Migration Hub Refactor Spaces.
//
// Deletes an Amazon Web Services Migration Hub Refactor Spaces application.
// Before you can delete an application, you must first delete any services
// or routes within the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteApplication
func (c *MigrationHubRefactorSpaces) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEnvironmentRequest method.
//    req, resp := client.DeleteEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteEnvironment
func (c *MigrationHubRefactorSpaces) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{EnvironmentIdentifier}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironment API operation for AWS Migration Hub Refactor Spaces.
//
// Deletes an Amazon Web Services Migration Hub Refactor Spaces environment.
// Before you can delete an environment, you must first delete any applications
// and services within the environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteEnvironment
func (c *MigrationHubRefactorSpaces) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourcePolicyRequest method.
//    req, resp := client.DeleteResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteResourcePolicy
func (c *MigrationHubRefactorSpaces) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resourcepolicy/{Identifier}",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for AWS Migration Hub Refactor Spaces.
//
// Deletes the resource policy set for the environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteResourcePolicy
func (c *MigrationHubRefactorSpaces) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRouteRequest method.
//    req, resp := client.DeleteRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteRoute
func (c *MigrationHubRefactorSpaces) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes/{RouteIdentifier}",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRoute API operation for AWS Migration Hub Refactor Spaces.
//
// Deletes an Amazon Web Services Migration Hub Refactor Spaces route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation DeleteRoute for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteRoute
func (c *MigrationHubRefactorSpaces) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceRequest method.
//    req, resp := client.DeleteServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteService
func (c *MigrationHubRefactorSpaces) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services/{ServiceIdentifier}",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for AWS Migration Hub Refactor Spaces.
//
// Deletes an Amazon Web Services Migration Hub Refactor Spaces service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/DeleteService
func (c *MigrationHubRefactorSpaces) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationRequest method.
//    req, resp := client.GetApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetApplication
func (c *MigrationHubRefactorSpaces) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWS Migration Hub Refactor Spaces.
//
// Gets an Amazon Web Services Migration Hub Refactor Spaces application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetApplication
func (c *MigrationHubRefactorSpaces) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnvironmentRequest method.
//    req, resp := client.GetEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetEnvironment
func (c *MigrationHubRefactorSpaces) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for AWS Migration Hub Refactor Spaces.
//
// Gets an Amazon Web Services Migration Hub Refactor Spaces environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetEnvironment
func (c *MigrationHubRefactorSpaces) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcePolicyRequest method.
//    req, resp := client.GetResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetResourcePolicy
func (c *MigrationHubRefactorSpaces) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/resourcepolicy/{Identifier}",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for AWS Migration Hub Refactor Spaces.
//
// Gets the resource-based permission policy that is set for the given environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetResourcePolicy
func (c *MigrationHubRefactorSpaces) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoute = "GetRoute"

// GetRouteRequest generates a "aws/request.Request" representing the
// client's request for the GetRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoute for more information on using the GetRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRouteRequest method.
//    req, resp := client.GetRouteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetRoute
func (c *MigrationHubRefactorSpaces) GetRouteRequest(input *GetRouteInput) (req *request.Request, output *GetRouteOutput) {
	op := &request.Operation{
		Name:       opGetRoute,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes/{RouteIdentifier}",
	}

	if input == nil {
		input = &GetRouteInput{}
	}

	output = &GetRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoute API operation for AWS Migration Hub Refactor Spaces.
//
// Gets an Amazon Web Services Migration Hub Refactor Spaces route.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation GetRoute for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetRoute
func (c *MigrationHubRefactorSpaces) GetRoute(input *GetRouteInput) (*GetRouteOutput, error) {
	req, out := c.GetRouteRequest(input)
	return out, req.Send()
}

// GetRouteWithContext is the same as GetRoute with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) GetRouteWithContext(ctx aws.Context, input *GetRouteInput, opts ...request.Option) (*GetRouteOutput, error) {
	req, out := c.GetRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRequest method.
//    req, resp := client.GetServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetService
func (c *MigrationHubRefactorSpaces) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services/{ServiceIdentifier}",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for AWS Migration Hub Refactor Spaces.
//
// Gets an Amazon Web Services Migration Hub Refactor Spaces service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation GetService for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/GetService
func (c *MigrationHubRefactorSpaces) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListApplications
func (c *MigrationHubRefactorSpaces) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS Migration Hub Refactor Spaces.
//
// Lists all the Amazon Web Services Migration Hub Refactor Spaces applications
// within an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListApplications
func (c *MigrationHubRefactorSpaces) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *migrationhubrefactorspaces.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MigrationHubRefactorSpaces) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentVpcs = "ListEnvironmentVpcs"

// ListEnvironmentVpcsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentVpcs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentVpcs for more information on using the ListEnvironmentVpcs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnvironmentVpcsRequest method.
//    req, resp := client.ListEnvironmentVpcsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListEnvironmentVpcs
func (c *MigrationHubRefactorSpaces) ListEnvironmentVpcsRequest(input *ListEnvironmentVpcsInput) (req *request.Request, output *ListEnvironmentVpcsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentVpcs,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/vpcs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentVpcsInput{}
	}

	output = &ListEnvironmentVpcsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentVpcs API operation for AWS Migration Hub Refactor Spaces.
//
// Lists all the virtual private clouds (VPCs) that are part of an Amazon Web
// Services Migration Hub Refactor Spaces environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListEnvironmentVpcs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListEnvironmentVpcs
func (c *MigrationHubRefactorSpaces) ListEnvironmentVpcs(input *ListEnvironmentVpcsInput) (*ListEnvironmentVpcsOutput, error) {
	req, out := c.ListEnvironmentVpcsRequest(input)
	return out, req.Send()
}

// ListEnvironmentVpcsWithContext is the same as ListEnvironmentVpcs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentVpcs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListEnvironmentVpcsWithContext(ctx aws.Context, input *ListEnvironmentVpcsInput, opts ...request.Option) (*ListEnvironmentVpcsOutput, error) {
	req, out := c.ListEnvironmentVpcsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentVpcsPages iterates over the pages of a ListEnvironmentVpcs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentVpcs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnvironmentVpcs operation.
//    pageNum := 0
//    err := client.ListEnvironmentVpcsPages(params,
//        func(page *migrationhubrefactorspaces.ListEnvironmentVpcsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MigrationHubRefactorSpaces) ListEnvironmentVpcsPages(input *ListEnvironmentVpcsInput, fn func(*ListEnvironmentVpcsOutput, bool) bool) error {
	return c.ListEnvironmentVpcsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentVpcsPagesWithContext same as ListEnvironmentVpcsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListEnvironmentVpcsPagesWithContext(ctx aws.Context, input *ListEnvironmentVpcsInput, fn func(*ListEnvironmentVpcsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentVpcsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentVpcsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentVpcsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnvironmentsRequest method.
//    req, resp := client.ListEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListEnvironments
func (c *MigrationHubRefactorSpaces) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for AWS Migration Hub Refactor Spaces.
//
// Lists Amazon Web Services Migration Hub Refactor Spaces environments owned
// by a caller account or shared with the caller account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListEnvironments
func (c *MigrationHubRefactorSpaces) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnvironments operation.
//    pageNum := 0
//    err := client.ListEnvironmentsPages(params,
//        func(page *migrationhubrefactorspaces.ListEnvironmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MigrationHubRefactorSpaces) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutes = "ListRoutes"

// ListRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutes for more information on using the ListRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutesRequest method.
//    req, resp := client.ListRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListRoutes
func (c *MigrationHubRefactorSpaces) ListRoutesRequest(input *ListRoutesInput) (req *request.Request, output *ListRoutesOutput) {
	op := &request.Operation{
		Name:       opListRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/routes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutesInput{}
	}

	output = &ListRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutes API operation for AWS Migration Hub Refactor Spaces.
//
// Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListRoutes for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListRoutes
func (c *MigrationHubRefactorSpaces) ListRoutes(input *ListRoutesInput) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	return out, req.Send()
}

// ListRoutesWithContext is the same as ListRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListRoutesWithContext(ctx aws.Context, input *ListRoutesInput, opts ...request.Option) (*ListRoutesOutput, error) {
	req, out := c.ListRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutesPages iterates over the pages of a ListRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoutes operation.
//    pageNum := 0
//    err := client.ListRoutesPages(params,
//        func(page *migrationhubrefactorspaces.ListRoutesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MigrationHubRefactorSpaces) ListRoutesPages(input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool) error {
	return c.ListRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutesPagesWithContext same as ListRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListRoutesPagesWithContext(ctx aws.Context, input *ListRoutesInput, fn func(*ListRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListServices
func (c *MigrationHubRefactorSpaces) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{EnvironmentIdentifier}/applications/{ApplicationIdentifier}/services",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for AWS Migration Hub Refactor Spaces.
//
// Lists all the Amazon Web Services Migration Hub Refactor Spaces services
// within an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ServiceQuotaExceededException
//   The request would cause a service quota to be exceeded.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListServices
func (c *MigrationHubRefactorSpaces) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *migrationhubrefactorspaces.ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MigrationHubRefactorSpaces) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListTagsForResource
func (c *MigrationHubRefactorSpaces) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Migration Hub Refactor Spaces.
//
// Lists the tags of a resource. The caller account must be the same as the
// resource’s OwnerAccountId. Listing tags in other accounts is not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/ListTagsForResource
func (c *MigrationHubRefactorSpaces) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourcePolicyRequest method.
//    req, resp := client.PutResourcePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/PutResourcePolicy
func (c *MigrationHubRefactorSpaces) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/resourcepolicy",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourcePolicy API operation for AWS Migration Hub Refactor Spaces.
//
// Attaches a resource-based permission policy to the Amazon Web Services Migration
// Hub Refactor Spaces environment. The policy must contain the same actions
// and condition statements as the arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment
// permission in Resource Access Manager. The policy must not contain new lines
// or blank lines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * InvalidResourcePolicyException
//   The resource policy is not valid.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
//   * ThrottlingException
//   Request was denied because the request was throttled.
//
//   * AccessDeniedException
//   The user does not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/PutResourcePolicy
func (c *MigrationHubRefactorSpaces) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/TagResource
func (c *MigrationHubRefactorSpaces) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Migration Hub Refactor Spaces.
//
// Removes the tags of a given resource. Tags are metadata which can be used
// to manage a resource. To tag a resource, the caller account must be the same
// as the resource’s OwnerAccountId. Tagging resources in other accounts is
// not supported.
//
// Amazon Web Services Migration Hub Refactor Spaces does not propagate tags
// to orchestrated resources, such as an environment’s transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/TagResource
func (c *MigrationHubRefactorSpaces) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/UntagResource
func (c *MigrationHubRefactorSpaces) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Migration Hub Refactor Spaces.
//
// Adds to or modifies the tags of the given resource. Tags are metadata which
// can be used to manage a resource. To untag a resource, the caller account
// must be the same as the resource’s OwnerAccountId. Untagging resources
// across accounts is not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub Refactor Spaces's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The request references a resource that does not exist.
//
//   * InternalServerException
//   An unexpected error occurred while processing the request.
//
//   * ValidationException
//   The input does not satisfy the constraints specified by an Amazon Web Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/migration-hub-refactor-spaces-2021-10-26/UntagResource
func (c *MigrationHubRefactorSpaces) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHubRefactorSpaces) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The user does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A wrapper object holding the Amazon API Gateway proxy configuration.
type ApiGatewayProxyConfig struct {
	_ struct{} `type:"structure"`

	// The resource ID of the API Gateway for the proxy.
	ApiGatewayId *string `min:"10" type:"string"`

	// The type of API Gateway endpoint created.
	EndpointType *string `type:"string" enum:"ApiGatewayEndpointType"`

	// The Amazon Resource Name (ARN) of the Network Load Balancer configured by
	// the API Gateway proxy.
	NlbArn *string `min:"20" type:"string"`

	// The name of the Network Load Balancer that is configured by the API Gateway
	// proxy.
	NlbName *string `min:"1" type:"string"`

	// The endpoint URL of the API Gateway proxy.
	ProxyUrl *string `min:"1" type:"string"`

	// The name of the API Gateway stage. The name defaults to prod.
	StageName *string `min:"1" type:"string"`

	// The VpcLink ID of the API Gateway proxy.
	VpcLinkId *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxyConfig) GoString() string {
	return s.String()
}

// SetApiGatewayId sets the ApiGatewayId field's value.
func (s *ApiGatewayProxyConfig) SetApiGatewayId(v string) *ApiGatewayProxyConfig {
	s.ApiGatewayId = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ApiGatewayProxyConfig) SetEndpointType(v string) *ApiGatewayProxyConfig {
	s.EndpointType = &v
	return s
}

// SetNlbArn sets the NlbArn field's value.
func (s *ApiGatewayProxyConfig) SetNlbArn(v string) *ApiGatewayProxyConfig {
	s.NlbArn = &v
	return s
}

// SetNlbName sets the NlbName field's value.
func (s *ApiGatewayProxyConfig) SetNlbName(v string) *ApiGatewayProxyConfig {
	s.NlbName = &v
	return s
}

// SetProxyUrl sets the ProxyUrl field's value.
func (s *ApiGatewayProxyConfig) SetProxyUrl(v string) *ApiGatewayProxyConfig {
	s.ProxyUrl = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ApiGatewayProxyConfig) SetStageName(v string) *ApiGatewayProxyConfig {
	s.StageName = &v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *ApiGatewayProxyConfig) SetVpcLinkId(v string) *ApiGatewayProxyConfig {
	s.VpcLinkId = &v
	return s
}

// A wrapper object holding the Amazon API Gateway endpoint input.
type ApiGatewayProxyInput_ struct {
	_ struct{} `type:"structure"`

	// The type of endpoint to use for the API Gateway proxy. If no value is specified
	// in the request, the value is set to REGIONAL by default.
	//
	// If the value is set to PRIVATE in the request, this creates a private API
	// endpoint that is isolated from the public internet. The private endpoint
	// can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) endpoints
	// for Amazon API Gateway that have been granted access.
	EndpointType *string `type:"string" enum:"ApiGatewayEndpointType"`

	// The name of the API Gateway stage. The name defaults to prod.
	StageName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxyInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxyInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApiGatewayProxyInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApiGatewayProxyInput_"}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointType sets the EndpointType field's value.
func (s *ApiGatewayProxyInput_) SetEndpointType(v string) *ApiGatewayProxyInput_ {
	s.EndpointType = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ApiGatewayProxyInput_) SetStageName(v string) *ApiGatewayProxyInput_ {
	s.StageName = &v
	return s
}

// A wrapper object holding the Amazon API Gateway proxy summary.
type ApiGatewayProxySummary struct {
	_ struct{} `type:"structure"`

	// The resource ID of the API Gateway for the proxy.
	ApiGatewayId *string `min:"10" type:"string"`

	// The type of API Gateway endpoint created.
	EndpointType *string `type:"string" enum:"ApiGatewayEndpointType"`

	// The Amazon Resource Name (ARN) of the Network Load Balancer configured by
	// the API Gateway proxy.
	NlbArn *string `min:"20" type:"string"`

	// The name of the Network Load Balancer that is configured by the API Gateway
	// proxy.
	NlbName *string `min:"1" type:"string"`

	// The endpoint URL of the API Gateway proxy.
	ProxyUrl *string `min:"1" type:"string"`

	// The name of the API Gateway stage. The name defaults to prod.
	StageName *string `min:"1" type:"string"`

	// The VpcLink ID of the API Gateway proxy.
	VpcLinkId *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiGatewayProxySummary) GoString() string {
	return s.String()
}

// SetApiGatewayId sets the ApiGatewayId field's value.
func (s *ApiGatewayProxySummary) SetApiGatewayId(v string) *ApiGatewayProxySummary {
	s.ApiGatewayId = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ApiGatewayProxySummary) SetEndpointType(v string) *ApiGatewayProxySummary {
	s.EndpointType = &v
	return s
}

// SetNlbArn sets the NlbArn field's value.
func (s *ApiGatewayProxySummary) SetNlbArn(v string) *ApiGatewayProxySummary {
	s.NlbArn = &v
	return s
}

// SetNlbName sets the NlbName field's value.
func (s *ApiGatewayProxySummary) SetNlbName(v string) *ApiGatewayProxySummary {
	s.NlbName = &v
	return s
}

// SetProxyUrl sets the ProxyUrl field's value.
func (s *ApiGatewayProxySummary) SetProxyUrl(v string) *ApiGatewayProxySummary {
	s.ProxyUrl = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ApiGatewayProxySummary) SetStageName(v string) *ApiGatewayProxySummary {
	s.StageName = &v
	return s
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *ApiGatewayProxySummary) SetVpcLinkId(v string) *ApiGatewayProxySummary {
	s.VpcLinkId = &v
	return s
}

// The list of ApplicationSummary objects.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The endpoint URL of the Amazon API Gateway proxy.
	ApiGatewayProxy *ApiGatewayProxySummary `type:"structure"`

	// The unique identifier of the application.
	ApplicationId *string `min:"14" type:"string"`

	// he Amazon Resource Name (ARN) of the application.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the application creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the application is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the application resource.
	Error *ErrorResponse `type:"structure"`

	// A timestamp that indicates when the application was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the application owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The proxy type of the proxy created within the application.
	ProxyType *string `type:"string" enum:"ProxyType"`

	// The current state of the application.
	State *string `type:"string" enum:"ApplicationState"`

	// The tags assigned to the application.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ApplicationSummary's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the virtual private cloud (VPC).
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApiGatewayProxy sets the ApiGatewayProxy field's value.
func (s *ApplicationSummary) SetApiGatewayProxy(v *ApiGatewayProxySummary) *ApplicationSummary {
	s.ApiGatewayProxy = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSummary) SetApplicationId(v string) *ApplicationSummary {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ApplicationSummary) SetArn(v string) *ApplicationSummary {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *ApplicationSummary) SetCreatedByAccountId(v string) *ApplicationSummary {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ApplicationSummary) SetCreatedTime(v time.Time) *ApplicationSummary {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ApplicationSummary) SetEnvironmentId(v string) *ApplicationSummary {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *ApplicationSummary) SetError(v *ErrorResponse) *ApplicationSummary {
	s.Error = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ApplicationSummary) SetLastUpdatedTime(v time.Time) *ApplicationSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *ApplicationSummary) SetOwnerAccountId(v string) *ApplicationSummary {
	s.OwnerAccountId = &v
	return s
}

// SetProxyType sets the ProxyType field's value.
func (s *ApplicationSummary) SetProxyType(v string) *ApplicationSummary {
	s.ProxyType = &v
	return s
}

// SetState sets the State field's value.
func (s *ApplicationSummary) SetState(v string) *ApplicationSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApplicationSummary) SetTags(v map[string]*string) *ApplicationSummary {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ApplicationSummary) SetVpcId(v string) *ApplicationSummary {
	s.VpcId = &v
	return s
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// A wrapper object holding the API Gateway endpoint type and stage name for
	// the proxy.
	ApiGatewayProxy *ApiGatewayProxyInput_ `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The name to use for the application.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// The proxy type of the proxy created within the application.
	//
	// ProxyType is a required field
	ProxyType *string `type:"string" required:"true" enum:"ProxyType"`

	// The tags to assign to the application. A tag is a label that you assign to
	// an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateApplicationInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the virtual private cloud (VPC).
	//
	// VpcId is a required field
	VpcId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.ProxyType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProxyType"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 12))
	}
	if s.ApiGatewayProxy != nil {
		if err := s.ApiGatewayProxy.Validate(); err != nil {
			invalidParams.AddNested("ApiGatewayProxy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiGatewayProxy sets the ApiGatewayProxy field's value.
func (s *CreateApplicationInput) SetApiGatewayProxy(v *ApiGatewayProxyInput_) *CreateApplicationInput {
	s.ApiGatewayProxy = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateApplicationInput) SetEnvironmentIdentifier(v string) *CreateApplicationInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetProxyType sets the ProxyType field's value.
func (s *CreateApplicationInput) SetProxyType(v string) *CreateApplicationInput {
	s.ProxyType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateApplicationInput) SetVpcId(v string) *CreateApplicationInput {
	s.VpcId = &v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// A wrapper object holding the API Gateway endpoint type and stage name for
	// the proxy.
	ApiGatewayProxy *ApiGatewayProxyInput_ `type:"structure"`

	// The unique identifier of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the application. The format for this ARN
	// is arn:aws:refactor-spaces:region:account-id:resource-type/resource-id .
	// For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of application creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the application is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the environment in which the application is created.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the application was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the application owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The proxy type of the proxy created within the application.
	ProxyType *string `type:"string" enum:"ProxyType"`

	// The current state of the application.
	State *string `type:"string" enum:"ApplicationState"`

	// The tags assigned to the application. A tag is a label that you assign to
	// an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateApplicationOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the Amazon VPC.
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApiGatewayProxy sets the ApiGatewayProxy field's value.
func (s *CreateApplicationOutput) SetApiGatewayProxy(v *ApiGatewayProxyInput_) *CreateApplicationOutput {
	s.ApiGatewayProxy = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateApplicationOutput) SetArn(v string) *CreateApplicationOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *CreateApplicationOutput) SetCreatedByAccountId(v string) *CreateApplicationOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateApplicationOutput) SetCreatedTime(v time.Time) *CreateApplicationOutput {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateApplicationOutput) SetEnvironmentId(v string) *CreateApplicationOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *CreateApplicationOutput) SetLastUpdatedTime(v time.Time) *CreateApplicationOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationOutput) SetName(v string) *CreateApplicationOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *CreateApplicationOutput) SetOwnerAccountId(v string) *CreateApplicationOutput {
	s.OwnerAccountId = &v
	return s
}

// SetProxyType sets the ProxyType field's value.
func (s *CreateApplicationOutput) SetProxyType(v string) *CreateApplicationOutput {
	s.ProxyType = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateApplicationOutput) SetState(v string) *CreateApplicationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationOutput) SetTags(v map[string]*string) *CreateApplicationOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateApplicationOutput) SetVpcId(v string) *CreateApplicationOutput {
	s.VpcId = &v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the environment.
	Description *string `min:"1" type:"string"`

	// The name of the environment.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// The network fabric type of the environment.
	//
	// NetworkFabricType is a required field
	NetworkFabricType *string `type:"string" required:"true" enum:"NetworkFabricType"`

	// The tags to assign to the environment. A tag is a label that you assign to
	// an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.NetworkFabricType == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkFabricType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEnvironmentInput) SetClientToken(v string) *CreateEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetNetworkFabricType sets the NetworkFabricType field's value.
func (s *CreateEnvironmentInput) SetNetworkFabricType(v string) *CreateEnvironmentInput {
	s.NetworkFabricType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `min:"20" type:"string"`

	// A timestamp that indicates when the environment is created.
	CreatedTime *time.Time `type:"timestamp"`

	// A description of the environment.
	Description *string `min:"1" type:"string"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the environment was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the environment.
	Name *string `min:"3" type:"string"`

	// The network fabric type of the environment.
	NetworkFabricType *string `type:"string" enum:"NetworkFabricType"`

	// The Amazon Web Services account ID of environment owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The current state of the environment.
	State *string `type:"string" enum:"EnvironmentState"`

	// The tags assigned to the created environment. A tag is a label that you assign
	// to an Amazon Web Services resource. Each tag consists of a key-value pair..
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEnvironmentOutput) SetArn(v string) *CreateEnvironmentOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateEnvironmentOutput) SetCreatedTime(v time.Time) *CreateEnvironmentOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentOutput) SetDescription(v string) *CreateEnvironmentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentId(v string) *CreateEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *CreateEnvironmentOutput) SetLastUpdatedTime(v time.Time) *CreateEnvironmentOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentOutput) SetName(v string) *CreateEnvironmentOutput {
	s.Name = &v
	return s
}

// SetNetworkFabricType sets the NetworkFabricType field's value.
func (s *CreateEnvironmentOutput) SetNetworkFabricType(v string) *CreateEnvironmentOutput {
	s.NetworkFabricType = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *CreateEnvironmentOutput) SetOwnerAccountId(v string) *CreateEnvironmentOutput {
	s.OwnerAccountId = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateEnvironmentOutput) SetState(v string) *CreateEnvironmentOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentOutput) SetTags(v map[string]*string) *CreateEnvironmentOutput {
	s.Tags = v
	return s
}

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application within which the route is being created.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the environment in which the route is created.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The route type of the route. DEFAULT indicates that all traffic that does
	// not match another route is forwarded to the default route. Applications must
	// have a default route before any other routes can be created. URI_PATH indicates
	// a route that is based on a URI path.
	//
	// RouteType is a required field
	RouteType *string `type:"string" required:"true" enum:"RouteType"`

	// The ID of the service in which the route is created. Traffic that matches
	// this route is forwarded to this service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `min:"14" type:"string" required:"true"`

	// The tags to assign to the route. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key-value pair..
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateRouteInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The configuration for the URI path route type.
	UriPathRoute *UriPathRouteInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRouteInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.RouteType == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteType"))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 14))
	}
	if s.UriPathRoute != nil {
		if err := s.UriPathRoute.Validate(); err != nil {
			invalidParams.AddNested("UriPathRoute", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *CreateRouteInput) SetApplicationIdentifier(v string) *CreateRouteInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRouteInput) SetClientToken(v string) *CreateRouteInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateRouteInput) SetEnvironmentIdentifier(v string) *CreateRouteInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetRouteType sets the RouteType field's value.
func (s *CreateRouteInput) SetRouteType(v string) *CreateRouteInput {
	s.RouteType = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *CreateRouteInput) SetServiceIdentifier(v string) *CreateRouteInput {
	s.ServiceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteInput) SetTags(v map[string]*string) *CreateRouteInput {
	s.Tags = v
	return s
}

// SetUriPathRoute sets the UriPathRoute field's value.
func (s *CreateRouteInput) SetUriPathRoute(v *UriPathRouteInput_) *CreateRouteInput {
	s.UriPathRoute = v
	return s
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application in which the route is created.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the route. The format for this ARN is arn:aws:refactor-spaces:region:account-id:resource-type/resource-id
	// . For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the route creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the route is created.
	CreatedTime *time.Time `type:"timestamp"`

	// A timestamp that indicates when the route was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The Amazon Web Services account ID of the route owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The unique identifier of the route.
	RouteId *string `min:"14" type:"string"`

	// The route type of the route.
	RouteType *string `type:"string" enum:"RouteType"`

	// The ID of service in which the rute iscreated. Traffic that matches this
	// route is forwarded to this service.
	ServiceId *string `min:"14" type:"string"`

	// he current state of the route.
	State *string `type:"string" enum:"RouteState"`

	// The tags assigned to the created route. A tag is a label that you assign
	// to an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateRouteOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// onfiguration for the URI path route type.
	UriPathRoute *UriPathRouteInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRouteOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateRouteOutput) SetApplicationId(v string) *CreateRouteOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateRouteOutput) SetArn(v string) *CreateRouteOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *CreateRouteOutput) SetCreatedByAccountId(v string) *CreateRouteOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateRouteOutput) SetCreatedTime(v time.Time) *CreateRouteOutput {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *CreateRouteOutput) SetLastUpdatedTime(v time.Time) *CreateRouteOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *CreateRouteOutput) SetOwnerAccountId(v string) *CreateRouteOutput {
	s.OwnerAccountId = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *CreateRouteOutput) SetRouteId(v string) *CreateRouteOutput {
	s.RouteId = &v
	return s
}

// SetRouteType sets the RouteType field's value.
func (s *CreateRouteOutput) SetRouteType(v string) *CreateRouteOutput {
	s.RouteType = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *CreateRouteOutput) SetServiceId(v string) *CreateRouteOutput {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateRouteOutput) SetState(v string) *CreateRouteOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRouteOutput) SetTags(v map[string]*string) *CreateRouteOutput {
	s.Tags = v
	return s
}

// SetUriPathRoute sets the UriPathRoute field's value.
func (s *CreateRouteOutput) SetUriPathRoute(v *UriPathRouteInput_) *CreateRouteOutput {
	s.UriPathRoute = v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application which the service is created.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the service.
	Description *string `min:"1" type:"string"`

	// The type of endpoint to use for the service. The type can be a URL in a VPC
	// or an Lambda function.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"ServiceEndpointType"`

	// The ID of the environment in which the service is created.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The configuration for the Lambda endpoint type.
	LambdaEndpoint *LambdaEndpointInput_ `type:"structure"`

	// The name of the service.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// The tags to assign to the service. A tag is a label that you assign to an
	// Amazon Web Services resource. Each tag consists of a key-value pair..
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The configuration for the URL endpoint type.
	UrlEndpoint *UrlEndpointInput_ `type:"structure"`

	// The ID of the VPC.
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.VpcId != nil && len(*s.VpcId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 12))
	}
	if s.LambdaEndpoint != nil {
		if err := s.LambdaEndpoint.Validate(); err != nil {
			invalidParams.AddNested("LambdaEndpoint", err.(request.ErrInvalidParams))
		}
	}
	if s.UrlEndpoint != nil {
		if err := s.UrlEndpoint.Validate(); err != nil {
			invalidParams.AddNested("UrlEndpoint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *CreateServiceInput) SetApplicationIdentifier(v string) *CreateServiceInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceInput) SetClientToken(v string) *CreateServiceInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceInput) SetDescription(v string) *CreateServiceInput {
	s.Description = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateServiceInput) SetEndpointType(v string) *CreateServiceInput {
	s.EndpointType = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateServiceInput) SetEnvironmentIdentifier(v string) *CreateServiceInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetLambdaEndpoint sets the LambdaEndpoint field's value.
func (s *CreateServiceInput) SetLambdaEndpoint(v *LambdaEndpointInput_) *CreateServiceInput {
	s.LambdaEndpoint = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInput) SetName(v string) *CreateServiceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v map[string]*string) *CreateServiceInput {
	s.Tags = v
	return s
}

// SetUrlEndpoint sets the UrlEndpoint field's value.
func (s *CreateServiceInput) SetUrlEndpoint(v *UrlEndpointInput_) *CreateServiceInput {
	s.UrlEndpoint = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateServiceInput) SetVpcId(v string) *CreateServiceInput {
	s.VpcId = &v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that the created service belongs to.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the service creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the service is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the created service.
	Description *string `min:"1" type:"string"`

	// The endpoint type of the service.
	EndpointType *string `type:"string" enum:"ServiceEndpointType"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// The configuration for the Lambda endpoint type.
	LambdaEndpoint *LambdaEndpointInput_ `type:"structure"`

	// A timestamp that indicates when the service was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the service.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the service owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The current state of the service.
	State *string `type:"string" enum:"ServiceState"`

	// The tags assigned to the created service. A tag is a label that you assign
	// to an Amazon Web Services resource. Each tag consists of a key-value pair..
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The configuration for the URL endpoint type.
	UrlEndpoint *UrlEndpointInput_ `type:"structure"`

	// The ID of the VPC.
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateServiceOutput) SetApplicationId(v string) *CreateServiceOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateServiceOutput) SetArn(v string) *CreateServiceOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *CreateServiceOutput) SetCreatedByAccountId(v string) *CreateServiceOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateServiceOutput) SetCreatedTime(v time.Time) *CreateServiceOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceOutput) SetDescription(v string) *CreateServiceOutput {
	s.Description = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateServiceOutput) SetEndpointType(v string) *CreateServiceOutput {
	s.EndpointType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateServiceOutput) SetEnvironmentId(v string) *CreateServiceOutput {
	s.EnvironmentId = &v
	return s
}

// SetLambdaEndpoint sets the LambdaEndpoint field's value.
func (s *CreateServiceOutput) SetLambdaEndpoint(v *LambdaEndpointInput_) *CreateServiceOutput {
	s.LambdaEndpoint = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *CreateServiceOutput) SetLastUpdatedTime(v time.Time) *CreateServiceOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceOutput) SetName(v string) *CreateServiceOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *CreateServiceOutput) SetOwnerAccountId(v string) *CreateServiceOutput {
	s.OwnerAccountId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *CreateServiceOutput) SetServiceId(v string) *CreateServiceOutput {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateServiceOutput) SetState(v string) *CreateServiceOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceOutput) SetTags(v map[string]*string) *CreateServiceOutput {
	s.Tags = v
	return s
}

// SetUrlEndpoint sets the UrlEndpoint field's value.
func (s *CreateServiceOutput) SetUrlEndpoint(v *UrlEndpointInput_) *CreateServiceOutput {
	s.UrlEndpoint = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateServiceOutput) SetVpcId(v string) *CreateServiceOutput {
	s.VpcId = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *DeleteApplicationInput) SetApplicationIdentifier(v string) *DeleteApplicationInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteApplicationInput) SetEnvironmentIdentifier(v string) *DeleteApplicationInput {
	s.EnvironmentIdentifier = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the application.
	Arn *string `min:"20" type:"string"`

	// The unique identifier of the application’s environment.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the environment was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"3" type:"string"`

	// The current state of the application.
	State *string `type:"string" enum:"ApplicationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationOutput) SetApplicationId(v string) *DeleteApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteApplicationOutput) SetArn(v string) *DeleteApplicationOutput {
	s.Arn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteApplicationOutput) SetEnvironmentId(v string) *DeleteApplicationOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DeleteApplicationOutput) SetLastUpdatedTime(v time.Time) *DeleteApplicationOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteApplicationOutput) SetName(v string) *DeleteApplicationOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteApplicationOutput) SetState(v string) *DeleteApplicationOutput {
	s.State = &v
	return s
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteEnvironmentInput) SetEnvironmentIdentifier(v string) *DeleteEnvironmentInput {
	s.EnvironmentIdentifier = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `min:"20" type:"string"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the environment was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the environment.
	Name *string `min:"3" type:"string"`

	// The current state of the environment.
	State *string `type:"string" enum:"EnvironmentState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteEnvironmentOutput) SetArn(v string) *DeleteEnvironmentOutput {
	s.Arn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentOutput) SetEnvironmentId(v string) *DeleteEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DeleteEnvironmentOutput) SetLastUpdatedTime(v time.Time) *DeleteEnvironmentOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteEnvironmentOutput) SetName(v string) *DeleteEnvironmentOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteEnvironmentOutput) SetState(v string) *DeleteEnvironmentOutput {
	s.State = &v
	return s
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Amazon Resource Name (ARN) of the resource associated with the policy.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteResourcePolicyInput) SetIdentifier(v string) *DeleteResourcePolicyInput {
	s.Identifier = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application to delete the route from.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment to delete the route from.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the route to delete.
	//
	// RouteIdentifier is a required field
	RouteIdentifier *string `location:"uri" locationName:"RouteIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRouteInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.RouteIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteIdentifier"))
	}
	if s.RouteIdentifier != nil && len(*s.RouteIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("RouteIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *DeleteRouteInput) SetApplicationIdentifier(v string) *DeleteRouteInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteRouteInput) SetEnvironmentIdentifier(v string) *DeleteRouteInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetRouteIdentifier sets the RouteIdentifier field's value.
func (s *DeleteRouteInput) SetRouteIdentifier(v string) *DeleteRouteInput {
	s.RouteIdentifier = &v
	return s
}

type DeleteRouteOutput struct {
	_ struct{} `type:"structure"`

	// he ID of the application that the route belongs to.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the route.
	Arn *string `min:"20" type:"string"`

	// A timestamp that indicates when the route was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The ID of the route to delete.
	RouteId *string `min:"14" type:"string"`

	// The ID of the service that the route belongs to.
	ServiceId *string `min:"14" type:"string"`

	// The current state of the route.
	State *string `type:"string" enum:"RouteState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRouteOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteRouteOutput) SetApplicationId(v string) *DeleteRouteOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteRouteOutput) SetArn(v string) *DeleteRouteOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DeleteRouteOutput) SetLastUpdatedTime(v time.Time) *DeleteRouteOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *DeleteRouteOutput) SetRouteId(v string) *DeleteRouteOutput {
	s.RouteId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *DeleteRouteOutput) SetServiceId(v string) *DeleteRouteOutput {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteRouteOutput) SetState(v string) *DeleteRouteOutput {
	s.State = &v
	return s
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Deletes a Refactor Spaces service.
	//
	// The RefactorSpacesSecurityGroup security group must be removed from all Amazon
	// Web Services resources in the virtual private cloud (VPC) prior to deleting
	// a service with a URL endpoint in a VPC.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment that the service is in.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the service to delete.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"ServiceIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *DeleteServiceInput) SetApplicationIdentifier(v string) *DeleteServiceInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteServiceInput) SetEnvironmentIdentifier(v string) *DeleteServiceInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *DeleteServiceInput) SetServiceIdentifier(v string) *DeleteServiceInput {
	s.ServiceIdentifier = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that the service is in.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `min:"20" type:"string"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the service was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the service.
	Name *string `min:"3" type:"string"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The current state of the service.
	State *string `type:"string" enum:"ServiceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteServiceOutput) SetApplicationId(v string) *DeleteServiceOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteServiceOutput) SetArn(v string) *DeleteServiceOutput {
	s.Arn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteServiceOutput) SetEnvironmentId(v string) *DeleteServiceOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DeleteServiceOutput) SetLastUpdatedTime(v time.Time) *DeleteServiceOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteServiceOutput) SetName(v string) *DeleteServiceOutput {
	s.Name = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *DeleteServiceOutput) SetServiceId(v string) *DeleteServiceOutput {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteServiceOutput) SetState(v string) *DeleteServiceOutput {
	s.State = &v
	return s
}

// The summary information for environments as a response to ListEnvironments.
type EnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `min:"20" type:"string"`

	// A timestamp that indicates when the environment is created.
	CreatedTime *time.Time `type:"timestamp"`

	// A description of the environment.
	Description *string `min:"1" type:"string"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the environment resource.
	Error *ErrorResponse `type:"structure"`

	// A timestamp that indicates when the environment was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the environment.
	Name *string `min:"3" type:"string"`

	// The network fabric type of the environment.
	NetworkFabricType *string `type:"string" enum:"NetworkFabricType"`

	// The Amazon Web Services account ID of the environment owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The current state of the environment.
	State *string `type:"string" enum:"EnvironmentState"`

	// The tags assigned to the environment.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the transit gateway set up by the environment.
	TransitGatewayId *string `min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentSummary) SetArn(v string) *EnvironmentSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EnvironmentSummary) SetCreatedTime(v time.Time) *EnvironmentSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentSummary) SetDescription(v string) *EnvironmentSummary {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentSummary) SetEnvironmentId(v string) *EnvironmentSummary {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *EnvironmentSummary) SetError(v *ErrorResponse) *EnvironmentSummary {
	s.Error = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EnvironmentSummary) SetLastUpdatedTime(v time.Time) *EnvironmentSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentSummary) SetName(v string) *EnvironmentSummary {
	s.Name = &v
	return s
}

// SetNetworkFabricType sets the NetworkFabricType field's value.
func (s *EnvironmentSummary) SetNetworkFabricType(v string) *EnvironmentSummary {
	s.NetworkFabricType = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *EnvironmentSummary) SetOwnerAccountId(v string) *EnvironmentSummary {
	s.OwnerAccountId = &v
	return s
}

// SetState sets the State field's value.
func (s *EnvironmentSummary) SetState(v string) *EnvironmentSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EnvironmentSummary) SetTags(v map[string]*string) *EnvironmentSummary {
	s.Tags = v
	return s
}

// SetTransitGatewayId sets the TransitGatewayId field's value.
func (s *EnvironmentSummary) SetTransitGatewayId(v string) *EnvironmentSummary {
	s.TransitGatewayId = &v
	return s
}

// Provides summary information for the EnvironmentVpc resource as a response
// to ListEnvironmentVpc.
type EnvironmentVpc struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the virtual private cloud (VPC) owner.
	AccountId *string `min:"12" type:"string"`

	// The list of Amazon Virtual Private Cloud (Amazon VPC) CIDR blocks.
	CidrBlocks []*string `min:"1" type:"list"`

	// A timestamp that indicates when the VPC is first added to the environment.
	CreatedTime *time.Time `type:"timestamp"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// A timestamp that indicates when the VPC was last updated by the environment.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The ID of the VPC.
	VpcId *string `min:"12" type:"string"`

	// The name of the VPC at the time it is added to the environment.
	VpcName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentVpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentVpc) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *EnvironmentVpc) SetAccountId(v string) *EnvironmentVpc {
	s.AccountId = &v
	return s
}

// SetCidrBlocks sets the CidrBlocks field's value.
func (s *EnvironmentVpc) SetCidrBlocks(v []*string) *EnvironmentVpc {
	s.CidrBlocks = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EnvironmentVpc) SetCreatedTime(v time.Time) *EnvironmentVpc {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentVpc) SetEnvironmentId(v string) *EnvironmentVpc {
	s.EnvironmentId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EnvironmentVpc) SetLastUpdatedTime(v time.Time) *EnvironmentVpc {
	s.LastUpdatedTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *EnvironmentVpc) SetVpcId(v string) *EnvironmentVpc {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *EnvironmentVpc) SetVpcName(v string) *EnvironmentVpc {
	s.VpcName = &v
	return s
}

// Error associated with a resource returned for a Get or List resource response.
type ErrorResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID of the resource owner.
	AccountId *string `min:"12" type:"string"`

	// Additional details about the error.
	AdditionalDetails map[string]*string `type:"map"`

	// The error code associated with the error.
	Code *string `type:"string" enum:"ErrorCode"`

	// The message associated with the error.
	Message *string `type:"string"`

	// The ID of the resource.
	ResourceIdentifier *string `min:"3" type:"string"`

	// The type of resource.
	ResourceType *string `type:"string" enum:"ErrorResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorResponse) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ErrorResponse) SetAccountId(v string) *ErrorResponse {
	s.AccountId = &v
	return s
}

// SetAdditionalDetails sets the AdditionalDetails field's value.
func (s *ErrorResponse) SetAdditionalDetails(v map[string]*string) *ErrorResponse {
	s.AdditionalDetails = v
	return s
}

// SetCode sets the Code field's value.
func (s *ErrorResponse) SetCode(v string) *ErrorResponse {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorResponse) SetMessage(v string) *ErrorResponse {
	s.Message = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ErrorResponse) SetResourceIdentifier(v string) *ErrorResponse {
	s.ResourceIdentifier = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ErrorResponse) SetResourceType(v string) *ErrorResponse {
	s.ResourceType = &v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *GetApplicationInput) SetApplicationIdentifier(v string) *GetApplicationInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *GetApplicationInput) SetEnvironmentIdentifier(v string) *GetApplicationInput {
	s.EnvironmentIdentifier = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint URL of the API Gateway proxy.
	ApiGatewayProxy *ApiGatewayProxyConfig `type:"structure"`

	// The unique identifier of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the application.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the application creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the application is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the application resource.
	Error *ErrorResponse `type:"structure"`

	// A timestamp that indicates when the application was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the application owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The proxy type of the proxy created within the application.
	ProxyType *string `type:"string" enum:"ProxyType"`

	// The current state of the application.
	State *string `type:"string" enum:"ApplicationState"`

	// The tags assigned to the application. A tag is a label that you assign to
	// an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetApplicationOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the virtual private cloud (VPC).
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApiGatewayProxy sets the ApiGatewayProxy field's value.
func (s *GetApplicationOutput) SetApiGatewayProxy(v *ApiGatewayProxyConfig) *GetApplicationOutput {
	s.ApiGatewayProxy = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationOutput) SetApplicationId(v string) *GetApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetApplicationOutput) SetArn(v string) *GetApplicationOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *GetApplicationOutput) SetCreatedByAccountId(v string) *GetApplicationOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetApplicationOutput) SetCreatedTime(v time.Time) *GetApplicationOutput {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetApplicationOutput) SetEnvironmentId(v string) *GetApplicationOutput {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetApplicationOutput) SetError(v *ErrorResponse) *GetApplicationOutput {
	s.Error = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetApplicationOutput) SetLastUpdatedTime(v time.Time) *GetApplicationOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *GetApplicationOutput) SetOwnerAccountId(v string) *GetApplicationOutput {
	s.OwnerAccountId = &v
	return s
}

// SetProxyType sets the ProxyType field's value.
func (s *GetApplicationOutput) SetProxyType(v string) *GetApplicationOutput {
	s.ProxyType = &v
	return s
}

// SetState sets the State field's value.
func (s *GetApplicationOutput) SetState(v string) *GetApplicationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApplicationOutput) SetTags(v map[string]*string) *GetApplicationOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetApplicationOutput) SetVpcId(v string) *GetApplicationOutput {
	s.VpcId = &v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *GetEnvironmentInput) SetEnvironmentIdentifier(v string) *GetEnvironmentInput {
	s.EnvironmentIdentifier = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `min:"20" type:"string"`

	// A timestamp that indicates when the environment is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the environment.
	Description *string `min:"1" type:"string"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the environment resource.
	Error *ErrorResponse `type:"structure"`

	// A timestamp that indicates when the environment was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the environment.
	Name *string `min:"3" type:"string"`

	// The network fabric type of the environment.
	NetworkFabricType *string `type:"string" enum:"NetworkFabricType"`

	// The Amazon Web Services account ID of the environment owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The current state of the environment.
	State *string `type:"string" enum:"EnvironmentState"`

	// The tags to assign to the environment. A tag is a label that you assign to
	// an Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetEnvironmentOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The ID of the transit gateway set up by the environment.
	TransitGatewayId *string `min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetEnvironmentOutput) SetArn(v string) *GetEnvironmentOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetEnvironmentOutput) SetCreatedTime(v time.Time) *GetEnvironmentOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEnvironmentOutput) SetDescription(v string) *GetEnvironmentOutput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentOutput) SetEnvironmentId(v string) *GetEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetEnvironmentOutput) SetError(v *ErrorResponse) *GetEnvironmentOutput {
	s.Error = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetEnvironmentOutput) SetLastUpdatedTime(v time.Time) *GetEnvironmentOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEnvironmentOutput) SetName(v string) *GetEnvironmentOutput {
	s.Name = &v
	return s
}

// SetNetworkFabricType sets the NetworkFabricType field's value.
func (s *GetEnvironmentOutput) SetNetworkFabricType(v string) *GetEnvironmentOutput {
	s.NetworkFabricType = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *GetEnvironmentOutput) SetOwnerAccountId(v string) *GetEnvironmentOutput {
	s.OwnerAccountId = &v
	return s
}

// SetState sets the State field's value.
func (s *GetEnvironmentOutput) SetState(v string) *GetEnvironmentOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEnvironmentOutput) SetTags(v map[string]*string) *GetEnvironmentOutput {
	s.Tags = v
	return s
}

// SetTransitGatewayId sets the TransitGatewayId field's value.
func (s *GetEnvironmentOutput) SetTransitGatewayId(v string) *GetEnvironmentOutput {
	s.TransitGatewayId = &v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource associated with the policy.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourcePolicyInput) SetIdentifier(v string) *GetResourcePolicyInput {
	s.Identifier = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted string for an Amazon Web Services resource-based policy.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v string) *GetResourcePolicyOutput {
	s.Policy = &v
	return s
}

type GetRouteInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the route.
	//
	// RouteIdentifier is a required field
	RouteIdentifier *string `location:"uri" locationName:"RouteIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRouteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRouteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRouteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRouteInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.RouteIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteIdentifier"))
	}
	if s.RouteIdentifier != nil && len(*s.RouteIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("RouteIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *GetRouteInput) SetApplicationIdentifier(v string) *GetRouteInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *GetRouteInput) SetEnvironmentIdentifier(v string) *GetRouteInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetRouteIdentifier sets the RouteIdentifier field's value.
func (s *GetRouteInput) SetRouteIdentifier(v string) *GetRouteInput {
	s.RouteIdentifier = &v
	return s
}

type GetRouteOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that the route belongs to.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the route.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the route creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// The timestamp of when the route is created.
	CreatedTime *time.Time `type:"timestamp"`

	// Unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the route resource.
	Error *ErrorResponse `type:"structure"`

	// Indicates whether to match all subpaths of the given source path. If this
	// value is false, requests must match the source path exactly before they are
	// forwarded to this route's service.
	IncludeChildPaths *bool `type:"boolean"`

	// A timestamp that indicates when the route was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A list of HTTP methods to match. An empty list matches all values. If a method
	// is present, only HTTP requests using that method are forwarded to this route’s
	// service.
	Methods []*string `type:"list"`

	// The Amazon Web Services account ID of the route owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// A mapping of Amazon API Gateway path resources to resource IDs.
	PathResourceToId map[string]*string `type:"map"`

	// The unique identifier of the route.
	//
	// DEFAULT: All traffic that does not match another route is forwarded to the
	// default route. Applications must have a default route before any other routes
	// can be created.
	//
	// URI_PATH: A route that is based on a URI path.
	RouteId *string `min:"14" type:"string"`

	// The type of route.
	RouteType *string `type:"string" enum:"RouteType"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The path to use to match traffic. Paths must start with / and are relative
	// to the base of the application.
	SourcePath *string `min:"1" type:"string"`

	// The current state of the route.
	State *string `type:"string" enum:"RouteState"`

	// The tags assigned to the route. A tag is a label that you assign to an Amazon
	// Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRouteOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRouteOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetRouteOutput) SetApplicationId(v string) *GetRouteOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetRouteOutput) SetArn(v string) *GetRouteOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *GetRouteOutput) SetCreatedByAccountId(v string) *GetRouteOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetRouteOutput) SetCreatedTime(v time.Time) *GetRouteOutput {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetRouteOutput) SetEnvironmentId(v string) *GetRouteOutput {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetRouteOutput) SetError(v *ErrorResponse) *GetRouteOutput {
	s.Error = v
	return s
}

// SetIncludeChildPaths sets the IncludeChildPaths field's value.
func (s *GetRouteOutput) SetIncludeChildPaths(v bool) *GetRouteOutput {
	s.IncludeChildPaths = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetRouteOutput) SetLastUpdatedTime(v time.Time) *GetRouteOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetMethods sets the Methods field's value.
func (s *GetRouteOutput) SetMethods(v []*string) *GetRouteOutput {
	s.Methods = v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *GetRouteOutput) SetOwnerAccountId(v string) *GetRouteOutput {
	s.OwnerAccountId = &v
	return s
}

// SetPathResourceToId sets the PathResourceToId field's value.
func (s *GetRouteOutput) SetPathResourceToId(v map[string]*string) *GetRouteOutput {
	s.PathResourceToId = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *GetRouteOutput) SetRouteId(v string) *GetRouteOutput {
	s.RouteId = &v
	return s
}

// SetRouteType sets the RouteType field's value.
func (s *GetRouteOutput) SetRouteType(v string) *GetRouteOutput {
	s.RouteType = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetRouteOutput) SetServiceId(v string) *GetRouteOutput {
	s.ServiceId = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *GetRouteOutput) SetSourcePath(v string) *GetRouteOutput {
	s.SourcePath = &v
	return s
}

// SetState sets the State field's value.
func (s *GetRouteOutput) SetState(v string) *GetRouteOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetRouteOutput) SetTags(v map[string]*string) *GetRouteOutput {
	s.Tags = v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the service.
	//
	// ServiceIdentifier is a required field
	ServiceIdentifier *string `location:"uri" locationName:"ServiceIdentifier" min:"14" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.ServiceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIdentifier"))
	}
	if s.ServiceIdentifier != nil && len(*s.ServiceIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceIdentifier", 14))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *GetServiceInput) SetApplicationIdentifier(v string) *GetServiceInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *GetServiceInput) SetEnvironmentIdentifier(v string) *GetServiceInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetServiceIdentifier sets the ServiceIdentifier field's value.
func (s *GetServiceInput) SetServiceIdentifier(v string) *GetServiceInput {
	s.ServiceIdentifier = &v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the service creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// The timestamp of when the service is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the service.
	Description *string `min:"1" type:"string"`

	// The endpoint type of the service.
	EndpointType *string `type:"string" enum:"ServiceEndpointType"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the service resource.
	Error *ErrorResponse `type:"structure"`

	// The configuration for the Lambda endpoint type.
	//
	// The Arn is the Amazon Resource Name (ARN) of the Lambda function associated
	// with this service.
	LambdaEndpoint *LambdaEndpointConfig `type:"structure"`

	// A timestamp that indicates when the service was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the service.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the service owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The current state of the service.
	State *string `type:"string" enum:"ServiceState"`

	// The tags assigned to the service. A tag is a label that you assign to an
	// Amazon Web Services resource. Each tag consists of a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetServiceOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The configuration for the URL endpoint type.
	//
	// The Url isthe URL of the endpoint type.
	//
	// The HealthUrl is the health check URL of the endpoint type.
	UrlEndpoint *UrlEndpointConfig `type:"structure"`

	// The ID of the virtual private cloud (VPC).
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetServiceOutput) SetApplicationId(v string) *GetServiceOutput {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetServiceOutput) SetArn(v string) *GetServiceOutput {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *GetServiceOutput) SetCreatedByAccountId(v string) *GetServiceOutput {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetServiceOutput) SetCreatedTime(v time.Time) *GetServiceOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetServiceOutput) SetDescription(v string) *GetServiceOutput {
	s.Description = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *GetServiceOutput) SetEndpointType(v string) *GetServiceOutput {
	s.EndpointType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetServiceOutput) SetEnvironmentId(v string) *GetServiceOutput {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetServiceOutput) SetError(v *ErrorResponse) *GetServiceOutput {
	s.Error = v
	return s
}

// SetLambdaEndpoint sets the LambdaEndpoint field's value.
func (s *GetServiceOutput) SetLambdaEndpoint(v *LambdaEndpointConfig) *GetServiceOutput {
	s.LambdaEndpoint = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetServiceOutput) SetLastUpdatedTime(v time.Time) *GetServiceOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetServiceOutput) SetName(v string) *GetServiceOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *GetServiceOutput) SetOwnerAccountId(v string) *GetServiceOutput {
	s.OwnerAccountId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetServiceOutput) SetServiceId(v string) *GetServiceOutput {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *GetServiceOutput) SetState(v string) *GetServiceOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetServiceOutput) SetTags(v map[string]*string) *GetServiceOutput {
	s.Tags = v
	return s
}

// SetUrlEndpoint sets the UrlEndpoint field's value.
func (s *GetServiceOutput) SetUrlEndpoint(v *UrlEndpointConfig) *GetServiceOutput {
	s.UrlEndpoint = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetServiceOutput) SetVpcId(v string) *GetServiceOutput {
	s.VpcId = &v
	return s
}

// An unexpected error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource policy is not valid.
type InvalidResourcePolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourcePolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourcePolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidResourcePolicyException(v protocol.ResponseMetadata) error {
	return &InvalidResourcePolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourcePolicyException) Code() string {
	return "InvalidResourcePolicyException"
}

// Message returns the exception's message.
func (s *InvalidResourcePolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourcePolicyException) OrigErr() error {
	return nil
}

func (s *InvalidResourcePolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourcePolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourcePolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for the Lambda endpoint type.
type LambdaEndpointConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda endpoint.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointConfig) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LambdaEndpointConfig) SetArn(v string) *LambdaEndpointConfig {
	s.Arn = &v
	return s
}

// The input for the Lambda endpoint type.
type LambdaEndpointInput_ struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda endpoint.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaEndpointInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaEndpointInput_"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *LambdaEndpointInput_) SetArn(v string) *LambdaEndpointInput_ {
	s.Arn = &v
	return s
}

// The summary for the Lambda endpoint type.
type LambdaEndpointSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda endpoint.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaEndpointSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LambdaEndpointSummary) SetArn(v string) *LambdaEndpointSummary {
	s.Arn = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *ListApplicationsInput) SetEnvironmentIdentifier(v string) *ListApplicationsInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ApplicationSummary objects.
	ApplicationSummaryList []*ApplicationSummary `type:"list"`

	// The token for the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationSummaryList sets the ApplicationSummaryList field's value.
func (s *ListApplicationsOutput) SetApplicationSummaryList(v []*ApplicationSummary) *ListApplicationsOutput {
	s.ApplicationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentVpcsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentVpcsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentVpcsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentVpcsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentVpcsInput"}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *ListEnvironmentVpcsInput) SetEnvironmentIdentifier(v string) *ListEnvironmentVpcsInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentVpcsInput) SetMaxResults(v int64) *ListEnvironmentVpcsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentVpcsInput) SetNextToken(v string) *ListEnvironmentVpcsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentVpcsOutput struct {
	_ struct{} `type:"structure"`

	// The list of EnvironmentVpc objects.
	EnvironmentVpcList []*EnvironmentVpc `type:"list"`

	// The token for the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentVpcsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentVpcsOutput) GoString() string {
	return s.String()
}

// SetEnvironmentVpcList sets the EnvironmentVpcList field's value.
func (s *ListEnvironmentVpcsOutput) SetEnvironmentVpcList(v []*EnvironmentVpc) *ListEnvironmentVpcsOutput {
	s.EnvironmentVpcList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentVpcsOutput) SetNextToken(v string) *ListEnvironmentVpcsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of EnvironmentSummary objects.
	EnvironmentSummaryList []*EnvironmentSummary `type:"list"`

	// The token for the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironmentSummaryList sets the EnvironmentSummaryList field's value.
func (s *ListEnvironmentsOutput) SetEnvironmentSummaryList(v []*EnvironmentSummary) *ListEnvironmentsOutput {
	s.EnvironmentSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListRoutesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutesInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *ListRoutesInput) SetApplicationIdentifier(v string) *ListRoutesInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *ListRoutesInput) SetEnvironmentIdentifier(v string) *ListRoutesInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoutesInput) SetMaxResults(v int64) *ListRoutesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesInput) SetNextToken(v string) *ListRoutesInput {
	s.NextToken = &v
	return s
}

type ListRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The list of RouteSummary objects.
	RouteSummaryList []*RouteSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutesOutput) SetNextToken(v string) *ListRoutesOutput {
	s.NextToken = &v
	return s
}

// SetRouteSummaryList sets the RouteSummaryList field's value.
func (s *ListRoutesOutput) SetRouteSummaryList(v []*RouteSummary) *ListRoutesOutput {
	s.RouteSummaryList = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the application.
	//
	// ApplicationIdentifier is a required field
	ApplicationIdentifier *string `location:"uri" locationName:"ApplicationIdentifier" min:"14" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"EnvironmentIdentifier" min:"14" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.ApplicationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationIdentifier"))
	}
	if s.ApplicationIdentifier != nil && len(*s.ApplicationIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIdentifier", 14))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 14 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 14))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIdentifier sets the ApplicationIdentifier field's value.
func (s *ListServicesInput) SetApplicationIdentifier(v string) *ListServicesInput {
	s.ApplicationIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *ListServicesInput) SetEnvironmentIdentifier(v string) *ListServicesInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next page of results.
	NextToken *string `min:"1" type:"string"`

	// The list of ServiceSummary objects.
	ServiceSummaryList []*ServiceSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServiceSummaryList sets the ServiceSummaryList field's value.
func (s *ListServicesOutput) SetServiceSummaryList(v []*ServiceSummary) *ListServicesOutput {
	s.ServiceSummaryList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted string for an Amazon Web Services resource-based policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource to which the policy is being
	// attached.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// The request references a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The summary information for the routes as a response to ListRoutes.
type RouteSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the route.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the route creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the route is created.
	CreatedTime *time.Time `type:"timestamp"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the route resource.
	Error *ErrorResponse `type:"structure"`

	// Indicates whether to match all subpaths of the given source path. If this
	// value is false, requests must match the source path exactly before they are
	// forwarded to this route's service.
	IncludeChildPaths *bool `type:"boolean"`

	// A timestamp that indicates when the route was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A list of HTTP methods to match. An empty list matches all values. If a method
	// is present, only HTTP requests using that method are forwarded to this route’s
	// service.
	Methods []*string `type:"list"`

	// The Amazon Web Services account ID of the route owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// A mapping of Amazon API Gateway path resources to resource IDs.
	PathResourceToId map[string]*string `type:"map"`

	// The unique identifier of the route.
	RouteId *string `min:"14" type:"string"`

	// The route type of the route.
	RouteType *string `type:"string" enum:"RouteType"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The path to use to match traffic. Paths must start with / and are relative
	// to the base of the application.
	SourcePath *string `min:"1" type:"string"`

	// The current state of the route.
	State *string `type:"string" enum:"RouteState"`

	// The tags assigned to the route.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RouteSummary's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RouteSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *RouteSummary) SetApplicationId(v string) *RouteSummary {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RouteSummary) SetArn(v string) *RouteSummary {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *RouteSummary) SetCreatedByAccountId(v string) *RouteSummary {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RouteSummary) SetCreatedTime(v time.Time) *RouteSummary {
	s.CreatedTime = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *RouteSummary) SetEnvironmentId(v string) *RouteSummary {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *RouteSummary) SetError(v *ErrorResponse) *RouteSummary {
	s.Error = v
	return s
}

// SetIncludeChildPaths sets the IncludeChildPaths field's value.
func (s *RouteSummary) SetIncludeChildPaths(v bool) *RouteSummary {
	s.IncludeChildPaths = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *RouteSummary) SetLastUpdatedTime(v time.Time) *RouteSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetMethods sets the Methods field's value.
func (s *RouteSummary) SetMethods(v []*string) *RouteSummary {
	s.Methods = v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *RouteSummary) SetOwnerAccountId(v string) *RouteSummary {
	s.OwnerAccountId = &v
	return s
}

// SetPathResourceToId sets the PathResourceToId field's value.
func (s *RouteSummary) SetPathResourceToId(v map[string]*string) *RouteSummary {
	s.PathResourceToId = v
	return s
}

// SetRouteId sets the RouteId field's value.
func (s *RouteSummary) SetRouteId(v string) *RouteSummary {
	s.RouteId = &v
	return s
}

// SetRouteType sets the RouteType field's value.
func (s *RouteSummary) SetRouteType(v string) *RouteSummary {
	s.RouteType = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *RouteSummary) SetServiceId(v string) *RouteSummary {
	s.ServiceId = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *RouteSummary) SetSourcePath(v string) *RouteSummary {
	s.SourcePath = &v
	return s
}

// SetState sets the State field's value.
func (s *RouteSummary) SetState(v string) *RouteSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RouteSummary) SetTags(v map[string]*string) *RouteSummary {
	s.Tags = v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service quota requirement to identify originating quota. Reached throttling
	// quota exception.
	QuotaCode *string `type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`

	// Service quota requirement to identify originating service. Reached throttling
	// quota exception service code.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary for the service as a response to ListServices.
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application.
	ApplicationId *string `min:"14" type:"string"`

	// The Amazon Resource Name (ARN) of the service.
	Arn *string `min:"20" type:"string"`

	// The Amazon Web Services account ID of the service creator.
	CreatedByAccountId *string `min:"12" type:"string"`

	// A timestamp that indicates when the service is created.
	CreatedTime *time.Time `type:"timestamp"`

	// A description of the service.
	Description *string `min:"1" type:"string"`

	// The endpoint type of the service.
	EndpointType *string `type:"string" enum:"ServiceEndpointType"`

	// The unique identifier of the environment.
	EnvironmentId *string `min:"14" type:"string"`

	// Any error associated with the service resource.
	Error *ErrorResponse `type:"structure"`

	// A summary of the configuration for the Lambda endpoint type.
	LambdaEndpoint *LambdaEndpointSummary `type:"structure"`

	// A timestamp that indicates when the service was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the service.
	Name *string `min:"3" type:"string"`

	// The Amazon Web Services account ID of the service owner.
	OwnerAccountId *string `min:"12" type:"string"`

	// The unique identifier of the service.
	ServiceId *string `min:"14" type:"string"`

	// The current state of the service.
	State *string `type:"string" enum:"ServiceState"`

	// The tags assigned to the service.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceSummary's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// The summary of the configuration for the URL endpoint type.
	UrlEndpoint *UrlEndpointSummary `type:"structure"`

	// The ID of the virtual private cloud (VPC).
	VpcId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ServiceSummary) SetApplicationId(v string) *ServiceSummary {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ServiceSummary) SetArn(v string) *ServiceSummary {
	s.Arn = &v
	return s
}

// SetCreatedByAccountId sets the CreatedByAccountId field's value.
func (s *ServiceSummary) SetCreatedByAccountId(v string) *ServiceSummary {
	s.CreatedByAccountId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ServiceSummary) SetCreatedTime(v time.Time) *ServiceSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSummary) SetDescription(v string) *ServiceSummary {
	s.Description = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ServiceSummary) SetEndpointType(v string) *ServiceSummary {
	s.EndpointType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ServiceSummary) SetEnvironmentId(v string) *ServiceSummary {
	s.EnvironmentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *ServiceSummary) SetError(v *ErrorResponse) *ServiceSummary {
	s.Error = v
	return s
}

// SetLambdaEndpoint sets the LambdaEndpoint field's value.
func (s *ServiceSummary) SetLambdaEndpoint(v *LambdaEndpointSummary) *ServiceSummary {
	s.LambdaEndpoint = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ServiceSummary) SetLastUpdatedTime(v time.Time) *ServiceSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceSummary) SetName(v string) *ServiceSummary {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *ServiceSummary) SetOwnerAccountId(v string) *ServiceSummary {
	s.OwnerAccountId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *ServiceSummary) SetServiceId(v string) *ServiceSummary {
	s.ServiceId = &v
	return s
}

// SetState sets the State field's value.
func (s *ServiceSummary) SetState(v string) *ServiceSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ServiceSummary) SetTags(v map[string]*string) *ServiceSummary {
	s.Tags = v
	return s
}

// SetUrlEndpoint sets the UrlEndpoint field's value.
func (s *ServiceSummary) SetUrlEndpoint(v *UrlEndpointSummary) *ServiceSummary {
	s.UrlEndpoint = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ServiceSummary) SetVpcId(v string) *ServiceSummary {
	s.VpcId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied because the request was throttled.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Service quota requirement to identify originating quota. Reached throttling
	// quota exception.
	QuotaCode *string `type:"string"`

	// The number of seconds to wait before retrying.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// Service quota requirement to identify originating service. Reached throttling
	// quota exception service code.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of keys of the tags to be removed from the resource.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The configuration for the URI path route type.
type UriPathRouteInput_ struct {
	_ struct{} `type:"structure"`

	// Indicates whether traffic is forwarded to this route’s service after the
	// route is created.
	//
	// ActivationState is a required field
	ActivationState *string `type:"string" required:"true" enum:"RouteActivationState"`

	// Indicates whether to match all subpaths of the given source path. If this
	// value is false, requests must match the source path exactly before they are
	// forwarded to this route's service.
	IncludeChildPaths *bool `type:"boolean"`

	// A list of HTTP methods to match. An empty list matches all values. If a method
	// is present, only HTTP requests using that method are forwarded to this route’s
	// service.
	Methods []*string `type:"list"`

	// The path to use to match traffic. Paths must start with / and are relative
	// to the base of the application.
	//
	// SourcePath is a required field
	SourcePath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UriPathRouteInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UriPathRouteInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UriPathRouteInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UriPathRouteInput_"}
	if s.ActivationState == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationState"))
	}
	if s.SourcePath == nil {
		invalidParams.Add(request.NewErrParamRequired("SourcePath"))
	}
	if s.SourcePath != nil && len(*s.SourcePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourcePath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationState sets the ActivationState field's value.
func (s *UriPathRouteInput_) SetActivationState(v string) *UriPathRouteInput_ {
	s.ActivationState = &v
	return s
}

// SetIncludeChildPaths sets the IncludeChildPaths field's value.
func (s *UriPathRouteInput_) SetIncludeChildPaths(v bool) *UriPathRouteInput_ {
	s.IncludeChildPaths = &v
	return s
}

// SetMethods sets the Methods field's value.
func (s *UriPathRouteInput_) SetMethods(v []*string) *UriPathRouteInput_ {
	s.Methods = v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *UriPathRouteInput_) SetSourcePath(v string) *UriPathRouteInput_ {
	s.SourcePath = &v
	return s
}

// The configuration for the URL endpoint type.
type UrlEndpointConfig struct {
	_ struct{} `type:"structure"`

	// The health check URL of the URL endpoint type.
	HealthUrl *string `min:"1" type:"string"`

	// The HTTP URL endpoint.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointConfig) GoString() string {
	return s.String()
}

// SetHealthUrl sets the HealthUrl field's value.
func (s *UrlEndpointConfig) SetHealthUrl(v string) *UrlEndpointConfig {
	s.HealthUrl = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UrlEndpointConfig) SetUrl(v string) *UrlEndpointConfig {
	s.Url = &v
	return s
}

// The configuration for the URL endpoint type.
type UrlEndpointInput_ struct {
	_ struct{} `type:"structure"`

	// The health check URL of the URL endpoint type. If the URL is a public endpoint,
	// the HealthUrl must also be a public endpoint. If the URL is a private endpoint
	// inside a virtual private cloud (VPC), the health URL must also be a private
	// endpoint, and the host must be the same as the URL.
	HealthUrl *string `min:"1" type:"string"`

	// The URL to route traffic to. The URL must be an rfc3986-formatted URL (https://datatracker.ietf.org/doc/html/rfc3986).
	// If the host is a domain name, the name must be resolvable over the public
	// internet. If the scheme is https, the top level domain of the host must be
	// listed in the IANA root zone database (https://www.iana.org/domains/root/db).
	//
	// Url is a required field
	Url *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UrlEndpointInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UrlEndpointInput_"}
	if s.HealthUrl != nil && len(*s.HealthUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthUrl", 1))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthUrl sets the HealthUrl field's value.
func (s *UrlEndpointInput_) SetHealthUrl(v string) *UrlEndpointInput_ {
	s.HealthUrl = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UrlEndpointInput_) SetUrl(v string) *UrlEndpointInput_ {
	s.Url = &v
	return s
}

// The summary of the configuration for the URL endpoint type.
type UrlEndpointSummary struct {
	_ struct{} `type:"structure"`

	// The health check URL of the URL endpoint type. If the URL is a public endpoint,
	// the HealthUrl must also be a public endpoint. If the URL is a private endpoint
	// inside a virtual private cloud (VPC), the health URL must also be a private
	// endpoint, and the host must be the same as the URL.
	HealthUrl *string `min:"1" type:"string"`

	// The URL to route traffic to. The URL must be an rfc3986-formatted URL (https://datatracker.ietf.org/doc/html/rfc3986).
	// If the host is a domain name, the name must be resolvable over the public
	// internet. If the scheme is https, the top level domain of the host must be
	// listed in the IANA root zone database (https://www.iana.org/domains/root/db).
	Url *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlEndpointSummary) GoString() string {
	return s.String()
}

// SetHealthUrl sets the HealthUrl field's value.
func (s *UrlEndpointSummary) SetHealthUrl(v string) *UrlEndpointSummary {
	s.HealthUrl = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UrlEndpointSummary) SetUrl(v string) *UrlEndpointSummary {
	s.Url = &v
	return s
}

// The input does not satisfy the constraints specified by an Amazon Web Service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ApiGatewayEndpointTypeRegional is a ApiGatewayEndpointType enum value
	ApiGatewayEndpointTypeRegional = "REGIONAL"

	// ApiGatewayEndpointTypePrivate is a ApiGatewayEndpointType enum value
	ApiGatewayEndpointTypePrivate = "PRIVATE"
)

// ApiGatewayEndpointType_Values returns all elements of the ApiGatewayEndpointType enum
func ApiGatewayEndpointType_Values() []string {
	return []string{
		ApiGatewayEndpointTypeRegional,
		ApiGatewayEndpointTypePrivate,
	}
}

const (
	// ApplicationStateCreating is a ApplicationState enum value
	ApplicationStateCreating = "CREATING"

	// ApplicationStateActive is a ApplicationState enum value
	ApplicationStateActive = "ACTIVE"

	// ApplicationStateDeleting is a ApplicationState enum value
	ApplicationStateDeleting = "DELETING"

	// ApplicationStateFailed is a ApplicationState enum value
	ApplicationStateFailed = "FAILED"

	// ApplicationStateUpdating is a ApplicationState enum value
	ApplicationStateUpdating = "UPDATING"
)

// ApplicationState_Values returns all elements of the ApplicationState enum
func ApplicationState_Values() []string {
	return []string{
		ApplicationStateCreating,
		ApplicationStateActive,
		ApplicationStateDeleting,
		ApplicationStateFailed,
		ApplicationStateUpdating,
	}
}

const (
	// EnvironmentStateCreating is a EnvironmentState enum value
	EnvironmentStateCreating = "CREATING"

	// EnvironmentStateActive is a EnvironmentState enum value
	EnvironmentStateActive = "ACTIVE"

	// EnvironmentStateDeleting is a EnvironmentState enum value
	EnvironmentStateDeleting = "DELETING"

	// EnvironmentStateFailed is a EnvironmentState enum value
	EnvironmentStateFailed = "FAILED"
)

// EnvironmentState_Values returns all elements of the EnvironmentState enum
func EnvironmentState_Values() []string {
	return []string{
		EnvironmentStateCreating,
		EnvironmentStateActive,
		EnvironmentStateDeleting,
		EnvironmentStateFailed,
	}
}

const (
	// ErrorCodeInvalidResourceState is a ErrorCode enum value
	ErrorCodeInvalidResourceState = "INVALID_RESOURCE_STATE"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "RESOURCE_LIMIT_EXCEEDED"

	// ErrorCodeResourceCreationFailure is a ErrorCode enum value
	ErrorCodeResourceCreationFailure = "RESOURCE_CREATION_FAILURE"

	// ErrorCodeResourceUpdateFailure is a ErrorCode enum value
	ErrorCodeResourceUpdateFailure = "RESOURCE_UPDATE_FAILURE"

	// ErrorCodeServiceEndpointHealthCheckFailure is a ErrorCode enum value
	ErrorCodeServiceEndpointHealthCheckFailure = "SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE"

	// ErrorCodeResourceDeletionFailure is a ErrorCode enum value
	ErrorCodeResourceDeletionFailure = "RESOURCE_DELETION_FAILURE"

	// ErrorCodeResourceRetrievalFailure is a ErrorCode enum value
	ErrorCodeResourceRetrievalFailure = "RESOURCE_RETRIEVAL_FAILURE"

	// ErrorCodeResourceInUse is a ErrorCode enum value
	ErrorCodeResourceInUse = "RESOURCE_IN_USE"

	// ErrorCodeResourceNotFound is a ErrorCode enum value
	ErrorCodeResourceNotFound = "RESOURCE_NOT_FOUND"

	// ErrorCodeStateTransitionFailure is a ErrorCode enum value
	ErrorCodeStateTransitionFailure = "STATE_TRANSITION_FAILURE"

	// ErrorCodeRequestLimitExceeded is a ErrorCode enum value
	ErrorCodeRequestLimitExceeded = "REQUEST_LIMIT_EXCEEDED"

	// ErrorCodeNotAuthorized is a ErrorCode enum value
	ErrorCodeNotAuthorized = "NOT_AUTHORIZED"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeInvalidResourceState,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeResourceCreationFailure,
		ErrorCodeResourceUpdateFailure,
		ErrorCodeServiceEndpointHealthCheckFailure,
		ErrorCodeResourceDeletionFailure,
		ErrorCodeResourceRetrievalFailure,
		ErrorCodeResourceInUse,
		ErrorCodeResourceNotFound,
		ErrorCodeStateTransitionFailure,
		ErrorCodeRequestLimitExceeded,
		ErrorCodeNotAuthorized,
	}
}

const (
	// ErrorResourceTypeEnvironment is a ErrorResourceType enum value
	ErrorResourceTypeEnvironment = "ENVIRONMENT"

	// ErrorResourceTypeApplication is a ErrorResourceType enum value
	ErrorResourceTypeApplication = "APPLICATION"

	// ErrorResourceTypeRoute is a ErrorResourceType enum value
	ErrorResourceTypeRoute = "ROUTE"

	// ErrorResourceTypeService is a ErrorResourceType enum value
	ErrorResourceTypeService = "SERVICE"

	// ErrorResourceTypeTransitGateway is a ErrorResourceType enum value
	ErrorResourceTypeTransitGateway = "TRANSIT_GATEWAY"

	// ErrorResourceTypeTransitGatewayAttachment is a ErrorResourceType enum value
	ErrorResourceTypeTransitGatewayAttachment = "TRANSIT_GATEWAY_ATTACHMENT"

	// ErrorResourceTypeApiGateway is a ErrorResourceType enum value
	ErrorResourceTypeApiGateway = "API_GATEWAY"

	// ErrorResourceTypeNlb is a ErrorResourceType enum value
	ErrorResourceTypeNlb = "NLB"

	// ErrorResourceTypeTargetGroup is a ErrorResourceType enum value
	ErrorResourceTypeTargetGroup = "TARGET_GROUP"

	// ErrorResourceTypeLoadBalancerListener is a ErrorResourceType enum value
	ErrorResourceTypeLoadBalancerListener = "LOAD_BALANCER_LISTENER"

	// ErrorResourceTypeVpcLink is a ErrorResourceType enum value
	ErrorResourceTypeVpcLink = "VPC_LINK"

	// ErrorResourceTypeLambda is a ErrorResourceType enum value
	ErrorResourceTypeLambda = "LAMBDA"

	// ErrorResourceTypeVpc is a ErrorResourceType enum value
	ErrorResourceTypeVpc = "VPC"

	// ErrorResourceTypeSubnet is a ErrorResourceType enum value
	ErrorResourceTypeSubnet = "SUBNET"

	// ErrorResourceTypeRouteTable is a ErrorResourceType enum value
	ErrorResourceTypeRouteTable = "ROUTE_TABLE"

	// ErrorResourceTypeSecurityGroup is a ErrorResourceType enum value
	ErrorResourceTypeSecurityGroup = "SECURITY_GROUP"

	// ErrorResourceTypeVpcEndpointServiceConfiguration is a ErrorResourceType enum value
	ErrorResourceTypeVpcEndpointServiceConfiguration = "VPC_ENDPOINT_SERVICE_CONFIGURATION"

	// ErrorResourceTypeResourceShare is a ErrorResourceType enum value
	ErrorResourceTypeResourceShare = "RESOURCE_SHARE"

	// ErrorResourceTypeIamRole is a ErrorResourceType enum value
	ErrorResourceTypeIamRole = "IAM_ROLE"
)

// ErrorResourceType_Values returns all elements of the ErrorResourceType enum
func ErrorResourceType_Values() []string {
	return []string{
		ErrorResourceTypeEnvironment,
		ErrorResourceTypeApplication,
		ErrorResourceTypeRoute,
		ErrorResourceTypeService,
		ErrorResourceTypeTransitGateway,
		ErrorResourceTypeTransitGatewayAttachment,
		ErrorResourceTypeApiGateway,
		ErrorResourceTypeNlb,
		ErrorResourceTypeTargetGroup,
		ErrorResourceTypeLoadBalancerListener,
		ErrorResourceTypeVpcLink,
		ErrorResourceTypeLambda,
		ErrorResourceTypeVpc,
		ErrorResourceTypeSubnet,
		ErrorResourceTypeRouteTable,
		ErrorResourceTypeSecurityGroup,
		ErrorResourceTypeVpcEndpointServiceConfiguration,
		ErrorResourceTypeResourceShare,
		ErrorResourceTypeIamRole,
	}
}

const (
	// HttpMethodDelete is a HttpMethod enum value
	HttpMethodDelete = "DELETE"

	// HttpMethodGet is a HttpMethod enum value
	HttpMethodGet = "GET"

	// HttpMethodHead is a HttpMethod enum value
	HttpMethodHead = "HEAD"

	// HttpMethodOptions is a HttpMethod enum value
	HttpMethodOptions = "OPTIONS"

	// HttpMethodPatch is a HttpMethod enum value
	HttpMethodPatch = "PATCH"

	// HttpMethodPost is a HttpMethod enum value
	HttpMethodPost = "POST"

	// HttpMethodPut is a HttpMethod enum value
	HttpMethodPut = "PUT"
)

// HttpMethod_Values returns all elements of the HttpMethod enum
func HttpMethod_Values() []string {
	return []string{
		HttpMethodDelete,
		HttpMethodGet,
		HttpMethodHead,
		HttpMethodOptions,
		HttpMethodPatch,
		HttpMethodPost,
		HttpMethodPut,
	}
}

const (
	// NetworkFabricTypeTransitGateway is a NetworkFabricType enum value
	NetworkFabricTypeTransitGateway = "TRANSIT_GATEWAY"
)

// NetworkFabricType_Values returns all elements of the NetworkFabricType enum
func NetworkFabricType_Values() []string {
	return []string{
		NetworkFabricTypeTransitGateway,
	}
}

const (
	// ProxyTypeApiGateway is a ProxyType enum value
	ProxyTypeApiGateway = "API_GATEWAY"
)

// ProxyType_Values returns all elements of the ProxyType enum
func ProxyType_Values() []string {
	return []string{
		ProxyTypeApiGateway,
	}
}

const (
	// RouteActivationStateActive is a RouteActivationState enum value
	RouteActivationStateActive = "ACTIVE"
)

// RouteActivationState_Values returns all elements of the RouteActivationState enum
func RouteActivationState_Values() []string {
	return []string{
		RouteActivationStateActive,
	}
}

const (
	// RouteStateCreating is a RouteState enum value
	RouteStateCreating = "CREATING"

	// RouteStateActive is a RouteState enum value
	RouteStateActive = "ACTIVE"

	// RouteStateDeleting is a RouteState enum value
	RouteStateDeleting = "DELETING"

	// RouteStateFailed is a RouteState enum value
	RouteStateFailed = "FAILED"

	// RouteStateUpdating is a RouteState enum value
	RouteStateUpdating = "UPDATING"

	// RouteStateInactive is a RouteState enum value
	RouteStateInactive = "INACTIVE"
)

// RouteState_Values returns all elements of the RouteState enum
func RouteState_Values() []string {
	return []string{
		RouteStateCreating,
		RouteStateActive,
		RouteStateDeleting,
		RouteStateFailed,
		RouteStateUpdating,
		RouteStateInactive,
	}
}

const (
	// RouteTypeDefault is a RouteType enum value
	RouteTypeDefault = "DEFAULT"

	// RouteTypeUriPath is a RouteType enum value
	RouteTypeUriPath = "URI_PATH"
)

// RouteType_Values returns all elements of the RouteType enum
func RouteType_Values() []string {
	return []string{
		RouteTypeDefault,
		RouteTypeUriPath,
	}
}

const (
	// ServiceEndpointTypeLambda is a ServiceEndpointType enum value
	ServiceEndpointTypeLambda = "LAMBDA"

	// ServiceEndpointTypeUrl is a ServiceEndpointType enum value
	ServiceEndpointTypeUrl = "URL"
)

// ServiceEndpointType_Values returns all elements of the ServiceEndpointType enum
func ServiceEndpointType_Values() []string {
	return []string{
		ServiceEndpointTypeLambda,
		ServiceEndpointTypeUrl,
	}
}

const (
	// ServiceStateCreating is a ServiceState enum value
	ServiceStateCreating = "CREATING"

	// ServiceStateActive is a ServiceState enum value
	ServiceStateActive = "ACTIVE"

	// ServiceStateDeleting is a ServiceState enum value
	ServiceStateDeleting = "DELETING"

	// ServiceStateFailed is a ServiceState enum value
	ServiceStateFailed = "FAILED"
)

// ServiceState_Values returns all elements of the ServiceState enum
func ServiceState_Values() []string {
	return []string{
		ServiceStateCreating,
		ServiceStateActive,
		ServiceStateDeleting,
		ServiceStateFailed,
	}
}
