/*
    Falling Block Game
    Copyright (C) 1999-2002 Jared Krinke <http://derajdezine.vze.com/>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    This application is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this distribution; if not, write to:
    Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307  USA

    Jared Krinke

    Deraj DeZine
    http://derajdezine.vze.com/
*/

#include <wx/wx.h>
#include <stdlib.h>
#include "startfbg.h"
#include <iostream>
#include <physfs.h>
#ifdef WIN32
#include "splash_win.xpm"
#else
#include "splash.xpm"
#endif
#include "icon.xpm"

IMPLEMENT_APP(fbglaunch)

fbglaunchFrame::fbglaunchFrame(const char* argv0, const fbglaunch* newParent, const wxString& title, int w, int h) : wxFrame(NULL, -1, title, wxDefaultPosition, wxSize(w,h), wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION) {
	// Set up PhysicsFS
	PHYSFS_init(argv0);
#ifdef WIN32
	PHYSFS_addToSearchPath((wxString(PHYSFS_getBaseDir())+"data\\").c_str(), 1);
	PHYSFS_addToSearchPath((wxString(PHYSFS_getUserDir())+"fbg\\data\\").c_str(), 1);
#else
	PHYSFS_addToSearchPath((wxString(PHYSFS_getUserDir())+".fbg/data/").c_str(), 1);
	PHYSFS_addToSearchPath(FBGDATADIR "/data/", 1);
	PHYSFS_addToSearchPath((wxString(PHYSFS_getBaseDir())+"data/").c_str(), 1);
	PHYSFS_addToSearchPath("/usr/local/games/fbg/data/", 1);
	PHYSFS_addToSearchPath("/usr/games/fbg/data/", 1);
#endif

	// Load in .pk3 files
	char** pk3list = PHYSFS_enumerateFiles("");
	for (int i=0; pk3list[i] != NULL; i++) {
		int end;
		for (end=0; pk3list[i][end] != '\0'; end++);
		if (pk3list[i][end-1] == '3' && pk3list[i][end-2] == 'k' && pk3list[i][end-3] == 'p' && pk3list[i][end-4] == '.') {
			PHYSFS_addToSearchPath((wxString(PHYSFS_getRealDir(pk3list[i]))+pk3list[i]).c_str(), 1);
		}
	}
	PHYSFS_freeList(pk3list);

	SetIcon(wxIcon(icon_xpm));

	parent = newParent;
	wxPanel* pan = new wxPanel(this, -1);
	wxBoxSizer* top = new wxBoxSizer(wxVERTICAL);

	wxStaticBoxSizer* graphBox = new wxStaticBoxSizer(new wxStaticBox(pan, -1, "Graphics Options"), wxVERTICAL);
		wxBoxSizer* themeBox = new wxBoxSizer(wxHORIZONTAL);
			themeBox->Add(new wxStaticText(pan, ID_RES, "Theme:"), 1, wxEXPAND|wxALIGN_CENTER_VERTICAL);
				int themeCount = 0;
				int defaultThemeIndex = 0;
				char** list = PHYSFS_enumerateFiles("themes");
				for (int i=0; list[i] != NULL; i++) {
					if (PHYSFS_isDirectory(wxString("themes/")+list[i])) themeCount++;
					if (wxString(list[i]) == wxT("default")) defaultThemeIndex = themeCount-1;
				}
				wxString* themeChoices;
				if (themeCount > 0) {
					themeChoices = new wxString[themeCount];
					int currentTheme = 0;
					for (int i=0; list[i] != NULL; i++) {
						if (PHYSFS_isDirectory(wxString("themes/")+list[i])) themeChoices[currentTheme++] = wxString(list[i]);
					}
				}
				PHYSFS_freeList(list);
			themeMenu = new wxChoice(pan, ID_THEME, wxDefaultPosition, wxDefaultSize, themeCount, themeChoices);
			delete themeChoices;
			themeMenu->SetSelection(defaultThemeIndex);
			themeBox->Add(themeMenu, 0, wxALIGN_RIGHT);
#ifdef ENABLE_SOUND
		wxBoxSizer* musicBox = new wxBoxSizer(wxHORIZONTAL);
			musicCheck = new wxCheckBox(pan, ID_MUSIC_CHECK, "Music");
			musicBox->Add(musicCheck, 1, wxALIGN_LEFT);
			musicBox->Add(new wxStaticText(pan, -1, "File: ", wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT), 1, wxALIGN_CENTER_VERTICAL);
			int musicCount = 0;
			int defaultMusicIndex = 0;
			char** mList = PHYSFS_enumerateFiles("music");
			for (int i=0; mList[i] != NULL; i++) {
				musicCount++;
				if (wxString(mList[i]) == wxT("typea.it")) defaultMusicIndex = musicCount-1;
			}
			wxString* musicChoices;
			if (musicCount > 0) {
				musicChoices = new wxString[musicCount];
				int currentMusic = 0;
				for (int i=0; mList[i] != NULL; i++) musicChoices[currentMusic] = wxString(mList[i]);
			}
			PHYSFS_freeList(mList);
			musicMenu = new wxChoice(pan, ID_MUSIC, wxDefaultPosition, wxDefaultSize, musicCount, musicChoices);
			musicMenu->SetSelection(defaultMusicIndex);
			musicCheck->SetValue(true);
			musicBox->Add(musicMenu, 0, wxALIGN_RIGHT);
#endif
		wxBoxSizer* resBox = new wxBoxSizer(wxHORIZONTAL);
			resBox->Add(new wxStaticText(pan, ID_RES, "Resolution:"), 1, wxEXPAND|wxALIGN_CENTER_VERTICAL);
			wxString resChoices[4] = {"320x240", "640x480", "800x600", "1024x768"};
			resMenu = new wxChoice(pan, ID_RES, wxDefaultPosition, wxDefaultSize, 4, resChoices);
			resMenu->SetSelection(1);
			resBox->Add(resMenu, 0, wxALIGN_RIGHT);
		wxBoxSizer* bppBox = new wxBoxSizer(wxHORIZONTAL);
			bppBox->Add(new wxStaticText(pan, ID_BPP, "Color Depth:"), 1, wxEXPAND|wxALIGN_CENTER_VERTICAL);
			wxString bppChoices[3] = {"16", "24", "32"};
			bppMenu = new wxChoice(pan, ID_BPP, wxDefaultPosition, wxDefaultSize, 3, bppChoices);
			bppMenu->SetSelection(2);
			bppBox->Add(bppMenu, 0, wxALIGN_RIGHT);
		wxBoxSizer* fsBox = new wxBoxSizer(wxHORIZONTAL);
			fsCheck = new wxCheckBox(pan, ID_FS, "Run Fullscreen");
			fsBox->Add(fsCheck, 0, wxALIGN_LEFT);
#ifdef WIN32
			fsCheck->SetValue(true);
#else
			fsCheck->SetValue(false);
#endif
		wxBoxSizer* lightBox = new wxBoxSizer(wxHORIZONTAL);
			lightCheck = new wxCheckBox(pan, ID_LIGHT, "\"Light\" Mode (uses less CPU)");
			lightBox->Add(lightCheck, 0, wxALIGN_LEFT);
		graphBox->Add(themeBox, 0, wxEXPAND);
#ifdef ENABLE_SOUND
		graphBox->Add(musicBox, 0, wxEXPAND);
#endif
		graphBox->Add(resBox, 0, wxEXPAND);
		graphBox->Add(bppBox, 0, wxEXPAND);
		graphBox->Add(fsBox, 0, wxALIGN_LEFT);
		graphBox->Add(lightBox, 0, wxALIGN_LEFT);
	wxStaticBoxSizer* gameBox = new wxStaticBoxSizer(new wxStaticBox(pan, -1, "Gameplay Options"), wxVERTICAL);
		wxBoxSizer* levelBox = new wxBoxSizer(wxHORIZONTAL);
			levelBox->Add(new wxStaticText(pan, -1, "Starting Level:"), 1, wxEXPAND|wxALIGN_CENTER_VERTICAL);
			wxString levelChoices[10] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
			levelMenu = new wxChoice(pan, ID_LEVEL, wxDefaultPosition, wxDefaultSize, 10, levelChoices);
			levelMenu->SetSelection(0);
			levelBox->Add(levelMenu, 0, wxALIGN_RIGHT);
		gameBox->Add(levelBox, 0, wxEXPAND);
		wxBoxSizer* btypeBox = new wxBoxSizer(wxHORIZONTAL);
			btypeCheck = new wxCheckBox(pan, ID_BTYPE_CHECK, "B-Type");
			btypeBox->Add(btypeCheck, 1, wxALIGN_LEFT);
			btypeBox->Add(new wxStaticText(pan, -1, "Height: ", wxDefaultPosition, wxDefaultSize, wxALIGN_RIGHT), 1, wxALIGN_CENTER_VERTICAL);
			wxString btypeChoices[9] = {"0", "1", "2", "3", "4", "5"};
			btypeMenu = new wxChoice(pan, ID_BTYPE, wxDefaultPosition, wxDefaultSize, 6, btypeChoices);
			btypeMenu->Enable(false);
			btypeMenu->SetSelection(0);
			btypeBox->Add(btypeMenu, 0, wxALIGN_RIGHT);
		gameBox->Add(btypeBox, 0, wxEXPAND);

#ifdef WIN32
	top->Add(new wxStaticBitmap(pan, -1, wxBitmap(wxBitmap(splash_win_xpm))), 0, wxALIGN_CENTER, 4);
#else
	top->Add(new wxStaticBitmap(pan, -1, wxBitmap(wxBitmap(splash_xpm))), 0, wxALIGN_CENTER, 4);
#endif
	top->Add(graphBox, 0, wxEXPAND|wxALL, 2);
	top->Add(gameBox, 0, wxEXPAND|wxALL, 2);
		playButton = new wxButton(pan, ID_PLAY, "Play Falling Block Game");
		pan->SetDefaultItem(playButton);
	top->Add(playButton, 0, wxEXPAND|wxALL, 1);
	pan->SetAutoLayout(true);
	pan->SetSizer(top);

	top->Fit(this);
	top->SetSizeHints(this);
}

void fbglaunchFrame::OnQuit(wxCommandEvent WXUNUSED(event)) {
	PHYSFS_deinit();
	Close(true);
}

BEGIN_EVENT_TABLE(fbglaunchFrame, wxFrame)
	EVT_BUTTON(fbglaunchFrame::ID_PLAY, fbglaunchFrame::clickPlay)
	EVT_CHECKBOX(fbglaunchFrame::ID_BTYPE_CHECK, fbglaunchFrame::checkBType)
#ifdef ENABLE_SOUND
	EVT_CHECKBOX(fbglaunchFrame::ID_MUSIC_CHECK, fbglaunchFrame::checkMusic)
#endif
END_EVENT_TABLE()

bool fbglaunch::OnInit() {
	frame = new fbglaunchFrame(argv[0], this, "Falling Block Game"/* " v" VERSION*/, 400, 400);
	frame->Show(true);
	SetTopWindow(frame);
	return true;
}

void fbglaunchFrame::clickPlay(wxCommandEvent& evt) {
	parent->launchFBG(wxString(PHYSFS_getBaseDir())+"fbg" FBG_EXTENSION, fsCheck->GetValue(), lightCheck->GetValue(), themeMenu->GetStringSelection(),
#ifdef ENABLE_SOUND
		(musicCheck->GetValue() ? musicMenu->GetStringSelection() : wxString("")),
#endif
		bppMenu->GetStringSelection(), resMenu->GetStringSelection(), levelMenu->GetStringSelection(), (btypeMenu->IsEnabled() ? btypeMenu->GetStringSelection() : wxString(wxT("-1"))));
}

void fbglaunchFrame::checkBType(wxCommandEvent& evt) {
	btypeMenu->Enable(btypeCheck->GetValue() ? true : false);
}
#ifdef ENABLE_SOUND
void fbglaunchFrame::checkMusic(wxCommandEvent& evt) {
	musicMenu->Enable(musicCheck->GetValue() ? true : false);
}
#endif

void fbglaunch::launchFBG(const wxString& fbgBin, bool fs, bool light, const wxString& theme,
#ifdef ENABLE_SOUND
const wxString& music,
#endif
const wxString& bpp, const wxString& res, const wxString& level, const wxString& btype) const {
	wxString cmd = "\""+fbgBin+"\"";
	cmd += (fs ? " -f" : " -w");
	if (light) cmd += " --light";
	cmd += " -t " + theme;
#ifdef ENABLE_SOUND
	if (music != "") cmd += " -m " + music;
	else cmd += " --no-music ";
#endif
	cmd += " -d " + bpp;
	cmd += " -r " + res;
	cmd += " -l " + level;
	if (btype != "-1") cmd += " -b " + btype;
	system(cmd);
}

int fbglaunch::OnExit() {
}
