/*
 * Copyright (C) 2002  Mihai RUSU (dizzy@roedu.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
			      

#ifndef __LINEAR_LIST_H__
#define __LINEAR_LIST_H__

#include <stdlib.h>

typedef struct list_elem_struct {
   void * data;
   struct list_elem_struct *prev, *next;
} t_list_elem;

typedef struct list_struct {
   t_list_elem *head, *tail;
   int no;
} t_list;

#define LIST_FIRST(list) ((list)->head)
#define LIST_LAST(list) ((list)->tail)
#define LIST_NEXT(p) ((p)->next)

extern struct list_struct * list_init(void);
extern int list_purge(t_list*);
extern int list_free(t_list*);
extern int list_insert_data(t_list*, void *);
extern int list_append_data(t_list*, void *);
extern int list_delete_by_elem(t_list*, t_list_elem *);
extern int list_get_size(t_list*);
extern void * list_fetch(t_list*);
extern t_list_elem* elem_create(void);
extern void elem_destroy(t_list_elem*);
extern int elem_set_data(t_list_elem *, void *);
extern void * elem_get_data(t_list_elem *);

#endif
