/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderConstants;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class ResourceRecord {
    private String name;
    private int rrType;
    private int rrClass;
    private long ttl;
    private Object rData;

    public ResourceRecord() {
    }

    public ResourceRecord(String name, int rrType, int rrClass, long ttl, Object rData) {
        this.name = name;
        this.rrType = rrType;
        this.rrClass = rrClass;
        this.ttl = ttl;
        this.rData = rData;
    }

    public int writeBytes(byte[] buffer, int startIdx) throws DomainProtocolException {
        int idx = startIdx;
        if (buffer == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        idx = ProviderMgr.writeName(this.name, buffer, idx);
        idx = ProviderMgr.write16Int(this.rrType, buffer, idx);
        idx = ProviderMgr.write16Int(this.rrClass, buffer, idx);
        idx = ProviderMgr.write32Int(this.ttl, buffer, idx);
        if (this.rrType == 2 || this.rrType == 5 || this.rrType == 12) {
            int idx0 = idx;
            idx += 2;
            idx = ProviderMgr.writeName((String)this.rData, buffer, idx);
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else if (this.rrType == 1) {
            byte[] ipBytes = ProviderMgr.parseIpStr((String)this.rData);
            idx = ProviderMgr.write16Int(ipBytes.length, buffer, idx);
            byte[] byArray = ipBytes;
            int n = 0;
            int n2 = byArray.length;
            while (n < n2) {
                byte element = byArray[n];
                buffer[idx++] = element;
                ++n;
            }
        } else if (this.rrType == 6) {
            StringTokenizer st = new StringTokenizer((String)this.rData, " ");
            int idx0 = idx;
            if (st.countTokens() != 7) {
                throw new DomainProtocolException(Messages.getString("jndi.35"));
            }
            idx += 2;
            String token = st.nextToken();
            idx = ProviderMgr.writeName(token, buffer, idx);
            token = st.nextToken();
            idx = ProviderMgr.writeName(token, buffer, idx);
            try {
                int i = 0;
                while (i < 5) {
                    token = st.nextToken();
                    idx = ProviderMgr.write32Int(Long.parseLong(token), buffer, idx);
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw new DomainProtocolException(Messages.getString("jndi.36"), e);
            }
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else if (this.rrType == 15) {
            StringTokenizer st = new StringTokenizer((String)this.rData, " ");
            int idx0 = idx;
            if (st.countTokens() != 2) {
                throw new DomainProtocolException(Messages.getString("jndi.37"));
            }
            idx += 2;
            String token = st.nextToken();
            try {
                ProviderMgr.write16Int(Integer.parseInt(token), buffer, idx);
            }
            catch (NumberFormatException e) {
                throw new DomainProtocolException(Messages.getString("jndi.38"), e);
            }
            token = st.nextToken();
            idx = ProviderMgr.writeName(token, buffer, idx);
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else if (this.rrType == 13) {
            StringTokenizer st = new StringTokenizer((String)this.rData, " ");
            int idx0 = idx;
            if (st.countTokens() != 2) {
                throw new DomainProtocolException(Messages.getString("jndi.39"));
            }
            idx += 2;
            int i = 0;
            while (i < 2) {
                String token = st.nextToken();
                idx = ProviderMgr.writeCharString(token, buffer, idx);
                ++i;
            }
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else if (this.rrType == 16) {
            int idx0 = idx;
            StringTokenizer st = new StringTokenizer((String)this.rData, " ");
            idx += 2;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.getBytes().length > 255) {
                    throw new DomainProtocolException(Messages.getString("jndi.3A"));
                }
                idx = ProviderMgr.writeCharString(token, buffer, idx);
            }
            if (idx - 2 - idx0 > 65535) {
                throw new DomainProtocolException(Messages.getString("jndi.3B"));
            }
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else if (this.rrType == 33) {
            String token;
            StringTokenizer st = new StringTokenizer((String)this.rData, " ");
            int idx0 = idx;
            idx += 2;
            if (st.countTokens() != 4) {
                throw new DomainProtocolException(Messages.getString("jndi.3C"));
            }
            try {
                int i = 0;
                while (i < 3) {
                    token = st.nextToken();
                    idx = ProviderMgr.write16Int(Integer.parseInt(token), buffer, idx);
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                throw new DomainProtocolException(Messages.getString("jndi.3D"), e);
            }
            token = st.nextToken();
            idx = ProviderMgr.writeName(token, buffer, idx);
            ProviderMgr.write16Int(idx - 2 - idx0, buffer, idx0);
        } else {
            if (!(this.rData instanceof byte[])) {
                throw new DomainProtocolException(Messages.getString("jndi.3E", this.rrType));
            }
            byte[] bytes = (byte[])this.rData;
            idx = ProviderMgr.write16Int(bytes.length, buffer, idx);
            byte[] byArray = bytes;
            int n = 0;
            int n3 = byArray.length;
            while (n < n3) {
                byte element = byArray[n];
                buffer[idx++] = element;
                ++n;
            }
        }
        return idx;
    }

    public static int parseRecord(byte[] mesBytes, int startIdx, ResourceRecord resultRR) throws DomainProtocolException {
        int idx = startIdx;
        StringBuffer nameSB = new StringBuffer();
        Object rDat = null;
        if (resultRR == null) {
            throw new NullPointerException(Messages.getString("jndi.3F"));
        }
        idx = ProviderMgr.parseName(mesBytes, idx, nameSB);
        resultRR.setName(ProviderMgr.normalizeName(nameSB.toString()));
        int rrType = ProviderMgr.parse16Int(mesBytes, idx);
        resultRR.setRRType(rrType);
        resultRR.setRRClass(ProviderMgr.parse16Int(mesBytes, idx += 2));
        resultRR.setTtl(ProviderMgr.parse32Int(mesBytes, idx += 2));
        int rdLen = ProviderMgr.parse16Int(mesBytes, idx += 4);
        idx += 2;
        if (rrType == 2 || rrType == 5 || rrType == 12) {
            StringBuffer name = new StringBuffer();
            idx = ProviderMgr.parseName(mesBytes, idx, name);
            rDat = ProviderMgr.normalizeName(name.toString());
        } else if (rrType == 1) {
            byte[] tmpArr = new byte[4];
            int i = 0;
            while (i < 4) {
                tmpArr[i] = mesBytes[idx + i];
                ++i;
            }
            rDat = ProviderMgr.getIpStr(tmpArr);
            idx += 4;
        } else if (rrType == 15) {
            StringBuffer name = new StringBuffer();
            int preference = ProviderMgr.parse16Int(mesBytes, idx);
            idx += 2;
            idx = ProviderMgr.parseName(mesBytes, idx, name);
            rDat = preference + " " + ProviderMgr.normalizeName(name.toString());
        } else if (rrType == 6) {
            StringBuffer mName = new StringBuffer();
            StringBuffer rName = new StringBuffer();
            idx = ProviderMgr.parseName(mesBytes, idx, mName);
            idx = ProviderMgr.parseName(mesBytes, idx, rName);
            long serial = ProviderMgr.parse32Int(mesBytes, idx);
            long refresh = ProviderMgr.parse32Int(mesBytes, idx += 4);
            long retry = ProviderMgr.parse32Int(mesBytes, idx += 4);
            long expire = ProviderMgr.parse32Int(mesBytes, idx += 4);
            long minimum = ProviderMgr.parse32Int(mesBytes, idx += 4);
            idx += 4;
            rDat = String.valueOf(ProviderMgr.normalizeName(mName.toString())) + " " + ProviderMgr.normalizeName(rName.toString()) + " " + serial + " " + refresh + " " + retry + " " + expire + " " + minimum;
        } else if (rrType == 16) {
            StringBuffer sbuf = new StringBuffer();
            int idx0 = idx;
            while (true) {
                int len11;
                if (idx - idx0 + (len11 = ProviderMgr.parse8Int(mesBytes, idx++)) > rdLen) {
                    --idx;
                    break;
                }
                if (sbuf.length() > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(new String(mesBytes, idx, len11));
                idx += len11;
            }
            rDat = sbuf.toString();
        } else if (rrType == 13) {
            StringBuffer res = new StringBuffer();
            idx = ProviderMgr.parseCharString(mesBytes, idx, res);
            res.append(" ");
            idx = ProviderMgr.parseCharString(mesBytes, idx, res);
            rDat = res.toString();
        } else if (rrType == 33) {
            StringBuffer name = new StringBuffer();
            int priority = ProviderMgr.parse16Int(mesBytes, idx);
            int weight = ProviderMgr.parse16Int(mesBytes, idx += 2);
            int port = ProviderMgr.parse16Int(mesBytes, idx += 2);
            idx += 2;
            idx = ProviderMgr.parseName(mesBytes, idx, name);
            rDat = priority + " " + weight + " " + port + " " + ProviderMgr.normalizeName(name.toString());
        } else {
            rDat = new byte[rdLen];
            int i = 0;
            while (i < rdLen) {
                ((byte[])rDat)[i] = mesBytes[idx++];
                ++i;
            }
        }
        resultRR.setRData(rDat);
        return idx;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(" ");
        sb.append(ProviderConstants.rrTypeNames[this.rrType]);
        sb.append(" ");
        sb.append(this.rrClass);
        sb.append(" ");
        sb.append("TTL=" + this.ttl);
        sb.append(" ");
        sb.append(this.rData.toString());
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getRData() {
        return this.rData;
    }

    public void setRData(Object data) {
        this.rData = data;
    }

    public int getRRClass() {
        return this.rrClass;
    }

    public void setRRClass(int rrClass) {
        this.rrClass = rrClass;
    }

    public int getRRType() {
        return this.rrType;
    }

    public void setRRType(int rrType) {
        this.rrType = rrType;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }
}

