/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.lang.reflect.Field;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLExceptionTest
extends TestCase {
    static long theFixedSUID = 2135244094396331484L;
    private static final SerializationTest.SerializableAssert SQLEXCEPTION_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public void testSUID() {
        try {
            Class<?> theClass = Class.forName("java.sql.SQLException");
            Field theField = theClass.getDeclaredField("serialVersionUID");
            theField.setAccessible(true);
            long theSUID = theField.getLong(null);
            SQLExceptionTest.assertEquals((String)"SUID mismatch: ", (long)theFixedSUID, (long)theSUID);
        }
        catch (Exception e) {
            System.out.println("SUID check got exception: " + e.getMessage());
        }
    }

    public void testSQLExceptionStringStringint() {
        String[] stringArray = new String[13];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[4] = "&valid*";
        stringArray[5] = "1";
        stringArray[6] = "a";
        stringArray[8] = "";
        stringArray[9] = "\u0000";
        stringArray[10] = "a";
        stringArray[11] = "a";
        stringArray[12] = "a";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[13];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[5] = "a";
        stringArray2[6] = "&valid*";
        stringArray2[7] = "a";
        stringArray2[8] = "a";
        stringArray2[9] = "a";
        stringArray2[11] = "";
        stringArray2[12] = "\u0000";
        String[] init2 = stringArray2;
        int[] nArray = new int[13];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 48429456;
        nArray[4] = 1770127344;
        nArray[5] = 1047282235;
        nArray[6] = -545472907;
        nArray[7] = Integer.MIN_VALUE;
        nArray[8] = Integer.MIN_VALUE;
        nArray[9] = Integer.MIN_VALUE;
        nArray[10] = Integer.MIN_VALUE;
        nArray[11] = Integer.MIN_VALUE;
        nArray[12] = Integer.MIN_VALUE;
        int[] init3 = nArray;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = init3;
        SQLException[] theFinalStates4 = new SQLException[13];
        Exception[] theExceptions = new Exception[13];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i], init3[i]);
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail();
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testSQLExceptionStringString() {
        String[] stringArray = new String[11];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[4] = "&valid*";
        stringArray[6] = "";
        stringArray[7] = "\u0000";
        stringArray[8] = "a";
        stringArray[9] = "a";
        stringArray[10] = "a";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[11];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[5] = "a";
        stringArray2[6] = "a";
        stringArray2[7] = "a";
        stringArray2[9] = "";
        stringArray2[10] = "\u0000";
        String[] init2 = stringArray2;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = new int[11];
        SQLException[] theFinalStates4 = new SQLException[11];
        Exception[] theExceptions = new Exception[11];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i]);
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail();
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testSQLExceptionString() {
        String[] init1;
        String[] stringArray = new String[8];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[4] = "&valid*";
        stringArray[6] = "";
        stringArray[7] = "\u0000";
        String[] theFinalStates1 = init1 = stringArray;
        String[] theFinalStates2 = new String[8];
        int[] theFinalStates3 = new int[8];
        SQLException[] theFinalStates4 = new SQLException[8];
        Exception[] theExceptions = new Exception[8];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i]);
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail();
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testSQLException() {
        String[] theFinalStates1 = new String[1];
        String[] theFinalStates2 = new String[1];
        int[] theFinalStates3 = new int[1];
        SQLException[] theFinalStates4 = new SQLException[1];
        Exception[] theExceptions = new Exception[1];
        int loopCount = 1;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException();
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail();
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testGetErrorCode() {
        int[] init3;
        String[] stringArray = new String[7];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[5] = "&valid*";
        stringArray[6] = "1";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[6] = "a";
        String[] init2 = stringArray2;
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 48429456;
        nArray[4] = 1770127344;
        nArray[5] = 1047282235;
        nArray[6] = -545472907;
        int[] theReturns = init3 = nArray;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = init3;
        SQLException[] theFinalStates4 = new SQLException[7];
        Exception[] theExceptions = new Exception[7];
        int loopCount = 1;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i], init3[i]);
                int theReturn = aSQLException.getErrorCode();
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Exception missed"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Return value mismatch"), (int)theReturn, (int)theReturns[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testGetNextException() {
        SQLException[] init4;
        String[] stringArray = new String[7];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[5] = "&valid*";
        stringArray[6] = "1";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[6] = "a";
        String[] init2 = stringArray2;
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 48429456;
        nArray[4] = 1770127344;
        nArray[5] = 1047282235;
        nArray[6] = -545472907;
        int[] init3 = nArray;
        SQLException[] sQLExceptionArray = new SQLException[7];
        sQLExceptionArray[0] = new SQLException();
        sQLExceptionArray[2] = new SQLException();
        sQLExceptionArray[3] = new SQLException();
        sQLExceptionArray[4] = new SQLException();
        sQLExceptionArray[6] = new SQLException();
        SQLException[] theReturns = init4 = sQLExceptionArray;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = init3;
        SQLException[] theFinalStates4 = init4;
        Exception[] theExceptions = new Exception[7];
        int loopCount = init1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i], init3[i]);
                aSQLException.setNextException(init4[i]);
                SQLException theReturn = aSQLException.getNextException();
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Exception missed"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Return value mismatch"), (Object)theReturn, (Object)theReturns[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testGetSQLState() {
        String[] stringArray = new String[7];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[5] = "&valid*";
        stringArray[6] = "1";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[6] = "a";
        String[] init2 = stringArray2;
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 48429456;
        nArray[4] = 1770127344;
        nArray[5] = 1047282235;
        nArray[6] = -545472907;
        int[] init3 = nArray;
        String[] theReturns = init2;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = init3;
        SQLException[] theFinalStates4 = new SQLException[7];
        Exception[] theExceptions = new Exception[7];
        int loopCount = 1;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i], init3[i]);
                String theReturn = aSQLException.getSQLState();
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Exception missed"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Return value mismatch"), (String)theReturn, (String)theReturns[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testSetNextExceptionSQLException() {
        SQLException[] sQLExceptionArray = new SQLException[7];
        sQLExceptionArray[0] = new SQLException();
        sQLExceptionArray[2] = new SQLException();
        sQLExceptionArray[3] = new SQLException();
        sQLExceptionArray[4] = new SQLException();
        sQLExceptionArray[6] = new SQLException();
        SQLException[] parm1 = sQLExceptionArray;
        String[] stringArray = new String[7];
        stringArray[0] = "a";
        stringArray[1] = "1";
        stringArray[2] = "valid1";
        stringArray[3] = "----";
        stringArray[5] = "&valid*";
        stringArray[6] = "1";
        String[] init1 = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[0] = "a";
        stringArray2[1] = "1";
        stringArray2[2] = "valid1";
        stringArray2[3] = "----";
        stringArray2[4] = "&valid*";
        stringArray2[6] = "a";
        String[] init2 = stringArray2;
        int[] nArray = new int[7];
        nArray[0] = Integer.MIN_VALUE;
        nArray[1] = Integer.MAX_VALUE;
        nArray[3] = 48429456;
        nArray[4] = 1770127344;
        nArray[5] = 1047282235;
        nArray[6] = -545472907;
        int[] init3 = nArray;
        String[] theFinalStates1 = init1;
        String[] theFinalStates2 = init2;
        int[] theFinalStates3 = init3;
        SQLException[] theFinalStates4 = parm1;
        Exception[] theExceptions = new Exception[11];
        int loopCount = parm1.length;
        int i = 0;
        while (i < loopCount) {
            try {
                SQLException aSQLException = new SQLException(init1[i], init2[i], init3[i]);
                aSQLException.setNextException(parm1[i]);
                if (theExceptions[i] != null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Exception missed"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getMessage(), (String)theFinalStates1[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (String)aSQLException.getSQLState(), (String)theFinalStates2[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (int)aSQLException.getErrorCode(), (int)theFinalStates3[i]);
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "  Final state mismatch"), (Object)aSQLException.getNextException(), (Object)theFinalStates4[i]);
            }
            catch (Exception e) {
                if (theExceptions[i] == null) {
                    SQLExceptionTest.fail((String)(String.valueOf(i) + "Unexpected exception"));
                }
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), e.getClass(), theExceptions[i].getClass());
                SQLExceptionTest.assertEquals((String)(String.valueOf(i) + "Exception mismatch"), (String)e.getMessage(), (String)theExceptions[i].getMessage());
            }
            ++i;
        }
    }

    public void testSerializationSelf() throws Exception {
        SQLException object = new SQLException();
        SerializationTest.verifySelf((Object)object, (SerializationTest.SerializableAssert)SQLEXCEPTION_COMPARATOR);
    }

    public void testSerializationCompatibility() throws Exception {
        SQLException nextSQLException = new SQLException("nextReason", "nextSQLState", 33);
        int vendorCode = 10;
        SQLException object = new SQLException("reason", "SQLState", vendorCode);
        object.setNextException(nextSQLException);
        SerializationTest.verifyGolden((TestCase)this, (Object)object, (SerializationTest.SerializableAssert)SQLEXCEPTION_COMPARATOR);
    }

    public void test_setNextException_LSQLException() {
        SQLException se1 = new SQLException("reason", "SQLState", 1);
        SQLException se2 = new SQLException("reason", "SQLState", 2);
        SQLException se3 = new SQLException("reason", "SQLState", 3);
        SQLException se4 = new SQLException("reason", "SQLState", 4);
        se1.setNextException(se2);
        SQLExceptionTest.assertSame((Object)se2, (Object)se1.getNextException());
        se1.setNextException(se3);
        SQLExceptionTest.assertSame((Object)se2, (Object)se1.getNextException());
        SQLExceptionTest.assertSame((Object)se3, (Object)se2.getNextException());
        SQLExceptionTest.assertNull((Object)se3.getNextException());
        se3.setNextException(null);
        SQLExceptionTest.assertNull((Object)se3.getNextException());
        se3.setNextException(se4);
        SQLExceptionTest.assertSame((Object)se4, (Object)se3.getNextException());
    }

    static /* synthetic */ SerializationTest.SerializableAssert access$0() {
        return SQLEXCEPTION_COMPARATOR;
    }
}

