/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.glmlicon;

import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.GlyphListModelList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GLMLTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Image> imageResources;
    private static final Map<String, Map<String, Image>> mappedImages;
    private static final BufferedImage[] subtableImages;

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            Dimension dimension = jLabel.getPreferredSize();
            int n2 = GLMLTreeCellRenderer.getViewportWidth(jTree);
            if (dimension.width < n2) {
                dimension.width = n2;
            }
            if (dimension.height < 24) {
                dimension.height = 24;
            }
            jLabel.setPreferredSize(dimension);
            jLabel.setIcon(new ImageIcon(GLMLTreeCellRenderer.getImageForTreeCell(object)));
        }
        return component;
    }

    private static int getViewportWidth(Component component) {
        while (component != null) {
            if (component instanceof JViewport) {
                return component.getWidth();
            }
            component = component.getParent();
        }
        return -1;
    }

    private static Image getImageForTreeCell(Object object) {
        GlyphListModel glyphListModel;
        if (object instanceof GlyphListModelList.GlyphListModelTreeNode && (glyphListModel = ((GlyphListModelList.GlyphListModelTreeNode)object).getModel()) != null) {
            Image image;
            Map<String, Image> map;
            String string = glyphListModel.getIconGroup();
            String string2 = object.toString();
            if (string.equals("subtable")) {
                try {
                    int n = Integer.parseInt(string2.substring(string2.length() - 2), 16);
                    if (subtableImages[n] != null) {
                        return subtableImages[n];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((map = mappedImages.get(string)) != null && (image = map.get(string2)) != null) {
                return image;
            }
        }
        return GLMLTreeCellRenderer.getImage("unknown.png");
    }

    private static Image getImage(String string) {
        Image image = imageResources.get(string);
        if (image != null) {
            return image;
        }
        URL uRL = GLMLTreeCellRenderer.class.getResource(string);
        if (uRL == null) {
            return null;
        }
        image = Toolkit.getDefaultToolkit().createImage(uRL);
        if (image == null) {
            return null;
        }
        imageResources.put(string, image);
        return image;
    }

    static {
        Object object;
        imageResources = new HashMap<String, Image>();
        mappedImages = new HashMap<String, Map<String, Image>>();
        Object object2 = new Scanner(GLMLTreeCellRenderer.class.getResourceAsStream("index.txt"));
        while (((Scanner)object2).hasNextLine()) {
            Image image;
            String[] stringArray = ((Scanner)object2).nextLine().trim().split("\\s+", 3);
            if (stringArray.length != 3 || (image = GLMLTreeCellRenderer.getImage(stringArray[0])) == null) continue;
            object = mappedImages.get(stringArray[1]);
            if (object == null) {
                object = new HashMap();
                mappedImages.put(stringArray[1], (Map<String, Image>)object);
            }
            object.put(stringArray[2], image);
        }
        ((Scanner)object2).close();
        subtableImages = new BufferedImage[256];
        try {
            object2 = ImageIO.read(GLMLTreeCellRenderer.class.getResource("subtable.png"));
            int n = ((BufferedImage)object2).getWidth() / 32;
            int n2 = ((BufferedImage)object2).getHeight();
            object = new int[n * n2];
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    BufferedImage bufferedImage = new BufferedImage(n * 2, n2, 2);
                    ((BufferedImage)object2).getRGB(i * 2 * n, 0, n, n2, (int[])object, 0, n);
                    bufferedImage.setRGB(0, 0, n, n2, (int[])object, 0, n);
                    ((BufferedImage)object2).getRGB((j * 2 + 1) * n, 0, n, n2, (int[])object, 0, n);
                    bufferedImage.setRGB(n, 0, n, n2, (int[])object, 0, n);
                    GLMLTreeCellRenderer.subtableImages[i << 4 | j] = bufferedImage;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

