/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import java.io.ByteArrayOutputStream;

public class PETSCII {
    public static final int[] PRIMARY_G0 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 163, 93, 8593, 8592, 9472, 9824, 129906, 129912, 129911, 129910, 129914, 129905, 129908, 9582, 9584, 9583, 129916, 9586, 9585, 129917, 129918, 8226, 129915, 9829, 129904, 9581, 9587, 9675, 9827, 129909, 9830, 9532, 129932, 9474, 960, 9701};
    public static final int[] PRIMARY_G1 = new int[]{160, 9612, 9604, 9620, 9601, 9615, 9618, 9621, 129935, 9700, 129927, 9500, 9623, 9492, 9488, 9602, 9484, 9524, 9516, 9508, 9614, 9613, 129928, 129922, 129923, 9603, 129919, 9622, 9629, 9496, 9624, 9626, 9472, 9824, 129906, 129912, 129911, 129910, 129914, 129905, 129908, 9582, 9584, 9583, 129916, 9586, 9585, 129917, 129918, 8226, 129915, 9829, 129904, 9581, 9587, 9675, 9827, 129909, 9830, 9532, 129932, 9474, 960, 9701, 160, 9612, 9604, 9620, 9601, 9615, 9618, 9621, 129935, 9700, 129927, 9500, 9623, 9492, 9488, 9602, 9484, 9524, 9516, 9508, 9614, 9613, 129928, 129922, 129923, 9603, 129919, 9622, 9629, 9496, 9624, 9626};
    public static final int[] ALTERNATE_G0 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 163, 93, 8593, 8592, 9472, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 9532, 129932, 9474, 129942, 129944};
    public static final int[] ALTERNATE_G1 = new int[]{160, 9612, 9604, 9620, 9601, 9615, 9618, 9621, 129935, 129945, 129927, 9500, 9623, 9492, 9488, 9602, 9484, 9524, 9516, 9508, 9614, 9613, 129928, 129922, 129923, 9603, 10003, 9622, 9629, 9496, 9624, 9626, 9472, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 9532, 129932, 9474, 129942, 129944, 160, 9612, 9604, 9620, 9601, 9615, 9618, 9621, 129935, 129945, 129927, 9500, 9623, 9492, 9488, 9602, 9484, 9524, 9516, 9508, 9614, 9613, 129928, 129922, 129923, 9603, 10003, 9622, 9629, 9496, 9624, 9626};

    public static int toUnicode(int n, boolean bl) {
        if ((n &= 0xFF) >= 32 && n <= 127) {
            return (bl ? ALTERNATE_G0 : PRIMARY_G0)[n - 32];
        }
        if (n >= 160 && n <= 255) {
            return (bl ? ALTERNATE_G1 : PRIMARY_G1)[n - 160];
        }
        return n;
    }

    public static int fromUnicode(int n, boolean bl) {
        int n2;
        if (n >= 0 && n <= 31) {
            return n;
        }
        if (n >= 128 && n <= 159) {
            return n;
        }
        for (n2 = 0; n2 < 96; ++n2) {
            if ((bl ? ALTERNATE_G0 : PRIMARY_G0)[n2] != n) continue;
            return n2 + 32;
        }
        for (n2 = 0; n2 < 96; ++n2) {
            if ((bl ? ALTERNATE_G1 : PRIMARY_G1)[n2] != n) continue;
            return n2 + 160;
        }
        return 63;
    }

    public static String toString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = PETSCII.toUnicode(byArray[i], bl);
            stringBuffer.append(Character.toChars(n));
        }
        return stringBuffer.toString();
    }

    public static byte[] fromString(String string, boolean bl) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            byteArrayOutputStream.write(PETSCII.fromUnicode(n, bl));
        }
        return byteArrayOutputStream.toByteArray();
    }
}

