/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLIRRecordBlock
extends ArrayList<Entry> {
    private static final long serialVersionUID = 1L;

    public void read(DataInput dataInput) throws IOException {
        this.clear();
        boolean bl = false;
        for (int i = 0; i < 127; ++i) {
            int n = dataInput.readUnsignedByte();
            int n2 = dataInput.readUnsignedByte();
            if (bl) continue;
            if (n == 0 && n2 == 0) {
                bl = true;
                continue;
            }
            this.add(new Entry(n, n2));
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n;
        for (n = 0; n < this.size() && n < 127; ++n) {
            Entry entry = (Entry)this.get(n);
            dataOutput.writeByte(entry.sectorCount);
            dataOutput.writeByte(entry.byteCount);
        }
        for (n = this.size(); n < 127; ++n) {
            dataOutput.writeByte(0);
            dataOutput.writeByte(0);
        }
    }

    public static final class Entry {
        public final int sectorCount;
        public final int byteCount;
        public final int length;

        public Entry(int n, int n2) {
            this.sectorCount = n;
            this.byteCount = n2;
            this.length = n * 254 - (255 - n2);
        }

        public Entry(int n) {
            this.sectorCount = (n + 253) / 254;
            this.byteCount = 255 - (this.sectorCount * 254 - n);
            this.length = n;
        }

        public String toString() {
            return this.sectorCount + "." + this.byteCount + ":" + this.length;
        }
    }
}

