/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FNTBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList encoding;
    private static final int[] CP1252_C1 = new int[]{8364, 9674, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 321, 381, 305, 8984, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 322, 382, 376};

    public FNTBitmapFontImporter() {
        this.encoding = null;
    }

    public FNTBitmapFontImporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(byteArrayInputStream));
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(fileInputStream));
        fileInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFontImpl(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = dataInputStream.readUnsignedShort();
        if (n5 < 1 || n5 > 3) {
            throw new IOException("bad magic number: " + n5);
        }
        int n6 = Integer.reverseBytes(dataInputStream.readInt());
        if (n6 < 118) {
            throw new IOException("bad size: " + n6);
        }
        byte[] byArray = new byte[n6];
        dataInputStream.readFully(byArray, 6, n6 - 6);
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 6, n6 - 6));
        byte[] byArray2 = new byte[60];
        dataInputStream.readFully(byArray2);
        for (n4 = 0; n4 < 60 && byArray2[n4] != 0; ++n4) {
        }
        String string = new String(byArray2, 0, n4, "CP1252");
        int n7 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        if ((n7 & 1) != 0) {
            throw new IOException("vector fonts are not supported");
        }
        int n8 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        dataInputStream.readShort();
        dataInputStream.readShort();
        int n9 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        dataInputStream.readShort();
        int n10 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n11 = dataInputStream.readUnsignedByte();
        int n12 = dataInputStream.readUnsignedByte();
        int n13 = dataInputStream.readUnsignedByte();
        int n14 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        dataInputStream.readByte();
        dataInputStream.readShort();
        int n15 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        dataInputStream.readByte();
        dataInputStream.readShort();
        dataInputStream.readShort();
        int n16 = dataInputStream.readUnsignedByte();
        int n17 = dataInputStream.readUnsignedByte();
        dataInputStream.readByte();
        dataInputStream.readByte();
        dataInputStream.readShort();
        dataInputStream.readInt();
        int n18 = Integer.reverseBytes(dataInputStream.readInt());
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readByte();
        int n19 = n3 = n5 >= 3 ? Integer.reverseBytes(dataInputStream.readInt()) : 0;
        if (n5 >= 3) {
            dataInputStream.readShort();
        }
        if (n5 >= 3) {
            dataInputStream.readShort();
        }
        if (n5 >= 3) {
            dataInputStream.readShort();
        }
        if (n5 >= 3) {
            dataInputStream.readInt();
        }
        byte[] byArray3 = new byte[16];
        if (n5 >= 3) {
            dataInputStream.readFully(byArray3);
        }
        for (n2 = n18; n2 < n6 && byArray[n2] != 0; ++n2) {
        }
        String string2 = new String(byArray, n18, n2 - n18, "CP1252");
        int n20 = n17 - n16 + 2;
        int[] nArray = new int[n20];
        int[] nArray2 = new int[n20];
        int[] nArray3 = new int[n20];
        int[] nArray4 = new int[n20];
        int[] nArray5 = new int[n20];
        int[] nArray6 = new int[n20];
        if (n5 < 3) {
            for (n = 0; n < n20; ++n) {
                nArray[n] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray2[n] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray3[n] = n15;
            }
        } else {
            for (n = 0; n < n20; ++n) {
                nArray[n] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray2[n] = Integer.reverseBytes(dataInputStream.readInt());
                nArray3[n] = (n3 & 0xF0) < 32 ? n15 : Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                if ((n3 & 0xF) < 4) continue;
                nArray4[n] = Integer.reverseBytes(dataInputStream.readInt());
                nArray5[n] = Integer.reverseBytes(dataInputStream.readInt());
                nArray6[n] = Integer.reverseBytes(dataInputStream.readInt());
            }
        }
        n = n15 - n9;
        int n21 = n8 * n9 / n15;
        int n22 = n8 - n21;
        String string3 = FNTBitmapFontImporter.styleName(n11, n12, n13, n14);
        BitmapFont bitmapFont = new BitmapFont(n21, n22, n9, n, 0, 0, n10);
        bitmapFont.setName(0, string);
        bitmapFont.setName(1, string2);
        bitmapFont.setName(2, string3);
        bitmapFont.setName(4, string2 + " " + string3);
        for (int i = 0; i < n20 - 1; ++i) {
            byte[][] byArray4 = new byte[nArray3[i]][nArray[i]];
            int n23 = nArray2[i];
            int n24 = 0;
            while (n24 < nArray3[i]) {
                int n25 = n23;
                int n26 = 0;
                while (n26 < nArray[i]) {
                    for (int j = 128; n26 < nArray[i] && j != 0; ++n26, j >>= 1) {
                        if ((byArray[n25] & j) == 0) continue;
                        byArray4[n24][n26] = -1;
                    }
                    n25 += nArray3[i];
                }
                ++n24;
                ++n23;
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray4, 0, nArray[i], n9);
            int n27 = n24 = this.encoding != null ? this.encoding.get(n16 + i) : FNTBitmapFontImporter.fromCP1252(n16 + i);
            if (n24 < 0) {
                n24 = 61440 + n16 + i;
            }
            bitmapFont.putCharacter(n24, bitmapFontGlyph);
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private static String styleName(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 < 400) {
            stringBuffer.append(n4 < 200 ? " Thin" : " Light");
        }
        if (n4 >= 600) {
            stringBuffer.append(n4 >= 900 ? " Black" : " Bold");
        }
        if (n != 0) {
            stringBuffer.append(" Italic");
        }
        if (n2 != 0) {
            stringBuffer.append(" Underline");
        }
        if (n3 != 0) {
            stringBuffer.append(" Strikeout");
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString().trim() : "Normal";
    }

    private static int fromCP1252(int n) {
        if (n < 128 || n >= 160) {
            return n;
        }
        return CP1252_C1[n - 128];
    }
}

