/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.ttflib.FindOpenType;
import com.kreative.unicode.ttflib.PuaaTable;
import com.kreative.unicode.ttflib.TtfFile;
import java.awt.Font;
import java.awt.font.OpenType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PuaaCache {
    private static final Map<String, PuaaTable> resCache = new HashMap<String, PuaaTable>();
    private static final Map<File, PuaaTable> fileCache = new HashMap<File, PuaaTable>();
    private static final Map<Font, PuaaTable> fontCache = new HashMap<Font, PuaaTable>();

    public static synchronized PuaaTable getPuaaTable(String string) {
        if (resCache.containsKey(string)) {
            return resCache.get(string);
        }
        try {
            TtfFile ttfFile = new TtfFile(PuaaCache.class.getResourceAsStream(string));
            PuaaTable puaaTable = ttfFile.getTableAs(PuaaTable.class, "PUAA");
            resCache.put(string, puaaTable);
            return puaaTable;
        }
        catch (Exception exception) {
            resCache.put(string, null);
            return null;
        }
    }

    public static synchronized PuaaTable getPuaaTable(File file) {
        if (fileCache.containsKey(file)) {
            return fileCache.get(file);
        }
        try {
            TtfFile ttfFile = new TtfFile(file);
            PuaaTable puaaTable = ttfFile.getTableAs(PuaaTable.class, "PUAA");
            fileCache.put(file, puaaTable);
            return puaaTable;
        }
        catch (Exception exception) {
            fileCache.put(file, null);
            return null;
        }
    }

    public static synchronized PuaaTable getPuaaTable(Font font) {
        if (fontCache.containsKey(font)) {
            return fontCache.get(font);
        }
        try {
            byte[] byArray;
            OpenType openType = FindOpenType.forFont(font);
            if (openType != null && (byArray = openType.getFontTable("PUAA")) != null && byArray.length > 0) {
                PuaaTable puaaTable = new PuaaTable(byArray);
                fontCache.put(font, puaaTable);
                return puaaTable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fontCache.put(font, null);
        return null;
    }
}

