/*
 *  Copyright (C) 2010-2024 Fabio Cavallo (aka FHorse)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include "mappers.h"
#include "save_slot.h"

void prg_swap_mmc3_208(WORD address, WORD value);
void mirroring_fix_mmc3_208(void);

struct _m208 {
	BYTE reg;
	struct _protection {
		BYTE index;
		BYTE reg[4];
	} protection;
} m208;
static const BYTE vlu208[256] = {
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x59, 0x49, 0x19, 0x09, 0x59, 0x49, 0x19, 0x09,
	0x59, 0x59, 0x59, 0x59,	0x59, 0x59, 0x59, 0x59,
	0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x59, 0x49, 0x19, 0x09,	0x59, 0x49, 0x19, 0x09,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
	0x00, 0x10, 0x40, 0x50,	0x00, 0x10, 0x40, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x18, 0x48, 0x58, 0x08, 0x18, 0x48, 0x58,
	0x00, 0x00, 0x00, 0x00,	0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x40, 0x50, 0x00, 0x10, 0x40, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x18, 0x48, 0x58,	0x08, 0x18, 0x48, 0x58,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x58, 0x48, 0x18, 0x08,	0x58, 0x48, 0x18, 0x08,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x50, 0x40, 0x10, 0x00, 0x50, 0x40, 0x10, 0x00,
	0x59, 0x59, 0x59, 0x59,	0x59, 0x59, 0x59, 0x59,
	0x58, 0x48, 0x18, 0x08, 0x58, 0x48, 0x18, 0x08,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,
	0x50, 0x40, 0x10, 0x00,	0x50, 0x40, 0x10, 0x00,
	0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x19, 0x49, 0x59,	0x09, 0x19, 0x49, 0x59,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51,
	0x00, 0x00, 0x00, 0x00,	0x00, 0x00, 0x00, 0x00,
	0x09, 0x19, 0x49, 0x59, 0x09, 0x19, 0x49, 0x59,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

void map_init_208(void) {
	EXTCL_AFTER_MAPPER_INIT(MMC3);
	EXTCL_CPU_WR_MEM(208);
	EXTCL_CPU_RD_MEM(208);
	EXTCL_SAVE_MAPPER(208);
	EXTCL_CPU_EVERY_CYCLE(MMC3);
	EXTCL_PPU_000_TO_34X(MMC3);
	EXTCL_PPU_000_TO_255(MMC3);
	EXTCL_PPU_256_TO_319(MMC3);
	EXTCL_PPU_320_TO_34X(MMC3);
	EXTCL_UPDATE_R2006(MMC3);
	map_internal_struct_init((BYTE *)&m208, sizeof(m208));
	map_internal_struct_init((BYTE *)&mmc3, sizeof(mmc3));

	if (info.reset >= HARD) {
		memset(&nes[0].irqA12, 0x00, sizeof(nes[0].irqA12));
	}

	memset(&m208, 0x00, sizeof(m208));

	init_MMC3(info.reset);
	MMC3_prg_swap = prg_swap_mmc3_208;
	MMC3_mirroring_fix = mirroring_fix_mmc3_208;

	info.mapper.extend_wr = TRUE;

	nes[0].irqA12.present = TRUE;
	irqA12_delay = 1;
}
void extcl_cpu_wr_mem_208(BYTE nidx, WORD address, BYTE value) {
	if ((address >= 0x4000) && (address <= 0x5FFF)) {
		switch (address & 0xF800) {
			case 0x4800:
				m208.reg = value;
				MMC3_prg_fix();
				MMC3_mirroring_fix();
				return;
			case 0x5000:
				m208.protection.index = value;
				return;
			case 0x5800:
				m208.protection.reg[address & 0x0003] = value ^ vlu208[m208.protection.index];
				return;
		}
		return;
	}
	if (address >= 0x8000) {
		extcl_cpu_wr_mem_MMC3(nidx, address, value);
	}
}
BYTE extcl_cpu_rd_mem_208(BYTE nidx, WORD address, BYTE openbus) {
	if ((address >= 0x5000) && (address <= 0x5FFF)) {
		return (address & 0x0800 ? m208.protection.reg[address & 0x0003]: openbus);
	}
	return (wram_rd(nidx, address));
}
BYTE extcl_save_mapper_208(BYTE mode, BYTE slot, FILE *fp) {
	save_slot_ele(mode, slot, m208.reg);
	save_slot_ele(mode, slot, m208.protection);
	return (extcl_save_mapper_MMC3(mode, slot, fp));
}

void prg_swap_mmc3_208(WORD address, WORD value) {
	const WORD slot = (address >> 13) & 0x03;

	value = info.mapper.submapper == 1
		? (mmc3.reg[6] & ~3) | slot
		: ((m208.reg & 0x01) << 2) | ((m208.reg & 0x10) >> 1) | slot;
	prg_swap_MMC3_base(address, value);
}
void mirroring_fix_mmc3_208(void) {
	if (info.mapper.submapper == 1) {
		mirroring_fix_MMC3_base();
		return;
	}
	if (m208.reg & 0x20) {
		mirroring_H(0);
	} else {
		mirroring_V(0);
	}
}
