/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc;

import java.util.Arrays;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.DoubleCollection;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.DoubleLookupContainer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.DoubleCursor;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.predicates.DoublePredicate;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public double[] toArray() {
        double[] array = new double[this.size()];
        int i = 0;
        for (DoubleCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

