/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.AbstractByteCollection;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.AbstractIterator;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.BufferAllocationException;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ByteArrayList;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ByteContainer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ByteDeque;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.Preallocable;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ByteCursor;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.predicates.BytePredicate;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.procedures.ByteProcedure;

public class ByteArrayDeque
extends AbstractByteCollection
implements ByteDeque,
Preallocable,
Cloneable {
    public byte[] buffer = ByteArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public ByteArrayDeque() {
        this(4);
    }

    public ByteArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ByteArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ByteArrayDeque(ByteContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(byte e1) {
        int h = ByteArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ByteArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public final void addFirst(byte ... elements) {
        this.ensureBufferSpace(elements.length);
        for (byte k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(ByteContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ByteCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends ByteCursor> iterable) {
        int size = 0;
        for (ByteCursor byteCursor : iterable) {
            this.addFirst(byteCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(byte e1) {
        int t = ByteArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ByteArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public final void addLast(byte ... elements) {
        this.ensureBufferSpace(1);
        for (byte k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(ByteContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ByteCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends ByteCursor> iterable) {
        int size = 0;
        for (ByteCursor byteCursor : iterable) {
            this.addLast(byteCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public byte removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        byte result = this.buffer[this.head];
        this.buffer[this.head] = 0;
        this.head = ByteArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public byte removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ByteArrayDeque.oneLeft(this.tail, this.buffer.length);
        byte result = this.buffer[this.tail];
        this.buffer[this.tail] = 0;
        return result;
    }

    @Override
    public byte getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public byte getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[ByteArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(byte e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(byte e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = ByteArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(byte e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(byte e1) {
        int bufLen = this.buffer.length;
        int last = ByteArrayDeque.oneLeft(this.head, bufLen);
        int i = ByteArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = ByteArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(byte e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (this.buffer[from] == e1) {
                this.buffer[from] = 0;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = ByteArrayDeque.oneRight(to, bufLen);
            }
            from = ByteArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        byte[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(buffer, head, buffer, head + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head, buffer, head + 1, lastIndex - head);
            }
            buffer[head] = 0;
            this.head = ByteArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(buffer, index + 1, buffer, index, rightChunk);
            } else {
                System.arraycopy(buffer, index + 1, buffer, index, lastIndex - index);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = 0;
            this.tail = ByteArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, (byte)0);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, (byte)0);
            Arrays.fill(this.buffer, this.head, this.buffer.length, (byte)0);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ByteArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                byte[] newBuffer = new byte[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public byte[] toArray() {
        int size = this.size();
        return this.toArray(new byte[size]);
    }

    public byte[] toArray(byte[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ByteArrayDeque clone() {
        try {
            ByteArrayDeque cloned = (ByteArrayDeque)super.clone();
            cloned.buffer = (byte[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ByteCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ByteProcedure procedure, int fromIndex, int toIndex) {
        byte[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = ByteArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        byte[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = ByteArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ByteProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ByteProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        byte[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = ByteArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends BytePredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(BytePredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        byte[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = ByteArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(BytePredicate predicate) {
        int to;
        byte[] buffer = this.buffer;
        int last = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = 0;
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                        buffer[from] = 0;
                    }
                    to = ByteArrayDeque.oneRight(to, bufLen);
                }
                from = ByteArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0;
                }
                to = ByteArrayDeque.oneRight(to, bufLen);
                from = ByteArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(byte e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        byte[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (buffer[i] == e) {
                return true;
            }
            i = ByteArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        byte[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
            i = ByteArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ByteArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(ByteArrayDeque other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        Iterator<ByteCursor> i1 = this.iterator();
        Iterator<ByteCursor> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i2.next().value == i1.next().value) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static ByteArrayDeque from(byte ... elements) {
        ByteArrayDeque coll = new ByteArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ByteArrayDeque.this.tail;
            this.remaining = ByteArrayDeque.this.size();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.remaining == 0) {
                return (ByteCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ByteArrayDeque.oneLeft(this.cursor.index, ByteArrayDeque.this.buffer.length);
            this.cursor.value = ByteArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ByteArrayDeque.oneLeft(ByteArrayDeque.this.head, ByteArrayDeque.this.buffer.length);
            this.remaining = ByteArrayDeque.this.size();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.remaining == 0) {
                return (ByteCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ByteArrayDeque.oneRight(this.cursor.index, ByteArrayDeque.this.buffer.length);
            this.cursor.value = ByteArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

