/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Attribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.AttributeSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.IOUtils;

public final class ConcatenatingTokenStream
extends TokenStream {
    private final TokenStream[] sources;
    private final OffsetAttribute[] sourceOffsets;
    private final PositionIncrementAttribute[] sourceIncrements;
    private final OffsetAttribute offsetAtt;
    private final PositionIncrementAttribute posIncAtt;
    private int currentSource;
    private int offsetIncrement;
    private int initialPositionIncrement = 1;

    public ConcatenatingTokenStream(TokenStream ... sources) {
        super(ConcatenatingTokenStream.combineSources(sources));
        this.sources = sources;
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
        this.sourceOffsets = new OffsetAttribute[sources.length];
        this.sourceIncrements = new PositionIncrementAttribute[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.sourceOffsets[i] = sources[i].addAttribute(OffsetAttribute.class);
            this.sourceIncrements[i] = sources[i].addAttribute(PositionIncrementAttribute.class);
        }
    }

    private static AttributeSource combineSources(TokenStream ... sources) {
        AttributeSource base = sources[0].cloneAttributes();
        try {
            for (int i = 1; i < sources.length; ++i) {
                Iterator<Class<? extends Attribute>> it = sources[i].getAttributeClassesIterator();
                while (it.hasNext()) {
                    base.addAttribute(it.next());
                }
                sources[i].copyTo(base);
            }
            return base;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Attempted to concatenate TokenStreams with different attribute types", e);
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        boolean newSource = false;
        while (!this.sources[this.currentSource].incrementToken()) {
            if (this.currentSource >= this.sources.length - 1) {
                return false;
            }
            this.sources[this.currentSource].end();
            this.initialPositionIncrement = this.sourceIncrements[this.currentSource].getPositionIncrement();
            OffsetAttribute att = this.sourceOffsets[this.currentSource];
            if (att != null) {
                this.offsetIncrement += att.endOffset();
            }
            ++this.currentSource;
            newSource = true;
        }
        this.clearAttributes();
        this.sources[this.currentSource].copyTo(this);
        this.offsetAtt.setOffset(this.offsetAtt.startOffset() + this.offsetIncrement, this.offsetAtt.endOffset() + this.offsetIncrement);
        if (newSource) {
            int posInc = this.posIncAtt.getPositionIncrement();
            this.posIncAtt.setPositionIncrement(posInc + this.initialPositionIncrement);
        }
        return true;
    }

    @Override
    public void end() throws IOException {
        this.sources[this.currentSource].end();
        int finalOffset = this.sourceOffsets[this.currentSource].endOffset() + this.offsetIncrement;
        int finalPosInc = this.sourceIncrements[this.currentSource].getPositionIncrement();
        super.end();
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncAtt.setPositionIncrement(finalPosInc);
    }

    @Override
    public void reset() throws IOException {
        for (TokenStream source : this.sources) {
            source.reset();
        }
        super.reset();
        this.currentSource = 0;
        this.offsetIncrement = 0;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.sources);
        }
        finally {
            super.close();
        }
    }
}

