/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.ElisionFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.ResourceLoader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.util.TokenFilterFactory;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "elision";
    private final String articlesFile;
    private final boolean ignoreCase;
    private CharArraySet articles;

    public ElisionFilterFactory(Map<String, String> args) {
        super(args);
        this.articlesFile = this.get(args, "articles");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.articles = this.articlesFile == null ? FrenchAnalyzer.DEFAULT_ARTICLES : this.getWordSet(loader, this.articlesFile, this.ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

