/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.document;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.XYDocValuesField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYRectangle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.ArrayUtil;

class XYPointDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final double x;
    final double y;
    final double[] values;
    double bottom;
    double topValue;
    SortedNumericDocValues currentDocs;
    int minX = Integer.MIN_VALUE;
    int maxX = Integer.MAX_VALUE;
    int minY = Integer.MIN_VALUE;
    int maxY = Integer.MAX_VALUE;
    int setBottomCounter = 0;
    private long[] currentValues = new long[4];
    private int valuesDocID = -1;

    public XYPointDistanceComparator(String field, float x, float y, int numHits) {
        this.field = field;
        this.x = x;
        this.y = y;
        this.values = new double[numHits];
    }

    @Override
    public void setScorer(Scorable scorer) {
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
        if (this.bottom < 3.4028234663852886E38 && (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63)) {
            XYRectangle rectangle = XYRectangle.fromPointDistance((float)this.x, (float)this.y, (float)this.bottom);
            this.minX = XYEncodingUtils.encode(rectangle.minX);
            this.maxX = XYEncodingUtils.encode(rectangle.maxX);
            this.minY = XYEncodingUtils.encode(rectangle.minY);
            this.maxY = XYEncodingUtils.encode(rectangle.maxY);
        }
        ++this.setBottomCounter;
    }

    @Override
    public void setTopValue(Double value) {
        this.topValue = value;
    }

    private void setValues() throws IOException {
        if (this.valuesDocID != this.currentDocs.docID()) {
            assert (this.valuesDocID < this.currentDocs.docID()) : " valuesDocID=" + this.valuesDocID + " vs " + this.currentDocs.docID();
            this.valuesDocID = this.currentDocs.docID();
            int count = this.currentDocs.docValueCount();
            if (count > this.currentValues.length) {
                this.currentValues = new long[ArrayUtil.oversize(count, 8)];
            }
            for (int i = 0; i < count; ++i) {
                this.currentValues[i] = this.currentDocs.nextValue();
            }
        }
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        if (doc < this.currentDocs.docID()) {
            return Double.compare(this.bottom, Double.POSITIVE_INFINITY);
        }
        this.setValues();
        int numValues = this.currentDocs.docValueCount();
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            double docY;
            double diffY;
            double docX;
            double diffX;
            double distance;
            int yBits;
            long encoded = this.currentValues[i];
            int xBits = (int)(encoded >> 32);
            if (xBits < this.minX || xBits > this.maxX || (yBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL)) < this.minY || yBits > this.maxY || (cmp = Math.max(cmp, Double.compare(this.bottom, distance = Math.sqrt((diffX = this.x - (docX = (double)XYEncodingUtils.decode(xBits))) * diffX + (diffY = this.y - (docY = (double)XYEncodingUtils.decode(yBits))) * diffY)))) <= 0) continue;
            return cmp;
        }
        return cmp;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortKey(doc);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            XYDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric(reader, this.field);
        this.valuesDocID = -1;
        return this;
    }

    @Override
    public Double value(int slot) {
        return this.values[slot];
    }

    @Override
    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, this.sortKey(doc));
    }

    double sortKey(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        double minValue = Double.POSITIVE_INFINITY;
        if (doc == this.currentDocs.docID()) {
            this.setValues();
            int numValues = this.currentDocs.docValueCount();
            for (int i = 0; i < numValues; ++i) {
                long encoded = this.currentValues[i];
                double docX = XYEncodingUtils.decode((int)(encoded >> 32));
                double docY = XYEncodingUtils.decode((int)(encoded & 0xFFFFFFFFFFFFFFFFL));
                double diffX = this.x - docX;
                double diffY = this.y - docY;
                double distance = Math.sqrt(diffX * diffX + diffY * diffY);
                minValue = Math.min(minValue, distance);
            }
        }
        return minValue;
    }
}

