/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BulkScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.BitsProducer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.CompletionQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.CompletionScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.CompletionTerms;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.NRTSuggester;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.IntsRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.automaton.Automaton;

public class CompletionWeight
extends Weight {
    private final CompletionQuery completionQuery;
    private final Automaton automaton;

    public CompletionWeight(CompletionQuery query, Automaton automaton) throws IOException {
        super(query);
        this.completionQuery = query;
        this.automaton = automaton;
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        NRTSuggester suggester;
        LeafReader reader = context.reader();
        Terms terms = reader.terms(this.completionQuery.getField());
        if (terms == null) {
            return null;
        }
        if (terms instanceof CompletionTerms) {
            CompletionTerms completionTerms = (CompletionTerms)terms;
            suggester = completionTerms.suggester();
            if (suggester == null) {
                return null;
            }
        } else {
            throw new IllegalArgumentException(this.completionQuery.getField() + " is not a SuggestField");
        }
        BitsProducer filter = this.completionQuery.getFilter();
        Bits filteredDocs = null;
        if (filter != null && (filteredDocs = filter.getBits(context)).getClass() == Bits.MatchNoBits.class) {
            return null;
        }
        return new CompletionScorer(this, suggester, reader, filteredDocs, filter != null, this.automaton);
    }

    protected void setNextMatch(IntsRef pathPrefix) {
    }

    protected float boost() {
        return 0.0f;
    }

    protected CharSequence context() {
        return null;
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return null;
    }
}

