/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.CompletionPostingsFormat;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.NRTSuggester;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Accountable;

public final class CompletionsTermsReader
implements Accountable {
    public final long minWeight;
    public final long maxWeight;
    public final byte type;
    private final IndexInput dictIn;
    private final long offset;
    private final CompletionPostingsFormat.FSTLoadMode fstLoadMode;
    private NRTSuggester suggester;

    CompletionsTermsReader(IndexInput dictIn, long offset, long minWeight, long maxWeight, byte type, CompletionPostingsFormat.FSTLoadMode fstLoadMode) {
        assert (minWeight <= maxWeight);
        assert (offset >= 0L && offset < dictIn.length());
        this.dictIn = dictIn;
        this.offset = offset;
        this.minWeight = minWeight;
        this.maxWeight = maxWeight;
        this.type = type;
        this.fstLoadMode = fstLoadMode;
    }

    public synchronized NRTSuggester suggester() throws IOException {
        if (this.suggester == null) {
            try (IndexInput dictClone = this.dictIn.clone();){
                dictClone.seek(this.offset);
                this.suggester = NRTSuggester.load(dictClone, this.fstLoadMode);
            }
        }
        return this.suggester;
    }

    @Override
    public long ramBytesUsed() {
        return this.suggester != null ? this.suggester.ramBytesUsed() : 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

