/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.FilteringTokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.memory.MemoryIndex;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.spans.SpanQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.CharArrayMatcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.uhighlight.UHComponents;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader memIndexLeafReader;
    private final CharArrayMatcher preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(UHComponents components, Analyzer analyzer) {
        super(components, analyzer);
        boolean storePayloads = components.getPhraseHelper().hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.memIndexLeafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(components);
    }

    private static CharArrayMatcher buildCombinedAutomaton(UHComponents components) {
        if (components.getTerms() == null || components.getAutomata() == null) {
            return null;
        }
        ArrayList<CharArrayMatcher> allAutomata = new ArrayList<CharArrayMatcher>();
        if (components.getTerms().length > 0) {
            allAutomata.add(CharArrayMatcher.fromTerms(Arrays.asList(components.getTerms())));
        }
        Collections.addAll(allAutomata, components.getAutomata());
        for (SpanQuery spanQuery : components.getPhraseHelper().getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata(spanQuery, components.getFieldMatcher(), true));
        }
        if (allAutomata.size() == 1) {
            return (CharArrayMatcher)allAutomata.get(0);
        }
        return (chars, offset, length) -> {
            for (int i = 0; i < allAutomata.size(); ++i) {
                if (!((CharArrayMatcher)allAutomata.get(i)).match(chars, offset, length)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        if (this.preMemIndexFilterAutomaton != null) {
            tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        }
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.getField(), tokenStream);
        if (reader == null) {
            return this.createOffsetsEnumFromReader(this.memIndexLeafReader, 0);
        }
        return this.createOffsetsEnumFromReader(new OverlaySingleDocTermsLeafReader(reader, this.memIndexLeafReader, this.getField(), docId), docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharArrayMatcher matcher) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(x0);
                this.charAtt = this.addAttribute(CharTermAttribute.class);
            }

            @Override
            protected boolean accept() throws IOException {
                return matcher.match(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

