/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoDegeneratePath;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPath;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoStandardPath;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.PlanetModel;

public class GeoPathFactory {
    private GeoPathFactory() {
    }

    public static GeoPath makeGeoPath(PlanetModel planetModel, double maxCutoffAngle, GeoPoint[] pathPoints) {
        if (maxCutoffAngle < 3.141592653589793E-12) {
            return new GeoDegeneratePath(planetModel, GeoPathFactory.filterPoints(pathPoints));
        }
        return new GeoStandardPath(planetModel, maxCutoffAngle, GeoPathFactory.filterPoints(pathPoints));
    }

    private static GeoPoint[] filterPoints(GeoPoint[] pathPoints) {
        ArrayList<GeoPoint> noIdenticalPoints = new ArrayList<GeoPoint>(pathPoints.length);
        for (int i = 0; i < pathPoints.length - 1; ++i) {
            if (pathPoints[i].isNumericallyIdentical(pathPoints[i + 1])) continue;
            noIdenticalPoints.add(pathPoints[i]);
        }
        noIdenticalPoints.add(pathPoints[pathPoints.length - 1]);
        return noIdenticalPoints.toArray(new GeoPoint[noIdenticalPoints.size()]);
    }
}

