/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.FailedNodeException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.node.NodeService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportNodesInfoAction
extends TransportNodesAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesInfoRequest::new, NodeInfoRequest::new, "management", NodeInfo.class);
        this.nodeService = nodeService;
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, List<NodeInfo> responses, List<FailedNodeException> failures) {
        return new NodesInfoResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeInfoRequest newNodeRequest(NodesInfoRequest request) {
        return new NodeInfoRequest(request);
    }

    @Override
    protected NodeInfo newNodeResponse(StreamInput in) throws IOException {
        return new NodeInfo(in);
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeRequest) {
        NodesInfoRequest request = nodeRequest.request;
        Set<String> metrics = request.requestedMetrics();
        return this.nodeService.info(metrics.contains(NodesInfoRequest.Metric.SETTINGS.metricName()), metrics.contains(NodesInfoRequest.Metric.OS.metricName()), metrics.contains(NodesInfoRequest.Metric.PROCESS.metricName()), metrics.contains(NodesInfoRequest.Metric.JVM.metricName()), metrics.contains(NodesInfoRequest.Metric.THREAD_POOL.metricName()), metrics.contains(NodesInfoRequest.Metric.TRANSPORT.metricName()), metrics.contains(NodesInfoRequest.Metric.HTTP.metricName()), metrics.contains(NodesInfoRequest.Metric.PLUGINS.metricName()), metrics.contains(NodesInfoRequest.Metric.INGEST.metricName()), metrics.contains(NodesInfoRequest.Metric.INDICES.metricName()));
    }

    public static class NodeInfoRequest
    extends BaseNodeRequest {
        NodesInfoRequest request;

        public NodeInfoRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesInfoRequest(in);
        }

        public NodeInfoRequest(NodesInfoRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

