/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.engine.Segment;

public class ShardSegments
implements Writeable,
Iterable<Segment> {
    private ShardRouting shardRouting;
    private List<Segment> segments;

    ShardSegments(ShardRouting shardRouting, List<Segment> segments) {
        this.shardRouting = shardRouting;
        this.segments = segments;
    }

    ShardSegments(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        int size = in.readVInt();
        if (size == 0) {
            this.segments = Collections.emptyList();
        } else {
            this.segments = new ArrayList<Segment>(size);
            for (int i = 0; i < size; ++i) {
                this.segments.add(new Segment(in));
            }
        }
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int getNumberOfCommitted() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfSearch() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isSearch()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        out.writeVInt(this.segments.size());
        for (Segment segment : this.segments) {
            segment.writeTo(out);
        }
    }
}

