/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search;

import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.OriginalIndices;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.PlainShardIterator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardIterator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchShardTarget;

public final class SearchShardIterator
extends PlainShardIterator {
    private final OriginalIndices originalIndices;
    private final String clusterAlias;
    private boolean skip = false;

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<ShardRouting> shards, OriginalIndices originalIndices) {
        super(shardId, shards);
        this.originalIndices = originalIndices;
        this.clusterAlias = clusterAlias;
    }

    public OriginalIndices getOriginalIndices() {
        return this.originalIndices;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    SearchShardTarget newSearchShardTarget(String nodeId) {
        return new SearchShardTarget(nodeId, this.shardId(), this.clusterAlias, this.originalIndices);
    }

    void resetAndSkip() {
        this.reset();
        this.skip = true;
    }

    boolean skip() {
        return this.skip;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchShardIterator that = (SearchShardIterator)o;
        return Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clusterAlias);
    }

    @Override
    public int compareTo(ShardIterator o) {
        int superCompareTo = super.compareTo(o);
        if (superCompareTo != 0 || !(o instanceof SearchShardIterator)) {
            return superCompareTo;
        }
        SearchShardIterator searchShardIterator = (SearchShardIterator)o;
        if (this.clusterAlias == null && searchShardIterator.getClusterAlias() == null) {
            return 0;
        }
        if (this.clusterAlias == null) {
            return -1;
        }
        if (searchShardIterator.getClusterAlias() == null) {
            return 1;
        }
        return this.clusterAlias.compareTo(searchShardIterator.getClusterAlias());
    }
}

