/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestConverters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.eql.EqlSearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.eql.EqlStatsRequest;

final class EqlRequestConverters {
    EqlRequestConverters() {
    }

    static Request search(EqlSearchRequest eqlSearchRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(eqlSearchRequest.indices()).addPathPartAsIs("_eql", "search").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withIndicesOptions(eqlSearchRequest.indicesOptions());
        request.setEntity(RequestConverters.createEntity(eqlSearchRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request stats(EqlStatsRequest eqlStatsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_eql", "stats").build();
        return new Request("GET", endpoint);
    }
}

