/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameAnalyticsConfigUpdate
implements ToXContentObject {
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_config_update", true, () -> new Builder());
    private final String id;
    private final String description;
    private final ByteSizeValue modelMemoryLimit;
    private final Boolean allowLazyStart;
    private final Integer maxNumThreads;

    public static DataFrameAnalyticsConfigUpdate fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataFrameAnalyticsConfigUpdate(String id, @Nullable String description, @Nullable ByteSizeValue modelMemoryLimit, @Nullable Boolean allowLazyStart, @Nullable Integer maxNumThreads) {
        this.id = id;
        this.description = description;
        this.modelMemoryLimit = modelMemoryLimit;
        this.allowLazyStart = allowLazyStart;
        this.maxNumThreads = maxNumThreads;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteSizeValue getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public Boolean isAllowLazyStart() {
        return this.allowLazyStart;
    }

    public Integer getMaxNumThreads() {
        return this.maxNumThreads;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id);
        if (this.description != null) {
            builder.field(DataFrameAnalyticsConfig.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.modelMemoryLimit != null) {
            builder.field(DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit.getStringRep());
        }
        if (this.allowLazyStart != null) {
            builder.field(DataFrameAnalyticsConfig.ALLOW_LAZY_START.getPreferredName(), this.allowLazyStart);
        }
        if (this.maxNumThreads != null) {
            builder.field(DataFrameAnalyticsConfig.MAX_NUM_THREADS.getPreferredName(), this.maxNumThreads);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataFrameAnalyticsConfigUpdate)) {
            return false;
        }
        DataFrameAnalyticsConfigUpdate that = (DataFrameAnalyticsConfigUpdate)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.modelMemoryLimit, that.modelMemoryLimit) && Objects.equals(this.allowLazyStart, that.allowLazyStart) && Objects.equals(this.maxNumThreads, that.maxNumThreads);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.modelMemoryLimit, this.allowLazyStart, this.maxNumThreads);
    }

    static {
        PARSER.declareString(Builder::setId, DataFrameAnalyticsConfig.ID);
        PARSER.declareStringOrNull(Builder::setDescription, DataFrameAnalyticsConfig.DESCRIPTION);
        PARSER.declareField(Builder::setModelMemoryLimit, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT.getPreferredName()), DataFrameAnalyticsConfig.MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        PARSER.declareBoolean(Builder::setAllowLazyStart, DataFrameAnalyticsConfig.ALLOW_LAZY_START);
        PARSER.declareInt(Builder::setMaxNumThreads, DataFrameAnalyticsConfig.MAX_NUM_THREADS);
    }

    public static class Builder {
        private String id;
        private String description;
        private ByteSizeValue modelMemoryLimit;
        private Boolean allowLazyStart;
        private Integer maxNumThreads;

        private Builder() {
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setModelMemoryLimit(ByteSizeValue modelMemoryLimit) {
            this.modelMemoryLimit = modelMemoryLimit;
            return this;
        }

        public Builder setAllowLazyStart(Boolean allowLazyStart) {
            this.allowLazyStart = allowLazyStart;
            return this;
        }

        public Builder setMaxNumThreads(Integer maxNumThreads) {
            this.maxNumThreads = maxNumThreads;
            return this;
        }

        public DataFrameAnalyticsConfigUpdate build() {
            return new DataFrameAnalyticsConfigUpdate(this.id, this.description, this.modelMemoryLimit, this.allowLazyStart, this.maxNumThreads);
        }
    }
}

