/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.results;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.common.TimeUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config.DetectorFunction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config.Job;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.results.AnomalyCause;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.results.Influence;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.results.Result;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class AnomalyRecord
implements ToXContentObject {
    public static final String RESULT_TYPE_VALUE = "record";
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField MULTI_BUCKET_IMPACT = new ParseField("multi_bucket_impact", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField CORRELATED_BY_FIELD_VALUE = new ParseField("correlated_by_field_value", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField FUNCTION = new ParseField("function", new String[0]);
    public static final ParseField FUNCTION_DESCRIPTION = new ParseField("function_description", new String[0]);
    public static final ParseField TYPICAL = new ParseField("typical", new String[0]);
    public static final ParseField ACTUAL = new ParseField("actual", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("records", new String[0]);
    public static final ParseField FIELD_NAME = new ParseField("field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField CAUSES = new ParseField("causes", new String[0]);
    public static final ParseField RECORD_SCORE = new ParseField("record_score", new String[0]);
    public static final ParseField INITIAL_RECORD_SCORE = new ParseField("initial_record_score", new String[0]);
    public static final ConstructingObjectParser<AnomalyRecord, Void> PARSER = new ConstructingObjectParser("record", true, a -> new AnomalyRecord((String)a[0], (Date)a[1], (Long)a[2]));
    private final String jobId;
    private int detectorIndex;
    private double probability;
    private Double multiBucketImpact;
    private String byFieldName;
    private String byFieldValue;
    private String correlatedByFieldValue;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String function;
    private String functionDescription;
    private List<Double> typical;
    private List<Double> actual;
    private boolean isInterim;
    private String fieldName;
    private String overFieldName;
    private String overFieldValue;
    private List<AnomalyCause> causes;
    private double recordScore;
    private double initialRecordScore;
    private final Date timestamp;
    private final long bucketSpan;
    private List<Influence> influences;

    AnomalyRecord(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.bucketSpan = bucketSpan;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        if (this.multiBucketImpact != null) {
            builder.field(MULTI_BUCKET_IMPACT.getPreferredName(), this.multiBucketImpact);
        }
        builder.field(RECORD_SCORE.getPreferredName(), this.recordScore);
        builder.field(INITIAL_RECORD_SCORE.getPreferredName(), this.initialRecordScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.correlatedByFieldValue != null) {
            builder.field(CORRELATED_BY_FIELD_VALUE.getPreferredName(), this.correlatedByFieldValue);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.function != null) {
            builder.field(FUNCTION.getPreferredName(), this.function);
        }
        if (this.functionDescription != null) {
            builder.field(FUNCTION_DESCRIPTION.getPreferredName(), this.functionDescription);
        }
        if (this.typical != null) {
            builder.field(TYPICAL.getPreferredName(), this.typical);
        }
        if (this.actual != null) {
            builder.field(ACTUAL.getPreferredName(), this.actual);
        }
        if (this.fieldName != null) {
            builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.causes != null) {
            builder.field(CAUSES.getPreferredName(), this.causes);
        }
        if (this.influences != null) {
            builder.field(INFLUENCERS.getPreferredName(), this.influences);
        }
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    void setDetectorIndex(int detectorIndex) {
        this.detectorIndex = detectorIndex;
    }

    public double getRecordScore() {
        return this.recordScore;
    }

    void setRecordScore(double recordScore) {
        this.recordScore = recordScore;
    }

    public double getInitialRecordScore() {
        return this.initialRecordScore;
    }

    void setInitialRecordScore(double initialRecordScore) {
        this.initialRecordScore = initialRecordScore;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getProbability() {
        return this.probability;
    }

    void setProbability(double value) {
        this.probability = value;
    }

    public double getMultiBucketImpact() {
        return this.multiBucketImpact;
    }

    void setMultiBucketImpact(double value) {
        this.multiBucketImpact = value;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    void setByFieldName(String value) {
        this.byFieldName = value;
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    void setByFieldValue(String value) {
        this.byFieldValue = value;
    }

    public String getCorrelatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    void setCorrelatedByFieldValue(String value) {
        this.correlatedByFieldValue = value;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    void setPartitionFieldName(String field) {
        this.partitionFieldName = field;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    void setPartitionFieldValue(String value) {
        this.partitionFieldValue = value;
    }

    public String getFunction() {
        return this.function;
    }

    void setFunction(String name) {
        this.function = name;
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription;
    }

    public List<Double> getTypical() {
        return this.typical;
    }

    void setTypical(List<Double> typical) {
        this.typical = Collections.unmodifiableList(typical);
    }

    public List<Double> getActual() {
        return this.actual;
    }

    void setActual(List<Double> actual) {
        this.actual = Collections.unmodifiableList(actual);
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    void setInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    void setFieldName(String field) {
        this.fieldName = field;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    void setOverFieldName(String name) {
        this.overFieldName = name;
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    void setOverFieldValue(String value) {
        this.overFieldValue = value;
    }

    public List<AnomalyCause> getCauses() {
        return this.causes;
    }

    void setCauses(List<AnomalyCause> causes) {
        this.causes = Collections.unmodifiableList(causes);
    }

    public List<Influence> getInfluencers() {
        return this.influences;
    }

    void setInfluencers(List<Influence> influencers) {
        this.influences = Collections.unmodifiableList(influencers);
    }

    @Nullable
    public GeoPoint getTypicalGeoPoint() {
        if (!DetectorFunction.LAT_LONG.getFullName().equals(this.function) || this.typical == null) {
            return null;
        }
        if (this.typical.size() == 2) {
            return new GeoPoint(this.typical.get(0), this.typical.get(1));
        }
        return null;
    }

    @Nullable
    public GeoPoint getActualGeoPoint() {
        if (!DetectorFunction.LAT_LONG.getFullName().equals(this.function) || this.actual == null) {
            return null;
        }
        if (this.actual.size() == 2) {
            return new GeoPoint(this.actual.get(0), this.actual.get(1));
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.detectorIndex, this.bucketSpan, this.probability, this.multiBucketImpact, this.recordScore, this.initialRecordScore, this.typical, this.actual, this.function, this.functionDescription, this.fieldName, this.byFieldName, this.byFieldValue, this.correlatedByFieldValue, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.timestamp, this.isInterim, this.causes, this.influences, this.jobId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AnomalyRecord that = (AnomalyRecord)other;
        return Objects.equals(this.jobId, that.jobId) && this.detectorIndex == that.detectorIndex && this.bucketSpan == that.bucketSpan && this.probability == that.probability && Objects.equals(this.multiBucketImpact, that.multiBucketImpact) && this.recordScore == that.recordScore && this.initialRecordScore == that.initialRecordScore && Objects.deepEquals(this.typical, that.typical) && Objects.deepEquals(this.actual, that.actual) && Objects.equals(this.function, that.function) && Objects.equals(this.functionDescription, that.functionDescription) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.correlatedByFieldValue, that.correlatedByFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.overFieldValue, that.overFieldValue) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.causes, that.causes) && Objects.equals(this.influences, that.influences);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareString((anomalyRecord, s) -> {}, Result.RESULT_TYPE);
        PARSER.declareDouble(AnomalyRecord::setProbability, PROBABILITY);
        PARSER.declareDouble(AnomalyRecord::setMultiBucketImpact, MULTI_BUCKET_IMPACT);
        PARSER.declareDouble(AnomalyRecord::setRecordScore, RECORD_SCORE);
        PARSER.declareDouble(AnomalyRecord::setInitialRecordScore, INITIAL_RECORD_SCORE);
        PARSER.declareInt(AnomalyRecord::setDetectorIndex, DETECTOR_INDEX);
        PARSER.declareBoolean(AnomalyRecord::setInterim, Result.IS_INTERIM);
        PARSER.declareString(AnomalyRecord::setByFieldName, BY_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setByFieldValue, BY_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setCorrelatedByFieldValue, CORRELATED_BY_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setPartitionFieldName, PARTITION_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setFunction, FUNCTION);
        PARSER.declareString(AnomalyRecord::setFunctionDescription, FUNCTION_DESCRIPTION);
        PARSER.declareDoubleArray(AnomalyRecord::setTypical, TYPICAL);
        PARSER.declareDoubleArray(AnomalyRecord::setActual, ACTUAL);
        PARSER.declareString(AnomalyRecord::setFieldName, FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setOverFieldName, OVER_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setOverFieldValue, OVER_FIELD_VALUE);
        PARSER.declareObjectArray(AnomalyRecord::setCauses, AnomalyCause.PARSER, CAUSES);
        PARSER.declareObjectArray(AnomalyRecord::setInfluencers, Influence.PARSER, INFLUENCERS);
    }
}

