/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.parsers;

import java.io.IOException;
import java.util.Collections;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.parsers.GeoJsonParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.parsers.GeoWKTParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;

public interface ShapeParser {
    public static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    public static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    public static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);

    public static ShapeBuilder parse(XContentParser parser, AbstractGeometryFieldMapper geometryMapper) throws IOException {
        AbstractShapeGeometryFieldMapper shapeMapper = null;
        if (geometryMapper != null) {
            if (!(geometryMapper instanceof AbstractShapeGeometryFieldMapper)) {
                throw new IllegalArgumentException("geometry must be a shape type");
            }
            shapeMapper = (AbstractShapeGeometryFieldMapper)geometryMapper;
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return GeoJsonParser.parse(parser, shapeMapper);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return GeoWKTParser.parse(parser, shapeMapper);
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return ShapeParser.parse(parser, null);
    }

    public static ShapeBuilder parse(Object value) throws IOException {
        try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("value", value), null);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            ShapeBuilder shapeBuilder = ShapeParser.parse(parser);
            return shapeBuilder;
        }
    }
}

