/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.compress.CompressorFactory;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.document.DocumentField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Writeable,
Iterable<DocumentField>,
ToXContentObject {
    public static final String _INDEX = "_index";
    public static final String _TYPE = "_type";
    public static final String _ID = "_id";
    private static final String _VERSION = "_version";
    private static final String _SEQ_NO = "_seq_no";
    private static final String _PRIMARY_TERM = "_primary_term";
    private static final String FOUND = "found";
    private static final String FIELDS = "fields";
    private String index;
    private String type;
    private String id;
    private long version;
    private long seqNo;
    private long primaryTerm;
    private boolean exists;
    private final Map<String, DocumentField> documentFields;
    private final Map<String, DocumentField> metaFields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    public GetResult(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readOptionalString();
        this.id = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.seqNo = in.readZLong();
            this.primaryTerm = in.readVLong();
        } else {
            this.seqNo = -2L;
            this.primaryTerm = 0L;
        }
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
                this.documentFields = this.readFields(in);
                this.metaFields = this.readFields(in);
            } else {
                Map<String, DocumentField> fields = this.readFields(in);
                this.documentFields = new HashMap<String, DocumentField>();
                this.metaFields = new HashMap<String, DocumentField>();
                fields.forEach((? super K fieldName, ? super V docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? this.metaFields : this.documentFields).put((String)fieldName, (DocumentField)docField));
            }
        } else {
            this.metaFields = Collections.emptyMap();
            this.documentFields = Collections.emptyMap();
        }
    }

    public GetResult(String index, String type, String id, long seqNo, long primaryTerm, long version, boolean exists, BytesReference source, Map<String, DocumentField> documentFields, Map<String, DocumentField> metaFields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        assert (seqNo == -2L && primaryTerm == 0L || seqNo >= 0L && primaryTerm >= 1L) : "seqNo: " + seqNo + " primaryTerm: " + primaryTerm;
        assert (exists || seqNo == -2L && primaryTerm == 0L) : "doc not found but seqNo/primaryTerm are set";
        this.version = version;
        this.exists = exists;
        this.source = source;
        this.documentFields = documentFields == null ? Collections.emptyMap() : documentFields;
        this.metaFields = metaFields == null ? Collections.emptyMap() : metaFields;
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, DocumentField> getMetadataFields() {
        return this.metaFields;
    }

    public Map<String, DocumentField> getDocumentFields() {
        return this.documentFields;
    }

    public Map<String, DocumentField> getFields() {
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        fields.putAll(this.metaFields);
        fields.putAll(this.documentFields);
        return fields;
    }

    public DocumentField field(String name) {
        return this.getFields().get(name);
    }

    @Override
    public Iterator<DocumentField> iterator() {
        Map<String, DocumentField> allFields = this.getFields();
        return allFields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.seqNo != -2L) {
            builder.field(_SEQ_NO, this.seqNo);
            builder.field(_PRIMARY_TERM, this.primaryTerm);
        }
        for (DocumentField field : this.metaFields.values()) {
            if (field.getName().equals("_ignored")) {
                builder.field(field.getName(), field.getValues());
                continue;
            }
            builder.field(field.getName(), field.getValue());
        }
        builder.field(FOUND, this.exists);
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!this.documentFields.isEmpty()) {
            builder.startObject(FIELDS);
            for (DocumentField field : this.documentFields.values()) {
                field.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX, this.index);
        builder.field(_TYPE, this.type);
        builder.field(_ID, this.id);
        if (this.isExists()) {
            if (this.version != -1L) {
                builder.field(_VERSION, this.version);
            }
            this.toXContentEmbedded(builder, params);
        } else {
            builder.field(FOUND, false);
        }
        builder.endObject();
        return builder;
    }

    public static GetResult fromXContentEmbedded(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        return GetResult.fromXContentEmbedded(parser, null, null, null);
    }

    public static GetResult fromXContentEmbedded(XContentParser parser, String index, String type, String id) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String currentFieldName = parser.currentName();
        long version = -1L;
        long seqNo = -2L;
        long primaryTerm = 0L;
        Boolean found = null;
        BytesReference source = null;
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        HashMap<String, DocumentField> metaFields = new HashMap<String, DocumentField>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (_INDEX.equals(currentFieldName)) {
                    index = parser.text();
                    continue;
                }
                if (_TYPE.equals(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if (_ID.equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                if (_VERSION.equals(currentFieldName)) {
                    version = parser.longValue();
                    continue;
                }
                if (_SEQ_NO.equals(currentFieldName)) {
                    seqNo = parser.longValue();
                    continue;
                }
                if (_PRIMARY_TERM.equals(currentFieldName)) {
                    primaryTerm = parser.longValue();
                    continue;
                }
                if (FOUND.equals(currentFieldName)) {
                    found = parser.booleanValue();
                    continue;
                }
                metaFields.put(currentFieldName, new DocumentField(currentFieldName, Collections.singletonList(parser.objectText())));
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("_source".equals(currentFieldName)) {
                    XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
                    try {
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes(builder);
                        continue;
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                        continue;
                    }
                }
                if (FIELDS.equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        DocumentField getField = DocumentField.fromXContent(parser);
                        documentFields.put(getField.getName(), getField);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("_ignored".equals(currentFieldName)) {
                metaFields.put(currentFieldName, new DocumentField(currentFieldName, parser.list()));
                continue;
            }
            parser.skipChildren();
        }
        return new GetResult(index, type, id, seqNo, primaryTerm, version, found, source, documentFields, metaFields);
    }

    public static GetResult fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        return GetResult.fromXContentEmbedded(parser);
    }

    private Map<String, DocumentField> readFields(StreamInput in) throws IOException {
        Map<String, DocumentField> fields;
        int size = in.readVInt();
        if (size == 0) {
            fields = Collections.emptyMap();
        } else {
            fields = new HashMap<String, DocumentField>(size);
            for (int i = 0; i < size; ++i) {
                DocumentField field = new DocumentField(in);
                fields.put(field.getName(), field);
            }
        }
        return fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeZLong(this.seqNo);
            out.writeVLong(this.primaryTerm);
        }
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                this.writeFields(out, this.documentFields);
                this.writeFields(out, this.metaFields);
            } else {
                this.writeFields(out, this.getFields());
            }
        }
    }

    private void writeFields(StreamOutput out, Map<String, DocumentField> fields) throws IOException {
        if (fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(fields.size());
            for (DocumentField field : fields.values()) {
                field.writeTo(out);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetResult getResult = (GetResult)o;
        return this.version == getResult.version && this.seqNo == getResult.seqNo && this.primaryTerm == getResult.primaryTerm && this.exists == getResult.exists && Objects.equals(this.index, getResult.index) && Objects.equals(this.type, getResult.type) && Objects.equals(this.id, getResult.id) && Objects.equals(this.documentFields, getResult.documentFields) && Objects.equals(this.metaFields, getResult.metaFields) && Objects.equals(this.sourceAsMap(), getResult.sourceAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.version, this.seqNo, this.primaryTerm, this.exists, this.index, this.type, this.id, this.documentFields, this.metaFields, this.sourceAsMap());
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

