/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FuzzyQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.RegexpQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermRangeQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.WildcardQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.BytesRefs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.Fuzziness;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TermBasedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.support.QueryParsers;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchService;

public abstract class StringFieldType
extends TermBasedFieldType {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\\\.)|([?*]+)");

    public StringFieldType(String name, boolean isSearchable, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, hasDocValues, textSearchInfo, meta);
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions);
    }

    @Override
    public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[prefix] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
        }
        this.failIfNotIndexed();
        PrefixQuery query = new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    public static final String normalizeWildcardPattern(String fieldname, String value, Analyzer normalizer) {
        BytesRef normalized;
        String chunk;
        if (normalizer == null) {
            return value;
        }
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(value);
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.start() > 0) {
                chunk = value.substring(last, wildcardMatcher.start());
                normalized = normalizer.normalize(fieldname, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef(wildcardMatcher.group()));
            last = wildcardMatcher.end();
        }
        if (last < value.length()) {
            chunk = value.substring(last);
            normalized = normalizer.normalize(fieldname, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef().utf8ToString();
    }

    @Override
    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Term term;
        this.failIfNotIndexed();
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        if (this.getTextSearchInfo().getSearchAnalyzer() != null) {
            value = StringFieldType.normalizeWildcardPattern(this.name(), value, this.getTextSearchInfo().getSearchAnalyzer());
            term = new Term(this.name(), value);
        } else {
            term = new Term(this.name(), this.indexedValueForSearch(value));
        }
        WildcardQuery query = new WildcardQuery(term);
        QueryParsers.setRewriteMethod(query, method);
        return query;
    }

    @Override
    public Query regexpQuery(String value, int flags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        RegexpQuery query = new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), flags, maxDeterminizedStates);
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }
}

