/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.search.function.RandomScoreFunction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;

public class RandomScoreFunctionBuilder
extends ScoreFunctionBuilder<RandomScoreFunctionBuilder> {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RandomScoreFunctionBuilder.class));
    public static final String NAME = "random_score";
    private String field;
    private Integer seed;

    public RandomScoreFunctionBuilder() {
    }

    public RandomScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.seed = in.readInt();
        }
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            this.field = in.readOptionalString();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.seed != null) {
            out.writeBoolean(true);
            out.writeInt(this.seed);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            out.writeOptionalString(this.field);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public RandomScoreFunctionBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public RandomScoreFunctionBuilder seed(long seed) {
        this.seed = RandomScoreFunctionBuilder.hash(seed);
        return this;
    }

    public RandomScoreFunctionBuilder seed(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("random_score function: seed must not be null");
        }
        this.seed = seed.hashCode();
        return this;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public RandomScoreFunctionBuilder setField(String field) {
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.seed != null) {
            builder.field("seed", this.seed);
        }
        if (this.field != null) {
            builder.field("field", this.field);
        }
        builder.endObject();
    }

    @Override
    protected boolean doEquals(RandomScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.seed, functionBuilder.seed);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.seed);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) {
        MappedFieldType fieldType;
        int salt = context.index().getName().hashCode() << 10 | context.getShardId();
        if (this.seed == null) {
            return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null);
        }
        if (this.field != null) {
            fieldType = context.getMapperService().fieldType(this.field);
        } else {
            deprecationLogger.deprecatedAndMaybeLog("seed_requires_field", "As of version 7.0 Elasticsearch will require that a [field] parameter is provided when a [seed] is set", new Object[0]);
            fieldType = context.getMapperService().fieldType("_id");
        }
        if (fieldType == null) {
            if (context.getMapperService().documentMapper() == null) {
                return new RandomScoreFunction(RandomScoreFunctionBuilder.hash(context.nowInMillis()), salt, null);
            }
            throw new IllegalArgumentException("Field [" + this.field + "] is not mapped on [" + context.index() + "] and cannot be used as a source of random numbers.");
        }
        int seed = this.seed != null ? this.seed : RandomScoreFunctionBuilder.hash(context.nowInMillis());
        return new RandomScoreFunction(seed, salt, (IndexFieldData<?>)context.getForField(fieldType));
    }

    private static int hash(long value) {
        return Long.hashCode(value);
    }

    public static RandomScoreFunctionBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        RandomScoreFunctionBuilder randomScoreFunctionBuilder = new RandomScoreFunctionBuilder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (parser.numberType() == XContentParser.NumberType.INT) {
                        randomScoreFunctionBuilder.seed(parser.intValue());
                        continue;
                    }
                    if (parser.numberType() == XContentParser.NumberType.LONG) {
                        randomScoreFunctionBuilder.seed(parser.longValue());
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int, long or string, not '" + token.toString() + "'", new Object[0]);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    randomScoreFunctionBuilder.seed(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "random_score seed must be an int/long or string, not '" + token.toString() + "'", new Object[0]);
            }
            if ("field".equals(currentFieldName)) {
                randomScoreFunctionBuilder.setField(parser.text());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "random_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        return randomScoreFunctionBuilder;
    }
}

