/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.reindex;

import java.util.function.Consumer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.CheckedConsumer;

public interface RejectAwareActionListener<T>
extends ActionListener<T> {
    public void onRejection(Exception var1);

    public static <X> RejectAwareActionListener<X> withResponseHandler(final RejectAwareActionListener<?> errorDelegate, final Consumer<X> responseHandler) {
        return new RejectAwareActionListener<X>(){

            @Override
            public void onRejection(Exception e) {
                errorDelegate.onRejection(e);
            }

            @Override
            public void onResponse(X t) {
                responseHandler.accept(t);
            }

            @Override
            public void onFailure(Exception e) {
                errorDelegate.onFailure(e);
            }
        };
    }

    public static <Response> RejectAwareActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure, final Consumer<Exception> onRejection) {
        return new RejectAwareActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }

            @Override
            public void onRejection(Exception e) {
                onRejection.accept(e);
            }
        };
    }
}

