/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.recovery.RecoveryTransportRequest;

final class RecoveryFinalizeRecoveryRequest
extends RecoveryTransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final long globalCheckpoint;
    private final long trimAboveSeqNo;

    RecoveryFinalizeRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.globalCheckpoint = in.readZLong();
        this.trimAboveSeqNo = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readZLong() : -2L;
    }

    RecoveryFinalizeRecoveryRequest(long recoveryId, long requestSeqNo, ShardId shardId, long globalCheckpoint, long trimAboveSeqNo) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.globalCheckpoint = globalCheckpoint;
        this.trimAboveSeqNo = trimAboveSeqNo;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public long trimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeZLong(this.globalCheckpoint);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeZLong(this.trimAboveSeqNo);
        }
    }
}

