/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.monitor.os;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class OsStats
implements Writeable,
ToXContentFragment {
    private final long timestamp;
    private final Cpu cpu;
    private final Mem mem;
    private final Swap swap;
    private final Cgroup cgroup;

    public OsStats(long timestamp, Cpu cpu, Mem mem, Swap swap, Cgroup cgroup) {
        this.timestamp = timestamp;
        this.cpu = Objects.requireNonNull(cpu);
        this.mem = Objects.requireNonNull(mem);
        this.swap = Objects.requireNonNull(swap);
        this.cgroup = cgroup;
    }

    public OsStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.cpu = new Cpu(in);
        this.mem = new Mem(in);
        this.swap = new Swap(in);
        this.cgroup = in.readOptionalWriteable(Cgroup::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        this.cpu.writeTo(out);
        this.mem.writeTo(out);
        this.swap.writeTo(out);
        out.writeOptionalWriteable(this.cgroup);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Swap getSwap() {
        return this.swap;
    }

    public Cgroup getCgroup() {
        return this.cgroup;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("os");
        builder.field("timestamp", this.getTimestamp());
        this.cpu.toXContent(builder, params);
        this.mem.toXContent(builder, params);
        this.swap.toXContent(builder, params);
        if (this.cgroup != null) {
            this.cgroup.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Cpu
    implements Writeable,
    ToXContentFragment {
        private final short percent;
        private final double[] loadAverage;

        public Cpu(short systemCpuPercent, double[] systemLoadAverage) {
            this.percent = systemCpuPercent;
            this.loadAverage = systemLoadAverage;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.loadAverage = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            if (this.loadAverage == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeDoubleArray(this.loadAverage);
            }
        }

        public short getPercent() {
            return this.percent;
        }

        public double[] getLoadAverage() {
            return this.loadAverage;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cpu");
            builder.field("percent", this.getPercent());
            if (this.getLoadAverage() != null && Arrays.stream(this.getLoadAverage()).anyMatch(load -> load != -1.0)) {
                builder.startObject("load_average");
                if (this.getLoadAverage()[0] != -1.0) {
                    builder.field("1m", this.getLoadAverage()[0]);
                }
                if (this.getLoadAverage()[1] != -1.0) {
                    builder.field("5m", this.getLoadAverage()[1]);
                }
                if (this.getLoadAverage()[2] != -1.0) {
                    builder.field("15m", this.getLoadAverage()[2]);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Mem
    implements Writeable,
    ToXContentFragment {
        private static final Logger logger = LogManager.getLogger(Mem.class);
        private final long total;
        private final long free;

        public Mem(long total, long free) {
            assert (total >= 0L) : "expected total memory to be positive, got: " + total;
            assert (free >= 0L) : "expected free memory to be positive, got: " + total;
            this.total = total;
            this.free = free;
        }

        public Mem(StreamInput in) throws IOException {
            this.total = in.readLong();
            assert (this.total >= 0L) : "expected total memory to be positive, got: " + this.total;
            this.free = in.readLong();
            assert (this.free >= 0L) : "expected free memory to be positive, got: " + this.total;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getUsed() {
            if (this.total == 0L) {
                if (this.free > 0L) {
                    logger.debug("cannot compute used memory when total memory is 0 and free memory is " + this.free);
                }
                return new ByteSizeValue(0L);
            }
            return new ByteSizeValue(this.total - this.free);
        }

        public short getUsedPercent() {
            return OsStats.calculatePercentage(this.getUsed().getBytes(), this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public short getFreePercent() {
            return OsStats.calculatePercentage(this.free, this.total);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("mem");
            builder.humanReadableField("total_in_bytes", "total", this.getTotal());
            builder.humanReadableField("free_in_bytes", "free", this.getFree());
            builder.humanReadableField("used_in_bytes", "used", this.getUsed());
            builder.field("free_percent", this.getFreePercent());
            builder.field("used_percent", this.getUsedPercent());
            builder.endObject();
            return builder;
        }
    }

    public static class Swap
    implements Writeable,
    ToXContentFragment {
        private static final Logger logger = LogManager.getLogger(Swap.class);
        private final long total;
        private final long free;

        public Swap(long total, long free) {
            assert (total >= 0L) : "expected total swap to be positive, got: " + total;
            assert (free >= 0L) : "expected free swap to be positive, got: " + total;
            this.total = total;
            this.free = free;
        }

        public Swap(StreamInput in) throws IOException {
            this.total = in.readLong();
            assert (this.total >= 0L) : "expected total swap to be positive, got: " + this.total;
            this.free = in.readLong();
            assert (this.free >= 0L) : "expected free swap to be positive, got: " + this.total;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getUsed() {
            if (this.total == 0L) {
                if (this.free > 0L) {
                    logger.debug("cannot compute used swap when total swap is 0 and free swap is " + this.free);
                }
                return new ByteSizeValue(0L);
            }
            return new ByteSizeValue(this.total - this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("swap");
            builder.humanReadableField("total_in_bytes", "total", this.getTotal());
            builder.humanReadableField("free_in_bytes", "free", this.getFree());
            builder.humanReadableField("used_in_bytes", "used", this.getUsed());
            builder.endObject();
            return builder;
        }
    }

    public static class Cgroup
    implements Writeable,
    ToXContentFragment {
        private final String cpuAcctControlGroup;
        private final long cpuAcctUsageNanos;
        private final String cpuControlGroup;
        private final long cpuCfsPeriodMicros;
        private final long cpuCfsQuotaMicros;
        private final CpuStat cpuStat;
        private final String memoryControlGroup;
        private final String memoryLimitInBytes;
        private final String memoryUsageInBytes;

        public String getCpuAcctControlGroup() {
            return this.cpuAcctControlGroup;
        }

        public long getCpuAcctUsageNanos() {
            return this.cpuAcctUsageNanos;
        }

        public String getCpuControlGroup() {
            return this.cpuControlGroup;
        }

        public long getCpuCfsPeriodMicros() {
            return this.cpuCfsPeriodMicros;
        }

        public long getCpuCfsQuotaMicros() {
            return this.cpuCfsQuotaMicros;
        }

        public CpuStat getCpuStat() {
            return this.cpuStat;
        }

        public String getMemoryControlGroup() {
            return this.memoryControlGroup;
        }

        public String getMemoryLimitInBytes() {
            return this.memoryLimitInBytes;
        }

        public String getMemoryUsageInBytes() {
            return this.memoryUsageInBytes;
        }

        public Cgroup(String cpuAcctControlGroup, long cpuAcctUsageNanos, String cpuControlGroup, long cpuCfsPeriodMicros, long cpuCfsQuotaMicros, CpuStat cpuStat, String memoryControlGroup, String memoryLimitInBytes, String memoryUsageInBytes) {
            this.cpuAcctControlGroup = Objects.requireNonNull(cpuAcctControlGroup);
            this.cpuAcctUsageNanos = cpuAcctUsageNanos;
            this.cpuControlGroup = Objects.requireNonNull(cpuControlGroup);
            this.cpuCfsPeriodMicros = cpuCfsPeriodMicros;
            this.cpuCfsQuotaMicros = cpuCfsQuotaMicros;
            this.cpuStat = Objects.requireNonNull(cpuStat);
            this.memoryControlGroup = memoryControlGroup;
            this.memoryLimitInBytes = memoryLimitInBytes;
            this.memoryUsageInBytes = memoryUsageInBytes;
        }

        Cgroup(StreamInput in) throws IOException {
            this.cpuAcctControlGroup = in.readString();
            this.cpuAcctUsageNanos = in.readLong();
            this.cpuControlGroup = in.readString();
            this.cpuCfsPeriodMicros = in.readLong();
            this.cpuCfsQuotaMicros = in.readLong();
            this.cpuStat = new CpuStat(in);
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.memoryControlGroup = in.readOptionalString();
                this.memoryLimitInBytes = in.readOptionalString();
                this.memoryUsageInBytes = in.readOptionalString();
            } else {
                this.memoryControlGroup = null;
                this.memoryLimitInBytes = null;
                this.memoryUsageInBytes = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.cpuAcctControlGroup);
            out.writeLong(this.cpuAcctUsageNanos);
            out.writeString(this.cpuControlGroup);
            out.writeLong(this.cpuCfsPeriodMicros);
            out.writeLong(this.cpuCfsQuotaMicros);
            this.cpuStat.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeOptionalString(this.memoryControlGroup);
                out.writeOptionalString(this.memoryLimitInBytes);
                out.writeOptionalString(this.memoryUsageInBytes);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cgroup");
            builder.startObject("cpuacct");
            builder.field("control_group", this.cpuAcctControlGroup);
            builder.field("usage_nanos", this.cpuAcctUsageNanos);
            builder.endObject();
            builder.startObject("cpu");
            builder.field("control_group", this.cpuControlGroup);
            builder.field("cfs_period_micros", this.cpuCfsPeriodMicros);
            builder.field("cfs_quota_micros", this.cpuCfsQuotaMicros);
            this.cpuStat.toXContent(builder, params);
            builder.endObject();
            if (this.memoryControlGroup != null) {
                builder.startObject("memory");
                builder.field("control_group", this.memoryControlGroup);
                if (this.memoryLimitInBytes != null) {
                    builder.field("limit_in_bytes", this.memoryLimitInBytes);
                }
                if (this.memoryUsageInBytes != null) {
                    builder.field("usage_in_bytes", this.memoryUsageInBytes);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public static class CpuStat
        implements Writeable,
        ToXContentFragment {
            private final long numberOfElapsedPeriods;
            private final long numberOfTimesThrottled;
            private final long timeThrottledNanos;

            public long getNumberOfElapsedPeriods() {
                return this.numberOfElapsedPeriods;
            }

            public long getNumberOfTimesThrottled() {
                return this.numberOfTimesThrottled;
            }

            public long getTimeThrottledNanos() {
                return this.timeThrottledNanos;
            }

            public CpuStat(long numberOfElapsedPeriods, long numberOfTimesThrottled, long timeThrottledNanos) {
                this.numberOfElapsedPeriods = numberOfElapsedPeriods;
                this.numberOfTimesThrottled = numberOfTimesThrottled;
                this.timeThrottledNanos = timeThrottledNanos;
            }

            CpuStat(StreamInput in) throws IOException {
                this.numberOfElapsedPeriods = in.readLong();
                this.numberOfTimesThrottled = in.readLong();
                this.timeThrottledNanos = in.readLong();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeLong(this.numberOfElapsedPeriods);
                out.writeLong(this.numberOfTimesThrottled);
                out.writeLong(this.timeThrottledNanos);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("stat");
                builder.field("number_of_elapsed_periods", this.numberOfElapsedPeriods);
                builder.field("number_of_times_throttled", this.numberOfTimesThrottled);
                builder.field("time_throttled_nanos", this.timeThrottledNanos);
                builder.endObject();
                return builder;
            }
        }
    }

    static final class Fields {
        static final String OS = "os";
        static final String TIMESTAMP = "timestamp";
        static final String CPU = "cpu";
        static final String PERCENT = "percent";
        static final String LOAD_AVERAGE = "load_average";
        static final String LOAD_AVERAGE_1M = "1m";
        static final String LOAD_AVERAGE_5M = "5m";
        static final String LOAD_AVERAGE_15M = "15m";
        static final String MEM = "mem";
        static final String SWAP = "swap";
        static final String FREE = "free";
        static final String FREE_IN_BYTES = "free_in_bytes";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String FREE_PERCENT = "free_percent";
        static final String USED_PERCENT = "used_percent";

        Fields() {
        }
    }
}

