/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;

public class RestCreateSnapshotAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.PUT, "/_snapshot/{repository}/{snapshot}"), new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/{snapshot}")));
    }

    @Override
    public String getName() {
        return "create_snapshot_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateSnapshotRequest createSnapshotRequest = Requests.createSnapshotRequest(request.param("repository"), request.param("snapshot"));
        request.applyContentParser(p -> createSnapshotRequest.source(p.mapOrdered()));
        createSnapshotRequest.masterNodeTimeout(request.paramAsTime("master_timeout", createSnapshotRequest.masterNodeTimeout()));
        createSnapshotRequest.waitForCompletion(request.paramAsBoolean("wait_for_completion", false));
        return channel -> client.admin().cluster().createSnapshot(createSnapshotRequest, new RestToXContentListener<CreateSnapshotResponse>((RestChannel)channel));
    }
}

