/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.TextField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup.SourceLookup;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final QueryShardContext context;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(MappedFieldType fieldType, QueryShardContext context, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(fieldType, preTags, postTags, boundaryScanner);
        this.context = context;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SourceLookup sourceLookup = this.context.lookup().source();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)reader.getContext(), docId);
        List<Object> values = sourceLookup.extractRawValues(this.fieldType.name());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }
}

