/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.shaded.elasticsearch7.org.apache.http.client.config.RequestConfig;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.MultiSearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.MultiSearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RestHighLevelClient;
import org.graylog.storage.elasticsearch7.ParsedElasticsearchException;
import org.graylog.storage.elasticsearch7.ThrowingBiFunction;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.InvalidWriteTargetException;
import org.graylog2.indexer.MasterNotDiscoveredException;

public class ElasticsearchClient {
    private static final Pattern invalidWriteTarget = Pattern.compile("no write index is defined for alias \\[(?<target>[\\w_]+)\\]");
    private final RestHighLevelClient client;
    private final boolean compressionEnabled;

    @Inject
    public ElasticsearchClient(RestHighLevelClient client, @Named(value="elasticsearch_compression_enabled") boolean compressionEnabled) {
        this.client = client;
        this.compressionEnabled = compressionEnabled;
    }

    public SearchResponse search(SearchRequest searchRequest, String errorMessage) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest().add(searchRequest);
        MultiSearchResponse result = this.execute((c, requestOptions) -> c.msearch(multiSearchRequest, (RequestOptions)requestOptions), errorMessage);
        return this.firstResponseFrom(result, errorMessage);
    }

    public SearchResponse singleSearch(SearchRequest searchRequest, String errorMessage) {
        return this.execute((c, requestOptions) -> c.search(searchRequest, (RequestOptions)requestOptions), errorMessage);
    }

    public List<MultiSearchResponse.Item> msearch(List<SearchRequest> searchRequests, String errorMessage) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        searchRequests.forEach(multiSearchRequest::add);
        MultiSearchResponse result = this.execute((c, requestOptions) -> c.msearch(multiSearchRequest, (RequestOptions)requestOptions), errorMessage);
        return Streams.stream((Iterable)result).collect(Collectors.toList());
    }

    private SearchResponse firstResponseFrom(MultiSearchResponse result, String errorMessage) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0);
        Preconditions.checkArgument((result.getResponses().length == 1 ? 1 : 0) != 0);
        MultiSearchResponse.Item firstResponse = result.getResponses()[0];
        if (firstResponse.getResponse() == null) {
            throw this.exceptionFrom(firstResponse.getFailure(), errorMessage);
        }
        return firstResponse.getResponse();
    }

    public <R> R execute(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn) {
        return this.execute(fn, "An error occurred: ");
    }

    public <R> R execute(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn, String errorMessage) {
        try {
            return fn.apply(this.client, this.requestOptions());
        }
        catch (Exception e) {
            throw this.exceptionFrom(e, errorMessage);
        }
    }

    public <R> R executeWithIOException(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn, String errorMessage) throws IOException {
        try {
            return fn.apply(this.client, this.requestOptions());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.exceptionFrom(e, errorMessage);
        }
    }

    private RequestOptions requestOptions() {
        return this.compressionEnabled ? RequestOptions.DEFAULT.toBuilder().addHeader("Accept-Encoding", "gzip").addHeader("Content-type", "application/json").build() : RequestOptions.DEFAULT;
    }

    private ElasticsearchException exceptionFrom(Exception e, String errorMessage) {
        if (e instanceof ElasticsearchException) {
            Matcher matcher;
            ElasticsearchException elasticsearchException = (ElasticsearchException)e;
            if (this.isIndexNotFoundException(elasticsearchException)) {
                throw IndexNotFoundException.create((String)(errorMessage + elasticsearchException.getResourceId()), (String)elasticsearchException.getIndex().getName());
            }
            if (this.isMasterNotDiscoveredException(elasticsearchException)) {
                throw new MasterNotDiscoveredException();
            }
            if (this.isInvalidWriteTargetException(elasticsearchException) && (matcher = invalidWriteTarget.matcher(elasticsearchException.getMessage())).find()) {
                String target = matcher.group("target");
                throw InvalidWriteTargetException.create((String)target);
            }
        }
        return new ElasticsearchException(errorMessage, (Throwable)e, new Object[0]);
    }

    private boolean isInvalidWriteTargetException(ElasticsearchException elasticsearchException) {
        try {
            ParsedElasticsearchException parsedException = ParsedElasticsearchException.from(elasticsearchException.getMessage());
            return parsedException.reason().startsWith("no write index is defined for alias");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isMasterNotDiscoveredException(ElasticsearchException elasticsearchException) {
        try {
            ParsedElasticsearchException parsedException = ParsedElasticsearchException.from(elasticsearchException.getMessage());
            return parsedException.type().equals("master_not_discovered_exception") || parsedException.type().equals("cluster_block_exception") && parsedException.reason().contains("no master");
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isIndexNotFoundException(ElasticsearchException e) {
        return e.getMessage().contains("index_not_found_exception");
    }

    public static RequestOptions withTimeout(RequestOptions requestOptions, Duration timeout) {
        RequestConfig.Builder requestConfigBuilder = requestOptions == null || requestOptions.getRequestConfig() == null ? RequestConfig.custom() : RequestConfig.copy(requestOptions.getRequestConfig());
        RequestConfig requestConfigWithTimeout = requestConfigBuilder.setSocketTimeout(Math.toIntExact(timeout.toMilliseconds())).build();
        RequestOptions.Builder requestOptionsBuilder = requestOptions == null ? RequestOptions.DEFAULT.toBuilder() : requestOptions.toBuilder();
        return requestOptionsBuilder.setRequestConfig(requestConfigWithTimeout).build();
    }
}

