/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.mapping.FieldMappingApi;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePollerAdapter;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFieldTypePollerAdapterES7
implements IndexFieldTypePollerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFieldTypePollerAdapterES7.class);
    private final ElasticsearchClient client;
    private final FieldMappingApi fieldMappingApi;

    @Inject
    public IndexFieldTypePollerAdapterES7(ElasticsearchClient client, FieldMappingApi fieldMappingApi) {
        this.client = client;
        this.fieldMappingApi = fieldMappingApi;
    }

    public Optional<Set<FieldTypeDTO>> pollIndex(String indexName, Timer pollTimer) {
        Map<String, String> fieldTypes;
        try (Timer.Context ignored = pollTimer.time();){
            fieldTypes = this.fieldMappingApi.fieldTypes(indexName);
        }
        catch (IndexNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Couldn't get mapping for index <{}>", (Object)indexName, (Object)e);
            } else {
                LOG.error("Couldn't get mapping for index <{}>: {}", (Object)indexName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            return Optional.empty();
        }
        return Optional.of(fieldTypes.entrySet().stream().filter(field -> !((String)field.getValue()).isEmpty()).map(field -> FieldTypeDTO.create((String)((String)field.getKey()), (String)((String)field.getValue()))).collect(Collectors.toSet()));
    }
}

