/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.bulk.BulkItemResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.bulk.BulkRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.bulk.BulkResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.get.GetRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.get.GetResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.index.IndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.AnalyzeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.indices.AnalyzeResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestStatus;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.ParsedElasticsearchException;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.messages.ChunkedBulkIndexer;
import org.graylog2.indexer.messages.DocumentNotFoundException;
import org.graylog2.indexer.messages.Indexable;
import org.graylog2.indexer.messages.IndexingRequest;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.indexer.messages.MessagesAdapter;
import org.graylog2.indexer.results.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesAdapterES7
implements MessagesAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesAdapterES7.class);
    static final String INDEX_BLOCK_ERROR = "cluster_block_exception";
    static final String MAPPER_PARSING_EXCEPTION = "mapper_parsing_exception";
    static final String INDEX_BLOCK_REASON = "blocked by: [TOO_MANY_REQUESTS/12/index read-only / allow delete (api)";
    static final String FLOOD_STAGE_WATERMARK = "blocked by: [TOO_MANY_REQUESTS/12/disk usage exceeded flood-stage watermark";
    static final String UNAVAILABLE_SHARDS_EXCEPTION = "unavailable_shards_exception";
    static final String PRIMARY_SHARD_NOT_ACTIVE_REASON = "primary shard is not active";
    static final String ILLEGAL_ARGUMENT_EXCEPTION = "illegal_argument_exception";
    static final String NO_WRITE_INDEX_DEFINED_FOR_ALIAS = "no write index is defined for alias";
    private final ElasticsearchClient client;
    private final Meter invalidTimestampMeter;
    private final ChunkedBulkIndexer chunkedBulkIndexer;
    private final ObjectMapper objectMapper;

    @Inject
    public MessagesAdapterES7(ElasticsearchClient elasticsearchClient, MetricRegistry metricRegistry, ChunkedBulkIndexer chunkedBulkIndexer, ObjectMapper objectMapper) {
        this.client = elasticsearchClient;
        this.invalidTimestampMeter = metricRegistry.meter(MetricRegistry.name(Messages.class, (String[])new String[]{"invalid-timestamps"}));
        this.chunkedBulkIndexer = chunkedBulkIndexer;
        this.objectMapper = objectMapper;
    }

    public ResultMessage get(String messageId, String index) throws DocumentNotFoundException {
        GetRequest getRequest = new GetRequest(index, messageId);
        GetResponse result = this.client.execute((c, requestOptions) -> c.get(getRequest, (RequestOptions)requestOptions));
        if (!result.isExists()) {
            throw new DocumentNotFoundException(index, messageId);
        }
        return ResultMessage.parseFromSource((String)messageId, (String)index, result.getSource());
    }

    public List<String> analyze(String toAnalyze, String index, String analyzer) {
        AnalyzeRequest analyzeRequest = AnalyzeRequest.withIndexAnalyzer(index, analyzer, toAnalyze);
        AnalyzeResponse result = this.client.execute((c, requestOptions) -> c.indices().analyze(analyzeRequest, (RequestOptions)requestOptions));
        return result.getTokens().stream().map(AnalyzeResponse.AnalyzeToken::getTerm).collect(Collectors.toList());
    }

    public List<Messages.IndexingError> bulkIndex(List<IndexingRequest> messageList) throws IOException {
        return this.chunkedBulkIndexer.index(messageList, this::bulkIndexChunked);
    }

    private List<Messages.IndexingError> bulkIndexChunked(ChunkedBulkIndexer.Chunk command) throws ChunkedBulkIndexer.EntityTooLargeException {
        List messageList = command.requests;
        int offset = command.offset;
        int chunkSize = command.size;
        if (messageList.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable chunks = Iterables.partition(messageList.subList(offset, messageList.size()), (int)chunkSize);
        int chunkCount = 1;
        int indexedSuccessfully = 0;
        ArrayList<Messages.IndexingError> indexFailures = new ArrayList<Messages.IndexingError>();
        for (List chunk : chunks) {
            BulkResponse result = this.runBulkRequest(indexedSuccessfully, chunk);
            indexedSuccessfully += chunk.size();
            List<BulkItemResponse> failures = this.extractFailures(result);
            indexFailures.addAll(this.indexingErrorsFrom(failures, messageList));
            this.logDebugInfo(messageList, offset, chunkSize, chunkCount, result, failures);
            this.logFailures(result, failures.size());
            ++chunkCount;
        }
        return indexFailures;
    }

    private List<BulkItemResponse> extractFailures(BulkResponse result) {
        return Arrays.stream(result.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toList());
    }

    private void logFailures(BulkResponse result, int failureCount) {
        if (failureCount > 0) {
            LOG.error("Failed to index [{}] messages. Please check the index error log in your web interface for the reason. Error: {}", (Object)failureCount, (Object)result.buildFailureMessage());
        }
    }

    private void logDebugInfo(List<IndexingRequest> messageList, int offset, int chunkSize, int chunkCount, BulkResponse result, List<BulkItemResponse> failures) {
        if (LOG.isDebugEnabled()) {
            String chunkInfo = "";
            if (chunkSize != messageList.size()) {
                chunkInfo = String.format(Locale.ROOT, " (chunk %d/%d offset %d)", chunkCount, (int)Math.ceil((double)messageList.size() / (double)chunkSize), offset);
            }
            LOG.debug("Index: Bulk indexed {} messages{}, failures: {}", new Object[]{result.getItems().length, chunkInfo, failures.size()});
        }
    }

    private BulkResponse runBulkRequest(int indexedSuccessfully, List<IndexingRequest> chunk) throws ChunkedBulkIndexer.EntityTooLargeException {
        BulkResponse result;
        BulkRequest bulkRequest = this.createBulkRequest(chunk);
        try {
            result = this.client.execute((c, requestOptions) -> c.bulk(bulkRequest, (RequestOptions)requestOptions));
        }
        catch (org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException e) {
            for (org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException cause : e.guessRootCauses()) {
                if (!cause.status().equals((Object)RestStatus.REQUEST_ENTITY_TOO_LARGE)) continue;
                throw new ChunkedBulkIndexer.EntityTooLargeException(indexedSuccessfully, this.indexingErrorsFrom(chunk));
            }
            throw new ElasticsearchException((Throwable)e);
        }
        return result;
    }

    private BulkRequest createBulkRequest(List<IndexingRequest> chunk) {
        BulkRequest bulkRequest = new BulkRequest();
        chunk.forEach(request -> bulkRequest.add(this.indexRequestFrom((IndexingRequest)request)));
        return bulkRequest;
    }

    private List<Messages.IndexingError> indexingErrorsFrom(List<IndexingRequest> messageList) {
        return messageList.stream().map(this::indexingErrorFrom).collect(Collectors.toList());
    }

    private Messages.IndexingError indexingErrorFrom(IndexingRequest indexingRequest) {
        return Messages.IndexingError.create((Indexable)indexingRequest.message(), (String)indexingRequest.indexSet().getWriteIndexAlias());
    }

    private List<Messages.IndexingError> indexingErrorsFrom(List<BulkItemResponse> failedItems, List<IndexingRequest> messageList) {
        if (failedItems.isEmpty()) {
            return Collections.emptyList();
        }
        Map messageMap = messageList.stream().map(IndexingRequest::message).distinct().collect(Collectors.toMap(Indexable::getId, Function.identity()));
        return failedItems.stream().map(item -> {
            Indexable message = (Indexable)messageMap.get(item.getId());
            return this.indexingErrorFromResponse((BulkItemResponse)item, message);
        }).collect(Collectors.toList());
    }

    private Messages.IndexingError indexingErrorFromResponse(BulkItemResponse item, Indexable message) {
        return Messages.IndexingError.create((Indexable)message, (String)item.getIndex(), (Messages.IndexingError.ErrorType)this.errorTypeFromResponse(item), (String)item.getFailureMessage());
    }

    private Messages.IndexingError.ErrorType errorTypeFromResponse(BulkItemResponse item) {
        ParsedElasticsearchException exception = ParsedElasticsearchException.from(item.getFailureMessage());
        switch (exception.type()) {
            case "mapper_parsing_exception": {
                return Messages.IndexingError.ErrorType.MappingError;
            }
            case "cluster_block_exception": {
                if (exception.reason().contains(INDEX_BLOCK_REASON) || exception.reason().contains(FLOOD_STAGE_WATERMARK)) {
                    return Messages.IndexingError.ErrorType.IndexBlocked;
                }
            }
            case "unavailable_shards_exception": {
                if (exception.reason().contains(PRIMARY_SHARD_NOT_ACTIVE_REASON)) {
                    return Messages.IndexingError.ErrorType.IndexBlocked;
                }
            }
            case "illegal_argument_exception": {
                if (!exception.reason().contains(NO_WRITE_INDEX_DEFINED_FOR_ALIAS)) break;
                return Messages.IndexingError.ErrorType.IndexBlocked;
            }
        }
        return Messages.IndexingError.ErrorType.Unknown;
    }

    private IndexRequest indexRequestFrom(IndexingRequest request) {
        byte[] body;
        try {
            body = this.objectMapper.writeValueAsBytes((Object)request.message().toElasticSearchObject(this.objectMapper, this.invalidTimestampMeter));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return new IndexRequest(request.indexSet().getWriteIndexAlias()).id(request.message().getId()).source(body, XContentType.JSON);
    }
}

