/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Request;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Response;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;

public class FieldMappingApi {
    private final ObjectMapper objectMapper;
    private final ElasticsearchClient client;

    @Inject
    public FieldMappingApi(ObjectMapper objectMapper, ElasticsearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public Map<String, String> fieldTypes(String index) {
        JsonNode result = this.client.execute((c, requestOptions) -> {
            Response response = c.getLowLevelClient().performRequest(this.request(index));
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, "Unable to retrieve field types of index " + index);
        JsonNode fields = result.path(index).path("mappings").path("properties");
        return Streams.stream((Iterator)fields.fields()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonNode)entry.getValue()).path("type").asText()));
    }

    private Request request(String index) {
        return new Request("GET", "/" + index + "/_mapping");
    }
}

